+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-08-03T12:50:00+01:00"
lastmod = "2016-08-04T10:33:00+01:00"
preamble = "Google reviews: why do people leave them? They give 1-5 star ratings, and leave a little comment about their good, bad, or so-so time at restaurants, concert venues, museums, and any other site on Earth that Google knows about. The premise seems to be entice (or warn) others about these places of business, since apparently, everyone's an expert.\n\nSo, are Google reviews unbiased? Horribly biased? Have the bad ones been weeded out by the company in question, and have the good ones been planted by pseudonyms with ulterior motives? For now, the question is moot. We got curious about what the anonymous (?) Internet had to say about some of the world's biggest opera houses.\n\nNote: a general [sic] applies throughout the piece, since we think spelling and grammar issues are part of the Google review experience."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470235093333/2016-08-03---Opera-Houses.jpg.jpg"
publishDate = "2016-08-04T10:11:00+01:00"
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/houston-grand-opera.md","scene/companies/san-francisco-opera.md","scene/companies/english-national-opera.md","scene/companies/royal-opera-house.md","scene/companies/canadian-opera-company.md"]
short_description = "It seems that $7 sausage/beer deal is appealing, if a distant goal: &quot;Only complaint is that the concession stands are too far away to make it there and back comfortably during intermission.&quot; The only other complaint? The length of Les Troyens: &quot;It was much too long at 5 hours with two 30-minute intermission breaks.&quot;"
slug = "6-opera-houses-googlereviewed"
title = "6 opera houses, Google-reviewed"
+++

## Lincoln Center

[Google users](https://www.google.co.uk/search?q=the+metropolitan+opera&oq=the+metropolitan+opera&aqs=chrome..69i57j0l5.2202j0j7&sourceid=chrome&ie=UTF-8#lrd=0x89c2585e73b059c1:0x7e81b5a4eefe288b,1,) who have been to [The Metropolitan Opera](/scene/companies/the-metropolitan-opera/) are wowed by the **"breathtaking"** interior of the opera house: **"The whole place feels opulent and impressive."** There's admiration for the Chagall paintings in the lobby, and **"their trademark starburst Swarovski crystal chandeliers are so beautiful."** A few users did notice the onstage action, too: **"World class shows, cool architecture and art."**

A few Met visitors struggled with the sight lines in the **"really big opera house with challenging views. Opera glasses were made for this place. If you're not in the orchestra you are far away."** Another hopeful ballet fan had one letdown, and that was to **"very unknowingly have bought box seats that could only see 10% of what was on stage which for a ballet really sucked."**

Google reviewers offered a few words of advice to potential newcomers: **"Don't be late. They start right on time."** Also, some conflicting information about proper opera attire: one reviewer urged opera-goers, **"don't be intimidated and think you need to wear a tux. Come as you are and enjoy!"** That advice is likely nails on a chalkboard for the reviewer whose **"only complaint is that some patrons have taken to showing up in shorts and t-shirts."**

Interestingly, there were more than a handful of complaints about rude staff at the Met. **"Customer Service is BAD! It is not simply unprofessional, but rude. Be very careful before ordering tickets, because if you will simply find a better seat they will refuse to exchange them."** Similarly, **"fancy building and gorgeous chandeliers don't make up for a rude, surly, horrid staff."** Also, one reviewer is totally over paper tickets: **"No mobile ticket scanning???"**

We like this savvy review as a good way to sum up a Met experience: **"I do wish they were more interesting/braver in their programming, but it is absolutely worth your visit and particularly so if you've never seen an opera before!"**


## War Memorial Opera House

Like the Met, [reviewers](https://www.google.co.uk/search?q=san+francisco+opera&oq=san+francisco+opera&aqs=chrome.0.0l6.1628j0j7&sourceid=chrome&ie=UTF-8#lrd=0x808580990e4645ed:0xed007ec6a060de06,1,) love the **"beautiful old building"** that is home to [San Francisco Opera](/scene/companies/san-francisco-opera/). **"Beautiful, historic, right next to the library, easily accessible by public transportation. We saw a performance of ballet "Cinderella" and everyone loved it (and I'm not a ballet fan)."** The reviews for War Memorial are generally pretty good, with kudos for the work onstage (**"Saw Carmen here and it was a wonderful experience"**) and elsewhere (**"Before the show and during intermission, the sausage sandwich and beer for $7 at the pop-up beer garden on the outdoor Loggia terrace looked enticing but the line was very long."**).

There are a few comments about seating, some of which **"feels a bit tight (I wouldn't want to crawl over anyone to make a bathroom visit), yet there was enough leg space for me to be comfortable."** Still, the price is right no matter where you sit: **"I love this opera house. Even the farthest back seats are exceptional! Hint: students get discounts!"**

It seems that $7 sausage/beer deal is appealing, if a distant goal: **"Only complaint is that the concession stands are too far away to make it there and back comfortably during intermission."** The only other complaint? The length of *Les Troyens*: **"It was much too long at 5 hours with two 30-minute intermission breaks."**

## Wortham Theater Center

**"Very nice.  The bathrooms are small,"** said one [reviewer](https://www.google.co.uk/search?q=houston+grand+opera&oq=houston+grand+opera&aqs=chrome..69i57j0l5.1865j0j7&sourceid=chrome&ie=UTF-8#lrd=0x8640bf30f924dcd1:0xdb81734c533da997,1,) of [Houston Grand Opera](/scene/companies/houston-grand-opera/)'s home base. **"It's so easy to forget how much better music is live. Excellent."**

Yet not everybody enjoys Houston's production line-up: **"Some of the adaptions they put on are pretty terrible, especially when they are 'modern'. After a particularly terrible Wagner I wanted my money back!"** Sounds like a real-deal Wagner fan, this one. Yet one reviewer had a fab time at [HGO's Opening Nights for Young Professionals](http://www.houstongrandopera.org/scheduletickets/subscribe/ON/), noting that the evening was **"tons of fun. pretend to be fancy and actually learn something about opera in the meantime. now a huge wagner fan. also, free drinks at intermission!"**

With mostly positive reviews of 4 stars and up, Houston Grand is a **"good place if u like opera"**.

## Royal Opera House

The [reviews](https://www.google.co.uk/search?q=royal+opera+house&oq=royal+opera+house&aqs=chrome..69i57j69i60j0l4.2415j0j7&sourceid=chrome&ie=UTF-8#lrd=0x487604cb87a023c9:0x582a37df62d31c08,1,) for the [Royal Opera House](/scene/companies/royal-opera-house/) at Covent Garden, like for the Met, were full of gushing over the beauty of the historical theatre. **"One word: wow,"** and, **"Sensational piece of international culture."** Another, more enthusiastic reviewer said, **"FANTABULOUS!!! BEAUTIFUL!! 10 stars!!"** Yet unlike the Met, visibility is a no-brainer no matter where listeners sit. **"The cheap seats may be high up, but you'll still have a great view of wonderful productions!"** Plus, the ROH staff seemed to be friendlier than their New York counterparts: **"Being the Opera I was expecting a bar full of snobbery, quite the opposite in reality. Lovely smiley staff, ready to help during a very busy time."**

Despite the **"smallish orchestra"** that seemed to irk one opera-goer, the significance of a night out at ROH wasn't lost on its visitors. **"Beautiful historic venue - don't forget to make an effort with your outfit as people tend to dress for the occasion!"**

Yet some folks just can't be pleased. **"I expected more from the ROYAL Opera House  but it was fine"**. 

Fine.

## Four Seasons Centre

Canadian [opera fans](https://www.google.co.uk/search?q=four+seasons+centre+toronto&oq=four+seasons+centre+toronto&aqs=chrome..69i57j0l5.2487j0j9&sourceid=chrome&ie=UTF-8#lrd=0x882b34cddfdbc1e1:0x6aeb453220fd1765,1,) who visit the home of the [Canadian Opera Company](/scene/companies/canadian-opera-company/) are treated to a top-notch night out: **"For those who love opera, this is the best place in Toronto you can go.**" The unique architecture of the Torontonian house **"looks beautiful on the outside and is amazing inside. Recommend checking it out and watching a show."** Some sage advice from an enthusiastic visitor: **"What a beautiful venue! If you're ever invited to an event here, say yes! Very clean and well maintained."**

Sight lines are a non-issue here, (**"There isn't a bad seat in the house"**), and even the cheap seats make for a great show: **"Sat on ring 5 for Carmen loved every minute of it!"**

The famed Four Seasons acoustics got mixed reviews, ranging from **"A tight, brittle accoustical box..."** to **"Wonderful shows, excellent acoustics! A true gem!"** There's even a shout-out to the COC's [Free Concert Series](http://www.coc.ca/PerformancesAndTickets/FreeConcertSeries.aspx) in the Richard Bradshaw Amphitheatre: **"Beautiful! Great free shows during the weekday :)"**

One reviewer had a slightly uncomfortable time at the COC, it seems: **"Pure acoustic, air conditioning need improvement, smell of toilets on balconies."** Though **"the staff were very helpful,"** another visitor got impatient waiting for their intermission bevvies: **"poor drinks service, slow and clunky to pre-order interval drinks."**

Periodic slow bar service aside, most reviewers echoed the sentiment, **"In a word, Magnificent."**

## Civic Opera House

**"Whatever brand the cookies were that were sold at the concession stands was phenomenal. Grab one during intermission."** 

[Nothing but love](https://www.google.co.uk/search?q=lyric+opera+chicago&oq=lyric+opera+&aqs=chrome.1.69i57j0l5.2990j0j7&sourceid=chrome&ie=UTF-8#lrd=0x880e2cb8925e8fe5:0x1a7ed21598ee5c97,1,) for the whole experience at [Lyric Opera of Chicago](/scene/companies/lyric-opera-of-chicago/). Reviews like **"It was a great experience! Great atmosphere and acoustics!"** and **"there isn't one bad thing I can say about this place."** are an impressive feat for a house in the middle of the opinionated United States of America.

The onstage spectacles are **"powerful, moving, magical, enlightening, grand, superb performances!!!!!"**, and the building itself is **"ASTOUNDING!  The architecture was only matched by the show!"** Plus, there's strong admiration for the fashion sense of Chicago's opera lovers: **"Do you miss dressing up to go to the theater? If so, go here. People actually still look like they're going to see a show, and not a football game."**

>What are your favourite venues for taking in opera? Let us know in the comments below!
