+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-02-27T12:22:00+00:00"
lastmod = "2017-02-28T11:25:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1488280027751/2017-02-28---Square-VSF17_Samples_James-Berry_023.jpg.jpg"
primary_image_credit = "The Various Stages Festival, presented by Mahogany Opera Group, 2017. Photo by James Berry."
publishDate = "2017-02-28T11:25:00+00:00"
related_articles = ["articles/in-review-tapestry-briefs-booster-shots.md","articles/he-saidshe-said-songbook-vi.md","articles/uncomfortable-premieres-the-mother.md"]
related_companies = ["scene/companies/mahogany-opera-group.md"]
short_description = "What was fascinating was hearing the questions that the creators of the works posed to the listeners. They offered their own inspiration for artistic choices, wondering if their intended affect made its way to the audience. Perhaps it&#039;s a good test to run works-in-process by an audience of industry folks and critics; if an opera can impress them, they&#039;re likely in good shape for general audiences."
slug = "6-new-works-presented-at-various-stages-2017"
title = "6 new works presented at Various Stages 2017"
+++

[Mahogany Opera Group](/scene/companies/mahogany-opera-group/) has presented the third iteration of its [Various Stages festival](https://www.mahoganyoperagroup.co.uk/productions/various-stages-festival-2017/), which showcases works-in-development in an intimate setting designed to encourage feedback between the creators and the audience.

This year, MOG put out an open call for submissions from across the globe, and they decided upon six worthy selections, to be presented over an afternoon at London's Institute of Contemporary Arts. The Festival, which MOG Artistic Director [Frederic Wake-Walker](/talking-with-directors-frederic-wake-walker/) says is "borne out of a desire or need to create our own work", is indicative of the company's larger mandate to challenge the expectations and boundaries of opera. 

Likely on par with the rest of the world, new opera in the UK suffers a dearth of research and development opportunity. It's significant that a single company like MOG has such a broad reach and an industrious pace with fostering new works, from operas for young people like [*The Rattler*](/delightfully-creepy-mahogany-opera-groups-the-rattler/) and [*Snappy Operas*](/great-ideas-snappy-operas/), and truly novel projects like *Folie à Deux* and *Mozart vs. Machine*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1488280691011/2017-02-28---VSF17_Samples_James-Berry_014.jpg.jpg)
<figcaption>*The Finding*, by Richard Melonian and Zoë Palmer, presented at the Various Stages Festival, 2017. Photo by James Berry.</figcaption>
</figure>

The six selections for the 2017 Various Stages Festival told stories about motherhood, real-life hoarders, domestic violence, and human trafficking, drawing on international influences from Vietnamese water puppetry to the folklore of the American West. There was plenty of novelty in the excerpts, from the chorus of mothers and babies (which is exactly what it sounds like) in Richard Melonian and Zoë Palmer's [*The Finding*](https://www.mahoganyoperagroup.co.uk/productions/various-stages-festival-2017/the-finding/) to the electro-acoustic cacophony that is Oliver Brignall and Poppy Burton-Morgan's [*Palace of Junk*](https://www.mahoganyoperagroup.co.uk/productions/various-stages-festival-2017/palace-of-junk/). 

A highlight of ours was [*In a Grove*](https://www.mahoganyoperagroup.co.uk/productions/various-stages-festival-2017/in-a-grove/), by Christopher Cerrone and Stephanie Fleischmann, which found a wise balance of electronic and acoustic sounds, and erred on the side of simple storytelling to pique our interest. 

Following each work's presentation, about 15-20 minutes were allotted for feedback. It's almost a risky move, to fill a small theatre with the kind of people who would take 6 hours out of their Friday to see opera-in-development. Listeners pointed out practical details like balancing electronic and acoustic sounds, and whether or not the text was audible and comprehensible; they also offered their own accounts of how they experienced various details in the work. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1488280787974/2017-02-28---VSF17_Samples_James-Berry_040.jpg.jpg)
<figcaption>*In a Grove*, by Christopher Cerrone and Stephanie Fleischmann, presented at the Various Stages Festival, 2017. Photo by James Berry.</figcaption>
</figure>

Less useful feedback came in the details of the "production", despite the workshop environment and obvious simplistic presentation; it's always a little irksome, if not amusing, to hear the kind of feedback that seems to come from a need to say *something*, rather than helpful information that the creators don't already know. 

What was fascinating was hearing the questions that the creators of the works posed to the listeners. They offered their own inspiration for artistic choices, wondering if their intended affect made its way to the audience. Perhaps it's a good test to run works-in-process by an audience of industry folks and critics; if an opera can impress them, they're likely in good shape for general audiences.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1488280848194/2017-02-28---VSF17_Samples_James-Berry_026.jpg.jpg)
<figcaption>*Palace of Junk*, by Oliver Brignall and Poppy Burton-Morgan, presented at the Various Stages Festival, 2017. Photo by James Berry.</figcaption>
</figure>

As the composers and librettists are well aware, now comes the tricky next step of bridging the gap between a workshop presentation and a proper production of these new works. The pieces are all extroardinarily novel, with a few that we're eager to see as a full-length work. Mahogany itself is a valuable champion of new opera, and one always hopes that showcases like the Various Stages Festival don't happen in a vacuum.
