+++
author = ["authors/kristen-seikaly.md"]
categories = "How-to"
date = "2015-06-04T12:45:00-04:00"
lastmod = "2017-06-01T10:54:00-04:00"
preamble = "This is a cross-post from mezzo-soprano Kristen Seikaly's fantastic [blog](http://www.kristenseikaly.com/blog/). Read the original post [here](http://www.kristenseikaly.com/6-creative-ways-to-learn-a-language-affordably/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496328025434/2017-06-01---Language.jpg.jpg"
publishDate = "2015-06-05T08:34:00-04:00"
related_articles = ["articles/kristen-seikaly-on-how-to-learn-a-role.md","articles/lost-in-translation.md","articles/native-speakers-their-operatic-advantage.md","articles/4-steps-to-taking-fixing-notes.md","articles/schmopera-is-three.md"]
related_people = ["scene/people/kristen-seikaly.md"]
short_description = "As classical singers, we constantly are looking for creative ways to learn a language quickly and affordably. Languages are important to our craft: we sing in different languages, we work in different countries, and our colleagues speak different languages. Yet we’re often not in another country long enough to learn the language by exposure alone."
slug = "6-learn-language"
title = "6 creative &amp; affordable ways to learn a language "
+++

As classical singers, we constantly are looking for creative ways to learn a language quickly and affordably. Languages are important to our craft: we sing in different languages, we work in different countries, and our colleagues speak different languages. Yet we’re often not in another country long enough to learn the language by exposure alone. Therefore, we need to add language learning to the long list of skills we must continually develop.

For some reason, many of us wish to cut corners with this skill. We’re impatient to just know the language already. Yet learning a language (just like any other skill) requires time, patience, and diligence to master. Fortunately, learning a language does not have to be expensive, as long as you’re willing to discipline yourself and get a little creative. To get you inspired, I have created a list of creative ways to learn a language, for singers and non-singers alike.

*Please note that when I use the term “target language” in this post, I am referring to the language you are studying. For example, if you are an English speaker working towards learning Italian, your “target language” would therefore be Italian.

### 1. Watch cartoons and other kids’ programming

The use of language in cartoons is often simple, visual, and indicative of how natives speak the language. Cartoons in different languages are generally available on YouTube or through a simple Google search. Oftentimes, you can also turn on closed captioning for these videos, which will give you the written language as well.

### 2. Make recipes

If you love to cook, if you love the food of your target language (Italian pasta anyone?), then kill two birds with one stone! Learn to cook a delicious new recipe and learn the words for the ingredients in your target language. Win/win!

### 3. Find a language-learning buddy

There are plenty of people in the world trying to learn other languages, singers and non-singers. Find ways to meet people who also want to learn your target language, or maybe find someone who wants to learn your native language in exchange for teaching you theirs. If you would rather meet face-to-face, check out language groups through sites like Meetup.

### 4. Play video games

Similar to watching cartoons, playing video games in your target language creates a visual experience for learning a language. This activity goes one step further by requiring you to interact with a language by following directions. Role playing games or multiplayer games are recommended for language learners. *One of my readers pointed out that board games such as Scrabble are a great option as well!

### 5. Place vocabulary Post-Its around your house

What’s the word for “door” in your target language? How about “bed,” “book,” or “piano”? Write it on a Post-It and stick it on that object! It’s a great way to create a connection between objects you interact with in your everyday life and vocabulary in your target language. Keep in mind that I do not recommend using this method with your pets, or your significant others.

 

### 6. Change the language of your social media pages

Yes, it can be hilarious to change your Facebook page to “Pirate” matey, but have you ever changed it to your target language? It can be a bit daunting at first, but it’s a great way to learn social phrases in a new language. Furthermore, you can search groups, tweets, or other activity by others in your target language for continued exposure.

*** 

By making simple, everyday changes like this, soon you’ll be exposing yourself every day to your target language within the comfort of your own home! I’d like to now give you a list or resources that can help you in your language learning journey. In addition to the websites mentioned above, these free or low-cost resources offer vocabulary, grammar exercises, language classes, and more.

- Mango
- Duolingo
- Memrise
- BBC Languages
- OpenCulture
- WordReference
- Your local library


What language(s) are you learning right now? What creative ways help you to learn your language? What are your favorite resources? If you subscribe to my mailing list now, you will also receive a free translation chart for your various texts and poetry, helping you to reach fluency in your target language even faster!

 

Continuez à écouter!
(Keep listening!)
