+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-07-02T00:25:00-04:00"
lastmod = "2017-05-25T10:09:00-04:00"
preamble = "Some folks have an inner pulse that rivals most metronomes. Others have to work for rhythmic perfection. Singers, we know you all get bad reputations among classical music circles for not being able to count, and frankly, sometimes you earn the stereotype. Singers who work regularly have excellent rhythm, and they know how to make music within a beat structure. Here are 5 quick ways to develop great rhythmic skills and squash the metronome-toting haters."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495720394536/2017-05-25---Time.jpg.jpg"
publishDate = "2015-07-03T09:08:00-04:00"
related_articles = ["articles/4-tips-for-when-there-are-too-many-notes.md","articles/4-secrets-for-better-high-notes.md","articles/how-to-play-for-singers.md","articles/4-steps-to-taking-fixing-notes.md","articles/singing-in-english-3-reasons-why-no-one-can-understand-you.md","articles/4-traits-of-a-great-cadenza.md","articles/singers-masters-of-illusions.md","articles/4-ways-to-test-your-memory.md","articles/rhythm-the-good-the-bad-and-the-stressful.md","articles/the-practice-tip-you-dont-want-to-hear.md"]
short_description = "Some folks have an inner pulse that rivals most metronomes. Others have to work for rhythmic perfection. Singers, we know you all get bad reputations among classical music circles for not being able to count, and frankly, sometimes you earn the stereotype. Singers who work regularly have excellent rhythm, and they know how to make music within a beat structure."
slug = "5-ways-to-build-your-rhythmic-chops"
title = "5 ways to build your rhythmic chops"
+++

### Subdivide

We don't mean "one-and-two-and," etc. If you've got basic musicianship skills, you know that two eighths equal a quarter and all of that. The theory of it all doesn't necessarily work for singers, especially when they're onstage in an opera; it takes them out of their character by placing a blank expression on their face as they start to count. Long notes can be a big culprit, because it's easy to make sound, start thinking about resonance and placement and vowel formation, then forget to count how many beats you've been hollering for. Get into the habit of repeating the word or syllable you're singing in a rhythmic way. If you sing the word "amore," with five beats allotted to the middle syllable, one of the first ways to internalize rhythm is by saying (or singing lightly), "amo-mo-mo-mo-mo-re." From there, graduate to "amo-o-o-o-o-re," articulating each "o" so that it gets a distinct, percussive beat. 

### Do something during a tied note

Often, singers see tied notes, and just say, "I have to hold this note longer than I think." We're grossly over-simplifying, and the root of the problem is that the beat over which the tie falls goes unaccounted for. If you have to sing a note that's tied over beyond the next downbeat or strong pulse, do something to help you feel that rhythmic checkpoint. A crescendo that peaks at the tied note is the simplest thing to do, and it's something you can bring into performance, too. Think of anything by Richard Strauss, and you'll know what we mean. Ties are written to increase excitement, and finding a musical impetus, like the snap of a rubber band at the end of its tension, will keep you active and artistic.

### Breathe in rhythm

This is hugely valuable in quick passages, *especially* when you're part of an ensemble. When we advise to give pulse to your breath, we mean spend any downtime between phrases breathing slowly and with rhythmic integrity. Say you've got to come in on a bunch of off-beats; you could panic and take a hitched breath half a beat before you're due to come in, or you could spend a luxurious bar or more taking a calm, slow breath that keeps you engaged and lets you sing off-beats with more musicality. Simply put, when you're not singing, you should be breathing. If you're doing neither, all that's left to do is overthink and second-guess. Plus, oxygen is great for the brain, where most of our counting happens.

### Listen, don't count

Instead of counting, find the bigger melody. Maybe you always tend to come in on beat 2 instead of 3, or you breathe too late for that weird entrance over the page. Whenever possible, look at the voices and instruments around you, and learn their melodies as completely as you do your own. Instead of having to count "one, TWO GODDAMMIT" and then sing, you could hum the whole bar and know when you join in. Even if you're on a huge stage and can't hear the orchestra, by show day you'll have internalized the bigger picture. It'll also make you a more flexible collaborator, in case the tempo fluctuates or the clarinetist feels like being extra expressive.

### Conduct yourself

Enough said. We don't mean bash a pencil on your score in quarter beats. Really conduct, using the correct beat patterns for whatever meter you're in. It's painfully difficult, and definitely humbling at first; but start doing it all the time (*all the time*, hear?). Your understanding of the pulse, not just the beats, will be beautifully whole.

> Readers, what are your go-to rhythm tricks? Let us know in the comments below!
