+++
author = ["authors/jeremy-hirsch.md"]
categories = "How-to"
date = "2018-10-10T16:42:00-04:00"
lastmod = "2018-10-11T20:11:00-04:00"
preamble = "Day jobs: A good one keeps you fed and sheltered while you grow towards doing what you love full time. A bad one drains time and energy from your artistic life.\n\nBackground acting (AKA working as an \"extra\" on a television or film set), with few barriers to entry and mostly single-day commitments, could be a good way to fill gaps between gigs. Approach it constructively and you can hone your craft while earning a (mostly) quick buck."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539204606414/sqCrowd.jpg.jpg"
publishDate = "2018-10-11T20:11:00-04:00"
related_articles = ["articles/how-i-acted-my-way-into-an-opera-career.md"]
short_description = "Background acting (AKA working as an &quot;extra&quot; on a television or film set), with few barriers to entry and mostly single-day commitments, could be a good way to fill gaps between gigs. Approach it constructively and you can hone your craft while earning a (mostly) quick buck."
slug = "5-ways-being-a-background-actor-helps-your-singing"
title = "5 ways being a background actor helps your singing"
+++

## It helps you relax

Film and TV actors put a high premium on staying relaxed while they act.

Recently, I was on set with a comedic actress who is having a moment of blooming popularity after years of success without stardom. She created a personal force field of relaxation while cameras and crew zipped around. Sipping her favorite Starbucks drink, she quietly got to know her colleague. When the cameras started recording, she bled that relaxed state into her on-camera performance. The result was not just "natural", it was "real".

Practical tip: Think of three activities (like yoga, stretching, meditation, etc.) that help you relax but will not interfere with a colleague's process. Between takes in the recording studio, or runs in the rehearsal room, experiment with one of your activities. Try to merge your relaxed self with your performance self as the next scene or take begins.

## It helps you remember humility

Day-playing non-union background actors are near the bottom of a production's hierarchy. Not that your work will not be appreciated. Background actors are essential, but they are the least public on- screen talent. You will have a number. Not dehumanizing, but far from glamorous.

The upside? No divas. Your background cohorts will generally be self-effacing, kind, fascinating people happy to share their stories. Confidence is essential as a performer, but so is humility. A day of background acting will check your tenor-ific ego.

Practical tip: You'll be onset with a lot of other background actors. It's a long day. Get to know your neighbor. Remember the joy of making friends. Bring that friendly attitude to your next opera rehearsal. Not only will you endear yourself to your colleagues in a genuine way, but the real-life chemistry you build in the rehearsal room will transfer to the stage. Also, you'll have more fun.

## It's a model of efficiency

Television shows are sound models for making high quality entertainment fast. Schedules are tight and stakes are high. Every minute costs money. When the gears get clogged, people get mad. But when the set is humming, it is magical.

Practical tip: Keep an eye on the crew. See what enervates them and what makes them smile. Learn what you can do to keep the production humming (usually it's as simple as be quiet and listen up). Hone an attitude of calm, disciplined attentiveness. See what happens when you bring that attitude to opera rehearsal.

## Costume yourself

As a background actor, you will usually costume yourself. Wardrobe is expensive and budgets do not permit personally outfitting every "extra". Opera singers are rarely tasked with costuming themselves at conservatory. A huge missed opportunity. It is a great way to learn how what you wear tells who you are.

Time is money, and wardrobe staffs are greatly outnumbered (think three people for seventy extras). You are more valuable to the production if you can costume yourself without making a fuss. Also less time at wardrobe means more time relaxing.

Practical tip: Hone your costuming skills. On set, try to get your first outfit wardrobe approved. As you work in opera and recital, consider costuming. Even if you cannot pick your own clothes, remember how it felt to do so, and what it feels like to wear your own clothes as a costume. If you do get to use your clothes, even better! Get personal and specific. Use your outfit to tell the story.

## You can practice your acting

Background work can put you in acting situations from the most mundane (buying a pretzel), to the most bizarre (a horde of decaying zombies). But since you are not the focus of the shot, the pressure is off. You can experiment with all that realism training you have invested in.

Practical tip: Set yourself small challenges. If you play an audience member watching a performance that is supposed to move the crowd to tears, find yourself moved to tears on every take. If you are crossing the street pantomiming conversation, great! There's an opportunity to be your natural self under highly fictionalized circumstances.

As a singer, you are always trying to figure out how to tell stories in more engrossing ways. But you have to pay your rent and fill your belly. When a dry spell hits, sometimes a flexible job that earns you a quick buck can be a saving grace. If it works your artistic chops, all the better.
