+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-04-11T19:01:00-04:00"
lastmod = "2015-04-11T19:01:00-04:00"
preamble = "<p>\n\tIt's that time of year! Music schools across North America are holding their entrance auditions over the next couple of months, and as someone who's been privy to more than a few in my own career, I wanted to extend some advice. Young singers, as you sing your hearts out for the faculties at the University of Toronto, GGS, Western University, McGill, Juilliard, Eastman, NEC, Peabody, Oberlin, Rice, and Curtis, I offer you tips from your audition pianist.\n</p>"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428793003564/UofT_Fotor.jpg.jpg"
publishDate = "2015-02-17T09:01:00-05:00"
related_articles = ["articles/how-to-really-learn-a-song.md","articles/what-to-wear-to-an-audition-via-the-red-carpet.md","articles/wolf-trap-audition-conversation.md","articles/psychology-audition.md","articles/audition-arias-101-the-young-singers-guide.md","articles/3-life-lessons-that-practice-rooms-can-teach-you.md","articles/rarities-opera-stage-parents.md","articles/4-myths-from-music-school.md","articles/honing-your-craft-opera-courses-at-the-associated-studios.md"]
related_companies = ["scene/companies/university-of-toronto-opera.md"]
short_description = "Young singers, as you sing your hearts out for the faculties at the University of Toronto, GGS, Western University, McGill, Juilliard, Eastman, NEC, Peabody, Oberlin, Rice, and Curtis, I offer you tips from your audition pianist."
slug = "5-tips-for-university-auditionees"
title = "5 Tips for University Auditionees"
+++

<h2>1. Do your research, <em>then</em> find your pianist</h2>
<p>
	Many music schools have a list of audition pianists, so you should contact the administration and ask for that list. Sometimes you can also find out the plan for scheduling rehearsals before your audition; at the University of Toronto, for example, they generally book you a warm-up room 30 minutes before your audition time. With info like this, you can make sure you hire a qualified pianist, and schedule a rehearsal with them at a time when you'll know you have a room. Finally, ask how much they cost; it's not an obtuse question, and why not find out ahead of time?
</p>
<h2>2. It's up to you to show up on time</h2>
<p>
	The bad news is that most university campuses are pretty confusing to navigate as a visitor. The good news, though, is that Google Maps exists. If you're driving to your audition, decide where you want to park, and be sure to include walking directions from the parking lot to the music building. You're going to be nervous and the day will be hectic; you don't need to add to your stress by getting lost and running late.
</p>
<h2>3. Bring your pianist an organized folder</h2>
<p>
	The ideal situation for your pianist's music is a three-ring binder, with double sided photocopies of your audition repertoire. A singular folder for your pianist is preferable to a stack of original scores, in my own experience; it's lighter, for one, and your pianist won't have to struggle with a book that won't stay open (and perhaps distract you while you're singing). Add your own notes to the music about whether or not you'll take repeats, or sing a cadenza, and it's a great idea to highlight signs for <i>da capo</i>, <em>dal segno</em>, and <i>fine/coda</i>. Bonus points for labeled tabs on each song.
</p>
<h2>4. You're in charge of your audition</h2>
<p>
	Your audition pianist may be a total stranger to you, but trust that he or she is there to help you, period. You get a short rehearsal before your audition, so make sure it goes the way you need it to go. Hum a bit of your piece to set a tempo before you start, and if you still don't like it, <em>change it</em>. We will take no offence. There's no requirement to follow your pianist, because we're there to follow you. This goes for in the audition itself; if you need to go slower, faster, take that breath, absolutely do it. Even if you're not perfectly in sync with your pianist for a moment, the people listening to you will know that you've made decisions about how you want to sing your repertoire. That's a good thing.
</p>
<h2>5. Pay your pianist before the audition starts</h2>
<p>
	This isn't a rule that's set in stone, but it's definitely a courtesy that pianists remember. Most auditions start with your singing, and then the pianist is excused while you chat with the panel. The main reason for paying up before your audition is that your pianist may need to run to their next rehearsal, instead of waiting for a cheque while you finish. It's also another thing that you can check off your to-do list for the day. My favourite method is the surprise envelope in the pianist's binder.
</p>
