+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-04-09T13:37:00+01:00"
lastmod = "2017-04-10T13:02:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1491823120482/2017-04-10---Church.jpg.jpg"
publishDate = "2017-04-10T12:20:00+01:00"
related_articles = ["articles/back-to-school-opera-a-practical-glossary.md","articles/but-why-didnt-they-write-opera.md","articles/rehearsing-a-messiah-that-moves.md","articles/palpable-chamber-music-haymarket-operas-lenten-oratorio.md"]
short_description = "Leave it to Krzysztof Penderecki, the Polish composer known for writing terrifying music, to bring to life every detail of the Passion according to the Gospel St. Luke. His St. Luke Passion is an eerie, uncomfortable, atonal setting; it&#039;s scored for three choruses, a boys chorus, three soloists, a narrator, and a huge orchestra that includes odd instruments like saxophones, vibraphones, and a harmonium."
slug = "5-reasons-to-get-your-drama-fix-from-oratorio"
title = "5 reasons to get your drama fix from oratorio"
+++

It's the week of palm cross sightings and store fronts that tend towards pastel colours and egg-shaped advertising campaigns (quite the crass contrast, if you think on it much about). Whether you're someone who's well aware of the Christian calendar, or you're one of the many singers who hold a regular gig singing in church services, you know it's Holy Week, which leads up to Easter Sunday on April 16, 2017. 

It's a time of year that comes with extra church services, more chocolate than necessary (unless you're an admirable person who's giving it up for Lent), and lots of sacred music meant to commemorate the holiest week in the Christian year.

Perhaps not all of you are religious folks, but one doesn't have to have faith to appreciate the awe and grandeur in the music we classify as "oratorio". Quickly: an oratorio is a large-scale musical work for instruments and singers, which has a sacred narrative, and is traditionally performed without sets or costumes.

In recent decades, directors have started experimenting with [staged](https://www.theguardian.com/music/2017/apr/07/mark-padmore-a-passion-for-bach-why-the-st-john-belongs-on-the-live-stage-at-easter) versions of oratorios. For some, it's a riveting way of experiencing these sacred works, and for others it's a tacky, maybe even blasphemous choice. Yet the success of projects like Peter Sellars' staged *St. Matthew Passion*, or Joel Ivany's movement-inspired [*AtG's Messiah*](/rehearsing-a-messiah-that-moves/) reaffirm the enormously inspired drama that's found in oratorio.

Compared to opera, oratorio may look stiff and bland; yet it's an overwhelming thing to discover how the composers of these works were - quite literally - inspired by the holy texts, enough to create some of the most evocative and imaginative musical settings. Even for someone who isn't religious, to hear Mozart's *Requiem* or Bach's *B Minor Mass* is to, at the very least, understand how desperately human beings look upwards for something more, and how valiantly we try to create things that rise higher, grow bigger, and last longer than any of our mortal bodies can manage. It's the same awe you one can feel walking into the Sagrada Familia in Barcelona or looking at the ceiling of the Sistine Chapel in Vatican City - human beings, when motivated, can create things that come from the natural, but are inspired by things which are supernatural.

With all that said, examples make a better point than words. We've decided not to limit these picks to oratorio specific to Easter or Holy Week; out of the enormously large oratorio repertoire, we've compiled a short list of dramatic moments in sacred music, ones that give even the exaggerated emotions of opera a run for their money.

## Verdi's *Requiem*

Among opera circles, Verdi's *Requiem* is lovingly nicknamed his "best opera". It's a standard setting of the Roman Catholic funeral mass text, composed in memory of Italian writer Alessandro Manzoni. First performed in 1874, the *Requiem* was written after Verdi's enormous "hits", like *Rigoletto*, *La traviata*, and *Aida*, but before his late masterpieces like *Simon Boccanegra*, *Otello* and *Falstaff*.

This clip is timed up to the beginning of the epic "Dies irae", or the "Day of wrath". Leave it to Verdi to write music that sounds just like wrath, coming straight for you:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/8iBaI2fgH7A?start=618" frameborder="0" allowfullscreen></iframe>
</figure>

## Beethoven's *Missa Solemnis*

Beethoven is another biggie who set the Mass text - twice, actually. His *Missa Solemnis*, Op. 123 is the second setting, written after his lesser-known Mass in C Minor, Op. 86. Its premiere happened in St. Petersburg, 50 years before Verdi's *Requiem*, yet Beethoven's music has all that ahead-of-its-time fire and oomph that we love about his symphonies. This clip is timed up to the last, thrilling bit of the *Gloria*, a [text](http://www.kitbraz.com/tchr/hist/med/mass_ordinary_text.html#GLORIA) which basically says that God is powerful and mighty. Beethoven piles fugue on top of fugue in this movement, pitting chorus against soloists to get your heart beating near out of your chest. Glory, indeed.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/VUUElRVrTeY?start=1567" frameborder="0" allowfullscreen></iframe>
</figure>

## Haydn's *Creation*

A classic, Haydn's oratorio is a setting of a libretto by Gottfried van Swieten, based on the creation story in the Book of Genesis. If you needed proof that oratorio composers use things like word-painting - where they make the word *sound* like what it means - this clip is timed up to one of the most famous bits from *The Creation*. The text here is that well-known line, "and God said, let there be light, and there was light." In this clip, Leonard Bernstein gives away the surprise a bit with his wry smile, but you can't deny the thrill in that magical C Major chord under "LICHT!"

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/32Xq7Tcj428?start=627" frameborder="0" allowfullscreen></iframe>
</figure>

## Penderecki's *St. Luke Passion*

Leave it to Krzysztof Penderecki, the Polish composer known for writing terrifying music, to bring to life every detail of the Passion story according to St. Luke. His *St. Luke Passion* is an eerie, uncomfortable, atonal setting; it's scored for three choruses, a boys chorus, three soloists, a narrator, and a huge orchestra that includes odd instruments like saxophones, vibraphones, and a harmonium.

Proof that oratorio can give you the heebie-jeebies, this clip starts at the "mocking of Christ" at his trial. Who needs opera when you've got Penderecki writing "angry mob" music? #Shudder.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/nkqydMUOoEs?start=1389" frameborder="0" allowfullscreen></iframe>
</figure>

## Bach's *St. Matthew Passion*

He never wrote an opera, but he wrote with an opera composer's imagination. One of the famous arias from his *St. Matthew Passion* is "Erbarme dich, mein Gott", written for the alto soloist. The aria text says, "Have mercy on me, God" and it's full of begging for pity. The melody is heart-wrenching, and Bach always writes with at least a handful of symbols up his sleeve. The aria is in b minor, decidedly one of the most painful, sad keys of his time; Bach almost always writes his arias for a solo singer, plus an "obbligato" instrument, which comes out of the orchestra texture as a second soloist. Here, it's an earthy violin which duets with the alto, full of reaches upwards, and tear-drop figures in the twangy, painful minor key. 

It's not opera, of course, but Bach's oratorio is undeniably dramatic.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/zRmlJInwkZc?start=5193" frameborder="0" allowfullscreen></iframe>
</figure>

>Readers, what oratorio moments do you love most? Let us know in the comments below!
