+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2016-08-08T10:28:00-04:00"
lastmod = "2017-08-02T21:50:00-04:00"
preamble = "In a recent [interview](http://www.faz.net/aktuell/feuilleton/buehne-und-konzert/russische-opernsaengerin-anna-netrebko-im-interview-14374153.html) with Eleanore Büning for FAZ, star soprano [Anna Netrebko](/scene/people/anna-netrebko/) said of the teleprompter she used in Dresden to sing Elsa in *Lohengrin*, \"Jetzt verrate ich Ihnen ein Geheimnis: Ich kann keinen deutschen Text memorieren.\" (\"Now I'll tell you a secret: I cannot memorize any German text.\")\n\nOur first reaction was that Netrebko was simply memorizing the wrong way; but really, her career speaks for itself, and we'll not be the ones to criticize her methods. When it comes to singers memorizing their words, the basic goal is to spot as many patterns as possible, like repeated sections of text, rhyme schemes, recognizing when the form goes A-B-A-C-A-D etc. Really, it's a personal thing that comes easily to some, and to others it's hard work.\n\nWhatever your method is of committing text to memory, we'll offer up some help for the next step, where you get to test your work:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501725015244/2017-08-02---Memory.jpg.jpg"
publishDate = "2016-08-09T05:54:00-04:00"
related_articles = ["articles/how-to-really-learn-a-song.md","articles/5-ways-to-build-your-rhythmic-chops.md","articles/singing-in-english-3-reasons-why-no-one-can-understand-you.md"]
short_description = "One of the most common pitfalls of singers in the memorizing process is to combine the words and music too soon. It&#039;s rare for a singer to have a memory lapse with the music itself (weird rhythmic entries excepted); in most cases, a singer&#039;s mind goes blank when they can&#039;t remember the upcoming words - even more so, when the text is in a non-native language."
slug = "4-ways-to-test-your-memory"
title = "4 ways to test your memory"
+++

## Can you write down and recite the text?

One of the most common pitfalls of singers in the memorization process is to combine the words and music too soon. It's rare for a singer to have a memory lapse with the music itself (weird rhythmic entries excepted); in most cases, a singer's mind goes blank when they can't remember the upcoming words - even more so, when the text is in a non-native language.

This is much less likely to happen if the text and music have been studied and memorized separately. That form of autopilot that often takes over in the practice room, where the flow of the music prompts the words along the way, is not to be trusted under pressure. Yet if a singer has a solid understanding of both the way the music *and* the words go - separately - those weird brain farts don't have nearly the same amount of disastrous power.

So, the best way to test whether or not you've memorized the words on their own (rather than relying on the guiding light of the tune), is to recite them as speech, or write them down as poetry. It's a valuable trick for text in any language, but if your first language isn't German or Italian, it's even more important to make sure you know your "dem" from your "der", your "lo" from "la". 

No music to help, no rhythmic patterns to remind you what comes next - it's a pure and brutal trial of how confident you are about text.

## Can you recite foreign text in your native language?

The point of this test is to make sure you're memorizing *words* - and their meanings - instead of a vague string of sounds. Phonetic memorization comes with many opportunities for odd mistakes, like "ma" instead of "da", "delitto" versus "diletto"; but it's much harder to confuse "but" with "from", and "crime" with "delight".

Since you're already sweating over a true translation of your foreign-language aria (and you're definitely not relying on the English "translation" that gets included in your score), test your work by reciting and/or writing down that translation. Get picky with verb tenses, passive versus active voice, formal versus familiar pronouns. Once you've passed this test, you can try the advanced version: singing your aria as written, but trading the original text for your translation.

That attention to detail will help nail down those tricky corners of memorization, and you'll be much more connected with the foreign text when you actually sing it for listeners.

## Do you know what word rhymes with what?

Rhyme schemes are handy, handy things. Sometimes they can be hard to spot, since the text isn't written out in a way where you can easily see rhyming couplets or an ABAB format to each verse.

So, before you combine the text and words, make sure you know what kind of rhyming scheme you're dealing with (or lack thereof). When it comes to memorizing, patterns are a beautiful thing, and you can't get more fail-safe than knowing your way around rhyming words.

## Do you know where you're likely to make a mistake?

As you slug through the memorization process, accept that you'll make mistakes along the way. But the most difficult mistakes to fix are the ones you don't always know you're making. 

If you make a few passes at writing down your words, and you notice that there are certain places where you consistently mix up verses or say the wrong verb tense,  note that these are the same places where muscle memory has started to take over before you really have your head around the text.

In rehearsals with a director, singers often rely more on muscle memory with their words and music, while they learn new staging. As any music staff member will know from experience, these are the rehearsals where music and text errors can either be fixed, or hopelessly ingrained into a singer's head.

So, stay wise to muscle memory, and know where it's a dangerous crutch. The more time you can spend with your brain focused only on text and music, the less likely you are to make repeated errors in staging rehearsals, where your focus shifts. Even better, if you get corrected on a text detail in rehearsal, it won't be new information to you.

>What methods do you use for memorization, and how do you test your work? Let us know in the comments below!
