+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2016-06-02T03:43:00-06:00"
lastmod = "2016-07-06T16:12:00-06:00"
preamble = "Part of the job of the music staff working on an opera is to deliver notes to the singers. Notes, in this context, are basically \"things the singer is doing wrong\". If you're a music staff member with compassion, this process can leave you feeling at best like Toby from *The Office*, or at worst, Estelle Costanza from *Seinfeld*.\n\nThere's an art to delivering constructive criticism, and we can help with that art. You could almost say we're about to give you notes on how to give notes. #meta."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464981998585/2016-06-04---Post-it-notes.jpg.jpg"
publishDate = "2016-06-03T14:19:00-06:00"
related_articles = ["articles/4-steps-to-taking-fixing-notes.md","articles/star-repetiteur-there-is-such-a-thing.md","articles/potential-orchestra-mutiny-and-conductor-envy.md","articles/3-tips-for-being-a-respectful-voice-coach.md","articles/nerding-out-why-you-should-definitely-care-what-key-your-aria-is-in.md"]
short_description = "Part of the job of the music staff working on an opera is to deliver notes to the singers. Notes, in this context, are basically &quot;things the singer is doing wrong&quot;. If you&#039;re a music staff member with compassion, this process can leave you feeling at best like Toby from The Office, or at worst, Estelle Costanza from Seinfeld."
slug = "4-ways-to-give-notes-still-be-liked"
title = "4 ways to give notes &amp; still be liked"
+++

## Start with respect

Usually, the music staff are not singers, and so there's an unique dynamic between the note-giver and the note recipient. So, starting from a point of respect for what singers can do is the best way to approach giving them notes, particularly when you give a note for the first time. This means that as music staff, your job actually gets a bit easier; you really only have to ask a singer for what you'd like to *hear*. For example, if there's a section of text that's unintelligible because the consonants aren't audible, ask for louder consonants. You may recognize that the issue is that the singer isn't supporting his or her breath through the consonants, making them inaudible, but there's no reason the singer can't come to that conclusion, too. It can be patronizing for a member of music staff to ask for louder consonants, and also launch into a mini technique lesson about *how* to do that. Assume that the singer can bridge that gap for themselves, and frame your requests from a point of "I hear XYZ", rather than "You're doing XYZ."

If a singer has trouble fixing your note, hopefully they'll ask you to clarify what you mean. If they don't, and the note doesn't get fixed, you could offer suggestions within the context of doing *more* of what they're already doing. So, rather than "support the whole word," ask them to "give more support on those consonants". It's a subtle difference; the former suggests they're not supporting at all, and the latter suggests that they need to adapt to the acoustics in the performance space.

## Timing is everything

During staging rehearsals, the music staff has a responsibility to be aware of the director. Often a rehearsal period begins with strictly music, then shifts into staging work; music doesn't become a focal point again until the *sitzprobe*, which happens fairly close to opening night. It's up to the music staff to establish musical priorities during their initial rehearsals, and to refine and maintain them during stagings. Most directors aren't opposed to taking some time out of his or her plan to address musical issues.

So, timing is everything. During a staging rehearsal, a singer is learning where to go, how to move, and how to co-ordinate that with singing well and watching the conductor. Music staff are wise to sit back for a few repetitions and let the singers sort out all of that juggling for him- or herself. Once a scene has been blocked and discussed and tried out, it's reasonable to ask for a minute or two to work on the scene's music before trying out the whole package. This is much different than fighting for the last word with a director, where music staff punctuates every staging suggestion with, "and don't forget the rolled R!" 

Both the music staff and director should be able to adapt. If a slower tempo lets a moment of comedy shine through more clearly, it's worth it to cede that detail to the director. If a slightly earlier entrance will help a singer hear and see their musical cue, it's worth it for a director to cede to the music staff. 

Teamwork!

## Be organized

It seems obvious, but it's a great idea to write down notes for the singers. You can feel like the bearer of bad news, like you're *that person* with your naggy little scribblings; but notes in writing are the best way to sum up what needs attention, and it allows the singer to take the list home and internalize your notes on their own time.

Use a single sheet of paper for each singer, with a clear list of bullet points for them to address. Include cues like bar numbers or text prompts, so they know the exact place you mean, and indicate what you'd like to hear differently. For example, you can write down an unclear word and underline the letters that are currently inaudible.

One piece of etiquette: avoid delivering notes to the singers while they're on a break during rehearsal. Let them have a break.

## Remember: it's not personal

Music staff, here are some reasons why your note doesn't get fixed, in decreasing order of probability: 1) they forgot, 2) they thought they fixed it, and 3) they don't like you. Number 3 rarely happens, and if it does, it says more about the artist than about you.

In the spirit of fairness, get honest with yourself about what you're asking a singer to do, and make sure that you're not being overly picky, that you're not asking for something that they don't have the ability to execute, and that you're not confusing personal taste with something that's musically necessary.

Remember, it's them up there on opening night, not you. And these singers are artists, too, with their own things to say about their roles. If you're dissatisfied with what an artist is doing, and it's too late to fix it, there comes a point where it doesn't matter *why* they're not taking your notes. By continuing to remind someone of what they're not doing, instead of listening to what they *are* doing, all you'll get is a singer who feels nagged and patronised. Whatever unsatisfactory state their work is to you by opening night will only become more so if a dead horse is beat.

>Have a note-giving etiquette tip to share? Leave your ideas in the comments below!
