+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-05-26T17:55:00+01:00"
lastmod = "2016-05-27T14:57:00+01:00"
preamble = "Photo: [William Warby](https://www.flickr.com/photos/wwarby/3895151999) via [Flickr](https://creativecommons.org/licenses/by/2.0/legalcode)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464349909840/2016-05-27---Butterfly.jpg.jpg"
publishDate = "2016-05-27T14:44:00+01:00"
related_articles = ["articles/morbid-musings-art-death.md","articles/proof-that-music-is-simply-unreasonable.md","articles/vibrato-all-the-reasons-why.md"]
short_description = "The link between human behavior and art is so strong and so complicated that it&#039;s even an understatement to call it a &quot;link&quot; at all; art comes from humans, and humans are part and a product of our environments, natural and otherwise. There&#039;s a potential regression from La traviata to single-cell organisms, if you step back far enough."
slug = "4-ways-that-opera-really-is-life"
title = "4 ways that opera really is life"
+++

It's clear that we, the Schmopera folks, have a passion for opera, and [like a lot of artsy types](http://www.overthoughtpodcast.com/), we also have a fascination with human nature. The two are linked, of course, and every once in a while, something about opera stands out as particularly representative of our tendencies and behaviours. 

For instance, *The Magic Flute* is a product of our struggle for an objective understanding of right and wrong. The heirarchy of a rehearsal room can seem like a miniature version of the complicated balance between authority and freedom that we all seek; sometimes a rehearsal is a dictatorship, and sometimes it's more of a socialist endeavour. Perhaps one of the most basic parallels between opera and human nature is our profound response to the sound of another human voice.

The link between human behavior and art is so strong and so complicated that it's even an understatement to call it a "link" at all; art comes from humans, and humans are part and a product of our environments, natural and otherwise. There's a potential regression from *La traviata* to single-cell organisms, if you step back far enough. So, before we spin our musings out of control, let's get to some examples. 

\*Note: we are not experts on science, and we're happy to hear feedback from those readers who are.

## Symmetry and patterns

Tunes get stuck in our head because there's something organic about them. As bilaterally symmetric beings, with brains that are great at spotting patterns, it makes sense that we react to music that reflects those qualities. Patterns exist in the repetition of melodies, and they allow listeners to catch on and start singing along sooner. We also respond to patterns in form; Mozart, Verdi, Rossini, these guys had formulas, like the "recit - slow bit - fast bit" pattern, or the use of ornamentation and exaggeration of musical material when it resurfaces. *Bel canto*, anyone?

Symmetry comes in the rise and fall of a pleasing melody; voices in particular are great at letting a phrase build organically, growing to a climactic peak, and then singing some sort of denouement. This can happen within a bar or two, or over the course of a whole opera. The balance of bass and treble gives us symmetry, too; it's related to how awesome it is to hear a full orchestra play as one, and it's related to how singers strive for as many overtones as possible, even when they sing a single pitch at a time.

Patterns and symmetry also work in tandem; consistent meters, like a nice, square 4/4 or a lilting 6/8, invite listeners into the flow of the music, and we naturally appreciate rhythmic checkpoints every 4 or 8 measures. Smart composers capitalize on this, and they plant surprises (one extra repetition, a deceptive cadence, etc.) precisely where we expect a pattern to continue. Humans like a dash of the unexpected, too.

## The evolutionary tree

We talk with a lot of singers, and one of the things we've learned is the curious nature of voice types. It's rare for a singer to be singing the same repertoire at 50 years old as they do at 20, and it's understood that voices change with time. The misconception, though, can be that a singer's vocal evolution is in the shape of a ladder, the rungs coinciding with milestones of age. 

The ladder model is also a [myth](http://evolution.berkeley.edu/evolibrary/article/evo_07) when it comes to the evolution of life. We used to consider it a progression towards a single goal, the top of a ladder, and human beings were thought to be at that top. Now, the model is understood to resemble a tree, not a ladder; the trunk of the tree includes bacteria and other teeny-tiny things, the big branches are things like fish and bipeds and warm-blooded things, and the little branches are things like bananas and panda bears and birds-of-paradise and humans.

It's nonsensical to compare the "progress" of panda bears to that birds-of-paradise, and human voices have a similar breadth of qualities. Not every young singer fits into Handel and Mozart, and not every soprano finds her way to Wagner after 40. It's the tree of vocal *Fachs*, maybe. It's fascinating to see the same kind of misconception about vocal evolution as there is about the various forms of life. It's also just as valuable for us to understand vocal change in a different shape - it's not about upward progression, it's simply about change.

## Mating calls

Lots of animals make noise in order to attract a mate. The criteria are all different; some animals go for the most volume, others for the highest or lowest pitches, and some get excited over rhythmic complexity. It's currently still debated whether speaking preceded singing, or vice versa; it's safe to say that singing affects humans differently than speech, and arguably the affect is more powerful. 

It's amusing to think of a tenor belting out a high C for the same reason that howler monkeys make their impressive racket: they're telling the world that they're healthy and contributing members of society, and that they'd make great mates. We're not saying that opera is one big formalized mating call; but today, we're still impressed by the sheer amount of sound they can make, and that they have the stamina to do so for hours at a time. Opera fans are the first to argue that music adds meaning to words that transcend language; perhaps those meanings aren't far off from what the [bull frog](https://www.youtube.com/watch?v=-zpajerFI1w) is trying to say.

## Survival of the fittest

The phrase is a bit of a misnomer in itself. In evolutionary terms, "survival of the fittest" basically means, "survival of the ones who didn't die and had lots of kids who also didn't die". Maybe it's a depressing thought, but there's some similarity between this idea of the "fittest" and the survival of operas. Perhaps the hit operas, like *Il barbiere di Siviglia* or *Carmen*, have made it into the standard canon of today because they didn't, well, go extinct.

That's not to say that these operas have no merit on their own. There's also the offspring factor to "survival of the fittest"; these hit operas have powerful qualities that have been picked up by later generations of composers. Works like *Carmen* and *Rigoletto* offer the anti-hero, telling the stories of the underdog and the folks who aren't "perfect". *Le nozze di Figaro* and *Il barbiere di Siviglia* offer up catchy music with tales of class revolutions. *La bohème* glorifies the free life that we all think we want to live, and the stunning music doesn't hurt either. Basically, these operas are "fit" because they offer things to their listeners that have turned out to be really handy in theatre. Catharsis, rooting for the underdogs, moving music - these are arguably positive adaptations of theatre. Kind of like opposable thumbs.
