+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-02-01T22:06:00-05:00"
lastmod = "2017-05-21T11:44:00-04:00"
postamble = "What are you sacred rules for writing and singing cadenzas? Let us know in the comments below!"
preamble = "If you're an opera singer, a [cadenza](https://en.wikipedia.org/wiki/Cadenza) is your real *\"listen to ME\"* moment. The orchestra cuts out, and all ears are focused on your voice. Cadenzas come with lots of tradition, lots of hype, and they can be covert competitions among opera's inner circles. So, what makes a cadenza great? More notes? Extreme ranges? Surprise tricks up a singer's sleeve? \n\nMore may be more, but it's all about the execution."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495381420043/2017-05-21---Cadenza.jpg.jpg"
publishDate = "2016-02-02T15:13:00-05:00"
related_articles = ["articles/4-tips-for-when-there-are-too-many-notes.md", "articles/5-ways-to-build-your-rhythmic-chops.md", "articles/how-to-really-learn-a-song.md", "articles/fab-nights-whose-opera-is-it-anyway.md"]
short_description = "If you&#039;re an opera singer, cadenzas are your real &quot;listen to ME&quot; moment. The orchestra cuts out, and all ears are focused on your voice. Cadenzas come with lots of tradition, lots of hype, and they can be covert competitions among opera&#039;s inner circles. So, what makes a cadenza great? More notes? Extreme ranges? Surprise tricks up a singer&#039;s sleeve?"
slug = "4-traits-of-a-great-cadenza"
title = "4 traits of a great cadenza"

+++
## It's got rhythm

A cadenza is arguably the part of any piece with the most freedom in it. Yet, even when the voice is isolated and the pulse of the accompaniment falls away, there's still a rhythm to it. If you're writing your own cadenza for a Baroque-ish opera, you have plenty of license; but while you're writing the notes, get specific about rhythmic values, too. This doesn't mean you'll stay exactly in tempo, but your improvisation should be something that you can conduct; if you can show it, your orchestra can follow.

This becomes especially important in _bel canto_ and everything that comes after it.  Composers like Verdi and Donizetti are more specific about their cadenzas, and the rhythmic values they write are part of the gesture. Without attention to rhythm, the cadenza with flute (or glass armonica) at the end of the _Lucia di Lammermoor_ mad scene just doesn't work. Have a look at this example from Violetta's Act I aria from _La traviata_:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1454433878615/2016-02-02---Verdi-Cadenza.jpg.jpg)
</figure>

Lots of rhythm written here. The first bar of sixteenth notes on the top line is all about proportion; look how Verdi writes that high C at the end of the scale, followed by a _dotted quarter note_ B-flat. Between the C and the B-flat, there are two quarter beats to deal with. If you were to conduct those two beats, you'd feel the strength in the "early" entrance of the B-flat. It's unique, and it's Violetta. Sure, there's nothing underneath the soprano to really highlight the syncopated feeling of those two notes, but if the singer knows it's there, we'll hear it.

The same goes for the "gioir" settings on the bottom line; we should hear that "gio-" is a pickup to "-ir" each time. It sounds like a silly detail, but without a frame of rhythmic context, the whole thing becomes a boneless mass of jelly.

So. The bottom line: if you don't know what the rhythmic checkpoints are in your cadenza, the effect will be less exciting, and you'll have a hard time leading a pianist or a conductor.

>Puzzles like this are a great reason to take your arias to a drama or acting coach.

## It has a focal point

Good cadenzas are like good interior decorating; the eye knows where to look, and there's a point of focus in the form of a gorgeous rug or painting or comfy-looking couch.

So, as you plan out your vocal fireworks, make sure we know where to be amazed. If it's a really high or low note, make sure it's the only one of its kind. If it's a wicked fast scale, make sure it's clear as a bell. Best of all, don't ignore the natural inclinations of any of your tricks. High notes want to fall, low notes want to rise, and scales want to lead to the tonic. Creativity is always awesome, but there's a fine line between imagination and over-complication.

>If you're adding a cadenza into an aria yourself, the first step should be to figure out why.

## The text makes sense

Messing around with cadenzas is usually legal (maybe not in Strauss, and even Bellini is sort of perfect the way it is), so give yourself license to adjust the underlying text to work with what you're doing.

Simply put, make sure you're not singing your grandest note on the word "the" or "what" or anything equally unimportant. When it comes to Baroque or early _bel canto_ cadenzas, you're dealing with very little text in proportion to the amount of music. So, since the text is repetitive and collects more and more subtext as the aria continues, it would be silly to dig one's heels in and sing all one's high notes on the word "la".

Speaking of subtext...

## It has dramatic purpose

The final piece of the puzzle is have a _reason_ to sing a cadenza. If it's written in by the composer, or at least suggested, it's a fair assumption that the composer intends there to be some dramatic outburst at that moment.

>If you can associate a musical gesture with a specific action or dramatic development, you're off to a great start.

If you're adding a cadenza into an aria yourself, the first step should be to figure out why. Does your character change his mind? Has she made a discovery? Is he losing or gaining something? Is she laughing hysterically?

If you can associate a musical gesture with a specific action or dramatic development, you're off to a great start. Plus, once you know _why_ the cadenza exists, you already have a head start on how it should sound.

Puzzles like this are a great reason to take your arias to a drama or acting coach. They can help align your intentions with what's in the score, and the whole thing will be easier to sing.