+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-06-03T21:00:00-04:00"
lastmod = "2017-05-21T11:53:00-04:00"
preamble = "When it comes to singing coloratura, it's easy to imagine that there are those who can, and those who cannot. \"She's always been able to move her voice,\" we say, as if it's a skill one is born with. That may be true, but it doesn't mean the rest of you will never sing fast notes. Your voice teacher is the first step in becoming a master of the scales and arpeggios, no doubt about that. We've found a few tricks that really speed up the learning process, specifically that difficult distance to cross between knowing what the notes are, and making them mean something."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495381518238/2017-05-21---Notes.jpg.jpg"
publishDate = "2015-06-04T09:18:00-04:00"
related_articles = ["articles/how-to-really-learn-a-song.md","articles/5-ways-to-build-your-rhythmic-chops.md","articles/pianists-3-tips-for-sounding-like-an-orchestra.md","articles/hot-topics-singers-who-scoop.md","articles/good-ideas-rehearsalasperformance.md","articles/4-traits-of-a-great-cadenza.md","articles/singable-text-when-composers-make-it-tricky.md","articles/hidden-secrets-of-the-soubrette.md","articles/vibrato-all-the-reasons-why.md","articles/4-weird-questions-for-opera-singers.md","articles/singers-masters-of-illusions.md","articles/3-ways-to-fight-boredom-at-the-opera.md","articles/talking-with-singers-jessica-pratt.md","articles/4-awesome-rage-arias-that-arent-the-queen-of-the-night.md","articles/4-english-language-habits-that-make-a-singers-life-harder.md","articles/the-practice-tip-you-dont-want-to-hear.md","articles/surprising-practice-tips-4-arias-to-try-too-fast.md","articles/a-singers-todo-list-4-tasks-to-keep-you-focused-this-year.md","articles/keeping-the-thread-momenttomoment-awareness-in-singing.md","articles/nerding-out-why-you-should-definitely-care-what-key-your-aria-is-in.md"]
short_description = "When it comes to singing coloratura, it&#039;s easy to imagine that there are those who can, and those who cannot. &quot;She&#039;s always been able to move her voice,&quot; we say, as if it&#039;s a skill one is born with. That may be true, but it doesn&#039;t mean the rest of you will never sing fast notes."
slug = "4-tips-for-when-there-are-too-many-notes"
title = "4 tips for when there are too many notes"
+++

### Break long runs into phrases

For every long and terrifying melisma, there are a handful of shorter phrases within it; finding those smaller sections will make your practicing more manageable, but it will end up more musically satisfying. Promise.

This is a section of coloratura from Handel's *Giulio Cesare*. It can look like an endless stream of notes, but there are ways to make sense of it; here's one of those ways:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433446123626/CesareColoraturaPhrasing.jpg.jpg)
</figure>

Patterns happen to be a golden ticket for singing coloratura. The red lines divide a long phrase into sequential steps; in this case, they're guided by the harmonic pattern in the bass. A bonus effect of grouping the coloratura this way is lightness. By beginning a phrase on a very weak beat, the singer will be less inclined to start beating tempo with his voice; the melisma starts to have a feeling of being in 2/2 instead of 4/4.

In Handel coloratura, or anything that's rhythmically square, it's easy to explore different phrasings. The markings can be shifted backwards or forwards, one note at a time, and they create completely different effects for the singer. The time you spend figuring out which phrasing you like best ends up as extra practicing, like watching a really great TV show on the treadmill.


### Find hidden tunes

Just like the mini-phrases hidden in long melismas, there's usually a sort of counter-melody to be found as well. This can help you find the big picture, or the skeleton of a melisma. Here's that same section of *Cesare*, this time showing one of these hidden melodies.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433381191965/CesareColoraturaBigBeats.jpg.jpg)
</figure>

Again using the harmonic motion underneath the voice, we've taken the primary notes of this melisma and isolated them. It's worth trying out this overarching tune a few times, singing the circled notes in bars 32-33 as half notes, and quarter notes in bar 34. This hidden melody is at a much kinder tempo than the actual run, so take the time to enjoy it as you try it out. When you go back to sing as written, you can hear that Handel is just jazzing up a fairly basic three-note melody. No need to get bogged down in every single note.

Here's another example, from Sesto's first aria in Mozart's *La clemenza di Tito*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433382418471/SestoColoratura.jpg.jpg)
</figure>

Mezzos hate this bit, and it's understandable. But when you find the checkpoints, the big picture of all these triplets, it's much more palatable. There's an easy rising third pattern in the circled quarter notes, under which Mozart added a few ornamental notes. Yes, it doesn't change the fact that it keeps rising up to a B-flat, but seeing the forest for the trees will keep you singing light and thinking ahead. It's hard to explain precisely why this works, but we've heard mezzos try it out, and go from running out of air to finishing "beltà" with gusto.

### Practice in rhythms

This is a piano trick, and although it doesn't always translate into a good method for singers, it's really applicable for learning coloratura. Here's a section of a horridly fast aria in Handel's *Semele*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433383405167/SemeleColoratura.png)
</figure>

This melisma combines scales and arpeggios, and takes unexpected dips and dives all over the place. Since you're going to have to repeat this run *a lot of times* before you can sing it *a tempo*, you may as well repeat it intelligently. The trick is to ignore the rhythm (for a bit). The short version of this trick is to turn straight sixteenth notes into dotted sixteenth notes; once you've mastered dotted-eight-note + sixteenth, try sixteenth + dotted eighth (short-long, versus long-short).

Now, for every beat (group of 4 notes), sing the first note long, and the last three short. Instead of four even sixteenth notes, you'll sing something more like a dotted eighth note + three triplet sixteenth notes. (*Long...short-short-short-Long...short-short-short*, etc.) 

Next, shift the long note to the second of each group of four. So, *short-Long...short-
short*, *short-Long...short-short*, etc. Then, the third note is the long one, and so on. It's hard to do and really annoying at first, but it is often *the* quickest way to learn a complicated run, and learn it well. The short notes help you practice moving quickly between every combination of pitches, and the long notes make sure that you feel every pitch in your full, healthy voice.

### Sing subtext, and never stop

At the very least, it'll keep you from overthinking the technical. Simply put, make sure you know *why* you're singing all those notes. Remind yourself that your character might be so happy she's on the verge of laughter, like Cleopatra:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433384723328/Screen%20Shot%202015-06-03%20at%2010.18.22%20PM.png)
</figure>

Cleopatra laughs, apparently, in short fits followed by high-pitched shrieks. Those tiny phrases leading down to trills are easier to make sense of with her mood in mind, and you'll be more likely to come up with creative ways to make these lines your own. Those repeated eight notes, while still tricky to keep in tune, will at least be motivated, even when you're not.

Or your character might be a bit schizophrenic, like the Queen of the Night:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433384956898/Screen%20Shot%202015-06-03%20at%2010.20.30%20PM.png)
</figure>

There are so many personalities in these three lines, and it's worth your while to get specific early on. The top of the page seems a bit cheerful, letting Tamino know that her daughter really is pretty, and by the middle of the second line, she's reminding him that she's in charge and she's handing out orders (it's fun to imagine in that last arpeggio up to the high F that she's screaming, "I'm the QUEEN!"). It sounds like dramatic work that won't translate into technique, but it can answer technical questions for they even arise. Plus, you'll be a vocal chameleon and wow the crowd.

Lastly, don't forget to have fun. Yes, using a Zerbinetta example is sort of mean, because it's some of the hardest coloratura in the opera canon. But let's not forget, in all the chromatic triplets, that this lady wants to get *laid*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433385513156/Screen%20Shot%202015-06-03%20at%209.57.18%20PM.png)
</figure>

Nymphomaniacal music is much more interesting to sing than trills and weird intervals, no?

>Singers, what are your go-to tricks for practicing coloratura? Let us know the comments below!
