+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-03-02T15:42:00+00:00"
lastmod = "2017-03-16T13:06:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1488475273563/2017-03-02---Summer.jpg.jpg"
publishDate = "2017-03-16T13:06:00+00:00"
related_articles = ["articles/paid-summer-programs-is-it-time-for-a-revolution.md","articles/how-to-make-the-most-of-your-summer-program.md"]
related_companies = ["scene/companies/cosi-centre-for-opera-studies-in-italy.md"]
short_description = "If you decide that you&#039;re not going to get hired based on your work at a summer program, you&#039;ll ironically have a better time doing what you&#039;re meant to be doing at said program. You&#039;ll focus on the work in front of you, and not with building up forced face time with the conductor or bothering the agent over break with banal conversation meant to &quot;impress&quot; them. You&#039;ll be a better artist, and you&#039;ll have that air of confidence - as false as it may be - that makes people want to work with you."
slug = "4-things-you-shouldnt-expect-from-summer-programs"
title = "4 things you shouldn&#039;t expect from summer programs"
+++

## A job

It's one of the biggest pulls for young singers who seek out summer programs: the pay-off gig. Programs are often set up so that participants work with professional conductors and directors, and sometimes a big agent or artistic director will swing by to hear the young singers and pianists in an audition setting. It seems like a recipe for getting work, and it very well may be. 

Yet it's best to assume you won't get a gig out of your time at a summer program. Remember, the directors and conductors you'll work with are also at work - they're gigging, too. You're working with them as colleagues (albeit with a hint of mentorship in these environments), and they're not necessarily spending the rehearsal process making notes of who they'll hire next. Sometimes, they don't even have the power to hire singers - at best, they may be able to recommend your name to a company.

If you decide that you're not going to get hired based on your work at a summer program, you'll ironically have a better time doing what you're meant to be doing at said program. You'll focus on the work in front of you, and not with building up forced face time with the conductor or bothering the agent over break with banal conversation meant to "impress" them. You'll be a better artist, and you'll have that air of confidence - as false as it may be - that makes people want to work with you.

## A mentor

The great part about attending summer programs like the [Centre for Opera Studies in Italy](http://www.co-si.com/) is that the teachers, coaches, and general sources of wisdom are often new to you. Often young artists will pursue a specific summer program precisely because they want to work with a member of the program faculty. It's easy to mythologize some of these people before you meet them; names like Warren Jones, Wendy Nielsen, and Martin Katz can get put on a pedestal, and you may walk into your first session with them thinking that you'll come away with a new full-time professional mentor.

That might be the case, but it just as well might not be; not every student-teacher relationship is the right fit, and it's important to not let yourself get disappointed if you two don't jive. It's definitely important to go to a lesson with respect for your coach, but allow yourself to recognize when the fit isn't right. Reap what you can from your time with these people, but be prepared for the learning opportunities to be finite and contained.

## A lightbulb moment

When you're straddling school and early professional experience, it can feel as though a lightbulb moment comes to you on a regular basis; it's exciting and motivating, no doubt. The more you learn about your craft, and the more experience you gain, the higher the bar becomes for lightbulb moments. This is a good thing, because it means you're growing as an artist.

One of the ways that summer programs imitate professional life is that they may not all offer an eye-opening, wow moment. Sometimes a gig will just happen; you'll come prepared, you'll do your job well, and you'll have fun with the show. But it may not be an experience that will stick with you for decades to come. It doesn't mean your time at the program wasn't worth it; it means that you're getting a taste of the job, and it's really valuable to know how you react not just to the gigs that are life-changing, but to the ones that are just "fine".

## Free time

This one goes for the summer programs that include some fun travel opportunities. When you head to Sulmona, Munich, San Francisco, or Tel-Aviv, it's an enticing thought to imagine spending your time outside of the rehearsal room as a tourist. Professional singers who travel for work will be the first to correct your assumptions about this, and summer programs are a safe environment to learn just what "free time" means when you're in a rehearsal period.

When you're not called to rehearsal, your time isn't necessarily free; you already know this from your own practice habits. Your evenings off will likely include memorization, score study, going over staging you learned that day, practicing, or even nursing your body to stay in good health.

The standard schedule for summer programs is one day off per week, and taking a day trip to Salzburg or Pompeii or Muir Woods is an attractive way to spend it. In our own experience, day trips (which are usually done in groups because it's more fun) end up being a longer investment of time than you anticipate. You might be exhausted at the end of the day - too exhausted to do that scory studying you promised yourself you'd do on the train back. And what if you get a nasty sunburn at the beach? What if a tick bites you on a hike? What if you miss your train home, or you get lost, or you get pickpocketed?

We're not saying "stay home because nothing good comes from exploring". But when you're at a program to focus on your craft, know that your day-off activities can have an effect on your working day. You don't have to be an anti-social hermit, but a summer program is not a place to live for the "weekends". Instead, consider booking your return flight for a few days/weeks after the program ends, so you can have some time to travel, conflict-free.
