+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-11-10T19:30:00-07:00"
lastmod = "2016-07-10T16:37:00-06:00"
postamble = "Do you have your own tips for being a pro at note-taking? Leave them in the comment section below!"
preamble = "One mark of a professional opera singer is his or her ability to take notes. At the end of a rehearsal, a singer may have a collection of notes from music staff, diction coaches, their teacher, even an enthusiastic donor or two. Taking notes \"well\" isn't necessarily about being a polite professional and not taking anything personally; it's about what a singer does next.\n\nFrom my seat as a coach, I notice when I give notes again and again. There are lots of reasons for that (mostly the hazards of multitasking), and it's not a three-strikes-you're-out, unforgivable sin. Often, I give repeat notes because singers forget to remember, or they lack a technical plan for incorporating a note into their singing. This is where a system can come in handy."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468190272744/2016-07-10---Notebook.jpg.jpg"
publishDate = "2015-11-11T10:04:00-07:00"
related_articles = ["articles/how-to-lead-your-pianist.md", "articles/how-to-play-for-singers.md", "articles/kristen-seikaly-on-how-to-learn-a-role.md", "articles/6-learn-language.md", "articles/5-ways-to-build-your-rhythmic-chops.md", "articles/singable-text-when-composers-make-it-tricky.md", "articles/4-ways-to-give-notes-still-be-liked.md", "articles/3-tips-for-being-a-respectful-voice-coach.md"]
short_description = "One mark of a professional opera singer is his or her ability to take notes. At the end of a rehearsal, a singer may have a collection of notes from music staff, diction coaches, their teacher, even an enthusiastic donor or two. Taking notes &quot;well&quot; isn&#039;t necessarily about being a polite professional and not taking anything personally; it&#039;s about what a singer does next."
slug = "4-steps-to-taking-fixing-notes"
title = "4 steps to taking (&amp; fixing) notes"

+++
## Figure out what you're being asked to do.

Getting a note like "don't drag" and "add a portamento" are fairly straightforward; if a conductor or coach asked for either of these things, you'd know that you should speed up and add a portamento. Demonstrations are always handy, too; if the maestro is literally showing you what he or she wants, listen carefully to the details, and take stock of what's different from how you were doing it.

Other times, conductors can be vague, giving you real-time notes like "look at me!" or "more fire!" or "this is still a recit!" There's clearly a problem, but if you're not sure what they mean, don't be shy about asking. Step #1 is about collecting information that you can use in step #2.

## Decide what that means for you, technically.

The conductor wants you to hold that note for longer? That's about your breath. The diction coach wants the correct vowel? Perhaps an adjustment in sound placement. The director wants you to lie down while you're singing? That's something you may need to practice on your own.

>Be diligent, and remember that repetition is your best weapon against bad habits.

Before you can incorporate a new request into your singing, you need to find out what it will take to accommodate it. Muscle memory can be a powerful thing, but you can adjust your habits with conscious and educated efforts. As a coach, I'm happiest when a singer is willing to try the new thing right then and there (provided there's reasonable time to do so). I get to hear what it sounds like, and the singer can get a sense of how much work it'll take. Which takes us to step #3...

## Know how quickly you can adapt to the note.

This one is up to you, and it depends mostly on the technique involved in fixing a note. If it's something you can change on the spot, that's ideal. If you have to spend some time in a practice room, there's no harm in politely saying either that you'll take it to your teacher, or you'll have it fixed for the next rehearsal. Speaking of which...

>It's true that you won't be able to please every note-giver all the time, but if I know you're thinking about it and trying, that counts for a lot.

## Live up to your promise to fix that note.

That's basically it. If you're still having trouble, ask more questions. It's true that you won't be able to please every note-giver all the time, but if I know you're thinking about it and trying, that counts for a lot.

Like I said, muscle memory is a powerful thing. When you're learning staging, watching the conductor, and dealing with new props, your lines can go on auto-pilot, and new music changes are the first to go out the window. Be diligent, and remember that repetition is your best weapon against bad habits.