+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-06-14T11:19:00-04:00"
lastmod = "2017-08-23T17:02:00-04:00"
postamble = "What are your tips and discoveries about singing up high or through the passaggio? Let us know in the comment section below!"
preamble = "No matter what voice type you are, it’s fair to admit that plenty of your most applause-worthy moments come with high notes. Fast high notes, loud high notes, entire-lungful-of-air high notes - they’re what we’re all waiting to hear. There, I said it. When it comes to producing great sound at the top of your range, I leave that process to the singers and their voice teachers. But I can profess to hearing a curious trend among singers as they’re mastering those big high note moments. Frankly, singers don't sing the notes *around* their high notes."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503522165637/2017-08-23---High-Notes.jpg.jpg"
publishDate = "2015-06-15T08:00:00-04:00"
related_articles = ["articles/how-to-lead-your-pianist.md", "articles/how-to-really-learn-a-song.md", "articles/on-pianists-those-vicarious-opera-singers.md", "articles/5-ways-to-build-your-rhythmic-chops.md", "articles/pianists-3-tips-for-sounding-like-an-orchestra.md", "articles/quick-tips-the-rolled-r-test.md", "articles/vibrato-all-the-reasons-why.md", "articles/4-weird-questions-for-opera-singers.md"]
related_people = ["scene/people/brian-mulligan.md"]
short_description = "No matter what voice type you are, it’s fair to admit that plenty of your most applause-worthy moments come with high notes. Fast high notes, loud high notes, entire-lungful-of-air high notes - they’re what we’re all waiting to hear. There, I said it. When it comes to producing great sound at the top of your range, I leave that process to the singers and their voice teachers. But I can profess to hearing a curious trend among singers as they’re mastering those big high note moments."
slug = "4-secrets-for-better-high-notes"
title = "4 secrets for better high notes"

+++
### Start early

I get the logic. Singers want to tread lightly before expounding energy on a high note, but doing this often has the opposite effect. Here's a small section of Don José's aria from _Carmen_:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548689353/media/2019/01/Jose2.png){{% /md %}}</figure>

At "je m'enivrais," the instinct can be to save steam; the result can be a mix of crooning with an explosive high A-flat. It doesn't have to be like that, but I understand that it takes a lot of trust to sing through the phrase. It can feel nonchalant, not energized enough; one of the universal things I've learned as a coach is that sound begets sound. Without air moving before a high note, it's probably similar to try to drive fast by going from parked to slamming on the gas. It's not sustainable, and it's not pretty. A tenor who trusts that finding optimal vowels and placement for "je m'eni..." will have the tools to find the "...vrais" that he wants.

### You're not done yet

Understandably, singers put a lot of concentration into that high A or C or F; yet, they don’t always _sing_ the notes leading to and from it. When I say they don’t sing, I mean just that; the resonant space has changed, the vibrato disappears, and the body isn’t engaged in the same way. In short, the legato is gone. I think singers do this harmlessly, out of a good place; they’re thinking about that high note, because it’s not easy. Here’s an example:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548689393/media/2019/01/Tosca.png){{% /md %}}</figure>

In “Vissi d’arte,” Tosca starts harmlessly with short phrases in her low-to-middle range; seeing that high A-flat suddenly appear can tempt a soprano into zeroing in on that one note. The slow descent of this phrase suddenly becomes more of an attack and decay, and instead of the voice carrying through all four notes unabashedly, the A-flat gets lots of spotlight, and the lower notes become less important. Add to that the vowels \[e\] and \[i\] on the way down, and that’s when the singing stops.

In the case of Tosca, she has to return to that A-flat shortly after the first one. That’s tiring, if you’re not thinking about the stuff between those two high notes. I figure it’s much more difficult to blast out an A-flat, relax, and then blast another one, than it is to concentrate on consistency throughout all four notes. I’m not saying either option is easy, but the latter makes more sense, and sounds _way_ better.

### It's not actually about the high C

More exemplary Puccini, from _La bohème_:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548689441/media/2019/01/Boheme.png){{% /md %}}
</figure>

Traditionally, there's a fermata added above the option (hah!) high C, and the tenors I like usually portamento down to the B-flat, which is wise from technical and musical perspectives. Basic music theory tells us that the C is a passing tone leading to the B-flat. Sure, I want the big grand high C, but it's about _singing_ the B-flat. A portamento is a good way to track the consistency of your sound production between the two notes; the real money of this phrase is in guaranteeing enough resonant room for the B-flat. The C is all foreplay.

Some tenors will kill me when I say this, but the same rule applies to things like Tonio’s aria from _La fille du régiment_:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548689479/media/2019/01/Tonio.png){{% /md %}}</figure>

Look. If you’ve got that many high Cs, that’s not something that needs extra help from me. Congrats! I do know, though, that this aria is a lot less tiring if that passing A on the way down gets some attention too. This is a tricky example; on the one hand, a passage like this is not one in which to add weight to the voice, by asking them to “make sure you sing every note!” On the other hand, too much relaxation (dropping, really) between extremely high singing has a quickly diminishing return when it comes to sound quality of your high notes. I think it comes down to this: that passing A I’m talking about, if you were to stop on that note mid-bar and sustain it, would it be free to vibrate?

### Technique is beautiful

Baritone example, coming right up. From _Rigoletto_:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548689520/media/2019/01/Rigoletto.png){{% /md %}}</figure>

Passaggio, hello! Like the other excerpts, the point is to leave room for every note, no matter how small and harmless it may look. This aria is a good example of how smart technique can feel counterproductive; Verdi's so great at writing for the voice that he uses technical needs to create beauty. Relentless legato, enjoying vowels on every note, gives that elastic, visceral vocal sound to which humans constantly respond.