+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-07-10T15:20:00-04:00"
lastmod = "2016-07-20T10:48:00-04:00"
preamble = "Like in any industry, there's only so much one can learn in school. In conservatories and post-secondary music programs, musicians hone their technique and prepare as best they can for their potential career as a performer; yet there are a few details that simply don't translate well between academic and professional environments. We're big advocates of schools and institutions, and it's important to know what they can and can't offer aspiring musicians. A few myths, debunked:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468183302684/2016-07-10---Rainbow.jpg.jpg"
publishDate = "2016-07-10T17:59:00-04:00"
related_articles = ["articles/5-tips-for-university-auditionees.md","articles/music-school-auditions-4-tips-for-parents.md","articles/psychology-audition.md","articles/singing-in-english-3-reasons-why-no-one-can-understand-you.md","articles/a-singers-todo-list-4-tasks-to-keep-you-focused-this-year.md"]
short_description = "Like in any industry, there&#039;s only so much one can learn in school. In conservatories and post-secondary music programs, musicians hone their technique and prepare as best they can for their potential career as a performer; yet there are a few details that simply don&#039;t translate well between academic and professional environments. We&#039;re big advocates of schools and institutions, and it&#039;s important to know what they can and can&#039;t offer aspiring musicians. A few myths, debunked:"
slug = "4-myths-from-music-school"
title = "4 myths from music school"
+++

## You need five arias for your audition package

You don't! But there's some logic to the widely accepted "magic number" of putting five arias on your list. A list of five arias gives you the chance to sing in Italian, French, German, English, and something else; and with five arias, you can show off 1) high notes, 2) coloratura, 3) stellar legato, 4) serious acting chops, and 5) comic relief. But really, only under extraordinary circumstances would an audition panel ask a singer for five selections. And in our own experience, we've never encountered an audition panel who deems a singer unfit precisely because they only offer two or three arias.

It's not that the "magic number" is too high, and if you truly have five arias that you can knock out of the park, go for it. Often young singers have, say, three arias that they actually feel comfortable singing, yet they add two more to their list in order to follow their mentors in school. Of course, Murphy's law states that an audition panel *will ask* for one of those less desirable filler arias, which likely means you'll not sing as well as you could.

Auditions are about quality, not quantity. Wow them first, then start to add repertoire to your list.

## You'll always get feedback about your work

Schools, and school-like institutions like young artist programmes, are built around the idea of offering feedback. Young singers hear from their teachers and coaches on a regular basis about the sound they're making, their language skills, their general musicianship; the singers are able to constantly check in with their technique, and there's a consistent frame of reference for their progress.

In the professional world, feedback is centred on what needs to be fixed. It's not necessarily feedback about your technical progress or the subtleties of vowel modification; music staff are correcting errors, making sure singers are intelligible, and finding a sweet spot of acoustic balance. The feedback that young singers get on a professional gig can feel like nothing but a list of problems, and there's very little offered on the side of positive reinforcement.

The good news is that if you're singing a gig and you get very little feedback about your work, that's likely a good sign. The bad news is that once you're out of academic or training-oriented environments, *you* have to be in charge of your own progress. Young singers should recognize not only what they could be doing better, but more importantly, they need to recognize when their work is good (and act as their own cheerleader).

## It matters what school you get into

Yes, it's true that a Juilliard student has more opportunity to make professional connections than a student at the University of Manitoba. Choosing a city is certainly part of choosing a school, and the bigger the metropolis, the more job leads there are at arm's reach. But in the world outside of schools, your *alma mater* doesn't really say much about you as a singer.

What matters is what you can learn from the teacher you choose. If they're an excellent teacher that no one has ever heard of, fantastic. Great technique can be taught anywhere in the globe, and if you don't have to pay to live in New York while you're at it, that's a bonus. If your teacher isn't, say, Marlena Malas, you may have to do some more hustling of your own for professional connections. 

But what really counts is what you bring to an audition, and what you bring to rehearsal. Solid technique is the obvious must-have, and it will speak for itself once you graduate from school and leap into the big pool of working singers. A fantastic audition by a singer who went to I've-Never-Heard-Of-That-School University is still fantastic, and a mediochre audition from a Curtis grad is, of course, still mediochre.

## Your sound is the most important thing

It's not! It's very important, but opera in the 21st century demands much, much more than endlessly beautiful sound. It's becoming more common in post-secondary schools, but building skills in business and entrepreneurship can be hard to come by in a school setting. As a professional singer, the product you'll be selling is much more than your voice; it's *you*, the pleasant person in rehearsal, the punctual performer, the creative and self-sufficient artist.

With all the great voice programs and young artist internships, well-trained voices are plentiful. Opera really does come down to the instrument, but with for all the great working singers today, the next challenge is presenting themselves as savvy, organized, bold artists who happen to have fantastic technique.

>What are some more myths from music school? Leave your thoughts in the comments below, or get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).
