+++
author = ["authors/jenna.md"]
categories = ""
date = 2017-08-10T22:07:00Z
lastmod = "2017-11-22T16:36:00-05:00"
preamble = "Singers have a better handle than most when it comes to mastering foreign languages. Rolled R's, umlauts, they do it all. For singers whose mother tongue is English, there are a few common traps that come up when they're asked to sing in any of the other common operatic languages. In the name of commiseration, and even offering a few tips, we've got our top four foreign-language tongue-twisters:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502457510582/2017-08-11---Tongue.jpg.jpg"
publishDate = "2017-08-11T09:21:00-04:00"
related_articles = ["articles/3-ways-your-english-is-showing.md", "articles/singing-in-english-3-reasons-why-no-one-can-understand-you.md"]
short_description = "Without enough nasal quality in those very particular French vowels, you&#039;ll sound like an awkward American, speaking Italian with a bad head cold; go too far with your nasality, and you can be accused of making a gross mockery of what French sounds like to non-French people."
slug = "4-foreign-language-challenges-for-singers"
title = "4 foreign language challenges for singers"

+++
## "Gli" in Italian

For a Romance language that's fairly straightforward, the confusing sounds of the word "gli" come as quite a surprise. It's one of the words that mean "the" in Italian, and the pesky combination of G and L show up not just in "gli" itself, but in other combinations of articles like "agli", "quegli" and "dagli".

The word is correctly prounounced by _almost_ saying a G (but not actually), at the same time as _almost_ saying an L (but not actually); if it comes out sounding like the beginnings of a dry heave, you're on the right track.

If you're hoping for tricks for mastering the art of "gli", we're likely to disappoint you here. The only tip we can offer is to think beyond the "gl-" part, and remember that the \[i\] vowel that follows will be what keeps the word easy to sing (and what keeps your gag-reflex from taking over the whole process).

## Ich-lauts in German

It shouldn't be such a fine balance, this pleasant little consonant that reads as the letters "ch", often following vowels like \[i\], \[ɛ\], \[e\], and \[ü\]. In the International Phonetic Alphabet, it loks like this: \[ç\]; its counterpart is the ach-laut, which is the more gutteral "ach!" sound that's stereotypical of German and Arabic, and it looks like this: \[x\].

It's easy to fall into a few traps set by ich-lauts. Some singers take a shortcut and just turn the "ch" into a \[k\] sound; others cheat a bit and replace it with a "sh", as in "fish" (which is often done to get more volume out of the sound - a noble reason, but it still doesn't make it accurate).

The closest thing we have in English to the German ich-laut is the word "huge"; say the word slowly, and you can feel how the tongue creeps up towards the front hard palate, just behind your front teeth. When you sing an ich-laut, it should be a smooth transition from the vowel that preceded it; if you feel like you're chewing or choking on the "ch", your vowel may be sounding a bit too far back.

## French nasal vowels

Without enough nasal quality in those very particular French vowels, you'll sound like an awkward American, speaking Italian with a bad head cold; go too far with your nasality, and you can be accused of making a gross mockery of [what French sounds like to non-French people](https://youtu.be/-r7dveDEv-I).

There are four basical nasal vowels in French: \[œ̃, õ, ɛ̃, ã\] They're indicated in the International Phonetic Alphabet as tildes over four vowels that are fairly easy to recognize: \[o\] as in "bientôt" in French or "tot" in German; \[ɛ\] as in "fête" in French or "bed" in English; \[a\] as in "chat" in French or "amore" in Italian; and \[œ\] as in "coeur" or "fleur" in French. Note: there's a handy tool in the sentence, _Un bon vin blanc_ ("A good white wine"), which incorporates all four nasal vowels: \[œ̃, õ, ɛ̃, ã\].

It can be fun to practice each vowel slowly, sustaining it first in its non-nasal form, and then in the same breath, trying to tip the vowel forward into the nose. It's kind of tricky to do, but super fun once you get the hang of it. The most fun one is \[o-õ\]; you start with the o-sound in "Minnesota" (if said with the proper accent like in _Fargo_), and you end up with the nasal o-sound like in the awesome song from _The Little Mermaid_, "Les poissons".

<figure data-type="video">{{% md %}}<iframe width="896" height="504" src="https://www.youtube.com/embed/UoJxBEQRLd0" title="Rene Auberjonois - Les Poissons (From "The Little Mermaid")" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}  
</figure>

## Slavic stuff

Czech has that infamous "ř" sound (as in Dvořàk), and Russian is known for its impossible clusters of consonantns ("vgl..." "shch..." etc.). For many non-Slavs, these languages can be tongue-twisting adventures that at worst, cause involuntary gagging and at best, sound like recordings of people speaking English, played in reverse.

We can offer one broad-reaching tip: these languages, when sung, are much brighter than you think. Czech in particular is full of Italianate vowels, and the consonants sit more forward as a result; the clusters of consonants in Russian that feel counterintuitive to singing are actually quite lovely to say, when given forward resonance and a consistent supply of air supporting them.

Beyond that, get thee to a specialist.

> Readers, what are your top picks for hard-to-pronounce sounds in foreign languages? Let us know in the comments below!