+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-05-18T21:24:00-04:00"
lastmod = "2017-05-25T23:17:00-04:00"
preamble = "English speakers, this one's for you. You might have already discovered that singing in your native language can be trickier than expected, sometimes even more than singing in a language you don't speak well. When you're in the rehearsal room getting note after note about your unintelligible English text, it can be disheartening to discover that spitting out more consonants doesn't always solve the problem.\n\nWe all have habits in our speech, and singing has a way of exaggerating those habits. We've narrowed down a few "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495158674046/2017-05-19---Language.jpg.jpg"
publishDate = "2017-05-25T23:13:00-04:00"
related_articles = ["articles/singing-in-english-3-reasons-why-no-one-can-understand-you.md","articles/quick-tips-the-rolled-r-test.md","articles/4-tips-for-when-there-are-too-many-notes.md"]
short_description = "There are some words that aren&#039;t actually helped by being overly literal with the pronunciation. The T&#039;s in words like &quot;better&quot; and &quot;getting&quot; have a natural tendency to sound more like D&#039;s; depending on how they&#039;re set, the sung versions of these words come out more clearly by keeping these &quot;lazy&quot; D sounds. An airy T sound can actually obscure the sound of the word, since it&#039;s unfamiliar to the ear."
slug = "4-english-language-habits-that-make-a-singers-life-harder"
title = "4 English language habits that make a singer&#039;s life harder"
+++

## Silent final letters

When we speak, words like "awake" or "dog" or "stop" or "rent" often have a final letter that's basically inaudible. Our lips and tongue are at the ready to make that final K or P or T sound, but in everyday speech, North American English speakers tend to get lazy with those final phonemes.

Sung text is often stretched out the natural rhythm of speech - or at least it's slowed down - and listeners are usually sitting farther away than they would be in an average spoken conversation. So, be aware of your innocent habit to avoid final sounds. Take the words, "innocent habit", for example. In speech, those T's are insinuated sounds; in song, they need some care, so that listeners don't hear, "innocen habih". It will likely feel like you're saying "dog-uh" instead of "dog", "stop-uh" instead of "stop," etc., but that's alright.

## Unnecessary homophones

A great example is in the words "are" and "our". We generally pronounce those two words similarly in speech, but with "our", we have a second option, to say it similarly to the word "power". In the slow pace of sung text, adding that little diphthong to distinguish between two words that sound alike can help keep an audience listening to you - in a good way. If there's ambiguity in the word you've sung, listeners can start to zone out, trying make sense of what you said three bars ago.

## Neglected tenses

Like those silent final letters, we're often lazy about our verb tenses. The difference between "walks" and "walked" can be pretty major, but it's easy for North Americans to make both options sound simply like, "walk".

That final S in the present tense, and final T-sound (in this case) for the past tense, should take an extra jab of support from you at the end of the word. It's also a bonus if we get to hear either "walked" or "walks" with a nice, loud K sound in the mix.

## Overdone consonants

There are some words that aren't actually helped by being overly literal with the pronunciation. The T's in words like "better" and "getting" have a natural tendency to sound more like D's; depending on how they're set, the sung versions of these words come out more clearly by keeping these "lazy" D sounds. An airy T sound can actually obscure the sound of the word, since it's unfamiliar to the ear.

>Singers, what are your secrets to singing intelligibly in English? Let us know in the comments below!
