+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-03-27T11:55:00-04:00"
lastmod = "2018-06-23T16:33:00-04:00"
preamble = "One of the best part about opera is that it can be a lifelong practice of discovery. Even some of opera's best-loved arias come with hidden layers of meaning, that sometimes take a while to recognise. We've compiled a few of our favourite arias, and why they're commonly misunderstood."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490713132594/2017-03-28---Misunderstood.jpg.jpg"
publishDate = "2017-03-28T11:23:00-04:00"
related_articles = ["articles/4-awesome-rage-arias-that-arent-the-queen-of-the-night.md","articles/5-important-roles-who-dont-get-an-aria.md","articles/8-contemporary-roles-to-covet.md","articles/more-operatic-roles-for-women-a-pledge.md"]
short_description = "Daughters have been making pouting faces and puppy eyes at their fathers to get what they want for centuries, and Puccini encapsulates the strategy perfectly. &quot;Babbino&quot; is like saying &quot;Daddy&quot;, or even &quot;Daddykins&quot;, and to sing it on top of the lush tune is the equivalent of crocodile tears. &quot;I&#039;ll throw myself off a bridge&quot;, Lauretta paraphrases (twice), if she doesn&#039;t get her way. Ugh."
slug = "4-arias-their-common-misconceptions"
title = "4 arias &amp; their common misconceptions"
+++

## "O mio babbino caro"

This infamous aria from Puccini's *Gianni Schicchi* is one of the most popular hits from the entire operatic canon. It's got a stunning, soaring melody that includes more than one opportunity to hang out on a lovely high A-flat. If you ignore the words, it sounds like a lush declaration of love, be it romantic or paternal; but here among the opera lovers, we can't ignore the words.

"O mio babbino caro" (or "O mio babs", as it's often nicknamed) is supposed to be *funny*. The opera is a comedy, and Lauretta sings this aria during a bit of an adolescent fit over wanting to marry her boyfriend, Rinuccio. Daughters have been making pouting faces and puppy eyes at their fathers to get what they want for centuries, and Puccini encapsulates the strategy perfectly. "Babbino" is like saying "Daddy", or even "Daddykins", and to sing it on top of the lush tune is the equivalent of crocodile tears. "I'll throw myself off a bridge", Lauretta paraphrases (twice), if she doesn't get her way. Ugh.

It's worth watching the compact *Gianni Schicchi* in its entirety, to get the full effect of "O mio babbino caro" amid the hilarious tale of a gold-digging troupe of vultures, lurking around the freshly deceased body of a wealthy family member.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/V0BXUZsSCpw?start=1322" frameborder="0" allowfullscreen></iframe>
</figure>

## "O beauty, o handsomeness"

Ah, villains. The best ones are rarely two-dimensional. In Britten's heartbreaking *Billy Budd*, Billy makes a dangerous enemy of John Claggart, master-at-arms aboard the *Indomitable*. Billy is one of the new sailors brought aboard the ship, and he brings with him an innocent, sunny, trusting attitude towards the dreary life at sea. Claggart catches Billy in a brief outburst of violence with another sailor, and takes the opportunity to vilify him, and accuse him of inciting mutiny on board the ship.

This aria isn't misunderstood *per se*, but there are facets of meaning in it which often go ignored, or unseen. 

Beyond the first layer of Claggart - the military type who sees "justice" as a black-and-white thing - are the layers of self-hatred and self-denial. People filled with negativity and hate certainly don't like it when they meet someone who's full of optimism. And people who are closeted homosexuals certainly don't like meeting someone to whom they're attracted, but can't have. Claggart's response to this young man, a good, beautiful person, is to destroy him; it's easier to do that than acknowledge his own complicated circumstances. 

The result: a blackly hateful aria about getting revenge on wrongdoings that are largely in Claggart's own head. Just listen to these words:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/A1lVBfqQyjs?start=3720" frameborder="0" allowfullscreen></iframe>
</figure>

## "Deh vieni, non tardar"

In the final act of Mozart's *Le nozze di Figaro* comes the most elegant - and most risky - moment of trickery in Beachmarchais' classic story of classism and sexism. Susanna sings "Deh vieni, non tardar" ("Oh come, and don't delay") while waiting for the Count to meet her, as per their secret arrangement earlier in the day. The tryst is part of a complicated plan to trick the Count into sleeping with his own wife (for once), the Countess; yet Susanna's fiancé, Figaro, has gotten some bad information about the plan, and he has followed Susanna, thinking that she's actually going to cheat on him with her creepy boss.

*Anyway*. When Susanna sings this aria, she knows Figaro is spying on her. It's a seductive aria, sung in a way that's much more regal, à-la-Countess, rather than the chirpy, sparkly music we've already heard from Susanna. 

What's often misunderstood about this aria is that it's no simple seduction. Susanna is doing a sort of double-fake thing; she's definitely pretending to be the Countess, but the sexiest part of the aria is that she's truly singing it for Figaro (whom she's pretending not to notice). 

The complexity piles on for sopranos who sing this beautiful bit of Mozart. Should you exaggerate it, and play up the mistaken identity? Should you be sincere, and send it right to Figaro? Sopranos, whatever you do, make it beautiful.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/T7i4z3HtE_U?start=9709" frameborder="0" allowfullscreen></iframe>
</figure>

## "Je veux vivre"

Everyone knows the story of Romeo and Juliet. Gounod's operatic take on Shakespeare does the story justice, and his Juliette gets an exciting entrance aria in "Je veux vivre dans le rêve.." ("I want to live in the dream..."). Juliette's impending arranged marriage to Paris is definitely on her mind, and on the surface, her aria may seem like she's making the case for the single life. *I just want to be free!*, she seems to say. And she does say that, but there's a motivation there that's easy for us in the 21st century to forget. 

The reason that Juliette's marriage to Paris is set up for the near future is because, very recently, she had her first menstrual period. Yikes. We likely remember more easily that both Juliette and Roméo are young, simply teenagers; but it's another detail entirely to think about how families decide when their daughters are ready to be married. Historically, this inevitable biological trait of females is a handy little alarm clock that lets people (men, frankly) decide when a girl becomes a woman, and therefore is all set to be married off.

It changes the impact of an aria like "Je veux vivre". The subtext of "I want to be free!" becomes much more desperate, and Juliette's nostalgia for her youth feels much sharper. She could be 12 years old, for all we know, making her rightly terrified about what's to come in her new life as a bride. Even the way Gounod writes her flashy introduction, and those insistent grace notes throughout the waltz, suddenly sound less giddy, and more *stressed the &#@! out*.

We're not convinced that the production below takes into account the biology of teenaged girls - what say you, readers?

<figure data-type="video">
<iframe width="640" height="360" src="https://www.youtube.com/embed/dIBFtNKCceU" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</figure>

>Readers, which are your favourite misunderstood arias? Let us know in the comments below! Primary image: [Véronique Debord-Lazaro](https://www.flickr.com/photos/debord/4932655275/in/photolist-8vT9yB-RwrzYU-RqoiAV-7iyNYi-6637Tb-SNrYLw-RC7Fqz-SKGfGH-SasG5V-7ERUx7-SZPkdW-SPf7CR-8BuMYR-4VwGmg-qPrj1L-RSMEi5-bTQwf4-RYLkab-SwXgUf-RJidXW-nh9E1M-RMtapr-REiixL-6W49Xi-czAVYd-5hJgbT-dYwzsm-5yViti-dco18n-SkdAzZ-9m1H8w-6PyW5a-aA9usm-SgJEx3-SCoZP3-QVrSzD-9344Qi-RX69E7-ddyx4t-Rwathq-4Bom3q-7Er6af-7k5o9D-cRMpS-9oGwvq-7vB7fR-7JnRdX-5huQJc-kqcqCx-rrv51P) via [Flickr.](https://creativecommons.org/licenses/by-sa/2.0/legalcode)
