+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2016-09-28T12:09:00+01:00"
lastmod = "2016-09-28T15:23:00+01:00"
preamble = "There's no shortage of spectacular, star-quality singers whose first language is English. Like everyone else, they hone their foreign language skills so that they sound like a native speaker in Italian, German, the whole operatic gamut. \n\nThere are idioms in every language, and that's what we hear when someone speaks with a foreign accent. It's handy for singers to identify some of these habits and idioms that keep them from sounding comfortable in a non-native language. So, we've identified three big linguistic tells for North American English speakers, and how to keep them away from your foreign language mastery."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475066143167/2016-09-27---America.jpg.jpg"
publishDate = "2016-09-28T14:53:00+01:00"
related_articles = ["articles/singing-in-english-3-reasons-why-no-one-can-understand-you.md","articles/quick-tips-the-rolled-r-test.md","articles/4-foreign-language-challenges-for-singers.md"]
short_description = "There are idioms in every language, and that&#039;s what we hear when someone speaks with a foreign accent. It&#039;s handy for singers to identify some of these habits and idioms that keep them from sounding comfortable in a non-native language. So, we&#039;ve identified three big linguistic tells for North American English speakers, and how to keep them from foreign language mastery."
slug = "3-ways-your-english-is-showing"
title = "3 ways your English is showing"
+++

## Secret schwas

When you listen to other languages, it's fascinating to pay attention to their "umm" word, that sound people make when they're thinking. In American English, we say "umm," or "uhh," and in Italian, it's more of an "eh," or "ih" (anywhere between [ɛ] and [i], really). In French, they have that lovely "euh" sound (take your pick between [œ], [ø], or [ə]), that's slightly nasal and seems quintessentially *français*.

All this is to say that the "umm" word is often a grand indicator of the general soundscape of a language; it's the default, unchecked sound of a native speaker. In American English, that default vowel is a dull schwa.

When English singers sing in Italian, for example, it can be easy for schwas to creep into words like "andare" or "vivere". Instead of two great "ah" vowels in "andare," sometime you'll get "uhn-dare" or something similarly lazy. "Vivere" becomes "Vee-vuh-re," reminiscent of the charming meme, "Amrrca." This is about vague vowels on weak syllables, which is a natural habit of ours. Fortunately, the solution is familiar: slow practice, and attention to detail.

## The wrong L

We have two versions of the letter L, the kind used in the word "lip," and the kind in the word "long." While you mumble those two words to yourself, notice the difference in what your tongue does. 

There's something about singing that exaggerates this harmless, subtle tendency of North Americans. When singers default to the "long" L, it can sound swallowed, or like someone doing an exaggerated Russian accent. So in the Italian word, "palpitare," pay attention to where that L sits. If it falls backwards, like that Russian-esque L, it can darken the vowel, kind of like what happens in the English word, "calm." 

The letter L can actually be a good way of checking your vowel placement, kind of like our [quick rolled R test.](/quick-tips-the-rolled-r-test/)

## Two-faced Rs

The topic of rolled Rs can be touchy for singers. Not everyone can do it, and some people think it's [genetic](https://en.wikipedia.org/wiki/Talk:Dental,_alveolar_and_postalveolar_trills#Recessive_gene). Though it's not part of our everyday language in North America, plenty of English speakers can roll their Rs; the giveaway in this instance is in the microseconds just before the roll begins. Instead of a seamless transition from vowel into rolled R, the English speaker adds in a tiny [American R](http://pronuncian.com/pronounce-r-sound/) to aid in the rolling.

With an Italian word like "arresta," it's all about what happens between the first [a] and the first [r]; if your vowel is in a good place, the rolled R should be easy and available to you, without the initial crutch of an American R. It's similar to the letter L, where choosing a backward-sitting consonant can darken the preceding vowel; here, if the vowel is too dark, the rolled R will be difficult. 

It's decidedly tricker in words like "parlare," where there's a cluster of consonants that need to be taken care of. Of course, if both the L and the R are forward, rather than getting comfy in the default place of American English, "parlare" is pretty easy to say.

>Singers, what do you find are telltale signs of non-native language, and how do fix them? Let us know in the comments below!
