+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-09-14T12:34:00+01:00"
lastmod = "2016-09-14T17:00:00+01:00"
preamble = "It's completely true: sometimes, opera is boring.\n\nThe boring thing may be the show itself, or the singers onstage, or the fact that you didn't want to go to the opera tonight in the first place, or that you've already seen this opera a bunch of times and you're bored with the story.\n\nOf course, when boredom sets in, one of the worst places to be is stuck in a dark theatre, made to keep quiet, without the opportunity to hover a mouse over the proscenium, like it's a giant laptop screen, to see for how much longer this thing will go on.\n\nBut the more you know about something, the more it can hold your interest. We're not offering you a crash course in opera appreciation; rather, we're invested in your coming home from any night out at the opera feeling like you've been made to think."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473864460658/2016-09-15---Bored.jpg.jpg"
publishDate = "2016-09-14T16:07:00+01:00"
related_articles = ["articles/tales-from-the-score-peter-grimes.md","articles/undergrad-degrees-why-youll-use-that-theory-class-after-all.md","articles/the-case-for-music-education.md","articles/4-tips-for-when-there-are-too-many-notes.md","articles/tales-from-stage-management.md"]
short_description = "Of course, when boredom sets in, one of the worst places to be is stuck in a dark theatre, made to keep quiet, without the opportunity to hover a mouse over the proscenium to see for how much longer this thing will go on."
slug = "3-ways-to-fight-boredom-at-the-opera"
title = "3 ways to fight boredom at the opera"
+++

## Get your definitions down

If an opera seems to be nothing but boring aria after boring duet, you may indeed be right. That's when it helps to start considering the opera like a specimen, something for you to take apart and figure out what makes it tick (or not).

You might be listening to [*bel canto*](https://en.wikipedia.org/wiki/Bel_canto) opera, or [*verismo*](https://en.wikipedia.org/wiki/Verismo_(music), or maybe it's a *Singspiel* or an operetta. It sounds dubious, but knowing stuff about opera forms and styles can be a huge cure for boredom. 

If you're at something that's *bel canto*, for example, know a) the singers are expected to show off, b) there's a basic *slow section > medium section > fast section* recipe to the arias, and c) the singers often write their own flashy sections, to maximize what they do best.

Or, if you're watching Verdi, note that you're watching a later evolution of *bel canto*. His operas are a bit heftier than Rossini's, for example, and instead of a simple series of musical numbers, Verdi began to connect large chunks of music and drama, so they flow more naturally. 

Wagner did this, too, and he took the concept to extreme (and extremely awesome) lengths. He wrote *Leitmotifs*, which are recurring themes for people or things in his shows. Men, women, places, swords, they all have *Leitmotifs*, and they pop up throughout his operas. In *Tristan und Isolde*, there's even the [Tristan chord](https://en.wikipedia.org/wiki/Tristan_chord) to keep your ears interested.

You don't have to do pre-show homework to pick out this sort of thing. Listen closely to what's happening with the music, even if it means zoning out from what the singers are saying. Even the act of listening for changes in the music, and comparing the slow-medium-fast recipe to each number, can be more engaging than simply sitting and waiting the whole thing out.

## Put the opera in context

Operas aren't created in a vacuum; like paintings and plays, operas come from legends, mythologies, holy books, from Shakespeare, Goethe, Voltaire, Beaumarchais, and 1000s more. There's even some overlap between the stories and characters; *La bohème*, *Rent*, and *Moulin Rouge* share a common source in Murger's [*La Vie de Bohème*](https://en.wikipedia.org/wiki/La_Vie_de_Boh%C3%A8me), as do *Le nozze di Figaro* and *Il barbiere di Siviglia* in Beaumarchais' [Figaro plays](https://en.wikipedia.org/wiki/Pierre_Beaumarchais#The_Figaro_plays). Wagner wrote an opera based on the legend of [Tristan and Isolde](https://en.wikipedia.org/wiki/Tristan_and_Iseult), and Donizetti's opera *L'elisir d'amore* makes a joking reference to that same legend. Mozart hung around with Masons, which may help to make a bit more sense out of the plot of *The Magic Flute*.

The neat thing for you, the bored opera-goer, is that you get a chance to learn something new about the characters in a story you may already know. You might find it pretty neat to hear Shakespeare's *Othello* sung in Italian, or to hear *Romeo and Juliet* in French. Even cooler is listening for a composer's opinion on a character. Characters like Don Juan, Cleopatra, Agamemnon, Ophelia, Don Quixote, Salome, and Jack the Ripper exist outside of their operatic versions, and it's completely fascinating to hear how a composer turns them into music. 

Britten's operas are great for this; his operas tells you what he thinks all the characters sound and act like. In his Shakespeare-based *A Midsummer Night's Dream*, he writes really different music for the fairies as he does for the human beings, and it's a curious thing to try and pick out how he gets the effect.

There are also tropes about different voices, and the roles they have in opera. Higher voices are often younger/nicer/more innocent characters; low-voiced men and women tend to be older and/or villainous, perhaps super smart, and perhaps a bit supernatural. 

Keep your eyes peeled for "trouser roles," where women sing the roles of young men (that's a whole wormhole of gender-sexuality-philosophy-psychology that can spiral out of control, perhaps further helping your boredom problems.)

## Ruin the mystery

Just like a magician and his tricks, everyone wants to know *how they did that*. So, when there's boredom in the air, sometimes it helps to think of all the backstage action:

Any time a singer appears onstage, it's fun to imagine their recent history. With a few minutes notes, they've likely been summoned by stage management from their dressing room, and they've arrived to the immediate backstage area, often with the help of a dresser to maneuver their huge skirt/wig/prosthetic hump.

When the chorus disappears and then comes back after a while, it's always fun to imagine a bunch of folks in Elizabethan wear or gypsy costumes or giant rat suits, sitting around a green room playing euchre, checking Twitter, and gingerly eating non-messy food.

[Stage managers](/tales-from-stage-management/) and crew are hovering mere feet away from public visibility, ready to shove singers onstage, move scenery, tell the lighting guys when to change the lights, catch props that get thrown into the wings, sneakily open and close doors, and dump buckets of confetti/flower petals/fake snow onto the stage.

Prompters are often parked nearby to whisper the singers' lines; if you've got a keen eye, you can sometimes spot the prompter's booth, which sticks up from the middle-front-ish of the stage. 

If there are surtitles projected with a translated text, you can rest assured that there's a [person in a booth](/michelle-telford/) (likely behind you), who is following along with a copy of the music, armed with basically a Powerpoint presentation as long as an opera; they're likely a tiny bit worried about the projector freezing up, or about showing the slide with the punch line of a joke before the singer actually says it.

If your seats are in the right spot, you can sometimes watch the conductor-camera on the TV monitors placed around the stage; the singers use these when they can't look directly at the conductor, and it's a neat little way to put yourself into their shoes for a moment.

For plenty of people, these kinds of theatre details really are more interesting than the opera itself. That's completely fine, especially if it saves you from the boredom that can be seep into the fourth act of anything.

>How do you fend off opera boredom? Let us know in the comments below!
