+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-10-19T19:59:00-04:00"
lastmod = "2017-10-23T13:07:00-04:00"
preamble = "The relationship between a singer and a voice coach is something unique, often full of a huge amount of mutual respect for what the other brings to the table. It's a dynamic that's not quite the same as the one between a singer and voice teacher, largely because voice coaches are often not trained singers. The best coaches know this well, and they're constantly observing the line between what they can offer, and what the singer is capable of doing.\n\nThat mutual respect is at the root of how opera's best voice coaches work, and it's something singers should look for in their work. A coach's ability to demonstrate respect for a singer's work counts for a lot, and we have three ways to achieve it:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508615877265/2017-10-21---Coach.jpg.jpg"
publishDate = "2017-10-22T16:39:00-04:00"
related_articles = ["articles/4-ways-to-give-notes-still-be-liked.md","articles/4-steps-to-taking-fixing-notes.md"]
short_description = "That mutual respect is at the root of how opera&#039;s best voice coaches work, and it&#039;s something singers should look for in their work. A coach&#039;s ability to demonstrate respect for a singer&#039;s work counts for a lot, and we have three ways to achieve it:"
slug = "3-tips-for-being-a-respectful-voice-coach"
title = "3 tips for being a respectful voice coach"
+++

## Keep your words neutral

For those of us whose primary instrument exists outside of our bodies, it's not always easy to understand just how vulnerable it can be to sing. Vulnerability is something that even seasoned professionals carry with them to work each day; it's what makes a singer's performance unforgettable, and we could all learn from that.

Good coaches will start from a place of respect for the singer they're working with; great coaches will reinforce that respect with their language. For example, when addressing intonation issues: instead of "**you are flat** on this pitch," go with, "**this pitch** is sounding flat." If there's breathiness in the sound: instead of "**you** get breathy in this line," "**there's some breathiness** that happens here."

It might seem like a subtle shift, but it keeps the conversation about the work and the sound, without adding implications that the singer is doing something "wrong". It's not that they can't take criticism, or they can't handle having imperfect technique; it's more about a coach addressing issues that are audible (and therefore more objective), rather than pointing at the singer as the creator of a problem.

## Assume a singer knows how to fix a problem

Along with a voice teacher, coaches are part of a team that helps a singer sound their best. The lines of jurisdiction are often a little blurry, and teachers and coaches might touch on the same issues in their respective sessions. In any case, it's wise for a coach to remember that the singer is the owner of a technical tool kit, and they can use those tools when they're made aware of an issue. A coach, in the most basic sense, is an objective and educated set of ears, and it's a great starting point to assume that alerting a singer to an issue is enough, without nececssarily having to also offer a solution.

To be fair, this does depend on the level of proficiency of the singer you're working with, since that tool kit is something singers acquire over time and practice. Still, consider this: if you're coaching a singer with less experience, sticking to your role as a listener and not a technician helps to build respect and trust between the singer-coach-teacher triumvirate. And if you're working with a singer with plenty of technical prowess, being that listener makes you an invaluable resource, rather than an extra cook in the kitchen.

## Make it an "I" statement, not a "you" statement

Similar to the neutral words is being aware of pronouns. Again, singers aren't too tender to hear pointed criticism, and that's not what pronoun-awareness is about. Instead, it's about addressing the *results* rather than the *action*.

Example: you, the coach, hear a change in the tone that goes from focused and supported to dull and out of tune. You may suspect that it's happening because the singer wants to make a big change in dynamic at that spot, and they're singing softly in the wrong way. If you say, "**you're trying** to be too quiet here," there's a certain list of possible solutions for a singer. But if you say instead, "**I hear** the tone get unfocused here," there's a whole other to-do list that comes with it. 

The difference is that the second list isn't about what dynamic a singer is singing - it's about what effect their technical choice has on their sound. If a singer is told they're singing too softly, they may a) sing louder, or b) disagree; it's very possible that neither choice will fix that unfocused tone that you're hearing. If you tell a singer what *you* hear, they can more easily make the connection between a technical choice that they're making, and how it sounds to listeners. That's something they care about, and they may even have a way of keeping the sound focused without sacrificing the soft dynamic they're after.

There's also something else that coaches need to be aware of: not all of your opinions warrant a change. If you say, "**I don't feel** enough tension in that cadenza," know that someone else might feel plenty; a singer can hear that feedback and decide for themselves what to do with it. If you phrase it differently, and say instead, "**Your cadenza** doesn't have enough tension," that's a less-fair statement, and one that can frustrate a singer who is happy with their cadenza decisions, and at a loss for how to please their coach.

>Singers, what do you love about working with your favourite coaches? Let us know in the comments below!
