+++
author = ["authors/jenna.md"]
categories = "Humour"
date = "2016-03-23T16:06:00+00:00"
lastmod = "2016-03-31T15:27:00+01:00"
preamble = "One of the first hurdles a young musician meets as he or she pursues advanced training is the fact that there are never enough practice rooms.\n\nMusic students and graduates, how many hours do you think you've spend sitting in practice room hallways, thumbing through your scores, eagerly looking up as a door opens, hoping to **God** that it's someone leaving, and not just going for a pee/water break?\n\nRemember that poster/meme that was popping up for a while, something about \"everything I need to know in life, I learned in kindergarten\"? The game of finding a practice room is sort of like that."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459424691439/2016-03-31---Bad-Piano.jpg.jpg"
publishDate = "2016-03-31T15:27:00+01:00"
related_articles = ["articles/undergrad-degrees-why-youll-use-that-theory-class-after-all.md","articles/5-tips-for-university-auditionees.md","articles/how-to-play-for-singers.md","articles/teaching-in-the-arctic-5-things-that-one-singer-learned.md"]
related_companies = ["scene/companies/university-of-toronto-opera.md","scene/companies/opera-mcgill.md"]
short_description = "Music students and graduates, how many hours do you think you&#039;ve spend sitting in practice room hallways, thumbing through your scores, eagerly looking up as a door opens, hoping to God that it&#039;s someone leaving, and not just going for a pee/water break. Remember that poster/meme that was popping up for a while, something about &quot;everything I need to know in life, I learned in kindergarten&quot;? The game of finding a practice room is sort of like that."
slug = "3-life-lessons-that-practice-rooms-can-teach-you"
title = "3 life lessons that practice rooms can teach you"
+++

## The Golden Rule

"Do unto other as you would have them to unto you", right? In the world of practice rooms, this usually means, "don't leave your stuff in a room and then walk away for more than 10 minutes". There's a funny thing that happens, where more senior students decide that they've a) paid their dues waiting for rooms, and/or b) their work is more important than those of first- or second-year students. It's an understandable thing, to take for oneself an unofficial reward for time spent in an academic environment. 

But it's a slippery slope indeed; like the person who's constantly late to meetings, the student who uses their backpack to call dibs on a practice room without practicing in it is deeming their time more valuable than others. Practice rooms are commercial real estate; in the same way that condo owners aren't allowed to run businesses out of their homes, it's also frowned upon for a person to bring a sleeping bag and a picnic to the office. This is what it is to dump one's belongings in a room for convenience, or to spend time in a practice room eating lunch and scrolling through your phone.

And if your institution uses the "sign up for a time slot" system, it's your right to use that time unwisely. It's less of a direct slight towards others, but it's still damn annoying to those stranded in the hallways, desperately peeking into those little windows to see why no noise has come out of your practice room for a while.

On the other hand, if you're the type of person who thinks of others, who pays it forward to that pitiful lot sitting sadly in the hallway, the chances of someone doing a good deed for you when you need it most are that much higher.

## Things don't go according to plan

Nothing's worse than having oodles of motivation to practice, and losing the chance to do so because, well, life happens. There are no rooms available, or you signed up for a time and now you can't use it because the photocopier wasn't working or the bus was really late or you got some surprise homework from class that morning. Life, like practice time, is full of well-laid plans that fall apart through no fault of the planner's. 

It totally sucks, but it's great practice for the professional life you seek. Sometime in the future, you'll show up at an audition venue with no space to warm up. Or, you'll be sick/fatigued, and while you've got work to do, repetitive strain isn't a great way to get it done. Learning to practice without one's instrument is immensely valuable. Without making a sound, musicians can start memorizing, decide on proper bowings and fingerings, and take the time to notice musical patterns that you might miss while you're busy repeating that tricky scale over and over. 

When a door closes, the practice room gods open a window, right? (Hah. Practice rooms with windows. Hah.)

## Nothing's perfect

What about the times you DO get a practice room, but there's something terrible about it? Someone has left their distinct body odour behind, or the stench of a food-filled garbage can not emptied in days. Or the piano is horrifically bad, or there's no mirror, or no music stand, or the walls are paper thin, or the lighting is brutal, or the carpeting makes you push your voice in a futile quest for resonance. 

Terrible practice rooms are better than nothing, just like the gig you take in a terrible acoustic with a half-full audience is better than no gig at all. It's disheartening, and makes one question their pursuit of music. Perhaps it's a bit hyperbolic, but practicing your craft under less-than-glamourous circumstances is one of the most powerful filters for those fit for a performance career, and those who are not. It's not a matter of "tough it out, or you're not a good musician", it's just representative of how the job is large amounts of uncontrollable circumstances, and a few moments of beautiful stages and nice instruments.

So, if you can stuff kleenex up your nose, imagine that your clunky upright piano is a 9-foot Steinway, and still put in your hour or two of drilling Beethoven, you can rest assured that you're in all this music stuff for the right reasons. 

And when you do get the chance to practice on a nice grand, in an acoustically friendly space, with maybe a nice view out a window or two, you'll suck up that inspiration like a sponge.

>What are your tales of practice room successes and failures? Share your stories, and tips for practice room wins, in the comments below!
