+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = 2021-09-21T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Readers, what have you read lately that you'd love to see in opera form? Let us know in the comments below, or get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
preamble = "Here's a surprising truth I've learned from raising a small human: the reading material is excellent. In the last four years, I've read hundreds of kids' books, and though they're not all masterpieces, there's certainly something to marvel at in their construction. Simple and evocative language, a close relationship between visuals and text, even a few great rhymes thrown around — this is the stuff of excellent children's literature. And in case I'm not clearly driving my point home, the stuff of great operas. So, here are my current picks for great kids' lit that are ready for their operatic treatment:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1632245168/media/2021/09/ChildrensBooks_b6yikh.jpg"
primary_image_credit = ""
related_articles = ["articles/3-life-lessons-that-practice-rooms-can-teach-you.md", "articles/4-awesome-rage-arias-that-arent-the-queen-of-the-night.md", "articles/5-people-who-would-make-great-opera-roles.md", "articles/5-books-that-should-be-operas.md"]
related_companies = []
related_people = []
short_description = "Simple and evocative language, a close relationship between visuals and text, even a few great rhymes thrown around — this is the stuff of excellent children's literature. And in case I'm not clearly driving my point home, the stuff of great operas."
slug = "3-childrens-books-that-would-make-excellent-operas"
title = "3 children's books that would make excellent operas"
youtube_url = ""

+++
## _A Promise is a Promise_, Robert Munsch, Michael Kusugak, and Vladyana Krykorka

If you grew up in Canada, there's a great chance that you read [_A Promise is a Promise_](https://robertmunsch.com/book/a-promise-is-a-promise-2) - and if you were an imaginative kid like I was, you had a few bad dreams about it. Munch's 1992  book is based on the legend of the [Qallupilluit](https://en.wikipedia.org/wiki/Qallupilluit), the terrifying figures of Inuit folklore who are said to live under the ice in the sea, and who kidnap ill-behaved children. It's one of those stories designed to keep children safe — as in, don't go out on the sea ice — but in doing so, potentially freaks them utterly out. Just look at the book cover: that horrid hand cracking out of the ice? It's just the start, as anyone who's seen Krykorka's hideous-magical renderings of the Qallupilluit knows.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632244677/media/2021/09/Munsch_thbdbb.jpg){{% /md %}}

</figure>

I imagine _A Promise is a Promise: The Opera_ to be an eerie soundscape, full of aural distinction between the Qallupilluit and the icy sea, and the earthy world of the family who dares to protect their children from drowning in their grasp. Munsch's telling has that classic story structure (the rule of three, outwitting a malevolent force) that's conducive to a multi-act opera. Allashua, the child who narrowly escapes the Qallupilluit's grasp, is a ballsy young soubrette who never completely recovers from her brush with death. Her parents, a warm baritone and an even warmer mezzo, are the wise figures who outsmart the Qallupilluit, achieving the ultimate heroic act: saving the lives of children.

There's so much room for sound exploration with this story. What do Qallupilluit sound like? What do they sound like when they come into Allashua's home and ask for candy? And if any opera is ready for an Inuk composer's hand, it would be _A Promise is a Promise_.

## _The Gruffalo_, Julia Donaldson and Axel Scheffler

Musical structure, anyone? [_The Gruffalo_](https://axelscheffler.com/books-with-julia-donaldson/the-gruffalo) is an amazing feat of storytelling, combining the rule of three with a palindromic narrative. (Can you tell I've read this book _a ton of times?_) So, we've got a Mouse who bluffs his way out getting eaten by a Fox, then an Owl, and then a Snake: he tells them he's buddies with a Gruffalo, a terrifying (and fictional) creature with tusks and orange eyes and a warty nose, who just so happens to love the taste of foxes, owls, and snakes. The bluff work - but wait! The Gruffalo isn't fictional after all!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632244064/media/2021/09/Gruffalo_fvulzt.jpg){{% /md %}}

</figure>

Sure, there are the awesome musical opportunities in describing a whip-smart little mouse, and the monstrous and exaggerated Gruffalo. The text already rhymes, and I'd be inclined to approach Julia Donaldson about using it as-is for a libretto. And imagine the thematic development of the music: Fox (violin) — Owl (clarinet?) — Snake (oboe!) — Gruffalo! (tuba!) — Snake — Owl — Fox. It's rife (RIFE!) with composer inspiration. And even better, this is a story about how someone small and un-scary can still wield power.

Opera-friendly structure? Yep. Great message for young people? Definitely. A _basso profundo_ as the Gruffalo? Yes please.

## _Marcel the Shell: The Most Surprised I've Ever Been_, Dean Fleischer-Camp and Jenny Slate

Alright, readers: if you've not yet heard of _Marcel the Shell With Shoes On_, make your day better by watching this fantastic 2010 short film by Dean Fleischer-Camp and Jenny Slate:

<figure data-type="video">{{% md %}}<iframe width="1010" height="568" src="https://www.youtube.com/embed/VF9-sEbqDvU" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>

The wonderful book from the Marcel the Shell universe, [_The Most Surprised I've Ever Been_](https://www.penguinrandomhouse.ca/books/311550/marcel-the-shell-the-most-surprised-ive-ever-been-by-jenny-slate-and-dean-fleischer-camp/9780698198999), is so freaking heartwarming I just can't handle it. It's a story about a single moment in a day: Little Marcel is minding his own business, when suddenly he is flung up into the air. While he's up there — a whole 200 centimetres off the ground — he thinks about astronauts, his grandmother, popcorn, paper airplanes, and more. It's something beautiful that comes out of the mundane, a story that makes us remember that everyone around us is living their very own lives, full of thoughts and plans and surprises.

It's a gorgeous setting for an opera short. I imagine it very through-composed, very stream-of-consciousness. Certainly, there's some gorgeous sound event that involves a harp when Marcel goes airborne, something that sets up a soundscape that makes us think of flight and fond memories. Surely, this opera sounds like a warm hug, padded harmonies mixed with — what else? — surprises. And Marcel is certainly a countertenor, no?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632244812/media/2021/09/Marcel_mo2hmi.jpg){{% /md %}}

</figure>