+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-02-16T10:18:00+00:00"
lastmod = "2017-02-20T14:14:00+00:00"
preamble = "Images, clockwise rom top left: scenes from *Parsifal* (Ken Howard), *Madama Butterfly* (Marty Sohl), *The Exterminating Angel* (Monika Rittershaus), *Cendrillon* (Ken Howard), and Kathryn Lewek as the Queen of the Night in Mozart's *Die Zauberflote* (Ken Howard)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487347679648/2017-02-17---Met-1718.jpg.jpg"
publishDate = "2017-02-18T09:35:00+00:00"
related_articles = ["articles/opera-philadelphia-puts-the-mets-201718-season-to-shame.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/nadine-sierra.md","scene/people/angela-meade.md","scene/people/jamie-barton.md","scene/people/christine-goerke.md","scene/people/kristine-opolais.md","scene/people/plcido-domingo.md","scene/people/bryn-terfel.md","scene/people/tara-erraught.md","scene/people/pretty-yende.md","scene/people/joyce-didonato.md","scene/people/yannick-nezet-seguin.md","scene/people/johannes-debus.md","scene/people/sondra-radvanovsky.md","scene/people/sonya-yoncheva.md","scene/people/elizabeth-deshong.md","scene/people/audrey-luna.md","scene/people/alice-coote.md","scene/people/vittorio-grigolo.md","scene/people/roberto-alagna.md"]
short_description = "By far, the coolest thing on the Met&#039;s new season line-up is Thomas Adès&#039; The Exterminating Angel, when the composer himself will conduct a cast that includes the likes of Audrey Luna, Alice Coote, and Iestyn Davies. The opera seems to be the token new work of the season, like Saariaho&#039;s L&#039;amour de loin was in 2016."
slug = "201718-at-the-met-are-conservative-seasons-the-way-to-go"
title = "2017/18 at the Met: are conservative seasons the way to go?"
+++

It was a pretty weird experience to peruse the newly-announced [2017/18 season](http://www.metopera.org/Season/2017-18-Season/) for [The Metropolitan Opera](/scene/companies/the-metropolitan-opera/). We did a double take; at first glance, the new season looks almost identical to the current one. Of course that's not true, since with a few exceptions like the Met's staple *La bohème* and Barlett's Sher's production of *Roméo et Juliette* from, the operas on their 17/18 season are different. But if we though last year's announcement was conservative (boasting only one opera on the line-up written in the 21st century), the new season seems to be simply another shade of grey.


There are 220 performances of 26 operas on the Met's line-up for 2017/18; 20 of those shows are revival productions, and 10 are set for an [HD cinema broadcast](http://www.metopera.org/Season/In-Cinemas/). There are certainly things to look forward to: [Christine Goerke](/talking-with-singers-christine-goerke/) sings [*Elektra*](http://www.metopera.org/Season/2017-18-Season/elektra-strauss-tickets/); [Yannick Nézet-Séguin](/scene/people/yannick-nezet-seguin/) will conduct [*Parsifal*](http://www.metopera.org/Season/2017-18-Season/parsifal-wagner-tickets/); [Nadine Sierra](/scene/people/nadine-sierra/) will sing Susanna in Richard Eyre's [*Le nozze di Figaro*](http://www.metopera.org/Season/2017-18-Season/nozze-di-figaro-mozart-tickets/); [Ailyn Pérez](/scene/people/ailyn-perez/) sings the title role in [*Thaïs*](http://www.metopera.org/Season/2017-18-Season/thais-massenet-tickets/); [Canadian Opera Company](/scene/companies/canadian-opera-company/) music director [Johannes Debus](/scene/people/johannes-debus/) returns to the Met to conduct [*Les contes d'Hoffman*](http://www.metopera.org/Season/2017-18-Season/hoffmann-offenbach-tickets/), and [Plácido Domingo](/scene/people/placido-domingo/) takes the podium for [*Roméo et Juliette*](http://www.metopera.org/Season/2017-18-Season/romeo-et-juliette-gounod-tickets/), and sings Miller in [*Luisa Miller*](http://www.metopera.org/Season/2017-18-Season/luisa-miller-verdi-tickets/).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487348122565/2017-02-17---Luisa-Miller.jpg.jpg)
<figcaption>A scene from Verdi's *Luisa Miller*. Photo by Ken Howard/Metropolitan Opera.</figcaption>
</figure>

By far, the coolest thing on the Met's new season line-up is Thomas Adès [*The Exterminating Angel*](http://www.metopera.org/Season/2017-18-Season/exterminating-angel-ades-tickets/), when the composer himself will conduct a cast that includes the likes of [Audrey Luna](/talking-with-singers-audrey-luna/), [Alice Coote](/talking-with-singers-alice-coote/), and [Iestyn Davies](/scene/people/iestyn-davies/). The opera seems to be the token new work of the season, like Saariaho's *L'amour de loin* was in 2016.

For fans of new opera, or even of young opera that deserves more stage time, the Met's season may seem disappointing. Why, when the Met has the budget and resources that it does, don't they champion opera in the present-day? Amid the revolving door-type productions of [*La bohème*](http://www.metopera.org/Season/2017-18-Season/boheme-puccini-tickets/), [*Tosca*](http://www.metopera.org/Season/2017-18-Season/tosca-puccini-tickets/) and [*Norma*](http://www.metopera.org/Season/2017-18-Season/norma-bellini-tickets/) (new as the productions may be), why can't there be room for something fresh, or even unexpected?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487348162383/2017-02-27---hires-exterminating_angel_218.jpg.jpg)
<figcaption>A scene from Tom Cairn's new production of Thomas Adès's *The Exterminating Angel*. Photographed here at the Salzburg Festival. Photo by Monika Rittershaus.</figcaption>
</figure>

But perhaps it's time to stop bashing our proverbial heads against proverbial walls, wishing the Met were different. Maybe it's like a toxic relationship, where one person is disappointed that the other person is behaving exactly as they always have. It doesn't matter that the Met *could* (or even *should*) become a powerful vehicle for new, deserving opera from the 20th and 21st century; the fact of the matter is that they *don't*. 

Those aforementioned productions of *Bohème*, *Tosca* and *Norma* (called revolving door-type because of the almost laughable number of multiple cast permutations), are the heart of the Met's purpose. Obviously, the Met is a place to hear the best voices in the world, and to see the work of the world's greatest directors; perhaps the programming is conservative because standards from Verdi, Mozart, and Donizetti are the easiest ways to hear these singers, where the audience can hear the voices without distraction by music that's unfamiliar.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487348173156/2017-02-17---ParsifalPARS2_4526b.jpg.jpg)
<figcaption>A scene from Wagner's *Parsifal*. Photo: Ken Howard/Metropolitan Opera</figcaption>
</figure>

When multiple casts, hectic rehearsal schedules, and old-standard revivals get together, the product isn't likely to be a gem of close-knit theatre; the production becomes a showcase of skills, combining the singers, conductors, and directors that deserve our ears. That's not to say that the Met can't wow their listeners, but for fans who crave a cohesive experience at the opera, these kinds of productions can feel like opera-by-numbers or an operatic model home, where the world's top talent working beside, rather than with each other.

But maybe that's the only way to produce season after season of 20+ operas with hundreds of singers - and to do it in the middle of New York, the American heart of music theatre. To answer our own question from earlier, maybe the Met's budget simply isn't for new works. That budget doesn't exist outside of the confines of a risk-free season that satisfies donors, fulfills their status as a New York tourist attraction, and doesn't compete with anything playing on Broadway. Maybe we're not the only idealistic opera fans who consider that as sort of a shame.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487348498955/2017-02-17---FIG1_7751.jpg.jpg)
<figcaption>A scene from Mozart's *Le Nozze di Figaro*. Photo by Ken Howard/Metropolitan Opera.</figcaption>
</figure>

Look. If you go to hear the Met's *Norma* sung by any combination of [Sondra Radvanovsky](/talking-with-singers-sondra-radvanovsky/), [Joyce Di Donato](/scene/people/joyce-di-donato/), [Angela Meade](/scene/people/angela-meade/), [Marina Rebeka](/scene/people/marina-rebeka/) or [Jamie Barton](/scene/people/jamie-barton/) in it, you're going to have a good night. And perhaps it's not a bad thing to limit the "new" stuff to just one, exciting production like *The Exterminating Angel* - there's nothing wrong with hype and sold-out shows.

But there's one important question that remains: is it a fair trade-off for the Met to stay conservative with its season programming, in exchange for offering the world's best opera talent?

So, readers, we will officially stop bashing our heads against the walls of Lincoln Center. Instead, we're curious to find out what you think: what has you excited - or not excited - in the Met's 2017/18 season? And more importantly, what part does the Met play in the opera world of 2017?
