+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-01-19T15:29:00+00:00"
lastmod = "2017-01-24T10:36:00+00:00"
preamble = "Roughly a month away is [Mahogany Opera Group](/scene/companies/mahogany-opera-group/)'s 2017 Various Stages Festival, which showcases new operas-in-progress with performances and critical feedback sessions. On **February 24th, 1pm** at London's Institute of Contemporary Arts, the Festival celebrates six new works, including\n[In A Grove](http://www.mahoganyoperagroup.co.uk/productions/various-stages-festival-2017/in-a-grove/), by composer Christopher Cerrone and librettist Stephanie Fleischmann. The opera, which \"plumbs the elusive nature of perception and truth and the harrowing terrain of love marred by violence,\" is inspired by Ryūnosuke Akutagawa's 1922 short story of the same name.\n\nWe spoke with Cerrone and Fleischmann about their work on *In a Grove*, and the unique creative process of adapting literature into opera."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484839928782/2017-01-19---In-A-Grove.jpg.jpg"
publishDate = "2017-01-24T10:36:00+00:00"
related_companies = ["scene/companies/mahogany-opera-group.md"]
short_description = "&quot;We hope listeners will take away a sense of the tone of the piece, and a glimpse of what we intend to with it as a whole. Even though we will be somewhat limited in how much we can do spatially at Various Stages to give a sense of the immersive nature of the opera, we hope the audience will have a taste of what’s to come: a powerfully unsettling, haunting experience designed to be both confounding and crystalline, disjunctive yet deeply emotional.&quot;"
slug = "2017-various-stages-festival-presents-in-a-grove-"
title = "2017 Various Stages Festival presents: In a Grove "
+++

## What can you tell us about the story of *In a Grove*? What appealed to you about Akutagawa's short story as a source material?

Akutagawa's classic short story plumbs the elusive nature of perception and truth and the harrowing terrain of love marred by violence. At the same time mysterious and lucid, intimate and epic, *In a Grove* relentlessly probes the isolation endemic to being alive in this world, the loneliness of existence. As source material, the work is formal and poetic yet at times unexpectedly down to earth, pellucid yet inscrutable. The simplicity of its form is surprisingly deceptive. It offers up the possibility of radical shifts in scale, extreme intimacy and intense emotionality within a container that suggests a more distanced perspective, and poses questions of truth and perception that feel particularly urgent in today's world.

## How would you describe the musical aesthetic of this work? How does it compare to your previous operatic projects?

**Chris Cerrone**: *In a Grove* feels darker, and perhaps more oblique than other works of mine. More often than not, my work relies upon a sensuality that is missing from this work. It is lean, raw, and minimalist in the literal sense. 

However, like much of my other work, it uses resonance and repetition to create a hypnotic sound world. The many interconnected threads in the tale of *In a Grove* allow me to create a variations form where ideas constantly reemerge, varied and evolved from their last iteration. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484839973600/2017-01-19---In-a-Grove_Chris-Cerrone.jpg.jpg)
<figcaption>Chris Cerrone, composer, *In a Grove*.</figcaption>
</figure>
 
## Are there any particular challenges to writing a libretto based on an existing piece of literature? How do you adapt the words to be sung?

**Stephanie Fleischmann**: When it comes to adaptation, every piece of literature poses its own set of challenges. Akutagawa's short story is already so distilled that the text itself doesn’t need much, if any, structural rejiggering, apart from the questions we are asking of it in order to serve the needs of the immersive experience we ultimately envision for the piece: Repetition of the first handful of scenes, which we imagine will be happening concurrently, is our initial structural conceit. We imagine the audience will experience this first series of scenes in a random order, although this may well change after we've spent some time in the room with the work. This is the boon a developmental residency such as Various Stages provides — a window for discovery.

Our aim for the work as a whole is to carve out a kind of neutral terrain for this classic Japanese text, which was written in 1922, and is intensely culturally specific, woven through with notions of honor and gender roles that are very much endemic to the time and place in which it was written. Yet this particular existing piece of literature is a text that deserves to be perceived as universal, not unlike Shakespeare and the Greeks and so many others. Our challenge is to mine it for what speaks to us in the here and now 

For me, the process of making a text sing is somewhat mysterious, a bit resistant to articulation. What I can say, after having put the source material—a wonderfully and ever so slightly clunky literal translation of an exceedingly poetic text—through my own idiosyncratic filter, is that my relationship to words is intensely kinetic. I tend to work with a great deal of internal rhyme, even if with this text we are making it a point to refrain from end rhymes. I didn't realize, until I started working with Chris, that alliteration is a little like breathing for me. So much so, that at Chris's request, I'm consciously working against that impulse. I grew up around classical music. Music is in everything I write, whether it is written to be sung or spoken. The sonic shape of the text drives its meaning. Whether the words' principle task is to conjure image or character, point of view or heightened moment, a dramatic muscularity—hopefully, at a cellular level—is emerging as I hone the libretto.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484847697129/2017-01-19---In-a-Grove_Stephanie-Fleischmann.jpg.jpg)
<figcaption>Stephanie Fleischmann, librettist, *In a Grove*.</figcaption>
</figure>

## What do you hope listeners will take away from *In a Grove*'s performance at the Various Stages Festival?

We hope listeners will take away a sense of the tone of the piece, and a glimpse of what we intend to with it as a whole. Even though we will be somewhat limited in how much we can do spatially at Various Stages to give a sense of the immersive nature of the opera, we hope the audience will have a taste of what’s to come: a powerfully unsettling, haunting experience designed to be both confounding and crystalline, disjunctive yet deeply emotional.
