+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2024-05-01T00:00:00-00:00"
lastmod = "2024-05-01T00:00:00-00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1714573730/Cover_Image_La_Ville_Morte_Sophie_Von_Hellerman_Sam_Roberts_Photography.jpg"
primary_image_credit = "Program cover image by Sophie von Hellerman depicting the tangled relationships in Catapult Opera’s production of La Ville Morte. Sophie von Hellerman / Sam Roberts Photography, 2023."
publishDate = "2024-05-01T00:00:00-00:00"
related_articles = ["articles/a-clarifying-and-revelatory-evening-with-schubert-and-jonas-kaufmann.md", "articles/julia-bullock-a-miraculous-evening-from-schubert-to-nina-simone.md"]
related_companies = []
related_people = []
short_description = "The opera's intended 1914 premiere at the Opéra Comique was cancelled due to the outbreak of World War I during which time the original orchestrations were lost. The origins of the Boulanger-Pugno work are almost as fraught with circumstance as D'Annunzio's libretto."
slug = "100-years-later-boulangers-opera-gets-north-american-premiere"
title = "100 years later, Boulanger's opera gets North American premiere"
+++

Nadia Boulanger and Raoul Pugno began composing _La Ville Morte_ in 1910. Pugno, 35 years her senior, had been supportive of Boulanger's career after her studies at the Paris Conservatory in 1904, and subsequently became her friend and lover. The libretto was based on celebrated Italian writer Gabriele D'Annunzio's play _La città morta_, a popular vehicle for Sarah Bernhardt, his own sometimes lover. The opera's intended 1914 premiere at the Opéra Comique was cancelled due to the outbreak of World War I during which time the original orchestrations were lost. The origins of the Boulanger-Pugno work are almost as fraught with circumstance as D'Annunzio's libretto.

As a respected pianist and composer, Pugno was able to promote their collaboration in important musical circles. Upon his death it fell off the cultural radar. Years later the early death of Boulanger's beloved sister and fellow composer Lili caused Boulanger to lose interested in her compositions and in promoting them. _La Ville Morte_ would wait over a century for its world premiere at the Greek National Opera in partnership with Catapult Opera.

Boulanger, of course, became widely regarded as the world's best teacher of musical composition. Her students included such luminaries as Aaron Copland, Leonard Bernstein and Philip Glass, not to mention Burt Bacharach and Quincy Jones. As a young female composer she was perhaps drawn to Pugno as a collaborator and to D'Annunzio's play, implementing a savvy strategy to gain acceptance in a male dominated musical culture.

Catapult, an ambitious and adventurous New York based company gained access to the surviving piano-vocal score on the condition that a new orchestration be commissioned.  The company retained Joseph Stillwell and Stephan Cwik, under the supervision of former Boulanger student David Conte, to create the chamber orchestration that premiered in Athens in January. 

It is a gift to the music world and an overdue recognition of Boulanger's accomplishments beyond her storied career as a teacher. Last month Catapult brought its production from Athens, a mere 120 kilometers from the archaeological excavation of Mycenae that inspires the story, to NYU's Skirball Center for its North American premiere.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1714573729/Nadia_Boulanger_1925_colorized.jpg)
<figcaption>French composer Nadia Boulanger in 1925. Photo: Edmond Joallier, Bibliothéque nationale de France (public domain).</figcaption>
</figure>

Scholars have noted that the surviving score clearly shows the pens of both Boulanger and Pugno. Who wrote what remains unknown. Conductor (and Catapult Opera artistic director) Neal Goren offers something of a clue. "The musical style does not reflect any of Pugno's other compositions," he writes in program notes, "whereas it can easily be seen as a logical extension of Boulanger's other compositions of the time." Perhaps Boulanger took the lead, reversing the mentor-mentee relationship. 

D'Annunzio's libretto concerns the tangled relationships among four people at the Mycenaean site; Léonard, a highly strung archaeologist, his young and pure of heart sister Hébé, Léonard's good friend Alexander and Alexander's wife Anne who, despite her blindness, appears to see all. 

Alexander confesses to Léonard his love for Hébé but knows that it is impossible while Léonard harbors incestuous desires for his sister and Anne tells Hébé that she loves her. Their situation, as if it weren't sufficiently tense, is exacerbated by Léonard’s fragility and frantic exhaustion. He is overwhelmed by the unearthed treasures.

Robin Guarino's direction mines little of the libretto's inherent melodrama and remains static throughout The story flows but scenes feel isolated much of the time. Andromache Chalfant's unhelpful set consists of an elevated room that functions like as a surreal overlook, and a minimally suggested archeological site. Jessica Ann Drayton's projections, handsomely mounted on a billowing white drape, provide atmosphere but often overstay their welcome. When turned, quite jarringly, on the room they are little more than video babble. Just a hint of Cyclopean masonry that distinguishes the site, might have provided some sense of heat and dust.

Production flaws fall by the wayside when hearing Catapult's ravishing new chamber orchestration played with finesse by the excellent Talea Ensemble. Leading the group Goren captured the myriad nuances of the score echoing Wagner and Debussy and the modern sensibilities of Boulanger and Pugno. The orchestration's balance of the aesthetics of impressionistic music and a decidedly expressionistic pallet suited this ensemble known for its virtuosic performances of new music. Here they give a century old composition new life.

With the character of a nurse and the chorus eliminated in this orchestration, four voices remain to breath life into _La Ville Morte_. The vocal world created by soprano Melissa Harvey as the much desired Hébé was youthful and poignant, suffused with impressive control and dramatic heft. Lyric tenor Joshua Dennis captured Léonard's unhinged nature and traversed the emotional extremes of his mad scene with assured and supple abandon. 

As Alexander, [Jorell Williams](/scene/people/jorell-williams/)' lustrous baritone and abundant acting chops provided the opera's only bit of levity. His commanding presence contributed to a sorely needed sense of place. Mezzo-soprano Laurie Rubin's Anne, inexplicably confined to a chair in the corner of the room, was nonetheless equally compelling and used her dark and enigmatic voice to create a kind of lovelorn oracle.

Talea's eloquent woodwinds created and sustained a foreboding atmosphere evoking the exotic environment and perverse nature of _La Ville Morte_. The Straussian touch of a prominent piano at key moments provided an ironic hint, perhaps of some archaeological mayhem or simply as counterpoint to the melodrama.