#ifndef __SKINWINDOW_H_
#define __SKINWINDOW_H_

#include <windows.h>
#include <tchar.h>
#include "MemDC.h"

#define BORDER_WIDTH			3//GetSystemMetrics(SM_CXSIZEFRAME)
#define BUTTON_SIZE				22//GetSystemMetrics(SM_CXSIZE)
#define TITLE_HEIGHT			22//GetSystemMetrics(SM_CYCAPTION)
#define ICON_WIDTH				GetSystemMetrics(SM_CXSMICON)
#define ICON_HEIGHT				GetSystemMetrics(SM_CYSMICON)

// λ
enum HitTestConstants
{
	//In the border of a window that does not have a sizing border 
	//ûдС߿Ĵڵı߿
	htBorder = HTBORDER,		
	//In the lower horizontal border of a resizable window (the user can click the mouse to resize the window vertically) 
	//ڿɵСڵĽϵˮƽ߿(ûԵ괹ֱڵĴС)
	htBottom = HTBOTTOM,
	//In the lower-left corner of a border of a resizable window (the user can click the mouse to resize the window diagonally)
	//ڿɵСڱ߿½(ûԵԽߵڵĴС)
	htBottomLeft = HTBOTTOMLEFT,
	//In the lower-right corner of a border of a resizable window (the user can click the mouse to resize the window diagonally) 
	//ڿɵСڱ߿½(ûԵԽߵڵĴС)
	htBottomRight = HTBOTTOMRIGHT,
	//In a title bar 
	//ڱ
	htCaption = HTCAPTION,
	//In a client area
	//ڿͻ
	htClient = HTCLIENT,
	//In a close button
	//ڹرհť
	htClose = HTCLOSE,
	//On the screen background or on a dividing line between windows (same as HTNOWHERE, except that the DefWindowProc function produces a system beep to indicate an error) 
	//Ļϻ򴰿֮ķֽ(HTNOWHEREͬDefWindowProcϵͳָʾ֮)
    htError = HTERROR,
	//In a size box (same as HTSIZE) 
	//ڴС(HTSIZEͬ)
	htGrowBox = HTSIZE,
	//In a Help button
	//ڰť
	htHelp = HTHELP,
	//In a horizontal scroll bar 
	//ˮƽ
	htHScroll = HTHSCROLL,
	//In the left border of a resizable window (the user can click the mouse to resize the window horizontally) 
	//ڿɵСڵ߿(ûԵˮƽڵĴС)
	htLeft = HTLEFT,
	//In a menu 
	//ڲ˵λ
	htMenu = HTMENU,
	//In Maximize button 
	//󻯰ť
	htMaxButton = HTMAXBUTTON,
	//In Minimize button 
	//Сť
	htMinButton = HTMINBUTTON,
	//On the screen background or on a dividing line between windows 
	//Ļϻ򴰿֮ķֽ
    htNoWhere =	HTNOWHERE,
	//In a Minimize button 
	//Сť
	htReduce = HTREDUCE,
	//In the right border of a resizable window (the user can click the mouse to resize the window horizontally) 
	//ڿɵСڵұ߿(ûԵˮƽڵĴС)
	htRight = HTRIGHT,
	//In a size box (same as HTGROWBOX) 
	//һС(HTGROWBOXͬ)
	htSize = HTSIZE,
	//In a System menu or in a Close button in a child window 
	//ϵͳ˵лӴеĹرհť
	htSysMenu = HTSYSMENU,
	//In the upper horizontal border of a window
	//ڴڵˮƽ߽
	htTop = HTTOP,
	//In the upper-left corner of a window border 
	//ڴڱ߿Ͻ
	htTopLeft = HTTOPLEFT,
	//In the upper right corner of a window border 
	//ڴڱ߿Ͻ
	htTopRight = HTTOPRIGHT,
	//In a window currently covered by another window in the same thread (the message will be sent to underlying windows in the same thread until one of them returns a code that is not HTTRANSPARENT) 
	//ڵǰͬһ߳еһڸǵĴ(Ϣ͵ͬһ߳еĵײ㴰ڣֱһڷطHTTRANSPARENT)
    htTransparent =	HTTRANSPARENT,
	//In the vertical scroll bar 
	//ڴֱ
	htVScroll =	HTVSCROLL,
	//In a Maximize button 
	//󻯰ť
	htZoom = HTZOOM,
	//Զλ
	htCustom = HTCLIENT
};

// ״̬
enum ObjStateConstants
{
    osNormal = 0x0,						//״̬				
    osHot = 0x1,						//״̬
    osPressed = 0x2,					//״̬
    osDisabled = 0x3,					//״̬
	osVisible = 0x4						//Ƿɼ״̬
};

// 
enum ObjTypeConstants
{
    otWindow = 0x1,						//				
	otIcon = 0x2,						//ͼ
	otText = 0x3,						//ı
	otHelp = 0x4,						//ť
	otMin = 0x5,						//Сť
	otMax = 0x6,						//󻯰ť
	otClose = 0x7,						//رհť
	otCustomButton = 0x8				//Զ尴ť
};

// 
class TheObj
{
public:
	TheObj(ObjTypeConstants eType)
	{
		Type = eType;
		State = osNormal;
		Icon = NULL;
		Title = NULL;
		Tip = NULL;
	}
	~TheObj()
	{
		Icon = NULL;
		Title = NULL; 
		Tip = NULL;
	}

	ObjTypeConstants Type;				//
	ObjStateConstants State;			//״̬
	RECT Area;							//
	HICON Icon;							//ͼ
	TCHAR* Title;						//
	TCHAR* Tip;							//ʾı
};

class CSkinWIndow
{
// 
public:
	CSkinWIndow();
	virtual ~CSkinWIndow();

// 
public:
	BYTE		Alpha;					//͸
	COLORREF	TitleColor;				//ɫ
	COLORREF	GradientBeginColor;		//俪ʼɫ
	COLORREF	GradientEndColor;		//ɫ
	COLORREF	BackColor;				//ڱɫ
	COLORREF	CloseButtonColor;		//رհťɫ
	INT			TitleBarHeight;			//߶
	INT			BorderWidth;			//߿
	HICON		Icon;					//ͼ
	TCHAR*		Title;					//ڱ
	BOOL		FontSmoothing;			//ƽ

// 
public:
	
	//Ƿб
	BOOL HasCaption(HWND hWnd) const;

	//Ƿ󻯰ť
	BOOL MaxButton() const;		
	VOID MaxButton(BOOL bValue);
	
	//ǷСť	
	BOOL MinButton() const;		
	VOID MinButton(BOOL bValue);

	//Ƿаť		
	BOOL HelpButton() const;		
	VOID HelpButton(BOOL bValue);
	
	//ô͸
	BOOL Transparent(BYTE nAlpha);
	
	//ˢ
	VOID Refresh();

// ¼
public:
	VOID OnShowWindow(HWND hWnd);
	//VOID OnNcCalcSize(RECT* lpRect);
	VOID OnNcCalcSize(NCCALCSIZE_PARAMS *lpncsp);
	VOID OnNcActivate(BOOL bActive);
	VOID OnSystemCommand(UINT nID, LPARAM lParam);
	VOID OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	VOID OnSize(INT nWidth, INT nHeight);
	UINT OnNcHitTest(UINT nHitTest, INT X, INT Y);
	VOID OnNcMouseMove(INT X, INT Y);
    VOID OnNcLButtonDblClk(INT X, INT Y);
	VOID OnNcLButtonDown(INT X, INT Y);
	VOID OnNcPaint();
	VOID OnPaint();
	VOID OnSettingChange();

private:
	HWND	m_hWnd;				//ھ
	HRGN	m_hRgn;				//
	CMemDC  m_MemDC;			//ڴDC

	TheObj	*m_oWindow;			//
	TheObj	*m_oIcon;			//ͼ
	TheObj	*m_oTitle;			//ı
	TheObj	*m_oClose;			//رհť
	TheObj	*m_oMax;			//󻯰ť
	TheObj	*m_oMin;			//Сť
	TheObj	*m_oHelp;			//ť

	TheObj	*m_oCustomBtn1;		//Զ尴ť1
	TheObj	*m_oCustomBtn2;		//Զ尴ť2
	TheObj	*m_oCustomBtn3;		//Զ尴ť3
	TheObj	*m_oCustomBtn4;		//Զ尴ť4
	TheObj	*m_oCustomBtn5;		//Զ尴ť5
	//TheObj	*m_oPrevButton;		//һť
	
	HitTestConstants m_eMousePos;	//ǰλ

	BOOL	m_bSysMenu;			//Ƿϵͳ˵
	//BOOL	m_bToolWindow;		//Ƿǹߴ
	//BOOL	m_bDialogFrame;		//ǷԻ򴰿
	
	BOOL	m_bMaxButton;		//Ƿ󻯰ť
	BOOL	m_bMinButton;		//ǷСť
	BOOL	m_bHelpButton;		//Ƿаť
	//BOOL	m_bShowMinMaxButtons;//ǷС󻯰ť

	BOOL	m_bMaximized;		//Ƿ
	BOOL	m_bMinimized;		//ǷС
	
	BOOL	m_bFirstShow;		//Ƿһʾ
	BOOL	m_bActive;			//Ƿ񱻼		
	
	BOOL	m_bAntiAliased;		//˿ݹ
		
private:
	
	VOID InitFrame(HWND hWnd);
	VOID ResetFrame(BOOL bMaximized);
	VOID DrawFrame(HDC hDC);

	VOID DrawCloseButton(HDC hDC);
	VOID DrawMaxButton(HDC hDC);
	VOID DrawMinButton(HDC hDC);
	VOID DrawHelpButton(HDC hDC);
	VOID DrawCustomButton(HDC hDC, TheObj *oButton);
	
	VOID OpenAntiAliasedFont(HWND hWnd);
	VOID CloseAntiAliasedFont(HWND hWnd);

};

#endif //__SKINWINDOW_H_
