#ifndef __SHADOWWINDOW_H_
#define __SHADOWWINDOW_H_

#include <windows.h>
#include <tchar.h>

#define DEF_DEPTH			5
#define DEF_TRANSPARENCY	200

// Vista compatibility APIs
//Ƿϡ
//Vistaϵͳڡѡˡϡ͡󻯺Сʱ̬ʾڡܺӰʾ⡣
//ڡϡʱرӰ
typedef HRESULT (WINAPI *pfnDwmIsCompositionEnabled)(BOOL *pfEnabled);
static pfnDwmIsCompositionEnabled s_DwmIsCompositionEnabled;

class CShadowWindow
{
// 
public:
	CShadowWindow();
	virtual ~CShadowWindow();

// 
public:

	//Ӱ
	enum ShadowTypeConstants
	{		
		stNoneShadow = 0,		//ûӰ
		stDefaultShadow = 1,	//ȱʡӰ(Ӱұߺ͵ױ)
		stFullShadow = 2		//ȫ(Ӱı)
	};

	COLORREF	ShadowColor;	//Ӱɫ
	INT			ShadowDepth;	//Ӱ
	BYTE		Transparency;	//͸
	ShadowTypeConstants ShadowType; //Ӱ

// 
public:
	
	BOOL Shadow(HWND hWnd);		//ӦӰ
	VOID OpenShadows();			//Ӱ
	VOID CloseShadows();		//رӰ
	BOOL IsDwmCompLayered();	//Vistaϵͳˡϡ+󻯺Сʱ̬ʾڡѡ

//¼
public:
	VOID OnWindowPosChanged(WINDOWPOS *lpwp);
	VOID OnSize();
	VOID OnSettingChange(); 

private:

	HWND m_hWnd;				//ھ
	HWND m_hWndLt;				//Ӱھ
	HWND m_hWndTt;				//Ӱھ
	HWND m_hWndBt;				//׶Ӱھ
	HWND m_hWndRt;				//ұӰھ
	BOOL m_bIsLayered;		    //ֲ㴰֧
	BOOL m_bLastShow;			//ϴʾ״̬
	WINDOWPOS m_wp;				//λ
	INT	 m_cx;					//һ
	INT  m_cy;					//һ߶
	BOOL m_bIsDwmCompLayered;	//Vistaϵͳˡϡ+󻯺Сʱ̬ʾڡѡ
	BOOL m_bIsOpend;			//ӰǷ񱻴

	VOID CheckEnvironment();	//黷ȷǷ֧Ӱ
	VOID DestroyShadows();		//Ӱ
	VOID CreateShadows();		//Ӱ
	VOID ShowShadows(BOOL bShow, BOOL bForce = FALSE);//ʾӰ
	VOID AdjustShadowPos();     //Ӱڳߴλ
	VOID UpdateShadowEdge(INT X, INT Y, INT nWidth, INT nHeight, INT nType);//Ӱ

};

#endif //__SHADOWWINDOW_H_
