# Contributing to open-strawberry

We're excited that you're interested in contributing to open-strawberry! This document outlines the process for contributing to this project and provides some guidelines to ensure a smooth collaboration.

## Table of Contents

1. [Code of Conduct](#code-of-conduct)
2. [Getting Started](#getting-started)
3. [How to Contribute](#how-to-contribute)
4. [Reporting Bugs](#reporting-bugs)
5. [Suggesting Enhancements](#suggesting-enhancements)
6. [Pull Request Process](#pull-request-process)
7. [Style Guidelines](#style-guidelines)
8. [Community](#community)

## Code of Conduct

By participating in this project, you are expected to uphold our [Code of Conduct](CODE_OF_CONDUCT.md). Please report unacceptable behavior to [pseudotensor@gmail.com](mailto:pseudotensor@gmail.com).

## Getting Started

1. Fork the repository on GitHub.
2. Clone your fork locally: `git clone https://github.com/pseudotensor/open-strawberry.git`
3. Create a new branch for your feature or bug fix: `git checkout -b feature/your-feature-name` or `git checkout -b fix/your-bug-fix`
4. Make your changes and commit them with a clear commit message.
5. Push your changes to your fork: `git push origin your-branch-name`

## How to Contribute

There are many ways to contribute to open-strawberry:

- Implement new features
- Fix bugs
- Improve documentation
- Write tests
- Report issues
- Suggest enhancements

For all contributions, please first discuss the change you wish to make via issue, email, or any other method with the owners of this repository before making a change.

## Reporting Bugs

1. Ensure the bug was not already reported by searching on GitHub under [Issues](https://github.com/pseudotensor/open-strawberry/issues).
2. If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/pseudotensor/open-strawberry/issues/new). Be sure to include a title and clear description, as much relevant information as possible, and a code sample or an executable test case demonstrating the expected behavior that is not occurring.

## Suggesting Enhancements

1. Open a new issue with a clear title and detailed description.
2. Provide any relevant examples or mock-ups that could help explain your suggestion.
3. Explain why this enhancement would be useful to most open-strawberry users.

## Pull Request Process

1. Ensure any install or build dependencies are removed before the end of the layer when doing a build.
2. Update the README.md with details of changes to the interface, this includes new environment variables, exposed ports, useful file locations and container parameters.
3. Increase the version numbers in any examples files and the README.md to the new version that this Pull Request would represent. The versioning scheme we use is [SemVer](http://semver.org/).
4. You may merge the Pull Request in once you have the sign-off of two other developers, or if you do not have permission to do that, you may request the second reviewer to merge it for you.

## Style Guidelines

- Follow the [PEP 8](https://www.python.org/dev/peps/pep-0008/) style guide for Python code.
- Use clear, descriptive variable and function names.
- Comment your code where necessary, especially for complex logic.
- Write clear, concise commit messages.

## Community

- Join our [Slack channel](https://open-strawberry.slack.com) for discussions and questions.
- Follow us on [Twitter](https://twitter.com/open-strawberry) for updates.
- Check out our [blog](https://open-strawberry.github.io/blog) for in-depth articles and tutorials.
- Discuss on [Discord](https://discord.com/invite/generative-h2o-ai-community-1097462770674438174) with the community.

Thank you for contributing to open-strawberry!