# Contribute to Rickshaw

Thanks for contributing!

## Issues

We're currently overhauling how we do issues. Before we have a template in place and relevant labels, it would be great if you made your issue concise, clear, and to the point. If you have labels that you would suggest we add, please add this line with suggested labels at the bottom of the issue:

`Suggested labels: example, another-example-label`

If you'd like to weigh in on labels, check out [this issue](https://github.com/shutterstock/rickshaw/issues/588).

## Pull requests are always welcome!

Please follow a few guidelines:

- Please don't include updated versions of `rickshaw.js` and `rickshaw.min.js`. Just changes to the source files will suffice.
- Add a unit test or two to cover the proposed changes
- Please run the tests and make sure tests are all passing before submitting your pull request
- Do as the Romans do and stick with existing whitespace and formatting conventions (i.e., tabs instead of spaces, etc)
- Consider adding a simple example under examples/ that demonstrates any new functionality

## Code of Conduct

All interactions with Shutterstock follow the [Contributor Covenant Code of Conduct](CODE_OF_CONDUCT.md).
