---
layout: page
permalink: /privacy/
title: "Privacy Q&amp;A"
description: "This Privacy Statement explains what information PrivacyTools and its related entities collect about its users, what we do with that information, and how we handle the content you place in our products and services."
---

## Who is {{ site.name }}?

{{ site.name }} is an unincorporated community developing this website and a number of privacy-friendly services. The current list of public team members [can be found on GitHub](https://github.com/orgs/privacytools/people). In order to operate these services, {{ site.name }} receives hosting and administration services from Aragon Ventures LLC.

## How does {{ site.name }} collect data about me?

We collect data:

* When you browse a website, forum, or other {{ site.name }} service.
* When you create an account on a {{ site.name }} service.
* When you post, send private messages, or otherwise participate on a {{ site.name }} service.

This data will be collected regardless of browser, device, or app used to access our services. We do not buy or otherwise receive data from data brokers.

## What data do you collect and why?

### We collect data about visits to our websites.

When you visit a {{ site.name }} website or service, regardless of whether you have an account or not, the website may use cookies, server logs, and other methods to collect the following data:

* What pages you visit,
* Your anonymized IP address: We anonymize the last 3 bytes of your IP, e.g. 192.xxx.xxx.xxx.

We use this data to:

* Optimize websites and services, so that they are quick and easy to use,
* Diagnose and debug technical errors,
* Defend websites and services from abuse and technical attacks.

This data is processed under our [Legitimate Interest](https://ico.org.uk/for-organisations/guide-to-data-protection/guide-to-the-general-data-protection-regulation-gdpr/legitimate-interests/when-can-we-rely-on-legitimate-interests/) to provide our services to you in a an efficient and secure manner and to ensure the legal compliance and proper administration of our business.

Raw data such as pages visited, anonymized visitor IPs, and visitor actions will be retained for 60 days. In special circumstances—such as extended investigations regarding a technical attack—we may preserve logged data for longer periods for analysis. We store aggregate statistics about use of the websites and services we host indefinitely, but those statistics do not include data identifiable to you personally.

### We collect account data.

On some websites and services we provide, many features may require an account. For example, on forum.privacytools.io an account is required to post and reply to topics.

To sign up for most accounts, we will collect a name, username, email, and password. In the event a website requires more information than just that data, that will be clearly marked and noted in a separate privacy statement, per-site.

We use your account data to identify you on the website, and to create pages specific to you, such as your profile page. We will also use your account data to publish a public profile for you on our services.

We use your email to:

* Notify you about posts and other activity on the websites or services.
* Reset your password and help keep your account secure.
* Contact you in special circumstances related to your account.
* Contact you about legal requests, such as DMCA takedown requests.

On some websites and services you may provide additional information for your account, such as a short biography, avatar, your location, or your birthday. We make that information available to everyone who can access the website or service in question. This information is not required to use any of our services, and can be erased at any time.

We will store your account data as long as your account remains open. After closing an account, we may retain some or all of your account data in the form of backups or archives for up to 90 days.

## Who is my data shared with?

When you use services provided by {{ site.name }} your data is shared with Aragon Ventures LLC, in order to facilitate their hosting obligations. Aragon Ventures LLC may collect and use your data as described in their privacy statement at [https://aragon.ventures/privacy](https://aragon.ventures/privacy/).

Your account data, posts, and other activities on {{ site.name }} services is shared with others as mentioned in the section about account data.

## Where is my data stored?

Your data is stored on servers provided by Aragon Ventures LLC, a company incorporated in Minnesota, United States. The primary datacenter for {{ site.name }} is located in France. Some websites, services, or backups may reside in datacenters in multiple jurisdictions, including the United States and the European Union.

## Is {{ site.name }} GDPR compliant?

We respect privacy rights under [Regulation (EU) 2016/679](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=uriserv:OJ.L_.2016.119.01.0001.01.ENG), the European Union’s General Data Protection Regulation (GDPR). Information that GDPR requires us to give can be found throughout this document.

## What are my data protection rights?

We would like to make sure you are fully aware of all of your data protection rights. Every user is entitled to the following:

* **The right to access** – You have the right to request access to your personal data, or copies of your personal data from us. We may charge you a small fee for providing a copy of your data.
* **The right to rectification** – You have the right to request that we correct any information you believe is inaccurate or incomplete.
* **The right to erasure** – You have the right to request that we erase your personal data, under certain conditions.
* **The right to restrict processing** – You have the right to request that we restrict the processing of your personal data, under certain conditions.
* **The right to object to processing** – You have the right to object to our processing of your personal data, under certain conditions.
* **The right to data portability** – You have the right to request that we transfer the data that we have collected to another organization, or directly to you, under certain conditions.

## How can I contact the {{ site.name }} team about privacy?

The {{ site.name }} team generally does not have access to personal data outside of limited access granted via some moderation panels. Inquiries regarding your personal information should be sent directly to the data controller for these services, Aragon Ventures LLC:

```
Jonah Aragon
Services Administrator, Aragon Ventures LLC
privacy@aragon.ventures
```

or write to:

```
Aragon Ventures LLC
PO Box 201
Anoka, MN 55303
United States
```

For all other inquiries, you can contact the team via methods described on our [contact page]({{ site.production_url }}/contact/).

For complaints under GDPR more generally, European Union users may lodge complaints with their local data protection supervisory authorities.

## How can I find out about changes to this document?

This version of our privacy statement took effect October 9th, 2019.

We will post any new versions of this statement at [{{ site.production_url }}/privacy/]({{ site.production_url }}/privacy/). We may change how we announce changes in future versions of this document. In the meantime we may update our contact information at any time without announcing a change. Please refer to [{{ site.production_url }}/privacy/]({{ site.production_url }}/privacy/) for the latest contact information at any time.

A full [revision history](https://github.com/privacytools/privacytools.io/commits/master/pages/privacy.md) for this page can be found on GitHub.
