# -*- coding: utf-8 -*-

item_constants = {
1: 'MASTER_BALL',
2: 'ULTRA_BALL',
3: 'BRIGHTPOWDER',
4: 'GREAT_BALL',
5: 'POKE_BALL',
7: 'BICYCLE',
8: 'MOON_STONE',
9: 'ANTIDOTE',
10: 'BURN_HEAL',
11: 'ICE_HEAL',
12: 'AWAKENING',
13: 'PARLYZ_HEAL',
14: 'FULL_RESTORE',
15: 'MAX_POTION',
16: 'HYPER_POTION',
17: 'SUPER_POTION',
18: 'POTION',
19: 'ESCAPE_ROPE',
20: 'REPEL',
21: 'MAX_ELIXER',
22: 'FIRE_STONE',
23: 'THUNDERSTONE',
24: 'WATER_STONE',
26: 'HP_UP',
27: 'PROTEIN',
28: 'IRON',
29: 'CARBOS',
30: 'LUCKY_PUNCH',
31: 'CALCIUM',
32: 'RARE_CANDY',
33: 'X_ACCURACY',
34: 'LEAF_STONE',
35: 'METAL_POWDER',
36: 'NUGGET',
37: 'POKE_DOLL',
38: 'FULL_HEAL',
39: 'REVIVE',
40: 'MAX_REVIVE',
41: 'GUARD_SPEC',
42: 'SUPER_REPEL',
43: 'MAX_REPEL',
44: 'DIRE_HIT',
46: 'FRESH_WATER',
47: 'SODA_POP',
48: 'LEMONADE',
49: 'X_ATTACK',
51: 'X_DEFEND',
52: 'X_SPEED',
53: 'X_SPECIAL',
54: 'COIN_CASE',
55: 'ITEMFINDER',
57: 'EXP_SHARE',
58: 'OLD_ROD',
59: 'GOOD_ROD',
60: 'SILVER_LEAF',
61: 'SUPER_ROD',
62: 'PP_UP',
63: 'ETHER',
64: 'MAX_ETHER',
65: 'ELIXER',
66: 'RED_SCALE',
67: 'SECRETPOTION',
68: 'S_S_TICKET',
69: 'MYSTERY_EGG',
70: 'CLEAR_BELL',
71: 'SILVER_WING',
72: 'MOOMOO_MILK',
73: 'QUICK_CLAW',
74: 'PSNCUREBERRY',
75: 'GOLD_LEAF',
76: 'SOFT_SAND',
77: 'SHARP_BEAK',
78: 'PRZCUREBERRY',
79: 'BURNT_BERRY',
80: 'ICE_BERRY',
81: 'POISON_BARB',
82: "KINGS_ROCK",
83: 'BITTER_BERRY',
84: 'MINT_BERRY',
85: 'RED_APRICORN',
86: 'TINYMUSHROOM',
87: 'BIG_MUSHROOM',
88: 'SILVERPOWDER',
89: 'BLU_APRICORN',
91: 'AMULET_COIN',
92: 'YLW_APRICORN',
93: 'GRN_APRICORN',
94: 'CLEANSE_TAG',
95: 'MYSTIC_WATER',
96: 'TWISTEDSPOON',
97: 'WHT_APRICORN',
98: 'BLACKBELT',
99: 'BLK_APRICORN',
101: 'PNK_APRICORN',
102: 'BLACKGLASSES',
103: 'SLOWPOKETAIL',
104: 'PINK_BOW',
105: 'STICK',
106: 'SMOKE_BALL',
107: 'NEVERMELTICE',
108: 'MAGNET',
109: 'MIRACLEBERRY',
110: 'PEARL',
111: 'BIG_PEARL',
112: 'EVERSTONE',
113: 'SPELL_TAG',
114: 'RAGECANDYBAR',
115: 'GS_BALL',
116: 'BLUE_CARD',
117: 'MIRACLE_SEED',
118: 'THICK_CLUB',
119: 'FOCUS_BAND',
121: 'ENERGYPOWDER',
122: 'ENERGY_ROOT',
123: 'HEAL_POWDER',
124: 'REVIVAL_HERB',
125: 'HARD_STONE',
126: 'LUCKY_EGG',
127: 'CARD_KEY',
128: 'MACHINE_PART',
129: 'EGG_TICKET',
130: 'LOST_ITEM',
131: 'STARDUST',
132: 'STAR_PIECE',
133: 'BASEMENT_KEY',
134: 'PASS',
138: 'CHARCOAL',
139: 'BERRY_JUICE',
140: 'SCOPE_LENS',
143: 'METAL_COAT',
144: 'DRAGON_FANG',
146: 'LEFTOVERS',
150: 'MYSTERYBERRY',
151: 'DRAGON_SCALE',
152: 'BERSERK_GENE',
156: 'SACRED_ASH',
157: 'HEAVY_BALL',
158: 'FLOWER_MAIL',
159: 'LEVEL_BALL',
160: 'LURE_BALL',
161: 'FAST_BALL',
163: 'LIGHT_BALL',
164: 'FRIEND_BALL',
165: 'MOON_BALL',
166: 'LOVE_BALL',
167: 'NORMAL_BOX',
168: 'GORGEOUS_BOX',
169: 'SUN_STONE',
170: 'POLKADOT_BOW',
172: 'UP_GRADE',
173: 'BERRY',
174: 'GOLD_BERRY',
175: 'SQUIRTBOTTLE',
177: 'PARK_BALL',
178: 'RAINBOW_WING',
180: 'BRICK_PIECE',
181: 'SURF_MAIL',
182: 'LITEBLUEMAIL',
183: 'PORTRAITMAIL',
184: 'LOVELY_MAIL',
185: 'EON_MAIL',
186: 'MORPH_MAIL',
187: 'BLUESKY_MAIL',
188: 'MUSIC_MAIL',
189: 'MIRAGE_MAIL',
191: 'TM_01',
192: 'TM_02',
193: 'TM_03',
194: 'TM_04',
196: 'TM_05',
197: 'TM_06',
198: 'TM_07',
199: 'TM_08',
200: 'TM_09',
201: 'TM_10',
202: 'TM_11',
203: 'TM_12',
204: 'TM_13',
205: 'TM_14',
206: 'TM_15',
207: 'TM_16',
208: 'TM_17',
209: 'TM_18',
210: 'TM_19',
211: 'TM_20',
212: 'TM_21',
213: 'TM_22',
214: 'TM_23',
215: 'TM_24',
216: 'TM_25',
217: 'TM_26',
218: 'TM_27',
219: 'TM_28',
221: 'TM_29',
222: 'TM_30',
223: 'TM_31',
224: 'TM_32',
225: 'TM_33',
226: 'TM_34',
227: 'TM_35',
228: 'TM_36',
229: 'TM_37',
230: 'TM_38',
231: 'TM_39',
232: 'TM_40',
233: 'TM_41',
234: 'TM_42',
235: 'TM_43',
236: 'TM_44',
237: 'TM_45',
238: 'TM_46',
239: 'TM_47',
240: 'TM_48',
241: 'TM_49',
242: 'TM_50',
243: 'HM_01',
244: 'HM_02',
245: 'HM_03',
246: 'HM_04',
247: 'HM_05',
248: 'HM_06',
249: 'HM_07',
}

def find_item_label_by_id(id):
    if id in item_constants.keys():
        return item_constants[id]
    else: return None

def generate_item_constants():
    """make a list of items to put in constants.asm"""
    output = ""
    for (id, item) in item_constants.items():
        val = ("$%.2x"%id).upper()
        while len(item)<13: item+= " "
        output += item + " EQU " + val + "\n"
    return output
