NITROFS_FILES := data/UTF16.dat \
                 data/area00light.txt \
                 data/area01light.txt \
                 data/area02light.txt \
                 data/battle_win.NSCR \
                 data/btower_canm.resdat \
                 data/btower_celact.cldat \
                 data/btower_cell.resdat \
                 data/btower_chr.resdat \
                 data/btower_pal.resdat \
                 data/cell0.NCGR \
                 data/cell0.NCLR \
                 data/clact_default.NANR \
                 data/crystal.nsbmd \
                 data/demo_climax.narc \
                 data/dp_areawindow.NCGR \
                 data/dp_areawindow.NCLR \
                 data/dt_test_celact.txt \
                 data/dt_test_res_cell.txt \
                 data/dt_test_res_cellanm.txt \
                 data/dt_test_res_char.txt \
                 data/dt_test_res_multi.txt \
                 data/dt_test_res_multianm.txt \
                 data/dt_test_res_pltt.txt \
                 data/dun_sea.nsbtx \
                 data/eoo.dat \
                 data/exdata.dat \
                 data/field_cutin.narc \
                 data/fld_anime0.bin \
                 data/fld_anime1.bin \
                 data/fld_anime10.bin \
                 data/fld_anime2.bin \
                 data/fld_anime3.bin \
                 data/fld_anime4.bin \
                 data/fld_anime5.bin \
                 data/fld_anime6.bin \
                 data/fld_anime7.bin \
                 data/fld_anime8.bin \
                 data/fld_anime9.bin \
                 data/fs_kanban.nsbca \
                 data/ground0.NCGR \
                 data/ground0.NCLR \
                 data/ground0.NSCR \
                 data/kemu_itpconv.dat \
                 data/lake_anim.nsbtx \
                 data/miniasahamabe.nsbtx \
                 data/miniasasea.nsbtx \
                 data/minihamabe.nsbtx \
                 data/minimum.nsbtx \
                 data/minirhana.nsbtx \
                 data/namein.narc \
                 data/nfont.NCGR \
                 data/nfont.NCLR \
                 data/pc.nsbca \
                 data/plist_canm.resdat \
                 data/plist_cell.resdat \
                 data/plist_chr.resdat \
                 data/plist_h.cldat \
                 data/plist_pal.resdat \
                 data/porucase_canm.resdat \
                 data/porucase_celact.cldat \
                 data/porucase_cell.resdat \
                 data/porucase_chr.resdat \
                 data/porucase_pal.resdat \
                 data/pst_canm.resdat \
                 data/pst_cell.resdat \
                 data/pst_chr.resdat \
                 data/pst_h.cldat \
                 data/pst_pal.resdat \
                 data/shop_canm.resdat \
                 data/shop_cell.resdat \
                 data/shop_chr.resdat \
                 data/shop_h.cldat \
                 data/shop_pal.resdat \
                 data/slot.narc \
                 data/smptm_koori.NANR \
                 data/smptm_koori.NCER \
                 data/smptm_koori.NCGR \
                 data/smptm_koori.NCLR \
                 data/smptm_nemuri.NANR \
                 data/smptm_nemuri.NCER \
                 data/smptm_nemuri.NCGR \
                 data/smptm_nemuri.NCLR \
                 data/t3_fl_b.nsbtx \
                 data/t3_fl_p.nsbtx \
                 data/t3_fl_r.nsbtx \
                 data/t3_fl_y.nsbtx \
                 data/test.atr \
                 data/tmap_block.dat \
                 data/tmap_flags.dat \
                 data/tmapn_canm.resdat \
                 data/tmapn_celact.cldat \
                 data/tmapn_celact.txt \
                 data/tmapn_cell.resdat \
                 data/tmapn_chr.resdat \
                 data/tmapn_pal.resdat \
                 data/tmapn_res_canm.txt \
                 data/tmapn_res_cell.txt \
                 data/tmapn_res_chr.txt \
                 data/tmapn_res_pal.txt \
                 data/tradelist.narc \
                 data/trapmark.narc \
                 data/ug_anim.narc \
                 data/ug_base_cur.nsbmd \
                 data/ug_boygirl.NCGR \
                 data/ug_boygirl.NCLR \
                 data/ug_fossil.narc \
                 data/ug_hero.NANR \
                 data/ug_hero.NCER \
                 data/ug_hole.NANR \
                 data/ug_hole.NCER \
                 data/ug_hole.NCGR \
                 data/ug_parts.narc \
                 data/ug_radar.narc \
                 data/ug_trap.narc \
                 data/ugeffect_obj_graphic.narc \
                 data/uground_cell.resdat \
                 data/uground_cellanm.resdat \
                 data/uground_char.resdat \
                 data/uground_char2.resdat \
                 data/uground_clact.cldat \
                 data/uground_pltt.resdat \
                 data/uground_pltt2.resdat \
                 data/underg_radar.narc \
                 data/utility.bin \
                 data/weather_sys.narc \
                 data/wifi.ncgr \
                 data/wifinote.narc \
                 data/wifip2pmatch.narc \
                 data/wm.ncgr \
                 data/wm.nclr \
                 data/sound/sound_data.sdat \
                 msgdata/msg.narc \
                 msgdata/scenario/scr_msg.narc \
                 poketool/pokegra/height.narc \
                 poketool/pokegra/height_o.narc \
                 poketool/pokegra/otherpoke.narc \
                 poketool/pokegra/poke_shadow.narc \
                 poketool/pokegra/poke_shadow_ofx.narc \
                 poketool/pokegra/poke_yofs.narc \
                 poketool/pokegra/pokegra.narc \
                 poketool/trgra/trbgra.narc \
                 poketool/trgra/trfgra.narc \
                 poketool/personal/personal.narc \
                 poketool/personal/evo.narc \
                 poketool/personal/growtbl.narc \
                 poketool/personal/pms.narc \
                 poketool/personal/wotbl.narc \
                 poketool/trainer/trdata.narc \
                 poketool/trainer/trpoke.narc \
                 poketool/trmsg/trtbl.narc \
                 poketool/trmsg/trtblofs.narc \
                 battle/graphic/b_bag_gra.narc \
                 battle/graphic/b_plist_gra.narc \
                 battle/graphic/batt_bg.narc \
                 battle/graphic/batt_obj.narc \
                 battle/graphic/vs_demo_gra.narc \
                 wazaeffect/we.arc \
                 wazaeffect/we_sub.narc \
                 battle/skill/be_seq.narc \
                 battle/skill/sub_seq.narc \
                 battle/skill/waza_seq.narc \
                 wazaeffect/effectclact/wecell.narc \
                 wazaeffect/effectclact/wecellanm.narc \
                 wazaeffect/effectclact/wechar.narc \
                 wazaeffect/effectclact/wepltt.narc \
                 poketool/waza/waza_tbl.narc \
                 fielddata/script/scr_seq_release.narc \
                 graphic/bag_gra.narc \
                 graphic/box.narc \
                 graphic/btower.narc \
                 graphic/config_gra.narc \
                 graphic/demo_trade.narc \
                 graphic/dendou_demo.narc \
                 graphic/dendou_pc.narc \
                 graphic/ending.narc \
                 graphic/ev_pokeselect.narc \
                 graphic/f_note_gra.narc \
                 graphic/field_board.narc \
                 graphic/field_encounteffect.narc \
                 graphic/fld_comact.narc \
                 graphic/font.narc \
                 graphic/fontoam.narc \
                 graphic/hiden_effect.narc \
                 graphic/imageclip.narc \
                 graphic/mail_gra.narc \
                 graphic/menu_gra.narc \
                 graphic/mysign.narc \
                 graphic/mystery.narc \
                 graphic/ntag_gra.narc \
                 graphic/nutmixer.narc \
                 graphic/oekaki.narc \
                 graphic/opening.narc \
                 graphic/plist_gra.narc \
                 graphic/pmsi.narc \
                 graphic/poketch.narc \
                 graphic/poru_gra.narc \
                 graphic/poruact.narc \
                 graphic/porudemo.narc \
                 graphic/pst_gra.narc \
                 graphic/ranking.narc \
                 graphic/record.narc \
                 graphic/shop_gra.narc \
                 graphic/tmap_gra.narc \
                 graphic/touch_subwindow.narc \
                 graphic/trainer_case.narc \
                 graphic/unionroom.narc \
                 graphic/waza_oshie_gra.narc \
                 graphic/winframe.narc \
                 graphic/worldtrade.narc \
                 itemtool/itemdata/item_data.narc \
                 itemtool/itemdata/item_icon.narc \
                 itemtool/itemdata/nuts_data.narc \
                 poketool/icongra/poke_icon.narc \
                 poketool/pokefoot/pokefoot.narc \
                 data/mmodel/mmodel.narc \
                 data/mmodel/fldeff.narc \
                 wazaeffect/effectdata/ball_particle.narc \
                 wazaeffect/effectdata/waza_particle.narc \
                 wazaeffect/pt_debug/debug_particle.narc \
                 fielddata/eventdata/zone_event_release.narc \
                 fielddata/encountdata/d_enc_data.narc \
                 fielddata/encountdata/p_enc_data.narc \
                 fielddata/build_model/build_model.narc \
                 fielddata/build_model/build_model_matshp.dat \
                 fielddata/mapmatrix/map_matrix.narc \
                 fielddata/areadata/area_data.narc \
                 fielddata/areadata/area_build_model/area_build.narc \
                 fielddata/areadata/area_build_model/areabm_texset.narc \
                 fielddata/areadata/area_map_tex/map_tex_set.narc \
                 fielddata/areadata/area_move_model/move_model_list.narc \
                 fielddata/land_data/land_data_release.narc \
                 contest/graphic/contest_bg.narc \
                 contest/graphic/contest_obj.narc \
                 contest/data/contest_data.narc \
                 particledata/particledata.narc \
                 application/zukanlist/zkn_data/zukan_data.narc \
                 application/wifi_earth/wifi_earth.narc \
                 application/wifi_earth/wifi_earth_place.narc \
                 demo/title/titledemo.narc \
                 application/custom_ball/data/cb_data.narc \
                 demo/egg/data/egg_data.narc \
                 demo/egg/data/particle/egg_demo_particle.narc \
                 fielddata/mm_list/move_model_list.narc \
                 pokeanime/poke_anm.narc \
                 battle/tr_ai/tr_ai_seq.narc \
                 arc/bm_anime.narc \
                 arc/bm_anime_list.narc \
                 arc/encdata_ex.narc \
                 arc/ppark.narc \
                 arc/ship_demo.narc \
                 arc/tv.narc \
                 fielddata/maptable/mapname.bin \
                 poketool/pokezukan.narc \
                 poketool/shinzukan.narc \
                 poketool/pokeanm/pokeanm.narc \
                 fielddata/pokemon_trade/fld_trade.narc \
                 demo/shinka/data/particle/shinka_demo_particle.narc \
                 demo/intro/intro.narc \
                 demo/intro/intro_tv.narc \
                 demo/title/op_demo.narc \
                 demo/syoujyou/syoujyou.narc \
                 battle/b_tower/btdpm.narc \
                 battle/b_tower/btdtr.narc \
                 application/zukanlist/zkn_data/zukan_enc_diamond.narc \
                 application/zukanlist/zkn_data/zukan_enc_pearl.narc \
                 resource/eng/trial/trial.narc \
                 resource/eng/zukan/zukan.narc \
                 dwc/utility.bin

ifeq ($(GAME_VERSION),PEARL)
NITROFS_FILES := $(NITROFS_FILES:poketool/personal/personal.narc=poketool/personal_pearl/personal.narc)
endif

HOSTFS_FILES := $(NITROFS_FILES:%=files/%)

%.narc:
	$(KNARC) -d $(basename $@)/ -p $@ -i

%.arc:
	$(KNARC) -d $(basename $@)/ -p $@ -i

%.naix: %.narc
files/wazaeffect/we.naix: %.naix: %.arc

O2NARC_TARGETS := \
	files/poketool/personal/personal.narc \
	files/poketool/personal_pearl/personal.narc \
	files/poketool/personal/wotbl.narc \
	files/poketool/personal/evo.narc \
	files/poketool/personal/growtbl.narc \
	files/poketool/personal/pms.narc \
	files/poketool/waza/waza_tbl.narc \
	files/itemtool/itemdata/item_data.narc \
	files/itemtool/itemdata/nuts_data.narc \
	files/poketool/trainer/trdata.narc \

ALL_O2NARC_TARGETS := $(O2NARC_TARGETS) \
	files/poketool/trainer/trpoke.narc

O2NARCFLAGS := -i
files/poketool/personal/pms.narc: O2NARCFLAGS = -f
files/itemtool/itemdata/item_data.narc: O2NARCFLAGS += -p 0xFF

ifeq (,$(NODEP))
$(ALL_O2NARC_TARGETS): dep = $(shell $(SCANINC) -I include -I include-mw -I arm9/lib/include $(patsubst %.narc,%.json.txt,$@))
else
$(ALL_O2NARC_TARGETS): dep :=
endif

## This specific target shares its source JSON with trdata.narc
files/poketool/trainer/trpoke.narc: %/trpoke.narc: %/trdata.json %/trpoke.json.txt $$(dep)
	$(JSONPROC) $< $(word 2,$^) $*/trpoke.c
	$(CC) $(MWCFLAGS) -c -o $*/trpoke.o $*/trpoke.c
	$(O2NARC) $(O2NARCFLAGS) $*/trpoke.o $@
	@$(RM) $*/trpoke.o $*/trpoke.c

$(O2NARC_TARGETS): %.narc: %.json %.json.txt $$(dep)
	$(JSONPROC) $*.json $*.json.txt $*.c
	$(CC) $(MWCFLAGS) -c -o $*.o $*.c
	$(O2NARC) $(O2NARCFLAGS) $*.o $@
	@$(RM) $*.o $*.c $*/*.c $*/*.o

files/application/wifi_earth/wifi_earth.narc: \
		files/application/wifi_earth/wifi_earth/narc_0005.NCGR \
		files/application/wifi_earth/wifi_earth/narc_0006.NCLR

files/battle/graphic/batt_bg.narc: \
        files/battle/graphic/batt_bg/narc_0156.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0142.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0022.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0036.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0037.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0023.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0143.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0141.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0155.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0035.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0021.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0009.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0008.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0020.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0034.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0154.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0140.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0144.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0150.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0018.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0030.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0024.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0025.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0031.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0019.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0151.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0145.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0153.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0147.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0027.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0033.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0032.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0026.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0146.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0152.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0135.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0121.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0109.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0082.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0096.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0041.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0055.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0069.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0068.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0054.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0040.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0097.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0083.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0108.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0120.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0134.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0122.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0136.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0095.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0081.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0056.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0042.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0043.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0057.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0080.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0094.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0137.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0123.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0127.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0133.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0090.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0084.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0053.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0047.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0046.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0052.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0085.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0091.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0132.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0126.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0118.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0130.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0124.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0087.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0093.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0078.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0044.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0050.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0051.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0045.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0079.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0092.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0086.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0125.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0131.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0119.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0114.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0100.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0128.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0060.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0074.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0048.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0049.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0075.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0061.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0129.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0101.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0115.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0103.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0117.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0088.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0077.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0063.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0062.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0076.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0089.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0116.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0102.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0106.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0112.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0099.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0072.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0066.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0067.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0073.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0098.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0113.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0107.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0139.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0111.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0105.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0059.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0065.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0071.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0070.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0064.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0058.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0104.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0110.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0138.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0003.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0017.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0016.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0002.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0148.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0014.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0000.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0028.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0029.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0001.NSCR.lz \
        files/battle/graphic/batt_bg/narc_0015.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0149.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0039.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0011.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0005.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0004.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0010.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0038.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0006.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0012.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0013.NCGR.lz \
        files/battle/graphic/batt_bg/narc_0007.NCGR.lz

files/battle/graphic/batt_obj.narc: \
        files/battle/graphic/batt_obj/narc_0195.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0181.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0156.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0142.NANR.lz \
        files/battle/graphic/batt_obj/narc_0220.NCER.lz \
        files/battle/graphic/batt_obj/narc_0234.NANR.lz \
        files/battle/graphic/batt_obj/narc_0208.NCER.lz \
        files/battle/graphic/batt_obj/narc_0209.NCER.lz \
        files/battle/graphic/batt_obj/narc_0235.NCER.lz \
        files/battle/graphic/batt_obj/narc_0221.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0143.NCER.lz \
        files/battle/graphic/batt_obj/narc_0157.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0180.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0194.NANR.lz \
        files/battle/graphic/batt_obj/narc_0182.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0196.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0141.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0155.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0169.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0237.NANR.lz \
        files/battle/graphic/batt_obj/narc_0223.NCER.lz \
        files/battle/graphic/batt_obj/narc_0222.NANR.lz \
        files/battle/graphic/batt_obj/narc_0236.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0168.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0154.NANR.lz \
        files/battle/graphic/batt_obj/narc_0140.NCER.lz \
        files/battle/graphic/batt_obj/narc_0197.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0183.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0187.NCER.lz \
        files/battle/graphic/batt_obj/narc_0193.NCER.lz \
        files/battle/graphic/batt_obj/narc_0178.NCER.lz \
        files/battle/graphic/batt_obj/narc_0144.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0150.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0232.NCER.lz \
        files/battle/graphic/batt_obj/narc_0226.NCER.lz \
        files/battle/graphic/batt_obj/narc_0227.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0233.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0151.NANR.lz \
        files/battle/graphic/batt_obj/narc_0145.NANR.lz \
        files/battle/graphic/batt_obj/narc_0179.NANR.lz \
        files/battle/graphic/batt_obj/narc_0192.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0186.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0190.NCER.lz \
        files/battle/graphic/batt_obj/narc_0184.NCER.lz \
        files/battle/graphic/batt_obj/narc_0153.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0147.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0219.NANR.lz \
        files/battle/graphic/batt_obj/narc_0225.NANR.lz \
        files/battle/graphic/batt_obj/narc_0231.NANR.lz \
        files/battle/graphic/batt_obj/narc_0230.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0224.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0218.NANR.lz \
        files/battle/graphic/batt_obj/narc_0146.NCER.lz \
        files/battle/graphic/batt_obj/narc_0152.NCER.lz \
        files/battle/graphic/batt_obj/narc_0185.NANR.lz \
        files/battle/graphic/batt_obj/narc_0191.NANR.lz \
        files/battle/graphic/batt_obj/narc_0135.NCER.lz \
        files/battle/graphic/batt_obj/narc_0121.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0109.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0082.NCER.lz \
        files/battle/graphic/batt_obj/narc_0096.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0243.NANR.lz \
        files/battle/graphic/batt_obj/narc_0257.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0256.NCER.lz \
        files/battle/graphic/batt_obj/narc_0242.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0097.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0083.NANR.lz \
        files/battle/graphic/batt_obj/narc_0108.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0120.NCER.lz \
        files/battle/graphic/batt_obj/narc_0134.NANR.lz \
        files/battle/graphic/batt_obj/narc_0122.NANR.lz \
        files/battle/graphic/batt_obj/narc_0136.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0095.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0081.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0254.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0240.NANR.lz \
        files/battle/graphic/batt_obj/narc_0268.NCER.lz \
        files/battle/graphic/batt_obj/narc_0269.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0241.NCER.lz \
        files/battle/graphic/batt_obj/narc_0255.NANR.lz \
        files/battle/graphic/batt_obj/narc_0080.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0094.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0137.NANR.lz \
        files/battle/graphic/batt_obj/narc_0123.NCER.lz \
        files/battle/graphic/batt_obj/narc_0127.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0133.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0090.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0084.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0251.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0245.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0244.NCER.lz \
        files/battle/graphic/batt_obj/narc_0250.NCER.lz \
        files/battle/graphic/batt_obj/narc_0278.NANR.lz \
        files/battle/graphic/batt_obj/narc_0085.NCER.lz \
        files/battle/graphic/batt_obj/narc_0091.NCER.lz \
        files/battle/graphic/batt_obj/narc_0132.NCER.lz \
        files/battle/graphic/batt_obj/narc_0126.NCER.lz \
        files/battle/graphic/batt_obj/narc_0118.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0130.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0124.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0087.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0093.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0078.NANR.lz \
        files/battle/graphic/batt_obj/narc_0246.NANR.lz \
        files/battle/graphic/batt_obj/narc_0252.NANR.lz \
        files/battle/graphic/batt_obj/narc_0253.NCER.lz \
        files/battle/graphic/batt_obj/narc_0247.NCER.lz \
        files/battle/graphic/batt_obj/narc_0079.NCER.lz \
        files/battle/graphic/batt_obj/narc_0092.NANR.lz \
        files/battle/graphic/batt_obj/narc_0086.NANR.lz \
        files/battle/graphic/batt_obj/narc_0125.NANR.lz \
        files/battle/graphic/batt_obj/narc_0131.NANR.lz \
        files/battle/graphic/batt_obj/narc_0119.NANR.lz \
        files/battle/graphic/batt_obj/narc_0114.NCER.lz \
        files/battle/graphic/batt_obj/narc_0100.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0128.NANR.lz \
        files/battle/graphic/batt_obj/narc_0262.NCER.lz \
        files/battle/graphic/batt_obj/narc_0276.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0277.NCER.lz \
        files/battle/graphic/batt_obj/narc_0263.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0075.NANR.lz \
        files/battle/graphic/batt_obj/narc_0129.NCER.lz \
        files/battle/graphic/batt_obj/narc_0101.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0115.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0103.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0117.NCER.lz \
        files/battle/graphic/batt_obj/narc_0088.NCER.lz \
        files/battle/graphic/batt_obj/narc_0077.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0275.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0261.NANR.lz \
        files/battle/graphic/batt_obj/narc_0249.NANR.lz \
        files/battle/graphic/batt_obj/narc_0248.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0260.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0274.NCER.lz \
        files/battle/graphic/batt_obj/narc_0076.NCER.lz \
        files/battle/graphic/batt_obj/narc_0089.NANR.lz \
        files/battle/graphic/batt_obj/narc_0116.NANR.lz \
        files/battle/graphic/batt_obj/narc_0102.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0106.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0112.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0099.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0258.NANR.lz \
        files/battle/graphic/batt_obj/narc_0270.NANR.lz \
        files/battle/graphic/batt_obj/narc_0264.NANR.lz \
        files/battle/graphic/batt_obj/narc_0265.NCER.lz \
        files/battle/graphic/batt_obj/narc_0271.NCER.lz \
        files/battle/graphic/batt_obj/narc_0259.NCER.lz \
        files/battle/graphic/batt_obj/narc_0098.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0113.NANR.lz \
        files/battle/graphic/batt_obj/narc_0107.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0139.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0111.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0105.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0267.NANR.lz \
        files/battle/graphic/batt_obj/narc_0273.NANR.lz \
        files/battle/graphic/batt_obj/narc_0272.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0266.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0104.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0110.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0138.NCER.lz \
        files/battle/graphic/batt_obj/narc_0188.NANR.lz \
        files/battle/graphic/batt_obj/narc_0177.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0163.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0201.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0215.NANR.lz \
        files/battle/graphic/batt_obj/narc_0229.NCER.lz \
        files/battle/graphic/batt_obj/narc_0228.NANR.lz \
        files/battle/graphic/batt_obj/narc_0214.NANR.lz \
        files/battle/graphic/batt_obj/narc_0200.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0162.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0176.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0189.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0160.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0174.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0148.NANR.lz \
        files/battle/graphic/batt_obj/narc_0216.NANR.lz \
        files/battle/graphic/batt_obj/narc_0202.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0203.NCER.lz \
        files/battle/graphic/batt_obj/narc_0217.NANR.lz \
        files/battle/graphic/batt_obj/narc_0149.NCER.lz \
        files/battle/graphic/batt_obj/narc_0175.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0161.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0159.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0165.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0171.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0213.NANR.lz \
        files/battle/graphic/batt_obj/narc_0207.NCER.lz \
        files/battle/graphic/batt_obj/narc_0206.NCER.lz \
        files/battle/graphic/batt_obj/narc_0212.NANR.lz \
        files/battle/graphic/batt_obj/narc_0170.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0164.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0158.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0199.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0172.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0166.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0238.NCER.lz \
        files/battle/graphic/batt_obj/narc_0204.NCER.lz \
        files/battle/graphic/batt_obj/narc_0210.NCER.lz \
        files/battle/graphic/batt_obj/narc_0211.NANR.lz \
        files/battle/graphic/batt_obj/narc_0205.NCER.lz \
        files/battle/graphic/batt_obj/narc_0239.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0167.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0173.NCGR.lz \
        files/battle/graphic/batt_obj/narc_0198.NCGR.lz

files/demo/egg/data/egg_data.narc: \
        files/demo/egg/data/egg_data/narc_0003.NCER.lz \
        files/demo/egg/data/egg_data/narc_0002.NANR.lz \
        files/demo/egg/data/egg_data/narc_0000.NCGR.lz \
        files/demo/egg/data/egg_data/narc_0001.NSCR.lz \
        files/demo/egg/data/egg_data/narc_0005.NANR.lz \
        files/demo/egg/data/egg_data/narc_0004.NCGR.lz \
        files/demo/egg/data/egg_data/narc_0006.NCER.lz \
        files/demo/egg/data/egg_data/narc_0007.NCGR.lz

files/wazaeffect/effectclact/wecell.narc: \
        files/wazaeffect/effectclact/wecell/narc_0022.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0036.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0023.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0035.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0021.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0009.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0008.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0020.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0034.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0018.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0030.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0024.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0025.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0031.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0019.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0027.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0033.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0032.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0026.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0003.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0017.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0016.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0002.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0014.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0000.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0028.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0029.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0001.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0015.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0011.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0005.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0004.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0010.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0006.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0012.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0013.NCER.lz \
        files/wazaeffect/effectclact/wecell/narc_0007.NCER.lz

files/wazaeffect/effectclact/wechar.narc: \
        files/wazaeffect/effectclact/wechar/narc_0022.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0036.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0023.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0035.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0021.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0009.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0008.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0020.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0034.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0018.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0030.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0024.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0025.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0031.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0019.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0027.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0033.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0032.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0026.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0003.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0017.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0016.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0002.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0014.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0000.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0028.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0029.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0001.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0015.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0011.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0005.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0004.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0010.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0006.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0012.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0013.NCGR.lz \
        files/wazaeffect/effectclact/wechar/narc_0007.NCGR.lz

files/wazaeffect/effectclact/wecellanm.narc: \
        files/wazaeffect/effectclact/wecellanm/narc_0022.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0036.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0023.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0035.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0021.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0009.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0008.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0020.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0034.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0018.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0030.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0024.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0025.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0031.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0019.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0027.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0033.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0032.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0026.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0003.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0017.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0016.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0002.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0014.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0000.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0028.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0029.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0001.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0015.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0011.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0005.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0004.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0010.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0006.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0012.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0013.NANR.lz \
        files/wazaeffect/effectclact/wecellanm/narc_0007.NANR.lz

files/graphic/bag_gra.narc: \
        files/graphic/bag_gra/narc_0002.NCGR \
        files/graphic/bag_gra/narc_0003.NCLR \
        files/graphic/bag_gra/narc_0006.NCGR \
        files/graphic/bag_gra/narc_0034.NCGR \
        files/graphic/bag_gra/narc_0034.NCLR

files/graphic/box.narc: \
        files/graphic/box/narc_0022.NANR.lz \
        files/graphic/box/narc_0036.NSCR.lz \
        files/graphic/box/narc_0023.NCER.lz \
        files/graphic/box/narc_0035.NCGR.lz \
        files/graphic/box/narc_0021.NCER.lz \
        files/graphic/box/narc_0009.NCGR.lz \
        files/graphic/box/narc_0008.NSCR.lz \
        files/graphic/box/narc_0018.NCER.lz \
        files/graphic/box/narc_0030.NSCR.lz \
        files/graphic/box/narc_0024.NANR.lz \
        files/graphic/box/narc_0025.NCGR.lz \
        files/graphic/box/narc_0019.NANR.lz \
        files/graphic/box/narc_0033.NSCR.lz \
        files/graphic/box/narc_0032.NCGR.lz \
        files/graphic/box/narc_0096.NSCR.lz \
        files/graphic/box/narc_0041.NCGR.lz \
        files/graphic/box/narc_0069.NSCR.lz \
        files/graphic/box/narc_0068.NCGR.lz \
        files/graphic/box/narc_0054.NSCR.lz \
        files/graphic/box/narc_0083.NCGR.lz \
        files/graphic/box/narc_0108.NCGR.lz \
        files/graphic/box/narc_0095.NCGR.lz \
        files/graphic/box/narc_0081.NSCR.lz \
        files/graphic/box/narc_0056.NCGR.lz \
        files/graphic/box/narc_0042.NSCR.lz \
        files/graphic/box/narc_0057.NSCR.lz \
        files/graphic/box/narc_0080.NCGR.lz \
        files/graphic/box/narc_0090.NSCR.lz \
        files/graphic/box/narc_0084.NSCR.lz \
        files/graphic/box/narc_0053.NCGR.lz \
        files/graphic/box/narc_0047.NCGR.lz \
        files/graphic/box/narc_0118.NCER.lz \
        files/graphic/box/narc_0087.NSCR.lz \
        files/graphic/box/narc_0093.NSCR.lz \
        files/graphic/box/narc_0078.NSCR.lz \
        files/graphic/box/narc_0044.NCGR.lz \
        files/graphic/box/narc_0050.NCGR.lz \
        files/graphic/box/narc_0051.NSCR.lz \
        files/graphic/box/narc_0045.NSCR.lz \
        files/graphic/box/narc_0092.NCGR.lz \
        files/graphic/box/narc_0086.NCGR.lz \
        files/graphic/box/narc_0119.NANR.lz \
        files/graphic/box/narc_0114.NCGR.lz \
        files/graphic/box/narc_0100.NSCR.lz \
        files/graphic/box/narc_0060.NSCR.lz \
        files/graphic/box/narc_0074.NCGR.lz \
        files/graphic/box/narc_0048.NSCR.lz \
        files/graphic/box/narc_0075.NSCR.lz \
        files/graphic/box/narc_0101.NSCR.lz \
        files/graphic/box/narc_0115.NCER.lz \
        files/graphic/box/narc_0103.NCGR.lz \
        files/graphic/box/narc_0117.NCGR.lz \
        files/graphic/box/narc_0077.NCGR.lz \
        files/graphic/box/narc_0063.NSCR.lz \
        files/graphic/box/narc_0062.NCGR.lz \
        files/graphic/box/narc_0089.NCGR.lz \
        files/graphic/box/narc_0116.NANR.lz \
        files/graphic/box/narc_0102.NSCR.lz \
        files/graphic/box/narc_0106.NSCR.lz \
        files/graphic/box/narc_0112.NANR.lz \
        files/graphic/box/narc_0099.NSCR.lz \
        files/graphic/box/narc_0072.NSCR.lz \
        files/graphic/box/narc_0066.NSCR.lz \
        files/graphic/box/narc_0098.NCGR.lz \
        files/graphic/box/narc_0107.NSCR.lz \
        files/graphic/box/narc_0111.NCER.lz \
        files/graphic/box/narc_0105.NSCR.lz \
        files/graphic/box/narc_0059.NCGR.lz \
        files/graphic/box/narc_0065.NCGR.lz \
        files/graphic/box/narc_0071.NCGR.lz \
        files/graphic/box/narc_0110.NCGR.lz \
        files/graphic/box/narc_0003.NSCR.lz \
        files/graphic/box/narc_0017.NCGR.lz \
        files/graphic/box/narc_0016.NCER.lz \
        files/graphic/box/narc_0002.NSCR.lz \
        files/graphic/box/narc_0014.NANR.lz \
        files/graphic/box/narc_0000.NSCR.lz \
        files/graphic/box/narc_0029.NCGR.lz \
        files/graphic/box/narc_0001.NCGR.lz \
        files/graphic/box/narc_0015.NCGR.lz \
        files/graphic/box/narc_0039.NSCR.lz \
        files/graphic/box/narc_0011.NANR.lz \
        files/graphic/box/narc_0004.NCGR.lz \
        files/graphic/box/narc_0010.NCER.lz \
        files/graphic/box/narc_0038.NCGR.lz \
        files/graphic/box/narc_0006.NSCR.lz \
        files/graphic/box/narc_0012.NCGR.lz \
        files/graphic/box/narc_0013.NCER.lz \
        files/graphic/box/narc_0007.NSCR.lz

files/graphic/record.narc: \
        files/graphic/record/narc_0009.NCGR.lz \
        files/graphic/record/narc_0003.NSCR.lz \
        files/graphic/record/narc_0002.NCGR.lz \
        files/graphic/record/narc_0014.NANR.lz \
        files/graphic/record/narc_0011.NANR.lz \
        files/graphic/record/narc_0005.NCER.lz \
        files/graphic/record/narc_0004.NCGR.lz \
        files/graphic/record/narc_0010.NCER.lz \
        files/graphic/record/narc_0006.NANR.lz \
        files/graphic/record/narc_0012.NCGR.lz \
        files/graphic/record/narc_0013.NCER.lz

files/graphic/mysign.narc: \
        files/graphic/mysign/narc_0009.NANR.lz \
        files/graphic/mysign/narc_0008.NCER.lz \
        files/graphic/mysign/narc_0003.NCGR.lz \
        files/graphic/mysign/narc_0005.NSCR.lz \
        files/graphic/mysign/narc_0004.NCGR.lz \
        files/graphic/mysign/narc_0006.NSCR.lz \
        files/graphic/mysign/narc_0007.NCGR.lz

files/graphic/mystery.narc: \
        files/graphic/mystery/narc_0022.NCGR.lz \
        files/graphic/mystery/narc_0037.NANR.lz \
        files/graphic/mystery/narc_0035.NCGR.lz \
        files/graphic/mystery/narc_0021.NSCR.lz \
        files/graphic/mystery/narc_0009.NCER.lz \
        files/graphic/mystery/narc_0008.NANR.lz \
        files/graphic/mystery/narc_0020.NSCR.lz \
        files/graphic/mystery/narc_0034.NCER.lz \
        files/graphic/mystery/narc_0018.NSCR.lz \
        files/graphic/mystery/narc_0030.NCGR.lz \
        files/graphic/mystery/narc_0024.NANR.lz \
        files/graphic/mystery/narc_0025.NCER.lz \
        files/graphic/mystery/narc_0031.NSCR.lz \
        files/graphic/mystery/narc_0027.NCGR.lz \
        files/graphic/mystery/narc_0033.NANR.lz \
        files/graphic/mystery/narc_0026.NCGR.lz \
        files/graphic/mystery/narc_0017.NCGR.lz \
        files/graphic/mystery/narc_0002.NSCR.lz \
        files/graphic/mystery/narc_0014.NCER.lz \
        files/graphic/mystery/narc_0028.NSCR.lz \
        files/graphic/mystery/narc_0001.NCGR.lz \
        files/graphic/mystery/narc_0015.NCGR.lz \
        files/graphic/mystery/narc_0039.NCGR.lz \
        files/graphic/mystery/narc_0005.NSCR.lz \
        files/graphic/mystery/narc_0004.NSCR.lz \
        files/graphic/mystery/narc_0010.NCGR.lz \
        files/graphic/mystery/narc_0038.NCER.lz \
        files/graphic/mystery/narc_0006.NCGR.lz \
        files/graphic/mystery/narc_0013.NANR.lz

files/graphic/oekaki.narc: \
        files/graphic/oekaki/narc_0008.NANR.lz \
        files/graphic/oekaki/narc_0003.NCGR.lz \
        files/graphic/oekaki/narc_0002.NCGR.lz \
        files/graphic/oekaki/narc_0005.NSCR.lz \
        files/graphic/oekaki/narc_0004.NSCR.lz \
        files/graphic/oekaki/narc_0006.NCGR.lz \
        files/graphic/oekaki/narc_0007.NCER.lz

files/graphic/worldtrade.narc: \
        files/graphic/worldtrade/narc_0022.NSCR.lz \
        files/graphic/worldtrade/narc_0036.NCER.lz \
        files/graphic/worldtrade/narc_0037.NANR.lz \
        files/graphic/worldtrade/narc_0023.NSCR.lz \
        files/graphic/worldtrade/narc_0035.NCGR.lz \
        files/graphic/worldtrade/narc_0021.NSCR.lz \
        files/graphic/worldtrade/narc_0020.NANR.lz \
        files/graphic/worldtrade/narc_0034.NANR.lz \
        files/graphic/worldtrade/narc_0018.NCGR.lz \
        files/graphic/worldtrade/narc_0030.NSCR.lz \
        files/graphic/worldtrade/narc_0024.NSCR.lz \
        files/graphic/worldtrade/narc_0025.NSCR.lz \
        files/graphic/worldtrade/narc_0031.NSCR.lz \
        files/graphic/worldtrade/narc_0019.NCER.lz \
        files/graphic/worldtrade/narc_0027.NSCR.lz \
        files/graphic/worldtrade/narc_0033.NCER.lz \
        files/graphic/worldtrade/narc_0032.NCGR.lz \
        files/graphic/worldtrade/narc_0026.NSCR.lz \
        files/graphic/worldtrade/narc_0017.NCGR.lz \
        files/graphic/worldtrade/narc_0016.NCGR.lz \
        files/graphic/worldtrade/narc_0014.NCGR.lz \
        files/graphic/worldtrade/narc_0028.NSCR.lz \
        files/graphic/worldtrade/narc_0029.NSCR.lz \
        files/graphic/worldtrade/narc_0015.NCGR.lz \
        files/graphic/worldtrade/narc_0011.NCGR.lz \
        files/graphic/worldtrade/narc_0010.NCGR.lz \
        files/graphic/worldtrade/narc_0012.NCGR.lz \
        files/graphic/worldtrade/narc_0013.NCGR.lz

files/graphic/unionroom.narc: \
        files/graphic/unionroom/narc_0003.NSCR.lz \
        files/graphic/unionroom/narc_0002.NCGR.lz \
        files/graphic/unionroom/narc_0005.NCGR.lz \
        files/graphic/unionroom/narc_0004.NSCR.lz \
        files/graphic/unionroom/narc_0006.NCER.lz \
        files/graphic/unionroom/narc_0007.NANR.lz

files/graphic/dendou_demo.narc: \
        files/graphic/dendou_demo/narc_0003.NCGR.lz \
        files/graphic/dendou_demo/narc_0002.NSCR.lz \
        files/graphic/dendou_demo/narc_0000.NSCR.lz \
        files/graphic/dendou_demo/narc_0001.NSCR.lz

files/graphic/pmsi.narc: \
        files/graphic/pmsi/narc_0022.NCER.lz \
        files/graphic/pmsi/narc_0023.NANR.lz \
        files/graphic/pmsi/narc_0009.NCGR.lz \
        files/graphic/pmsi/narc_0008.NANR.lz \
        files/graphic/pmsi/narc_0020.NCGR.lz \
        files/graphic/pmsi/narc_0018.NSCR.lz \
        files/graphic/pmsi/narc_0024.NCGR.lz \
        files/graphic/pmsi/narc_0019.NSCR.lz \
        files/graphic/pmsi/narc_0003.NCGR.lz \
        files/graphic/pmsi/narc_0017.NSCR.lz \
        files/graphic/pmsi/narc_0016.NSCR.lz \
        files/graphic/pmsi/narc_0002.NSCR.lz \
        files/graphic/pmsi/narc_0014.NSCR.lz \
        files/graphic/pmsi/narc_0000.NSCR.lz \
        files/graphic/pmsi/narc_0001.NCGR.lz \
        files/graphic/pmsi/narc_0015.NSCR.lz \
        files/graphic/pmsi/narc_0011.NSCR.lz \
        files/graphic/pmsi/narc_0005.NCGR.lz \
        files/graphic/pmsi/narc_0004.NSCR.lz \
        files/graphic/pmsi/narc_0012.NSCR.lz \
        files/graphic/pmsi/narc_0013.NSCR.lz \
        files/graphic/pmsi/narc_0007.NCER.lz

files/graphic/demo_trade.narc: \
        files/graphic/demo_trade/narc_0022.NCGR.lz \
        files/graphic/demo_trade/narc_0021.NSCR.lz \
        files/graphic/demo_trade/narc_0009.NCGR.lz \
        files/graphic/demo_trade/narc_0008.NANR.lz \
        files/graphic/demo_trade/narc_0018.NSCR.lz \
        files/graphic/demo_trade/narc_0024.NSCR.lz \
        files/graphic/demo_trade/narc_0025.NCGR.lz \
        files/graphic/demo_trade/narc_0019.NCGR.lz \
        files/graphic/demo_trade/narc_0016.NCGR.lz \
        files/graphic/demo_trade/narc_0002.NCGR.lz \
        files/graphic/demo_trade/narc_0000.NSCR.lz \
        files/graphic/demo_trade/narc_0001.NSCR.lz \
        files/graphic/demo_trade/narc_0015.NSCR.lz \
        files/graphic/demo_trade/narc_0011.NCER.lz \
        files/graphic/demo_trade/narc_0005.NCGR.lz \
        files/graphic/demo_trade/narc_0004.NSCR.lz \
        files/graphic/demo_trade/narc_0012.NANR.lz \
        files/graphic/demo_trade/narc_0013.NCGR.lz \
        files/graphic/demo_trade/narc_0007.NCER.lz

files/graphic/font.narc: \
        files/graphic/font/narc_0004.NCGR.lz

files/graphic/touch_subwindow.narc: \
        files/graphic/touch_subwindow/narc_0009.NSCR.lz \
        files/graphic/touch_subwindow/narc_0008.NSCR.lz \
        files/graphic/touch_subwindow/narc_0003.NSCR.lz \
        files/graphic/touch_subwindow/narc_0002.NSCR.lz \
        files/graphic/touch_subwindow/narc_0001.NCGR.lz \
        files/graphic/touch_subwindow/narc_0005.NSCR.lz \
        files/graphic/touch_subwindow/narc_0004.NSCR.lz \
        files/graphic/touch_subwindow/narc_0006.NSCR.lz \
        files/graphic/touch_subwindow/narc_0007.NSCR.lz

files/graphic/dendou_pc.narc: \
        files/graphic/dendou_pc/narc_0000.NSCR.lz \
        files/graphic/dendou_pc/narc_0001.NCGR.lz

files/poketool/pokefoot/pokefoot.narc: \
        files/poketool/pokefoot/pokefoot/narc_0397.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0383.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0354.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0432.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0426.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0340.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0368.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0195.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0181.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0156.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0142.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0022.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0036.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0220.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0234.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0208.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0209.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0235.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0221.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0037.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0023.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0143.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0157.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0180.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0194.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0369.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0427.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0341.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0355.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0433.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0382.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0396.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0380.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0394.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0343.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0425.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0431.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0357.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0419.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0182.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0196.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0141.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0155.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0169.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0035.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0021.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0009.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0237.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0223.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0222.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0236.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0008.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0020.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0034.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0168.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0154.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0140.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0197.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0183.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0418.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0430.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0356.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0342.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0424.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0395.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0381.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0385.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0391.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0408.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0420.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0346.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0352.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0434.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0187.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0193.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0178.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0144.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0150.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0018.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0030.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0024.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0232.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0226.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0227.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0233.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0025.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0031.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0019.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0151.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0145.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0179.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0192.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0186.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0353.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0435.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0421.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0347.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0409.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0390.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0384.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0392.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0386.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0379.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0437.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0351.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0345.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0423.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0190.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0184.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0153.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0147.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0027.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0033.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0219.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0225.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0231.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0230.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0224.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0218.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0032.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0026.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0146.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0152.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0185.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0191.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0344.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0422.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0436.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0350.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0378.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0387.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0393.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0492.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0486.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0451.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0337.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0323.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0445.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0479.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0135.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0121.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0109.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0082.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0096.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0041.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0055.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0069.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0280.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0294.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0243.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0257.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0256.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0242.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0295.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0281.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0068.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0054.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0040.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0097.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0083.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0108.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0120.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0134.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0478.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0322.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0444.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0450.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0336.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0487.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0493.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0485.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0491.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0446.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0320.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0334.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0452.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0308.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0122.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0136.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0095.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0081.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0056.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0042.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0297.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0283.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0254.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0240.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0268.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0269.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0241.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0255.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0282.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0296.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0043.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0057.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0080.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0094.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0137.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0123.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0309.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0335.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0453.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0447.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0321.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0490.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0484.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0480.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0494.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0319.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0325.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0443.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0457.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0331.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0127.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0133.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0090.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0084.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0053.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0047.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0292.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0286.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0279.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0251.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0245.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0244.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0250.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0278.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0287.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0293.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0046.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0052.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0085.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0091.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0132.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0126.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0456.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0330.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0324.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0442.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0318.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0495.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0481.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0483.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0468.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0332.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0454.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0440.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0326.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0118.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0130.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0124.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0087.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0093.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0078.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0044.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0050.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0285.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0291.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0246.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0252.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0253.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0247.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0290.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0284.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0051.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0045.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0079.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0092.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0086.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0125.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0131.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0119.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0441.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0327.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0333.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0455.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0469.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0482.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0496.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0470.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0316.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0302.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0464.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0458.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0114.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0100.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0128.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0060.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0074.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0048.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0289.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0262.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0276.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0277.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0263.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0288.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0049.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0075.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0061.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0129.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0101.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0115.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0459.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0303.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0465.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0471.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0317.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0467.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0301.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0315.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0473.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0329.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0103.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0117.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0088.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0077.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0063.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0275.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0261.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0249.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0248.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0260.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0274.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0062.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0076.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0089.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0116.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0102.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0328.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0314.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0472.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0466.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0300.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0489.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0338.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0304.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0462.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0476.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0310.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0106.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0112.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0099.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0072.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0066.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0258.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0270.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0264.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0265.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0271.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0259.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0067.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0073.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0098.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0113.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0107.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0477.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0311.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0305.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0463.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0339.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0488.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0449.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0313.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0475.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0461.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0307.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0139.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0111.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0105.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0059.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0065.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0071.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0298.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0267.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0273.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0272.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0266.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0299.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0070.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0064.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0058.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0104.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0110.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0138.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0460.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0306.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0312.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0474.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0448.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0375.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0413.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0407.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0361.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0349.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0188.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0177.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0163.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0003.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0017.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0201.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0215.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0229.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0228.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0214.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0200.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0016.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0002.NCER.lz \
        files/poketool/pokefoot/pokefoot/narc_0162.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0176.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0189.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0348.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0406.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0360.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0374.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0412.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0389.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0362.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0404.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0410.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0376.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0438.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0160.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0174.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0148.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0014.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0028.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0216.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0202.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0203.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0217.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0029.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0001.NANR.lz \
        files/poketool/pokefoot/pokefoot/narc_0015.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0149.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0175.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0161.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0439.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0411.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0377.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0363.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0405.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0388.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0398.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0429.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0401.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0367.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0373.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0415.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0159.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0165.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0171.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0039.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0011.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0005.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0213.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0207.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0206.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0212.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0004.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0010.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0038.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0170.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0164.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0158.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0372.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0414.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0400.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0366.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0428.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0399.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0358.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0416.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0370.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0364.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0402.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0199.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0172.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0166.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0006.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0012.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0238.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0204.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0210.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0211.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0205.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0239.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0013.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0007.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0167.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0173.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0198.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0365.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0403.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0417.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0371.NCGR.lz \
        files/poketool/pokefoot/pokefoot/narc_0359.NCGR.lz

files/itemtool/itemdata/item_icon.narc: \
        files/itemtool/itemdata/item_icon/narc_0002.NCGR \
        files/itemtool/itemdata/item_icon/narc_0002.NCLR \
        files/itemtool/itemdata/item_icon/narc_0004.NCGR \
        files/itemtool/itemdata/item_icon/narc_0004.NCLR \
        files/itemtool/itemdata/item_icon/narc_0006.NCGR \
        files/itemtool/itemdata/item_icon/narc_0006.NCLR \
        files/itemtool/itemdata/item_icon/narc_0008.NCGR \
        files/itemtool/itemdata/item_icon/narc_0008.NCLR \
        files/itemtool/itemdata/item_icon/narc_0010.NCGR \
        files/itemtool/itemdata/item_icon/narc_0010.NCLR \
        files/itemtool/itemdata/item_icon/narc_0012.NCGR \
        files/itemtool/itemdata/item_icon/narc_0012.NCLR \
        files/itemtool/itemdata/item_icon/narc_0014.NCGR \
        files/itemtool/itemdata/item_icon/narc_0014.NCLR \
        files/itemtool/itemdata/item_icon/narc_0016.NCGR \
        files/itemtool/itemdata/item_icon/narc_0016.NCLR \
        files/itemtool/itemdata/item_icon/narc_0018.NCGR \
        files/itemtool/itemdata/item_icon/narc_0018.NCLR \
        files/itemtool/itemdata/item_icon/narc_0020.NCGR \
        files/itemtool/itemdata/item_icon/narc_0021.NCGR \
        files/itemtool/itemdata/item_icon/narc_0022.NCLR \
        files/itemtool/itemdata/item_icon/narc_0023.NCGR \
        files/itemtool/itemdata/item_icon/narc_0024.NCGR \
        files/itemtool/itemdata/item_icon/narc_0025.NCLR \
        files/itemtool/itemdata/item_icon/narc_0026.NCGR \
        files/itemtool/itemdata/item_icon/narc_0027.NCLR \
        files/itemtool/itemdata/item_icon/narc_0028.NCLR \
        files/itemtool/itemdata/item_icon/narc_0029.NCLR \
        files/itemtool/itemdata/item_icon/narc_0030.NCGR \
        files/itemtool/itemdata/item_icon/narc_0031.NCLR \
        files/itemtool/itemdata/item_icon/narc_0032.NCLR \
        files/itemtool/itemdata/item_icon/narc_0033.NCGR \
        files/itemtool/itemdata/item_icon/narc_0034.NCLR \
        files/itemtool/itemdata/item_icon/narc_0035.NCLR \
        files/itemtool/itemdata/item_icon/narc_0036.NCLR \
        files/itemtool/itemdata/item_icon/narc_0037.NCLR \
        files/itemtool/itemdata/item_icon/narc_0038.NCGR \
        files/itemtool/itemdata/item_icon/narc_0038.NCLR \
        files/itemtool/itemdata/item_icon/narc_0040.NCGR \
        files/itemtool/itemdata/item_icon/narc_0041.NCGR \
        files/itemtool/itemdata/item_icon/narc_0042.NCLR \
        files/itemtool/itemdata/item_icon/narc_0043.NCGR \
        files/itemtool/itemdata/item_icon/narc_0043.NCLR \
        files/itemtool/itemdata/item_icon/narc_0045.NCGR \
        files/itemtool/itemdata/item_icon/narc_0045.NCLR \
        files/itemtool/itemdata/item_icon/narc_0047.NCGR \
        files/itemtool/itemdata/item_icon/narc_0047.NCLR \
        files/itemtool/itemdata/item_icon/narc_0049.NCGR \
        files/itemtool/itemdata/item_icon/narc_0049.NCLR \
        files/itemtool/itemdata/item_icon/narc_0051.NCGR \
        files/itemtool/itemdata/item_icon/narc_0052.NCLR \
        files/itemtool/itemdata/item_icon/narc_0053.NCGR \
        files/itemtool/itemdata/item_icon/narc_0053.NCLR \
        files/itemtool/itemdata/item_icon/narc_0055.NCLR \
        files/itemtool/itemdata/item_icon/narc_0056.NCGR \
        files/itemtool/itemdata/item_icon/narc_0056.NCLR \
        files/itemtool/itemdata/item_icon/narc_0058.NCGR \
        files/itemtool/itemdata/item_icon/narc_0059.NCLR \
        files/itemtool/itemdata/item_icon/narc_0060.NCLR \
        files/itemtool/itemdata/item_icon/narc_0061.NCLR \
        files/itemtool/itemdata/item_icon/narc_0062.NCLR \
        files/itemtool/itemdata/item_icon/narc_0063.NCGR \
        files/itemtool/itemdata/item_icon/narc_0063.NCLR \
        files/itemtool/itemdata/item_icon/narc_0065.NCGR \
        files/itemtool/itemdata/item_icon/narc_0066.NCLR \
        files/itemtool/itemdata/item_icon/narc_0067.NCLR \
        files/itemtool/itemdata/item_icon/narc_0068.NCLR \
        files/itemtool/itemdata/item_icon/narc_0069.NCLR \
        files/itemtool/itemdata/item_icon/narc_0070.NCLR \
        files/itemtool/itemdata/item_icon/narc_0071.NCGR \
        files/itemtool/itemdata/item_icon/narc_0071.NCLR \
        files/itemtool/itemdata/item_icon/narc_0073.NCGR \
        files/itemtool/itemdata/item_icon/narc_0074.NCLR \
        files/itemtool/itemdata/item_icon/narc_0075.NCLR \
        files/itemtool/itemdata/item_icon/narc_0076.NCGR \
        files/itemtool/itemdata/item_icon/narc_0076.NCLR \
        files/itemtool/itemdata/item_icon/narc_0078.NCGR \
        files/itemtool/itemdata/item_icon/narc_0079.NCLR \
        files/itemtool/itemdata/item_icon/narc_0080.NCLR \
        files/itemtool/itemdata/item_icon/narc_0081.NCLR \
        files/itemtool/itemdata/item_icon/narc_0082.NCLR \
        files/itemtool/itemdata/item_icon/narc_0083.NCGR \
        files/itemtool/itemdata/item_icon/narc_0083.NCLR \
        files/itemtool/itemdata/item_icon/narc_0085.NCGR \
        files/itemtool/itemdata/item_icon/narc_0086.NCLR \
        files/itemtool/itemdata/item_icon/narc_0087.NCLR \
        files/itemtool/itemdata/item_icon/narc_0088.NCLR \
        files/itemtool/itemdata/item_icon/narc_0089.NCLR \
        files/itemtool/itemdata/item_icon/narc_0090.NCGR \
        files/itemtool/itemdata/item_icon/narc_0090.NCLR \
        files/itemtool/itemdata/item_icon/narc_0092.NCGR \
        files/itemtool/itemdata/item_icon/narc_0092.NCLR \
        files/itemtool/itemdata/item_icon/narc_0094.NCLR \
        files/itemtool/itemdata/item_icon/narc_0095.NCGR \
        files/itemtool/itemdata/item_icon/narc_0095.NCLR \
        files/itemtool/itemdata/item_icon/narc_0097.NCLR \
        files/itemtool/itemdata/item_icon/narc_0098.NCLR \
        files/itemtool/itemdata/item_icon/narc_0099.NCLR \
        files/itemtool/itemdata/item_icon/narc_0100.NCGR \
        files/itemtool/itemdata/item_icon/narc_0101.NCLR \
        files/itemtool/itemdata/item_icon/narc_0102.NCLR \
        files/itemtool/itemdata/item_icon/narc_0103.NCLR \
        files/itemtool/itemdata/item_icon/narc_0104.NCLR \
        files/itemtool/itemdata/item_icon/narc_0105.NCGR \
        files/itemtool/itemdata/item_icon/narc_0105.NCLR \
        files/itemtool/itemdata/item_icon/narc_0107.NCGR \
        files/itemtool/itemdata/item_icon/narc_0107.NCLR \
        files/itemtool/itemdata/item_icon/narc_0109.NCGR \
        files/itemtool/itemdata/item_icon/narc_0110.NCLR \
        files/itemtool/itemdata/item_icon/narc_0111.NCLR \
        files/itemtool/itemdata/item_icon/narc_0112.NCGR \
        files/itemtool/itemdata/item_icon/narc_0112.NCLR \
        files/itemtool/itemdata/item_icon/narc_0114.NCLR \
        files/itemtool/itemdata/item_icon/narc_0115.NCGR \
        files/itemtool/itemdata/item_icon/narc_0115.NCLR \
        files/itemtool/itemdata/item_icon/narc_0117.NCGR \
        files/itemtool/itemdata/item_icon/narc_0117.NCLR \
        files/itemtool/itemdata/item_icon/narc_0119.NCGR \
        files/itemtool/itemdata/item_icon/narc_0119.NCLR \
        files/itemtool/itemdata/item_icon/narc_0121.NCGR \
        files/itemtool/itemdata/item_icon/narc_0121.NCLR \
        files/itemtool/itemdata/item_icon/narc_0123.NCGR \
        files/itemtool/itemdata/item_icon/narc_0123.NCLR \
        files/itemtool/itemdata/item_icon/narc_0125.NCGR \
        files/itemtool/itemdata/item_icon/narc_0125.NCLR \
        files/itemtool/itemdata/item_icon/narc_0127.NCGR \
        files/itemtool/itemdata/item_icon/narc_0128.NCGR \
        files/itemtool/itemdata/item_icon/narc_0129.NCLR \
        files/itemtool/itemdata/item_icon/narc_0130.NCGR \
        files/itemtool/itemdata/item_icon/narc_0131.NCLR \
        files/itemtool/itemdata/item_icon/narc_0132.NCGR \
        files/itemtool/itemdata/item_icon/narc_0133.NCGR \
        files/itemtool/itemdata/item_icon/narc_0134.NCLR \
        files/itemtool/itemdata/item_icon/narc_0135.NCGR \
        files/itemtool/itemdata/item_icon/narc_0136.NCGR \
        files/itemtool/itemdata/item_icon/narc_0136.NCLR \
        files/itemtool/itemdata/item_icon/narc_0138.NCGR \
        files/itemtool/itemdata/item_icon/narc_0138.NCLR \
        files/itemtool/itemdata/item_icon/narc_0140.NCGR \
        files/itemtool/itemdata/item_icon/narc_0140.NCLR \
        files/itemtool/itemdata/item_icon/narc_0142.NCGR \
        files/itemtool/itemdata/item_icon/narc_0142.NCLR \
        files/itemtool/itemdata/item_icon/narc_0144.NCGR \
        files/itemtool/itemdata/item_icon/narc_0144.NCLR \
        files/itemtool/itemdata/item_icon/narc_0146.NCGR \
        files/itemtool/itemdata/item_icon/narc_0146.NCLR \
        files/itemtool/itemdata/item_icon/narc_0148.NCGR \
        files/itemtool/itemdata/item_icon/narc_0148.NCLR \
        files/itemtool/itemdata/item_icon/narc_0150.NCGR \
        files/itemtool/itemdata/item_icon/narc_0150.NCLR \
        files/itemtool/itemdata/item_icon/narc_0152.NCGR \
        files/itemtool/itemdata/item_icon/narc_0152.NCLR \
        files/itemtool/itemdata/item_icon/narc_0154.NCGR \
        files/itemtool/itemdata/item_icon/narc_0154.NCLR \
        files/itemtool/itemdata/item_icon/narc_0156.NCGR \
        files/itemtool/itemdata/item_icon/narc_0156.NCLR \
        files/itemtool/itemdata/item_icon/narc_0158.NCGR \
        files/itemtool/itemdata/item_icon/narc_0158.NCLR \
        files/itemtool/itemdata/item_icon/narc_0160.NCGR \
        files/itemtool/itemdata/item_icon/narc_0160.NCLR \
        files/itemtool/itemdata/item_icon/narc_0162.NCGR \
        files/itemtool/itemdata/item_icon/narc_0162.NCLR \
        files/itemtool/itemdata/item_icon/narc_0164.NCGR \
        files/itemtool/itemdata/item_icon/narc_0164.NCLR \
        files/itemtool/itemdata/item_icon/narc_0166.NCGR \
        files/itemtool/itemdata/item_icon/narc_0166.NCLR \
        files/itemtool/itemdata/item_icon/narc_0168.NCGR \
        files/itemtool/itemdata/item_icon/narc_0168.NCLR \
        files/itemtool/itemdata/item_icon/narc_0170.NCGR \
        files/itemtool/itemdata/item_icon/narc_0170.NCLR \
        files/itemtool/itemdata/item_icon/narc_0172.NCGR \
        files/itemtool/itemdata/item_icon/narc_0172.NCLR \
        files/itemtool/itemdata/item_icon/narc_0174.NCGR \
        files/itemtool/itemdata/item_icon/narc_0174.NCLR \
        files/itemtool/itemdata/item_icon/narc_0176.NCGR \
        files/itemtool/itemdata/item_icon/narc_0176.NCLR \
        files/itemtool/itemdata/item_icon/narc_0178.NCGR \
        files/itemtool/itemdata/item_icon/narc_0178.NCLR \
        files/itemtool/itemdata/item_icon/narc_0180.NCGR \
        files/itemtool/itemdata/item_icon/narc_0180.NCLR \
        files/itemtool/itemdata/item_icon/narc_0182.NCGR \
        files/itemtool/itemdata/item_icon/narc_0182.NCLR \
        files/itemtool/itemdata/item_icon/narc_0184.NCGR \
        files/itemtool/itemdata/item_icon/narc_0184.NCLR \
        files/itemtool/itemdata/item_icon/narc_0186.NCGR \
        files/itemtool/itemdata/item_icon/narc_0186.NCLR \
        files/itemtool/itemdata/item_icon/narc_0188.NCGR \
        files/itemtool/itemdata/item_icon/narc_0188.NCLR \
        files/itemtool/itemdata/item_icon/narc_0190.NCGR \
        files/itemtool/itemdata/item_icon/narc_0190.NCLR \
        files/itemtool/itemdata/item_icon/narc_0192.NCGR \
        files/itemtool/itemdata/item_icon/narc_0192.NCLR \
        files/itemtool/itemdata/item_icon/narc_0194.NCGR \
        files/itemtool/itemdata/item_icon/narc_0194.NCLR \
        files/itemtool/itemdata/item_icon/narc_0196.NCGR \
        files/itemtool/itemdata/item_icon/narc_0196.NCLR \
        files/itemtool/itemdata/item_icon/narc_0198.NCGR \
        files/itemtool/itemdata/item_icon/narc_0198.NCLR \
        files/itemtool/itemdata/item_icon/narc_0200.NCGR \
        files/itemtool/itemdata/item_icon/narc_0200.NCLR \
        files/itemtool/itemdata/item_icon/narc_0202.NCGR \
        files/itemtool/itemdata/item_icon/narc_0202.NCLR \
        files/itemtool/itemdata/item_icon/narc_0204.NCGR \
        files/itemtool/itemdata/item_icon/narc_0204.NCLR \
        files/itemtool/itemdata/item_icon/narc_0206.NCGR \
        files/itemtool/itemdata/item_icon/narc_0206.NCLR \
        files/itemtool/itemdata/item_icon/narc_0208.NCGR \
        files/itemtool/itemdata/item_icon/narc_0208.NCLR \
        files/itemtool/itemdata/item_icon/narc_0210.NCGR \
        files/itemtool/itemdata/item_icon/narc_0210.NCLR \
        files/itemtool/itemdata/item_icon/narc_0212.NCGR \
        files/itemtool/itemdata/item_icon/narc_0212.NCLR \
        files/itemtool/itemdata/item_icon/narc_0214.NCGR \
        files/itemtool/itemdata/item_icon/narc_0214.NCLR \
        files/itemtool/itemdata/item_icon/narc_0216.NCGR \
        files/itemtool/itemdata/item_icon/narc_0216.NCLR \
        files/itemtool/itemdata/item_icon/narc_0218.NCGR \
        files/itemtool/itemdata/item_icon/narc_0218.NCLR \
        files/itemtool/itemdata/item_icon/narc_0220.NCGR \
        files/itemtool/itemdata/item_icon/narc_0220.NCLR \
        files/itemtool/itemdata/item_icon/narc_0222.NCGR \
        files/itemtool/itemdata/item_icon/narc_0222.NCLR \
        files/itemtool/itemdata/item_icon/narc_0224.NCGR \
        files/itemtool/itemdata/item_icon/narc_0224.NCLR \
        files/itemtool/itemdata/item_icon/narc_0226.NCGR \
        files/itemtool/itemdata/item_icon/narc_0226.NCLR \
        files/itemtool/itemdata/item_icon/narc_0228.NCGR \
        files/itemtool/itemdata/item_icon/narc_0228.NCLR \
        files/itemtool/itemdata/item_icon/narc_0230.NCGR \
        files/itemtool/itemdata/item_icon/narc_0230.NCLR \
        files/itemtool/itemdata/item_icon/narc_0232.NCGR \
        files/itemtool/itemdata/item_icon/narc_0232.NCLR \
        files/itemtool/itemdata/item_icon/narc_0234.NCGR \
        files/itemtool/itemdata/item_icon/narc_0234.NCLR \
        files/itemtool/itemdata/item_icon/narc_0236.NCGR \
        files/itemtool/itemdata/item_icon/narc_0236.NCLR \
        files/itemtool/itemdata/item_icon/narc_0238.NCGR \
        files/itemtool/itemdata/item_icon/narc_0238.NCLR \
        files/itemtool/itemdata/item_icon/narc_0240.NCGR \
        files/itemtool/itemdata/item_icon/narc_0240.NCLR \
        files/itemtool/itemdata/item_icon/narc_0242.NCGR \
        files/itemtool/itemdata/item_icon/narc_0242.NCLR \
        files/itemtool/itemdata/item_icon/narc_0244.NCGR \
        files/itemtool/itemdata/item_icon/narc_0244.NCLR \
        files/itemtool/itemdata/item_icon/narc_0246.NCGR \
        files/itemtool/itemdata/item_icon/narc_0246.NCLR \
        files/itemtool/itemdata/item_icon/narc_0248.NCGR \
        files/itemtool/itemdata/item_icon/narc_0248.NCLR

files/application/custom_ball/data/cb_data.narc: \
        files/application/custom_ball/data/cb_data/narc_0195.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0181.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0156.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0142.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0022.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0036.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0220.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0234.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0208.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0209.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0235.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0221.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0037.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0023.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0143.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0157.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0180.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0194.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0182.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0196.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0141.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0155.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0169.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0035.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0021.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0009.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0237.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0223.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0222.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0236.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0008.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0020.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0034.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0168.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0154.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0140.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0197.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0183.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0187.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0193.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0178.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0144.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0150.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0018.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0030.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0024.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0232.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0226.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0227.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0233.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0025.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0031.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0019.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0151.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0145.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0179.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0192.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0186.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0190.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0184.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0153.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0147.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0027.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0033.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0219.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0225.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0231.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0230.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0224.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0218.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0032.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0026.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0146.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0152.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0185.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0191.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0135.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0121.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0109.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0082.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0096.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0041.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0055.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0069.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0280.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0243.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0257.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0256.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0242.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0281.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0068.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0054.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0040.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0097.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0083.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0108.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0120.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0134.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0122.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0136.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0095.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0081.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0056.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0042.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0283.NSCR.lz \
        files/application/custom_ball/data/cb_data/narc_0254.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0240.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0268.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0269.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0241.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0255.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0282.NSCR.lz \
        files/application/custom_ball/data/cb_data/narc_0043.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0057.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0080.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0094.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0137.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0123.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0127.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0133.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0090.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0084.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0053.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0047.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0279.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0251.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0245.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0244.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0250.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0278.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0046.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0052.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0085.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0091.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0132.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0126.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0118.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0130.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0124.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0087.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0093.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0078.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0044.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0050.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0285.NSCR.lz \
        files/application/custom_ball/data/cb_data/narc_0246.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0252.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0253.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0247.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0284.NSCR.lz \
        files/application/custom_ball/data/cb_data/narc_0051.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0045.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0079.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0092.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0086.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0125.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0131.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0119.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0114.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0100.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0128.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0060.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0074.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0048.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0262.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0276.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0277.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0263.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0049.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0075.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0061.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0129.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0101.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0115.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0103.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0117.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0088.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0077.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0063.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0275.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0261.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0249.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0248.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0260.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0274.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0062.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0076.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0089.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0116.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0102.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0106.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0112.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0099.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0072.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0066.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0258.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0270.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0264.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0265.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0271.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0259.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0067.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0073.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0098.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0113.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0107.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0139.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0111.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0105.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0059.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0065.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0071.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0267.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0273.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0272.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0266.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0070.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0064.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0058.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0104.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0110.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0138.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0188.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0177.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0163.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0003.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0017.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0201.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0215.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0229.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0228.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0214.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0200.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0016.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0002.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0162.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0176.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0189.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0160.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0174.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0148.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0014.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0000.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0028.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0216.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0202.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0203.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0217.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0029.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0001.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0015.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0149.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0175.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0161.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0159.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0165.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0171.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0039.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0011.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0005.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0213.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0207.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0206.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0212.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0004.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0010.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0038.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0170.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0164.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0158.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0199.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0172.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0166.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0006.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0012.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0238.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0204.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0210.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0211.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0205.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0239.NCGR.lz \
        files/application/custom_ball/data/cb_data/narc_0013.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0007.NANR.lz \
        files/application/custom_ball/data/cb_data/narc_0167.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0173.NCER.lz \
        files/application/custom_ball/data/cb_data/narc_0198.NCGR.lz

files/resource/eng/zukan/zukan.narc: \
        files/resource/eng/zukan/zukan/narc_0036.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0037.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0035.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0034.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0030.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0031.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0027.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0033.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0032.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0121.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0109.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0082.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0096.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0041.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0055.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0069.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0068.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0054.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0040.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0097.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0083.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0108.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0120.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0122.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0095.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0081.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0056.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0042.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0043.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0057.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0080.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0094.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0123.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0127.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0090.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0084.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0053.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0047.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0046.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0052.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0085.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0091.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0126.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0118.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0124.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0087.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0093.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0078.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0044.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0050.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0051.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0045.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0079.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0092.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0086.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0125.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0119.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0114.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0100.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0128.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0060.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0074.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0048.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0049.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0075.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0061.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0129.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0101.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0115.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0103.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0117.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0088.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0077.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0063.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0062.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0076.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0089.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0116.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0102.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0106.NCER.lz \
        files/resource/eng/zukan/zukan/narc_0112.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0099.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0072.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0066.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0067.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0073.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0098.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0113.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0107.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0111.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0105.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0059.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0065.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0071.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0070.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0064.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0058.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0104.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0110.NANR.lz \
        files/resource/eng/zukan/zukan/narc_0028.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0029.NCGR.lz \
        files/resource/eng/zukan/zukan/narc_0039.NSCR.lz \
        files/resource/eng/zukan/zukan/narc_0038.NSCR.lz

files/contest/graphic/contest_bg.narc: \
        files/contest/graphic/contest_bg/narc_0022.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0023.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0021.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0009.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0008.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0020.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0018.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0024.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0025.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0019.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0027.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0026.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0003.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0017.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0016.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0002.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0014.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0000.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0028.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0001.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0015.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0011.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0005.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0004.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0010.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0006.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0012.NSCR.lz \
        files/contest/graphic/contest_bg/narc_0013.NCGR.lz \
        files/contest/graphic/contest_bg/narc_0007.NSCR.lz

files/contest/graphic/contest_obj.narc: \
        files/contest/graphic/contest_obj/narc_0022.NCER.lz \
        files/contest/graphic/contest_obj/narc_0036.NANR.lz \
        files/contest/graphic/contest_obj/narc_0037.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0023.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0035.NCER.lz \
        files/contest/graphic/contest_obj/narc_0021.NANR.lz \
        files/contest/graphic/contest_obj/narc_0020.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0034.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0018.NANR.lz \
        files/contest/graphic/contest_obj/narc_0030.NANR.lz \
        files/contest/graphic/contest_obj/narc_0024.NANR.lz \
        files/contest/graphic/contest_obj/narc_0025.NCER.lz \
        files/contest/graphic/contest_obj/narc_0031.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0019.NCER.lz \
        files/contest/graphic/contest_obj/narc_0027.NANR.lz \
        files/contest/graphic/contest_obj/narc_0033.NANR.lz \
        files/contest/graphic/contest_obj/narc_0032.NCER.lz \
        files/contest/graphic/contest_obj/narc_0026.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0082.NANR.lz \
        files/contest/graphic/contest_obj/narc_0096.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0041.NANR.lz \
        files/contest/graphic/contest_obj/narc_0055.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0069.NANR.lz \
        files/contest/graphic/contest_obj/narc_0068.NCER.lz \
        files/contest/graphic/contest_obj/narc_0054.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0040.NCER.lz \
        files/contest/graphic/contest_obj/narc_0083.NCER.lz \
        files/contest/graphic/contest_obj/narc_0095.NCER.lz \
        files/contest/graphic/contest_obj/narc_0081.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0056.NCER.lz \
        files/contest/graphic/contest_obj/narc_0042.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0043.NCER.lz \
        files/contest/graphic/contest_obj/narc_0057.NANR.lz \
        files/contest/graphic/contest_obj/narc_0080.NCER.lz \
        files/contest/graphic/contest_obj/narc_0094.NANR.lz \
        files/contest/graphic/contest_obj/narc_0090.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0084.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0053.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0047.NANR.lz \
        files/contest/graphic/contest_obj/narc_0046.NCER.lz \
        files/contest/graphic/contest_obj/narc_0052.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0085.NANR.lz \
        files/contest/graphic/contest_obj/narc_0091.NANR.lz \
        files/contest/graphic/contest_obj/narc_0087.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0093.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0078.NANR.lz \
        files/contest/graphic/contest_obj/narc_0044.NANR.lz \
        files/contest/graphic/contest_obj/narc_0050.NANR.lz \
        files/contest/graphic/contest_obj/narc_0051.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0045.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0079.NANR.lz \
        files/contest/graphic/contest_obj/narc_0092.NCER.lz \
        files/contest/graphic/contest_obj/narc_0086.NCER.lz \
        files/contest/graphic/contest_obj/narc_0060.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0074.NCER.lz \
        files/contest/graphic/contest_obj/narc_0048.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0049.NCER.lz \
        files/contest/graphic/contest_obj/narc_0075.NANR.lz \
        files/contest/graphic/contest_obj/narc_0061.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0088.NANR.lz \
        files/contest/graphic/contest_obj/narc_0077.NCER.lz \
        files/contest/graphic/contest_obj/narc_0063.NANR.lz \
        files/contest/graphic/contest_obj/narc_0062.NCER.lz \
        files/contest/graphic/contest_obj/narc_0076.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0089.NCER.lz \
        files/contest/graphic/contest_obj/narc_0072.NCER.lz \
        files/contest/graphic/contest_obj/narc_0066.NANR.lz \
        files/contest/graphic/contest_obj/narc_0067.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0073.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0059.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0065.NCER.lz \
        files/contest/graphic/contest_obj/narc_0071.NANR.lz \
        files/contest/graphic/contest_obj/narc_0070.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0064.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0058.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0017.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0016.NCER.lz \
        files/contest/graphic/contest_obj/narc_0014.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0028.NCER.lz \
        files/contest/graphic/contest_obj/narc_0029.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0015.NANR.lz \
        files/contest/graphic/contest_obj/narc_0039.NCGR.lz \
        files/contest/graphic/contest_obj/narc_0038.NCER.lz \
        files/contest/graphic/contest_obj/narc_0012.NANR.lz \
        files/contest/graphic/contest_obj/narc_0013.NCER.lz

files/data/tradelist.narc: \
        files/data/tradelist/narc_0009.NANR.lz \
        files/data/tradelist/narc_0008.NCER.lz \
        files/data/tradelist/narc_0003.NSCR.lz \
        files/data/tradelist/narc_0002.NCGR.lz \
        files/data/tradelist/narc_0001.NCGR.lz \
        files/data/tradelist/narc_0011.NCER.lz \
        files/data/tradelist/narc_0005.NSCR.lz \
        files/data/tradelist/narc_0004.NSCR.lz \
        files/data/tradelist/narc_0010.NCGR.lz \
        files/data/tradelist/narc_0006.NSCR.lz \
        files/data/tradelist/narc_0012.NANR.lz \
        files/data/tradelist/narc_0007.NCGR.lz

files/data/namein.narc: \
        files/data/namein/narc_0009.NSCR.lz \
        files/data/namein/narc_0008.NSCR.lz \
        files/data/namein/narc_0018.NSCR.lz \
        files/data/namein/narc_0003.NCGR.lz \
        files/data/namein/narc_0017.NSCR.lz \
        files/data/namein/narc_0016.NCGR.lz \
        files/data/namein/narc_0002.NCGR.lz \
        files/data/namein/narc_0014.NANR.lz \
        files/data/namein/narc_0015.NANR.lz \
        files/data/namein/narc_0011.NCGR.lz \
        files/data/namein/narc_0005.NSCR.lz \
        files/data/namein/narc_0004.NSCR.lz \
        files/data/namein/narc_0010.NCGR.lz \
        files/data/namein/narc_0006.NSCR.lz \
        files/data/namein/narc_0012.NCER.lz \
        files/data/namein/narc_0013.NCER.lz \
        files/data/namein/narc_0007.NSCR.lz

files/demo/title/titledemo.narc: \
        files/demo/title/titledemo/narc_0001.NCGR \
        files/demo/title/titledemo/narc_0001.NCLR \
        files/demo/title/titledemo/narc_0003.NCGR \
        files/demo/title/titledemo/narc_0003.NCLR \
        files/demo/title/titledemo/narc_0007.NCGR \
        files/demo/title/titledemo/narc_0009.NCLR \
        files/demo/title/titledemo/narc_0010.NCLR \
        files/demo/title/titledemo/narc_0011.NCGR \
        files/demo/title/titledemo/narc_0013.NCLR \
        files/demo/title/titledemo/narc_0014.NCLR \
        files/demo/title/titledemo/narc_0015.NCGR \
        files/demo/title/titledemo/narc_0016.NCLR \
        files/demo/title/titledemo/narc_0017.NSCR

files/poketool/trgra/trbgra.narc: \
        files/poketool/trgra/trbgra/narc_0000.NCGR \
        files/poketool/trgra/trbgra/narc_0000.NCLR \
        files/poketool/trgra/trbgra/narc_0002.NCGR \
        files/poketool/trgra/trbgra/narc_0002.NCLR \
        files/poketool/trgra/trbgra/narc_0004.NCGR \
        files/poketool/trgra/trbgra/narc_0004.NCLR \
        files/poketool/trgra/trbgra/narc_0006.NCGR \
        files/poketool/trgra/trbgra/narc_0006.NCLR \
        files/poketool/trgra/trbgra/narc_0008.NCGR \
        files/poketool/trgra/trbgra/narc_0008.NCLR \
        files/poketool/trgra/trbgra/narc_0010.NCGR \
        files/poketool/trgra/trbgra/narc_0010.NCLR \
        files/poketool/trgra/trbgra/narc_0012.NCGR \
        files/poketool/trgra/trbgra/narc_0012.NCLR \
        files/poketool/trgra/trbgra/narc_0014.NCGR \
        files/poketool/trgra/trbgra/narc_0014.NCLR

files/poketool/trgra/trfgra.narc: \
		files/poketool/trgra/trfgra/narc_0000.NCGR \
		files/poketool/trgra/trfgra/narc_0000.NCLR \
        files/poketool/trgra/trfgra/narc_0002.NCGR \
        files/poketool/trgra/trfgra/narc_0002.NCLR \
        files/poketool/trgra/trfgra/narc_0004.NCGR \
        files/poketool/trgra/trfgra/narc_0004.NCLR \
        files/poketool/trgra/trfgra/narc_0006.NCGR \
        files/poketool/trgra/trfgra/narc_0006.NCLR \
        files/poketool/trgra/trfgra/narc_0008.NCGR \
        files/poketool/trgra/trfgra/narc_0008.NCLR \
        files/poketool/trgra/trfgra/narc_0010.NCGR \
        files/poketool/trgra/trfgra/narc_0010.NCLR \
        files/poketool/trgra/trfgra/narc_0012.NCGR \
        files/poketool/trgra/trfgra/narc_0012.NCLR \
        files/poketool/trgra/trfgra/narc_0014.NCGR \
        files/poketool/trgra/trfgra/narc_0014.NCLR \
        files/poketool/trgra/trfgra/narc_0016.NCGR \
        files/poketool/trgra/trfgra/narc_0016.NCLR \
        files/poketool/trgra/trfgra/narc_0018.NCGR \
        files/poketool/trgra/trfgra/narc_0018.NCLR \
        files/poketool/trgra/trfgra/narc_0020.NCGR \
        files/poketool/trgra/trfgra/narc_0020.NCLR \
        files/poketool/trgra/trfgra/narc_0022.NCGR \
        files/poketool/trgra/trfgra/narc_0022.NCLR \
        files/poketool/trgra/trfgra/narc_0024.NCGR \
        files/poketool/trgra/trfgra/narc_0024.NCLR \
        files/poketool/trgra/trfgra/narc_0026.NCGR \
        files/poketool/trgra/trfgra/narc_0026.NCLR \
        files/poketool/trgra/trfgra/narc_0028.NCGR \
        files/poketool/trgra/trfgra/narc_0028.NCLR \
        files/poketool/trgra/trfgra/narc_0030.NCGR \
        files/poketool/trgra/trfgra/narc_0030.NCLR \
        files/poketool/trgra/trfgra/narc_0032.NCGR \
        files/poketool/trgra/trfgra/narc_0032.NCLR \
        files/poketool/trgra/trfgra/narc_0034.NCGR \
        files/poketool/trgra/trfgra/narc_0034.NCLR \
        files/poketool/trgra/trfgra/narc_0036.NCGR \
        files/poketool/trgra/trfgra/narc_0036.NCLR \
        files/poketool/trgra/trfgra/narc_0038.NCGR \
        files/poketool/trgra/trfgra/narc_0038.NCLR \
        files/poketool/trgra/trfgra/narc_0040.NCGR \
        files/poketool/trgra/trfgra/narc_0040.NCLR \
        files/poketool/trgra/trfgra/narc_0042.NCGR \
        files/poketool/trgra/trfgra/narc_0042.NCLR \
        files/poketool/trgra/trfgra/narc_0044.NCGR \
        files/poketool/trgra/trfgra/narc_0044.NCLR \
        files/poketool/trgra/trfgra/narc_0046.NCGR \
        files/poketool/trgra/trfgra/narc_0046.NCLR \
        files/poketool/trgra/trfgra/narc_0048.NCGR \
        files/poketool/trgra/trfgra/narc_0048.NCLR \
        files/poketool/trgra/trfgra/narc_0050.NCGR \
        files/poketool/trgra/trfgra/narc_0050.NCLR \
        files/poketool/trgra/trfgra/narc_0052.NCGR \
        files/poketool/trgra/trfgra/narc_0052.NCLR \
        files/poketool/trgra/trfgra/narc_0054.NCGR \
        files/poketool/trgra/trfgra/narc_0054.NCLR \
        files/poketool/trgra/trfgra/narc_0056.NCGR \
        files/poketool/trgra/trfgra/narc_0056.NCLR \
        files/poketool/trgra/trfgra/narc_0058.NCGR \
        files/poketool/trgra/trfgra/narc_0058.NCLR \
        files/poketool/trgra/trfgra/narc_0060.NCGR \
        files/poketool/trgra/trfgra/narc_0060.NCLR \
        files/poketool/trgra/trfgra/narc_0062.NCGR \
        files/poketool/trgra/trfgra/narc_0062.NCLR \
        files/poketool/trgra/trfgra/narc_0064.NCGR \
        files/poketool/trgra/trfgra/narc_0064.NCLR \
        files/poketool/trgra/trfgra/narc_0066.NCGR \
        files/poketool/trgra/trfgra/narc_0066.NCLR \
        files/poketool/trgra/trfgra/narc_0068.NCGR \
        files/poketool/trgra/trfgra/narc_0068.NCLR \
        files/poketool/trgra/trfgra/narc_0070.NCGR \
        files/poketool/trgra/trfgra/narc_0070.NCLR \
        files/poketool/trgra/trfgra/narc_0072.NCGR \
        files/poketool/trgra/trfgra/narc_0072.NCLR \
        files/poketool/trgra/trfgra/narc_0074.NCGR \
        files/poketool/trgra/trfgra/narc_0074.NCLR \
        files/poketool/trgra/trfgra/narc_0076.NCGR \
        files/poketool/trgra/trfgra/narc_0076.NCLR \
        files/poketool/trgra/trfgra/narc_0078.NCGR \
        files/poketool/trgra/trfgra/narc_0078.NCLR \
        files/poketool/trgra/trfgra/narc_0080.NCGR \
        files/poketool/trgra/trfgra/narc_0080.NCLR \
        files/poketool/trgra/trfgra/narc_0082.NCGR \
        files/poketool/trgra/trfgra/narc_0082.NCLR \
        files/poketool/trgra/trfgra/narc_0084.NCGR \
        files/poketool/trgra/trfgra/narc_0084.NCLR \
        files/poketool/trgra/trfgra/narc_0086.NCGR \
        files/poketool/trgra/trfgra/narc_0086.NCLR \
        files/poketool/trgra/trfgra/narc_0088.NCGR \
        files/poketool/trgra/trfgra/narc_0088.NCLR \
        files/poketool/trgra/trfgra/narc_0090.NCGR \
        files/poketool/trgra/trfgra/narc_0090.NCLR \
        files/poketool/trgra/trfgra/narc_0092.NCGR \
        files/poketool/trgra/trfgra/narc_0092.NCLR \
        files/poketool/trgra/trfgra/narc_0094.NCGR \
        files/poketool/trgra/trfgra/narc_0094.NCLR \
        files/poketool/trgra/trfgra/narc_0096.NCGR \
        files/poketool/trgra/trfgra/narc_0096.NCLR \
        files/poketool/trgra/trfgra/narc_0098.NCGR \
        files/poketool/trgra/trfgra/narc_0098.NCLR \
        files/poketool/trgra/trfgra/narc_0100.NCGR \
        files/poketool/trgra/trfgra/narc_0100.NCLR \
        files/poketool/trgra/trfgra/narc_0102.NCGR \
        files/poketool/trgra/trfgra/narc_0102.NCLR \
        files/poketool/trgra/trfgra/narc_0104.NCGR \
        files/poketool/trgra/trfgra/narc_0104.NCLR \
        files/poketool/trgra/trfgra/narc_0106.NCGR \
        files/poketool/trgra/trfgra/narc_0106.NCLR \
        files/poketool/trgra/trfgra/narc_0108.NCGR \
        files/poketool/trgra/trfgra/narc_0108.NCLR \
        files/poketool/trgra/trfgra/narc_0110.NCGR \
        files/poketool/trgra/trfgra/narc_0110.NCLR \
        files/poketool/trgra/trfgra/narc_0112.NCGR \
        files/poketool/trgra/trfgra/narc_0112.NCLR \
        files/poketool/trgra/trfgra/narc_0114.NCGR \
        files/poketool/trgra/trfgra/narc_0114.NCLR \
        files/poketool/trgra/trfgra/narc_0116.NCGR \
        files/poketool/trgra/trfgra/narc_0116.NCLR \
        files/poketool/trgra/trfgra/narc_0118.NCGR \
        files/poketool/trgra/trfgra/narc_0118.NCLR \
        files/poketool/trgra/trfgra/narc_0120.NCGR \
        files/poketool/trgra/trfgra/narc_0120.NCLR \
        files/poketool/trgra/trfgra/narc_0122.NCGR \
        files/poketool/trgra/trfgra/narc_0122.NCLR \
        files/poketool/trgra/trfgra/narc_0124.NCGR \
        files/poketool/trgra/trfgra/narc_0124.NCLR \
        files/poketool/trgra/trfgra/narc_0126.NCGR \
        files/poketool/trgra/trfgra/narc_0126.NCLR \
        files/poketool/trgra/trfgra/narc_0128.NCGR \
        files/poketool/trgra/trfgra/narc_0128.NCLR \
        files/poketool/trgra/trfgra/narc_0130.NCGR \
        files/poketool/trgra/trfgra/narc_0130.NCLR \
        files/poketool/trgra/trfgra/narc_0132.NCGR \
        files/poketool/trgra/trfgra/narc_0132.NCLR \
        files/poketool/trgra/trfgra/narc_0134.NCGR \
        files/poketool/trgra/trfgra/narc_0134.NCLR \
        files/poketool/trgra/trfgra/narc_0136.NCGR \
        files/poketool/trgra/trfgra/narc_0136.NCLR \
        files/poketool/trgra/trfgra/narc_0138.NCGR \
        files/poketool/trgra/trfgra/narc_0138.NCLR \
        files/poketool/trgra/trfgra/narc_0140.NCGR \
        files/poketool/trgra/trfgra/narc_0140.NCLR \
        files/poketool/trgra/trfgra/narc_0142.NCGR \
        files/poketool/trgra/trfgra/narc_0142.NCLR \
        files/poketool/trgra/trfgra/narc_0144.NCGR \
        files/poketool/trgra/trfgra/narc_0144.NCLR \
        files/poketool/trgra/trfgra/narc_0146.NCGR \
        files/poketool/trgra/trfgra/narc_0146.NCLR \
        files/poketool/trgra/trfgra/narc_0148.NCGR \
        files/poketool/trgra/trfgra/narc_0148.NCLR \
        files/poketool/trgra/trfgra/narc_0150.NCGR \
        files/poketool/trgra/trfgra/narc_0150.NCLR \
        files/poketool/trgra/trfgra/narc_0152.NCGR \
        files/poketool/trgra/trfgra/narc_0152.NCLR \
        files/poketool/trgra/trfgra/narc_0154.NCGR \
        files/poketool/trgra/trfgra/narc_0154.NCLR \
        files/poketool/trgra/trfgra/narc_0156.NCGR \
        files/poketool/trgra/trfgra/narc_0156.NCLR \
        files/poketool/trgra/trfgra/narc_0158.NCGR \
        files/poketool/trgra/trfgra/narc_0158.NCLR \
        files/poketool/trgra/trfgra/narc_0160.NCGR \
        files/poketool/trgra/trfgra/narc_0160.NCLR \
        files/poketool/trgra/trfgra/narc_0162.NCGR \
        files/poketool/trgra/trfgra/narc_0162.NCLR \
        files/poketool/trgra/trfgra/narc_0164.NCGR \
        files/poketool/trgra/trfgra/narc_0164.NCLR \
        files/poketool/trgra/trfgra/narc_0166.NCGR \
        files/poketool/trgra/trfgra/narc_0166.NCLR \
        files/poketool/trgra/trfgra/narc_0168.NCGR \
        files/poketool/trgra/trfgra/narc_0168.NCLR \
        files/poketool/trgra/trfgra/narc_0170.NCGR \
        files/poketool/trgra/trfgra/narc_0170.NCLR \
        files/poketool/trgra/trfgra/narc_0172.NCGR \
        files/poketool/trgra/trfgra/narc_0172.NCLR \
        files/poketool/trgra/trfgra/narc_0174.NCGR \
        files/poketool/trgra/trfgra/narc_0174.NCLR \
        files/poketool/trgra/trfgra/narc_0176.NCGR \
        files/poketool/trgra/trfgra/narc_0176.NCLR \
        files/poketool/trgra/trfgra/narc_0178.NCGR \
        files/poketool/trgra/trfgra/narc_0178.NCLR \
        files/poketool/trgra/trfgra/narc_0180.NCGR \
        files/poketool/trgra/trfgra/narc_0180.NCLR \
        files/poketool/trgra/trfgra/narc_0182.NCGR \
        files/poketool/trgra/trfgra/narc_0182.NCLR \
        files/poketool/trgra/trfgra/narc_0184.NCGR \
        files/poketool/trgra/trfgra/narc_0184.NCLR \
        files/poketool/trgra/trfgra/narc_0186.NCGR \
        files/poketool/trgra/trfgra/narc_0186.NCLR \
        files/poketool/trgra/trfgra/narc_0188.NCGR \
        files/poketool/trgra/trfgra/narc_0188.NCLR \
        files/poketool/trgra/trfgra/narc_0190.NCGR \
        files/poketool/trgra/trfgra/narc_0190.NCLR \
        files/poketool/trgra/trfgra/narc_0192.NCGR \
        files/poketool/trgra/trfgra/narc_0192.NCLR \
        files/poketool/trgra/trfgra/narc_0194.NCGR \
        files/poketool/trgra/trfgra/narc_0194.NCLR \

files/poketool/pokegra/pokegra.narc: \
        files/poketool/pokegra/pokegra/narc_0000.NCGR \
        files/poketool/pokegra/pokegra/narc_0001.NCGR \
        files/poketool/pokegra/pokegra/narc_0002.NCGR \
        files/poketool/pokegra/pokegra/narc_0003.NCGR \
        files/poketool/pokegra/pokegra/narc_0006.NCGR \
        files/poketool/pokegra/pokegra/narc_0007.NCGR \
        files/poketool/pokegra/pokegra/narc_0008.NCGR \
        files/poketool/pokegra/pokegra/narc_0009.NCGR \
        files/poketool/pokegra/pokegra/narc_0010.NCLR \
        files/poketool/pokegra/pokegra/narc_0011.NCLR \
        files/poketool/pokegra/pokegra/narc_0012.NCGR \
        files/poketool/pokegra/pokegra/narc_0013.NCGR \
        files/poketool/pokegra/pokegra/narc_0014.NCGR \
        files/poketool/pokegra/pokegra/narc_0015.NCGR \
        files/poketool/pokegra/pokegra/narc_0016.NCLR \
        files/poketool/pokegra/pokegra/narc_0017.NCLR \
        files/poketool/pokegra/pokegra/narc_0018.NCGR \
        files/poketool/pokegra/pokegra/narc_0019.NCGR \
        files/poketool/pokegra/pokegra/narc_0020.NCGR \
        files/poketool/pokegra/pokegra/narc_0021.NCGR \
        files/poketool/pokegra/pokegra/narc_0022.NCLR \
        files/poketool/pokegra/pokegra/narc_0023.NCLR \
        files/poketool/pokegra/pokegra/narc_0024.NCGR \
        files/poketool/pokegra/pokegra/narc_0025.NCGR \
        files/poketool/pokegra/pokegra/narc_0026.NCGR \
        files/poketool/pokegra/pokegra/narc_0027.NCGR \
        files/poketool/pokegra/pokegra/narc_0028.NCLR \
        files/poketool/pokegra/pokegra/narc_0029.NCLR \
        files/poketool/pokegra/pokegra/narc_0030.NCGR \
        files/poketool/pokegra/pokegra/narc_0031.NCGR \
        files/poketool/pokegra/pokegra/narc_0032.NCGR \
        files/poketool/pokegra/pokegra/narc_0033.NCGR \
        files/poketool/pokegra/pokegra/narc_0034.NCLR \
        files/poketool/pokegra/pokegra/narc_0035.NCLR \
        files/poketool/pokegra/pokegra/narc_0036.NCGR \
        files/poketool/pokegra/pokegra/narc_0037.NCGR \
        files/poketool/pokegra/pokegra/narc_0038.NCGR \
        files/poketool/pokegra/pokegra/narc_0039.NCGR \
        files/poketool/pokegra/pokegra/narc_0040.NCLR \
        files/poketool/pokegra/pokegra/narc_0041.NCLR \
        files/poketool/pokegra/pokegra/narc_0042.NCGR \
        files/poketool/pokegra/pokegra/narc_0043.NCGR \
        files/poketool/pokegra/pokegra/narc_0044.NCGR \
        files/poketool/pokegra/pokegra/narc_0045.NCGR \
        files/poketool/pokegra/pokegra/narc_0046.NCLR \
        files/poketool/pokegra/pokegra/narc_0047.NCLR \
        files/poketool/pokegra/pokegra/narc_0048.NCGR \
        files/poketool/pokegra/pokegra/narc_0049.NCGR \
        files/poketool/pokegra/pokegra/narc_0050.NCGR \
        files/poketool/pokegra/pokegra/narc_0051.NCGR \
        files/poketool/pokegra/pokegra/narc_0052.NCLR \
        files/poketool/pokegra/pokegra/narc_0053.NCLR \
        files/poketool/pokegra/pokegra/narc_0054.NCGR \
        files/poketool/pokegra/pokegra/narc_0055.NCGR \
        files/poketool/pokegra/pokegra/narc_0056.NCGR \
        files/poketool/pokegra/pokegra/narc_0057.NCGR \
        files/poketool/pokegra/pokegra/narc_0058.NCLR \
        files/poketool/pokegra/pokegra/narc_0059.NCLR \
        files/poketool/pokegra/pokegra/narc_0060.NCGR \
        files/poketool/pokegra/pokegra/narc_0061.NCGR \
        files/poketool/pokegra/pokegra/narc_0062.NCGR \
        files/poketool/pokegra/pokegra/narc_0063.NCGR \
        files/poketool/pokegra/pokegra/narc_0064.NCLR \
        files/poketool/pokegra/pokegra/narc_0065.NCLR \
        files/poketool/pokegra/pokegra/narc_0066.NCGR \
        files/poketool/pokegra/pokegra/narc_0067.NCGR \
        files/poketool/pokegra/pokegra/narc_0068.NCGR \
        files/poketool/pokegra/pokegra/narc_0069.NCGR \
        files/poketool/pokegra/pokegra/narc_0070.NCLR \
        files/poketool/pokegra/pokegra/narc_0071.NCLR \
        files/poketool/pokegra/pokegra/narc_0072.NCGR \
        files/poketool/pokegra/pokegra/narc_0073.NCGR \
        files/poketool/pokegra/pokegra/narc_0074.NCGR \
        files/poketool/pokegra/pokegra/narc_0075.NCGR \
        files/poketool/pokegra/pokegra/narc_0076.NCLR \
        files/poketool/pokegra/pokegra/narc_0077.NCLR \
        files/poketool/pokegra/pokegra/narc_0078.NCGR \
        files/poketool/pokegra/pokegra/narc_0079.NCGR \
        files/poketool/pokegra/pokegra/narc_0080.NCGR \
        files/poketool/pokegra/pokegra/narc_0081.NCGR \
        files/poketool/pokegra/pokegra/narc_0082.NCLR \
        files/poketool/pokegra/pokegra/narc_0083.NCLR \
        files/poketool/pokegra/pokegra/narc_0084.NCGR \
        files/poketool/pokegra/pokegra/narc_0085.NCGR \
        files/poketool/pokegra/pokegra/narc_0086.NCGR \
        files/poketool/pokegra/pokegra/narc_0087.NCGR \
        files/poketool/pokegra/pokegra/narc_0088.NCLR \
        files/poketool/pokegra/pokegra/narc_0089.NCLR \
        files/poketool/pokegra/pokegra/narc_0090.NCGR \
        files/poketool/pokegra/pokegra/narc_0091.NCGR \
        files/poketool/pokegra/pokegra/narc_0092.NCGR \
        files/poketool/pokegra/pokegra/narc_0093.NCGR \
        files/poketool/pokegra/pokegra/narc_0094.NCLR \
        files/poketool/pokegra/pokegra/narc_0095.NCLR \
        files/poketool/pokegra/pokegra/narc_0096.NCGR \
        files/poketool/pokegra/pokegra/narc_0097.NCGR \
        files/poketool/pokegra/pokegra/narc_0098.NCGR \
        files/poketool/pokegra/pokegra/narc_0099.NCGR \
        files/poketool/pokegra/pokegra/narc_0100.NCLR \
        files/poketool/pokegra/pokegra/narc_0101.NCLR \
        files/poketool/pokegra/pokegra/narc_0102.NCGR \
        files/poketool/pokegra/pokegra/narc_0103.NCGR \
        files/poketool/pokegra/pokegra/narc_0104.NCGR \
        files/poketool/pokegra/pokegra/narc_0105.NCGR \
        files/poketool/pokegra/pokegra/narc_0106.NCLR \
        files/poketool/pokegra/pokegra/narc_0107.NCLR \
        files/poketool/pokegra/pokegra/narc_0108.NCGR \
        files/poketool/pokegra/pokegra/narc_0109.NCGR \
        files/poketool/pokegra/pokegra/narc_0110.NCGR \
        files/poketool/pokegra/pokegra/narc_0111.NCGR \
        files/poketool/pokegra/pokegra/narc_0112.NCLR \
        files/poketool/pokegra/pokegra/narc_0113.NCLR \
        files/poketool/pokegra/pokegra/narc_0114.NCGR \
        files/poketool/pokegra/pokegra/narc_0115.NCGR \
        files/poketool/pokegra/pokegra/narc_0116.NCGR \
        files/poketool/pokegra/pokegra/narc_0117.NCGR \
        files/poketool/pokegra/pokegra/narc_0118.NCLR \
        files/poketool/pokegra/pokegra/narc_0119.NCLR \
        files/poketool/pokegra/pokegra/narc_0120.NCGR \
        files/poketool/pokegra/pokegra/narc_0121.NCGR \
        files/poketool/pokegra/pokegra/narc_0122.NCGR \
        files/poketool/pokegra/pokegra/narc_0123.NCGR \
        files/poketool/pokegra/pokegra/narc_0124.NCLR \
        files/poketool/pokegra/pokegra/narc_0125.NCLR \
        files/poketool/pokegra/pokegra/narc_0126.NCGR \
        files/poketool/pokegra/pokegra/narc_0127.NCGR \
        files/poketool/pokegra/pokegra/narc_0128.NCGR \
        files/poketool/pokegra/pokegra/narc_0129.NCGR \
        files/poketool/pokegra/pokegra/narc_0130.NCLR \
        files/poketool/pokegra/pokegra/narc_0131.NCLR \
        files/poketool/pokegra/pokegra/narc_0132.NCGR \
        files/poketool/pokegra/pokegra/narc_0133.NCGR \
        files/poketool/pokegra/pokegra/narc_0134.NCGR \
        files/poketool/pokegra/pokegra/narc_0135.NCGR \
        files/poketool/pokegra/pokegra/narc_0136.NCLR \
        files/poketool/pokegra/pokegra/narc_0137.NCLR \
        files/poketool/pokegra/pokegra/narc_0138.NCGR \
        files/poketool/pokegra/pokegra/narc_0139.NCGR \
        files/poketool/pokegra/pokegra/narc_0140.NCGR \
        files/poketool/pokegra/pokegra/narc_0141.NCGR \
        files/poketool/pokegra/pokegra/narc_0142.NCLR \
        files/poketool/pokegra/pokegra/narc_0143.NCLR \
        files/poketool/pokegra/pokegra/narc_0144.NCGR \
        files/poketool/pokegra/pokegra/narc_0145.NCGR \
        files/poketool/pokegra/pokegra/narc_0146.NCGR \
        files/poketool/pokegra/pokegra/narc_0147.NCGR \
        files/poketool/pokegra/pokegra/narc_0148.NCLR \
        files/poketool/pokegra/pokegra/narc_0149.NCLR \
        files/poketool/pokegra/pokegra/narc_0150.NCGR \
        files/poketool/pokegra/pokegra/narc_0151.NCGR \
        files/poketool/pokegra/pokegra/narc_0152.NCGR \
        files/poketool/pokegra/pokegra/narc_0153.NCGR \
        files/poketool/pokegra/pokegra/narc_0154.NCLR \
        files/poketool/pokegra/pokegra/narc_0155.NCLR \
        files/poketool/pokegra/pokegra/narc_0156.NCGR \
        files/poketool/pokegra/pokegra/narc_0157.NCGR \
        files/poketool/pokegra/pokegra/narc_0158.NCGR \
        files/poketool/pokegra/pokegra/narc_0159.NCGR \
        files/poketool/pokegra/pokegra/narc_0160.NCLR \
        files/poketool/pokegra/pokegra/narc_0161.NCLR \
        files/poketool/pokegra/pokegra/narc_0162.NCGR \
        files/poketool/pokegra/pokegra/narc_0163.NCGR \
        files/poketool/pokegra/pokegra/narc_0164.NCGR \
        files/poketool/pokegra/pokegra/narc_0165.NCGR \
        files/poketool/pokegra/pokegra/narc_0166.NCLR \
        files/poketool/pokegra/pokegra/narc_0167.NCLR \
        files/poketool/pokegra/pokegra/narc_0168.NCGR \
        files/poketool/pokegra/pokegra/narc_0169.NCGR \
        files/poketool/pokegra/pokegra/narc_0170.NCGR \
        files/poketool/pokegra/pokegra/narc_0171.NCGR \
        files/poketool/pokegra/pokegra/narc_0172.NCLR \
        files/poketool/pokegra/pokegra/narc_0173.NCLR \
        files/poketool/pokegra/pokegra/narc_0174.NCGR \
        files/poketool/pokegra/pokegra/narc_0176.NCGR \
        files/poketool/pokegra/pokegra/narc_0178.NCLR \
        files/poketool/pokegra/pokegra/narc_0179.NCLR \
        files/poketool/pokegra/pokegra/narc_0180.NCGR \
        files/poketool/pokegra/pokegra/narc_0182.NCGR \
        files/poketool/pokegra/pokegra/narc_0184.NCLR \
        files/poketool/pokegra/pokegra/narc_0185.NCLR \
        files/poketool/pokegra/pokegra/narc_0186.NCGR \
        files/poketool/pokegra/pokegra/narc_0188.NCGR \
        files/poketool/pokegra/pokegra/narc_0190.NCLR \
        files/poketool/pokegra/pokegra/narc_0191.NCLR \
        files/poketool/pokegra/pokegra/narc_0193.NCGR \
        files/poketool/pokegra/pokegra/narc_0195.NCGR \
        files/poketool/pokegra/pokegra/narc_0196.NCLR \
        files/poketool/pokegra/pokegra/narc_0197.NCLR \
        files/poketool/pokegra/pokegra/narc_0199.NCGR \
        files/poketool/pokegra/pokegra/narc_0201.NCGR \
        files/poketool/pokegra/pokegra/narc_0202.NCLR \
        files/poketool/pokegra/pokegra/narc_0203.NCLR \
        files/poketool/pokegra/pokegra/narc_0205.NCGR \
        files/poketool/pokegra/pokegra/narc_0207.NCGR \
        files/poketool/pokegra/pokegra/narc_0208.NCLR \
        files/poketool/pokegra/pokegra/narc_0209.NCLR \
        files/poketool/pokegra/pokegra/narc_0210.NCGR \
        files/poketool/pokegra/pokegra/narc_0211.NCGR \
        files/poketool/pokegra/pokegra/narc_0212.NCGR \
        files/poketool/pokegra/pokegra/narc_0213.NCGR \
        files/poketool/pokegra/pokegra/narc_0214.NCLR \
        files/poketool/pokegra/pokegra/narc_0215.NCLR \
        files/poketool/pokegra/pokegra/narc_0216.NCGR \
        files/poketool/pokegra/pokegra/narc_0217.NCGR \
        files/poketool/pokegra/pokegra/narc_0218.NCGR \
        files/poketool/pokegra/pokegra/narc_0219.NCGR \
        files/poketool/pokegra/pokegra/narc_0220.NCLR \
        files/poketool/pokegra/pokegra/narc_0221.NCLR \
        files/poketool/pokegra/pokegra/narc_0222.NCGR \
        files/poketool/pokegra/pokegra/narc_0223.NCGR \
        files/poketool/pokegra/pokegra/narc_0224.NCGR \
        files/poketool/pokegra/pokegra/narc_0225.NCGR \
        files/poketool/pokegra/pokegra/narc_0226.NCLR \
        files/poketool/pokegra/pokegra/narc_0227.NCLR \
        files/poketool/pokegra/pokegra/narc_0228.NCGR \
        files/poketool/pokegra/pokegra/narc_0229.NCGR \
        files/poketool/pokegra/pokegra/narc_0230.NCGR \
        files/poketool/pokegra/pokegra/narc_0231.NCGR \
        files/poketool/pokegra/pokegra/narc_0232.NCLR \
        files/poketool/pokegra/pokegra/narc_0233.NCLR \
        files/poketool/pokegra/pokegra/narc_0234.NCGR \
        files/poketool/pokegra/pokegra/narc_0235.NCGR \
        files/poketool/pokegra/pokegra/narc_0236.NCGR \
        files/poketool/pokegra/pokegra/narc_0237.NCGR \
        files/poketool/pokegra/pokegra/narc_0238.NCLR \
        files/poketool/pokegra/pokegra/narc_0239.NCLR \
        files/poketool/pokegra/pokegra/narc_0240.NCGR \
        files/poketool/pokegra/pokegra/narc_0241.NCGR \
        files/poketool/pokegra/pokegra/narc_0242.NCGR \
        files/poketool/pokegra/pokegra/narc_0243.NCGR \
        files/poketool/pokegra/pokegra/narc_0244.NCLR \
        files/poketool/pokegra/pokegra/narc_0245.NCLR \
        files/poketool/pokegra/pokegra/narc_0246.NCGR \
        files/poketool/pokegra/pokegra/narc_0247.NCGR \
        files/poketool/pokegra/pokegra/narc_0248.NCGR \
        files/poketool/pokegra/pokegra/narc_0249.NCGR \
        files/poketool/pokegra/pokegra/narc_0250.NCLR \
        files/poketool/pokegra/pokegra/narc_0251.NCLR \
        files/poketool/pokegra/pokegra/narc_0252.NCGR \
        files/poketool/pokegra/pokegra/narc_0253.NCGR \
        files/poketool/pokegra/pokegra/narc_0254.NCGR \
        files/poketool/pokegra/pokegra/narc_0255.NCGR \
        files/poketool/pokegra/pokegra/narc_0256.NCLR \
        files/poketool/pokegra/pokegra/narc_0257.NCLR \
        files/poketool/pokegra/pokegra/narc_0258.NCGR \
        files/poketool/pokegra/pokegra/narc_0259.NCGR \
        files/poketool/pokegra/pokegra/narc_0260.NCGR \
        files/poketool/pokegra/pokegra/narc_0261.NCGR \
        files/poketool/pokegra/pokegra/narc_0262.NCLR \
        files/poketool/pokegra/pokegra/narc_0263.NCLR \
        files/poketool/pokegra/pokegra/narc_0264.NCGR \
        files/poketool/pokegra/pokegra/narc_0265.NCGR \
        files/poketool/pokegra/pokegra/narc_0266.NCGR \
        files/poketool/pokegra/pokegra/narc_0267.NCGR \
        files/poketool/pokegra/pokegra/narc_0268.NCLR \
        files/poketool/pokegra/pokegra/narc_0269.NCLR \
        files/poketool/pokegra/pokegra/narc_0270.NCGR \
        files/poketool/pokegra/pokegra/narc_0271.NCGR \
        files/poketool/pokegra/pokegra/narc_0272.NCGR \
        files/poketool/pokegra/pokegra/narc_0273.NCGR \
        files/poketool/pokegra/pokegra/narc_0274.NCLR \
        files/poketool/pokegra/pokegra/narc_0275.NCLR \
        files/poketool/pokegra/pokegra/narc_0276.NCGR \
        files/poketool/pokegra/pokegra/narc_0277.NCGR \
        files/poketool/pokegra/pokegra/narc_0278.NCGR \
        files/poketool/pokegra/pokegra/narc_0279.NCGR \
        files/poketool/pokegra/pokegra/narc_0280.NCLR \
        files/poketool/pokegra/pokegra/narc_0281.NCLR \
        files/poketool/pokegra/pokegra/narc_0282.NCGR \
        files/poketool/pokegra/pokegra/narc_0283.NCGR \
        files/poketool/pokegra/pokegra/narc_0284.NCGR \
        files/poketool/pokegra/pokegra/narc_0285.NCGR \
        files/poketool/pokegra/pokegra/narc_0286.NCLR \
        files/poketool/pokegra/pokegra/narc_0287.NCLR \
        files/poketool/pokegra/pokegra/narc_0288.NCGR \
        files/poketool/pokegra/pokegra/narc_0289.NCGR \
        files/poketool/pokegra/pokegra/narc_0290.NCGR \
        files/poketool/pokegra/pokegra/narc_0291.NCGR \
        files/poketool/pokegra/pokegra/narc_0292.NCLR \
        files/poketool/pokegra/pokegra/narc_0293.NCLR \
        files/poketool/pokegra/pokegra/narc_0294.NCGR \
        files/poketool/pokegra/pokegra/narc_0295.NCGR \
        files/poketool/pokegra/pokegra/narc_0296.NCGR \
        files/poketool/pokegra/pokegra/narc_0297.NCGR \
        files/poketool/pokegra/pokegra/narc_0298.NCLR \
        files/poketool/pokegra/pokegra/narc_0299.NCLR \
        files/poketool/pokegra/pokegra/narc_0300.NCGR \
        files/poketool/pokegra/pokegra/narc_0301.NCGR \
        files/poketool/pokegra/pokegra/narc_0302.NCGR \
        files/poketool/pokegra/pokegra/narc_0303.NCGR \
        files/poketool/pokegra/pokegra/narc_0304.NCLR \
        files/poketool/pokegra/pokegra/narc_0305.NCLR \
        files/poketool/pokegra/pokegra/narc_0306.NCGR \
        files/poketool/pokegra/pokegra/narc_0307.NCGR \
        files/poketool/pokegra/pokegra/narc_0308.NCGR \
        files/poketool/pokegra/pokegra/narc_0309.NCGR \
        files/poketool/pokegra/pokegra/narc_0310.NCLR \
        files/poketool/pokegra/pokegra/narc_0311.NCLR \
        files/poketool/pokegra/pokegra/narc_0312.NCGR \
        files/poketool/pokegra/pokegra/narc_0313.NCGR \
        files/poketool/pokegra/pokegra/narc_0314.NCGR \
        files/poketool/pokegra/pokegra/narc_0315.NCGR \
        files/poketool/pokegra/pokegra/narc_0316.NCLR \
        files/poketool/pokegra/pokegra/narc_0317.NCLR \
        files/poketool/pokegra/pokegra/narc_0318.NCGR \
        files/poketool/pokegra/pokegra/narc_0319.NCGR \
        files/poketool/pokegra/pokegra/narc_0320.NCGR \
        files/poketool/pokegra/pokegra/narc_0321.NCGR \
        files/poketool/pokegra/pokegra/narc_0322.NCLR \
        files/poketool/pokegra/pokegra/narc_0323.NCLR \
        files/poketool/pokegra/pokegra/narc_0324.NCGR \
        files/poketool/pokegra/pokegra/narc_0325.NCGR \
        files/poketool/pokegra/pokegra/narc_0326.NCGR \
        files/poketool/pokegra/pokegra/narc_0327.NCGR \
        files/poketool/pokegra/pokegra/narc_0328.NCLR \
        files/poketool/pokegra/pokegra/narc_0329.NCLR \
        files/poketool/pokegra/pokegra/narc_0330.NCGR \
        files/poketool/pokegra/pokegra/narc_0331.NCGR \
        files/poketool/pokegra/pokegra/narc_0332.NCGR \
        files/poketool/pokegra/pokegra/narc_0333.NCGR \
        files/poketool/pokegra/pokegra/narc_0334.NCLR \
        files/poketool/pokegra/pokegra/narc_0335.NCLR \
        files/poketool/pokegra/pokegra/narc_0336.NCGR \
        files/poketool/pokegra/pokegra/narc_0337.NCGR \
        files/poketool/pokegra/pokegra/narc_0338.NCGR \
        files/poketool/pokegra/pokegra/narc_0339.NCGR \
        files/poketool/pokegra/pokegra/narc_0340.NCLR \
        files/poketool/pokegra/pokegra/narc_0341.NCLR \
        files/poketool/pokegra/pokegra/narc_0342.NCGR \
        files/poketool/pokegra/pokegra/narc_0343.NCGR \
        files/poketool/pokegra/pokegra/narc_0344.NCGR \
        files/poketool/pokegra/pokegra/narc_0345.NCGR \
        files/poketool/pokegra/pokegra/narc_0346.NCLR \
        files/poketool/pokegra/pokegra/narc_0347.NCLR \
        files/poketool/pokegra/pokegra/narc_0348.NCGR \
        files/poketool/pokegra/pokegra/narc_0349.NCGR \
        files/poketool/pokegra/pokegra/narc_0350.NCGR \
        files/poketool/pokegra/pokegra/narc_0351.NCGR \
        files/poketool/pokegra/pokegra/narc_0352.NCLR \
        files/poketool/pokegra/pokegra/narc_0353.NCLR \
        files/poketool/pokegra/pokegra/narc_0354.NCGR \
        files/poketool/pokegra/pokegra/narc_0355.NCGR \
        files/poketool/pokegra/pokegra/narc_0356.NCGR \
        files/poketool/pokegra/pokegra/narc_0357.NCGR \
        files/poketool/pokegra/pokegra/narc_0358.NCLR \
        files/poketool/pokegra/pokegra/narc_0359.NCLR \
        files/poketool/pokegra/pokegra/narc_0360.NCGR \
        files/poketool/pokegra/pokegra/narc_0361.NCGR \
        files/poketool/pokegra/pokegra/narc_0362.NCGR \
        files/poketool/pokegra/pokegra/narc_0363.NCGR \
        files/poketool/pokegra/pokegra/narc_0364.NCLR \
        files/poketool/pokegra/pokegra/narc_0365.NCLR \
        files/poketool/pokegra/pokegra/narc_0366.NCGR \
        files/poketool/pokegra/pokegra/narc_0367.NCGR \
        files/poketool/pokegra/pokegra/narc_0368.NCGR \
        files/poketool/pokegra/pokegra/narc_0369.NCGR \
        files/poketool/pokegra/pokegra/narc_0370.NCLR \
        files/poketool/pokegra/pokegra/narc_0371.NCLR \
        files/poketool/pokegra/pokegra/narc_0372.NCGR \
        files/poketool/pokegra/pokegra/narc_0373.NCGR \
        files/poketool/pokegra/pokegra/narc_0374.NCGR \
        files/poketool/pokegra/pokegra/narc_0375.NCGR \
        files/poketool/pokegra/pokegra/narc_0376.NCLR \
        files/poketool/pokegra/pokegra/narc_0377.NCLR \
        files/poketool/pokegra/pokegra/narc_0378.NCGR \
        files/poketool/pokegra/pokegra/narc_0379.NCGR \
        files/poketool/pokegra/pokegra/narc_0380.NCGR \
        files/poketool/pokegra/pokegra/narc_0381.NCGR \
        files/poketool/pokegra/pokegra/narc_0382.NCLR \
        files/poketool/pokegra/pokegra/narc_0383.NCLR \
        files/poketool/pokegra/pokegra/narc_0384.NCGR \
        files/poketool/pokegra/pokegra/narc_0385.NCGR \
        files/poketool/pokegra/pokegra/narc_0386.NCGR \
        files/poketool/pokegra/pokegra/narc_0387.NCGR \
        files/poketool/pokegra/pokegra/narc_0388.NCLR \
        files/poketool/pokegra/pokegra/narc_0389.NCLR \
        files/poketool/pokegra/pokegra/narc_0390.NCGR \
        files/poketool/pokegra/pokegra/narc_0391.NCGR \
        files/poketool/pokegra/pokegra/narc_0392.NCGR \
        files/poketool/pokegra/pokegra/narc_0393.NCGR \
        files/poketool/pokegra/pokegra/narc_0394.NCLR \
        files/poketool/pokegra/pokegra/narc_0395.NCLR \
        files/poketool/pokegra/pokegra/narc_0396.NCGR \
        files/poketool/pokegra/pokegra/narc_0397.NCGR \
        files/poketool/pokegra/pokegra/narc_0398.NCGR \
        files/poketool/pokegra/pokegra/narc_0399.NCGR \
        files/poketool/pokegra/pokegra/narc_0400.NCLR \
        files/poketool/pokegra/pokegra/narc_0401.NCLR \
        files/poketool/pokegra/pokegra/narc_0402.NCGR \
        files/poketool/pokegra/pokegra/narc_0403.NCGR \
        files/poketool/pokegra/pokegra/narc_0404.NCGR \
        files/poketool/pokegra/pokegra/narc_0405.NCGR \
        files/poketool/pokegra/pokegra/narc_0406.NCLR \
        files/poketool/pokegra/pokegra/narc_0407.NCLR \
        files/poketool/pokegra/pokegra/narc_0408.NCGR \
        files/poketool/pokegra/pokegra/narc_0409.NCGR \
        files/poketool/pokegra/pokegra/narc_0410.NCGR \
        files/poketool/pokegra/pokegra/narc_0411.NCGR \
        files/poketool/pokegra/pokegra/narc_0412.NCLR \
        files/poketool/pokegra/pokegra/narc_0413.NCLR \
        files/poketool/pokegra/pokegra/narc_0414.NCGR \
        files/poketool/pokegra/pokegra/narc_0415.NCGR \
        files/poketool/pokegra/pokegra/narc_0416.NCGR \
        files/poketool/pokegra/pokegra/narc_0417.NCGR \
        files/poketool/pokegra/pokegra/narc_0418.NCLR \
        files/poketool/pokegra/pokegra/narc_0419.NCLR \
        files/poketool/pokegra/pokegra/narc_0420.NCGR \
        files/poketool/pokegra/pokegra/narc_0421.NCGR \
        files/poketool/pokegra/pokegra/narc_0422.NCGR \
        files/poketool/pokegra/pokegra/narc_0423.NCGR \
        files/poketool/pokegra/pokegra/narc_0424.NCLR \
        files/poketool/pokegra/pokegra/narc_0425.NCLR \
        files/poketool/pokegra/pokegra/narc_0426.NCGR \
        files/poketool/pokegra/pokegra/narc_0427.NCGR \
        files/poketool/pokegra/pokegra/narc_0428.NCGR \
        files/poketool/pokegra/pokegra/narc_0429.NCGR \
        files/poketool/pokegra/pokegra/narc_0430.NCLR \
        files/poketool/pokegra/pokegra/narc_0431.NCLR \
        files/poketool/pokegra/pokegra/narc_0432.NCGR \
        files/poketool/pokegra/pokegra/narc_0433.NCGR \
        files/poketool/pokegra/pokegra/narc_0434.NCGR \
        files/poketool/pokegra/pokegra/narc_0435.NCGR \
        files/poketool/pokegra/pokegra/narc_0436.NCLR \
        files/poketool/pokegra/pokegra/narc_0437.NCLR \
        files/poketool/pokegra/pokegra/narc_0438.NCGR \
        files/poketool/pokegra/pokegra/narc_0439.NCGR \
        files/poketool/pokegra/pokegra/narc_0440.NCGR \
        files/poketool/pokegra/pokegra/narc_0441.NCGR \
        files/poketool/pokegra/pokegra/narc_0442.NCLR \
        files/poketool/pokegra/pokegra/narc_0443.NCLR \
        files/poketool/pokegra/pokegra/narc_0444.NCGR \
        files/poketool/pokegra/pokegra/narc_0445.NCGR \
        files/poketool/pokegra/pokegra/narc_0446.NCGR \
        files/poketool/pokegra/pokegra/narc_0447.NCGR \
        files/poketool/pokegra/pokegra/narc_0448.NCLR \
        files/poketool/pokegra/pokegra/narc_0449.NCLR \
        files/poketool/pokegra/pokegra/narc_0450.NCGR \
        files/poketool/pokegra/pokegra/narc_0451.NCGR \
        files/poketool/pokegra/pokegra/narc_0452.NCGR \
        files/poketool/pokegra/pokegra/narc_0453.NCGR \
        files/poketool/pokegra/pokegra/narc_0454.NCLR \
        files/poketool/pokegra/pokegra/narc_0455.NCLR \
        files/poketool/pokegra/pokegra/narc_0456.NCGR \
        files/poketool/pokegra/pokegra/narc_0457.NCGR \
        files/poketool/pokegra/pokegra/narc_0458.NCGR \
        files/poketool/pokegra/pokegra/narc_0459.NCGR \
        files/poketool/pokegra/pokegra/narc_0460.NCLR \
        files/poketool/pokegra/pokegra/narc_0461.NCLR \
        files/poketool/pokegra/pokegra/narc_0462.NCGR \
        files/poketool/pokegra/pokegra/narc_0463.NCGR \
        files/poketool/pokegra/pokegra/narc_0464.NCGR \
        files/poketool/pokegra/pokegra/narc_0465.NCGR \
        files/poketool/pokegra/pokegra/narc_0466.NCLR \
        files/poketool/pokegra/pokegra/narc_0467.NCLR \
        files/poketool/pokegra/pokegra/narc_0468.NCGR \
        files/poketool/pokegra/pokegra/narc_0469.NCGR \
        files/poketool/pokegra/pokegra/narc_0470.NCGR \
        files/poketool/pokegra/pokegra/narc_0471.NCGR \
        files/poketool/pokegra/pokegra/narc_0472.NCLR \
        files/poketool/pokegra/pokegra/narc_0473.NCLR \
        files/poketool/pokegra/pokegra/narc_0474.NCGR \
        files/poketool/pokegra/pokegra/narc_0475.NCGR \
        files/poketool/pokegra/pokegra/narc_0476.NCGR \
        files/poketool/pokegra/pokegra/narc_0477.NCGR \
        files/poketool/pokegra/pokegra/narc_0478.NCLR \
        files/poketool/pokegra/pokegra/narc_0479.NCLR \
        files/poketool/pokegra/pokegra/narc_0480.NCGR \
        files/poketool/pokegra/pokegra/narc_0481.NCGR \
        files/poketool/pokegra/pokegra/narc_0482.NCGR \
        files/poketool/pokegra/pokegra/narc_0483.NCGR \
        files/poketool/pokegra/pokegra/narc_0484.NCLR \
        files/poketool/pokegra/pokegra/narc_0485.NCLR \
        files/poketool/pokegra/pokegra/narc_0487.NCGR \
        files/poketool/pokegra/pokegra/narc_0489.NCGR \
        files/poketool/pokegra/pokegra/narc_0490.NCLR \
        files/poketool/pokegra/pokegra/narc_0491.NCLR \
        files/poketool/pokegra/pokegra/narc_0493.NCGR \
        files/poketool/pokegra/pokegra/narc_0495.NCGR \
        files/poketool/pokegra/pokegra/narc_0496.NCLR \
        files/poketool/pokegra/pokegra/narc_0497.NCLR \
        files/poketool/pokegra/pokegra/narc_0498.NCGR \
        files/poketool/pokegra/pokegra/narc_0499.NCGR \
        files/poketool/pokegra/pokegra/narc_0500.NCGR \
        files/poketool/pokegra/pokegra/narc_0501.NCGR \
        files/poketool/pokegra/pokegra/narc_0502.NCLR \
        files/poketool/pokegra/pokegra/narc_0503.NCLR \
        files/poketool/pokegra/pokegra/narc_0504.NCGR \
        files/poketool/pokegra/pokegra/narc_0505.NCGR \
        files/poketool/pokegra/pokegra/narc_0506.NCGR \
        files/poketool/pokegra/pokegra/narc_0507.NCGR \
        files/poketool/pokegra/pokegra/narc_0508.NCLR \
        files/poketool/pokegra/pokegra/narc_0509.NCLR \
        files/poketool/pokegra/pokegra/narc_0510.NCGR \
        files/poketool/pokegra/pokegra/narc_0511.NCGR \
        files/poketool/pokegra/pokegra/narc_0512.NCGR \
        files/poketool/pokegra/pokegra/narc_0513.NCGR \
        files/poketool/pokegra/pokegra/narc_0514.NCLR \
        files/poketool/pokegra/pokegra/narc_0515.NCLR \
        files/poketool/pokegra/pokegra/narc_0516.NCGR \
        files/poketool/pokegra/pokegra/narc_0517.NCGR \
        files/poketool/pokegra/pokegra/narc_0518.NCGR \
        files/poketool/pokegra/pokegra/narc_0519.NCGR \
        files/poketool/pokegra/pokegra/narc_0520.NCLR \
        files/poketool/pokegra/pokegra/narc_0521.NCLR \
        files/poketool/pokegra/pokegra/narc_0522.NCGR \
        files/poketool/pokegra/pokegra/narc_0523.NCGR \
        files/poketool/pokegra/pokegra/narc_0524.NCGR \
        files/poketool/pokegra/pokegra/narc_0525.NCGR \
        files/poketool/pokegra/pokegra/narc_0526.NCLR \
        files/poketool/pokegra/pokegra/narc_0527.NCLR \
        files/poketool/pokegra/pokegra/narc_0528.NCGR \
        files/poketool/pokegra/pokegra/narc_0529.NCGR \
        files/poketool/pokegra/pokegra/narc_0530.NCGR \
        files/poketool/pokegra/pokegra/narc_0531.NCGR \
        files/poketool/pokegra/pokegra/narc_0532.NCLR \
        files/poketool/pokegra/pokegra/narc_0533.NCLR \
        files/poketool/pokegra/pokegra/narc_0534.NCGR \
        files/poketool/pokegra/pokegra/narc_0535.NCGR \
        files/poketool/pokegra/pokegra/narc_0536.NCGR \
        files/poketool/pokegra/pokegra/narc_0537.NCGR \
        files/poketool/pokegra/pokegra/narc_0538.NCLR \
        files/poketool/pokegra/pokegra/narc_0539.NCLR \
        files/poketool/pokegra/pokegra/narc_0540.NCGR \
        files/poketool/pokegra/pokegra/narc_0541.NCGR \
        files/poketool/pokegra/pokegra/narc_0542.NCGR \
        files/poketool/pokegra/pokegra/narc_0543.NCGR \
        files/poketool/pokegra/pokegra/narc_0544.NCLR \
        files/poketool/pokegra/pokegra/narc_0545.NCLR \
        files/poketool/pokegra/pokegra/narc_0546.NCGR \
        files/poketool/pokegra/pokegra/narc_0547.NCGR \
        files/poketool/pokegra/pokegra/narc_0548.NCGR \
        files/poketool/pokegra/pokegra/narc_0549.NCGR \
        files/poketool/pokegra/pokegra/narc_0550.NCLR \
        files/poketool/pokegra/pokegra/narc_0551.NCLR \
        files/poketool/pokegra/pokegra/narc_0552.NCGR \
        files/poketool/pokegra/pokegra/narc_0553.NCGR \
        files/poketool/pokegra/pokegra/narc_0554.NCGR \
        files/poketool/pokegra/pokegra/narc_0555.NCGR \
        files/poketool/pokegra/pokegra/narc_0556.NCLR \
        files/poketool/pokegra/pokegra/narc_0557.NCLR \
        files/poketool/pokegra/pokegra/narc_0558.NCGR \
        files/poketool/pokegra/pokegra/narc_0559.NCGR \
        files/poketool/pokegra/pokegra/narc_0560.NCGR \
        files/poketool/pokegra/pokegra/narc_0561.NCGR \
        files/poketool/pokegra/pokegra/narc_0562.NCLR \
        files/poketool/pokegra/pokegra/narc_0563.NCLR \
        files/poketool/pokegra/pokegra/narc_0564.NCGR \
        files/poketool/pokegra/pokegra/narc_0565.NCGR \
        files/poketool/pokegra/pokegra/narc_0566.NCGR \
        files/poketool/pokegra/pokegra/narc_0567.NCGR \
        files/poketool/pokegra/pokegra/narc_0568.NCLR \
        files/poketool/pokegra/pokegra/narc_0569.NCLR \
        files/poketool/pokegra/pokegra/narc_0570.NCGR \
        files/poketool/pokegra/pokegra/narc_0571.NCGR \
        files/poketool/pokegra/pokegra/narc_0572.NCGR \
        files/poketool/pokegra/pokegra/narc_0573.NCGR \
        files/poketool/pokegra/pokegra/narc_0574.NCLR \
        files/poketool/pokegra/pokegra/narc_0575.NCLR \
        files/poketool/pokegra/pokegra/narc_0576.NCGR \
        files/poketool/pokegra/pokegra/narc_0577.NCGR \
        files/poketool/pokegra/pokegra/narc_0578.NCGR \
        files/poketool/pokegra/pokegra/narc_0579.NCGR \
        files/poketool/pokegra/pokegra/narc_0580.NCLR \
        files/poketool/pokegra/pokegra/narc_0581.NCLR \
        files/poketool/pokegra/pokegra/narc_0582.NCGR \
        files/poketool/pokegra/pokegra/narc_0583.NCGR \
        files/poketool/pokegra/pokegra/narc_0584.NCGR \
        files/poketool/pokegra/pokegra/narc_0585.NCGR \
        files/poketool/pokegra/pokegra/narc_0586.NCLR \
        files/poketool/pokegra/pokegra/narc_0587.NCLR \
        files/poketool/pokegra/pokegra/narc_0588.NCGR \
        files/poketool/pokegra/pokegra/narc_0589.NCGR \
        files/poketool/pokegra/pokegra/narc_0590.NCGR \
        files/poketool/pokegra/pokegra/narc_0591.NCGR \
        files/poketool/pokegra/pokegra/narc_0592.NCLR \
        files/poketool/pokegra/pokegra/narc_0593.NCLR \
        files/poketool/pokegra/pokegra/narc_0594.NCGR \
        files/poketool/pokegra/pokegra/narc_0595.NCGR \
        files/poketool/pokegra/pokegra/narc_0596.NCGR \
        files/poketool/pokegra/pokegra/narc_0597.NCGR \
        files/poketool/pokegra/pokegra/narc_0598.NCLR \
        files/poketool/pokegra/pokegra/narc_0599.NCLR \
        files/poketool/pokegra/pokegra/narc_0601.NCGR \
        files/poketool/pokegra/pokegra/narc_0603.NCGR \
        files/poketool/pokegra/pokegra/narc_0604.NCLR \
        files/poketool/pokegra/pokegra/narc_0605.NCLR \
        files/poketool/pokegra/pokegra/narc_0607.NCGR \
        files/poketool/pokegra/pokegra/narc_0609.NCGR \
        files/poketool/pokegra/pokegra/narc_0610.NCLR \
        files/poketool/pokegra/pokegra/narc_0611.NCLR \
        files/poketool/pokegra/pokegra/narc_0612.NCGR \
        files/poketool/pokegra/pokegra/narc_0613.NCGR \
        files/poketool/pokegra/pokegra/narc_0614.NCGR \
        files/poketool/pokegra/pokegra/narc_0615.NCGR \
        files/poketool/pokegra/pokegra/narc_0616.NCLR \
        files/poketool/pokegra/pokegra/narc_0617.NCLR \
        files/poketool/pokegra/pokegra/narc_0618.NCGR \
        files/poketool/pokegra/pokegra/narc_0619.NCGR \
        files/poketool/pokegra/pokegra/narc_0620.NCGR \
        files/poketool/pokegra/pokegra/narc_0621.NCGR \
        files/poketool/pokegra/pokegra/narc_0622.NCLR \
        files/poketool/pokegra/pokegra/narc_0623.NCLR \
        files/poketool/pokegra/pokegra/narc_0624.NCGR \
        files/poketool/pokegra/pokegra/narc_0625.NCGR \
        files/poketool/pokegra/pokegra/narc_0626.NCGR \
        files/poketool/pokegra/pokegra/narc_0627.NCGR \
        files/poketool/pokegra/pokegra/narc_0628.NCLR \
        files/poketool/pokegra/pokegra/narc_0629.NCLR \
        files/poketool/pokegra/pokegra/narc_0630.NCGR \
        files/poketool/pokegra/pokegra/narc_0631.NCGR \
        files/poketool/pokegra/pokegra/narc_0632.NCGR \
        files/poketool/pokegra/pokegra/narc_0633.NCGR \
        files/poketool/pokegra/pokegra/narc_0634.NCLR \
        files/poketool/pokegra/pokegra/narc_0635.NCLR \
        files/poketool/pokegra/pokegra/narc_0637.NCGR \
        files/poketool/pokegra/pokegra/narc_0639.NCGR \
        files/poketool/pokegra/pokegra/narc_0640.NCLR \
        files/poketool/pokegra/pokegra/narc_0641.NCLR \
        files/poketool/pokegra/pokegra/narc_0643.NCGR \
        files/poketool/pokegra/pokegra/narc_0645.NCGR \
        files/poketool/pokegra/pokegra/narc_0646.NCLR \
        files/poketool/pokegra/pokegra/narc_0647.NCLR \
        files/poketool/pokegra/pokegra/narc_0648.NCGR \
        files/poketool/pokegra/pokegra/narc_0649.NCGR \
        files/poketool/pokegra/pokegra/narc_0650.NCGR \
        files/poketool/pokegra/pokegra/narc_0651.NCGR \
        files/poketool/pokegra/pokegra/narc_0652.NCLR \
        files/poketool/pokegra/pokegra/narc_0653.NCLR \
        files/poketool/pokegra/pokegra/narc_0654.NCGR \
        files/poketool/pokegra/pokegra/narc_0655.NCGR \
        files/poketool/pokegra/pokegra/narc_0656.NCGR \
        files/poketool/pokegra/pokegra/narc_0657.NCGR \
        files/poketool/pokegra/pokegra/narc_0658.NCLR \
        files/poketool/pokegra/pokegra/narc_0659.NCLR \
        files/poketool/pokegra/pokegra/narc_0660.NCGR \
        files/poketool/pokegra/pokegra/narc_0661.NCGR \
        files/poketool/pokegra/pokegra/narc_0662.NCGR \
        files/poketool/pokegra/pokegra/narc_0663.NCGR \
        files/poketool/pokegra/pokegra/narc_0664.NCLR \
        files/poketool/pokegra/pokegra/narc_0665.NCLR \
        files/poketool/pokegra/pokegra/narc_0666.NCGR \
        files/poketool/pokegra/pokegra/narc_0667.NCGR \
        files/poketool/pokegra/pokegra/narc_0668.NCGR \
        files/poketool/pokegra/pokegra/narc_0669.NCGR \
        files/poketool/pokegra/pokegra/narc_0670.NCLR \
        files/poketool/pokegra/pokegra/narc_0671.NCLR \
        files/poketool/pokegra/pokegra/narc_0672.NCGR \
        files/poketool/pokegra/pokegra/narc_0673.NCGR \
        files/poketool/pokegra/pokegra/narc_0674.NCGR \
        files/poketool/pokegra/pokegra/narc_0675.NCGR \
        files/poketool/pokegra/pokegra/narc_0676.NCLR \
        files/poketool/pokegra/pokegra/narc_0677.NCLR \
        files/poketool/pokegra/pokegra/narc_0678.NCGR \
        files/poketool/pokegra/pokegra/narc_0680.NCGR \
        files/poketool/pokegra/pokegra/narc_0682.NCLR \
        files/poketool/pokegra/pokegra/narc_0683.NCLR \
        files/poketool/pokegra/pokegra/narc_0684.NCGR \
        files/poketool/pokegra/pokegra/narc_0685.NCGR \
        files/poketool/pokegra/pokegra/narc_0686.NCGR \
        files/poketool/pokegra/pokegra/narc_0687.NCGR \
        files/poketool/pokegra/pokegra/narc_0688.NCLR \
        files/poketool/pokegra/pokegra/narc_0689.NCLR \
        files/poketool/pokegra/pokegra/narc_0690.NCGR \
        files/poketool/pokegra/pokegra/narc_0692.NCGR \
        files/poketool/pokegra/pokegra/narc_0694.NCLR \
        files/poketool/pokegra/pokegra/narc_0695.NCLR \
        files/poketool/pokegra/pokegra/narc_0696.NCGR \
        files/poketool/pokegra/pokegra/narc_0697.NCGR \
        files/poketool/pokegra/pokegra/narc_0698.NCGR \
        files/poketool/pokegra/pokegra/narc_0699.NCGR \
        files/poketool/pokegra/pokegra/narc_0700.NCLR \
        files/poketool/pokegra/pokegra/narc_0701.NCLR \
        files/poketool/pokegra/pokegra/narc_0702.NCGR \
        files/poketool/pokegra/pokegra/narc_0703.NCGR \
        files/poketool/pokegra/pokegra/narc_0704.NCGR \
        files/poketool/pokegra/pokegra/narc_0705.NCGR \
        files/poketool/pokegra/pokegra/narc_0706.NCLR \
        files/poketool/pokegra/pokegra/narc_0707.NCLR \
        files/poketool/pokegra/pokegra/narc_0708.NCGR \
        files/poketool/pokegra/pokegra/narc_0709.NCGR \
        files/poketool/pokegra/pokegra/narc_0710.NCGR \
        files/poketool/pokegra/pokegra/narc_0711.NCGR \
        files/poketool/pokegra/pokegra/narc_0712.NCLR \
        files/poketool/pokegra/pokegra/narc_0713.NCLR \
        files/poketool/pokegra/pokegra/narc_0714.NCGR \
        files/poketool/pokegra/pokegra/narc_0715.NCGR \
        files/poketool/pokegra/pokegra/narc_0716.NCGR \
        files/poketool/pokegra/pokegra/narc_0717.NCGR \
        files/poketool/pokegra/pokegra/narc_0718.NCLR \
        files/poketool/pokegra/pokegra/narc_0719.NCLR \
        files/poketool/pokegra/pokegra/narc_0721.NCGR \
        files/poketool/pokegra/pokegra/narc_0723.NCGR \
        files/poketool/pokegra/pokegra/narc_0724.NCLR \
        files/poketool/pokegra/pokegra/narc_0725.NCLR \
        files/poketool/pokegra/pokegra/narc_0727.NCGR \
        files/poketool/pokegra/pokegra/narc_0729.NCGR \
        files/poketool/pokegra/pokegra/narc_0730.NCLR \
        files/poketool/pokegra/pokegra/narc_0731.NCLR \
        files/poketool/pokegra/pokegra/narc_0732.NCGR \
        files/poketool/pokegra/pokegra/narc_0733.NCGR \
        files/poketool/pokegra/pokegra/narc_0734.NCGR \
        files/poketool/pokegra/pokegra/narc_0735.NCGR \
        files/poketool/pokegra/pokegra/narc_0736.NCLR \
        files/poketool/pokegra/pokegra/narc_0737.NCLR \
        files/poketool/pokegra/pokegra/narc_0738.NCGR \
        files/poketool/pokegra/pokegra/narc_0739.NCGR \
        files/poketool/pokegra/pokegra/narc_0740.NCGR \
        files/poketool/pokegra/pokegra/narc_0741.NCGR \
        files/poketool/pokegra/pokegra/narc_0742.NCLR \
        files/poketool/pokegra/pokegra/narc_0743.NCLR \
        files/poketool/pokegra/pokegra/narc_0744.NCGR \
        files/poketool/pokegra/pokegra/narc_0746.NCGR \
        files/poketool/pokegra/pokegra/narc_0748.NCLR \
        files/poketool/pokegra/pokegra/narc_0749.NCLR \
        files/poketool/pokegra/pokegra/narc_0750.NCGR \
        files/poketool/pokegra/pokegra/narc_0751.NCGR \
        files/poketool/pokegra/pokegra/narc_0752.NCGR \
        files/poketool/pokegra/pokegra/narc_0753.NCGR \
        files/poketool/pokegra/pokegra/narc_0754.NCLR \
        files/poketool/pokegra/pokegra/narc_0755.NCLR \
        files/poketool/pokegra/pokegra/narc_0756.NCGR \
        files/poketool/pokegra/pokegra/narc_0757.NCGR \
        files/poketool/pokegra/pokegra/narc_0758.NCGR \
        files/poketool/pokegra/pokegra/narc_0759.NCGR \
        files/poketool/pokegra/pokegra/narc_0760.NCLR \
        files/poketool/pokegra/pokegra/narc_0761.NCLR \
        files/poketool/pokegra/pokegra/narc_0762.NCGR \
        files/poketool/pokegra/pokegra/narc_0763.NCGR \
        files/poketool/pokegra/pokegra/narc_0764.NCGR \
        files/poketool/pokegra/pokegra/narc_0765.NCGR \
        files/poketool/pokegra/pokegra/narc_0766.NCLR \
        files/poketool/pokegra/pokegra/narc_0767.NCLR \
        files/poketool/pokegra/pokegra/narc_0769.NCGR \
        files/poketool/pokegra/pokegra/narc_0771.NCGR \
        files/poketool/pokegra/pokegra/narc_0772.NCLR \
        files/poketool/pokegra/pokegra/narc_0773.NCLR \
        files/poketool/pokegra/pokegra/narc_0774.NCGR \
        files/poketool/pokegra/pokegra/narc_0775.NCGR \
        files/poketool/pokegra/pokegra/narc_0776.NCGR \
        files/poketool/pokegra/pokegra/narc_0777.NCGR \
        files/poketool/pokegra/pokegra/narc_0778.NCLR \
        files/poketool/pokegra/pokegra/narc_0779.NCLR \
        files/poketool/pokegra/pokegra/narc_0780.NCGR \
        files/poketool/pokegra/pokegra/narc_0781.NCGR \
        files/poketool/pokegra/pokegra/narc_0782.NCGR \
        files/poketool/pokegra/pokegra/narc_0783.NCGR \
        files/poketool/pokegra/pokegra/narc_0784.NCLR \
        files/poketool/pokegra/pokegra/narc_0785.NCLR \
        files/poketool/pokegra/pokegra/narc_0786.NCGR \
        files/poketool/pokegra/pokegra/narc_0787.NCGR \
        files/poketool/pokegra/pokegra/narc_0788.NCGR \
        files/poketool/pokegra/pokegra/narc_0789.NCGR \
        files/poketool/pokegra/pokegra/narc_0790.NCLR \
        files/poketool/pokegra/pokegra/narc_0791.NCLR \
        files/poketool/pokegra/pokegra/narc_0793.NCGR \
        files/poketool/pokegra/pokegra/narc_0795.NCGR \
        files/poketool/pokegra/pokegra/narc_0796.NCLR \
        files/poketool/pokegra/pokegra/narc_0797.NCLR \
        files/poketool/pokegra/pokegra/narc_0798.NCGR \
        files/poketool/pokegra/pokegra/narc_0799.NCGR \
        files/poketool/pokegra/pokegra/narc_0800.NCGR \
        files/poketool/pokegra/pokegra/narc_0801.NCGR \
        files/poketool/pokegra/pokegra/narc_0802.NCLR \
        files/poketool/pokegra/pokegra/narc_0803.NCLR \
        files/poketool/pokegra/pokegra/narc_0804.NCGR \
        files/poketool/pokegra/pokegra/narc_0805.NCGR \
        files/poketool/pokegra/pokegra/narc_0806.NCGR \
        files/poketool/pokegra/pokegra/narc_0807.NCGR \
        files/poketool/pokegra/pokegra/narc_0808.NCLR \
        files/poketool/pokegra/pokegra/narc_0809.NCLR \
        files/poketool/pokegra/pokegra/narc_0810.NCGR \
        files/poketool/pokegra/pokegra/narc_0811.NCGR \
        files/poketool/pokegra/pokegra/narc_0812.NCGR \
        files/poketool/pokegra/pokegra/narc_0813.NCGR \
        files/poketool/pokegra/pokegra/narc_0814.NCLR \
        files/poketool/pokegra/pokegra/narc_0815.NCLR \
        files/poketool/pokegra/pokegra/narc_0816.NCGR \
        files/poketool/pokegra/pokegra/narc_0817.NCGR \
        files/poketool/pokegra/pokegra/narc_0818.NCGR \
        files/poketool/pokegra/pokegra/narc_0819.NCGR \
        files/poketool/pokegra/pokegra/narc_0820.NCLR \
        files/poketool/pokegra/pokegra/narc_0821.NCLR \
        files/poketool/pokegra/pokegra/narc_0823.NCGR \
        files/poketool/pokegra/pokegra/narc_0825.NCGR \
        files/poketool/pokegra/pokegra/narc_0826.NCLR \
        files/poketool/pokegra/pokegra/narc_0827.NCLR \
        files/poketool/pokegra/pokegra/narc_0828.NCGR \
        files/poketool/pokegra/pokegra/narc_0829.NCGR \
        files/poketool/pokegra/pokegra/narc_0830.NCGR \
        files/poketool/pokegra/pokegra/narc_0831.NCGR \
        files/poketool/pokegra/pokegra/narc_0832.NCLR \
        files/poketool/pokegra/pokegra/narc_0833.NCLR \
        files/poketool/pokegra/pokegra/narc_0834.NCGR \
        files/poketool/pokegra/pokegra/narc_0835.NCGR \
        files/poketool/pokegra/pokegra/narc_0836.NCGR \
        files/poketool/pokegra/pokegra/narc_0837.NCGR \
        files/poketool/pokegra/pokegra/narc_0838.NCLR \
        files/poketool/pokegra/pokegra/narc_0839.NCLR \
        files/poketool/pokegra/pokegra/narc_0840.NCGR \
        files/poketool/pokegra/pokegra/narc_0841.NCGR \
        files/poketool/pokegra/pokegra/narc_0842.NCGR \
        files/poketool/pokegra/pokegra/narc_0843.NCGR \
        files/poketool/pokegra/pokegra/narc_0844.NCLR \
        files/poketool/pokegra/pokegra/narc_0845.NCLR \
        files/poketool/pokegra/pokegra/narc_0846.NCGR \
        files/poketool/pokegra/pokegra/narc_0847.NCGR \
        files/poketool/pokegra/pokegra/narc_0848.NCGR \
        files/poketool/pokegra/pokegra/narc_0849.NCGR \
        files/poketool/pokegra/pokegra/narc_0850.NCLR \
        files/poketool/pokegra/pokegra/narc_0851.NCLR \
        files/poketool/pokegra/pokegra/narc_0852.NCGR \
        files/poketool/pokegra/pokegra/narc_0853.NCGR \
        files/poketool/pokegra/pokegra/narc_0854.NCGR \
        files/poketool/pokegra/pokegra/narc_0855.NCGR \
        files/poketool/pokegra/pokegra/narc_0856.NCLR \
        files/poketool/pokegra/pokegra/narc_0857.NCLR \
        files/poketool/pokegra/pokegra/narc_0858.NCGR \
        files/poketool/pokegra/pokegra/narc_0859.NCGR \
        files/poketool/pokegra/pokegra/narc_0860.NCGR \
        files/poketool/pokegra/pokegra/narc_0861.NCGR \
        files/poketool/pokegra/pokegra/narc_0862.NCLR \
        files/poketool/pokegra/pokegra/narc_0863.NCLR \
        files/poketool/pokegra/pokegra/narc_0865.NCGR \
        files/poketool/pokegra/pokegra/narc_0867.NCGR \
        files/poketool/pokegra/pokegra/narc_0868.NCLR \
        files/poketool/pokegra/pokegra/narc_0869.NCLR \
        files/poketool/pokegra/pokegra/narc_0871.NCGR \
        files/poketool/pokegra/pokegra/narc_0873.NCGR \
        files/poketool/pokegra/pokegra/narc_0874.NCLR \
        files/poketool/pokegra/pokegra/narc_0875.NCLR \
        files/poketool/pokegra/pokegra/narc_0877.NCGR \
        files/poketool/pokegra/pokegra/narc_0879.NCGR \
        files/poketool/pokegra/pokegra/narc_0880.NCLR \
        files/poketool/pokegra/pokegra/narc_0881.NCLR \
        files/poketool/pokegra/pokegra/narc_0882.NCGR \
        files/poketool/pokegra/pokegra/narc_0883.NCGR \
        files/poketool/pokegra/pokegra/narc_0884.NCGR \
        files/poketool/pokegra/pokegra/narc_0885.NCGR \
        files/poketool/pokegra/pokegra/narc_0886.NCLR \
        files/poketool/pokegra/pokegra/narc_0887.NCLR \
        files/poketool/pokegra/pokegra/narc_0888.NCGR \
        files/poketool/pokegra/pokegra/narc_0889.NCGR \
        files/poketool/pokegra/pokegra/narc_0890.NCGR \
        files/poketool/pokegra/pokegra/narc_0891.NCGR \
        files/poketool/pokegra/pokegra/narc_0892.NCLR \
        files/poketool/pokegra/pokegra/narc_0893.NCLR \
        files/poketool/pokegra/pokegra/narc_0894.NCGR \
        files/poketool/pokegra/pokegra/narc_0895.NCGR \
        files/poketool/pokegra/pokegra/narc_0896.NCGR \
        files/poketool/pokegra/pokegra/narc_0897.NCGR \
        files/poketool/pokegra/pokegra/narc_0898.NCLR \
        files/poketool/pokegra/pokegra/narc_0899.NCLR \
        files/poketool/pokegra/pokegra/narc_0901.NCGR \
        files/poketool/pokegra/pokegra/narc_0903.NCGR \
        files/poketool/pokegra/pokegra/narc_0904.NCLR \
        files/poketool/pokegra/pokegra/narc_0905.NCLR \
        files/poketool/pokegra/pokegra/narc_0907.NCGR \
        files/poketool/pokegra/pokegra/narc_0909.NCGR \
        files/poketool/pokegra/pokegra/narc_0910.NCLR \
        files/poketool/pokegra/pokegra/narc_0911.NCLR \
        files/poketool/pokegra/pokegra/narc_0912.NCGR \
        files/poketool/pokegra/pokegra/narc_0913.NCGR \
        files/poketool/pokegra/pokegra/narc_0914.NCGR \
        files/poketool/pokegra/pokegra/narc_0915.NCGR \
        files/poketool/pokegra/pokegra/narc_0916.NCLR \
        files/poketool/pokegra/pokegra/narc_0917.NCLR \
        files/poketool/pokegra/pokegra/narc_0918.NCGR \
        files/poketool/pokegra/pokegra/narc_0919.NCGR \
        files/poketool/pokegra/pokegra/narc_0920.NCGR \
        files/poketool/pokegra/pokegra/narc_0921.NCGR \
        files/poketool/pokegra/pokegra/narc_0922.NCLR \
        files/poketool/pokegra/pokegra/narc_0923.NCLR \
        files/poketool/pokegra/pokegra/narc_0924.NCGR \
        files/poketool/pokegra/pokegra/narc_0925.NCGR \
        files/poketool/pokegra/pokegra/narc_0926.NCGR \
        files/poketool/pokegra/pokegra/narc_0927.NCGR \
        files/poketool/pokegra/pokegra/narc_0928.NCLR \
        files/poketool/pokegra/pokegra/narc_0929.NCLR \
        files/poketool/pokegra/pokegra/narc_0930.NCGR \
        files/poketool/pokegra/pokegra/narc_0931.NCGR \
        files/poketool/pokegra/pokegra/narc_0932.NCGR \
        files/poketool/pokegra/pokegra/narc_0933.NCGR \
        files/poketool/pokegra/pokegra/narc_0934.NCLR \
        files/poketool/pokegra/pokegra/narc_0935.NCLR \
        files/poketool/pokegra/pokegra/narc_0936.NCGR \
        files/poketool/pokegra/pokegra/narc_0937.NCGR \
        files/poketool/pokegra/pokegra/narc_0938.NCGR \
        files/poketool/pokegra/pokegra/narc_0939.NCGR \
        files/poketool/pokegra/pokegra/narc_0940.NCLR \
        files/poketool/pokegra/pokegra/narc_0941.NCLR \
        files/poketool/pokegra/pokegra/narc_0942.NCGR \
        files/poketool/pokegra/pokegra/narc_0943.NCGR \
        files/poketool/pokegra/pokegra/narc_0944.NCGR \
        files/poketool/pokegra/pokegra/narc_0945.NCGR \
        files/poketool/pokegra/pokegra/narc_0946.NCLR \
        files/poketool/pokegra/pokegra/narc_0947.NCLR \
        files/poketool/pokegra/pokegra/narc_0948.NCGR \
        files/poketool/pokegra/pokegra/narc_0949.NCGR \
        files/poketool/pokegra/pokegra/narc_0950.NCGR \
        files/poketool/pokegra/pokegra/narc_0951.NCGR \
        files/poketool/pokegra/pokegra/narc_0952.NCLR \
        files/poketool/pokegra/pokegra/narc_0953.NCLR \
        files/poketool/pokegra/pokegra/narc_0954.NCGR \
        files/poketool/pokegra/pokegra/narc_0955.NCGR \
        files/poketool/pokegra/pokegra/narc_0956.NCGR \
        files/poketool/pokegra/pokegra/narc_0957.NCGR \
        files/poketool/pokegra/pokegra/narc_0958.NCLR \
        files/poketool/pokegra/pokegra/narc_0959.NCLR \
        files/poketool/pokegra/pokegra/narc_0960.NCGR \
        files/poketool/pokegra/pokegra/narc_0961.NCGR \
        files/poketool/pokegra/pokegra/narc_0962.NCGR \
        files/poketool/pokegra/pokegra/narc_0963.NCGR \
        files/poketool/pokegra/pokegra/narc_0964.NCLR \
        files/poketool/pokegra/pokegra/narc_0965.NCLR \
        files/poketool/pokegra/pokegra/narc_0966.NCGR \
        files/poketool/pokegra/pokegra/narc_0967.NCGR \
        files/poketool/pokegra/pokegra/narc_0968.NCGR \
        files/poketool/pokegra/pokegra/narc_0969.NCGR \
        files/poketool/pokegra/pokegra/narc_0970.NCLR \
        files/poketool/pokegra/pokegra/narc_0971.NCLR \
        files/poketool/pokegra/pokegra/narc_0972.NCGR \
        files/poketool/pokegra/pokegra/narc_0973.NCGR \
        files/poketool/pokegra/pokegra/narc_0974.NCGR \
        files/poketool/pokegra/pokegra/narc_0975.NCGR \
        files/poketool/pokegra/pokegra/narc_0976.NCLR \
        files/poketool/pokegra/pokegra/narc_0977.NCLR \
        files/poketool/pokegra/pokegra/narc_0978.NCGR \
        files/poketool/pokegra/pokegra/narc_0979.NCGR \
        files/poketool/pokegra/pokegra/narc_0980.NCGR \
        files/poketool/pokegra/pokegra/narc_0981.NCGR \
        files/poketool/pokegra/pokegra/narc_0982.NCLR \
        files/poketool/pokegra/pokegra/narc_0983.NCLR \
        files/poketool/pokegra/pokegra/narc_0984.NCGR \
        files/poketool/pokegra/pokegra/narc_0985.NCGR \
        files/poketool/pokegra/pokegra/narc_0986.NCGR \
        files/poketool/pokegra/pokegra/narc_0987.NCGR \
        files/poketool/pokegra/pokegra/narc_0988.NCLR \
        files/poketool/pokegra/pokegra/narc_0989.NCLR \
        files/poketool/pokegra/pokegra/narc_0990.NCGR \
        files/poketool/pokegra/pokegra/narc_0991.NCGR \
        files/poketool/pokegra/pokegra/narc_0992.NCGR \
        files/poketool/pokegra/pokegra/narc_0993.NCGR \
        files/poketool/pokegra/pokegra/narc_0994.NCLR \
        files/poketool/pokegra/pokegra/narc_0995.NCLR \
        files/poketool/pokegra/pokegra/narc_0996.NCGR \
        files/poketool/pokegra/pokegra/narc_0997.NCGR \
        files/poketool/pokegra/pokegra/narc_0998.NCGR \
        files/poketool/pokegra/pokegra/narc_0999.NCGR \
        files/poketool/pokegra/pokegra/narc_1000.NCLR \
        files/poketool/pokegra/pokegra/narc_1001.NCLR \
        files/poketool/pokegra/pokegra/narc_1002.NCGR \
        files/poketool/pokegra/pokegra/narc_1003.NCGR \
        files/poketool/pokegra/pokegra/narc_1004.NCGR \
        files/poketool/pokegra/pokegra/narc_1005.NCGR \
        files/poketool/pokegra/pokegra/narc_1006.NCLR \
        files/poketool/pokegra/pokegra/narc_1007.NCLR \
        files/poketool/pokegra/pokegra/narc_1008.NCGR \
        files/poketool/pokegra/pokegra/narc_1009.NCGR \
        files/poketool/pokegra/pokegra/narc_1010.NCGR \
        files/poketool/pokegra/pokegra/narc_1011.NCGR \
        files/poketool/pokegra/pokegra/narc_1012.NCLR \
        files/poketool/pokegra/pokegra/narc_1013.NCLR \
        files/poketool/pokegra/pokegra/narc_1014.NCGR \
        files/poketool/pokegra/pokegra/narc_1015.NCGR \
        files/poketool/pokegra/pokegra/narc_1016.NCGR \
        files/poketool/pokegra/pokegra/narc_1017.NCGR \
        files/poketool/pokegra/pokegra/narc_1018.NCLR \
        files/poketool/pokegra/pokegra/narc_1019.NCLR \
        files/poketool/pokegra/pokegra/narc_1020.NCGR \
        files/poketool/pokegra/pokegra/narc_1021.NCGR \
        files/poketool/pokegra/pokegra/narc_1022.NCGR \
        files/poketool/pokegra/pokegra/narc_1023.NCGR \
        files/poketool/pokegra/pokegra/narc_1024.NCLR \
        files/poketool/pokegra/pokegra/narc_1025.NCLR \
        files/poketool/pokegra/pokegra/narc_1026.NCGR \
        files/poketool/pokegra/pokegra/narc_1027.NCGR \
        files/poketool/pokegra/pokegra/narc_1028.NCGR \
        files/poketool/pokegra/pokegra/narc_1029.NCGR \
        files/poketool/pokegra/pokegra/narc_1030.NCLR \
        files/poketool/pokegra/pokegra/narc_1031.NCLR \
        files/poketool/pokegra/pokegra/narc_1032.NCGR \
        files/poketool/pokegra/pokegra/narc_1033.NCGR \
        files/poketool/pokegra/pokegra/narc_1034.NCGR \
        files/poketool/pokegra/pokegra/narc_1035.NCGR \
        files/poketool/pokegra/pokegra/narc_1036.NCLR \
        files/poketool/pokegra/pokegra/narc_1037.NCLR \
        files/poketool/pokegra/pokegra/narc_1038.NCGR \
        files/poketool/pokegra/pokegra/narc_1039.NCGR \
        files/poketool/pokegra/pokegra/narc_1040.NCGR \
        files/poketool/pokegra/pokegra/narc_1041.NCGR \
        files/poketool/pokegra/pokegra/narc_1042.NCLR \
        files/poketool/pokegra/pokegra/narc_1043.NCLR \
        files/poketool/pokegra/pokegra/narc_1044.NCGR \
        files/poketool/pokegra/pokegra/narc_1045.NCGR \
        files/poketool/pokegra/pokegra/narc_1046.NCGR \
        files/poketool/pokegra/pokegra/narc_1047.NCGR \
        files/poketool/pokegra/pokegra/narc_1048.NCLR \
        files/poketool/pokegra/pokegra/narc_1049.NCLR \
        files/poketool/pokegra/pokegra/narc_1050.NCGR \
        files/poketool/pokegra/pokegra/narc_1051.NCGR \
        files/poketool/pokegra/pokegra/narc_1052.NCGR \
        files/poketool/pokegra/pokegra/narc_1053.NCGR \
        files/poketool/pokegra/pokegra/narc_1054.NCLR \
        files/poketool/pokegra/pokegra/narc_1055.NCLR \
        files/poketool/pokegra/pokegra/narc_1056.NCGR \
        files/poketool/pokegra/pokegra/narc_1057.NCGR \
        files/poketool/pokegra/pokegra/narc_1058.NCGR \
        files/poketool/pokegra/pokegra/narc_1059.NCGR \
        files/poketool/pokegra/pokegra/narc_1060.NCLR \
        files/poketool/pokegra/pokegra/narc_1061.NCLR \
        files/poketool/pokegra/pokegra/narc_1062.NCGR \
        files/poketool/pokegra/pokegra/narc_1063.NCGR \
        files/poketool/pokegra/pokegra/narc_1064.NCGR \
        files/poketool/pokegra/pokegra/narc_1065.NCGR \
        files/poketool/pokegra/pokegra/narc_1066.NCLR \
        files/poketool/pokegra/pokegra/narc_1067.NCLR \
        files/poketool/pokegra/pokegra/narc_1068.NCGR \
        files/poketool/pokegra/pokegra/narc_1069.NCGR \
        files/poketool/pokegra/pokegra/narc_1070.NCGR \
        files/poketool/pokegra/pokegra/narc_1071.NCGR \
        files/poketool/pokegra/pokegra/narc_1072.NCLR \
        files/poketool/pokegra/pokegra/narc_1073.NCLR \
        files/poketool/pokegra/pokegra/narc_1074.NCGR \
        files/poketool/pokegra/pokegra/narc_1075.NCGR \
        files/poketool/pokegra/pokegra/narc_1076.NCGR \
        files/poketool/pokegra/pokegra/narc_1077.NCGR \
        files/poketool/pokegra/pokegra/narc_1078.NCLR \
        files/poketool/pokegra/pokegra/narc_1079.NCLR \
        files/poketool/pokegra/pokegra/narc_1080.NCGR \
        files/poketool/pokegra/pokegra/narc_1081.NCGR \
        files/poketool/pokegra/pokegra/narc_1082.NCGR \
        files/poketool/pokegra/pokegra/narc_1083.NCGR \
        files/poketool/pokegra/pokegra/narc_1084.NCLR \
        files/poketool/pokegra/pokegra/narc_1085.NCLR \
        files/poketool/pokegra/pokegra/narc_1086.NCGR \
        files/poketool/pokegra/pokegra/narc_1087.NCGR \
        files/poketool/pokegra/pokegra/narc_1088.NCGR \
        files/poketool/pokegra/pokegra/narc_1089.NCGR \
        files/poketool/pokegra/pokegra/narc_1090.NCLR \
        files/poketool/pokegra/pokegra/narc_1091.NCLR \
        files/poketool/pokegra/pokegra/narc_1092.NCGR \
        files/poketool/pokegra/pokegra/narc_1093.NCGR \
        files/poketool/pokegra/pokegra/narc_1094.NCGR \
        files/poketool/pokegra/pokegra/narc_1095.NCGR \
        files/poketool/pokegra/pokegra/narc_1096.NCLR \
        files/poketool/pokegra/pokegra/narc_1097.NCLR \
        files/poketool/pokegra/pokegra/narc_1098.NCGR \
        files/poketool/pokegra/pokegra/narc_1099.NCGR \
        files/poketool/pokegra/pokegra/narc_1100.NCGR \
        files/poketool/pokegra/pokegra/narc_1101.NCGR \
        files/poketool/pokegra/pokegra/narc_1102.NCLR \
        files/poketool/pokegra/pokegra/narc_1103.NCLR \
        files/poketool/pokegra/pokegra/narc_1104.NCGR \
        files/poketool/pokegra/pokegra/narc_1105.NCGR \
        files/poketool/pokegra/pokegra/narc_1106.NCGR \
        files/poketool/pokegra/pokegra/narc_1107.NCGR \
        files/poketool/pokegra/pokegra/narc_1108.NCLR \
        files/poketool/pokegra/pokegra/narc_1109.NCLR \
        files/poketool/pokegra/pokegra/narc_1110.NCGR \
        files/poketool/pokegra/pokegra/narc_1111.NCGR \
        files/poketool/pokegra/pokegra/narc_1112.NCGR \
        files/poketool/pokegra/pokegra/narc_1113.NCGR \
        files/poketool/pokegra/pokegra/narc_1114.NCLR \
        files/poketool/pokegra/pokegra/narc_1115.NCLR \
        files/poketool/pokegra/pokegra/narc_1116.NCGR \
        files/poketool/pokegra/pokegra/narc_1117.NCGR \
        files/poketool/pokegra/pokegra/narc_1118.NCGR \
        files/poketool/pokegra/pokegra/narc_1119.NCGR \
        files/poketool/pokegra/pokegra/narc_1120.NCLR \
        files/poketool/pokegra/pokegra/narc_1121.NCLR \
        files/poketool/pokegra/pokegra/narc_1122.NCGR \
        files/poketool/pokegra/pokegra/narc_1123.NCGR \
        files/poketool/pokegra/pokegra/narc_1124.NCGR \
        files/poketool/pokegra/pokegra/narc_1125.NCGR \
        files/poketool/pokegra/pokegra/narc_1126.NCLR \
        files/poketool/pokegra/pokegra/narc_1127.NCLR \
        files/poketool/pokegra/pokegra/narc_1128.NCGR \
        files/poketool/pokegra/pokegra/narc_1129.NCGR \
        files/poketool/pokegra/pokegra/narc_1130.NCGR \
        files/poketool/pokegra/pokegra/narc_1131.NCGR \
        files/poketool/pokegra/pokegra/narc_1132.NCLR \
        files/poketool/pokegra/pokegra/narc_1133.NCLR \
        files/poketool/pokegra/pokegra/narc_1134.NCGR \
        files/poketool/pokegra/pokegra/narc_1135.NCGR \
        files/poketool/pokegra/pokegra/narc_1136.NCGR \
        files/poketool/pokegra/pokegra/narc_1137.NCGR \
        files/poketool/pokegra/pokegra/narc_1138.NCLR \
        files/poketool/pokegra/pokegra/narc_1139.NCLR \
        files/poketool/pokegra/pokegra/narc_1140.NCGR \
        files/poketool/pokegra/pokegra/narc_1141.NCGR \
        files/poketool/pokegra/pokegra/narc_1142.NCGR \
        files/poketool/pokegra/pokegra/narc_1143.NCGR \
        files/poketool/pokegra/pokegra/narc_1144.NCLR \
        files/poketool/pokegra/pokegra/narc_1145.NCLR \
        files/poketool/pokegra/pokegra/narc_1146.NCGR \
        files/poketool/pokegra/pokegra/narc_1147.NCGR \
        files/poketool/pokegra/pokegra/narc_1148.NCGR \
        files/poketool/pokegra/pokegra/narc_1149.NCGR \
        files/poketool/pokegra/pokegra/narc_1150.NCLR \
        files/poketool/pokegra/pokegra/narc_1151.NCLR \
        files/poketool/pokegra/pokegra/narc_1152.NCGR \
        files/poketool/pokegra/pokegra/narc_1153.NCGR \
        files/poketool/pokegra/pokegra/narc_1154.NCGR \
        files/poketool/pokegra/pokegra/narc_1155.NCGR \
        files/poketool/pokegra/pokegra/narc_1156.NCLR \
        files/poketool/pokegra/pokegra/narc_1157.NCLR \
        files/poketool/pokegra/pokegra/narc_1158.NCGR \
        files/poketool/pokegra/pokegra/narc_1159.NCGR \
        files/poketool/pokegra/pokegra/narc_1160.NCGR \
        files/poketool/pokegra/pokegra/narc_1161.NCGR \
        files/poketool/pokegra/pokegra/narc_1162.NCLR \
        files/poketool/pokegra/pokegra/narc_1163.NCLR \
        files/poketool/pokegra/pokegra/narc_1164.NCGR \
        files/poketool/pokegra/pokegra/narc_1165.NCGR \
        files/poketool/pokegra/pokegra/narc_1166.NCGR \
        files/poketool/pokegra/pokegra/narc_1167.NCGR \
        files/poketool/pokegra/pokegra/narc_1168.NCLR \
        files/poketool/pokegra/pokegra/narc_1169.NCLR \
        files/poketool/pokegra/pokegra/narc_1170.NCGR \
        files/poketool/pokegra/pokegra/narc_1171.NCGR \
        files/poketool/pokegra/pokegra/narc_1172.NCGR \
        files/poketool/pokegra/pokegra/narc_1173.NCGR \
        files/poketool/pokegra/pokegra/narc_1174.NCLR \
        files/poketool/pokegra/pokegra/narc_1175.NCLR \
        files/poketool/pokegra/pokegra/narc_1176.NCGR \
        files/poketool/pokegra/pokegra/narc_1177.NCGR \
        files/poketool/pokegra/pokegra/narc_1178.NCGR \
        files/poketool/pokegra/pokegra/narc_1179.NCGR \
        files/poketool/pokegra/pokegra/narc_1180.NCLR \
        files/poketool/pokegra/pokegra/narc_1181.NCLR \
        files/poketool/pokegra/pokegra/narc_1182.NCGR \
        files/poketool/pokegra/pokegra/narc_1183.NCGR \
        files/poketool/pokegra/pokegra/narc_1184.NCGR \
        files/poketool/pokegra/pokegra/narc_1185.NCGR \
        files/poketool/pokegra/pokegra/narc_1186.NCLR \
        files/poketool/pokegra/pokegra/narc_1187.NCLR \
        files/poketool/pokegra/pokegra/narc_1188.NCGR \
        files/poketool/pokegra/pokegra/narc_1189.NCGR \
        files/poketool/pokegra/pokegra/narc_1190.NCGR \
        files/poketool/pokegra/pokegra/narc_1191.NCGR \
        files/poketool/pokegra/pokegra/narc_1192.NCLR \
        files/poketool/pokegra/pokegra/narc_1193.NCLR \
        files/poketool/pokegra/pokegra/narc_1194.NCGR \
        files/poketool/pokegra/pokegra/narc_1195.NCGR \
        files/poketool/pokegra/pokegra/narc_1196.NCGR \
        files/poketool/pokegra/pokegra/narc_1197.NCGR \
        files/poketool/pokegra/pokegra/narc_1198.NCLR \
        files/poketool/pokegra/pokegra/narc_1199.NCLR \
        files/poketool/pokegra/pokegra/narc_1200.NCGR \
        files/poketool/pokegra/pokegra/narc_1201.NCGR \
        files/poketool/pokegra/pokegra/narc_1202.NCGR \
        files/poketool/pokegra/pokegra/narc_1203.NCGR \
        files/poketool/pokegra/pokegra/narc_1204.NCLR \
        files/poketool/pokegra/pokegra/narc_1205.NCLR \
        files/poketool/pokegra/pokegra/narc_1207.NCGR \
        files/poketool/pokegra/pokegra/narc_1209.NCGR \
        files/poketool/pokegra/pokegra/narc_1210.NCLR \
        files/poketool/pokegra/pokegra/narc_1211.NCLR \
        files/poketool/pokegra/pokegra/narc_1212.NCGR \
        files/poketool/pokegra/pokegra/narc_1213.NCGR \
        files/poketool/pokegra/pokegra/narc_1214.NCGR \
        files/poketool/pokegra/pokegra/narc_1215.NCGR \
        files/poketool/pokegra/pokegra/narc_1216.NCLR \
        files/poketool/pokegra/pokegra/narc_1217.NCLR \
        files/poketool/pokegra/pokegra/narc_1218.NCGR \
        files/poketool/pokegra/pokegra/narc_1219.NCGR \
        files/poketool/pokegra/pokegra/narc_1220.NCGR \
        files/poketool/pokegra/pokegra/narc_1221.NCGR \
        files/poketool/pokegra/pokegra/narc_1222.NCLR \
        files/poketool/pokegra/pokegra/narc_1223.NCLR \
        files/poketool/pokegra/pokegra/narc_1224.NCGR \
        files/poketool/pokegra/pokegra/narc_1225.NCGR \
        files/poketool/pokegra/pokegra/narc_1226.NCGR \
        files/poketool/pokegra/pokegra/narc_1227.NCGR \
        files/poketool/pokegra/pokegra/narc_1228.NCLR \
        files/poketool/pokegra/pokegra/narc_1229.NCLR \
        files/poketool/pokegra/pokegra/narc_1230.NCGR \
        files/poketool/pokegra/pokegra/narc_1231.NCGR \
        files/poketool/pokegra/pokegra/narc_1232.NCGR \
        files/poketool/pokegra/pokegra/narc_1233.NCGR \
        files/poketool/pokegra/pokegra/narc_1234.NCLR \
        files/poketool/pokegra/pokegra/narc_1235.NCLR \
        files/poketool/pokegra/pokegra/narc_1236.NCGR \
        files/poketool/pokegra/pokegra/narc_1237.NCGR \
        files/poketool/pokegra/pokegra/narc_1238.NCGR \
        files/poketool/pokegra/pokegra/narc_1239.NCGR \
        files/poketool/pokegra/pokegra/narc_1240.NCLR \
        files/poketool/pokegra/pokegra/narc_1241.NCLR \
        files/poketool/pokegra/pokegra/narc_1242.NCGR \
        files/poketool/pokegra/pokegra/narc_1243.NCGR \
        files/poketool/pokegra/pokegra/narc_1244.NCGR \
        files/poketool/pokegra/pokegra/narc_1245.NCGR \
        files/poketool/pokegra/pokegra/narc_1246.NCLR \
        files/poketool/pokegra/pokegra/narc_1247.NCLR \
        files/poketool/pokegra/pokegra/narc_1248.NCGR \
        files/poketool/pokegra/pokegra/narc_1249.NCGR \
        files/poketool/pokegra/pokegra/narc_1250.NCGR \
        files/poketool/pokegra/pokegra/narc_1251.NCGR \
        files/poketool/pokegra/pokegra/narc_1252.NCLR \
        files/poketool/pokegra/pokegra/narc_1253.NCLR \
        files/poketool/pokegra/pokegra/narc_1254.NCGR \
        files/poketool/pokegra/pokegra/narc_1255.NCGR \
        files/poketool/pokegra/pokegra/narc_1256.NCGR \
        files/poketool/pokegra/pokegra/narc_1257.NCGR \
        files/poketool/pokegra/pokegra/narc_1258.NCLR \
        files/poketool/pokegra/pokegra/narc_1259.NCLR \
        files/poketool/pokegra/pokegra/narc_1260.NCGR \
        files/poketool/pokegra/pokegra/narc_1261.NCGR \
        files/poketool/pokegra/pokegra/narc_1262.NCGR \
        files/poketool/pokegra/pokegra/narc_1263.NCGR \
        files/poketool/pokegra/pokegra/narc_1264.NCLR \
        files/poketool/pokegra/pokegra/narc_1265.NCLR \
        files/poketool/pokegra/pokegra/narc_1266.NCGR \
        files/poketool/pokegra/pokegra/narc_1267.NCGR \
        files/poketool/pokegra/pokegra/narc_1268.NCGR \
        files/poketool/pokegra/pokegra/narc_1269.NCGR \
        files/poketool/pokegra/pokegra/narc_1270.NCLR \
        files/poketool/pokegra/pokegra/narc_1271.NCLR \
        files/poketool/pokegra/pokegra/narc_1272.NCGR \
        files/poketool/pokegra/pokegra/narc_1273.NCGR \
        files/poketool/pokegra/pokegra/narc_1274.NCGR \
        files/poketool/pokegra/pokegra/narc_1275.NCGR \
        files/poketool/pokegra/pokegra/narc_1276.NCLR \
        files/poketool/pokegra/pokegra/narc_1277.NCLR \
        files/poketool/pokegra/pokegra/narc_1278.NCGR \
        files/poketool/pokegra/pokegra/narc_1279.NCGR \
        files/poketool/pokegra/pokegra/narc_1280.NCGR \
        files/poketool/pokegra/pokegra/narc_1281.NCGR \
        files/poketool/pokegra/pokegra/narc_1282.NCLR \
        files/poketool/pokegra/pokegra/narc_1283.NCLR \
        files/poketool/pokegra/pokegra/narc_1284.NCGR \
        files/poketool/pokegra/pokegra/narc_1285.NCGR \
        files/poketool/pokegra/pokegra/narc_1286.NCGR \
        files/poketool/pokegra/pokegra/narc_1287.NCGR \
        files/poketool/pokegra/pokegra/narc_1288.NCLR \
        files/poketool/pokegra/pokegra/narc_1289.NCLR \
        files/poketool/pokegra/pokegra/narc_1290.NCGR \
        files/poketool/pokegra/pokegra/narc_1291.NCGR \
        files/poketool/pokegra/pokegra/narc_1292.NCGR \
        files/poketool/pokegra/pokegra/narc_1293.NCGR \
        files/poketool/pokegra/pokegra/narc_1294.NCLR \
        files/poketool/pokegra/pokegra/narc_1295.NCLR \
        files/poketool/pokegra/pokegra/narc_1296.NCGR \
        files/poketool/pokegra/pokegra/narc_1297.NCGR \
        files/poketool/pokegra/pokegra/narc_1298.NCGR \
        files/poketool/pokegra/pokegra/narc_1299.NCGR \
        files/poketool/pokegra/pokegra/narc_1300.NCLR \
        files/poketool/pokegra/pokegra/narc_1301.NCLR \
        files/poketool/pokegra/pokegra/narc_1302.NCGR \
        files/poketool/pokegra/pokegra/narc_1303.NCGR \
        files/poketool/pokegra/pokegra/narc_1304.NCGR \
        files/poketool/pokegra/pokegra/narc_1305.NCGR \
        files/poketool/pokegra/pokegra/narc_1306.NCLR \
        files/poketool/pokegra/pokegra/narc_1307.NCLR \
        files/poketool/pokegra/pokegra/narc_1308.NCGR \
        files/poketool/pokegra/pokegra/narc_1309.NCGR \
        files/poketool/pokegra/pokegra/narc_1310.NCGR \
        files/poketool/pokegra/pokegra/narc_1311.NCGR \
        files/poketool/pokegra/pokegra/narc_1312.NCLR \
        files/poketool/pokegra/pokegra/narc_1313.NCLR \
        files/poketool/pokegra/pokegra/narc_1314.NCGR \
        files/poketool/pokegra/pokegra/narc_1315.NCGR \
        files/poketool/pokegra/pokegra/narc_1316.NCGR \
        files/poketool/pokegra/pokegra/narc_1317.NCGR \
        files/poketool/pokegra/pokegra/narc_1318.NCLR \
        files/poketool/pokegra/pokegra/narc_1319.NCLR \
        files/poketool/pokegra/pokegra/narc_1320.NCGR \
        files/poketool/pokegra/pokegra/narc_1321.NCGR \
        files/poketool/pokegra/pokegra/narc_1322.NCGR \
        files/poketool/pokegra/pokegra/narc_1323.NCGR \
        files/poketool/pokegra/pokegra/narc_1324.NCLR \
        files/poketool/pokegra/pokegra/narc_1325.NCLR \
        files/poketool/pokegra/pokegra/narc_1326.NCGR \
        files/poketool/pokegra/pokegra/narc_1327.NCGR \
        files/poketool/pokegra/pokegra/narc_1328.NCGR \
        files/poketool/pokegra/pokegra/narc_1329.NCGR \
        files/poketool/pokegra/pokegra/narc_1330.NCLR \
        files/poketool/pokegra/pokegra/narc_1331.NCLR \
        files/poketool/pokegra/pokegra/narc_1332.NCGR \
        files/poketool/pokegra/pokegra/narc_1333.NCGR \
        files/poketool/pokegra/pokegra/narc_1334.NCGR \
        files/poketool/pokegra/pokegra/narc_1335.NCGR \
        files/poketool/pokegra/pokegra/narc_1336.NCLR \
        files/poketool/pokegra/pokegra/narc_1337.NCLR \
        files/poketool/pokegra/pokegra/narc_1338.NCGR \
        files/poketool/pokegra/pokegra/narc_1339.NCGR \
        files/poketool/pokegra/pokegra/narc_1340.NCGR \
        files/poketool/pokegra/pokegra/narc_1341.NCGR \
        files/poketool/pokegra/pokegra/narc_1342.NCLR \
        files/poketool/pokegra/pokegra/narc_1343.NCLR \
        files/poketool/pokegra/pokegra/narc_1344.NCGR \
        files/poketool/pokegra/pokegra/narc_1345.NCGR \
        files/poketool/pokegra/pokegra/narc_1346.NCGR \
        files/poketool/pokegra/pokegra/narc_1347.NCGR \
        files/poketool/pokegra/pokegra/narc_1348.NCLR \
        files/poketool/pokegra/pokegra/narc_1349.NCLR \
        files/poketool/pokegra/pokegra/narc_1350.NCGR \
        files/poketool/pokegra/pokegra/narc_1351.NCGR \
        files/poketool/pokegra/pokegra/narc_1352.NCGR \
        files/poketool/pokegra/pokegra/narc_1353.NCGR \
        files/poketool/pokegra/pokegra/narc_1354.NCLR \
        files/poketool/pokegra/pokegra/narc_1355.NCLR \
        files/poketool/pokegra/pokegra/narc_1356.NCGR \
        files/poketool/pokegra/pokegra/narc_1357.NCGR \
        files/poketool/pokegra/pokegra/narc_1358.NCGR \
        files/poketool/pokegra/pokegra/narc_1359.NCGR \
        files/poketool/pokegra/pokegra/narc_1360.NCLR \
        files/poketool/pokegra/pokegra/narc_1361.NCLR \
        files/poketool/pokegra/pokegra/narc_1362.NCGR \
        files/poketool/pokegra/pokegra/narc_1363.NCGR \
        files/poketool/pokegra/pokegra/narc_1364.NCGR \
        files/poketool/pokegra/pokegra/narc_1365.NCGR \
        files/poketool/pokegra/pokegra/narc_1366.NCLR \
        files/poketool/pokegra/pokegra/narc_1367.NCLR \
        files/poketool/pokegra/pokegra/narc_1368.NCGR \
        files/poketool/pokegra/pokegra/narc_1369.NCGR \
        files/poketool/pokegra/pokegra/narc_1370.NCGR \
        files/poketool/pokegra/pokegra/narc_1371.NCGR \
        files/poketool/pokegra/pokegra/narc_1372.NCLR \
        files/poketool/pokegra/pokegra/narc_1373.NCLR \
        files/poketool/pokegra/pokegra/narc_1374.NCGR \
        files/poketool/pokegra/pokegra/narc_1375.NCGR \
        files/poketool/pokegra/pokegra/narc_1376.NCGR \
        files/poketool/pokegra/pokegra/narc_1377.NCGR \
        files/poketool/pokegra/pokegra/narc_1378.NCLR \
        files/poketool/pokegra/pokegra/narc_1379.NCLR \
        files/poketool/pokegra/pokegra/narc_1380.NCGR \
        files/poketool/pokegra/pokegra/narc_1381.NCGR \
        files/poketool/pokegra/pokegra/narc_1382.NCGR \
        files/poketool/pokegra/pokegra/narc_1383.NCGR \
        files/poketool/pokegra/pokegra/narc_1384.NCLR \
        files/poketool/pokegra/pokegra/narc_1385.NCLR \
        files/poketool/pokegra/pokegra/narc_1386.NCGR \
        files/poketool/pokegra/pokegra/narc_1387.NCGR \
        files/poketool/pokegra/pokegra/narc_1388.NCGR \
        files/poketool/pokegra/pokegra/narc_1389.NCGR \
        files/poketool/pokegra/pokegra/narc_1390.NCLR \
        files/poketool/pokegra/pokegra/narc_1391.NCLR \
        files/poketool/pokegra/pokegra/narc_1392.NCGR \
        files/poketool/pokegra/pokegra/narc_1393.NCGR \
        files/poketool/pokegra/pokegra/narc_1394.NCGR \
        files/poketool/pokegra/pokegra/narc_1395.NCGR \
        files/poketool/pokegra/pokegra/narc_1396.NCLR \
        files/poketool/pokegra/pokegra/narc_1397.NCLR \
        files/poketool/pokegra/pokegra/narc_1399.NCGR \
        files/poketool/pokegra/pokegra/narc_1401.NCGR \
        files/poketool/pokegra/pokegra/narc_1402.NCLR \
        files/poketool/pokegra/pokegra/narc_1403.NCLR \
        files/poketool/pokegra/pokegra/narc_1404.NCGR \
        files/poketool/pokegra/pokegra/narc_1405.NCGR \
        files/poketool/pokegra/pokegra/narc_1406.NCGR \
        files/poketool/pokegra/pokegra/narc_1407.NCGR \
        files/poketool/pokegra/pokegra/narc_1408.NCLR \
        files/poketool/pokegra/pokegra/narc_1409.NCLR \
        files/poketool/pokegra/pokegra/narc_1410.NCGR \
        files/poketool/pokegra/pokegra/narc_1411.NCGR \
        files/poketool/pokegra/pokegra/narc_1412.NCGR \
        files/poketool/pokegra/pokegra/narc_1413.NCGR \
        files/poketool/pokegra/pokegra/narc_1414.NCLR \
        files/poketool/pokegra/pokegra/narc_1415.NCLR \
        files/poketool/pokegra/pokegra/narc_1417.NCGR \
        files/poketool/pokegra/pokegra/narc_1419.NCGR \
        files/poketool/pokegra/pokegra/narc_1420.NCLR \
        files/poketool/pokegra/pokegra/narc_1421.NCLR \
        files/poketool/pokegra/pokegra/narc_1423.NCGR \
        files/poketool/pokegra/pokegra/narc_1425.NCGR \
        files/poketool/pokegra/pokegra/narc_1426.NCLR \
        files/poketool/pokegra/pokegra/narc_1427.NCLR \
        files/poketool/pokegra/pokegra/narc_1428.NCGR \
        files/poketool/pokegra/pokegra/narc_1430.NCGR \
        files/poketool/pokegra/pokegra/narc_1432.NCLR \
        files/poketool/pokegra/pokegra/narc_1433.NCLR \
        files/poketool/pokegra/pokegra/narc_1434.NCGR \
        files/poketool/pokegra/pokegra/narc_1435.NCGR \
        files/poketool/pokegra/pokegra/narc_1436.NCGR \
        files/poketool/pokegra/pokegra/narc_1437.NCGR \
        files/poketool/pokegra/pokegra/narc_1438.NCLR \
        files/poketool/pokegra/pokegra/narc_1439.NCLR \
        files/poketool/pokegra/pokegra/narc_1440.NCGR \
        files/poketool/pokegra/pokegra/narc_1441.NCGR \
        files/poketool/pokegra/pokegra/narc_1442.NCGR \
        files/poketool/pokegra/pokegra/narc_1443.NCGR \
        files/poketool/pokegra/pokegra/narc_1444.NCLR \
        files/poketool/pokegra/pokegra/narc_1445.NCLR \
        files/poketool/pokegra/pokegra/narc_1446.NCGR \
        files/poketool/pokegra/pokegra/narc_1448.NCGR \
        files/poketool/pokegra/pokegra/narc_1450.NCLR \
        files/poketool/pokegra/pokegra/narc_1451.NCLR \
        files/poketool/pokegra/pokegra/narc_1452.NCGR \
        files/poketool/pokegra/pokegra/narc_1454.NCGR \
        files/poketool/pokegra/pokegra/narc_1456.NCLR \
        files/poketool/pokegra/pokegra/narc_1457.NCLR \
        files/poketool/pokegra/pokegra/narc_1459.NCGR \
        files/poketool/pokegra/pokegra/narc_1461.NCGR \
        files/poketool/pokegra/pokegra/narc_1462.NCLR \
        files/poketool/pokegra/pokegra/narc_1463.NCLR \
        files/poketool/pokegra/pokegra/narc_1465.NCGR \
        files/poketool/pokegra/pokegra/narc_1467.NCGR \
        files/poketool/pokegra/pokegra/narc_1468.NCLR \
        files/poketool/pokegra/pokegra/narc_1469.NCLR \
        files/poketool/pokegra/pokegra/narc_1471.NCGR \
        files/poketool/pokegra/pokegra/narc_1473.NCGR \
        files/poketool/pokegra/pokegra/narc_1474.NCLR \
        files/poketool/pokegra/pokegra/narc_1475.NCLR \
        files/poketool/pokegra/pokegra/narc_1476.NCGR \
        files/poketool/pokegra/pokegra/narc_1477.NCGR \
        files/poketool/pokegra/pokegra/narc_1478.NCGR \
        files/poketool/pokegra/pokegra/narc_1479.NCGR \
        files/poketool/pokegra/pokegra/narc_1480.NCLR \
        files/poketool/pokegra/pokegra/narc_1481.NCLR \
        files/poketool/pokegra/pokegra/narc_1482.NCGR \
        files/poketool/pokegra/pokegra/narc_1483.NCGR \
        files/poketool/pokegra/pokegra/narc_1484.NCGR \
        files/poketool/pokegra/pokegra/narc_1485.NCGR \
        files/poketool/pokegra/pokegra/narc_1486.NCLR \
        files/poketool/pokegra/pokegra/narc_1487.NCLR \
        files/poketool/pokegra/pokegra/narc_1488.NCGR \
        files/poketool/pokegra/pokegra/narc_1489.NCGR \
        files/poketool/pokegra/pokegra/narc_1490.NCGR \
        files/poketool/pokegra/pokegra/narc_1491.NCGR \
        files/poketool/pokegra/pokegra/narc_1492.NCLR \
        files/poketool/pokegra/pokegra/narc_1493.NCLR \
        files/poketool/pokegra/pokegra/narc_1495.NCGR \
        files/poketool/pokegra/pokegra/narc_1497.NCGR \
        files/poketool/pokegra/pokegra/narc_1498.NCLR \
        files/poketool/pokegra/pokegra/narc_1499.NCLR \
        files/poketool/pokegra/pokegra/narc_1501.NCGR \
        files/poketool/pokegra/pokegra/narc_1503.NCGR \
        files/poketool/pokegra/pokegra/narc_1504.NCLR \
        files/poketool/pokegra/pokegra/narc_1505.NCLR \
        files/poketool/pokegra/pokegra/narc_1507.NCGR \
        files/poketool/pokegra/pokegra/narc_1509.NCGR \
        files/poketool/pokegra/pokegra/narc_1510.NCLR \
        files/poketool/pokegra/pokegra/narc_1511.NCLR \
        files/poketool/pokegra/pokegra/narc_1512.NCGR \
        files/poketool/pokegra/pokegra/narc_1513.NCGR \
        files/poketool/pokegra/pokegra/narc_1514.NCGR \
        files/poketool/pokegra/pokegra/narc_1515.NCGR \
        files/poketool/pokegra/pokegra/narc_1516.NCLR \
        files/poketool/pokegra/pokegra/narc_1517.NCLR \
        files/poketool/pokegra/pokegra/narc_1518.NCGR \
        files/poketool/pokegra/pokegra/narc_1519.NCGR \
        files/poketool/pokegra/pokegra/narc_1520.NCGR \
        files/poketool/pokegra/pokegra/narc_1521.NCGR \
        files/poketool/pokegra/pokegra/narc_1522.NCLR \
        files/poketool/pokegra/pokegra/narc_1523.NCLR \
        files/poketool/pokegra/pokegra/narc_1524.NCGR \
        files/poketool/pokegra/pokegra/narc_1525.NCGR \
        files/poketool/pokegra/pokegra/narc_1526.NCGR \
        files/poketool/pokegra/pokegra/narc_1527.NCGR \
        files/poketool/pokegra/pokegra/narc_1528.NCLR \
        files/poketool/pokegra/pokegra/narc_1529.NCLR \
        files/poketool/pokegra/pokegra/narc_1530.NCGR \
        files/poketool/pokegra/pokegra/narc_1531.NCGR \
        files/poketool/pokegra/pokegra/narc_1532.NCGR \
        files/poketool/pokegra/pokegra/narc_1533.NCGR \
        files/poketool/pokegra/pokegra/narc_1534.NCLR \
        files/poketool/pokegra/pokegra/narc_1535.NCLR \
        files/poketool/pokegra/pokegra/narc_1536.NCGR \
        files/poketool/pokegra/pokegra/narc_1537.NCGR \
        files/poketool/pokegra/pokegra/narc_1538.NCGR \
        files/poketool/pokegra/pokegra/narc_1539.NCGR \
        files/poketool/pokegra/pokegra/narc_1540.NCLR \
        files/poketool/pokegra/pokegra/narc_1541.NCLR \
        files/poketool/pokegra/pokegra/narc_1542.NCGR \
        files/poketool/pokegra/pokegra/narc_1543.NCGR \
        files/poketool/pokegra/pokegra/narc_1544.NCGR \
        files/poketool/pokegra/pokegra/narc_1545.NCGR \
        files/poketool/pokegra/pokegra/narc_1546.NCLR \
        files/poketool/pokegra/pokegra/narc_1547.NCLR \
        files/poketool/pokegra/pokegra/narc_1548.NCGR \
        files/poketool/pokegra/pokegra/narc_1549.NCGR \
        files/poketool/pokegra/pokegra/narc_1550.NCGR \
        files/poketool/pokegra/pokegra/narc_1551.NCGR \
        files/poketool/pokegra/pokegra/narc_1552.NCLR \
        files/poketool/pokegra/pokegra/narc_1553.NCLR \
        files/poketool/pokegra/pokegra/narc_1554.NCGR \
        files/poketool/pokegra/pokegra/narc_1555.NCGR \
        files/poketool/pokegra/pokegra/narc_1556.NCGR \
        files/poketool/pokegra/pokegra/narc_1557.NCGR \
        files/poketool/pokegra/pokegra/narc_1558.NCLR \
        files/poketool/pokegra/pokegra/narc_1559.NCLR \
        files/poketool/pokegra/pokegra/narc_1560.NCGR \
        files/poketool/pokegra/pokegra/narc_1561.NCGR \
        files/poketool/pokegra/pokegra/narc_1562.NCGR \
        files/poketool/pokegra/pokegra/narc_1563.NCGR \
        files/poketool/pokegra/pokegra/narc_1564.NCLR \
        files/poketool/pokegra/pokegra/narc_1565.NCLR \
        files/poketool/pokegra/pokegra/narc_1566.NCGR \
        files/poketool/pokegra/pokegra/narc_1567.NCGR \
        files/poketool/pokegra/pokegra/narc_1568.NCGR \
        files/poketool/pokegra/pokegra/narc_1569.NCGR \
        files/poketool/pokegra/pokegra/narc_1570.NCLR \
        files/poketool/pokegra/pokegra/narc_1571.NCLR \
        files/poketool/pokegra/pokegra/narc_1572.NCGR \
        files/poketool/pokegra/pokegra/narc_1573.NCGR \
        files/poketool/pokegra/pokegra/narc_1574.NCGR \
        files/poketool/pokegra/pokegra/narc_1575.NCGR \
        files/poketool/pokegra/pokegra/narc_1576.NCLR \
        files/poketool/pokegra/pokegra/narc_1577.NCLR \
        files/poketool/pokegra/pokegra/narc_1578.NCGR \
        files/poketool/pokegra/pokegra/narc_1579.NCGR \
        files/poketool/pokegra/pokegra/narc_1580.NCGR \
        files/poketool/pokegra/pokegra/narc_1581.NCGR \
        files/poketool/pokegra/pokegra/narc_1582.NCLR \
        files/poketool/pokegra/pokegra/narc_1583.NCLR \
        files/poketool/pokegra/pokegra/narc_1584.NCGR \
        files/poketool/pokegra/pokegra/narc_1585.NCGR \
        files/poketool/pokegra/pokegra/narc_1586.NCGR \
        files/poketool/pokegra/pokegra/narc_1587.NCGR \
        files/poketool/pokegra/pokegra/narc_1588.NCLR \
        files/poketool/pokegra/pokegra/narc_1589.NCLR \
        files/poketool/pokegra/pokegra/narc_1590.NCGR \
        files/poketool/pokegra/pokegra/narc_1591.NCGR \
        files/poketool/pokegra/pokegra/narc_1592.NCGR \
        files/poketool/pokegra/pokegra/narc_1593.NCGR \
        files/poketool/pokegra/pokegra/narc_1594.NCLR \
        files/poketool/pokegra/pokegra/narc_1595.NCLR \
        files/poketool/pokegra/pokegra/narc_1596.NCGR \
        files/poketool/pokegra/pokegra/narc_1597.NCGR \
        files/poketool/pokegra/pokegra/narc_1598.NCGR \
        files/poketool/pokegra/pokegra/narc_1599.NCGR \
        files/poketool/pokegra/pokegra/narc_1600.NCLR \
        files/poketool/pokegra/pokegra/narc_1601.NCLR \
        files/poketool/pokegra/pokegra/narc_1602.NCGR \
        files/poketool/pokegra/pokegra/narc_1603.NCGR \
        files/poketool/pokegra/pokegra/narc_1604.NCGR \
        files/poketool/pokegra/pokegra/narc_1605.NCGR \
        files/poketool/pokegra/pokegra/narc_1606.NCLR \
        files/poketool/pokegra/pokegra/narc_1607.NCLR \
        files/poketool/pokegra/pokegra/narc_1608.NCGR \
        files/poketool/pokegra/pokegra/narc_1609.NCGR \
        files/poketool/pokegra/pokegra/narc_1610.NCGR \
        files/poketool/pokegra/pokegra/narc_1611.NCGR \
        files/poketool/pokegra/pokegra/narc_1612.NCLR \
        files/poketool/pokegra/pokegra/narc_1613.NCLR \
        files/poketool/pokegra/pokegra/narc_1614.NCGR \
        files/poketool/pokegra/pokegra/narc_1615.NCGR \
        files/poketool/pokegra/pokegra/narc_1616.NCGR \
        files/poketool/pokegra/pokegra/narc_1617.NCGR \
        files/poketool/pokegra/pokegra/narc_1618.NCLR \
        files/poketool/pokegra/pokegra/narc_1619.NCLR \
        files/poketool/pokegra/pokegra/narc_1620.NCGR \
        files/poketool/pokegra/pokegra/narc_1621.NCGR \
        files/poketool/pokegra/pokegra/narc_1622.NCGR \
        files/poketool/pokegra/pokegra/narc_1623.NCGR \
        files/poketool/pokegra/pokegra/narc_1624.NCLR \
        files/poketool/pokegra/pokegra/narc_1625.NCLR \
        files/poketool/pokegra/pokegra/narc_1626.NCGR \
        files/poketool/pokegra/pokegra/narc_1627.NCGR \
        files/poketool/pokegra/pokegra/narc_1628.NCGR \
        files/poketool/pokegra/pokegra/narc_1629.NCGR \
        files/poketool/pokegra/pokegra/narc_1630.NCLR \
        files/poketool/pokegra/pokegra/narc_1631.NCLR \
        files/poketool/pokegra/pokegra/narc_1632.NCGR \
        files/poketool/pokegra/pokegra/narc_1633.NCGR \
        files/poketool/pokegra/pokegra/narc_1634.NCGR \
        files/poketool/pokegra/pokegra/narc_1635.NCGR \
        files/poketool/pokegra/pokegra/narc_1636.NCLR \
        files/poketool/pokegra/pokegra/narc_1637.NCLR \
        files/poketool/pokegra/pokegra/narc_1638.NCGR \
        files/poketool/pokegra/pokegra/narc_1639.NCGR \
        files/poketool/pokegra/pokegra/narc_1640.NCGR \
        files/poketool/pokegra/pokegra/narc_1641.NCGR \
        files/poketool/pokegra/pokegra/narc_1642.NCLR \
        files/poketool/pokegra/pokegra/narc_1643.NCLR \
        files/poketool/pokegra/pokegra/narc_1644.NCGR \
        files/poketool/pokegra/pokegra/narc_1645.NCGR \
        files/poketool/pokegra/pokegra/narc_1646.NCGR \
        files/poketool/pokegra/pokegra/narc_1647.NCGR \
        files/poketool/pokegra/pokegra/narc_1648.NCLR \
        files/poketool/pokegra/pokegra/narc_1649.NCLR \
        files/poketool/pokegra/pokegra/narc_1650.NCGR \
        files/poketool/pokegra/pokegra/narc_1651.NCGR \
        files/poketool/pokegra/pokegra/narc_1652.NCGR \
        files/poketool/pokegra/pokegra/narc_1653.NCGR \
        files/poketool/pokegra/pokegra/narc_1654.NCLR \
        files/poketool/pokegra/pokegra/narc_1655.NCLR \
        files/poketool/pokegra/pokegra/narc_1656.NCGR \
        files/poketool/pokegra/pokegra/narc_1657.NCGR \
        files/poketool/pokegra/pokegra/narc_1658.NCGR \
        files/poketool/pokegra/pokegra/narc_1659.NCGR \
        files/poketool/pokegra/pokegra/narc_1660.NCLR \
        files/poketool/pokegra/pokegra/narc_1661.NCLR \
        files/poketool/pokegra/pokegra/narc_1662.NCGR \
        files/poketool/pokegra/pokegra/narc_1663.NCGR \
        files/poketool/pokegra/pokegra/narc_1664.NCGR \
        files/poketool/pokegra/pokegra/narc_1665.NCGR \
        files/poketool/pokegra/pokegra/narc_1666.NCLR \
        files/poketool/pokegra/pokegra/narc_1667.NCLR \
        files/poketool/pokegra/pokegra/narc_1668.NCGR \
        files/poketool/pokegra/pokegra/narc_1669.NCGR \
        files/poketool/pokegra/pokegra/narc_1670.NCGR \
        files/poketool/pokegra/pokegra/narc_1671.NCGR \
        files/poketool/pokegra/pokegra/narc_1672.NCLR \
        files/poketool/pokegra/pokegra/narc_1673.NCLR \
        files/poketool/pokegra/pokegra/narc_1674.NCGR \
        files/poketool/pokegra/pokegra/narc_1675.NCGR \
        files/poketool/pokegra/pokegra/narc_1676.NCGR \
        files/poketool/pokegra/pokegra/narc_1677.NCGR \
        files/poketool/pokegra/pokegra/narc_1678.NCLR \
        files/poketool/pokegra/pokegra/narc_1679.NCLR \
        files/poketool/pokegra/pokegra/narc_1680.NCGR \
        files/poketool/pokegra/pokegra/narc_1681.NCGR \
        files/poketool/pokegra/pokegra/narc_1682.NCGR \
        files/poketool/pokegra/pokegra/narc_1683.NCGR \
        files/poketool/pokegra/pokegra/narc_1684.NCLR \
        files/poketool/pokegra/pokegra/narc_1685.NCLR \
        files/poketool/pokegra/pokegra/narc_1686.NCGR \
        files/poketool/pokegra/pokegra/narc_1687.NCGR \
        files/poketool/pokegra/pokegra/narc_1688.NCGR \
        files/poketool/pokegra/pokegra/narc_1689.NCGR \
        files/poketool/pokegra/pokegra/narc_1690.NCLR \
        files/poketool/pokegra/pokegra/narc_1691.NCLR \
        files/poketool/pokegra/pokegra/narc_1692.NCGR \
        files/poketool/pokegra/pokegra/narc_1693.NCGR \
        files/poketool/pokegra/pokegra/narc_1694.NCGR \
        files/poketool/pokegra/pokegra/narc_1695.NCGR \
        files/poketool/pokegra/pokegra/narc_1696.NCLR \
        files/poketool/pokegra/pokegra/narc_1697.NCLR \
        files/poketool/pokegra/pokegra/narc_1698.NCGR \
        files/poketool/pokegra/pokegra/narc_1699.NCGR \
        files/poketool/pokegra/pokegra/narc_1700.NCGR \
        files/poketool/pokegra/pokegra/narc_1701.NCGR \
        files/poketool/pokegra/pokegra/narc_1702.NCLR \
        files/poketool/pokegra/pokegra/narc_1703.NCLR \
        files/poketool/pokegra/pokegra/narc_1704.NCGR \
        files/poketool/pokegra/pokegra/narc_1705.NCGR \
        files/poketool/pokegra/pokegra/narc_1706.NCGR \
        files/poketool/pokegra/pokegra/narc_1707.NCGR \
        files/poketool/pokegra/pokegra/narc_1708.NCLR \
        files/poketool/pokegra/pokegra/narc_1709.NCLR \
        files/poketool/pokegra/pokegra/narc_1710.NCGR \
        files/poketool/pokegra/pokegra/narc_1711.NCGR \
        files/poketool/pokegra/pokegra/narc_1712.NCGR \
        files/poketool/pokegra/pokegra/narc_1713.NCGR \
        files/poketool/pokegra/pokegra/narc_1714.NCLR \
        files/poketool/pokegra/pokegra/narc_1715.NCLR \
        files/poketool/pokegra/pokegra/narc_1716.NCGR \
        files/poketool/pokegra/pokegra/narc_1717.NCGR \
        files/poketool/pokegra/pokegra/narc_1718.NCGR \
        files/poketool/pokegra/pokegra/narc_1719.NCGR \
        files/poketool/pokegra/pokegra/narc_1720.NCLR \
        files/poketool/pokegra/pokegra/narc_1721.NCLR \
        files/poketool/pokegra/pokegra/narc_1722.NCGR \
        files/poketool/pokegra/pokegra/narc_1723.NCGR \
        files/poketool/pokegra/pokegra/narc_1724.NCGR \
        files/poketool/pokegra/pokegra/narc_1725.NCGR \
        files/poketool/pokegra/pokegra/narc_1726.NCLR \
        files/poketool/pokegra/pokegra/narc_1727.NCLR \
        files/poketool/pokegra/pokegra/narc_1728.NCGR \
        files/poketool/pokegra/pokegra/narc_1729.NCGR \
        files/poketool/pokegra/pokegra/narc_1730.NCGR \
        files/poketool/pokegra/pokegra/narc_1731.NCGR \
        files/poketool/pokegra/pokegra/narc_1732.NCLR \
        files/poketool/pokegra/pokegra/narc_1733.NCLR \
        files/poketool/pokegra/pokegra/narc_1734.NCGR \
        files/poketool/pokegra/pokegra/narc_1735.NCGR \
        files/poketool/pokegra/pokegra/narc_1736.NCGR \
        files/poketool/pokegra/pokegra/narc_1737.NCGR \
        files/poketool/pokegra/pokegra/narc_1738.NCLR \
        files/poketool/pokegra/pokegra/narc_1739.NCLR \
        files/poketool/pokegra/pokegra/narc_1740.NCGR \
        files/poketool/pokegra/pokegra/narc_1741.NCGR \
        files/poketool/pokegra/pokegra/narc_1742.NCGR \
        files/poketool/pokegra/pokegra/narc_1743.NCGR \
        files/poketool/pokegra/pokegra/narc_1744.NCLR \
        files/poketool/pokegra/pokegra/narc_1745.NCLR \
        files/poketool/pokegra/pokegra/narc_1746.NCGR \
        files/poketool/pokegra/pokegra/narc_1747.NCGR \
        files/poketool/pokegra/pokegra/narc_1748.NCGR \
        files/poketool/pokegra/pokegra/narc_1749.NCGR \
        files/poketool/pokegra/pokegra/narc_1750.NCLR \
        files/poketool/pokegra/pokegra/narc_1751.NCLR \
        files/poketool/pokegra/pokegra/narc_1753.NCGR \
        files/poketool/pokegra/pokegra/narc_1755.NCGR \
        files/poketool/pokegra/pokegra/narc_1756.NCLR \
        files/poketool/pokegra/pokegra/narc_1757.NCLR \
        files/poketool/pokegra/pokegra/narc_1758.NCGR \
        files/poketool/pokegra/pokegra/narc_1759.NCGR \
        files/poketool/pokegra/pokegra/narc_1760.NCGR \
        files/poketool/pokegra/pokegra/narc_1761.NCGR \
        files/poketool/pokegra/pokegra/narc_1762.NCLR \
        files/poketool/pokegra/pokegra/narc_1763.NCLR \
        files/poketool/pokegra/pokegra/narc_1764.NCGR \
        files/poketool/pokegra/pokegra/narc_1765.NCGR \
        files/poketool/pokegra/pokegra/narc_1766.NCGR \
        files/poketool/pokegra/pokegra/narc_1767.NCGR \
        files/poketool/pokegra/pokegra/narc_1768.NCLR \
        files/poketool/pokegra/pokegra/narc_1769.NCLR \
        files/poketool/pokegra/pokegra/narc_1770.NCGR \
        files/poketool/pokegra/pokegra/narc_1771.NCGR \
        files/poketool/pokegra/pokegra/narc_1772.NCGR \
        files/poketool/pokegra/pokegra/narc_1773.NCGR \
        files/poketool/pokegra/pokegra/narc_1774.NCLR \
        files/poketool/pokegra/pokegra/narc_1775.NCLR \
        files/poketool/pokegra/pokegra/narc_1776.NCGR \
        files/poketool/pokegra/pokegra/narc_1777.NCGR \
        files/poketool/pokegra/pokegra/narc_1778.NCGR \
        files/poketool/pokegra/pokegra/narc_1779.NCGR \
        files/poketool/pokegra/pokegra/narc_1780.NCLR \
        files/poketool/pokegra/pokegra/narc_1781.NCLR \
        files/poketool/pokegra/pokegra/narc_1782.NCGR \
        files/poketool/pokegra/pokegra/narc_1783.NCGR \
        files/poketool/pokegra/pokegra/narc_1784.NCGR \
        files/poketool/pokegra/pokegra/narc_1785.NCGR \
        files/poketool/pokegra/pokegra/narc_1786.NCLR \
        files/poketool/pokegra/pokegra/narc_1787.NCLR \
        files/poketool/pokegra/pokegra/narc_1788.NCGR \
        files/poketool/pokegra/pokegra/narc_1789.NCGR \
        files/poketool/pokegra/pokegra/narc_1790.NCGR \
        files/poketool/pokegra/pokegra/narc_1791.NCGR \
        files/poketool/pokegra/pokegra/narc_1792.NCLR \
        files/poketool/pokegra/pokegra/narc_1793.NCLR \
        files/poketool/pokegra/pokegra/narc_1794.NCGR \
        files/poketool/pokegra/pokegra/narc_1795.NCGR \
        files/poketool/pokegra/pokegra/narc_1796.NCGR \
        files/poketool/pokegra/pokegra/narc_1797.NCGR \
        files/poketool/pokegra/pokegra/narc_1798.NCLR \
        files/poketool/pokegra/pokegra/narc_1799.NCLR \
        files/poketool/pokegra/pokegra/narc_1800.NCGR \
        files/poketool/pokegra/pokegra/narc_1801.NCGR \
        files/poketool/pokegra/pokegra/narc_1802.NCGR \
        files/poketool/pokegra/pokegra/narc_1803.NCGR \
        files/poketool/pokegra/pokegra/narc_1804.NCLR \
        files/poketool/pokegra/pokegra/narc_1805.NCLR \
        files/poketool/pokegra/pokegra/narc_1806.NCGR \
        files/poketool/pokegra/pokegra/narc_1807.NCGR \
        files/poketool/pokegra/pokegra/narc_1808.NCGR \
        files/poketool/pokegra/pokegra/narc_1809.NCGR \
        files/poketool/pokegra/pokegra/narc_1810.NCLR \
        files/poketool/pokegra/pokegra/narc_1811.NCLR \
        files/poketool/pokegra/pokegra/narc_1812.NCGR \
        files/poketool/pokegra/pokegra/narc_1813.NCGR \
        files/poketool/pokegra/pokegra/narc_1814.NCGR \
        files/poketool/pokegra/pokegra/narc_1815.NCGR \
        files/poketool/pokegra/pokegra/narc_1816.NCLR \
        files/poketool/pokegra/pokegra/narc_1817.NCLR \
        files/poketool/pokegra/pokegra/narc_1818.NCGR \
        files/poketool/pokegra/pokegra/narc_1819.NCGR \
        files/poketool/pokegra/pokegra/narc_1820.NCGR \
        files/poketool/pokegra/pokegra/narc_1821.NCGR \
        files/poketool/pokegra/pokegra/narc_1822.NCLR \
        files/poketool/pokegra/pokegra/narc_1823.NCLR \
        files/poketool/pokegra/pokegra/narc_1824.NCGR \
        files/poketool/pokegra/pokegra/narc_1825.NCGR \
        files/poketool/pokegra/pokegra/narc_1826.NCGR \
        files/poketool/pokegra/pokegra/narc_1827.NCGR \
        files/poketool/pokegra/pokegra/narc_1828.NCLR \
        files/poketool/pokegra/pokegra/narc_1829.NCLR \
        files/poketool/pokegra/pokegra/narc_1830.NCGR \
        files/poketool/pokegra/pokegra/narc_1831.NCGR \
        files/poketool/pokegra/pokegra/narc_1832.NCGR \
        files/poketool/pokegra/pokegra/narc_1833.NCGR \
        files/poketool/pokegra/pokegra/narc_1834.NCLR \
        files/poketool/pokegra/pokegra/narc_1835.NCLR \
        files/poketool/pokegra/pokegra/narc_1836.NCGR \
        files/poketool/pokegra/pokegra/narc_1837.NCGR \
        files/poketool/pokegra/pokegra/narc_1838.NCGR \
        files/poketool/pokegra/pokegra/narc_1839.NCGR \
        files/poketool/pokegra/pokegra/narc_1840.NCLR \
        files/poketool/pokegra/pokegra/narc_1841.NCLR \
        files/poketool/pokegra/pokegra/narc_1842.NCGR \
        files/poketool/pokegra/pokegra/narc_1843.NCGR \
        files/poketool/pokegra/pokegra/narc_1844.NCGR \
        files/poketool/pokegra/pokegra/narc_1845.NCGR \
        files/poketool/pokegra/pokegra/narc_1846.NCLR \
        files/poketool/pokegra/pokegra/narc_1847.NCLR \
        files/poketool/pokegra/pokegra/narc_1848.NCGR \
        files/poketool/pokegra/pokegra/narc_1849.NCGR \
        files/poketool/pokegra/pokegra/narc_1850.NCGR \
        files/poketool/pokegra/pokegra/narc_1851.NCGR \
        files/poketool/pokegra/pokegra/narc_1852.NCLR \
        files/poketool/pokegra/pokegra/narc_1853.NCLR \
        files/poketool/pokegra/pokegra/narc_1854.NCGR \
        files/poketool/pokegra/pokegra/narc_1855.NCGR \
        files/poketool/pokegra/pokegra/narc_1856.NCGR \
        files/poketool/pokegra/pokegra/narc_1857.NCGR \
        files/poketool/pokegra/pokegra/narc_1858.NCLR \
        files/poketool/pokegra/pokegra/narc_1859.NCLR \
        files/poketool/pokegra/pokegra/narc_1860.NCGR \
        files/poketool/pokegra/pokegra/narc_1861.NCGR \
        files/poketool/pokegra/pokegra/narc_1862.NCGR \
        files/poketool/pokegra/pokegra/narc_1863.NCGR \
        files/poketool/pokegra/pokegra/narc_1864.NCLR \
        files/poketool/pokegra/pokegra/narc_1865.NCLR \
        files/poketool/pokegra/pokegra/narc_1866.NCGR \
        files/poketool/pokegra/pokegra/narc_1867.NCGR \
        files/poketool/pokegra/pokegra/narc_1868.NCGR \
        files/poketool/pokegra/pokegra/narc_1869.NCGR \
        files/poketool/pokegra/pokegra/narc_1870.NCLR \
        files/poketool/pokegra/pokegra/narc_1871.NCLR \
        files/poketool/pokegra/pokegra/narc_1872.NCGR \
        files/poketool/pokegra/pokegra/narc_1873.NCGR \
        files/poketool/pokegra/pokegra/narc_1874.NCGR \
        files/poketool/pokegra/pokegra/narc_1875.NCGR \
        files/poketool/pokegra/pokegra/narc_1876.NCLR \
        files/poketool/pokegra/pokegra/narc_1877.NCLR \
        files/poketool/pokegra/pokegra/narc_1879.NCGR \
        files/poketool/pokegra/pokegra/narc_1881.NCGR \
        files/poketool/pokegra/pokegra/narc_1882.NCLR \
        files/poketool/pokegra/pokegra/narc_1883.NCLR \
        files/poketool/pokegra/pokegra/narc_1884.NCGR \
        files/poketool/pokegra/pokegra/narc_1886.NCGR \
        files/poketool/pokegra/pokegra/narc_1888.NCLR \
        files/poketool/pokegra/pokegra/narc_1889.NCLR \
        files/poketool/pokegra/pokegra/narc_1890.NCGR \
        files/poketool/pokegra/pokegra/narc_1891.NCGR \
        files/poketool/pokegra/pokegra/narc_1892.NCGR \
        files/poketool/pokegra/pokegra/narc_1893.NCGR \
        files/poketool/pokegra/pokegra/narc_1894.NCLR \
        files/poketool/pokegra/pokegra/narc_1895.NCLR \
        files/poketool/pokegra/pokegra/narc_1896.NCGR \
        files/poketool/pokegra/pokegra/narc_1897.NCGR \
        files/poketool/pokegra/pokegra/narc_1898.NCGR \
        files/poketool/pokegra/pokegra/narc_1899.NCGR \
        files/poketool/pokegra/pokegra/narc_1900.NCLR \
        files/poketool/pokegra/pokegra/narc_1901.NCLR \
        files/poketool/pokegra/pokegra/narc_1902.NCGR \
        files/poketool/pokegra/pokegra/narc_1903.NCGR \
        files/poketool/pokegra/pokegra/narc_1904.NCGR \
        files/poketool/pokegra/pokegra/narc_1905.NCGR \
        files/poketool/pokegra/pokegra/narc_1906.NCLR \
        files/poketool/pokegra/pokegra/narc_1907.NCLR \
        files/poketool/pokegra/pokegra/narc_1908.NCGR \
        files/poketool/pokegra/pokegra/narc_1909.NCGR \
        files/poketool/pokegra/pokegra/narc_1910.NCGR \
        files/poketool/pokegra/pokegra/narc_1911.NCGR \
        files/poketool/pokegra/pokegra/narc_1912.NCLR \
        files/poketool/pokegra/pokegra/narc_1913.NCLR \
        files/poketool/pokegra/pokegra/narc_1914.NCGR \
        files/poketool/pokegra/pokegra/narc_1915.NCGR \
        files/poketool/pokegra/pokegra/narc_1916.NCGR \
        files/poketool/pokegra/pokegra/narc_1917.NCGR \
        files/poketool/pokegra/pokegra/narc_1918.NCLR \
        files/poketool/pokegra/pokegra/narc_1919.NCLR \
        files/poketool/pokegra/pokegra/narc_1920.NCGR \
        files/poketool/pokegra/pokegra/narc_1921.NCGR \
        files/poketool/pokegra/pokegra/narc_1922.NCGR \
        files/poketool/pokegra/pokegra/narc_1923.NCGR \
        files/poketool/pokegra/pokegra/narc_1924.NCLR \
        files/poketool/pokegra/pokegra/narc_1925.NCLR \
        files/poketool/pokegra/pokegra/narc_1926.NCGR \
        files/poketool/pokegra/pokegra/narc_1927.NCGR \
        files/poketool/pokegra/pokegra/narc_1928.NCGR \
        files/poketool/pokegra/pokegra/narc_1929.NCGR \
        files/poketool/pokegra/pokegra/narc_1930.NCLR \
        files/poketool/pokegra/pokegra/narc_1931.NCLR \
        files/poketool/pokegra/pokegra/narc_1932.NCGR \
        files/poketool/pokegra/pokegra/narc_1933.NCGR \
        files/poketool/pokegra/pokegra/narc_1934.NCGR \
        files/poketool/pokegra/pokegra/narc_1935.NCGR \
        files/poketool/pokegra/pokegra/narc_1936.NCLR \
        files/poketool/pokegra/pokegra/narc_1937.NCLR \
        files/poketool/pokegra/pokegra/narc_1938.NCGR \
        files/poketool/pokegra/pokegra/narc_1939.NCGR \
        files/poketool/pokegra/pokegra/narc_1940.NCGR \
        files/poketool/pokegra/pokegra/narc_1941.NCGR \
        files/poketool/pokegra/pokegra/narc_1942.NCLR \
        files/poketool/pokegra/pokegra/narc_1943.NCLR \
        files/poketool/pokegra/pokegra/narc_1944.NCGR \
        files/poketool/pokegra/pokegra/narc_1945.NCGR \
        files/poketool/pokegra/pokegra/narc_1946.NCGR \
        files/poketool/pokegra/pokegra/narc_1947.NCGR \
        files/poketool/pokegra/pokegra/narc_1948.NCLR \
        files/poketool/pokegra/pokegra/narc_1949.NCLR \
        files/poketool/pokegra/pokegra/narc_1950.NCGR \
        files/poketool/pokegra/pokegra/narc_1951.NCGR \
        files/poketool/pokegra/pokegra/narc_1952.NCGR \
        files/poketool/pokegra/pokegra/narc_1953.NCGR \
        files/poketool/pokegra/pokegra/narc_1954.NCLR \
        files/poketool/pokegra/pokegra/narc_1955.NCLR \
        files/poketool/pokegra/pokegra/narc_1956.NCGR \
        files/poketool/pokegra/pokegra/narc_1957.NCGR \
        files/poketool/pokegra/pokegra/narc_1958.NCGR \
        files/poketool/pokegra/pokegra/narc_1959.NCGR \
        files/poketool/pokegra/pokegra/narc_1960.NCLR \
        files/poketool/pokegra/pokegra/narc_1961.NCLR \
        files/poketool/pokegra/pokegra/narc_1962.NCGR \
        files/poketool/pokegra/pokegra/narc_1963.NCGR \
        files/poketool/pokegra/pokegra/narc_1964.NCGR \
        files/poketool/pokegra/pokegra/narc_1965.NCGR \
        files/poketool/pokegra/pokegra/narc_1966.NCLR \
        files/poketool/pokegra/pokegra/narc_1967.NCLR \
        files/poketool/pokegra/pokegra/narc_1968.NCGR \
        files/poketool/pokegra/pokegra/narc_1969.NCGR \
        files/poketool/pokegra/pokegra/narc_1970.NCGR \
        files/poketool/pokegra/pokegra/narc_1971.NCGR \
        files/poketool/pokegra/pokegra/narc_1972.NCLR \
        files/poketool/pokegra/pokegra/narc_1973.NCLR \
        files/poketool/pokegra/pokegra/narc_1974.NCGR \
        files/poketool/pokegra/pokegra/narc_1975.NCGR \
        files/poketool/pokegra/pokegra/narc_1976.NCGR \
        files/poketool/pokegra/pokegra/narc_1977.NCGR \
        files/poketool/pokegra/pokegra/narc_1978.NCLR \
        files/poketool/pokegra/pokegra/narc_1979.NCLR \
        files/poketool/pokegra/pokegra/narc_1980.NCGR \
        files/poketool/pokegra/pokegra/narc_1981.NCGR \
        files/poketool/pokegra/pokegra/narc_1982.NCGR \
        files/poketool/pokegra/pokegra/narc_1983.NCGR \
        files/poketool/pokegra/pokegra/narc_1984.NCLR \
        files/poketool/pokegra/pokegra/narc_1985.NCLR \
        files/poketool/pokegra/pokegra/narc_1986.NCGR \
        files/poketool/pokegra/pokegra/narc_1987.NCGR \
        files/poketool/pokegra/pokegra/narc_1988.NCGR \
        files/poketool/pokegra/pokegra/narc_1989.NCGR \
        files/poketool/pokegra/pokegra/narc_1990.NCLR \
        files/poketool/pokegra/pokegra/narc_1991.NCLR \
        files/poketool/pokegra/pokegra/narc_1992.NCGR \
        files/poketool/pokegra/pokegra/narc_1993.NCGR \
        files/poketool/pokegra/pokegra/narc_1994.NCGR \
        files/poketool/pokegra/pokegra/narc_1995.NCGR \
        files/poketool/pokegra/pokegra/narc_1996.NCLR \
        files/poketool/pokegra/pokegra/narc_1997.NCLR \
        files/poketool/pokegra/pokegra/narc_1998.NCGR \
        files/poketool/pokegra/pokegra/narc_1999.NCGR \
        files/poketool/pokegra/pokegra/narc_2000.NCGR \
        files/poketool/pokegra/pokegra/narc_2001.NCGR \
        files/poketool/pokegra/pokegra/narc_2002.NCLR \
        files/poketool/pokegra/pokegra/narc_2003.NCLR \
        files/poketool/pokegra/pokegra/narc_2004.NCGR \
        files/poketool/pokegra/pokegra/narc_2005.NCGR \
        files/poketool/pokegra/pokegra/narc_2006.NCGR \
        files/poketool/pokegra/pokegra/narc_2007.NCGR \
        files/poketool/pokegra/pokegra/narc_2008.NCLR \
        files/poketool/pokegra/pokegra/narc_2009.NCLR \
        files/poketool/pokegra/pokegra/narc_2010.NCGR \
        files/poketool/pokegra/pokegra/narc_2011.NCGR \
        files/poketool/pokegra/pokegra/narc_2012.NCGR \
        files/poketool/pokegra/pokegra/narc_2013.NCGR \
        files/poketool/pokegra/pokegra/narc_2014.NCLR \
        files/poketool/pokegra/pokegra/narc_2015.NCLR \
        files/poketool/pokegra/pokegra/narc_2016.NCGR \
        files/poketool/pokegra/pokegra/narc_2017.NCGR \
        files/poketool/pokegra/pokegra/narc_2018.NCGR \
        files/poketool/pokegra/pokegra/narc_2019.NCGR \
        files/poketool/pokegra/pokegra/narc_2020.NCLR \
        files/poketool/pokegra/pokegra/narc_2021.NCLR \
        files/poketool/pokegra/pokegra/narc_2023.NCGR \
        files/poketool/pokegra/pokegra/narc_2025.NCGR \
        files/poketool/pokegra/pokegra/narc_2026.NCLR \
        files/poketool/pokegra/pokegra/narc_2027.NCLR \
        files/poketool/pokegra/pokegra/narc_2029.NCGR \
        files/poketool/pokegra/pokegra/narc_2031.NCGR \
        files/poketool/pokegra/pokegra/narc_2032.NCLR \
        files/poketool/pokegra/pokegra/narc_2033.NCLR \
        files/poketool/pokegra/pokegra/narc_2034.NCGR \
        files/poketool/pokegra/pokegra/narc_2035.NCGR \
        files/poketool/pokegra/pokegra/narc_2036.NCGR \
        files/poketool/pokegra/pokegra/narc_2037.NCGR \
        files/poketool/pokegra/pokegra/narc_2038.NCLR \
        files/poketool/pokegra/pokegra/narc_2039.NCLR \
        files/poketool/pokegra/pokegra/narc_2040.NCGR \
        files/poketool/pokegra/pokegra/narc_2041.NCGR \
        files/poketool/pokegra/pokegra/narc_2042.NCGR \
        files/poketool/pokegra/pokegra/narc_2043.NCGR \
        files/poketool/pokegra/pokegra/narc_2044.NCLR \
        files/poketool/pokegra/pokegra/narc_2045.NCLR \
        files/poketool/pokegra/pokegra/narc_2046.NCGR \
        files/poketool/pokegra/pokegra/narc_2047.NCGR \
        files/poketool/pokegra/pokegra/narc_2048.NCGR \
        files/poketool/pokegra/pokegra/narc_2049.NCGR \
        files/poketool/pokegra/pokegra/narc_2050.NCLR \
        files/poketool/pokegra/pokegra/narc_2051.NCLR \
        files/poketool/pokegra/pokegra/narc_2052.NCGR \
        files/poketool/pokegra/pokegra/narc_2053.NCGR \
        files/poketool/pokegra/pokegra/narc_2054.NCGR \
        files/poketool/pokegra/pokegra/narc_2055.NCGR \
        files/poketool/pokegra/pokegra/narc_2056.NCLR \
        files/poketool/pokegra/pokegra/narc_2057.NCLR \
        files/poketool/pokegra/pokegra/narc_2059.NCGR \
        files/poketool/pokegra/pokegra/narc_2061.NCGR \
        files/poketool/pokegra/pokegra/narc_2062.NCLR \
        files/poketool/pokegra/pokegra/narc_2063.NCLR \
        files/poketool/pokegra/pokegra/narc_2065.NCGR \
        files/poketool/pokegra/pokegra/narc_2067.NCGR \
        files/poketool/pokegra/pokegra/narc_2068.NCLR \
        files/poketool/pokegra/pokegra/narc_2069.NCLR \
        files/poketool/pokegra/pokegra/narc_2070.NCGR \
        files/poketool/pokegra/pokegra/narc_2071.NCGR \
        files/poketool/pokegra/pokegra/narc_2072.NCGR \
        files/poketool/pokegra/pokegra/narc_2073.NCGR \
        files/poketool/pokegra/pokegra/narc_2074.NCLR \
        files/poketool/pokegra/pokegra/narc_2075.NCLR \
        files/poketool/pokegra/pokegra/narc_2076.NCGR \
        files/poketool/pokegra/pokegra/narc_2077.NCGR \
        files/poketool/pokegra/pokegra/narc_2078.NCGR \
        files/poketool/pokegra/pokegra/narc_2079.NCGR \
        files/poketool/pokegra/pokegra/narc_2080.NCLR \
        files/poketool/pokegra/pokegra/narc_2081.NCLR \
        files/poketool/pokegra/pokegra/narc_2082.NCGR \
        files/poketool/pokegra/pokegra/narc_2083.NCGR \
        files/poketool/pokegra/pokegra/narc_2084.NCGR \
        files/poketool/pokegra/pokegra/narc_2085.NCGR \
        files/poketool/pokegra/pokegra/narc_2086.NCLR \
        files/poketool/pokegra/pokegra/narc_2087.NCLR \
        files/poketool/pokegra/pokegra/narc_2088.NCGR \
        files/poketool/pokegra/pokegra/narc_2089.NCGR \
        files/poketool/pokegra/pokegra/narc_2090.NCGR \
        files/poketool/pokegra/pokegra/narc_2091.NCGR \
        files/poketool/pokegra/pokegra/narc_2092.NCLR \
        files/poketool/pokegra/pokegra/narc_2093.NCLR \
        files/poketool/pokegra/pokegra/narc_2094.NCGR \
        files/poketool/pokegra/pokegra/narc_2095.NCGR \
        files/poketool/pokegra/pokegra/narc_2096.NCGR \
        files/poketool/pokegra/pokegra/narc_2097.NCGR \
        files/poketool/pokegra/pokegra/narc_2098.NCLR \
        files/poketool/pokegra/pokegra/narc_2099.NCLR \
        files/poketool/pokegra/pokegra/narc_2100.NCGR \
        files/poketool/pokegra/pokegra/narc_2101.NCGR \
        files/poketool/pokegra/pokegra/narc_2102.NCGR \
        files/poketool/pokegra/pokegra/narc_2103.NCGR \
        files/poketool/pokegra/pokegra/narc_2104.NCLR \
        files/poketool/pokegra/pokegra/narc_2105.NCLR \
        files/poketool/pokegra/pokegra/narc_2106.NCGR \
        files/poketool/pokegra/pokegra/narc_2107.NCGR \
        files/poketool/pokegra/pokegra/narc_2108.NCGR \
        files/poketool/pokegra/pokegra/narc_2109.NCGR \
        files/poketool/pokegra/pokegra/narc_2110.NCLR \
        files/poketool/pokegra/pokegra/narc_2111.NCLR \
        files/poketool/pokegra/pokegra/narc_2112.NCGR \
        files/poketool/pokegra/pokegra/narc_2113.NCGR \
        files/poketool/pokegra/pokegra/narc_2114.NCGR \
        files/poketool/pokegra/pokegra/narc_2115.NCGR \
        files/poketool/pokegra/pokegra/narc_2116.NCLR \
        files/poketool/pokegra/pokegra/narc_2117.NCLR \
        files/poketool/pokegra/pokegra/narc_2118.NCGR \
        files/poketool/pokegra/pokegra/narc_2119.NCGR \
        files/poketool/pokegra/pokegra/narc_2120.NCGR \
        files/poketool/pokegra/pokegra/narc_2121.NCGR \
        files/poketool/pokegra/pokegra/narc_2122.NCLR \
        files/poketool/pokegra/pokegra/narc_2123.NCLR \
        files/poketool/pokegra/pokegra/narc_2124.NCGR \
        files/poketool/pokegra/pokegra/narc_2125.NCGR \
        files/poketool/pokegra/pokegra/narc_2126.NCGR \
        files/poketool/pokegra/pokegra/narc_2127.NCGR \
        files/poketool/pokegra/pokegra/narc_2128.NCLR \
        files/poketool/pokegra/pokegra/narc_2129.NCLR \
        files/poketool/pokegra/pokegra/narc_2130.NCGR \
        files/poketool/pokegra/pokegra/narc_2131.NCGR \
        files/poketool/pokegra/pokegra/narc_2132.NCGR \
        files/poketool/pokegra/pokegra/narc_2133.NCGR \
        files/poketool/pokegra/pokegra/narc_2134.NCLR \
        files/poketool/pokegra/pokegra/narc_2135.NCLR \
        files/poketool/pokegra/pokegra/narc_2136.NCGR \
        files/poketool/pokegra/pokegra/narc_2137.NCGR \
        files/poketool/pokegra/pokegra/narc_2138.NCGR \
        files/poketool/pokegra/pokegra/narc_2139.NCGR \
        files/poketool/pokegra/pokegra/narc_2140.NCLR \
        files/poketool/pokegra/pokegra/narc_2141.NCLR \
        files/poketool/pokegra/pokegra/narc_2142.NCGR \
        files/poketool/pokegra/pokegra/narc_2143.NCGR \
        files/poketool/pokegra/pokegra/narc_2144.NCGR \
        files/poketool/pokegra/pokegra/narc_2145.NCGR \
        files/poketool/pokegra/pokegra/narc_2146.NCLR \
        files/poketool/pokegra/pokegra/narc_2147.NCLR \
        files/poketool/pokegra/pokegra/narc_2148.NCGR \
        files/poketool/pokegra/pokegra/narc_2149.NCGR \
        files/poketool/pokegra/pokegra/narc_2150.NCGR \
        files/poketool/pokegra/pokegra/narc_2151.NCGR \
        files/poketool/pokegra/pokegra/narc_2152.NCLR \
        files/poketool/pokegra/pokegra/narc_2153.NCLR \
        files/poketool/pokegra/pokegra/narc_2154.NCGR \
        files/poketool/pokegra/pokegra/narc_2155.NCGR \
        files/poketool/pokegra/pokegra/narc_2156.NCGR \
        files/poketool/pokegra/pokegra/narc_2157.NCGR \
        files/poketool/pokegra/pokegra/narc_2158.NCLR \
        files/poketool/pokegra/pokegra/narc_2159.NCLR \
        files/poketool/pokegra/pokegra/narc_2160.NCGR \
        files/poketool/pokegra/pokegra/narc_2161.NCGR \
        files/poketool/pokegra/pokegra/narc_2162.NCGR \
        files/poketool/pokegra/pokegra/narc_2163.NCGR \
        files/poketool/pokegra/pokegra/narc_2164.NCLR \
        files/poketool/pokegra/pokegra/narc_2165.NCLR \
        files/poketool/pokegra/pokegra/narc_2166.NCGR \
        files/poketool/pokegra/pokegra/narc_2167.NCGR \
        files/poketool/pokegra/pokegra/narc_2168.NCGR \
        files/poketool/pokegra/pokegra/narc_2169.NCGR \
        files/poketool/pokegra/pokegra/narc_2170.NCLR \
        files/poketool/pokegra/pokegra/narc_2171.NCLR \
        files/poketool/pokegra/pokegra/narc_2172.NCGR \
        files/poketool/pokegra/pokegra/narc_2173.NCGR \
        files/poketool/pokegra/pokegra/narc_2174.NCGR \
        files/poketool/pokegra/pokegra/narc_2175.NCGR \
        files/poketool/pokegra/pokegra/narc_2176.NCLR \
        files/poketool/pokegra/pokegra/narc_2177.NCLR \
        files/poketool/pokegra/pokegra/narc_2178.NCGR \
        files/poketool/pokegra/pokegra/narc_2179.NCGR \
        files/poketool/pokegra/pokegra/narc_2180.NCGR \
        files/poketool/pokegra/pokegra/narc_2181.NCGR \
        files/poketool/pokegra/pokegra/narc_2182.NCLR \
        files/poketool/pokegra/pokegra/narc_2183.NCLR \
        files/poketool/pokegra/pokegra/narc_2184.NCGR \
        files/poketool/pokegra/pokegra/narc_2185.NCGR \
        files/poketool/pokegra/pokegra/narc_2186.NCGR \
        files/poketool/pokegra/pokegra/narc_2187.NCGR \
        files/poketool/pokegra/pokegra/narc_2188.NCLR \
        files/poketool/pokegra/pokegra/narc_2189.NCLR \
        files/poketool/pokegra/pokegra/narc_2190.NCGR \
        files/poketool/pokegra/pokegra/narc_2191.NCGR \
        files/poketool/pokegra/pokegra/narc_2192.NCGR \
        files/poketool/pokegra/pokegra/narc_2193.NCGR \
        files/poketool/pokegra/pokegra/narc_2194.NCLR \
        files/poketool/pokegra/pokegra/narc_2195.NCLR \
        files/poketool/pokegra/pokegra/narc_2196.NCGR \
        files/poketool/pokegra/pokegra/narc_2197.NCGR \
        files/poketool/pokegra/pokegra/narc_2198.NCGR \
        files/poketool/pokegra/pokegra/narc_2199.NCGR \
        files/poketool/pokegra/pokegra/narc_2200.NCLR \
        files/poketool/pokegra/pokegra/narc_2201.NCLR \
        files/poketool/pokegra/pokegra/narc_2202.NCGR \
        files/poketool/pokegra/pokegra/narc_2203.NCGR \
        files/poketool/pokegra/pokegra/narc_2204.NCGR \
        files/poketool/pokegra/pokegra/narc_2205.NCGR \
        files/poketool/pokegra/pokegra/narc_2206.NCLR \
        files/poketool/pokegra/pokegra/narc_2207.NCLR \
        files/poketool/pokegra/pokegra/narc_2208.NCGR \
        files/poketool/pokegra/pokegra/narc_2209.NCGR \
        files/poketool/pokegra/pokegra/narc_2210.NCGR \
        files/poketool/pokegra/pokegra/narc_2211.NCGR \
        files/poketool/pokegra/pokegra/narc_2212.NCLR \
        files/poketool/pokegra/pokegra/narc_2213.NCLR \
        files/poketool/pokegra/pokegra/narc_2214.NCGR \
        files/poketool/pokegra/pokegra/narc_2215.NCGR \
        files/poketool/pokegra/pokegra/narc_2216.NCGR \
        files/poketool/pokegra/pokegra/narc_2217.NCGR \
        files/poketool/pokegra/pokegra/narc_2218.NCLR \
        files/poketool/pokegra/pokegra/narc_2219.NCLR \
        files/poketool/pokegra/pokegra/narc_2220.NCGR \
        files/poketool/pokegra/pokegra/narc_2221.NCGR \
        files/poketool/pokegra/pokegra/narc_2222.NCGR \
        files/poketool/pokegra/pokegra/narc_2223.NCGR \
        files/poketool/pokegra/pokegra/narc_2224.NCLR \
        files/poketool/pokegra/pokegra/narc_2225.NCLR \
        files/poketool/pokegra/pokegra/narc_2226.NCGR \
        files/poketool/pokegra/pokegra/narc_2227.NCGR \
        files/poketool/pokegra/pokegra/narc_2228.NCGR \
        files/poketool/pokegra/pokegra/narc_2229.NCGR \
        files/poketool/pokegra/pokegra/narc_2230.NCLR \
        files/poketool/pokegra/pokegra/narc_2231.NCLR \
        files/poketool/pokegra/pokegra/narc_2232.NCGR \
        files/poketool/pokegra/pokegra/narc_2233.NCGR \
        files/poketool/pokegra/pokegra/narc_2234.NCGR \
        files/poketool/pokegra/pokegra/narc_2235.NCGR \
        files/poketool/pokegra/pokegra/narc_2236.NCLR \
        files/poketool/pokegra/pokegra/narc_2237.NCLR \
        files/poketool/pokegra/pokegra/narc_2238.NCGR \
        files/poketool/pokegra/pokegra/narc_2239.NCGR \
        files/poketool/pokegra/pokegra/narc_2240.NCGR \
        files/poketool/pokegra/pokegra/narc_2241.NCGR \
        files/poketool/pokegra/pokegra/narc_2242.NCLR \
        files/poketool/pokegra/pokegra/narc_2243.NCLR \
        files/poketool/pokegra/pokegra/narc_2245.NCGR \
        files/poketool/pokegra/pokegra/narc_2247.NCGR \
        files/poketool/pokegra/pokegra/narc_2248.NCLR \
        files/poketool/pokegra/pokegra/narc_2249.NCLR \
        files/poketool/pokegra/pokegra/narc_2251.NCGR \
        files/poketool/pokegra/pokegra/narc_2253.NCGR \
        files/poketool/pokegra/pokegra/narc_2254.NCLR \
        files/poketool/pokegra/pokegra/narc_2255.NCLR \
        files/poketool/pokegra/pokegra/narc_2257.NCGR \
        files/poketool/pokegra/pokegra/narc_2259.NCGR \
        files/poketool/pokegra/pokegra/narc_2260.NCLR \
        files/poketool/pokegra/pokegra/narc_2261.NCLR \
        files/poketool/pokegra/pokegra/narc_2263.NCGR \
        files/poketool/pokegra/pokegra/narc_2265.NCGR \
        files/poketool/pokegra/pokegra/narc_2266.NCLR \
        files/poketool/pokegra/pokegra/narc_2267.NCLR \
        files/poketool/pokegra/pokegra/narc_2269.NCGR \
        files/poketool/pokegra/pokegra/narc_2271.NCGR \
        files/poketool/pokegra/pokegra/narc_2272.NCLR \
        files/poketool/pokegra/pokegra/narc_2273.NCLR \
        files/poketool/pokegra/pokegra/narc_2275.NCGR \
        files/poketool/pokegra/pokegra/narc_2277.NCGR \
        files/poketool/pokegra/pokegra/narc_2278.NCLR \
        files/poketool/pokegra/pokegra/narc_2279.NCLR \
        files/poketool/pokegra/pokegra/narc_2280.NCGR \
        files/poketool/pokegra/pokegra/narc_2282.NCGR \
        files/poketool/pokegra/pokegra/narc_2284.NCLR \
        files/poketool/pokegra/pokegra/narc_2285.NCLR \
        files/poketool/pokegra/pokegra/narc_2287.NCGR \
        files/poketool/pokegra/pokegra/narc_2289.NCGR \
        files/poketool/pokegra/pokegra/narc_2290.NCLR \
        files/poketool/pokegra/pokegra/narc_2291.NCLR \
        files/poketool/pokegra/pokegra/narc_2293.NCGR \
        files/poketool/pokegra/pokegra/narc_2295.NCGR \
        files/poketool/pokegra/pokegra/narc_2296.NCLR \
        files/poketool/pokegra/pokegra/narc_2297.NCLR \
        files/poketool/pokegra/pokegra/narc_2299.NCGR \
        files/poketool/pokegra/pokegra/narc_2301.NCGR \
        files/poketool/pokegra/pokegra/narc_2302.NCLR \
        files/poketool/pokegra/pokegra/narc_2303.NCLR \
        files/poketool/pokegra/pokegra/narc_2305.NCGR \
        files/poketool/pokegra/pokegra/narc_2307.NCGR \
        files/poketool/pokegra/pokegra/narc_2308.NCLR \
        files/poketool/pokegra/pokegra/narc_2309.NCLR \
        files/poketool/pokegra/pokegra/narc_2311.NCGR \
        files/poketool/pokegra/pokegra/narc_2313.NCGR \
        files/poketool/pokegra/pokegra/narc_2314.NCLR \
        files/poketool/pokegra/pokegra/narc_2315.NCLR \
        files/poketool/pokegra/pokegra/narc_2317.NCGR \
        files/poketool/pokegra/pokegra/narc_2319.NCGR \
        files/poketool/pokegra/pokegra/narc_2320.NCLR \
        files/poketool/pokegra/pokegra/narc_2321.NCLR \
        files/poketool/pokegra/pokegra/narc_2322.NCGR \
        files/poketool/pokegra/pokegra/narc_2323.NCGR \
        files/poketool/pokegra/pokegra/narc_2324.NCGR \
        files/poketool/pokegra/pokegra/narc_2325.NCGR \
        files/poketool/pokegra/pokegra/narc_2326.NCLR \
        files/poketool/pokegra/pokegra/narc_2327.NCLR \
        files/poketool/pokegra/pokegra/narc_2328.NCGR \
        files/poketool/pokegra/pokegra/narc_2329.NCGR \
        files/poketool/pokegra/pokegra/narc_2330.NCGR \
        files/poketool/pokegra/pokegra/narc_2331.NCGR \
        files/poketool/pokegra/pokegra/narc_2332.NCLR \
        files/poketool/pokegra/pokegra/narc_2333.NCLR \
        files/poketool/pokegra/pokegra/narc_2334.NCGR \
        files/poketool/pokegra/pokegra/narc_2335.NCGR \
        files/poketool/pokegra/pokegra/narc_2336.NCGR \
        files/poketool/pokegra/pokegra/narc_2337.NCGR \
        files/poketool/pokegra/pokegra/narc_2338.NCLR \
        files/poketool/pokegra/pokegra/narc_2339.NCLR \
        files/poketool/pokegra/pokegra/narc_2340.NCGR \
        files/poketool/pokegra/pokegra/narc_2341.NCGR \
        files/poketool/pokegra/pokegra/narc_2342.NCGR \
        files/poketool/pokegra/pokegra/narc_2343.NCGR \
        files/poketool/pokegra/pokegra/narc_2344.NCLR \
        files/poketool/pokegra/pokegra/narc_2345.NCLR \
        files/poketool/pokegra/pokegra/narc_2346.NCGR \
        files/poketool/pokegra/pokegra/narc_2347.NCGR \
        files/poketool/pokegra/pokegra/narc_2348.NCGR \
        files/poketool/pokegra/pokegra/narc_2349.NCGR \
        files/poketool/pokegra/pokegra/narc_2350.NCLR \
        files/poketool/pokegra/pokegra/narc_2351.NCLR \
        files/poketool/pokegra/pokegra/narc_2352.NCGR \
        files/poketool/pokegra/pokegra/narc_2353.NCGR \
        files/poketool/pokegra/pokegra/narc_2354.NCGR \
        files/poketool/pokegra/pokegra/narc_2355.NCGR \
        files/poketool/pokegra/pokegra/narc_2356.NCLR \
        files/poketool/pokegra/pokegra/narc_2357.NCLR \
        files/poketool/pokegra/pokegra/narc_2358.NCGR \
        files/poketool/pokegra/pokegra/narc_2359.NCGR \
        files/poketool/pokegra/pokegra/narc_2360.NCGR \
        files/poketool/pokegra/pokegra/narc_2361.NCGR \
        files/poketool/pokegra/pokegra/narc_2362.NCLR \
        files/poketool/pokegra/pokegra/narc_2363.NCLR \
        files/poketool/pokegra/pokegra/narc_2364.NCGR \
        files/poketool/pokegra/pokegra/narc_2365.NCGR \
        files/poketool/pokegra/pokegra/narc_2366.NCGR \
        files/poketool/pokegra/pokegra/narc_2367.NCGR \
        files/poketool/pokegra/pokegra/narc_2368.NCLR \
        files/poketool/pokegra/pokegra/narc_2369.NCLR \
        files/poketool/pokegra/pokegra/narc_2370.NCGR \
        files/poketool/pokegra/pokegra/narc_2371.NCGR \
        files/poketool/pokegra/pokegra/narc_2372.NCGR \
        files/poketool/pokegra/pokegra/narc_2373.NCGR \
        files/poketool/pokegra/pokegra/narc_2374.NCLR \
        files/poketool/pokegra/pokegra/narc_2375.NCLR \
        files/poketool/pokegra/pokegra/narc_2376.NCGR \
        files/poketool/pokegra/pokegra/narc_2377.NCGR \
        files/poketool/pokegra/pokegra/narc_2378.NCGR \
        files/poketool/pokegra/pokegra/narc_2379.NCGR \
        files/poketool/pokegra/pokegra/narc_2380.NCLR \
        files/poketool/pokegra/pokegra/narc_2381.NCLR \
        files/poketool/pokegra/pokegra/narc_2382.NCGR \
        files/poketool/pokegra/pokegra/narc_2383.NCGR \
        files/poketool/pokegra/pokegra/narc_2384.NCGR \
        files/poketool/pokegra/pokegra/narc_2385.NCGR \
        files/poketool/pokegra/pokegra/narc_2386.NCLR \
        files/poketool/pokegra/pokegra/narc_2387.NCLR \
        files/poketool/pokegra/pokegra/narc_2388.NCGR \
        files/poketool/pokegra/pokegra/narc_2389.NCGR \
        files/poketool/pokegra/pokegra/narc_2390.NCGR \
        files/poketool/pokegra/pokegra/narc_2391.NCGR \
        files/poketool/pokegra/pokegra/narc_2392.NCLR \
        files/poketool/pokegra/pokegra/narc_2393.NCLR \
        files/poketool/pokegra/pokegra/narc_2394.NCGR \
        files/poketool/pokegra/pokegra/narc_2395.NCGR \
        files/poketool/pokegra/pokegra/narc_2396.NCGR \
        files/poketool/pokegra/pokegra/narc_2397.NCGR \
        files/poketool/pokegra/pokegra/narc_2398.NCLR \
        files/poketool/pokegra/pokegra/narc_2399.NCLR \
        files/poketool/pokegra/pokegra/narc_2400.NCGR \
        files/poketool/pokegra/pokegra/narc_2401.NCGR \
        files/poketool/pokegra/pokegra/narc_2402.NCGR \
        files/poketool/pokegra/pokegra/narc_2403.NCGR \
        files/poketool/pokegra/pokegra/narc_2404.NCLR \
        files/poketool/pokegra/pokegra/narc_2405.NCLR \
        files/poketool/pokegra/pokegra/narc_2406.NCGR \
        files/poketool/pokegra/pokegra/narc_2407.NCGR \
        files/poketool/pokegra/pokegra/narc_2408.NCGR \
        files/poketool/pokegra/pokegra/narc_2409.NCGR \
        files/poketool/pokegra/pokegra/narc_2410.NCLR \
        files/poketool/pokegra/pokegra/narc_2411.NCLR \
        files/poketool/pokegra/pokegra/narc_2412.NCGR \
        files/poketool/pokegra/pokegra/narc_2413.NCGR \
        files/poketool/pokegra/pokegra/narc_2414.NCGR \
        files/poketool/pokegra/pokegra/narc_2415.NCGR \
        files/poketool/pokegra/pokegra/narc_2416.NCLR \
        files/poketool/pokegra/pokegra/narc_2417.NCLR \
        files/poketool/pokegra/pokegra/narc_2418.NCGR \
        files/poketool/pokegra/pokegra/narc_2419.NCGR \
        files/poketool/pokegra/pokegra/narc_2420.NCGR \
        files/poketool/pokegra/pokegra/narc_2421.NCGR \
        files/poketool/pokegra/pokegra/narc_2422.NCLR \
        files/poketool/pokegra/pokegra/narc_2423.NCLR \
        files/poketool/pokegra/pokegra/narc_2424.NCGR \
        files/poketool/pokegra/pokegra/narc_2425.NCGR \
        files/poketool/pokegra/pokegra/narc_2426.NCGR \
        files/poketool/pokegra/pokegra/narc_2427.NCGR \
        files/poketool/pokegra/pokegra/narc_2428.NCLR \
        files/poketool/pokegra/pokegra/narc_2429.NCLR \
        files/poketool/pokegra/pokegra/narc_2430.NCGR \
        files/poketool/pokegra/pokegra/narc_2431.NCGR \
        files/poketool/pokegra/pokegra/narc_2432.NCGR \
        files/poketool/pokegra/pokegra/narc_2433.NCGR \
        files/poketool/pokegra/pokegra/narc_2434.NCLR \
        files/poketool/pokegra/pokegra/narc_2435.NCLR \
        files/poketool/pokegra/pokegra/narc_2436.NCGR \
        files/poketool/pokegra/pokegra/narc_2437.NCGR \
        files/poketool/pokegra/pokegra/narc_2438.NCGR \
        files/poketool/pokegra/pokegra/narc_2439.NCGR \
        files/poketool/pokegra/pokegra/narc_2440.NCLR \
        files/poketool/pokegra/pokegra/narc_2441.NCLR \
        files/poketool/pokegra/pokegra/narc_2442.NCGR \
        files/poketool/pokegra/pokegra/narc_2443.NCGR \
        files/poketool/pokegra/pokegra/narc_2444.NCGR \
        files/poketool/pokegra/pokegra/narc_2445.NCGR \
        files/poketool/pokegra/pokegra/narc_2446.NCLR \
        files/poketool/pokegra/pokegra/narc_2447.NCLR \
        files/poketool/pokegra/pokegra/narc_2448.NCGR \
        files/poketool/pokegra/pokegra/narc_2449.NCGR \
        files/poketool/pokegra/pokegra/narc_2450.NCGR \
        files/poketool/pokegra/pokegra/narc_2451.NCGR \
        files/poketool/pokegra/pokegra/narc_2452.NCLR \
        files/poketool/pokegra/pokegra/narc_2453.NCLR \
        files/poketool/pokegra/pokegra/narc_2454.NCGR \
        files/poketool/pokegra/pokegra/narc_2455.NCGR \
        files/poketool/pokegra/pokegra/narc_2456.NCGR \
        files/poketool/pokegra/pokegra/narc_2457.NCGR \
        files/poketool/pokegra/pokegra/narc_2458.NCLR \
        files/poketool/pokegra/pokegra/narc_2459.NCLR \
        files/poketool/pokegra/pokegra/narc_2460.NCGR \
        files/poketool/pokegra/pokegra/narc_2461.NCGR \
        files/poketool/pokegra/pokegra/narc_2462.NCGR \
        files/poketool/pokegra/pokegra/narc_2463.NCGR \
        files/poketool/pokegra/pokegra/narc_2464.NCLR \
        files/poketool/pokegra/pokegra/narc_2465.NCLR \
        files/poketool/pokegra/pokegra/narc_2466.NCGR \
        files/poketool/pokegra/pokegra/narc_2467.NCGR \
        files/poketool/pokegra/pokegra/narc_2468.NCGR \
        files/poketool/pokegra/pokegra/narc_2469.NCGR \
        files/poketool/pokegra/pokegra/narc_2470.NCLR \
        files/poketool/pokegra/pokegra/narc_2471.NCLR \
        files/poketool/pokegra/pokegra/narc_2472.NCGR \
        files/poketool/pokegra/pokegra/narc_2473.NCGR \
        files/poketool/pokegra/pokegra/narc_2474.NCGR \
        files/poketool/pokegra/pokegra/narc_2475.NCGR \
        files/poketool/pokegra/pokegra/narc_2476.NCLR \
        files/poketool/pokegra/pokegra/narc_2477.NCLR \
        files/poketool/pokegra/pokegra/narc_2478.NCGR \
        files/poketool/pokegra/pokegra/narc_2480.NCGR \
        files/poketool/pokegra/pokegra/narc_2482.NCLR \
        files/poketool/pokegra/pokegra/narc_2483.NCLR \
        files/poketool/pokegra/pokegra/narc_2485.NCGR \
        files/poketool/pokegra/pokegra/narc_2487.NCGR \
        files/poketool/pokegra/pokegra/narc_2488.NCLR \
        files/poketool/pokegra/pokegra/narc_2489.NCLR \
        files/poketool/pokegra/pokegra/narc_2490.NCGR \
        files/poketool/pokegra/pokegra/narc_2491.NCGR \
        files/poketool/pokegra/pokegra/narc_2492.NCGR \
        files/poketool/pokegra/pokegra/narc_2493.NCGR \
        files/poketool/pokegra/pokegra/narc_2494.NCLR \
        files/poketool/pokegra/pokegra/narc_2495.NCLR \
        files/poketool/pokegra/pokegra/narc_2496.NCGR \
        files/poketool/pokegra/pokegra/narc_2498.NCGR \
        files/poketool/pokegra/pokegra/narc_2500.NCLR \
        files/poketool/pokegra/pokegra/narc_2501.NCLR \
        files/poketool/pokegra/pokegra/narc_2502.NCGR \
        files/poketool/pokegra/pokegra/narc_2503.NCGR \
        files/poketool/pokegra/pokegra/narc_2504.NCGR \
        files/poketool/pokegra/pokegra/narc_2505.NCGR \
        files/poketool/pokegra/pokegra/narc_2506.NCLR \
        files/poketool/pokegra/pokegra/narc_2507.NCLR \
        files/poketool/pokegra/pokegra/narc_2508.NCGR \
        files/poketool/pokegra/pokegra/narc_2509.NCGR \
        files/poketool/pokegra/pokegra/narc_2510.NCGR \
        files/poketool/pokegra/pokegra/narc_2511.NCGR \
        files/poketool/pokegra/pokegra/narc_2512.NCLR \
        files/poketool/pokegra/pokegra/narc_2513.NCLR \
        files/poketool/pokegra/pokegra/narc_2514.NCGR \
        files/poketool/pokegra/pokegra/narc_2515.NCGR \
        files/poketool/pokegra/pokegra/narc_2516.NCGR \
        files/poketool/pokegra/pokegra/narc_2517.NCGR \
        files/poketool/pokegra/pokegra/narc_2518.NCLR \
        files/poketool/pokegra/pokegra/narc_2519.NCLR \
        files/poketool/pokegra/pokegra/narc_2520.NCGR \
        files/poketool/pokegra/pokegra/narc_2521.NCGR \
        files/poketool/pokegra/pokegra/narc_2522.NCGR \
        files/poketool/pokegra/pokegra/narc_2523.NCGR \
        files/poketool/pokegra/pokegra/narc_2524.NCLR \
        files/poketool/pokegra/pokegra/narc_2525.NCLR \
        files/poketool/pokegra/pokegra/narc_2526.NCGR \
        files/poketool/pokegra/pokegra/narc_2527.NCGR \
        files/poketool/pokegra/pokegra/narc_2528.NCGR \
        files/poketool/pokegra/pokegra/narc_2529.NCGR \
        files/poketool/pokegra/pokegra/narc_2530.NCLR \
        files/poketool/pokegra/pokegra/narc_2531.NCLR \
        files/poketool/pokegra/pokegra/narc_2532.NCGR \
        files/poketool/pokegra/pokegra/narc_2533.NCGR \
        files/poketool/pokegra/pokegra/narc_2534.NCGR \
        files/poketool/pokegra/pokegra/narc_2535.NCGR \
        files/poketool/pokegra/pokegra/narc_2536.NCLR \
        files/poketool/pokegra/pokegra/narc_2537.NCLR \
        files/poketool/pokegra/pokegra/narc_2538.NCGR \
        files/poketool/pokegra/pokegra/narc_2539.NCGR \
        files/poketool/pokegra/pokegra/narc_2540.NCGR \
        files/poketool/pokegra/pokegra/narc_2541.NCGR \
        files/poketool/pokegra/pokegra/narc_2542.NCLR \
        files/poketool/pokegra/pokegra/narc_2543.NCLR \
        files/poketool/pokegra/pokegra/narc_2544.NCGR \
        files/poketool/pokegra/pokegra/narc_2545.NCGR \
        files/poketool/pokegra/pokegra/narc_2546.NCGR \
        files/poketool/pokegra/pokegra/narc_2547.NCGR \
        files/poketool/pokegra/pokegra/narc_2548.NCLR \
        files/poketool/pokegra/pokegra/narc_2549.NCLR \
        files/poketool/pokegra/pokegra/narc_2550.NCGR \
        files/poketool/pokegra/pokegra/narc_2551.NCGR \
        files/poketool/pokegra/pokegra/narc_2552.NCGR \
        files/poketool/pokegra/pokegra/narc_2553.NCGR \
        files/poketool/pokegra/pokegra/narc_2554.NCLR \
        files/poketool/pokegra/pokegra/narc_2555.NCLR \
        files/poketool/pokegra/pokegra/narc_2556.NCGR \
        files/poketool/pokegra/pokegra/narc_2557.NCGR \
        files/poketool/pokegra/pokegra/narc_2558.NCGR \
        files/poketool/pokegra/pokegra/narc_2559.NCGR \
        files/poketool/pokegra/pokegra/narc_2560.NCLR \
        files/poketool/pokegra/pokegra/narc_2561.NCLR \
        files/poketool/pokegra/pokegra/narc_2562.NCGR \
        files/poketool/pokegra/pokegra/narc_2563.NCGR \
        files/poketool/pokegra/pokegra/narc_2564.NCGR \
        files/poketool/pokegra/pokegra/narc_2565.NCGR \
        files/poketool/pokegra/pokegra/narc_2566.NCLR \
        files/poketool/pokegra/pokegra/narc_2567.NCLR \
        files/poketool/pokegra/pokegra/narc_2568.NCGR \
        files/poketool/pokegra/pokegra/narc_2569.NCGR \
        files/poketool/pokegra/pokegra/narc_2570.NCGR \
        files/poketool/pokegra/pokegra/narc_2571.NCGR \
        files/poketool/pokegra/pokegra/narc_2572.NCLR \
        files/poketool/pokegra/pokegra/narc_2573.NCLR \
        files/poketool/pokegra/pokegra/narc_2574.NCGR \
        files/poketool/pokegra/pokegra/narc_2575.NCGR \
        files/poketool/pokegra/pokegra/narc_2576.NCGR \
        files/poketool/pokegra/pokegra/narc_2577.NCGR \
        files/poketool/pokegra/pokegra/narc_2578.NCLR \
        files/poketool/pokegra/pokegra/narc_2579.NCLR \
        files/poketool/pokegra/pokegra/narc_2580.NCGR \
        files/poketool/pokegra/pokegra/narc_2581.NCGR \
        files/poketool/pokegra/pokegra/narc_2582.NCGR \
        files/poketool/pokegra/pokegra/narc_2583.NCGR \
        files/poketool/pokegra/pokegra/narc_2584.NCLR \
        files/poketool/pokegra/pokegra/narc_2585.NCLR \
        files/poketool/pokegra/pokegra/narc_2586.NCGR \
        files/poketool/pokegra/pokegra/narc_2587.NCGR \
        files/poketool/pokegra/pokegra/narc_2588.NCGR \
        files/poketool/pokegra/pokegra/narc_2589.NCGR \
        files/poketool/pokegra/pokegra/narc_2590.NCLR \
        files/poketool/pokegra/pokegra/narc_2591.NCLR \
        files/poketool/pokegra/pokegra/narc_2592.NCGR \
        files/poketool/pokegra/pokegra/narc_2593.NCGR \
        files/poketool/pokegra/pokegra/narc_2594.NCGR \
        files/poketool/pokegra/pokegra/narc_2595.NCGR \
        files/poketool/pokegra/pokegra/narc_2596.NCLR \
        files/poketool/pokegra/pokegra/narc_2597.NCLR \
        files/poketool/pokegra/pokegra/narc_2598.NCGR \
        files/poketool/pokegra/pokegra/narc_2599.NCGR \
        files/poketool/pokegra/pokegra/narc_2600.NCGR \
        files/poketool/pokegra/pokegra/narc_2601.NCGR \
        files/poketool/pokegra/pokegra/narc_2602.NCLR \
        files/poketool/pokegra/pokegra/narc_2603.NCLR \
        files/poketool/pokegra/pokegra/narc_2604.NCGR \
        files/poketool/pokegra/pokegra/narc_2605.NCGR \
        files/poketool/pokegra/pokegra/narc_2606.NCGR \
        files/poketool/pokegra/pokegra/narc_2607.NCGR \
        files/poketool/pokegra/pokegra/narc_2608.NCLR \
        files/poketool/pokegra/pokegra/narc_2609.NCLR \
        files/poketool/pokegra/pokegra/narc_2610.NCGR \
        files/poketool/pokegra/pokegra/narc_2611.NCGR \
        files/poketool/pokegra/pokegra/narc_2612.NCGR \
        files/poketool/pokegra/pokegra/narc_2613.NCGR \
        files/poketool/pokegra/pokegra/narc_2614.NCLR \
        files/poketool/pokegra/pokegra/narc_2615.NCLR \
        files/poketool/pokegra/pokegra/narc_2617.NCGR \
        files/poketool/pokegra/pokegra/narc_2619.NCGR \
        files/poketool/pokegra/pokegra/narc_2620.NCLR \
        files/poketool/pokegra/pokegra/narc_2621.NCLR \
        files/poketool/pokegra/pokegra/narc_2623.NCGR \
        files/poketool/pokegra/pokegra/narc_2625.NCGR \
        files/poketool/pokegra/pokegra/narc_2626.NCLR \
        files/poketool/pokegra/pokegra/narc_2627.NCLR \
        files/poketool/pokegra/pokegra/narc_2628.NCGR \
        files/poketool/pokegra/pokegra/narc_2629.NCGR \
        files/poketool/pokegra/pokegra/narc_2630.NCGR \
        files/poketool/pokegra/pokegra/narc_2631.NCGR \
        files/poketool/pokegra/pokegra/narc_2632.NCLR \
        files/poketool/pokegra/pokegra/narc_2633.NCLR \
        files/poketool/pokegra/pokegra/narc_2634.NCGR \
        files/poketool/pokegra/pokegra/narc_2635.NCGR \
        files/poketool/pokegra/pokegra/narc_2636.NCGR \
        files/poketool/pokegra/pokegra/narc_2637.NCGR \
        files/poketool/pokegra/pokegra/narc_2638.NCLR \
        files/poketool/pokegra/pokegra/narc_2639.NCLR \
        files/poketool/pokegra/pokegra/narc_2640.NCGR \
        files/poketool/pokegra/pokegra/narc_2642.NCGR \
        files/poketool/pokegra/pokegra/narc_2644.NCLR \
        files/poketool/pokegra/pokegra/narc_2645.NCLR \
        files/poketool/pokegra/pokegra/narc_2646.NCGR \
        files/poketool/pokegra/pokegra/narc_2647.NCGR \
        files/poketool/pokegra/pokegra/narc_2648.NCGR \
        files/poketool/pokegra/pokegra/narc_2649.NCGR \
        files/poketool/pokegra/pokegra/narc_2650.NCLR \
        files/poketool/pokegra/pokegra/narc_2651.NCLR \
        files/poketool/pokegra/pokegra/narc_2652.NCGR \
        files/poketool/pokegra/pokegra/narc_2653.NCGR \
        files/poketool/pokegra/pokegra/narc_2654.NCGR \
        files/poketool/pokegra/pokegra/narc_2655.NCGR \
        files/poketool/pokegra/pokegra/narc_2656.NCLR \
        files/poketool/pokegra/pokegra/narc_2657.NCLR \
        files/poketool/pokegra/pokegra/narc_2658.NCGR \
        files/poketool/pokegra/pokegra/narc_2659.NCGR \
        files/poketool/pokegra/pokegra/narc_2660.NCGR \
        files/poketool/pokegra/pokegra/narc_2661.NCGR \
        files/poketool/pokegra/pokegra/narc_2662.NCLR \
        files/poketool/pokegra/pokegra/narc_2663.NCLR \
        files/poketool/pokegra/pokegra/narc_2664.NCGR \
        files/poketool/pokegra/pokegra/narc_2665.NCGR \
        files/poketool/pokegra/pokegra/narc_2666.NCGR \
        files/poketool/pokegra/pokegra/narc_2667.NCGR \
        files/poketool/pokegra/pokegra/narc_2668.NCLR \
        files/poketool/pokegra/pokegra/narc_2669.NCLR \
        files/poketool/pokegra/pokegra/narc_2670.NCGR \
        files/poketool/pokegra/pokegra/narc_2671.NCGR \
        files/poketool/pokegra/pokegra/narc_2672.NCGR \
        files/poketool/pokegra/pokegra/narc_2673.NCGR \
        files/poketool/pokegra/pokegra/narc_2674.NCLR \
        files/poketool/pokegra/pokegra/narc_2675.NCLR \
        files/poketool/pokegra/pokegra/narc_2676.NCGR \
        files/poketool/pokegra/pokegra/narc_2677.NCGR \
        files/poketool/pokegra/pokegra/narc_2678.NCGR \
        files/poketool/pokegra/pokegra/narc_2679.NCGR \
        files/poketool/pokegra/pokegra/narc_2680.NCLR \
        files/poketool/pokegra/pokegra/narc_2681.NCLR \
        files/poketool/pokegra/pokegra/narc_2682.NCGR \
        files/poketool/pokegra/pokegra/narc_2683.NCGR \
        files/poketool/pokegra/pokegra/narc_2684.NCGR \
        files/poketool/pokegra/pokegra/narc_2685.NCGR \
        files/poketool/pokegra/pokegra/narc_2686.NCLR \
        files/poketool/pokegra/pokegra/narc_2687.NCLR \
        files/poketool/pokegra/pokegra/narc_2688.NCGR \
        files/poketool/pokegra/pokegra/narc_2689.NCGR \
        files/poketool/pokegra/pokegra/narc_2690.NCGR \
        files/poketool/pokegra/pokegra/narc_2691.NCGR \
        files/poketool/pokegra/pokegra/narc_2692.NCLR \
        files/poketool/pokegra/pokegra/narc_2693.NCLR \
        files/poketool/pokegra/pokegra/narc_2694.NCGR \
        files/poketool/pokegra/pokegra/narc_2695.NCGR \
        files/poketool/pokegra/pokegra/narc_2696.NCGR \
        files/poketool/pokegra/pokegra/narc_2697.NCGR \
        files/poketool/pokegra/pokegra/narc_2698.NCLR \
        files/poketool/pokegra/pokegra/narc_2699.NCLR \
        files/poketool/pokegra/pokegra/narc_2700.NCGR \
        files/poketool/pokegra/pokegra/narc_2701.NCGR \
        files/poketool/pokegra/pokegra/narc_2702.NCGR \
        files/poketool/pokegra/pokegra/narc_2703.NCGR \
        files/poketool/pokegra/pokegra/narc_2704.NCLR \
        files/poketool/pokegra/pokegra/narc_2705.NCLR \
        files/poketool/pokegra/pokegra/narc_2706.NCGR \
        files/poketool/pokegra/pokegra/narc_2707.NCGR \
        files/poketool/pokegra/pokegra/narc_2708.NCGR \
        files/poketool/pokegra/pokegra/narc_2709.NCGR \
        files/poketool/pokegra/pokegra/narc_2710.NCLR \
        files/poketool/pokegra/pokegra/narc_2711.NCLR \
        files/poketool/pokegra/pokegra/narc_2712.NCGR \
        files/poketool/pokegra/pokegra/narc_2713.NCGR \
        files/poketool/pokegra/pokegra/narc_2714.NCGR \
        files/poketool/pokegra/pokegra/narc_2715.NCGR \
        files/poketool/pokegra/pokegra/narc_2716.NCLR \
        files/poketool/pokegra/pokegra/narc_2717.NCLR \
        files/poketool/pokegra/pokegra/narc_2718.NCGR \
        files/poketool/pokegra/pokegra/narc_2719.NCGR \
        files/poketool/pokegra/pokegra/narc_2720.NCGR \
        files/poketool/pokegra/pokegra/narc_2721.NCGR \
        files/poketool/pokegra/pokegra/narc_2722.NCLR \
        files/poketool/pokegra/pokegra/narc_2723.NCLR \
        files/poketool/pokegra/pokegra/narc_2724.NCGR \
        files/poketool/pokegra/pokegra/narc_2725.NCGR \
        files/poketool/pokegra/pokegra/narc_2726.NCGR \
        files/poketool/pokegra/pokegra/narc_2727.NCGR \
        files/poketool/pokegra/pokegra/narc_2728.NCLR \
        files/poketool/pokegra/pokegra/narc_2729.NCLR \
        files/poketool/pokegra/pokegra/narc_2730.NCGR \
        files/poketool/pokegra/pokegra/narc_2731.NCGR \
        files/poketool/pokegra/pokegra/narc_2732.NCGR \
        files/poketool/pokegra/pokegra/narc_2733.NCGR \
        files/poketool/pokegra/pokegra/narc_2734.NCLR \
        files/poketool/pokegra/pokegra/narc_2735.NCLR \
        files/poketool/pokegra/pokegra/narc_2736.NCGR \
        files/poketool/pokegra/pokegra/narc_2737.NCGR \
        files/poketool/pokegra/pokegra/narc_2738.NCGR \
        files/poketool/pokegra/pokegra/narc_2739.NCGR \
        files/poketool/pokegra/pokegra/narc_2740.NCLR \
        files/poketool/pokegra/pokegra/narc_2741.NCLR \
        files/poketool/pokegra/pokegra/narc_2742.NCGR \
        files/poketool/pokegra/pokegra/narc_2743.NCGR \
        files/poketool/pokegra/pokegra/narc_2744.NCGR \
        files/poketool/pokegra/pokegra/narc_2745.NCGR \
        files/poketool/pokegra/pokegra/narc_2746.NCLR \
        files/poketool/pokegra/pokegra/narc_2747.NCLR \
        files/poketool/pokegra/pokegra/narc_2748.NCGR \
        files/poketool/pokegra/pokegra/narc_2749.NCGR \
        files/poketool/pokegra/pokegra/narc_2750.NCGR \
        files/poketool/pokegra/pokegra/narc_2751.NCGR \
        files/poketool/pokegra/pokegra/narc_2752.NCLR \
        files/poketool/pokegra/pokegra/narc_2753.NCLR \
        files/poketool/pokegra/pokegra/narc_2754.NCGR \
        files/poketool/pokegra/pokegra/narc_2755.NCGR \
        files/poketool/pokegra/pokegra/narc_2756.NCGR \
        files/poketool/pokegra/pokegra/narc_2757.NCGR \
        files/poketool/pokegra/pokegra/narc_2758.NCLR \
        files/poketool/pokegra/pokegra/narc_2759.NCLR \
        files/poketool/pokegra/pokegra/narc_2760.NCGR \
        files/poketool/pokegra/pokegra/narc_2761.NCGR \
        files/poketool/pokegra/pokegra/narc_2762.NCGR \
        files/poketool/pokegra/pokegra/narc_2763.NCGR \
        files/poketool/pokegra/pokegra/narc_2764.NCLR \
        files/poketool/pokegra/pokegra/narc_2765.NCLR \
        files/poketool/pokegra/pokegra/narc_2766.NCGR \
        files/poketool/pokegra/pokegra/narc_2767.NCGR \
        files/poketool/pokegra/pokegra/narc_2768.NCGR \
        files/poketool/pokegra/pokegra/narc_2769.NCGR \
        files/poketool/pokegra/pokegra/narc_2770.NCLR \
        files/poketool/pokegra/pokegra/narc_2771.NCLR \
        files/poketool/pokegra/pokegra/narc_2773.NCGR \
        files/poketool/pokegra/pokegra/narc_2775.NCGR \
        files/poketool/pokegra/pokegra/narc_2776.NCLR \
        files/poketool/pokegra/pokegra/narc_2777.NCLR \
        files/poketool/pokegra/pokegra/narc_2778.NCGR \
        files/poketool/pokegra/pokegra/narc_2779.NCGR \
        files/poketool/pokegra/pokegra/narc_2780.NCGR \
        files/poketool/pokegra/pokegra/narc_2781.NCGR \
        files/poketool/pokegra/pokegra/narc_2782.NCLR \
        files/poketool/pokegra/pokegra/narc_2783.NCLR \
        files/poketool/pokegra/pokegra/narc_2784.NCGR \
        files/poketool/pokegra/pokegra/narc_2785.NCGR \
        files/poketool/pokegra/pokegra/narc_2786.NCGR \
        files/poketool/pokegra/pokegra/narc_2787.NCGR \
        files/poketool/pokegra/pokegra/narc_2788.NCLR \
        files/poketool/pokegra/pokegra/narc_2789.NCLR \
        files/poketool/pokegra/pokegra/narc_2790.NCGR \
        files/poketool/pokegra/pokegra/narc_2791.NCGR \
        files/poketool/pokegra/pokegra/narc_2792.NCGR \
        files/poketool/pokegra/pokegra/narc_2793.NCGR \
        files/poketool/pokegra/pokegra/narc_2794.NCLR \
        files/poketool/pokegra/pokegra/narc_2795.NCLR \
        files/poketool/pokegra/pokegra/narc_2796.NCGR \
        files/poketool/pokegra/pokegra/narc_2797.NCGR \
        files/poketool/pokegra/pokegra/narc_2798.NCGR \
        files/poketool/pokegra/pokegra/narc_2799.NCGR \
        files/poketool/pokegra/pokegra/narc_2800.NCLR \
        files/poketool/pokegra/pokegra/narc_2801.NCLR \
        files/poketool/pokegra/pokegra/narc_2802.NCGR \
        files/poketool/pokegra/pokegra/narc_2803.NCGR \
        files/poketool/pokegra/pokegra/narc_2804.NCGR \
        files/poketool/pokegra/pokegra/narc_2805.NCGR \
        files/poketool/pokegra/pokegra/narc_2806.NCLR \
        files/poketool/pokegra/pokegra/narc_2807.NCLR \
        files/poketool/pokegra/pokegra/narc_2808.NCGR \
        files/poketool/pokegra/pokegra/narc_2809.NCGR \
        files/poketool/pokegra/pokegra/narc_2810.NCGR \
        files/poketool/pokegra/pokegra/narc_2811.NCGR \
        files/poketool/pokegra/pokegra/narc_2812.NCLR \
        files/poketool/pokegra/pokegra/narc_2813.NCLR \
        files/poketool/pokegra/pokegra/narc_2814.NCGR \
        files/poketool/pokegra/pokegra/narc_2815.NCGR \
        files/poketool/pokegra/pokegra/narc_2816.NCGR \
        files/poketool/pokegra/pokegra/narc_2817.NCGR \
        files/poketool/pokegra/pokegra/narc_2818.NCLR \
        files/poketool/pokegra/pokegra/narc_2819.NCLR \
        files/poketool/pokegra/pokegra/narc_2820.NCGR \
        files/poketool/pokegra/pokegra/narc_2821.NCGR \
        files/poketool/pokegra/pokegra/narc_2822.NCGR \
        files/poketool/pokegra/pokegra/narc_2823.NCGR \
        files/poketool/pokegra/pokegra/narc_2824.NCLR \
        files/poketool/pokegra/pokegra/narc_2825.NCLR \
        files/poketool/pokegra/pokegra/narc_2826.NCGR \
        files/poketool/pokegra/pokegra/narc_2827.NCGR \
        files/poketool/pokegra/pokegra/narc_2828.NCGR \
        files/poketool/pokegra/pokegra/narc_2829.NCGR \
        files/poketool/pokegra/pokegra/narc_2830.NCLR \
        files/poketool/pokegra/pokegra/narc_2831.NCLR \
        files/poketool/pokegra/pokegra/narc_2832.NCGR \
        files/poketool/pokegra/pokegra/narc_2833.NCGR \
        files/poketool/pokegra/pokegra/narc_2834.NCGR \
        files/poketool/pokegra/pokegra/narc_2835.NCGR \
        files/poketool/pokegra/pokegra/narc_2836.NCLR \
        files/poketool/pokegra/pokegra/narc_2837.NCLR \
        files/poketool/pokegra/pokegra/narc_2838.NCGR \
        files/poketool/pokegra/pokegra/narc_2839.NCGR \
        files/poketool/pokegra/pokegra/narc_2840.NCGR \
        files/poketool/pokegra/pokegra/narc_2841.NCGR \
        files/poketool/pokegra/pokegra/narc_2842.NCLR \
        files/poketool/pokegra/pokegra/narc_2843.NCLR \
        files/poketool/pokegra/pokegra/narc_2845.NCGR \
        files/poketool/pokegra/pokegra/narc_2847.NCGR \
        files/poketool/pokegra/pokegra/narc_2848.NCLR \
        files/poketool/pokegra/pokegra/narc_2849.NCLR \
        files/poketool/pokegra/pokegra/narc_2851.NCGR \
        files/poketool/pokegra/pokegra/narc_2853.NCGR \
        files/poketool/pokegra/pokegra/narc_2854.NCLR \
        files/poketool/pokegra/pokegra/narc_2855.NCLR \
        files/poketool/pokegra/pokegra/narc_2856.NCGR \
        files/poketool/pokegra/pokegra/narc_2857.NCGR \
        files/poketool/pokegra/pokegra/narc_2858.NCGR \
        files/poketool/pokegra/pokegra/narc_2859.NCGR \
        files/poketool/pokegra/pokegra/narc_2860.NCLR \
        files/poketool/pokegra/pokegra/narc_2861.NCLR \
        files/poketool/pokegra/pokegra/narc_2862.NCGR \
        files/poketool/pokegra/pokegra/narc_2863.NCGR \
        files/poketool/pokegra/pokegra/narc_2864.NCGR \
        files/poketool/pokegra/pokegra/narc_2865.NCGR \
        files/poketool/pokegra/pokegra/narc_2866.NCLR \
        files/poketool/pokegra/pokegra/narc_2867.NCLR \
        files/poketool/pokegra/pokegra/narc_2868.NCGR \
        files/poketool/pokegra/pokegra/narc_2870.NCGR \
        files/poketool/pokegra/pokegra/narc_2872.NCLR \
        files/poketool/pokegra/pokegra/narc_2873.NCLR \
        files/poketool/pokegra/pokegra/narc_2875.NCGR \
        files/poketool/pokegra/pokegra/narc_2877.NCGR \
        files/poketool/pokegra/pokegra/narc_2878.NCLR \
        files/poketool/pokegra/pokegra/narc_2879.NCLR \
        files/poketool/pokegra/pokegra/narc_2881.NCGR \
        files/poketool/pokegra/pokegra/narc_2883.NCGR \
        files/poketool/pokegra/pokegra/narc_2884.NCLR \
        files/poketool/pokegra/pokegra/narc_2885.NCLR \
        files/poketool/pokegra/pokegra/narc_2887.NCGR \
        files/poketool/pokegra/pokegra/narc_2889.NCGR \
        files/poketool/pokegra/pokegra/narc_2890.NCLR \
        files/poketool/pokegra/pokegra/narc_2891.NCLR \
        files/poketool/pokegra/pokegra/narc_2893.NCGR \
        files/poketool/pokegra/pokegra/narc_2895.NCGR \
        files/poketool/pokegra/pokegra/narc_2896.NCLR \
        files/poketool/pokegra/pokegra/narc_2897.NCLR \
        files/poketool/pokegra/pokegra/narc_2899.NCGR \
        files/poketool/pokegra/pokegra/narc_2901.NCGR \
        files/poketool/pokegra/pokegra/narc_2902.NCLR \
        files/poketool/pokegra/pokegra/narc_2903.NCLR \
        files/poketool/pokegra/pokegra/narc_2905.NCGR \
        files/poketool/pokegra/pokegra/narc_2907.NCGR \
        files/poketool/pokegra/pokegra/narc_2908.NCLR \
        files/poketool/pokegra/pokegra/narc_2909.NCLR \
        files/poketool/pokegra/pokegra/narc_2910.NCGR \
        files/poketool/pokegra/pokegra/narc_2911.NCGR \
        files/poketool/pokegra/pokegra/narc_2912.NCGR \
        files/poketool/pokegra/pokegra/narc_2913.NCGR \
        files/poketool/pokegra/pokegra/narc_2914.NCLR \
        files/poketool/pokegra/pokegra/narc_2915.NCLR \
        files/poketool/pokegra/pokegra/narc_2917.NCGR \
        files/poketool/pokegra/pokegra/narc_2919.NCGR \
        files/poketool/pokegra/pokegra/narc_2920.NCLR \
        files/poketool/pokegra/pokegra/narc_2921.NCLR \
        files/poketool/pokegra/pokegra/narc_2923.NCGR \
        files/poketool/pokegra/pokegra/narc_2925.NCGR \
        files/poketool/pokegra/pokegra/narc_2926.NCLR \
        files/poketool/pokegra/pokegra/narc_2927.NCLR \
        files/poketool/pokegra/pokegra/narc_2928.NCGR \
        files/poketool/pokegra/pokegra/narc_2930.NCGR \
        files/poketool/pokegra/pokegra/narc_2932.NCLR \
        files/poketool/pokegra/pokegra/narc_2933.NCLR \
        files/poketool/pokegra/pokegra/narc_2935.NCGR \
        files/poketool/pokegra/pokegra/narc_2937.NCGR \
        files/poketool/pokegra/pokegra/narc_2938.NCLR \
        files/poketool/pokegra/pokegra/narc_2939.NCLR \
        files/poketool/pokegra/pokegra/narc_2941.NCGR \
        files/poketool/pokegra/pokegra/narc_2943.NCGR \
        files/poketool/pokegra/pokegra/narc_2944.NCLR \
        files/poketool/pokegra/pokegra/narc_2945.NCLR \
        files/poketool/pokegra/pokegra/narc_2947.NCGR \
        files/poketool/pokegra/pokegra/narc_2949.NCGR \
        files/poketool/pokegra/pokegra/narc_2950.NCLR \
        files/poketool/pokegra/pokegra/narc_2951.NCLR \
        files/poketool/pokegra/pokegra/narc_2953.NCGR \
        files/poketool/pokegra/pokegra/narc_2955.NCGR \
        files/poketool/pokegra/pokegra/narc_2956.NCLR \
        files/poketool/pokegra/pokegra/narc_2957.NCLR \
        files/poketool/pokegra/pokegra/narc_2959.NCGR \
        files/poketool/pokegra/pokegra/narc_2961.NCGR \
        files/poketool/pokegra/pokegra/narc_2962.NCLR \
        files/poketool/pokegra/pokegra/narc_2963.NCLR 


files/poketool/icongra/poke_icon.narc: \
        files/poketool/icongra/poke_icon/narc_0000.NCLR \
        files/poketool/icongra/poke_icon/narc_0001.NANR \
        files/poketool/icongra/poke_icon/narc_0002.NCER \
        files/poketool/icongra/poke_icon/narc_0003.NANR \
        files/poketool/icongra/poke_icon/narc_0004.NCER \
        files/poketool/icongra/poke_icon/narc_0005.NANR \
        files/poketool/icongra/poke_icon/narc_0006.NCER \
        files/poketool/icongra/poke_icon/narc_0007.NCGR \
        files/poketool/icongra/poke_icon/narc_0008.NCGR \
        files/poketool/icongra/poke_icon/narc_0009.NCGR \
        files/poketool/icongra/poke_icon/narc_0010.NCGR \
        files/poketool/icongra/poke_icon/narc_0011.NCGR \
        files/poketool/icongra/poke_icon/narc_0012.NCGR \
        files/poketool/icongra/poke_icon/narc_0013.NCGR \
        files/poketool/icongra/poke_icon/narc_0014.NCGR \
        files/poketool/icongra/poke_icon/narc_0015.NCGR \
        files/poketool/icongra/poke_icon/narc_0016.NCGR \
        files/poketool/icongra/poke_icon/narc_0017.NCGR \
        files/poketool/icongra/poke_icon/narc_0018.NCGR \
        files/poketool/icongra/poke_icon/narc_0019.NCGR \
        files/poketool/icongra/poke_icon/narc_0020.NCGR \
        files/poketool/icongra/poke_icon/narc_0021.NCGR \
        files/poketool/icongra/poke_icon/narc_0022.NCGR \
        files/poketool/icongra/poke_icon/narc_0023.NCGR \
        files/poketool/icongra/poke_icon/narc_0024.NCGR \
        files/poketool/icongra/poke_icon/narc_0025.NCGR \
        files/poketool/icongra/poke_icon/narc_0026.NCGR \
        files/poketool/icongra/poke_icon/narc_0027.NCGR \
        files/poketool/icongra/poke_icon/narc_0028.NCGR \
        files/poketool/icongra/poke_icon/narc_0029.NCGR \
        files/poketool/icongra/poke_icon/narc_0030.NCGR \
        files/poketool/icongra/poke_icon/narc_0031.NCGR \
        files/poketool/icongra/poke_icon/narc_0032.NCGR \
        files/poketool/icongra/poke_icon/narc_0033.NCGR \
        files/poketool/icongra/poke_icon/narc_0034.NCGR \
        files/poketool/icongra/poke_icon/narc_0035.NCGR \
        files/poketool/icongra/poke_icon/narc_0036.NCGR \
        files/poketool/icongra/poke_icon/narc_0402.NCGR

files/msgdata/msg.narc: \
	files/msgdata/msg/narc_0000.bin \
        files/msgdata/msg/narc_0001.bin \
        files/msgdata/msg/narc_0002.bin \
        files/msgdata/msg/narc_0003.bin \
        files/msgdata/msg/narc_0004.bin \
        files/msgdata/msg/narc_0005.bin \
        files/msgdata/msg/narc_0006.bin \
        files/msgdata/msg/narc_0007.bin \
        files/msgdata/msg/narc_0008.bin \
        files/msgdata/msg/narc_0009.bin \
        files/msgdata/msg/narc_0010.bin \
        files/msgdata/msg/narc_0011.bin \
        files/msgdata/msg/narc_0012.bin \
        files/msgdata/msg/narc_0013.bin \
        files/msgdata/msg/narc_0014.bin \
        files/msgdata/msg/narc_0015.bin \
        files/msgdata/msg/narc_0016.bin \
        files/msgdata/msg/narc_0017.bin \
        files/msgdata/msg/narc_0018.bin \
        files/msgdata/msg/narc_0019.bin \
        files/msgdata/msg/narc_0020.bin \
        files/msgdata/msg/narc_0021.bin \
        files/msgdata/msg/narc_0022.bin \
        files/msgdata/msg/narc_0023.bin \
        files/msgdata/msg/narc_0024.bin \
        files/msgdata/msg/narc_0025.bin \
        files/msgdata/msg/narc_0026.bin \
        files/msgdata/msg/narc_0027.bin \
        files/msgdata/msg/narc_0028.bin \
        files/msgdata/msg/narc_0029.bin \
        files/msgdata/msg/narc_0030.bin \
        files/msgdata/msg/narc_0031.bin \
        files/msgdata/msg/narc_0032.bin \
        files/msgdata/msg/narc_0033.bin \
        files/msgdata/msg/narc_0034.bin \
        files/msgdata/msg/narc_0035.bin \
        files/msgdata/msg/narc_0036.bin \
        files/msgdata/msg/narc_0037.bin \
        files/msgdata/msg/narc_0038.bin \
        files/msgdata/msg/narc_0039.bin \
        files/msgdata/msg/narc_0040.bin \
        files/msgdata/msg/narc_0041.bin \
        files/msgdata/msg/narc_0042.bin \
        files/msgdata/msg/narc_0043.bin \
        files/msgdata/msg/narc_0044.bin \
        files/msgdata/msg/narc_0045.bin \
        files/msgdata/msg/narc_0046.bin \
        files/msgdata/msg/narc_0047.bin \
        files/msgdata/msg/narc_0048.bin \
        files/msgdata/msg/narc_0049.bin \
        files/msgdata/msg/narc_0050.bin \
        files/msgdata/msg/narc_0051.bin \
        files/msgdata/msg/narc_0052.bin \
        files/msgdata/msg/narc_0053.bin \
        files/msgdata/msg/narc_0054.bin \
        files/msgdata/msg/narc_0055.bin \
        files/msgdata/msg/narc_0056.bin \
        files/msgdata/msg/narc_0057.bin \
        files/msgdata/msg/narc_0058.bin \
        files/msgdata/msg/narc_0059.bin \
        files/msgdata/msg/narc_0060.bin \
        files/msgdata/msg/narc_0061.bin \
        files/msgdata/msg/narc_0062.bin \
        files/msgdata/msg/narc_0063.bin \
        files/msgdata/msg/narc_0064.bin \
        files/msgdata/msg/narc_0065.bin \
        files/msgdata/msg/narc_0066.bin \
        files/msgdata/msg/narc_0067.bin \
        files/msgdata/msg/narc_0068.bin \
        files/msgdata/msg/narc_0069.bin \
        files/msgdata/msg/narc_0070.bin \
        files/msgdata/msg/narc_0071.bin \
        files/msgdata/msg/narc_0072.bin \
        files/msgdata/msg/narc_0073.bin \
        files/msgdata/msg/narc_0074.bin \
        files/msgdata/msg/narc_0075.bin \
        files/msgdata/msg/narc_0076.bin \
        files/msgdata/msg/narc_0077.bin \
        files/msgdata/msg/narc_0078.bin \
        files/msgdata/msg/narc_0079.bin \
        files/msgdata/msg/narc_0080.bin \
        files/msgdata/msg/narc_0081.bin \
        files/msgdata/msg/narc_0082.bin \
        files/msgdata/msg/narc_0083.bin \
        files/msgdata/msg/narc_0084.bin \
        files/msgdata/msg/narc_0085.bin \
        files/msgdata/msg/narc_0086.bin \
        files/msgdata/msg/narc_0087.bin \
        files/msgdata/msg/narc_0088.bin \
        files/msgdata/msg/narc_0089.bin \
        files/msgdata/msg/narc_0090.bin \
        files/msgdata/msg/narc_0091.bin \
        files/msgdata/msg/narc_0092.bin \
        files/msgdata/msg/narc_0093.bin \
        files/msgdata/msg/narc_0094.bin \
        files/msgdata/msg/narc_0095.bin \
        files/msgdata/msg/narc_0096.bin \
        files/msgdata/msg/narc_0097.bin \
        files/msgdata/msg/narc_0098.bin \
        files/msgdata/msg/narc_0099.bin \
        files/msgdata/msg/narc_0100.bin \
        files/msgdata/msg/narc_0101.bin \
        files/msgdata/msg/narc_0102.bin \
        files/msgdata/msg/narc_0103.bin \
        files/msgdata/msg/narc_0104.bin \
        files/msgdata/msg/narc_0105.bin \
        files/msgdata/msg/narc_0106.bin \
        files/msgdata/msg/narc_0107.bin \
        files/msgdata/msg/narc_0108.bin \
        files/msgdata/msg/narc_0109.bin \
        files/msgdata/msg/narc_0110.bin \
        files/msgdata/msg/narc_0111.bin \
        files/msgdata/msg/narc_0112.bin \
        files/msgdata/msg/narc_0113.bin \
        files/msgdata/msg/narc_0114.bin \
        files/msgdata/msg/narc_0115.bin \
        files/msgdata/msg/narc_0116.bin \
        files/msgdata/msg/narc_0117.bin \
        files/msgdata/msg/narc_0118.bin \
        files/msgdata/msg/narc_0119.bin \
        files/msgdata/msg/narc_0120.bin \
        files/msgdata/msg/narc_0121.bin \
        files/msgdata/msg/narc_0122.bin \
        files/msgdata/msg/narc_0123.bin \
        files/msgdata/msg/narc_0124.bin \
        files/msgdata/msg/narc_0125.bin \
        files/msgdata/msg/narc_0126.bin \
        files/msgdata/msg/narc_0127.bin \
        files/msgdata/msg/narc_0128.bin \
        files/msgdata/msg/narc_0129.bin \
        files/msgdata/msg/narc_0130.bin \
        files/msgdata/msg/narc_0131.bin \
        files/msgdata/msg/narc_0132.bin \
        files/msgdata/msg/narc_0133.bin \
        files/msgdata/msg/narc_0134.bin \
        files/msgdata/msg/narc_0135.bin \
        files/msgdata/msg/narc_0136.bin \
        files/msgdata/msg/narc_0137.bin \
        files/msgdata/msg/narc_0138.bin \
        files/msgdata/msg/narc_0139.bin \
        files/msgdata/msg/narc_0140.bin \
        files/msgdata/msg/narc_0141.bin \
        files/msgdata/msg/narc_0142.bin \
        files/msgdata/msg/narc_0143.bin \
        files/msgdata/msg/narc_0144.bin \
        files/msgdata/msg/narc_0145.bin \
        files/msgdata/msg/narc_0146.bin \
        files/msgdata/msg/narc_0147.bin \
        files/msgdata/msg/narc_0148.bin \
        files/msgdata/msg/narc_0149.bin \
        files/msgdata/msg/narc_0150.bin \
        files/msgdata/msg/narc_0151.bin \
        files/msgdata/msg/narc_0152.bin \
        files/msgdata/msg/narc_0153.bin \
        files/msgdata/msg/narc_0154.bin \
        files/msgdata/msg/narc_0155.bin \
        files/msgdata/msg/narc_0156.bin \
        files/msgdata/msg/narc_0157.bin \
        files/msgdata/msg/narc_0158.bin \
        files/msgdata/msg/narc_0159.bin \
        files/msgdata/msg/narc_0160.bin \
        files/msgdata/msg/narc_0161.bin \
        files/msgdata/msg/narc_0162.bin \
        files/msgdata/msg/narc_0163.bin \
        files/msgdata/msg/narc_0164.bin \
        files/msgdata/msg/narc_0165.bin \
        files/msgdata/msg/narc_0166.bin \
        files/msgdata/msg/narc_0167.bin \
        files/msgdata/msg/narc_0168.bin \
        files/msgdata/msg/narc_0169.bin \
        files/msgdata/msg/narc_0170.bin \
        files/msgdata/msg/narc_0171.bin \
        files/msgdata/msg/narc_0172.bin \
        files/msgdata/msg/narc_0173.bin \
        files/msgdata/msg/narc_0174.bin \
        files/msgdata/msg/narc_0175.bin \
        files/msgdata/msg/narc_0176.bin \
        files/msgdata/msg/narc_0177.bin \
        files/msgdata/msg/narc_0178.bin \
        files/msgdata/msg/narc_0179.bin \
        files/msgdata/msg/narc_0180.bin \
        files/msgdata/msg/narc_0181.bin \
        files/msgdata/msg/narc_0182.bin \
        files/msgdata/msg/narc_0183.bin \
        files/msgdata/msg/narc_0184.bin \
        files/msgdata/msg/narc_0185.bin \
        files/msgdata/msg/narc_0186.bin \
        files/msgdata/msg/narc_0187.bin \
        files/msgdata/msg/narc_0188.bin \
        files/msgdata/msg/narc_0189.bin \
        files/msgdata/msg/narc_0190.bin \
        files/msgdata/msg/narc_0191.bin \
        files/msgdata/msg/narc_0192.bin \
        files/msgdata/msg/narc_0193.bin \
        files/msgdata/msg/narc_0194.bin \
        files/msgdata/msg/narc_0195.bin \
        files/msgdata/msg/narc_0196.bin \
        files/msgdata/msg/narc_0197.bin \
        files/msgdata/msg/narc_0198.bin \
        files/msgdata/msg/narc_0199.bin \
        files/msgdata/msg/narc_0200.bin \
        files/msgdata/msg/narc_0201.bin \
        files/msgdata/msg/narc_0202.bin \
        files/msgdata/msg/narc_0203.bin \
        files/msgdata/msg/narc_0204.bin \
        files/msgdata/msg/narc_0205.bin \
        files/msgdata/msg/narc_0206.bin \
        files/msgdata/msg/narc_0207.bin \
        files/msgdata/msg/narc_0208.bin \
        files/msgdata/msg/narc_0209.bin \
        files/msgdata/msg/narc_0210.bin \
        files/msgdata/msg/narc_0211.bin \
        files/msgdata/msg/narc_0212.bin \
        files/msgdata/msg/narc_0213.bin \
        files/msgdata/msg/narc_0214.bin \
        files/msgdata/msg/narc_0215.bin \
        files/msgdata/msg/narc_0216.bin \
        files/msgdata/msg/narc_0217.bin \
        files/msgdata/msg/narc_0218.bin \
        files/msgdata/msg/narc_0219.bin \
        files/msgdata/msg/narc_0220.bin \
        files/msgdata/msg/narc_0221.bin \
        files/msgdata/msg/narc_0222.bin \
        files/msgdata/msg/narc_0223.bin \
        files/msgdata/msg/narc_0224.bin \
        files/msgdata/msg/narc_0225.bin \
        files/msgdata/msg/narc_0226.bin \
        files/msgdata/msg/narc_0227.bin \
        files/msgdata/msg/narc_0228.bin \
        files/msgdata/msg/narc_0229.bin \
        files/msgdata/msg/narc_0230.bin \
        files/msgdata/msg/narc_0231.bin \
        files/msgdata/msg/narc_0232.bin \
        files/msgdata/msg/narc_0233.bin \
        files/msgdata/msg/narc_0234.bin \
        files/msgdata/msg/narc_0235.bin \
        files/msgdata/msg/narc_0236.bin \
        files/msgdata/msg/narc_0237.bin \
        files/msgdata/msg/narc_0238.bin \
        files/msgdata/msg/narc_0239.bin \
        files/msgdata/msg/narc_0240.bin \
        files/msgdata/msg/narc_0241.bin \
        files/msgdata/msg/narc_0242.bin \
        files/msgdata/msg/narc_0243.bin \
        files/msgdata/msg/narc_0244.bin \
        files/msgdata/msg/narc_0245.bin \
        files/msgdata/msg/narc_0246.bin \
        files/msgdata/msg/narc_0247.bin \
        files/msgdata/msg/narc_0248.bin \
        files/msgdata/msg/narc_0249.bin \
        files/msgdata/msg/narc_0250.bin \
        files/msgdata/msg/narc_0251.bin \
        files/msgdata/msg/narc_0252.bin \
        files/msgdata/msg/narc_0253.bin \
        files/msgdata/msg/narc_0254.bin \
        files/msgdata/msg/narc_0255.bin \
        files/msgdata/msg/narc_0256.bin \
        files/msgdata/msg/narc_0257.bin \
        files/msgdata/msg/narc_0258.bin \
        files/msgdata/msg/narc_0259.bin \
        files/msgdata/msg/narc_0260.bin \
        files/msgdata/msg/narc_0261.bin \
        files/msgdata/msg/narc_0262.bin \
        files/msgdata/msg/narc_0263.bin \
        files/msgdata/msg/narc_0264.bin \
        files/msgdata/msg/narc_0265.bin \
        files/msgdata/msg/narc_0266.bin \
        files/msgdata/msg/narc_0267.bin \
        files/msgdata/msg/narc_0268.bin \
        files/msgdata/msg/narc_0269.bin \
        files/msgdata/msg/narc_0270.bin \
        files/msgdata/msg/narc_0271.bin \
        files/msgdata/msg/narc_0272.bin \
        files/msgdata/msg/narc_0273.bin \
        files/msgdata/msg/narc_0274.bin \
        files/msgdata/msg/narc_0275.bin \
        files/msgdata/msg/narc_0276.bin \
        files/msgdata/msg/narc_0277.bin \
        files/msgdata/msg/narc_0278.bin \
        files/msgdata/msg/narc_0279.bin \
        files/msgdata/msg/narc_0280.bin \
        files/msgdata/msg/narc_0281.bin \
        files/msgdata/msg/narc_0282.bin \
        files/msgdata/msg/narc_0283.bin \
        files/msgdata/msg/narc_0284.bin \
        files/msgdata/msg/narc_0285.bin \
        files/msgdata/msg/narc_0286.bin \
        files/msgdata/msg/narc_0287.bin \
        files/msgdata/msg/narc_0288.bin \
        files/msgdata/msg/narc_0289.bin \
        files/msgdata/msg/narc_0290.bin \
        files/msgdata/msg/narc_0291.bin \
        files/msgdata/msg/narc_0292.bin \
        files/msgdata/msg/narc_0293.bin \
        files/msgdata/msg/narc_0294.bin \
        files/msgdata/msg/narc_0295.bin \
        files/msgdata/msg/narc_0296.bin \
        files/msgdata/msg/narc_0297.bin \
        files/msgdata/msg/narc_0298.bin \
        files/msgdata/msg/narc_0299.bin \
        files/msgdata/msg/narc_0300.bin \
        files/msgdata/msg/narc_0301.bin \
        files/msgdata/msg/narc_0302.bin \
        files/msgdata/msg/narc_0303.bin \
        files/msgdata/msg/narc_0304.bin \
        files/msgdata/msg/narc_0305.bin \
        files/msgdata/msg/narc_0306.bin \
        files/msgdata/msg/narc_0307.bin \
        files/msgdata/msg/narc_0308.bin \
        files/msgdata/msg/narc_0309.bin \
        files/msgdata/msg/narc_0310.bin \
        files/msgdata/msg/narc_0311.bin \
        files/msgdata/msg/narc_0312.bin \
        files/msgdata/msg/narc_0313.bin \
        files/msgdata/msg/narc_0314.bin \
        files/msgdata/msg/narc_0315.bin \
        files/msgdata/msg/narc_0316.bin \
        files/msgdata/msg/narc_0317.bin \
        files/msgdata/msg/narc_0318.bin \
        files/msgdata/msg/narc_0319.bin \
        files/msgdata/msg/narc_0320.bin \
        files/msgdata/msg/narc_0321.bin \
        files/msgdata/msg/narc_0322.bin \
        files/msgdata/msg/narc_0323.bin \
        files/msgdata/msg/narc_0324.bin \
        files/msgdata/msg/narc_0325.bin \
        files/msgdata/msg/narc_0326.bin \
        files/msgdata/msg/narc_0327.bin \
        files/msgdata/msg/narc_0328.bin \
        files/msgdata/msg/narc_0329.bin \
        files/msgdata/msg/narc_0330.bin \
        files/msgdata/msg/narc_0331.bin \
        files/msgdata/msg/narc_0332.bin \
        files/msgdata/msg/narc_0333.bin \
        files/msgdata/msg/narc_0334.bin \
        files/msgdata/msg/narc_0335.bin \
        files/msgdata/msg/narc_0336.bin \
        files/msgdata/msg/narc_0337.bin \
        files/msgdata/msg/narc_0338.bin \
        files/msgdata/msg/narc_0339.bin \
        files/msgdata/msg/narc_0340.bin \
        files/msgdata/msg/narc_0341.bin \
        files/msgdata/msg/narc_0342.bin \
        files/msgdata/msg/narc_0343.bin \
        files/msgdata/msg/narc_0344.bin \
        files/msgdata/msg/narc_0345.bin \
        files/msgdata/msg/narc_0346.bin \
        files/msgdata/msg/narc_0347.bin \
        files/msgdata/msg/narc_0348.bin \
        files/msgdata/msg/narc_0349.bin \
        files/msgdata/msg/narc_0350.bin \
        files/msgdata/msg/narc_0351.bin \
        files/msgdata/msg/narc_0352.bin \
        files/msgdata/msg/narc_0353.bin \
        files/msgdata/msg/narc_0354.bin \
        files/msgdata/msg/narc_0355.bin \
        files/msgdata/msg/narc_0356.bin \
        files/msgdata/msg/narc_0357.bin \
        files/msgdata/msg/narc_0358.bin \
        files/msgdata/msg/narc_0359.bin \
        files/msgdata/msg/narc_0360.bin \
        files/msgdata/msg/narc_0361.bin \
        files/msgdata/msg/narc_0362.bin \
        files/msgdata/msg/narc_0363.bin \
        files/msgdata/msg/narc_0364.bin \
        files/msgdata/msg/narc_0365.bin \
        files/msgdata/msg/narc_0366.bin \
        files/msgdata/msg/narc_0367.bin \
        files/msgdata/msg/narc_0368.bin \
        files/msgdata/msg/narc_0369.bin \
        files/msgdata/msg/narc_0370.bin \
        files/msgdata/msg/narc_0371.bin \
        files/msgdata/msg/narc_0372.bin \
        files/msgdata/msg/narc_0373.bin \
        files/msgdata/msg/narc_0374.bin \
        files/msgdata/msg/narc_0375.bin \
        files/msgdata/msg/narc_0376.bin \
        files/msgdata/msg/narc_0377.bin \
        files/msgdata/msg/narc_0378.bin \
        files/msgdata/msg/narc_0379.bin \
        files/msgdata/msg/narc_0380.bin \
        files/msgdata/msg/narc_0381.bin \
        files/msgdata/msg/narc_0382.bin \
        files/msgdata/msg/narc_0383.bin \
        files/msgdata/msg/narc_0384.bin \
        files/msgdata/msg/narc_0385.bin \
        files/msgdata/msg/narc_0386.bin \
        files/msgdata/msg/narc_0387.bin \
        files/msgdata/msg/narc_0388.bin \
        files/msgdata/msg/narc_0389.bin \
        files/msgdata/msg/narc_0390.bin \
        files/msgdata/msg/narc_0391.bin \
        files/msgdata/msg/narc_0392.bin \
        files/msgdata/msg/narc_0393.bin \
        files/msgdata/msg/narc_0394.bin \
        files/msgdata/msg/narc_0395.bin \
        files/msgdata/msg/narc_0396.bin \
        files/msgdata/msg/narc_0397.bin \
        files/msgdata/msg/narc_0398.bin \
        files/msgdata/msg/narc_0399.bin \
        files/msgdata/msg/narc_0400.bin \
        files/msgdata/msg/narc_0401.bin \
        files/msgdata/msg/narc_0402.bin \
        files/msgdata/msg/narc_0403.bin \
        files/msgdata/msg/narc_0404.bin \
        files/msgdata/msg/narc_0405.bin \
        files/msgdata/msg/narc_0406.bin \
        files/msgdata/msg/narc_0407.bin \
        files/msgdata/msg/narc_0408.bin \
        files/msgdata/msg/narc_0409.bin \
        files/msgdata/msg/narc_0410.bin \
        files/msgdata/msg/narc_0411.bin \
        files/msgdata/msg/narc_0412.bin \
        files/msgdata/msg/narc_0413.bin \
        files/msgdata/msg/narc_0414.bin \
        files/msgdata/msg/narc_0415.bin \
        files/msgdata/msg/narc_0416.bin \
        files/msgdata/msg/narc_0417.bin \
        files/msgdata/msg/narc_0418.bin \
        files/msgdata/msg/narc_0419.bin \
        files/msgdata/msg/narc_0420.bin \
        files/msgdata/msg/narc_0421.bin \
        files/msgdata/msg/narc_0422.bin \
        files/msgdata/msg/narc_0423.bin \
        files/msgdata/msg/narc_0424.bin \
        files/msgdata/msg/narc_0425.bin \
        files/msgdata/msg/narc_0426.bin \
        files/msgdata/msg/narc_0427.bin \
        files/msgdata/msg/narc_0428.bin \
        files/msgdata/msg/narc_0429.bin \
        files/msgdata/msg/narc_0430.bin \
        files/msgdata/msg/narc_0431.bin \
        files/msgdata/msg/narc_0432.bin \
        files/msgdata/msg/narc_0433.bin \
        files/msgdata/msg/narc_0434.bin \
        files/msgdata/msg/narc_0435.bin \
        files/msgdata/msg/narc_0436.bin \
        files/msgdata/msg/narc_0437.bin \
        files/msgdata/msg/narc_0438.bin \
        files/msgdata/msg/narc_0439.bin \
        files/msgdata/msg/narc_0440.bin \
        files/msgdata/msg/narc_0441.bin \
        files/msgdata/msg/narc_0442.bin \
        files/msgdata/msg/narc_0443.bin \
        files/msgdata/msg/narc_0444.bin \
        files/msgdata/msg/narc_0445.bin \
        files/msgdata/msg/narc_0446.bin \
        files/msgdata/msg/narc_0447.bin \
        files/msgdata/msg/narc_0448.bin \
        files/msgdata/msg/narc_0449.bin \
        files/msgdata/msg/narc_0450.bin \
        files/msgdata/msg/narc_0451.bin \
        files/msgdata/msg/narc_0452.bin \
        files/msgdata/msg/narc_0453.bin \
        files/msgdata/msg/narc_0454.bin \
        files/msgdata/msg/narc_0455.bin \
        files/msgdata/msg/narc_0456.bin \
        files/msgdata/msg/narc_0457.bin \
        files/msgdata/msg/narc_0458.bin \
        files/msgdata/msg/narc_0459.bin \
        files/msgdata/msg/narc_0460.bin \
        files/msgdata/msg/narc_0461.bin \
        files/msgdata/msg/narc_0462.bin \
        files/msgdata/msg/narc_0463.bin \
        files/msgdata/msg/narc_0464.bin \
        files/msgdata/msg/narc_0465.bin \
        files/msgdata/msg/narc_0466.bin \
        files/msgdata/msg/narc_0467.bin \
        files/msgdata/msg/narc_0468.bin \
        files/msgdata/msg/narc_0469.bin \
        files/msgdata/msg/narc_0470.bin \
        files/msgdata/msg/narc_0471.bin \
        files/msgdata/msg/narc_0472.bin \
        files/msgdata/msg/narc_0473.bin \
        files/msgdata/msg/narc_0474.bin \
        files/msgdata/msg/narc_0475.bin \
        files/msgdata/msg/narc_0476.bin \
        files/msgdata/msg/narc_0477.bin \
        files/msgdata/msg/narc_0478.bin \
        files/msgdata/msg/narc_0479.bin \
        files/msgdata/msg/narc_0480.bin \
        files/msgdata/msg/narc_0481.bin \
        files/msgdata/msg/narc_0482.bin \
        files/msgdata/msg/narc_0483.bin \
        files/msgdata/msg/narc_0484.bin \
        files/msgdata/msg/narc_0485.bin \
        files/msgdata/msg/narc_0486.bin \
        files/msgdata/msg/narc_0487.bin \
        files/msgdata/msg/narc_0488.bin \
        files/msgdata/msg/narc_0489.bin \
        files/msgdata/msg/narc_0490.bin \
        files/msgdata/msg/narc_0491.bin \
        files/msgdata/msg/narc_0492.bin \
        files/msgdata/msg/narc_0493.bin \
        files/msgdata/msg/narc_0494.bin \
        files/msgdata/msg/narc_0495.bin \
        files/msgdata/msg/narc_0496.bin \
        files/msgdata/msg/narc_0497.bin \
        files/msgdata/msg/narc_0498.bin \
        files/msgdata/msg/narc_0499.bin \
        files/msgdata/msg/narc_0500.bin \
        files/msgdata/msg/narc_0501.bin \
        files/msgdata/msg/narc_0502.bin \
        files/msgdata/msg/narc_0503.bin \
        files/msgdata/msg/narc_0504.bin \
        files/msgdata/msg/narc_0505.bin \
        files/msgdata/msg/narc_0506.bin \
        files/msgdata/msg/narc_0507.bin \
        files/msgdata/msg/narc_0508.bin \
        files/msgdata/msg/narc_0509.bin \
        files/msgdata/msg/narc_0510.bin \
        files/msgdata/msg/narc_0511.bin \
        files/msgdata/msg/narc_0512.bin \
        files/msgdata/msg/narc_0513.bin \
        files/msgdata/msg/narc_0514.bin \
        files/msgdata/msg/narc_0515.bin \
        files/msgdata/msg/narc_0516.bin \
        files/msgdata/msg/narc_0517.bin \
        files/msgdata/msg/narc_0518.bin \
        files/msgdata/msg/narc_0519.bin \
        files/msgdata/msg/narc_0520.bin \
        files/msgdata/msg/narc_0521.bin \
        files/msgdata/msg/narc_0522.bin \
        files/msgdata/msg/narc_0523.bin \
        files/msgdata/msg/narc_0524.bin \
        files/msgdata/msg/narc_0525.bin \
        files/msgdata/msg/narc_0526.bin \
        files/msgdata/msg/narc_0527.bin \
        files/msgdata/msg/narc_0528.bin \
        files/msgdata/msg/narc_0529.bin \
        files/msgdata/msg/narc_0530.bin \
        files/msgdata/msg/narc_0531.bin \
        files/msgdata/msg/narc_0532.bin \
        files/msgdata/msg/narc_0533.bin \
        files/msgdata/msg/narc_0534.bin \
        files/msgdata/msg/narc_0535.bin \
        files/msgdata/msg/narc_0536.bin \
        files/msgdata/msg/narc_0537.bin \
        files/msgdata/msg/narc_0538.bin \
        files/msgdata/msg/narc_0539.bin \
        files/msgdata/msg/narc_0540.bin \
        files/msgdata/msg/narc_0541.bin \
        files/msgdata/msg/narc_0542.bin \
        files/msgdata/msg/narc_0543.bin \
        files/msgdata/msg/narc_0544.bin \
        files/msgdata/msg/narc_0545.bin \
        files/msgdata/msg/narc_0546.bin \
        files/msgdata/msg/narc_0547.bin \
        files/msgdata/msg/narc_0548.bin \
        files/msgdata/msg/narc_0549.bin \
        files/msgdata/msg/narc_0550.bin \
        files/msgdata/msg/narc_0551.bin \
        files/msgdata/msg/narc_0552.bin \
        files/msgdata/msg/narc_0553.bin \
        files/msgdata/msg/narc_0554.bin \
        files/msgdata/msg/narc_0555.bin \
        files/msgdata/msg/narc_0556.bin \
        files/msgdata/msg/narc_0557.bin \
        files/msgdata/msg/narc_0558.bin \
        files/msgdata/msg/narc_0559.bin \
        files/msgdata/msg/narc_0560.bin \
        files/msgdata/msg/narc_0561.bin \
        files/msgdata/msg/narc_0562.bin \
        files/msgdata/msg/narc_0563.bin \
        files/msgdata/msg/narc_0564.bin \
        files/msgdata/msg/narc_0565.bin \
        files/msgdata/msg/narc_0566.bin \
        files/msgdata/msg/narc_0567.bin \
        files/msgdata/msg/narc_0568.bin \
        files/msgdata/msg/narc_0569.bin \
        files/msgdata/msg/narc_0570.bin \
        files/msgdata/msg/narc_0571.bin \
        files/msgdata/msg/narc_0572.bin \
        files/msgdata/msg/narc_0573.bin \
        files/msgdata/msg/narc_0574.bin \
        files/msgdata/msg/narc_0575.bin \
        files/msgdata/msg/narc_0576.bin \
        files/msgdata/msg/narc_0577.bin \
        files/msgdata/msg/narc_0578.bin \
        files/msgdata/msg/narc_0579.bin \
        files/msgdata/msg/narc_0580.bin \
        files/msgdata/msg/narc_0581.bin \
        files/msgdata/msg/narc_0582.bin \
        files/msgdata/msg/narc_0583.bin \
        files/msgdata/msg/narc_0584.bin \
        files/msgdata/msg/narc_0585.bin \
        files/msgdata/msg/narc_0586.bin \
        files/msgdata/msg/narc_0587.bin \
        files/msgdata/msg/narc_0588.bin \
        files/msgdata/msg/narc_0589.bin \
        files/msgdata/msg/narc_0590.bin \
        files/msgdata/msg/narc_0591.bin \
        files/msgdata/msg/narc_0592.bin \
        files/msgdata/msg/narc_0593.bin \
        files/msgdata/msg/narc_0594.bin \
        files/msgdata/msg/narc_0595.bin \
        files/msgdata/msg/narc_0596.bin \
        files/msgdata/msg/narc_0597.bin \
        files/msgdata/msg/narc_0598.bin \
        files/msgdata/msg/narc_0599.bin \
        files/msgdata/msg/narc_0600.bin \
        files/msgdata/msg/narc_0601.bin \
        files/msgdata/msg/narc_0602.bin \
        files/msgdata/msg/narc_0603.bin \
        files/msgdata/msg/narc_0604.bin \
        files/msgdata/msg/narc_0605.bin \
        files/msgdata/msg/narc_0606.bin \
        files/msgdata/msg/narc_0607.bin \
        files/msgdata/msg/narc_0608.bin \
        files/msgdata/msg/narc_0609.bin \
        files/msgdata/msg/narc_0610.bin \
        files/msgdata/msg/narc_0611.bin \
        files/msgdata/msg/narc_0612.bin \
        files/msgdata/msg/narc_0613.bin \
        files/msgdata/msg/narc_0614.bin \
        files/msgdata/msg/narc_0615.bin \
        files/msgdata/msg/narc_0616.bin \
        files/msgdata/msg/narc_0617.bin \
        files/msgdata/msg/narc_0618.bin \
        files/msgdata/msg/narc_0619.bin \
        files/msgdata/msg/narc_0620.bin \
        files/msgdata/msg/narc_0621.bin \
        files/msgdata/msg/narc_0622.bin \
        files/msgdata/msg/narc_0623.bin

files/graphic/poketch.narc: \
	files/graphic/poketch/narc_0010.NCGR.lz \
	files/graphic/poketch/narc_0011.NSCR.lz

files/resource/eng/trial/trial.narc: \
	files/resource/eng/trial/trial/narc_0000.NCLR \
	files/resource/eng/trial/trial/narc_0001.NCGR \
	files/resource/eng/trial/trial/narc_0003.NCLR \
	files/resource/eng/trial/trial/narc_0004.NCGR \
	files/resource/eng/trial/trial/narc_0006.NCLR \
	files/resource/eng/trial/trial/narc_0007.NCGR

files/demo/intro/intro.narc: \
	files/demo/intro/intro/main_background_tileset.NCGR \
	files/demo/intro/intro/main_background_diamond.NCLR \
	files/demo/intro/intro/main_background_pearl.NCLR \
	files/demo/intro/intro/lucas_walk_1.NCGR \
	files/demo/intro/intro/lucas_walk_2.NCGR \
	files/demo/intro/intro/lucas_walk_3.NCGR \
	files/demo/intro/intro/lucas_walk_4.NCGR \
	files/demo/intro/intro/lucas_walk.NCLR \
	files/demo/intro/intro/dawn_walk_1.NCGR \
	files/demo/intro/intro/dawn_walk_2.NCGR \
    files/demo/intro/intro/dawn_walk_3.NCGR \
    files/demo/intro/intro/dawn_walk_4.NCGR \
	files/demo/intro/intro/dawn_walk.NCLR \
    files/demo/intro/intro/rowan_front.NCGR \
    files/demo/intro/intro/rowan_front.NCLR \
    files/demo/intro/intro/barry_front.NCGR \
    files/demo/intro/intro/barry_front.NCLR \
    files/demo/intro/intro/sub_background_tileset.NCGR \
    files/demo/intro/intro/sub_background_diamond.NCLR \
    files/demo/intro/intro/sub_background_pearl.NCLR \
    files/demo/intro/intro/pokeball_button_1.NCGR \
    files/demo/intro/intro/pokeball_button_2.NCGR \
    files/demo/intro/intro/pokeball_button_3.NCGR

files/graphic/field_board.narc: \
	files/graphic/field_board/narc_0000.NCGR \
	files/graphic/field_board/narc_0001.NCLR \
	files/graphic/field_board/narc_0002.NCGR \
	files/graphic/field_board/narc_0003.NCGR \
	files/graphic/field_board/narc_0004.NCGR \
	files/graphic/field_board/narc_0005.NCGR \
	files/graphic/field_board/narc_0006.NCGR \
	files/graphic/field_board/narc_0007.NCGR \
	files/graphic/field_board/narc_0008.NCGR \
	files/graphic/field_board/narc_0009.NCGR \
	files/graphic/field_board/narc_0010.NCGR \
	files/graphic/field_board/narc_0011.NCGR \
	files/graphic/field_board/narc_0012.NCGR \
	files/graphic/field_board/narc_0013.NCGR \
	files/graphic/field_board/narc_0014.NCGR \
	files/graphic/field_board/narc_0015.NCGR \
	files/graphic/field_board/narc_0016.NCGR \
	files/graphic/field_board/narc_0017.NCGR \
	files/graphic/field_board/narc_0018.NCGR \
	files/graphic/field_board/narc_0019.NCGR \
	files/graphic/field_board/narc_0020.NCGR \
	files/graphic/field_board/narc_0021.NCGR \
	files/graphic/field_board/narc_0022.NCGR \
	files/graphic/field_board/narc_0023.NCGR \
	files/graphic/field_board/narc_0024.NCGR \
	files/graphic/field_board/narc_0025.NCGR \
	files/graphic/field_board/narc_0026.NCGR \
	files/graphic/field_board/narc_0027.NCGR \
	files/graphic/field_board/narc_0028.NCGR \
	files/graphic/field_board/narc_0029.NCGR \
	files/graphic/field_board/narc_0030.NCGR \
	files/graphic/field_board/narc_0031.NCGR \
	files/graphic/field_board/narc_0032.NCGR \
	files/graphic/field_board/narc_0033.NCGR \
	files/graphic/field_board/narc_0034.NCGR \
	files/graphic/field_board/narc_0035.NCGR \
	files/graphic/field_board/narc_0036.NCGR \
	files/graphic/field_board/narc_0037.NCGR \
	files/graphic/field_board/narc_0038.NCGR \
	files/graphic/field_board/narc_0039.NCGR \
	files/graphic/field_board/narc_0040.NCGR \
	files/graphic/field_board/narc_0041.NCGR \
	files/graphic/field_board/narc_0042.NCGR \
	files/graphic/field_board/narc_0043.NCGR \
	files/graphic/field_board/narc_0044.NCGR \
	files/graphic/field_board/narc_0045.NCGR \
	files/graphic/field_board/narc_0046.NCGR \
	files/graphic/field_board/narc_0047.NCGR \
	files/graphic/field_board/narc_0048.NCGR \
	files/graphic/field_board/narc_0049.NCGR \
	files/graphic/field_board/narc_0050.NCGR \
	files/graphic/field_board/narc_0051.NCGR

include files/msgdata/msg.mk

.PHONY: filesystem

filesystem: $(HOSTFS_FILES)
