CHARMAP = charmap.txt

MSGDATA_DIR := files/msgdata
MSGDATA_MSG_DIR := $(MSGDATA_DIR)/msg

TRNAME_GMM := $(MSGDATA_MSG_DIR)/narc_0559.gmm
MSGFILE_GMM := $(sort $(wildcard $(MSGDATA_MSG_DIR)/*.gmm) $(TRNAME_GMM))
MSGFILE_BIN := $(patsubst %.gmm,%.bin,$(MSGFILE_GMM))
MSGFILE_H := $(patsubst %.gmm,%.h,$(MSGFILE_GMM))

$(MSGFILE_H): %.h: %.bin

## Trainer names
$(TRNAME_GMM): files/poketool/trainer/trdata.json files/poketool/trainer/trname.json.txt
	$(JSONPROC) $^ $@
	$(SED) -i 's/&/&amp;/g' $@

$(MSGFILE_BIN): %.bin: %.gmm $(CHARMAP)
	$(MSGENC) $(MSGENCFLAGS) -e -c $(CHARMAP) --gmm -H $*.h $< $@

files/msgdata/msg/%.bin: files/msgdata/msg/%.txt $(CHARMAP)
	$(MSGENC) $(MSGENCFLAGS) -e -c $(CHARMAP) $< $@

files/msgdata/msg/narc_0000.bin: MSGENCFLAGS = -k 0x58e6
files/msgdata/msg/narc_0001.bin: MSGENCFLAGS = -k 0x3ad4
files/msgdata/msg/narc_0002.bin: MSGENCFLAGS = -k 0xb6f3
files/msgdata/msg/narc_0003.bin: MSGENCFLAGS = -k 0x0fa3
files/msgdata/msg/narc_0004.bin: MSGENCFLAGS = -k 0x764f
files/msgdata/msg/narc_0005.bin: MSGENCFLAGS = -k 0x868a
files/msgdata/msg/narc_0006.bin: MSGENCFLAGS = -k 0xadca
files/msgdata/msg/narc_0007.bin: MSGENCFLAGS = -k 0x02c1
files/msgdata/msg/narc_0008.bin: MSGENCFLAGS = -k 0xd21d
files/msgdata/msg/narc_0009.bin: MSGENCFLAGS = -k 0x3802
files/msgdata/msg/narc_0010.bin: MSGENCFLAGS = -k 0xd8d3
files/msgdata/msg/narc_0011.bin: MSGENCFLAGS = -k 0x6255
files/msgdata/msg/narc_0012.bin: MSGENCFLAGS = -k 0x443b
files/msgdata/msg/narc_0013.bin: MSGENCFLAGS = -k 0x79a4
files/msgdata/msg/narc_0014.bin: MSGENCFLAGS = -k 0xf340
files/msgdata/msg/narc_0015.bin: MSGENCFLAGS = -k 0x2907
files/msgdata/msg/narc_0016.bin: MSGENCFLAGS = -k 0x6785
files/msgdata/msg/narc_0017.bin: MSGENCFLAGS = -k 0x300b
files/msgdata/msg/narc_0018.bin: MSGENCFLAGS = -k 0x4793
files/msgdata/msg/narc_0019.bin: MSGENCFLAGS = -k 0xcab0
files/msgdata/msg/narc_0020.bin: MSGENCFLAGS = -k 0x996e
files/msgdata/msg/narc_0021.bin: MSGENCFLAGS = -k 0x2bb3
files/msgdata/msg/narc_0022.bin: MSGENCFLAGS = -k 0x4403
files/msgdata/msg/narc_0023.bin: MSGENCFLAGS = -k 0x440f
files/msgdata/msg/narc_0024.bin: MSGENCFLAGS = -k 0x440b
files/msgdata/msg/narc_0025.bin: MSGENCFLAGS = -k 0x441b
files/msgdata/msg/narc_0026.bin: MSGENCFLAGS = -k 0x4417
files/msgdata/msg/narc_0027.bin: MSGENCFLAGS = -k 0x4413
files/msgdata/msg/narc_0028.bin: MSGENCFLAGS = -k 0x440f
files/msgdata/msg/narc_0029.bin: MSGENCFLAGS = -k 0x440b
files/msgdata/msg/narc_0030.bin: MSGENCFLAGS = -k 0x4407
files/msgdata/msg/narc_0031.bin: MSGENCFLAGS = -k 0x4403
files/msgdata/msg/narc_0032.bin: MSGENCFLAGS = -k 0x443f
files/msgdata/msg/narc_0033.bin: MSGENCFLAGS = -k 0xc412
files/msgdata/msg/narc_0034.bin: MSGENCFLAGS = -k 0xc41e
files/msgdata/msg/narc_0035.bin: MSGENCFLAGS = -k 0xc41a
files/msgdata/msg/narc_0036.bin: MSGENCFLAGS = -k 0x442b
files/msgdata/msg/narc_0037.bin: MSGENCFLAGS = -k 0xc422
files/msgdata/msg/narc_0038.bin: MSGENCFLAGS = -k 0xc42e
files/msgdata/msg/narc_0039.bin: MSGENCFLAGS = -k 0xc42a
files/msgdata/msg/narc_0040.bin: MSGENCFLAGS = -k 0xc436
files/msgdata/msg/narc_0041.bin: MSGENCFLAGS = -k 0xc43a
files/msgdata/msg/narc_0042.bin: MSGENCFLAGS = -k 0x4433
files/msgdata/msg/narc_0043.bin: MSGENCFLAGS = -k 0x444b
files/msgdata/msg/narc_0044.bin: MSGENCFLAGS = -k 0x4447
files/msgdata/msg/narc_0045.bin: MSGENCFLAGS = -k 0xc442
files/msgdata/msg/narc_0046.bin: MSGENCFLAGS = -k 0x4c0b
files/msgdata/msg/narc_0047.bin: MSGENCFLAGS = -k 0x479f
files/msgdata/msg/narc_0048.bin: MSGENCFLAGS = -k 0xcad0
files/msgdata/msg/narc_0049.bin: MSGENCFLAGS = -k 0xf96e
files/msgdata/msg/narc_0050.bin: MSGENCFLAGS = -k 0x2bd3
files/msgdata/msg/narc_0051.bin: MSGENCFLAGS = -k 0x7403
files/msgdata/msg/narc_0052.bin: MSGENCFLAGS = -k 0x740f
files/msgdata/msg/narc_0053.bin: MSGENCFLAGS = -k 0x740b
files/msgdata/msg/narc_0054.bin: MSGENCFLAGS = -k 0x741b
files/msgdata/msg/narc_0055.bin: MSGENCFLAGS = -k 0xf412
files/msgdata/msg/narc_0056.bin: MSGENCFLAGS = -k 0x742b
files/msgdata/msg/narc_0057.bin: MSGENCFLAGS = -k 0xf422
files/msgdata/msg/narc_0058.bin: MSGENCFLAGS = -k 0x479b
files/msgdata/msg/narc_0059.bin: MSGENCFLAGS = -k 0x4af1
files/msgdata/msg/narc_0060.bin: MSGENCFLAGS = -k 0x596f
files/msgdata/msg/narc_0061.bin: MSGENCFLAGS = -k 0xabf2
files/msgdata/msg/narc_0062.bin: MSGENCFLAGS = -k 0xabfa
files/msgdata/msg/narc_0063.bin: MSGENCFLAGS = -k 0x6403
files/msgdata/msg/narc_0064.bin: MSGENCFLAGS = -k 0x640f
files/msgdata/msg/narc_0065.bin: MSGENCFLAGS = -k 0x640b
files/msgdata/msg/narc_0066.bin: MSGENCFLAGS = -k 0x6417
files/msgdata/msg/narc_0067.bin: MSGENCFLAGS = -k 0x641b
files/msgdata/msg/narc_0068.bin: MSGENCFLAGS = -k 0x6417
files/msgdata/msg/narc_0069.bin: MSGENCFLAGS = -k 0x6413
files/msgdata/msg/narc_0070.bin: MSGENCFLAGS = -k 0x640f
files/msgdata/msg/narc_0071.bin: MSGENCFLAGS = -k 0xe412
files/msgdata/msg/narc_0072.bin: MSGENCFLAGS = -k 0x642b
files/msgdata/msg/narc_0073.bin: MSGENCFLAGS = -k 0xe422
files/msgdata/msg/narc_0074.bin: MSGENCFLAGS = -k 0xe43a
files/msgdata/msg/narc_0075.bin: MSGENCFLAGS = -k 0xe436
files/msgdata/msg/narc_0076.bin: MSGENCFLAGS = -k 0xe432
files/msgdata/msg/narc_0077.bin: MSGENCFLAGS = -k 0x6433
files/msgdata/msg/narc_0078.bin: MSGENCFLAGS = -k 0x4787
files/msgdata/msg/narc_0079.bin: MSGENCFLAGS = -k 0xca10
files/msgdata/msg/narc_0080.bin: MSGENCFLAGS = -k 0x396e
files/msgdata/msg/narc_0081.bin: MSGENCFLAGS = -k 0x3962
files/msgdata/msg/narc_0082.bin: MSGENCFLAGS = -k 0x2b13
files/msgdata/msg/narc_0083.bin: MSGENCFLAGS = -k 0x2b1f
files/msgdata/msg/narc_0084.bin: MSGENCFLAGS = -k 0x1403
files/msgdata/msg/narc_0085.bin: MSGENCFLAGS = -k 0x141b
files/msgdata/msg/narc_0086.bin: MSGENCFLAGS = -k 0x1417
files/msgdata/msg/narc_0087.bin: MSGENCFLAGS = -k 0x1413
files/msgdata/msg/narc_0088.bin: MSGENCFLAGS = -k 0x140f
files/msgdata/msg/narc_0089.bin: MSGENCFLAGS = -k 0x9412
files/msgdata/msg/narc_0090.bin: MSGENCFLAGS = -k 0x941e
files/msgdata/msg/narc_0091.bin: MSGENCFLAGS = -k 0x941a
files/msgdata/msg/narc_0092.bin: MSGENCFLAGS = -k 0x9406
files/msgdata/msg/narc_0093.bin: MSGENCFLAGS = -k 0x142b
files/msgdata/msg/narc_0094.bin: MSGENCFLAGS = -k 0x9422
files/msgdata/msg/narc_0095.bin: MSGENCFLAGS = -k 0x943a
files/msgdata/msg/narc_0096.bin: MSGENCFLAGS = -k 0x1433
files/msgdata/msg/narc_0097.bin: MSGENCFLAGS = -k 0x144b
files/msgdata/msg/narc_0098.bin: MSGENCFLAGS = -k 0x4783
files/msgdata/msg/narc_0099.bin: MSGENCFLAGS = -k 0x4a31
files/msgdata/msg/narc_0100.bin: MSGENCFLAGS = -k 0x996f
files/msgdata/msg/narc_0101.bin: MSGENCFLAGS = -k 0x997b
files/msgdata/msg/narc_0102.bin: MSGENCFLAGS = -k 0x9973
files/msgdata/msg/narc_0103.bin: MSGENCFLAGS = -k 0x994b
files/msgdata/msg/narc_0104.bin: MSGENCFLAGS = -k 0x9d67
files/msgdata/msg/narc_0105.bin: MSGENCFLAGS = -k 0xab32
files/msgdata/msg/narc_0106.bin: MSGENCFLAGS = -k 0x0403
files/msgdata/msg/narc_0107.bin: MSGENCFLAGS = -k 0x040f
files/msgdata/msg/narc_0108.bin: MSGENCFLAGS = -k 0x040b
files/msgdata/msg/narc_0109.bin: MSGENCFLAGS = -k 0x041b
files/msgdata/msg/narc_0110.bin: MSGENCFLAGS = -k 0x8412
files/msgdata/msg/narc_0111.bin: MSGENCFLAGS = -k 0x042b
files/msgdata/msg/narc_0112.bin: MSGENCFLAGS = -k 0x8422
files/msgdata/msg/narc_0113.bin: MSGENCFLAGS = -k 0x843a
files/msgdata/msg/narc_0114.bin: MSGENCFLAGS = -k 0x0433
files/msgdata/msg/narc_0115.bin: MSGENCFLAGS = -k 0x044b
files/msgdata/msg/narc_0116.bin: MSGENCFLAGS = -k 0x0447
files/msgdata/msg/narc_0117.bin: MSGENCFLAGS = -k 0x0443
files/msgdata/msg/narc_0118.bin: MSGENCFLAGS = -k 0x8442
files/msgdata/msg/narc_0119.bin: MSGENCFLAGS = -k 0x0c0b
files/msgdata/msg/narc_0120.bin: MSGENCFLAGS = -k 0x8c02
files/msgdata/msg/narc_0121.bin: MSGENCFLAGS = -k 0x8c0a
files/msgdata/msg/narc_0122.bin: MSGENCFLAGS = -k 0x8c1a
files/msgdata/msg/narc_0123.bin: MSGENCFLAGS = -k 0x478f
files/msgdata/msg/narc_0124.bin: MSGENCFLAGS = -k 0x4a51
files/msgdata/msg/narc_0125.bin: MSGENCFLAGS = -k 0xf96f
files/msgdata/msg/narc_0126.bin: MSGENCFLAGS = -k 0xab52
files/msgdata/msg/narc_0127.bin: MSGENCFLAGS = -k 0xab5e
files/msgdata/msg/narc_0128.bin: MSGENCFLAGS = -k 0x3403
files/msgdata/msg/narc_0129.bin: MSGENCFLAGS = -k 0x340f
files/msgdata/msg/narc_0130.bin: MSGENCFLAGS = -k 0x341b
files/msgdata/msg/narc_0131.bin: MSGENCFLAGS = -k 0xb412
files/msgdata/msg/narc_0132.bin: MSGENCFLAGS = -k 0x342b
files/msgdata/msg/narc_0133.bin: MSGENCFLAGS = -k 0xb422
files/msgdata/msg/narc_0134.bin: MSGENCFLAGS = -k 0xb43a
files/msgdata/msg/narc_0135.bin: MSGENCFLAGS = -k 0x478b
files/msgdata/msg/narc_0136.bin: MSGENCFLAGS = -k 0x596e
files/msgdata/msg/narc_0137.bin: MSGENCFLAGS = -k 0x2b73
files/msgdata/msg/narc_0138.bin: MSGENCFLAGS = -k 0x2b7b
files/msgdata/msg/narc_0139.bin: MSGENCFLAGS = -k 0x2403
files/msgdata/msg/narc_0140.bin: MSGENCFLAGS = -k 0x241b
files/msgdata/msg/narc_0141.bin: MSGENCFLAGS = -k 0x2417
files/msgdata/msg/narc_0142.bin: MSGENCFLAGS = -k 0x2413
files/msgdata/msg/narc_0143.bin: MSGENCFLAGS = -k 0x240f
files/msgdata/msg/narc_0144.bin: MSGENCFLAGS = -k 0x240b
files/msgdata/msg/narc_0145.bin: MSGENCFLAGS = -k 0x2407
files/msgdata/msg/narc_0146.bin: MSGENCFLAGS = -k 0xa412
files/msgdata/msg/narc_0147.bin: MSGENCFLAGS = -k 0x242b
files/msgdata/msg/narc_0148.bin: MSGENCFLAGS = -k 0xa422
files/msgdata/msg/narc_0149.bin: MSGENCFLAGS = -k 0xa43a
files/msgdata/msg/narc_0150.bin: MSGENCFLAGS = -k 0x2433
files/msgdata/msg/narc_0151.bin: MSGENCFLAGS = -k 0x244b
files/msgdata/msg/narc_0152.bin: MSGENCFLAGS = -k 0xa442
files/msgdata/msg/narc_0153.bin: MSGENCFLAGS = -k 0x47b7
files/msgdata/msg/narc_0154.bin: MSGENCFLAGS = -k 0xcb90
files/msgdata/msg/narc_0155.bin: MSGENCFLAGS = -k 0x396d
files/msgdata/msg/narc_0156.bin: MSGENCFLAGS = -k 0x3965
files/msgdata/msg/narc_0157.bin: MSGENCFLAGS = -k 0x2a93
files/msgdata/msg/narc_0158.bin: MSGENCFLAGS = -k 0xd403
files/msgdata/msg/narc_0159.bin: MSGENCFLAGS = -k 0xd41b
files/msgdata/msg/narc_0160.bin: MSGENCFLAGS = -k 0x5412
files/msgdata/msg/narc_0161.bin: MSGENCFLAGS = -k 0xd42b
files/msgdata/msg/narc_0162.bin: MSGENCFLAGS = -k 0x5422
files/msgdata/msg/narc_0163.bin: MSGENCFLAGS = -k 0x543a
files/msgdata/msg/narc_0164.bin: MSGENCFLAGS = -k 0xd433
files/msgdata/msg/narc_0165.bin: MSGENCFLAGS = -k 0xd44b
files/msgdata/msg/narc_0166.bin: MSGENCFLAGS = -k 0x5442
files/msgdata/msg/narc_0167.bin: MSGENCFLAGS = -k 0x47b3
files/msgdata/msg/narc_0168.bin: MSGENCFLAGS = -k 0x4bb1
files/msgdata/msg/narc_0169.bin: MSGENCFLAGS = -k 0x996c
files/msgdata/msg/narc_0170.bin: MSGENCFLAGS = -k 0xaab2
files/msgdata/msg/narc_0171.bin: MSGENCFLAGS = -k 0xc403
files/msgdata/msg/narc_0172.bin: MSGENCFLAGS = -k 0xc41b
files/msgdata/msg/narc_0173.bin: MSGENCFLAGS = -k 0x4397
files/msgdata/msg/narc_0174.bin: MSGENCFLAGS = -k 0x0b93
files/msgdata/msg/narc_0175.bin: MSGENCFLAGS = -k 0xd422
files/msgdata/msg/narc_0176.bin: MSGENCFLAGS = -k 0xd42a
files/msgdata/msg/narc_0177.bin: MSGENCFLAGS = -k 0xd432
files/msgdata/msg/narc_0178.bin: MSGENCFLAGS = -k 0xd43a
files/msgdata/msg/narc_0179.bin: MSGENCFLAGS = -k 0xd402
files/msgdata/msg/narc_0180.bin: MSGENCFLAGS = -k 0xd022
files/msgdata/msg/narc_0181.bin: MSGENCFLAGS = -k 0xd02e
files/msgdata/msg/narc_0182.bin: MSGENCFLAGS = -k 0xd02a
files/msgdata/msg/narc_0183.bin: MSGENCFLAGS = -k 0x4393
files/msgdata/msg/narc_0184.bin: MSGENCFLAGS = -k 0x6ab1
files/msgdata/msg/narc_0185.bin: MSGENCFLAGS = -k 0x8bb2
files/msgdata/msg/narc_0186.bin: MSGENCFLAGS = -k 0xc422
files/msgdata/msg/narc_0187.bin: MSGENCFLAGS = -k 0xc43a
files/msgdata/msg/narc_0188.bin: MSGENCFLAGS = -k 0x4433
files/msgdata/msg/narc_0189.bin: MSGENCFLAGS = -k 0xc40a
files/msgdata/msg/narc_0190.bin: MSGENCFLAGS = -k 0xa69c
files/msgdata/msg/narc_0191.bin: MSGENCFLAGS = -k 0xa8f9
files/msgdata/msg/narc_0192.bin: MSGENCFLAGS = -k 0x817d
files/msgdata/msg/narc_0193.bin: MSGENCFLAGS = -k 0xe905
files/msgdata/msg/narc_0194.bin: MSGENCFLAGS = -k 0x59b5
files/msgdata/msg/narc_0195.bin: MSGENCFLAGS = -k 0x0033
files/msgdata/msg/narc_0196.bin: MSGENCFLAGS = -k 0x5c96
files/msgdata/msg/narc_0197.bin: MSGENCFLAGS = -k 0x9542
files/msgdata/msg/narc_0198.bin: MSGENCFLAGS = -k 0x9fd6
files/msgdata/msg/narc_0199.bin: MSGENCFLAGS = -k 0xd8d3
files/msgdata/msg/narc_0200.bin: MSGENCFLAGS = -k 0x6eb8
files/msgdata/msg/narc_0201.bin: MSGENCFLAGS = -k 0x5626
files/msgdata/msg/narc_0202.bin: MSGENCFLAGS = -k 0x4c39
files/msgdata/msg/narc_0203.bin: MSGENCFLAGS = -k 0xeeb2
files/msgdata/msg/narc_0204.bin: MSGENCFLAGS = -k 0xcaff
files/msgdata/msg/narc_0205.bin: MSGENCFLAGS = -k 0x5f5c
files/msgdata/msg/narc_0206.bin: MSGENCFLAGS = -k 0xb90f
files/msgdata/msg/narc_0207.bin: MSGENCFLAGS = -k 0x5e05
files/msgdata/msg/narc_0208.bin: MSGENCFLAGS = -k 0x2402
files/msgdata/msg/narc_0209.bin: MSGENCFLAGS = -k 0x240e
files/msgdata/msg/narc_0210.bin: MSGENCFLAGS = -k 0xc7a6
files/msgdata/msg/narc_0211.bin: MSGENCFLAGS = -k 0x1402
files/msgdata/msg/narc_0212.bin: MSGENCFLAGS = -k 0xc7a2
files/msgdata/msg/narc_0213.bin: MSGENCFLAGS = -k 0x0402
files/msgdata/msg/narc_0214.bin: MSGENCFLAGS = -k 0xc7be
files/msgdata/msg/narc_0215.bin: MSGENCFLAGS = -k 0x7402
files/msgdata/msg/narc_0216.bin: MSGENCFLAGS = -k 0x6402
files/msgdata/msg/narc_0217.bin: MSGENCFLAGS = -k 0x640e
files/msgdata/msg/narc_0218.bin: MSGENCFLAGS = -k 0x6006
files/msgdata/msg/narc_0219.bin: MSGENCFLAGS = -k 0x600e
files/msgdata/msg/narc_0220.bin: MSGENCFLAGS = -k 0x6016
files/msgdata/msg/narc_0221.bin: MSGENCFLAGS = -k 0x601e
files/msgdata/msg/narc_0222.bin: MSGENCFLAGS = -k 0x5402
files/msgdata/msg/narc_0223.bin: MSGENCFLAGS = -k 0x541a
files/msgdata/msg/narc_0224.bin: MSGENCFLAGS = -k 0x5416
files/msgdata/msg/narc_0225.bin: MSGENCFLAGS = -k 0x5412
files/msgdata/msg/narc_0226.bin: MSGENCFLAGS = -k 0x540e
files/msgdata/msg/narc_0227.bin: MSGENCFLAGS = -k 0x540a
files/msgdata/msg/narc_0228.bin: MSGENCFLAGS = -k 0x5406
files/msgdata/msg/narc_0229.bin: MSGENCFLAGS = -k 0x4402
files/msgdata/msg/narc_0230.bin: MSGENCFLAGS = -k 0x440e
files/msgdata/msg/narc_0231.bin: MSGENCFLAGS = -k 0x4412
files/msgdata/msg/narc_0232.bin: MSGENCFLAGS = -k 0x401e
files/msgdata/msg/narc_0233.bin: MSGENCFLAGS = -k 0xa402
files/msgdata/msg/narc_0234.bin: MSGENCFLAGS = -k 0xa416
files/msgdata/msg/narc_0235.bin: MSGENCFLAGS = -k 0xb423
files/msgdata/msg/narc_0236.bin: MSGENCFLAGS = -k 0xa423
files/msgdata/msg/narc_0237.bin: MSGENCFLAGS = -k 0xc3a2
files/msgdata/msg/narc_0238.bin: MSGENCFLAGS = -k 0x8423
files/msgdata/msg/narc_0239.bin: MSGENCFLAGS = -k 0x842f
files/msgdata/msg/narc_0240.bin: MSGENCFLAGS = -k 0xf423
files/msgdata/msg/narc_0241.bin: MSGENCFLAGS = -k 0xf42f
files/msgdata/msg/narc_0242.bin: MSGENCFLAGS = -k 0xc3ba
files/msgdata/msg/narc_0243.bin: MSGENCFLAGS = -k 0xe423
files/msgdata/msg/narc_0244.bin: MSGENCFLAGS = -k 0xc3b6
files/msgdata/msg/narc_0245.bin: MSGENCFLAGS = -k 0xd423
files/msgdata/msg/narc_0246.bin: MSGENCFLAGS = -k 0xd42f
files/msgdata/msg/narc_0247.bin: MSGENCFLAGS = -k 0xd42b
files/msgdata/msg/narc_0248.bin: MSGENCFLAGS = -k 0xc42f
files/msgdata/msg/narc_0249.bin: MSGENCFLAGS = -k 0xc42b
files/msgdata/msg/narc_0250.bin: MSGENCFLAGS = -k 0xc437
files/msgdata/msg/narc_0251.bin: MSGENCFLAGS = -k 0xc38e
files/msgdata/msg/narc_0252.bin: MSGENCFLAGS = -k 0xb45f
files/msgdata/msg/narc_0253.bin: MSGENCFLAGS = -k 0xa443
files/msgdata/msg/narc_0254.bin: MSGENCFLAGS = -k 0x9443
files/msgdata/msg/narc_0255.bin: MSGENCFLAGS = -k 0x944f
files/msgdata/msg/narc_0256.bin: MSGENCFLAGS = -k 0x944b
files/msgdata/msg/narc_0257.bin: MSGENCFLAGS = -k 0xcfbe
files/msgdata/msg/narc_0258.bin: MSGENCFLAGS = -k 0xf453
files/msgdata/msg/narc_0259.bin: MSGENCFLAGS = -k 0xf45b
files/msgdata/msg/narc_0260.bin: MSGENCFLAGS = -k 0xe443
files/msgdata/msg/narc_0261.bin: MSGENCFLAGS = -k 0xe45f
files/msgdata/msg/narc_0262.bin: MSGENCFLAGS = -k 0xd443
files/msgdata/msg/narc_0263.bin: MSGENCFLAGS = -k 0xd44f
files/msgdata/msg/narc_0264.bin: MSGENCFLAGS = -k 0xd44b
files/msgdata/msg/narc_0265.bin: MSGENCFLAGS = -k 0xd457
files/msgdata/msg/narc_0266.bin: MSGENCFLAGS = -k 0xd453
files/msgdata/msg/narc_0267.bin: MSGENCFLAGS = -k 0xd45f
files/msgdata/msg/narc_0268.bin: MSGENCFLAGS = -k 0xd45b
files/msgdata/msg/narc_0269.bin: MSGENCFLAGS = -k 0xd467
files/msgdata/msg/narc_0270.bin: MSGENCFLAGS = -k 0xc443
files/msgdata/msg/narc_0271.bin: MSGENCFLAGS = -k 0xc44f
files/msgdata/msg/narc_0272.bin: MSGENCFLAGS = -k 0xc44b
files/msgdata/msg/narc_0273.bin: MSGENCFLAGS = -k 0x3443
files/msgdata/msg/narc_0274.bin: MSGENCFLAGS = -k 0x344f
files/msgdata/msg/narc_0275.bin: MSGENCFLAGS = -k 0x344b
files/msgdata/msg/narc_0276.bin: MSGENCFLAGS = -k 0x2443
files/msgdata/msg/narc_0277.bin: MSGENCFLAGS = -k 0x244f
files/msgdata/msg/narc_0278.bin: MSGENCFLAGS = -k 0x244b
files/msgdata/msg/narc_0279.bin: MSGENCFLAGS = -k 0xcbae
files/msgdata/msg/narc_0280.bin: MSGENCFLAGS = -k 0x3462
files/msgdata/msg/narc_0281.bin: MSGENCFLAGS = -k 0xcbaa
files/msgdata/msg/narc_0282.bin: MSGENCFLAGS = -k 0x2462
files/msgdata/msg/narc_0283.bin: MSGENCFLAGS = -k 0x247a
files/msgdata/msg/narc_0284.bin: MSGENCFLAGS = -k 0x246a
files/msgdata/msg/narc_0285.bin: MSGENCFLAGS = -k 0x2466
files/msgdata/msg/narc_0286.bin: MSGENCFLAGS = -k 0x2462
files/msgdata/msg/narc_0287.bin: MSGENCFLAGS = -k 0xeac3
files/msgdata/msg/narc_0288.bin: MSGENCFLAGS = -k 0x7852
files/msgdata/msg/narc_0289.bin: MSGENCFLAGS = -k 0xbaed
files/msgdata/msg/narc_0290.bin: MSGENCFLAGS = -k 0x770e
files/msgdata/msg/narc_0291.bin: MSGENCFLAGS = -k 0x66d4
files/msgdata/msg/narc_0292.bin: MSGENCFLAGS = -k 0xca9d
files/msgdata/msg/narc_0293.bin: MSGENCFLAGS = -k 0x0ed8
files/msgdata/msg/narc_0294.bin: MSGENCFLAGS = -k 0x547e
files/msgdata/msg/narc_0295.bin: MSGENCFLAGS = -k 0x103c
files/msgdata/msg/narc_0296.bin: MSGENCFLAGS = -k 0x6e7b
files/msgdata/msg/narc_0297.bin: MSGENCFLAGS = -k 0x2ecc
files/msgdata/msg/narc_0298.bin: MSGENCFLAGS = -k 0x0bce
files/msgdata/msg/narc_0299.bin: MSGENCFLAGS = -k 0xb29b
files/msgdata/msg/narc_0300.bin: MSGENCFLAGS = -k 0xc56b
files/msgdata/msg/narc_0301.bin: MSGENCFLAGS = -k 0x4eec
files/msgdata/msg/narc_0302.bin: MSGENCFLAGS = -k 0xbb13
files/msgdata/msg/narc_0303.bin: MSGENCFLAGS = -k 0x491e
files/msgdata/msg/narc_0304.bin: MSGENCFLAGS = -k 0xe278
files/msgdata/msg/narc_0305.bin: MSGENCFLAGS = -k 0xca9c
files/msgdata/msg/narc_0306.bin: MSGENCFLAGS = -k 0xe9af
files/msgdata/msg/narc_0307.bin: MSGENCFLAGS = -k 0x16e9
files/msgdata/msg/narc_0308.bin: MSGENCFLAGS = -k 0xb4b2
files/msgdata/msg/narc_0309.bin: MSGENCFLAGS = -k 0x3d9b
files/msgdata/msg/narc_0310.bin: MSGENCFLAGS = -k 0xd790
files/msgdata/msg/narc_0311.bin: MSGENCFLAGS = -k 0xef78
files/msgdata/msg/narc_0312.bin: MSGENCFLAGS = -k 0x05bf
files/msgdata/msg/narc_0313.bin: MSGENCFLAGS = -k 0x6b7a
files/msgdata/msg/narc_0314.bin: MSGENCFLAGS = -k 0x0d41
files/msgdata/msg/narc_0315.bin: MSGENCFLAGS = -k 0xf619
files/msgdata/msg/narc_0316.bin: MSGENCFLAGS = -k 0x6323
files/msgdata/msg/narc_0317.bin: MSGENCFLAGS = -k 0x6759
files/msgdata/msg/narc_0318.bin: MSGENCFLAGS = -k 0x923c
files/msgdata/msg/narc_0319.bin: MSGENCFLAGS = -k 0xbbe6
files/msgdata/msg/narc_0320.bin: MSGENCFLAGS = -k 0xe6e4
files/msgdata/msg/narc_0321.bin: MSGENCFLAGS = -k 0x5031
files/msgdata/msg/narc_0322.bin: MSGENCFLAGS = -k 0x2e3d
files/msgdata/msg/narc_0323.bin: MSGENCFLAGS = -k 0xd3a0
files/msgdata/msg/narc_0324.bin: MSGENCFLAGS = -k 0xbaf4
files/msgdata/msg/narc_0325.bin: MSGENCFLAGS = -k 0xa206
files/msgdata/msg/narc_0326.bin: MSGENCFLAGS = -k 0x12e7
files/msgdata/msg/narc_0327.bin: MSGENCFLAGS = -k 0x90d0
files/msgdata/msg/narc_0328.bin: MSGENCFLAGS = -k 0xa06b
files/msgdata/msg/narc_0329.bin: MSGENCFLAGS = -k 0x8e95
files/msgdata/msg/narc_0330.bin: MSGENCFLAGS = -k 0x56f9
files/msgdata/msg/narc_0331.bin: MSGENCFLAGS = -k 0x082e
files/msgdata/msg/narc_0332.bin: MSGENCFLAGS = -k 0xb330
files/msgdata/msg/narc_0333.bin: MSGENCFLAGS = -k 0x4f58
files/msgdata/msg/narc_0334.bin: MSGENCFLAGS = -k 0x9644
files/msgdata/msg/narc_0335.bin: MSGENCFLAGS = -k 0x08ef
files/msgdata/msg/narc_0336.bin: MSGENCFLAGS = -k 0xc019
files/msgdata/msg/narc_0337.bin: MSGENCFLAGS = -k 0x0cad
files/msgdata/msg/narc_0338.bin: MSGENCFLAGS = -k 0x7b4d
files/msgdata/msg/narc_0339.bin: MSGENCFLAGS = -k 0xe4a5
files/msgdata/msg/narc_0340.bin: MSGENCFLAGS = -k 0x141f
files/msgdata/msg/narc_0341.bin: MSGENCFLAGS = -k 0xf2d0
files/msgdata/msg/narc_0342.bin: MSGENCFLAGS = -k 0x3fe6
files/msgdata/msg/narc_0343.bin: MSGENCFLAGS = -k 0x5efc
files/msgdata/msg/narc_0344.bin: MSGENCFLAGS = -k 0xcaad
files/msgdata/msg/narc_0345.bin: MSGENCFLAGS = -k 0x9f20
files/msgdata/msg/narc_0346.bin: MSGENCFLAGS = -k 0xa320
files/msgdata/msg/narc_0347.bin: MSGENCFLAGS = -k 0x2bad
files/msgdata/msg/narc_0348.bin: MSGENCFLAGS = -k 0xd6dc
files/msgdata/msg/narc_0349.bin: MSGENCFLAGS = -k 0x49b2
files/msgdata/msg/narc_0350.bin: MSGENCFLAGS = -k 0x291f
files/msgdata/msg/narc_0351.bin: MSGENCFLAGS = -k 0x110a
files/msgdata/msg/narc_0352.bin: MSGENCFLAGS = -k 0x47eb
files/msgdata/msg/narc_0353.bin: MSGENCFLAGS = -k 0x2400
files/msgdata/msg/narc_0354.bin: MSGENCFLAGS = -k 0x47e7
files/msgdata/msg/narc_0355.bin: MSGENCFLAGS = -k 0x1400
files/msgdata/msg/narc_0356.bin: MSGENCFLAGS = -k 0x1418
files/msgdata/msg/narc_0357.bin: MSGENCFLAGS = -k 0x9411
files/msgdata/msg/narc_0358.bin: MSGENCFLAGS = -k 0x47e3
files/msgdata/msg/narc_0359.bin: MSGENCFLAGS = -k 0x4754
files/msgdata/msg/narc_0360.bin: MSGENCFLAGS = -k 0x1fbc
files/msgdata/msg/narc_0361.bin: MSGENCFLAGS = -k 0xe814
files/msgdata/msg/narc_0362.bin: MSGENCFLAGS = -k 0x782c
files/msgdata/msg/narc_0363.bin: MSGENCFLAGS = -k 0xe921
files/msgdata/msg/narc_0364.bin: MSGENCFLAGS = -k 0xe25c
files/msgdata/msg/narc_0365.bin: MSGENCFLAGS = -k 0x80e3
files/msgdata/msg/narc_0366.bin: MSGENCFLAGS = -k 0x80ef
files/msgdata/msg/narc_0367.bin: MSGENCFLAGS = -k 0x80eb
files/msgdata/msg/narc_0368.bin: MSGENCFLAGS = -k 0x80f7
files/msgdata/msg/narc_0369.bin: MSGENCFLAGS = -k 0x8896
files/msgdata/msg/narc_0370.bin: MSGENCFLAGS = -k 0x2a22
files/msgdata/msg/narc_0371.bin: MSGENCFLAGS = -k 0x71d3
files/msgdata/msg/narc_0372.bin: MSGENCFLAGS = -k 0xa004
files/msgdata/msg/narc_0373.bin: MSGENCFLAGS = -k 0x3455
files/msgdata/msg/narc_0374.bin: MSGENCFLAGS = -k 0xd9ae
files/msgdata/msg/narc_0375.bin: MSGENCFLAGS = -k 0x1b1a
files/msgdata/msg/narc_0376.bin: MSGENCFLAGS = -k 0xe7e1
files/msgdata/msg/narc_0377.bin: MSGENCFLAGS = -k 0x1605
files/msgdata/msg/narc_0378.bin: MSGENCFLAGS = -k 0x9935
files/msgdata/msg/narc_0379.bin: MSGENCFLAGS = -k 0x0639
files/msgdata/msg/narc_0380.bin: MSGENCFLAGS = -k 0x670d
files/msgdata/msg/narc_0381.bin: MSGENCFLAGS = -k 0xa782
files/msgdata/msg/narc_0382.bin: MSGENCFLAGS = -k 0x0a06
files/msgdata/msg/narc_0383.bin: MSGENCFLAGS = -k 0x5c7d
files/msgdata/msg/narc_0384.bin: MSGENCFLAGS = -k 0x1078
files/msgdata/msg/narc_0385.bin: MSGENCFLAGS = -k 0xa375
files/msgdata/msg/narc_0386.bin: MSGENCFLAGS = -k 0x909b
files/msgdata/msg/narc_0387.bin: MSGENCFLAGS = -k 0x3dce
files/msgdata/msg/narc_0388.bin: MSGENCFLAGS = -k 0xfba6
files/msgdata/msg/narc_0389.bin: MSGENCFLAGS = -k 0xfba2
files/msgdata/msg/narc_0390.bin: MSGENCFLAGS = -k 0xfb9e
files/msgdata/msg/narc_0391.bin: MSGENCFLAGS = -k 0xfb9a
files/msgdata/msg/narc_0392.bin: MSGENCFLAGS = -k 0xffbe
files/msgdata/msg/narc_0393.bin: MSGENCFLAGS = -k 0xffba
files/msgdata/msg/narc_0394.bin: MSGENCFLAGS = -k 0xffb6
files/msgdata/msg/narc_0395.bin: MSGENCFLAGS = -k 0xdb06
files/msgdata/msg/narc_0396.bin: MSGENCFLAGS = -k 0xbb16
files/msgdata/msg/narc_0397.bin: MSGENCFLAGS = -k 0x16e5
files/msgdata/msg/narc_0398.bin: MSGENCFLAGS = -k 0x6289
files/msgdata/msg/narc_0399.bin: MSGENCFLAGS = -k 0x08f7
files/msgdata/msg/narc_0400.bin: MSGENCFLAGS = -k 0xe9a2
files/msgdata/msg/narc_0401.bin: MSGENCFLAGS = -k 0x3854
files/msgdata/msg/narc_0402.bin: MSGENCFLAGS = -k 0xe14e
files/msgdata/msg/narc_0403.bin: MSGENCFLAGS = -k 0x5198
files/msgdata/msg/narc_0404.bin: MSGENCFLAGS = -k 0xb047
files/msgdata/msg/narc_0405.bin: MSGENCFLAGS = -k 0x0d4f
files/msgdata/msg/narc_0406.bin: MSGENCFLAGS = -k 0x62b7
files/msgdata/msg/narc_0407.bin: MSGENCFLAGS = -k 0x3a19
files/msgdata/msg/narc_0408.bin: MSGENCFLAGS = -k 0xcd8e
files/msgdata/msg/narc_0409.bin: MSGENCFLAGS = -k 0xbf7a
files/msgdata/msg/narc_0410.bin: MSGENCFLAGS = -k 0x0f58
files/msgdata/msg/narc_0411.bin: MSGENCFLAGS = -k 0x8bdc
files/msgdata/msg/narc_0412.bin: MSGENCFLAGS = -k 0x24ff
files/msgdata/msg/narc_0413.bin: MSGENCFLAGS = -k 0x0165
files/msgdata/msg/narc_0414.bin: MSGENCFLAGS = -k 0x7b00
files/msgdata/msg/narc_0415.bin: MSGENCFLAGS = -k 0x9e9c
files/msgdata/msg/narc_0416.bin: MSGENCFLAGS = -k 0x9e90
files/msgdata/msg/narc_0417.bin: MSGENCFLAGS = -k 0x9e94
files/msgdata/msg/narc_0418.bin: MSGENCFLAGS = -k 0x097e
files/msgdata/msg/narc_0419.bin: MSGENCFLAGS = -k 0x0972
files/msgdata/msg/narc_0420.bin: MSGENCFLAGS = -k 0x0d7e
files/msgdata/msg/narc_0421.bin: MSGENCFLAGS = -k 0x7254
files/msgdata/msg/narc_0422.bin: MSGENCFLAGS = -k 0x0d72
files/msgdata/msg/narc_0423.bin: MSGENCFLAGS = -k 0x9e80
files/msgdata/msg/narc_0424.bin: MSGENCFLAGS = -k 0x8eca
files/msgdata/msg/narc_0425.bin: MSGENCFLAGS = -k 0x8ed2
files/msgdata/msg/narc_0426.bin: MSGENCFLAGS = -k 0x9e84
files/msgdata/msg/narc_0427.bin: MSGENCFLAGS = -k 0x9eb8
files/msgdata/msg/narc_0428.bin: MSGENCFLAGS = -k 0x6eca
files/msgdata/msg/narc_0429.bin: MSGENCFLAGS = -k 0x9ebc
files/msgdata/msg/narc_0430.bin: MSGENCFLAGS = -k 0x7eca
files/msgdata/msg/narc_0431.bin: MSGENCFLAGS = -k 0x7eda
files/msgdata/msg/narc_0432.bin: MSGENCFLAGS = -k 0x9977
files/msgdata/msg/narc_0433.bin: MSGENCFLAGS = -k 0xd2f5
files/msgdata/msg/narc_0434.bin: MSGENCFLAGS = -k 0x997b
files/msgdata/msg/narc_0435.bin: MSGENCFLAGS = -k 0xe2f5
files/msgdata/msg/narc_0436.bin: MSGENCFLAGS = -k 0x9d77
files/msgdata/msg/narc_0437.bin: MSGENCFLAGS = -k 0x9d7b
files/msgdata/msg/narc_0438.bin: MSGENCFLAGS = -k 0x9177
files/msgdata/msg/narc_0439.bin: MSGENCFLAGS = -k 0x52b4
files/msgdata/msg/narc_0440.bin: MSGENCFLAGS = -k 0x52b8
files/msgdata/msg/narc_0441.bin: MSGENCFLAGS = -k 0x52bc
files/msgdata/msg/narc_0442.bin: MSGENCFLAGS = -k 0x917b
files/msgdata/msg/narc_0443.bin: MSGENCFLAGS = -k 0x62b4
files/msgdata/msg/narc_0444.bin: MSGENCFLAGS = -k 0x9a94
files/msgdata/msg/narc_0445.bin: MSGENCFLAGS = -k 0x5eeb
files/msgdata/msg/narc_0446.bin: MSGENCFLAGS = -k 0x5ef3
files/msgdata/msg/narc_0447.bin: MSGENCFLAGS = -k 0xdefa
files/msgdata/msg/narc_0448.bin: MSGENCFLAGS = -k 0x5ec3
files/msgdata/msg/narc_0449.bin: MSGENCFLAGS = -k 0xdeca
files/msgdata/msg/narc_0450.bin: MSGENCFLAGS = -k 0xded2
files/msgdata/msg/narc_0451.bin: MSGENCFLAGS = -k 0x9a88
files/msgdata/msg/narc_0452.bin: MSGENCFLAGS = -k 0x2eeb
files/msgdata/msg/narc_0453.bin: MSGENCFLAGS = -k 0x9a8c
files/msgdata/msg/narc_0454.bin: MSGENCFLAGS = -k 0x9a80
files/msgdata/msg/narc_0455.bin: MSGENCFLAGS = -k 0x0eeb
files/msgdata/msg/narc_0456.bin: MSGENCFLAGS = -k 0x9a84
files/msgdata/msg/narc_0457.bin: MSGENCFLAGS = -k 0x1eeb
files/msgdata/msg/narc_0458.bin: MSGENCFLAGS = -k 0x1ef3
files/msgdata/msg/narc_0459.bin: MSGENCFLAGS = -k 0x9ab8
files/msgdata/msg/narc_0460.bin: MSGENCFLAGS = -k 0xeeeb
files/msgdata/msg/narc_0461.bin: MSGENCFLAGS = -k 0xeef3
files/msgdata/msg/narc_0462.bin: MSGENCFLAGS = -k 0x9abc
files/msgdata/msg/narc_0463.bin: MSGENCFLAGS = -k 0x969c
files/msgdata/msg/narc_0464.bin: MSGENCFLAGS = -k 0x7e8b
files/msgdata/msg/narc_0465.bin: MSGENCFLAGS = -k 0x7e93
files/msgdata/msg/narc_0466.bin: MSGENCFLAGS = -k 0x9690
files/msgdata/msg/narc_0467.bin: MSGENCFLAGS = -k 0x4e8b
files/msgdata/msg/narc_0468.bin: MSGENCFLAGS = -k 0x4e93
files/msgdata/msg/narc_0469.bin: MSGENCFLAGS = -k 0xce9a
files/msgdata/msg/narc_0470.bin: MSGENCFLAGS = -k 0x9688
files/msgdata/msg/narc_0471.bin: MSGENCFLAGS = -k 0x968c
files/msgdata/msg/narc_0472.bin: MSGENCFLAGS = -k 0x3e8b
files/msgdata/msg/narc_0473.bin: MSGENCFLAGS = -k 0x9680
files/msgdata/msg/narc_0474.bin: MSGENCFLAGS = -k 0x9684
files/msgdata/msg/narc_0475.bin: MSGENCFLAGS = -k 0x1e8b
files/msgdata/msg/narc_0476.bin: MSGENCFLAGS = -k 0x96b8
files/msgdata/msg/narc_0477.bin: MSGENCFLAGS = -k 0xee8b
files/msgdata/msg/narc_0478.bin: MSGENCFLAGS = -k 0xee93
files/msgdata/msg/narc_0479.bin: MSGENCFLAGS = -k 0x6e9a
files/msgdata/msg/narc_0480.bin: MSGENCFLAGS = -k 0x96bc
files/msgdata/msg/narc_0481.bin: MSGENCFLAGS = -k 0xa009
files/msgdata/msg/narc_0482.bin: MSGENCFLAGS = -k 0xade9
files/msgdata/msg/narc_0483.bin: MSGENCFLAGS = -k 0xb5a8
files/msgdata/msg/narc_0484.bin: MSGENCFLAGS = -k 0xd169
files/msgdata/msg/narc_0485.bin: MSGENCFLAGS = -k 0x15ec
files/msgdata/msg/narc_0486.bin: MSGENCFLAGS = -k 0x3160
files/msgdata/msg/narc_0487.bin: MSGENCFLAGS = -k 0xbb17
files/msgdata/msg/narc_0488.bin: MSGENCFLAGS = -k 0xe94a
files/msgdata/msg/narc_0489.bin: MSGENCFLAGS = -k 0x697b
files/msgdata/msg/narc_0490.bin: MSGENCFLAGS = -k 0x32ad
files/msgdata/msg/narc_0491.bin: MSGENCFLAGS = -k 0xaba7
files/msgdata/msg/narc_0492.bin: MSGENCFLAGS = -k 0x993a
files/msgdata/msg/narc_0493.bin: MSGENCFLAGS = -k 0xaa22
files/msgdata/msg/narc_0494.bin: MSGENCFLAGS = -k 0x9764
files/msgdata/msg/narc_0495.bin: MSGENCFLAGS = -k 0x307c
files/msgdata/msg/narc_0496.bin: MSGENCFLAGS = -k 0x49b7
files/msgdata/msg/narc_0497.bin: MSGENCFLAGS = -k 0x2b0a
files/msgdata/msg/narc_0498.bin: MSGENCFLAGS = -k 0x472b
files/msgdata/msg/narc_0499.bin: MSGENCFLAGS = -k 0x2406
files/msgdata/msg/narc_0500.bin: MSGENCFLAGS = -k 0x240a
files/msgdata/msg/narc_0501.bin: MSGENCFLAGS = -k 0x241e
files/msgdata/msg/narc_0502.bin: MSGENCFLAGS = -k 0x2412
files/msgdata/msg/narc_0503.bin: MSGENCFLAGS = -k 0xa417
files/msgdata/msg/narc_0504.bin: MSGENCFLAGS = -k 0x242e
files/msgdata/msg/narc_0505.bin: MSGENCFLAGS = -k 0x4727
files/msgdata/msg/narc_0506.bin: MSGENCFLAGS = -k 0xcf10
files/msgdata/msg/narc_0507.bin: MSGENCFLAGS = -k 0x2e13
files/msgdata/msg/narc_0508.bin: MSGENCFLAGS = -k 0x2e1f
files/msgdata/msg/narc_0509.bin: MSGENCFLAGS = -k 0x1406
files/msgdata/msg/narc_0510.bin: MSGENCFLAGS = -k 0x141e
files/msgdata/msg/narc_0511.bin: MSGENCFLAGS = -k 0x1412
files/msgdata/msg/narc_0512.bin: MSGENCFLAGS = -k 0x9417
files/msgdata/msg/narc_0513.bin: MSGENCFLAGS = -k 0x4723
files/msgdata/msg/narc_0514.bin: MSGENCFLAGS = -k 0x4f31
files/msgdata/msg/narc_0515.bin: MSGENCFLAGS = -k 0xae32
files/msgdata/msg/narc_0516.bin: MSGENCFLAGS = -k 0x0406
files/msgdata/msg/narc_0517.bin: MSGENCFLAGS = -k 0x041e
files/msgdata/msg/narc_0518.bin: MSGENCFLAGS = -k 0x8417
files/msgdata/msg/narc_0519.bin: MSGENCFLAGS = -k 0x473f
files/msgdata/msg/narc_0520.bin: MSGENCFLAGS = -k 0xcfd0
files/msgdata/msg/narc_0521.bin: MSGENCFLAGS = -k 0x2ed3
files/msgdata/msg/narc_0522.bin: MSGENCFLAGS = -k 0x7406
files/msgdata/msg/narc_0523.bin: MSGENCFLAGS = -k 0x741e
files/msgdata/msg/narc_0524.bin: MSGENCFLAGS = -k 0xf417
files/msgdata/msg/narc_0525.bin: MSGENCFLAGS = -k 0x742e
files/msgdata/msg/narc_0526.bin: MSGENCFLAGS = -k 0xf427
files/msgdata/msg/narc_0527.bin: MSGENCFLAGS = -k 0x473b
files/msgdata/msg/narc_0528.bin: MSGENCFLAGS = -k 0xaef2
files/msgdata/msg/narc_0529.bin: MSGENCFLAGS = -k 0x6406
files/msgdata/msg/narc_0530.bin: MSGENCFLAGS = -k 0x641e
files/msgdata/msg/narc_0531.bin: MSGENCFLAGS = -k 0xe417
files/msgdata/msg/narc_0532.bin: MSGENCFLAGS = -k 0x642e
files/msgdata/msg/narc_0533.bin: MSGENCFLAGS = -k 0xe427
files/msgdata/msg/narc_0534.bin: MSGENCFLAGS = -k 0x4737
files/msgdata/msg/narc_0535.bin: MSGENCFLAGS = -k 0x4f91
files/msgdata/msg/narc_0536.bin: MSGENCFLAGS = -k 0xae92
files/msgdata/msg/narc_0537.bin: MSGENCFLAGS = -k 0x5406
files/msgdata/msg/narc_0538.bin: MSGENCFLAGS = -k 0x541e
files/msgdata/msg/narc_0539.bin: MSGENCFLAGS = -k 0xd417
files/msgdata/msg/narc_0540.bin: MSGENCFLAGS = -k 0x4733
files/msgdata/msg/narc_0541.bin: MSGENCFLAGS = -k 0xcfb0
files/msgdata/msg/narc_0542.bin: MSGENCFLAGS = -k 0x2eb3
files/msgdata/msg/narc_0543.bin: MSGENCFLAGS = -k 0x4406
files/msgdata/msg/narc_0544.bin: MSGENCFLAGS = -k 0x440a
files/msgdata/msg/narc_0545.bin: MSGENCFLAGS = -k 0x440e
files/msgdata/msg/narc_0546.bin: MSGENCFLAGS = -k 0x441e
files/msgdata/msg/narc_0547.bin: MSGENCFLAGS = -k 0xc417
files/msgdata/msg/narc_0548.bin: MSGENCFLAGS = -k 0x1311
files/msgdata/msg/narc_0549.bin: MSGENCFLAGS = -k 0x5fbd
files/msgdata/msg/narc_0550.bin: MSGENCFLAGS = -k 0xd916
files/msgdata/msg/narc_0551.bin: MSGENCFLAGS = -k 0x3329
files/msgdata/msg/narc_0552.bin: MSGENCFLAGS = -k 0x1c70
files/msgdata/msg/narc_0553.bin: MSGENCFLAGS = -k 0xc452
files/msgdata/msg/narc_0554.bin: MSGENCFLAGS = -k 0x6844
files/msgdata/msg/narc_0555.bin: MSGENCFLAGS = -k 0x069b
files/msgdata/msg/narc_0556.bin: MSGENCFLAGS = -k 0xd524
files/msgdata/msg/narc_0557.bin: MSGENCFLAGS = -k 0x409e
files/msgdata/msg/narc_0558.bin: MSGENCFLAGS = -k 0x17e8
files/msgdata/msg/narc_0559.bin: MSGENCFLAGS = -k 0xd8ed
files/msgdata/msg/narc_0560.bin: MSGENCFLAGS = -k 0xfc2c
files/msgdata/msg/narc_0561.bin: MSGENCFLAGS = -k 0x7924
files/msgdata/msg/narc_0562.bin: MSGENCFLAGS = -k 0x44be
files/msgdata/msg/narc_0563.bin: MSGENCFLAGS = -k 0xc550
files/msgdata/msg/narc_0564.bin: MSGENCFLAGS = -k 0x61cf
files/msgdata/msg/narc_0565.bin: MSGENCFLAGS = -k 0x3b89
files/msgdata/msg/narc_0566.bin: MSGENCFLAGS = -k 0x111a
files/msgdata/msg/narc_0567.bin: MSGENCFLAGS = -k 0x3043
files/msgdata/msg/narc_0568.bin: MSGENCFLAGS = -k 0x489e
files/msgdata/msg/narc_0569.bin: MSGENCFLAGS = -k 0xfccd
files/msgdata/msg/narc_0570.bin: MSGENCFLAGS = -k 0x7aa0
files/msgdata/msg/narc_0571.bin: MSGENCFLAGS = -k 0x0489
files/msgdata/msg/narc_0572.bin: MSGENCFLAGS = -k 0x9bb6
files/msgdata/msg/narc_0573.bin: MSGENCFLAGS = -k 0x73b6
files/msgdata/msg/narc_0574.bin: MSGENCFLAGS = -k 0xf7ec
files/msgdata/msg/narc_0575.bin: MSGENCFLAGS = -k 0x945a
files/msgdata/msg/narc_0576.bin: MSGENCFLAGS = -k 0x87fc
files/msgdata/msg/narc_0577.bin: MSGENCFLAGS = -k 0x27f8
files/msgdata/msg/narc_0578.bin: MSGENCFLAGS = -k 0x00d0
files/msgdata/msg/narc_0579.bin: MSGENCFLAGS = -k 0xb8dd
files/msgdata/msg/narc_0580.bin: MSGENCFLAGS = -k 0x269e
files/msgdata/msg/narc_0581.bin: MSGENCFLAGS = -k 0xb3a8
files/msgdata/msg/narc_0582.bin: MSGENCFLAGS = -k 0xbe98
files/msgdata/msg/narc_0583.bin: MSGENCFLAGS = -k 0xbe80
files/msgdata/msg/narc_0584.bin: MSGENCFLAGS = -k 0x0fcb
files/msgdata/msg/narc_0585.bin: MSGENCFLAGS = -k 0xba98
files/msgdata/msg/narc_0586.bin: MSGENCFLAGS = -k 0x93cb
files/msgdata/msg/narc_0587.bin: MSGENCFLAGS = -k 0x6c98
files/msgdata/msg/narc_0588.bin: MSGENCFLAGS = -k 0xf8c9
files/msgdata/msg/narc_0589.bin: MSGENCFLAGS = -k 0x56b0
files/msgdata/msg/narc_0590.bin: MSGENCFLAGS = -k 0x81d4
files/msgdata/msg/narc_0591.bin: MSGENCFLAGS = -k 0xd561
files/msgdata/msg/narc_0592.bin: MSGENCFLAGS = -k 0x3d5b
files/msgdata/msg/narc_0593.bin: MSGENCFLAGS = -k 0xf420
files/msgdata/msg/narc_0594.bin: MSGENCFLAGS = -k 0x8194
files/msgdata/msg/narc_0595.bin: MSGENCFLAGS = -k 0x9dc4
files/msgdata/msg/narc_0596.bin: MSGENCFLAGS = -k 0x8194
files/msgdata/msg/narc_0597.bin: MSGENCFLAGS = -k 0x4da1
files/msgdata/msg/narc_0598.bin: MSGENCFLAGS = -k 0x69a1
files/msgdata/msg/narc_0599.bin: MSGENCFLAGS = -k 0xddf4
files/msgdata/msg/narc_0600.bin: MSGENCFLAGS = -k 0x05e9
files/msgdata/msg/narc_0601.bin: MSGENCFLAGS = -k 0x6d89
files/msgdata/msg/narc_0602.bin: MSGENCFLAGS = -k 0x01b5
files/msgdata/msg/narc_0603.bin: MSGENCFLAGS = -k 0xc1f0
files/msgdata/msg/narc_0604.bin: MSGENCFLAGS = -k 0x71d9
files/msgdata/msg/narc_0605.bin: MSGENCFLAGS = -k 0x19cd
files/msgdata/msg/narc_0606.bin: MSGENCFLAGS = -k 0x09e9
files/msgdata/msg/narc_0607.bin: MSGENCFLAGS = -k 0xf5b8
files/msgdata/msg/narc_0608.bin: MSGENCFLAGS = -k 0xf530
files/msgdata/msg/narc_0609.bin: MSGENCFLAGS = -k 0x1d5d
files/msgdata/msg/narc_0610.bin: MSGENCFLAGS = -k 0x950c
files/msgdata/msg/narc_0611.bin: MSGENCFLAGS = -k 0x852c
files/msgdata/msg/narc_0612.bin: MSGENCFLAGS = -k 0x9eb7
files/msgdata/msg/narc_0613.bin: MSGENCFLAGS = -k 0xd2da
files/msgdata/msg/narc_0614.bin: MSGENCFLAGS = -k 0x2a25
files/msgdata/msg/narc_0615.bin: MSGENCFLAGS = -k 0x7542
files/msgdata/msg/narc_0616.bin: MSGENCFLAGS = -k 0x7546
files/msgdata/msg/narc_0617.bin: MSGENCFLAGS = -k 0x754a
files/msgdata/msg/narc_0618.bin: MSGENCFLAGS = -k 0x754e
files/msgdata/msg/narc_0619.bin: MSGENCFLAGS = -k 0x62d1
files/msgdata/msg/narc_0620.bin: MSGENCFLAGS = -k 0x1395
files/msgdata/msg/narc_0621.bin: MSGENCFLAGS = -k 0xbea9
files/msgdata/msg/narc_0622.bin: MSGENCFLAGS = -k 0x7df9
files/msgdata/msg/narc_0623.bin: MSGENCFLAGS = -k 0x5938

FS_CLEAN_LIST += $(TRNAME_GMM) $(MSGFILE_H)
