#include "rs_migrate_string.h"

#include "global.h"

#include "string_util.h"

static const u16 conversion_table[][2] = {
    { 0x0001, 0x01DE }, // <space>
    { 0x0003, 0x0003 }, // あ
    { 0x0005, 0x0005 }, // い
    { 0x0007, 0x0007 }, // う
    { 0x0009, 0x0009 }, // え
    { 0x000B, 0x000B }, // お
    { 0x000C, 0x000C }, // か
    { 0x000E, 0x000E }, // き
    { 0x0010, 0x0010 }, // く
    { 0x0012, 0x0012 }, // け
    { 0x0014, 0x0014 }, // こ
    { 0x0016, 0x0016 }, // さ
    { 0x0018, 0x0018 }, // し
    { 0x001A, 0x001A }, // す
    { 0x001C, 0x001C }, // せ
    { 0x001E, 0x001E }, // そ
    { 0x0020, 0x0020 }, // た
    { 0x0022, 0x0022 }, // ち
    { 0x0025, 0x0025 }, // つ
    { 0x0027, 0x0027 }, // て
    { 0x0029, 0x0029 }, // と
    { 0x002B, 0x002B }, // な
    { 0x002C, 0x002C }, // に
    { 0x002D, 0x002D }, // ぬ
    { 0x002E, 0x002E }, // ね
    { 0x002F, 0x002F }, // の
    { 0x0030, 0x0030 }, // は
    { 0x0033, 0x0033 }, // ひ
    { 0x0036, 0x0036 }, // ふ
    { 0x0039, 0x0039 }, // へ
    { 0x003C, 0x003C }, // ほ
    { 0x003F, 0x003F }, // ま
    { 0x0040, 0x0040 }, // み
    { 0x0041, 0x0041 }, // む
    { 0x0042, 0x0042 }, // め
    { 0x0043, 0x0043 }, // も
    { 0x0045, 0x0045 }, // や
    { 0x0047, 0x0047 }, // ゆ
    { 0x0049, 0x0049 }, // よ
    { 0x004A, 0x004A }, // ら
    { 0x004B, 0x004B }, // り
    { 0x004C, 0x004C }, // る
    { 0x004D, 0x004D }, // れ
    { 0x004E, 0x004E }, // ろ
    { 0x004F, 0x004F }, // わ
    { 0x0050, 0x0050 }, // を
    { 0x0051, 0x0051 }, // ん
    { 0x0002, 0x0002 }, // ぁ
    { 0x0004, 0x0004 }, // ぃ
    { 0x0006, 0x0006 }, // ぅ
    { 0x0008, 0x0008 }, // ぇ
    { 0x000A, 0x000A }, // ぉ
    { 0x0044, 0x0044 }, // ゃ
    { 0x0046, 0x0046 }, // ゅ
    { 0x0048, 0x0048 }, // ょ
    { 0x000D, 0x000D }, // が
    { 0x000F, 0x000F }, // ぎ
    { 0x0011, 0x0011 }, // ぐ
    { 0x0013, 0x0013 }, // げ
    { 0x0015, 0x0015 }, // ご
    { 0x0017, 0x0017 }, // ざ
    { 0x0019, 0x0019 }, // じ
    { 0x001B, 0x001B }, // ず
    { 0x001D, 0x001D }, // ぜ
    { 0x001F, 0x001F }, // ぞ
    { 0x0021, 0x0021 }, // だ
    { 0x0023, 0x0023 }, // ぢ
    { 0x0026, 0x0026 }, // づ
    { 0x0028, 0x0028 }, // で
    { 0x002A, 0x002A }, // ど
    { 0x0031, 0x0031 }, // ば
    { 0x0034, 0x0034 }, // び
    { 0x0037, 0x0037 }, // ぶ
    { 0x003A, 0x003A }, // べ
    { 0x003D, 0x003D }, // ぼ
    { 0x0032, 0x0032 }, // ぱ
    { 0x0035, 0x0035 }, // ぴ
    { 0x0038, 0x0038 }, // ぷ
    { 0x003B, 0x003B }, // ぺ
    { 0x003E, 0x003E }, // ぽ
    { 0x0024, 0x0024 }, // っ
    { 0x0053, 0x0053 }, // ア
    { 0x0055, 0x0055 }, // イ
    { 0x0057, 0x0057 }, // ウ
    { 0x0059, 0x0059 }, // エ
    { 0x005B, 0x005B }, // オ
    { 0x005C, 0x005C }, // カ
    { 0x005E, 0x005E }, // キ
    { 0x0060, 0x0060 }, // ク
    { 0x0062, 0x0062 }, // ケ
    { 0x0064, 0x0064 }, // コ
    { 0x0066, 0x0066 }, // サ
    { 0x0068, 0x0068 }, // シ
    { 0x006A, 0x006A }, // ス
    { 0x006C, 0x006C }, // セ
    { 0x006E, 0x006E }, // ソ
    { 0x0070, 0x0070 }, // タ
    { 0x0072, 0x0072 }, // チ
    { 0x0075, 0x0075 }, // ツ
    { 0x0077, 0x0077 }, // テ
    { 0x0079, 0x0079 }, // ト
    { 0x007B, 0x007B }, // ナ
    { 0x007C, 0x007C }, // ニ
    { 0x007D, 0x007D }, // ヌ
    { 0x007E, 0x007E }, // ネ
    { 0x007F, 0x007F }, // ノ
    { 0x0080, 0x0080 }, // ハ
    { 0x0083, 0x0083 }, // ヒ
    { 0x0086, 0x0086 }, // フ
    { 0x0089, 0x0089 }, // ヘ
    { 0x008C, 0x008C }, // ホ
    { 0x008F, 0x008F }, // マ
    { 0x0090, 0x0090 }, // ミ
    { 0x0091, 0x0091 }, // ム
    { 0x0092, 0x0092 }, // メ
    { 0x0093, 0x0093 }, // モ
    { 0x0095, 0x0095 }, // ヤ
    { 0x0097, 0x0097 }, // ユ
    { 0x0099, 0x0099 }, // ヨ
    { 0x009A, 0x009A }, // ラ
    { 0x009B, 0x009B }, // リ
    { 0x009C, 0x009C }, // ル
    { 0x009D, 0x009D }, // レ
    { 0x009E, 0x009E }, // ロ
    { 0x009F, 0x009F }, // ワ
    { 0x00A0, 0x00A0 }, // ヲ
    { 0x00A1, 0x00A1 }, // ン
    { 0x0052, 0x0052 }, // ァ
    { 0x0054, 0x0054 }, // ィ
    { 0x0056, 0x0056 }, // ゥ
    { 0x0058, 0x0058 }, // ェ
    { 0x005A, 0x005A }, // ォ
    { 0x0094, 0x0094 }, // ャ
    { 0x0096, 0x0096 }, // ュ
    { 0x0098, 0x0098 }, // ョ
    { 0x005D, 0x005D }, // ガ
    { 0x005F, 0x005F }, // ギ
    { 0x0061, 0x0061 }, // グ
    { 0x0063, 0x0063 }, // ゲ
    { 0x0065, 0x0065 }, // ゴ
    { 0x0067, 0x0067 }, // ザ
    { 0x0069, 0x0069 }, // ジ
    { 0x006B, 0x006B }, // ズ
    { 0x006D, 0x006D }, // ゼ
    { 0x006F, 0x006F }, // ゾ
    { 0x0071, 0x0071 }, // ダ
    { 0x0073, 0x0073 }, // ヂ
    { 0x0076, 0x0076 }, // ヅ
    { 0x0078, 0x0078 }, // デ
    { 0x007A, 0x007A }, // ド
    { 0x0081, 0x0081 }, // バ
    { 0x0084, 0x0084 }, // ビ
    { 0x0087, 0x0087 }, // ブ
    { 0x008A, 0x008A }, // ベ
    { 0x008D, 0x008D }, // ボ
    { 0x0082, 0x0082 }, // パ
    { 0x0085, 0x0085 }, // ピ
    { 0x0088, 0x0088 }, // プ
    { 0x008B, 0x008B }, // ペ
    { 0x008E, 0x008E }, // ポ
    { 0x0074, 0x0074 }, // ッ
    { 0x00A2, 0x0121 }, // 0
    { 0x00A3, 0x0122 }, // 1
    { 0x00A4, 0x0123 }, // 2
    { 0x00A5, 0x0124 }, // 3
    { 0x00A6, 0x0125 }, // 4
    { 0x00A7, 0x0126 }, // 5
    { 0x00A8, 0x0127 }, // 6
    { 0x00A9, 0x0128 }, // 7
    { 0x00AA, 0x0129 }, // 8
    { 0x00AB, 0x012A }, // 9
    { 0x00E1, 0x01AB }, // !
    { 0x00E2, 0x01AC }, // ?
    { 0x00E4, 0x01AE }, // .
    { 0x00F1, 0x01BE }, // -
    { 0x00E6, 0x01B0 }, // ·
    { 0x00E5, 0x01AF }, // …
    { 0x00EA, 0x00EA }, // “
    { 0x00EB, 0x00EB }, // ”
    { 0x00E8, 0x01B2 }, // ‘
    { 0x00E9, 0x01B3 }, // '
    { 0x00EE, 0x01BB }, // ♂
    { 0x00EF, 0x01BC }, // ♀
    { 0x0112, 0x0112 }, // ¥
    { 0x00E3, 0x01AD }, // ,
    { 0x00F2, 0x0176 }, // ×
    { 0x00E7, 0x01B1 }, // /
    { 0x00AC, 0x012B }, // A
    { 0x00AD, 0x012C }, // B
    { 0x00AE, 0x012D }, // C
    { 0x00AF, 0x012E }, // D
    { 0x00B0, 0x012F }, // E
    { 0x00B1, 0x0130 }, // F
    { 0x00B2, 0x0131 }, // G
    { 0x00B3, 0x0132 }, // H
    { 0x00B4, 0x0133 }, // I
    { 0x00B5, 0x0134 }, // J
    { 0x00B6, 0x0135 }, // K
    { 0x00B7, 0x0136 }, // L
    { 0x00B8, 0x0137 }, // M
    { 0x00B9, 0x0138 }, // N
    { 0x00BA, 0x0139 }, // O
    { 0x00BB, 0x013A }, // P
    { 0x00BC, 0x013B }, // Q
    { 0x00BD, 0x013C }, // R
    { 0x00BE, 0x013D }, // S
    { 0x00BF, 0x013E }, // T
    { 0x00C0, 0x013F }, // U
    { 0x00C1, 0x0140 }, // V
    { 0x00C2, 0x0141 }, // W
    { 0x00C3, 0x0142 }, // X
    { 0x00C4, 0x0143 }, // Y
    { 0x00C5, 0x0144 }, // Z
    { 0x00C6, 0x0145 }, // a
    { 0x00C7, 0x0146 }, // b
    { 0x00C8, 0x0147 }, // c
    { 0x00C9, 0x0148 }, // d
    { 0x00CA, 0x0149 }, // e
    { 0x00CB, 0x014A }, // f
    { 0x00CC, 0x014B }, // g
    { 0x00CD, 0x014C }, // h
    { 0x00CE, 0x014D }, // i
    { 0x00CF, 0x014E }, // j
    { 0x00D0, 0x014F }, // k
    { 0x00D1, 0x0150 }, // l
    { 0x00D2, 0x0151 }, // m
    { 0x00D3, 0x0152 }, // n
    { 0x00D4, 0x0153 }, // o
    { 0x00D5, 0x0154 }, // p
    { 0x00D6, 0x0155 }, // q
    { 0x00D7, 0x0156 }, // r
    { 0x00D8, 0x0157 }, // s
    { 0x00D9, 0x0158 }, // t
    { 0x00DA, 0x0159 }, // u
    { 0x00DB, 0x015A }, // v
    { 0x00DC, 0x015B }, // w
    { 0x00DD, 0x015C }, // x
    { 0x00DE, 0x015D }, // y
    { 0x00DF, 0x015E }, // z
    { 0x011F, 0x011F }, // ▶
    { 0x00F6, 0x01C4 }, // :
    { 0x0163, 0x0163 }, // Ä
    { 0x0175, 0x0175 }, // Ö
    { 0x017B, 0x017B }, // Ü
    { 0x0183, 0x0183 }, // ä
    { 0x0195, 0x0195 }, // ö
    { 0x019B, 0x019B }, // ü
};

static u16 GetOpeningQuote(u32 language) {
    switch (language) {
    default:
        return 0xEA;
    case LANGUAGE_ENGLISH:
    case LANGUAGE_ITALIAN:
    case LANGUAGE_SPANISH:
        return 0x1B4;
    case LANGUAGE_FRENCH:
        return 0x1B7;
    case LANGUAGE_GERMAN:
        return 0x1B6;
    }
}

static u16 GetClosingQuote(u32 language) {
    switch (language) {
    default:
        return 0xEB;
    case LANGUAGE_ENGLISH:
    case LANGUAGE_ITALIAN:
    case LANGUAGE_SPANISH:
        return 0x1B5;
    case LANGUAGE_FRENCH:
        return 0x1B8;
    case LANGUAGE_GERMAN:
        return 0x1B4;
    }
}

BOOL ConvertRSStringToDPStringInternational(const u8 *rs_str, u16 *dp_str, u32 length, u32 language) {
    BOOL notFullWidth;
    u32 i;

    notFullWidth = (language != LANGUAGE_JAPANESE);
    for (i = 0; i < length - 1; i++) {
        if (rs_str[i] == 0xFF) { // RS: EOS
            break;
        }
        if (rs_str[i] >= 0xF7) // RS: DYNAMIC
        {
            // If we're here, the provided name is corrupt.
            // Fill it with question marks.
            s32 r3 = (s32)((length - 1) < 10 ? (length - 1) : 10);
            s32 r1;
            for (r1 = 0; r1 < r3; r1++) {
                dp_str[r1] = 0x1AC; // DP: ?
            }
            dp_str[r1] = EOS;
            return FALSE;
        }
        switch (conversion_table[rs_str[i]][notFullWidth]) {
        case 0xEA: // RS: Opening double quote
            dp_str[i] = GetOpeningQuote(language);
            break;
        case 0xEB: // RS: Closing double quote
            dp_str[i] = GetClosingQuote(language);
            break;
        default:
            dp_str[i] = conversion_table[rs_str[i]][notFullWidth];
            break;
        }
    }
    dp_str[i] = EOS;
    return TRUE;
}
