#include "map_header.h"

#include "global.h"

#include "constants/map_sections.h"
#include "constants/maps.h"
#include "constants/sndseq.h"

#include "fielddata/areadata/area_data.naix"
#include "fielddata/encountdata/d_enc_data.naix"
#include "fielddata/encountdata/p_enc_data.naix"
#include "fielddata/eventdata/zone_event_release.naix"
#include "fielddata/mapmatrix/map_matrix.naix"
#include "fielddata/mm_list/move_model_list.naix"
#include "fielddata/script/scr_seq_release.naix"
#include "msgdata/msg.naix"

#include "pokemon.h"

#define ENCDATA(dia, pea) ((GAME_VERSION == VERSION_DIAMOND) ? (dia) : (pea))

// Static decls
u32 MapNumberBoundsCheck(u32 mapno);

static const u16 sPokemonCenterSecondFloorMaps[] = {
    MAP_T02PC0102,
    MAP_T03PC0102,
    MAP_T04PC0102,
    MAP_T05PC0102,
    MAP_T06PC0102,
    MAP_T07PC0102,
    MAP_C01PC0102,
    MAP_C02PC0102,
    MAP_C03PC0102,
    MAP_C10R0114,
    MAP_C04PC0102,
    MAP_C05PC0102,
    MAP_C06PC0102,
    MAP_C07PC0102,
    MAP_C08PC0102,
    MAP_C09PC0102,
    MAP_C10PC0102,
    MAP_C11PC0102
};

static const u16 sMapEvolutionMethods[] = {
    MAP_R217,
    EVO_ROUTE217,
    MAP_D03R0101,
    EVO_ETERNA,
    MAP_D05R0101,
    EVO_CORONET,
    MAP_D05R0102,
    EVO_CORONET,
    MAP_D05R0103,
    EVO_CORONET,
    MAP_D05R0104,
    EVO_CORONET,
    MAP_D05R0105,
    EVO_CORONET,
    MAP_D05R0106,
    EVO_CORONET,
    MAP_D05R0107,
    EVO_CORONET,
    MAP_D05R0108,
    EVO_CORONET,
    MAP_D05R0109,
    EVO_CORONET,
    MAP_D05R0110,
    EVO_CORONET,
    MAP_D05R0111,
    EVO_CORONET,
    MAP_D05R0112,
    EVO_CORONET,
    MAP_D05R0113,
    EVO_CORONET,
    MAP_D05R0114,
    EVO_CORONET,
    MAP_D05R0115,
    EVO_CORONET,
};

static const struct MapHeader sMapHeaders[] = {
    { NARC_area_data_narc_0000_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 2, 3, TRUE, TRUE, TRUE, FALSE }, // MAP_EVERYWHERE
    { NARC_area_data_narc_0000_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 0, 3, FALSE, FALSE, FALSE, FALSE }, // MAP_NOTHING
    { NARC_area_data_narc_0002_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0002_bin, NARC_scr_seq_release_narc_1043_bin, NARC_scr_seq_release_narc_0970_bin, NARC_msg_narc_0566_bin, SEQ_TANKOU, SEQ_TANKOU, 0xFFFF, NARC_zone_event_release_narc_0001_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 6, 3, FALSE, FALSE, FALSE, FALSE }, // MAP_UG
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0002_bin, NARC_scr_seq_release_narc_0465_bin, NARC_msg_narc_0018_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0002_bin, MAPSEC_JUBILIFE_CITY, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C01
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0003_bin, NARC_scr_seq_release_narc_0466_bin, NARC_msg_narc_0019_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0003_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01FS0101
    { NARC_area_data_narc_0020_bin, 20, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0004_bin, NARC_scr_seq_release_narc_0467_bin, NARC_msg_narc_0020_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0004_bin, MAPSEC_JUBILIFE_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01GYM0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0005_bin, NARC_scr_seq_release_narc_0468_bin, NARC_msg_narc_0021_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0005_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0006_bin, NARC_scr_seq_release_narc_0469_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0006_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01PC0102
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0141_bin, NARC_scr_seq_release_narc_0008_bin, NARC_scr_seq_release_narc_0471_bin, NARC_msg_narc_0022_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0007_bin, MAPSEC_POKETCH_CO, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0101
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0142_bin, NARC_scr_seq_release_narc_0009_bin, NARC_scr_seq_release_narc_0472_bin, NARC_msg_narc_0023_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0008_bin, MAPSEC_POKETCH_CO, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0102
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0143_bin, NARC_scr_seq_release_narc_0010_bin, NARC_scr_seq_release_narc_0473_bin, NARC_msg_narc_0024_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0009_bin, MAPSEC_POKETCH_CO, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0103
    { NARC_area_data_narc_0034_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0148_bin, NARC_scr_seq_release_narc_0011_bin, NARC_scr_seq_release_narc_0474_bin, NARC_msg_narc_0025_bin, SEQ_BLD_TV, SEQ_BLD_TV, 0xFFFF, NARC_zone_event_release_narc_0010_bin, MAPSEC_JUBILIFE_TV, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0201
    { NARC_area_data_narc_0034_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0149_bin, NARC_scr_seq_release_narc_0012_bin, NARC_scr_seq_release_narc_0475_bin, NARC_msg_narc_0026_bin, SEQ_BLD_TV, SEQ_BLD_TV, 0xFFFF, NARC_zone_event_release_narc_0011_bin, MAPSEC_JUBILIFE_TV, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0202
    { NARC_area_data_narc_0034_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0150_bin, NARC_scr_seq_release_narc_0013_bin, NARC_scr_seq_release_narc_0476_bin, NARC_msg_narc_0027_bin, SEQ_BLD_TV, SEQ_BLD_TV, 0xFFFF, NARC_zone_event_release_narc_0012_bin, MAPSEC_JUBILIFE_TV, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0203
    { NARC_area_data_narc_0034_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0151_bin, NARC_scr_seq_release_narc_0014_bin, NARC_scr_seq_release_narc_0477_bin, NARC_msg_narc_0028_bin, SEQ_BLD_TV, SEQ_BLD_TV, 0xFFFF, NARC_zone_event_release_narc_0013_bin, MAPSEC_JUBILIFE_TV, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0204
    { NARC_area_data_narc_0034_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0152_bin, NARC_scr_seq_release_narc_0015_bin, NARC_scr_seq_release_narc_0478_bin, NARC_msg_narc_0029_bin, SEQ_BLD_TV, SEQ_BLD_TV, 0xFFFF, NARC_zone_event_release_narc_0014_bin, MAPSEC_JUBILIFE_TV, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0205
    { NARC_area_data_narc_0034_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0153_bin, NARC_scr_seq_release_narc_0016_bin, NARC_scr_seq_release_narc_0479_bin, NARC_msg_narc_0030_bin, SEQ_BLD_TV, SEQ_BLD_TV, 0xFFFF, NARC_zone_event_release_narc_0015_bin, MAPSEC_JUBILIFE_TV, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0206
    { NARC_area_data_narc_0034_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0154_bin, NARC_scr_seq_release_narc_0017_bin, NARC_scr_seq_release_narc_0480_bin, NARC_msg_narc_0031_bin, SEQ_BLD_TV, SEQ_BLD_TV, 0xFFFF, NARC_zone_event_release_narc_0016_bin, MAPSEC_JUBILIFE_TV, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0207
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0207_bin, NARC_scr_seq_release_narc_0018_bin, NARC_scr_seq_release_narc_0481_bin, NARC_msg_narc_0032_bin, SEQ_BLD_TV, SEQ_BLD_TV, 0xFFFF, NARC_zone_event_release_narc_0017_bin, MAPSEC_JUBILIFE_TV, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0208
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0132_bin, NARC_scr_seq_release_narc_0019_bin, NARC_scr_seq_release_narc_0482_bin, NARC_msg_narc_0033_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0018_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0301
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0020_bin, NARC_scr_seq_release_narc_0483_bin, NARC_msg_narc_0034_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0019_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0302
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0021_bin, NARC_scr_seq_release_narc_0484_bin, NARC_msg_narc_0035_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0020_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0303
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0021_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0304
    { NARC_area_data_narc_0020_bin, 20, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0023_bin, NARC_scr_seq_release_narc_0486_bin, NARC_msg_narc_0036_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0022_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0401
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0132_bin, NARC_scr_seq_release_narc_0024_bin, NARC_scr_seq_release_narc_0487_bin, NARC_msg_narc_0037_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0023_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0501
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0025_bin, NARC_scr_seq_release_narc_0488_bin, NARC_msg_narc_0038_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0024_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0502
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0026_bin, NARC_scr_seq_release_narc_0489_bin, NARC_msg_narc_0039_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0025_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0503
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0027_bin, NARC_scr_seq_release_narc_0490_bin, NARC_msg_narc_0040_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0026_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0504
    { NARC_area_data_narc_0040_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0205_bin, NARC_scr_seq_release_narc_0028_bin, NARC_scr_seq_release_narc_0491_bin, NARC_msg_narc_0041_bin, SEQ_BLD_BLD_GTC, SEQ_BLD_BLD_GTC, 0xFFFF, NARC_zone_event_release_narc_0027_bin, MAPSEC_GTS, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0601
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0140_bin, NARC_scr_seq_release_narc_0029_bin, NARC_scr_seq_release_narc_0492_bin, NARC_msg_narc_0042_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0028_bin, MAPSEC_TRAINERS_SCHOOL, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0701
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0132_bin, NARC_scr_seq_release_narc_0030_bin, NARC_scr_seq_release_narc_0493_bin, NARC_msg_narc_0043_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0029_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0801
    { NARC_area_data_narc_0020_bin, 20, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0032_bin, NARC_scr_seq_release_narc_0495_bin, NARC_msg_narc_0045_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0030_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0901
    { NARC_area_data_narc_0020_bin, 20, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0033_bin, NARC_scr_seq_release_narc_0496_bin, NARC_msg_narc_0046_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0031_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R1001
    { NARC_area_data_narc_0015_bin, NARC_move_model_list_narc_0009_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0034_bin, NARC_scr_seq_release_narc_0497_bin, NARC_msg_narc_0047_bin, SEQ_CITY02_D, SEQ_CITY02_N, ENCDATA(NARC_d_enc_data_narc_0000_bin, NARC_p_enc_data_narc_0000_bin), NARC_zone_event_release_narc_0032_bin, MAPSEC_CANALAVE_CITY, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C02
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0035_bin, NARC_scr_seq_release_narc_0498_bin, NARC_msg_narc_0048_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0033_bin, MAPSEC_CANALAVE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02FS0101
    { NARC_area_data_narc_0024_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0112_bin, NARC_scr_seq_release_narc_0036_bin, NARC_scr_seq_release_narc_0499_bin, NARC_msg_narc_0049_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0034_bin, MAPSEC_CANALAVE_CITY, 0, 3, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02GYM0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0037_bin, NARC_scr_seq_release_narc_0500_bin, NARC_msg_narc_0050_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0035_bin, MAPSEC_CANALAVE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0038_bin, NARC_scr_seq_release_narc_0501_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0036_bin, MAPSEC_CANALAVE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02PC0102
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0217_bin, NARC_scr_seq_release_narc_0040_bin, NARC_scr_seq_release_narc_0503_bin, NARC_msg_narc_0051_bin, SEQ_CITY02_D, SEQ_CITY02_N, 0xFFFF, NARC_zone_event_release_narc_0037_bin, MAPSEC_CANALAVE_LIBRARY, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_C02R0101
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0218_bin, NARC_scr_seq_release_narc_0041_bin, NARC_scr_seq_release_narc_0504_bin, NARC_msg_narc_0052_bin, SEQ_CITY02_D, SEQ_CITY02_N, 0xFFFF, NARC_zone_event_release_narc_0038_bin, MAPSEC_CANALAVE_LIBRARY, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_C02R0102
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0219_bin, NARC_scr_seq_release_narc_0042_bin, NARC_scr_seq_release_narc_0505_bin, NARC_msg_narc_0053_bin, SEQ_CITY02_D, SEQ_CITY02_N, 0xFFFF, NARC_zone_event_release_narc_0039_bin, MAPSEC_CANALAVE_LIBRARY, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_C02R0103
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0043_bin, NARC_scr_seq_release_narc_0506_bin, NARC_msg_narc_0054_bin, SEQ_CITY02_D, SEQ_CITY02_N, 0xFFFF, NARC_zone_event_release_narc_0040_bin, MAPSEC_CANALAVE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0044_bin, NARC_scr_seq_release_narc_0507_bin, NARC_msg_narc_0055_bin, SEQ_CITY02_D, SEQ_CITY02_N, 0xFFFF, NARC_zone_event_release_narc_0041_bin, MAPSEC_CANALAVE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02R0301
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0045_bin, NARC_scr_seq_release_narc_0508_bin, NARC_msg_narc_0056_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0042_bin, MAPSEC_CANALAVE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02R0401
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0046_bin, NARC_scr_seq_release_narc_0509_bin, NARC_msg_narc_0057_bin, SEQ_CITY02_D, SEQ_CITY02_N, 0xFFFF, NARC_zone_event_release_narc_0043_bin, MAPSEC_CANALAVE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02R0501
    { NARC_area_data_narc_0007_bin, NARC_move_model_list_narc_0001_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0048_bin, NARC_scr_seq_release_narc_0511_bin, NARC_msg_narc_0058_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0044_bin, MAPSEC_OREBURGH_CITY, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C03
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0049_bin, NARC_scr_seq_release_narc_0512_bin, NARC_msg_narc_0059_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0045_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03FS0101
    { NARC_area_data_narc_0025_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0113_bin, NARC_scr_seq_release_narc_0050_bin, NARC_scr_seq_release_narc_0513_bin, NARC_msg_narc_0060_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0046_bin, MAPSEC_OREBURGH_CITY, 0, 9, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03GYM0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0051_bin, NARC_scr_seq_release_narc_0514_bin, NARC_msg_narc_0061_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0047_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0052_bin, NARC_scr_seq_release_narc_0515_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0048_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03PC0102
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0132_bin, NARC_scr_seq_release_narc_0054_bin, NARC_scr_seq_release_narc_0517_bin, NARC_msg_narc_0063_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0049_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0101
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0055_bin, NARC_scr_seq_release_narc_0518_bin, NARC_msg_narc_0064_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0050_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0102
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0136_bin, NARC_scr_seq_release_narc_0056_bin, NARC_scr_seq_release_narc_0519_bin, NARC_msg_narc_0065_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0051_bin, MAPSEC_OREBURGH_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0103
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0057_bin, NARC_scr_seq_release_narc_0520_bin, NARC_msg_narc_0066_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0052_bin, MAPSEC_OREBURGH_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0104
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0132_bin, NARC_scr_seq_release_narc_0058_bin, NARC_scr_seq_release_narc_0521_bin, NARC_msg_narc_0067_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0053_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0201
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0059_bin, NARC_scr_seq_release_narc_0522_bin, NARC_msg_narc_0068_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0054_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0202
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0136_bin, NARC_scr_seq_release_narc_0060_bin, NARC_scr_seq_release_narc_0523_bin, NARC_msg_narc_0069_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0055_bin, MAPSEC_OREBURGH_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0203
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0061_bin, NARC_scr_seq_release_narc_0524_bin, NARC_msg_narc_0070_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0056_bin, MAPSEC_OREBURGH_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0204
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0062_bin, NARC_scr_seq_release_narc_0525_bin, NARC_msg_narc_0071_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0057_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0301
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0155_bin, NARC_scr_seq_release_narc_0063_bin, NARC_scr_seq_release_narc_0526_bin, NARC_msg_narc_0072_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0058_bin, MAPSEC_MINING_MUSEUM, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0401
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0064_bin, NARC_scr_seq_release_narc_0527_bin, NARC_msg_narc_0073_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0059_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0501
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0132_bin, NARC_scr_seq_release_narc_0065_bin, NARC_scr_seq_release_narc_0528_bin, NARC_msg_narc_0074_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0060_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0601
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0066_bin, NARC_scr_seq_release_narc_0529_bin, NARC_msg_narc_0075_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0061_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0602
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0067_bin, NARC_scr_seq_release_narc_0530_bin, NARC_msg_narc_0076_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0062_bin, MAPSEC_OREBURGH_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0603
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0068_bin, NARC_scr_seq_release_narc_0531_bin, NARC_msg_narc_0077_bin, SEQ_CITY03_D, SEQ_CITY03_N, 0xFFFF, NARC_zone_event_release_narc_0063_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03R0701
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0069_bin, NARC_scr_seq_release_narc_0532_bin, NARC_msg_narc_0078_bin, SEQ_CITY04_D, SEQ_CITY04_N, ENCDATA(NARC_d_enc_data_narc_0001_bin, NARC_p_enc_data_narc_0001_bin), NARC_zone_event_release_narc_0064_bin, MAPSEC_ETERNA_CITY, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C04
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0070_bin, NARC_scr_seq_release_narc_0533_bin, NARC_msg_narc_0079_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0065_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04FS0101
    { NARC_area_data_narc_0026_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0220_bin, NARC_scr_seq_release_narc_0071_bin, NARC_scr_seq_release_narc_0534_bin, NARC_msg_narc_0080_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0066_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04GYM0101
    { NARC_area_data_narc_0026_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0221_bin, NARC_scr_seq_release_narc_0072_bin, NARC_scr_seq_release_narc_0535_bin, NARC_msg_narc_0081_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0067_bin, MAPSEC_ETERNA_CITY, 0, 9, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04GYM0102
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0073_bin, NARC_scr_seq_release_narc_0536_bin, NARC_msg_narc_0082_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0068_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0074_bin, NARC_scr_seq_release_narc_0537_bin, NARC_msg_narc_0083_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0069_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04PC0102
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0138_bin, NARC_scr_seq_release_narc_0076_bin, NARC_scr_seq_release_narc_0539_bin, NARC_msg_narc_0084_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0070_bin, MAPSEC_CYCLE_SHOP, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0101
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0132_bin, NARC_scr_seq_release_narc_0077_bin, NARC_scr_seq_release_narc_0540_bin, NARC_msg_narc_0085_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, 0xFFFF, NARC_zone_event_release_narc_0071_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0201
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0133_bin, NARC_scr_seq_release_narc_0078_bin, NARC_scr_seq_release_narc_0541_bin, NARC_msg_narc_0086_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, 0xFFFF, NARC_zone_event_release_narc_0072_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0202
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0134_bin, NARC_scr_seq_release_narc_0079_bin, NARC_scr_seq_release_narc_0542_bin, NARC_msg_narc_0087_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, 0xFFFF, NARC_zone_event_release_narc_0073_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0203
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0080_bin, NARC_scr_seq_release_narc_0543_bin, NARC_msg_narc_0088_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, 0xFFFF, NARC_zone_event_release_narc_0074_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0204
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0132_bin, NARC_scr_seq_release_narc_0081_bin, NARC_scr_seq_release_narc_0544_bin, NARC_msg_narc_0089_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0075_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0301
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0135_bin, NARC_scr_seq_release_narc_0082_bin, NARC_scr_seq_release_narc_0545_bin, NARC_msg_narc_0090_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0076_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0302
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0083_bin, NARC_scr_seq_release_narc_0546_bin, NARC_msg_narc_0091_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0077_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0303
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0084_bin, NARC_scr_seq_release_narc_0547_bin, NARC_msg_narc_0092_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0078_bin, MAPSEC_ETERNA_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0304
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0159_bin, NARC_scr_seq_release_narc_0085_bin, NARC_scr_seq_release_narc_0548_bin, NARC_msg_narc_0093_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0079_bin, MAPSEC_ROUTE_206, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0401
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0170_bin, NARC_scr_seq_release_narc_0086_bin, NARC_scr_seq_release_narc_0549_bin, NARC_msg_narc_0094_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0080_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0501
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0124_bin, NARC_scr_seq_release_narc_0087_bin, NARC_scr_seq_release_narc_0550_bin, NARC_msg_narc_0095_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0081_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0601
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0124_bin, NARC_scr_seq_release_narc_0088_bin, NARC_scr_seq_release_narc_0551_bin, NARC_msg_narc_0096_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0082_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0701
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0244_bin, NARC_scr_seq_release_narc_0089_bin, NARC_scr_seq_release_narc_0552_bin, NARC_msg_narc_0097_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0083_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0801
    { NARC_area_data_narc_0020_bin, 20, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0084_bin, MAPSEC_ETERNA_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04R0901
    { NARC_area_data_narc_0009_bin, NARC_move_model_list_narc_0003_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0090_bin, NARC_scr_seq_release_narc_0553_bin, NARC_msg_narc_0098_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0085_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C05
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0091_bin, NARC_scr_seq_release_narc_0554_bin, NARC_msg_narc_0099_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0086_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05FS0101
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0222_bin, NARC_scr_seq_release_narc_0092_bin, NARC_scr_seq_release_narc_0555_bin, NARC_msg_narc_0100_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0087_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0101
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0223_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0088_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0102
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0223_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0089_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0103
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0224_bin, NARC_scr_seq_release_narc_0093_bin, NARC_scr_seq_release_narc_0556_bin, NARC_msg_narc_0101_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0090_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0104
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0223_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0091_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0105
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0224_bin, NARC_scr_seq_release_narc_0094_bin, NARC_scr_seq_release_narc_0557_bin, NARC_msg_narc_0102_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0092_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0106
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0223_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0093_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0107
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0224_bin, NARC_scr_seq_release_narc_0095_bin, NARC_scr_seq_release_narc_0558_bin, NARC_msg_narc_0103_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0094_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0108
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0223_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0095_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0109
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0223_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0096_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0110
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0223_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0097_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0111
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0223_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0098_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0112
    { NARC_area_data_narc_0027_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0225_bin, NARC_scr_seq_release_narc_0096_bin, NARC_scr_seq_release_narc_0559_bin, NARC_msg_narc_0104_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0099_bin, MAPSEC_HEARTHOME_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05GYM0113
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0097_bin, NARC_scr_seq_release_narc_0560_bin, NARC_msg_narc_0105_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0100_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0098_bin, NARC_scr_seq_release_narc_0561_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0101_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05PC0102
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0209_bin, NARC_scr_seq_release_narc_0100_bin, NARC_scr_seq_release_narc_0563_bin, NARC_msg_narc_0106_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0102_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0101
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0210_bin, NARC_scr_seq_release_narc_0101_bin, NARC_scr_seq_release_narc_0564_bin, NARC_msg_narc_0107_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0103_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0102
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0207_bin, NARC_scr_seq_release_narc_0102_bin, NARC_scr_seq_release_narc_0565_bin, NARC_msg_narc_0108_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0104_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0103
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0156_bin, NARC_scr_seq_release_narc_0103_bin, NARC_scr_seq_release_narc_0566_bin, NARC_msg_narc_0109_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0105_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0201
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0157_bin, NARC_scr_seq_release_narc_0104_bin, NARC_scr_seq_release_narc_0567_bin, NARC_msg_narc_0110_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0106_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0301
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0157_bin, NARC_scr_seq_release_narc_0105_bin, NARC_scr_seq_release_narc_0568_bin, NARC_msg_narc_0111_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0107_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0401
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0158_bin, NARC_scr_seq_release_narc_0106_bin, NARC_scr_seq_release_narc_0569_bin, NARC_msg_narc_0112_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0108_bin, MAPSEC_ROUTE_208, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0501
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0158_bin, NARC_scr_seq_release_narc_0107_bin, NARC_scr_seq_release_narc_0570_bin, NARC_msg_narc_0113_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, 0xFFFF, NARC_zone_event_release_narc_0109_bin, MAPSEC_ROUTE_209, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0601
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0157_bin, NARC_scr_seq_release_narc_0108_bin, NARC_scr_seq_release_narc_0571_bin, NARC_msg_narc_0114_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, 0xFFFF, NARC_zone_event_release_narc_0110_bin, MAPSEC_ROUTE_212, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0701
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0209_bin, NARC_scr_seq_release_narc_0109_bin, NARC_scr_seq_release_narc_0572_bin, NARC_msg_narc_0115_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0111_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0801
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0210_bin, NARC_scr_seq_release_narc_0110_bin, NARC_scr_seq_release_narc_0573_bin, NARC_msg_narc_0116_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0112_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0802
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0207_bin, NARC_scr_seq_release_narc_0111_bin, NARC_scr_seq_release_narc_0574_bin, NARC_msg_narc_0117_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0113_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0803
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0112_bin, NARC_scr_seq_release_narc_0575_bin, NARC_msg_narc_0118_bin, SEQ_CITY05_D, SEQ_CITY05_N, 0xFFFF, NARC_zone_event_release_narc_0114_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R0901
    { NARC_area_data_narc_0037_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0237_bin, NARC_scr_seq_release_narc_0113_bin, NARC_scr_seq_release_narc_0576_bin, NARC_msg_narc_0119_bin, SEQ_BLD_CON, SEQ_BLD_CON, 0xFFFF, NARC_zone_event_release_narc_0115_bin, MAPSEC_POFFIN_HOUSE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R1001
    { NARC_area_data_narc_0032_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0165_bin, NARC_scr_seq_release_narc_0114_bin, NARC_scr_seq_release_narc_0577_bin, NARC_msg_narc_0120_bin, SEQ_BLD_CON, SEQ_BLD_CON, 0xFFFF, NARC_zone_event_release_narc_0116_bin, MAPSEC_CONTEST_HALL, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R1101
    { NARC_area_data_narc_0032_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0166_bin, NARC_scr_seq_release_narc_0115_bin, NARC_scr_seq_release_narc_0578_bin, NARC_msg_narc_0018_bin, SEQ_BLD_CON, SEQ_BLD_CON, 0xFFFF, NARC_zone_event_release_narc_0117_bin, MAPSEC_CONTEST_HALL, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R1102
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0167_bin, NARC_scr_seq_release_narc_0117_bin, NARC_scr_seq_release_narc_0580_bin, NARC_msg_narc_0122_bin, SEQ_SILENCE_FIELD, SEQ_SILENCE_FIELD, 0xFFFF, NARC_zone_event_release_narc_0118_bin, MAPSEC_FOREIGN_BUILDING, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R1201
    { NARC_area_data_narc_0012_bin, NARC_move_model_list_narc_0006_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0118_bin, NARC_scr_seq_release_narc_0581_bin, NARC_msg_narc_0123_bin, SEQ_CITY06_D, SEQ_CITY06_N, ENCDATA(NARC_d_enc_data_narc_0002_bin, NARC_p_enc_data_narc_0002_bin), NARC_zone_event_release_narc_0119_bin, MAPSEC_PASTORIA_CITY, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C06
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0206_bin, NARC_scr_seq_release_narc_0119_bin, NARC_scr_seq_release_narc_0582_bin, NARC_msg_narc_0124_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0120_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06FS0101
    { NARC_area_data_narc_0023_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0111_bin, NARC_scr_seq_release_narc_0120_bin, NARC_scr_seq_release_narc_0583_bin, NARC_msg_narc_0125_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0121_bin, MAPSEC_PASTORIA_CITY, 0, 1, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06GYM0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0121_bin, NARC_scr_seq_release_narc_0584_bin, NARC_msg_narc_0126_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0122_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0122_bin, NARC_scr_seq_release_narc_0585_bin, NARC_msg_narc_0127_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0123_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06PC0102
    { NARC_area_data_narc_0039_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0181_bin, NARC_scr_seq_release_narc_0124_bin, NARC_scr_seq_release_narc_0587_bin, NARC_msg_narc_0128_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0124_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06R0101
    { NARC_area_data_narc_0039_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0182_bin, NARC_scr_seq_release_narc_0125_bin, NARC_scr_seq_release_narc_0588_bin, NARC_msg_narc_0129_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0125_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06R0102
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0126_bin, NARC_scr_seq_release_narc_0589_bin, NARC_msg_narc_0130_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0126_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0127_bin, NARC_scr_seq_release_narc_0590_bin, NARC_msg_narc_0131_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0127_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06R0301
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0128_bin, NARC_scr_seq_release_narc_0591_bin, NARC_msg_narc_0132_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0128_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06R0401
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0129_bin, NARC_scr_seq_release_narc_0592_bin, NARC_msg_narc_0133_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0129_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06R0501
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0130_bin, NARC_scr_seq_release_narc_0593_bin, NARC_msg_narc_0134_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0130_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06R0601
    { NARC_area_data_narc_0011_bin, NARC_move_model_list_narc_0005_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0131_bin, NARC_scr_seq_release_narc_0594_bin, NARC_msg_narc_0135_bin, SEQ_CITY07_D, SEQ_CITY07_N, 0xFFFF, NARC_zone_event_release_narc_0131_bin, MAPSEC_VEILSTONE_CITY, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C07
    { NARC_area_data_narc_0029_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0115_bin, NARC_scr_seq_release_narc_0132_bin, NARC_scr_seq_release_narc_0595_bin, NARC_msg_narc_0136_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0132_bin, MAPSEC_VEILSTONE_CITY, 0, 10, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07GYM0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0133_bin, NARC_scr_seq_release_narc_0596_bin, NARC_msg_narc_0137_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0133_bin, MAPSEC_VEILSTONE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0134_bin, NARC_scr_seq_release_narc_0597_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0134_bin, MAPSEC_VEILSTONE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07PC0102
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0139_bin, NARC_scr_seq_release_narc_0136_bin, NARC_scr_seq_release_narc_0599_bin, NARC_msg_narc_0139_bin, SEQ_BLD_GAME, SEQ_BLD_GAME, 0xFFFF, NARC_zone_event_release_narc_0135_bin, MAPSEC_GAME_CORNER, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0101
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0172_bin, NARC_scr_seq_release_narc_0137_bin, NARC_scr_seq_release_narc_0600_bin, NARC_msg_narc_0140_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0136_bin, MAPSEC_VEILSTONE_STORE, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0201
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0173_bin, NARC_scr_seq_release_narc_0138_bin, NARC_scr_seq_release_narc_0601_bin, NARC_msg_narc_0141_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0137_bin, MAPSEC_VEILSTONE_STORE, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0202
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0174_bin, NARC_scr_seq_release_narc_0139_bin, NARC_scr_seq_release_narc_0602_bin, NARC_msg_narc_0142_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0138_bin, MAPSEC_VEILSTONE_STORE, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0203
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0175_bin, NARC_scr_seq_release_narc_0140_bin, NARC_scr_seq_release_narc_0603_bin, NARC_msg_narc_0143_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0139_bin, MAPSEC_VEILSTONE_STORE, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0204
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0176_bin, NARC_scr_seq_release_narc_0141_bin, NARC_scr_seq_release_narc_0604_bin, NARC_msg_narc_0144_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0140_bin, MAPSEC_VEILSTONE_STORE, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0205
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0207_bin, NARC_scr_seq_release_narc_0142_bin, NARC_scr_seq_release_narc_0605_bin, NARC_msg_narc_0145_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0141_bin, MAPSEC_VEILSTONE_STORE, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0206
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0177_bin, NARC_scr_seq_release_narc_0143_bin, NARC_scr_seq_release_narc_0606_bin, NARC_msg_narc_0146_bin, SEQ_CITY07_D, SEQ_CITY07_N, 0xFFFF, NARC_zone_event_release_narc_0142_bin, MAPSEC_VEILSTONE_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0301
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0204_bin, NARC_scr_seq_release_narc_0144_bin, NARC_scr_seq_release_narc_0607_bin, NARC_msg_narc_0147_bin, SEQ_CITY07_D, SEQ_CITY07_N, 0xFFFF, NARC_zone_event_release_narc_0143_bin, MAPSEC_VEILSTONE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0401
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0145_bin, NARC_scr_seq_release_narc_0608_bin, NARC_msg_narc_0148_bin, SEQ_CITY07_D, SEQ_CITY07_N, 0xFFFF, NARC_zone_event_release_narc_0144_bin, MAPSEC_VEILSTONE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0501
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0146_bin, NARC_scr_seq_release_narc_0609_bin, NARC_msg_narc_0149_bin, SEQ_CITY07_D, SEQ_CITY07_N, 0xFFFF, NARC_zone_event_release_narc_0145_bin, MAPSEC_VEILSTONE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0601
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0147_bin, NARC_scr_seq_release_narc_0610_bin, NARC_msg_narc_0150_bin, SEQ_CITY07_D, SEQ_CITY07_N, 0xFFFF, NARC_zone_event_release_narc_0146_bin, MAPSEC_VEILSTONE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0701
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0148_bin, NARC_scr_seq_release_narc_0611_bin, NARC_msg_narc_0151_bin, SEQ_CITY07_D, SEQ_CITY07_N, 0xFFFF, NARC_zone_event_release_narc_0147_bin, MAPSEC_VEILSTONE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0801
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0158_bin, NARC_scr_seq_release_narc_0149_bin, NARC_scr_seq_release_narc_0612_bin, NARC_msg_narc_0152_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, 0xFFFF, NARC_zone_event_release_narc_0148_bin, MAPSEC_ROUTE_215, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07R0901
    { NARC_area_data_narc_0013_bin, NARC_move_model_list_narc_0007_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0150_bin, NARC_scr_seq_release_narc_0613_bin, NARC_msg_narc_0153_bin, SEQ_CITY08_D, SEQ_CITY08_N, ENCDATA(NARC_d_enc_data_narc_0003_bin, NARC_p_enc_data_narc_0003_bin), NARC_zone_event_release_narc_0149_bin, MAPSEC_SUNYSHORE_CITY, 0, 11, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C08
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0155_bin, NARC_scr_seq_release_narc_0618_bin, NARC_msg_narc_0157_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0150_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0156_bin, NARC_scr_seq_release_narc_0619_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0151_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08PC0102
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0151_bin, NARC_scr_seq_release_narc_0614_bin, NARC_msg_narc_0154_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0152_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08FS0101
    { NARC_area_data_narc_0030_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0226_bin, NARC_scr_seq_release_narc_0152_bin, NARC_scr_seq_release_narc_0615_bin, NARC_msg_narc_0155_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0153_bin, MAPSEC_SUNYSHORE_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08GYM0101
    { NARC_area_data_narc_0030_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0227_bin, NARC_scr_seq_release_narc_0153_bin, NARC_scr_seq_release_narc_0616_bin, NARC_msg_narc_0018_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0154_bin, MAPSEC_SUNYSHORE_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08GYM0102
    { NARC_area_data_narc_0030_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0228_bin, NARC_scr_seq_release_narc_0154_bin, NARC_scr_seq_release_narc_0617_bin, NARC_msg_narc_0156_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0155_bin, MAPSEC_SUNYSHORE_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08GYM0103
    { NARC_area_data_narc_0038_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0203_bin, NARC_scr_seq_release_narc_0158_bin, NARC_scr_seq_release_narc_0621_bin, NARC_msg_narc_0158_bin, SEQ_CITY08_D, SEQ_CITY08_N, 0xFFFF, NARC_zone_event_release_narc_0156_bin, MAPSEC_SUNYSHORE_MARKET, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0159_bin, NARC_scr_seq_release_narc_0622_bin, NARC_msg_narc_0159_bin, SEQ_CITY08_D, SEQ_CITY08_N, 0xFFFF, NARC_zone_event_release_narc_0157_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0244_bin, NARC_scr_seq_release_narc_0160_bin, NARC_scr_seq_release_narc_0623_bin, NARC_msg_narc_0160_bin, SEQ_CITY08_D, SEQ_CITY08_N, 0xFFFF, NARC_zone_event_release_narc_0158_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08R0301
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0161_bin, NARC_scr_seq_release_narc_0624_bin, NARC_msg_narc_0161_bin, SEQ_CITY08_D, SEQ_CITY08_N, 0xFFFF, NARC_zone_event_release_narc_0159_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08R0401
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0162_bin, NARC_scr_seq_release_narc_0625_bin, NARC_msg_narc_0162_bin, SEQ_CITY08_D, SEQ_CITY08_N, 0xFFFF, NARC_zone_event_release_narc_0160_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08R0501
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0163_bin, NARC_scr_seq_release_narc_0626_bin, NARC_msg_narc_0163_bin, SEQ_CITY08_D, SEQ_CITY08_N, 0xFFFF, NARC_zone_event_release_narc_0161_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08R0601
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0164_bin, NARC_scr_seq_release_narc_0627_bin, NARC_msg_narc_0164_bin, SEQ_CITY08_D, SEQ_CITY08_N, 0xFFFF, NARC_zone_event_release_narc_0162_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08R0701
    { NARC_area_data_narc_0039_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0230_bin, NARC_scr_seq_release_narc_0165_bin, NARC_scr_seq_release_narc_0628_bin, NARC_msg_narc_0165_bin, SEQ_CITY08_D, SEQ_CITY08_N, 0xFFFF, NARC_zone_event_release_narc_0163_bin, MAPSEC_VISTA_LIGHTHOUSE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08R0801
    { NARC_area_data_narc_0014_bin, NARC_move_model_list_narc_0008_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0168_bin, NARC_scr_seq_release_narc_0631_bin, NARC_msg_narc_0167_bin, SEQ_CITY09_D, SEQ_CITY09_N, 0xFFFF, NARC_zone_event_release_narc_0164_bin, MAPSEC_SNOWPOINT_CITY, 28, 0, 1, 5, FALSE, TRUE, FALSE, TRUE }, // MAP_C09
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0169_bin, NARC_scr_seq_release_narc_0632_bin, NARC_msg_narc_0168_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0165_bin, MAPSEC_SNOWPOINT_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C09FS0101
    { NARC_area_data_narc_0028_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0114_bin, NARC_scr_seq_release_narc_0170_bin, NARC_scr_seq_release_narc_0633_bin, NARC_msg_narc_0169_bin, SEQ_GYM, SEQ_GYM, 0xFFFF, NARC_zone_event_release_narc_0166_bin, MAPSEC_SNOWPOINT_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C09GYM0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0171_bin, NARC_scr_seq_release_narc_0634_bin, NARC_msg_narc_0170_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0167_bin, MAPSEC_SNOWPOINT_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C09PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0172_bin, NARC_scr_seq_release_narc_0635_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0168_bin, MAPSEC_SNOWPOINT_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C09PC0102
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0174_bin, NARC_scr_seq_release_narc_0637_bin, NARC_msg_narc_0171_bin, SEQ_CITY09_D, SEQ_CITY09_N, 0xFFFF, NARC_zone_event_release_narc_0169_bin, MAPSEC_SNOWPOINT_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C09R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0175_bin, NARC_scr_seq_release_narc_0638_bin, NARC_msg_narc_0172_bin, SEQ_CITY09_D, SEQ_CITY09_N, 0xFFFF, NARC_zone_event_release_narc_0170_bin, MAPSEC_SNOWPOINT_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C09R0201
    { NARC_area_data_narc_0013_bin, NARC_move_model_list_narc_0010_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0176_bin, NARC_scr_seq_release_narc_0639_bin, NARC_msg_narc_0173_bin, SEQ_CITY10_D, SEQ_CITY10_N, ENCDATA(NARC_d_enc_data_narc_0004_bin, NARC_p_enc_data_narc_0004_bin), NARC_zone_event_release_narc_0171_bin, MAPSEC_POKEMON_LEAGUE, 8, 11, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C10
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0177_bin, NARC_scr_seq_release_narc_0640_bin, NARC_msg_narc_0174_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0172_bin, MAPSEC_POKEMON_LEAGUE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C10PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0178_bin, NARC_scr_seq_release_narc_0641_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0173_bin, MAPSEC_POKEMON_LEAGUE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C10PC0102
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0144_bin, NARC_scr_seq_release_narc_0180_bin, NARC_scr_seq_release_narc_0643_bin, NARC_msg_narc_0175_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0174_bin, MAPSEC_POKEMON_LEAGUE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0101
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0187_bin, NARC_scr_seq_release_narc_0181_bin, NARC_scr_seq_release_narc_0644_bin, NARC_msg_narc_0018_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0175_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0102
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0183_bin, NARC_scr_seq_release_narc_0182_bin, NARC_scr_seq_release_narc_0645_bin, NARC_msg_narc_0176_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0176_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0103
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0188_bin, NARC_scr_seq_release_narc_0183_bin, NARC_scr_seq_release_narc_0646_bin, NARC_msg_narc_0018_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0177_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0104
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0184_bin, NARC_scr_seq_release_narc_0184_bin, NARC_scr_seq_release_narc_0647_bin, NARC_msg_narc_0177_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0178_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0105
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0188_bin, NARC_scr_seq_release_narc_0185_bin, NARC_scr_seq_release_narc_0648_bin, NARC_msg_narc_0018_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0179_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0106
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0185_bin, NARC_scr_seq_release_narc_0186_bin, NARC_scr_seq_release_narc_0649_bin, NARC_msg_narc_0178_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0180_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0107
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0188_bin, NARC_scr_seq_release_narc_0187_bin, NARC_scr_seq_release_narc_0650_bin, NARC_msg_narc_0018_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0181_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0108
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0186_bin, NARC_scr_seq_release_narc_0188_bin, NARC_scr_seq_release_narc_0651_bin, NARC_msg_narc_0179_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0182_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0109
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0189_bin, NARC_scr_seq_release_narc_0189_bin, NARC_scr_seq_release_narc_0652_bin, NARC_msg_narc_0018_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0183_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0110
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0190_bin, NARC_scr_seq_release_narc_0190_bin, NARC_scr_seq_release_narc_0653_bin, NARC_msg_narc_0180_bin, SEQ_D_LEAGUE, SEQ_D_LEAGUE, 0xFFFF, NARC_zone_event_release_narc_0184_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0111
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0192_bin, NARC_scr_seq_release_narc_0191_bin, NARC_scr_seq_release_narc_0654_bin, NARC_msg_narc_0181_bin, SEQ_BLD_DENDO, SEQ_BLD_DENDO, 0xFFFF, NARC_zone_event_release_narc_0185_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0112
    { NARC_area_data_narc_0036_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0191_bin, NARC_scr_seq_release_narc_0192_bin, NARC_scr_seq_release_narc_0655_bin, NARC_msg_narc_0182_bin, SEQ_BLD_DENDO, SEQ_BLD_DENDO, 0xFFFF, NARC_zone_event_release_narc_0186_bin, MAPSEC_POKEMON_LEAGUE, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0113
    { NARC_area_data_narc_0019_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0195_bin, NARC_scr_seq_release_narc_0658_bin, NARC_msg_narc_0183_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0187_bin, MAPSEC_FIGHT_AREA, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_C11
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0197_bin, NARC_scr_seq_release_narc_0660_bin, NARC_msg_narc_0185_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0188_bin, MAPSEC_FIGHT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C11PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0198_bin, NARC_scr_seq_release_narc_0661_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0189_bin, MAPSEC_FIGHT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C11PC0102
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0196_bin, NARC_scr_seq_release_narc_0659_bin, NARC_msg_narc_0184_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0190_bin, MAPSEC_FIGHT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C11FS0101
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0159_bin, NARC_scr_seq_release_narc_0200_bin, NARC_scr_seq_release_narc_0663_bin, NARC_msg_narc_0186_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0191_bin, MAPSEC_BATTLE_PARK, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C11R0101
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0157_bin, NARC_scr_seq_release_narc_0201_bin, NARC_scr_seq_release_narc_0664_bin, NARC_msg_narc_0187_bin, SEQ_TOWN06_D, SEQ_TOWN06_N, 0xFFFF, NARC_zone_event_release_narc_0192_bin, MAPSEC_ROUTE_225, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C11R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0202_bin, NARC_scr_seq_release_narc_0665_bin, NARC_msg_narc_0188_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0193_bin, MAPSEC_FIGHT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C11R0301
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0203_bin, NARC_scr_seq_release_narc_0666_bin, NARC_msg_narc_0189_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0194_bin, MAPSEC_FIGHT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C11R0401
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C11R0501
    { NARC_area_data_narc_0045_bin, 45, NARC_map_matrix_narc_0005_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_01, SEQ_D_01, 0xFFFF, NARC_zone_event_release_narc_0195_bin, MAPSEC_OREBURGH_MINE, 0, 0, 3, 9, TRUE, TRUE, TRUE, FALSE }, // MAP_D01
    { NARC_area_data_narc_0045_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0005_bin, NARC_scr_seq_release_narc_0208_bin, NARC_scr_seq_release_narc_0668_bin, NARC_msg_narc_0208_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0005_bin, NARC_p_enc_data_narc_0005_bin), NARC_zone_event_release_narc_0196_bin, MAPSEC_OREBURGH_MINE, 0, 12, 3, 9, TRUE, FALSE, TRUE, FALSE }, // MAP_D01R0101
    { NARC_area_data_narc_0045_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0006_bin, NARC_scr_seq_release_narc_0209_bin, NARC_scr_seq_release_narc_0669_bin, NARC_msg_narc_0209_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0006_bin, NARC_p_enc_data_narc_0006_bin), NARC_zone_event_release_narc_0197_bin, MAPSEC_OREBURGH_MINE, 0, 12, 3, 9, TRUE, FALSE, TRUE, FALSE }, // MAP_D01R0102
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0210_bin, NARC_scr_seq_release_narc_0670_bin, NARC_msg_narc_0210_bin, SEQ_ROAD_C_D, SEQ_ROAD_C_N, ENCDATA(NARC_d_enc_data_narc_0007_bin, NARC_p_enc_data_narc_0007_bin), NARC_zone_event_release_narc_0198_bin, MAPSEC_VALLEY_WINDWORKS, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_D02
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0234_bin, NARC_scr_seq_release_narc_0211_bin, NARC_scr_seq_release_narc_0671_bin, NARC_msg_narc_0211_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, 0xFFFF, NARC_zone_event_release_narc_0199_bin, MAPSEC_VALLEY_WINDWORKS, 0, 4, 3, 7, FALSE, TRUE, FALSE, FALSE }, // MAP_D02R0101
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0212_bin, NARC_scr_seq_release_narc_0672_bin, NARC_msg_narc_0212_bin, SEQ_ROAD_C_D, SEQ_ROAD_C_N, 0xFFFF, NARC_zone_event_release_narc_0200_bin, MAPSEC_ETERNA_FOREST, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_D03
    { NARC_area_data_narc_0044_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0007_bin, NARC_scr_seq_release_narc_0213_bin, NARC_scr_seq_release_narc_0673_bin, NARC_msg_narc_0213_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0008_bin, NARC_p_enc_data_narc_0008_bin), NARC_zone_event_release_narc_0201_bin, MAPSEC_ETERNA_FOREST, 0, 2, 3, 3, TRUE, TRUE, FALSE, TRUE }, // MAP_D03R0101
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0214_bin, NARC_scr_seq_release_narc_0674_bin, NARC_msg_narc_0214_bin, SEQ_ROAD_C_D, SEQ_ROAD_C_N, ENCDATA(NARC_d_enc_data_narc_0009_bin, NARC_p_enc_data_narc_0009_bin), NARC_zone_event_release_narc_0202_bin, MAPSEC_FUEGO_IRONWORKS, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_D04
    { NARC_area_data_narc_0057_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0008_bin, NARC_scr_seq_release_narc_0215_bin, NARC_scr_seq_release_narc_0675_bin, NARC_msg_narc_0215_bin, SEQ_D_04, SEQ_D_04, 0xFFFF, NARC_zone_event_release_narc_0203_bin, MAPSEC_FUEGO_IRONWORKS, 0, 4, 3, 7, FALSE, TRUE, FALSE, FALSE }, // MAP_D04R0101
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, FALSE, FALSE }, // MAP_D05
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0009_bin, NARC_scr_seq_release_narc_0217_bin, NARC_scr_seq_release_narc_0677_bin, NARC_msg_narc_0216_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0010_bin, NARC_p_enc_data_narc_0010_bin), NARC_zone_event_release_narc_0204_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0101
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0010_bin, NARC_scr_seq_release_narc_0218_bin, NARC_scr_seq_release_narc_0678_bin, NARC_msg_narc_0217_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0011_bin, NARC_p_enc_data_narc_0011_bin), NARC_zone_event_release_narc_0205_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0102
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0011_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0012_bin, NARC_p_enc_data_narc_0012_bin), NARC_zone_event_release_narc_0206_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0103
    { NARC_area_data_narc_0014_bin, NARC_move_model_list_narc_0008_bin, NARC_map_matrix_narc_0012_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_MOUNT1, SEQ_D_MOUNT1, ENCDATA(NARC_d_enc_data_narc_0013_bin, NARC_p_enc_data_narc_0013_bin), NARC_zone_event_release_narc_0207_bin, MAPSEC_MT_CORONET, 6, 7, 2, 5, FALSE, TRUE, FALSE, TRUE }, // MAP_D05R0104
    { NARC_area_data_narc_0014_bin, NARC_move_model_list_narc_0008_bin, NARC_map_matrix_narc_0013_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_MOUNT1, SEQ_D_MOUNT1, ENCDATA(NARC_d_enc_data_narc_0014_bin, NARC_p_enc_data_narc_0014_bin), NARC_zone_event_release_narc_0208_bin, MAPSEC_MT_CORONET, 6, 6, 2, 5, FALSE, TRUE, FALSE, TRUE }, // MAP_D05R0105
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0014_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_MOUNT1, SEQ_D_MOUNT1, ENCDATA(NARC_d_enc_data_narc_0015_bin, NARC_p_enc_data_narc_0015_bin), NARC_zone_event_release_narc_0209_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0106
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0015_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_MOUNT1, SEQ_D_MOUNT1, ENCDATA(NARC_d_enc_data_narc_0016_bin, NARC_p_enc_data_narc_0016_bin), NARC_zone_event_release_narc_0210_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0107
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0016_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_MOUNT1, SEQ_D_MOUNT1, ENCDATA(NARC_d_enc_data_narc_0017_bin, NARC_p_enc_data_narc_0017_bin), NARC_zone_event_release_narc_0211_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0108
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0017_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_MOUNT1, SEQ_D_MOUNT1, ENCDATA(NARC_d_enc_data_narc_0018_bin, NARC_p_enc_data_narc_0018_bin), NARC_zone_event_release_narc_0212_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0109
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0018_bin, NARC_scr_seq_release_narc_0226_bin, NARC_scr_seq_release_narc_0686_bin, NARC_msg_narc_0218_bin, SEQ_D_MOUNT1, SEQ_D_MOUNT1, ENCDATA(NARC_d_enc_data_narc_0019_bin, NARC_p_enc_data_narc_0019_bin), NARC_zone_event_release_narc_0213_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0110
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0019_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0020_bin, NARC_p_enc_data_narc_0020_bin), NARC_zone_event_release_narc_0214_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0111
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0020_bin, NARC_scr_seq_release_narc_0228_bin, NARC_scr_seq_release_narc_0688_bin, NARC_msg_narc_0219_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0021_bin, NARC_p_enc_data_narc_0021_bin), NARC_zone_event_release_narc_0215_bin, MAPSEC_MT_CORONET, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0112
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0021_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0022_bin, NARC_p_enc_data_narc_0022_bin), NARC_zone_event_release_narc_0216_bin, MAPSEC_MT_CORONET, 14, 0, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D05R0113
    { NARC_area_data_narc_0050_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0022_bin, NARC_scr_seq_release_narc_0230_bin, NARC_scr_seq_release_narc_0690_bin, NARC_msg_narc_0220_bin, SEQ_D_MOUNT2, SEQ_D_MOUNT2, 0xFFFF, NARC_zone_event_release_narc_0217_bin, MAPSEC_SPEAR_PILLAR, 13, 5, 2, 4, FALSE, TRUE, FALSE, FALSE }, // MAP_D05R0114
    { NARC_area_data_narc_0050_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0023_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_MOUNT2, SEQ_D_MOUNT2, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_SPEAR_PILLAR, 13, 5, 2, 4, FALSE, TRUE, FALSE, FALSE }, // MAP_D05R0115
    { NARC_area_data_narc_0012_bin, NARC_move_model_list_narc_0006_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, FALSE, FALSE }, // MAP_D06
    { NARC_area_data_narc_0053_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0024_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0218_bin, MAPSEC_PASTORIA_CITY, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D06R0101
    { NARC_area_data_narc_0010_bin, NARC_move_model_list_narc_0004_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, FALSE, FALSE }, // MAP_D07
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0025_bin, NARC_scr_seq_release_narc_0241_bin, NARC_scr_seq_release_narc_0701_bin, NARC_msg_narc_0229_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0029_bin, NARC_p_enc_data_narc_0029_bin), NARC_zone_event_release_narc_0219_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0101
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0026_bin, NARC_scr_seq_release_narc_0242_bin, NARC_scr_seq_release_narc_0702_bin, NARC_msg_narc_0230_bin, SEQ_D_02, SEQ_D_02, 0xFFFF, NARC_zone_event_release_narc_0220_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0102
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0040_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0030_bin, NARC_p_enc_data_narc_0030_bin), NARC_zone_event_release_narc_0221_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0103
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0035_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0031_bin, NARC_p_enc_data_narc_0031_bin), NARC_zone_event_release_narc_0222_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0104
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0039_bin, NARC_scr_seq_release_narc_0245_bin, NARC_scr_seq_release_narc_0705_bin, NARC_msg_narc_0231_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0032_bin, NARC_p_enc_data_narc_0032_bin), NARC_zone_event_release_narc_0223_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0105
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0031_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0033_bin, NARC_p_enc_data_narc_0033_bin), NARC_zone_event_release_narc_0224_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0106
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0034_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0034_bin, NARC_p_enc_data_narc_0034_bin), NARC_zone_event_release_narc_0225_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0107
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0031_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0035_bin, NARC_p_enc_data_narc_0035_bin), NARC_zone_event_release_narc_0226_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0108
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0040_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0036_bin, NARC_p_enc_data_narc_0036_bin), NARC_zone_event_release_narc_0227_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0109
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0042_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0037_bin, NARC_p_enc_data_narc_0037_bin), NARC_zone_event_release_narc_0228_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0110
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0035_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0038_bin, NARC_p_enc_data_narc_0038_bin), NARC_zone_event_release_narc_0229_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0111
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0035_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0039_bin, NARC_p_enc_data_narc_0039_bin), NARC_zone_event_release_narc_0230_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0112
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0036_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0040_bin, NARC_p_enc_data_narc_0040_bin), NARC_zone_event_release_narc_0231_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0113
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0034_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0041_bin, NARC_p_enc_data_narc_0041_bin), NARC_zone_event_release_narc_0232_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0114
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0030_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0042_bin, NARC_p_enc_data_narc_0042_bin), NARC_zone_event_release_narc_0233_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0115
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0041_bin, NARC_scr_seq_release_narc_0256_bin, NARC_scr_seq_release_narc_0716_bin, NARC_msg_narc_0232_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0043_bin, NARC_p_enc_data_narc_0043_bin), NARC_zone_event_release_narc_0234_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0116
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0031_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0044_bin, NARC_p_enc_data_narc_0044_bin), NARC_zone_event_release_narc_0235_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0117
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0035_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0045_bin, NARC_p_enc_data_narc_0045_bin), NARC_zone_event_release_narc_0236_bin, MAPSEC_SOLACEON_RUINS, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0118
    { NARC_area_data_narc_0014_bin, NARC_move_model_list_narc_0008_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, FALSE, FALSE }, // MAP_D09
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0043_bin, NARC_scr_seq_release_narc_0259_bin, NARC_scr_seq_release_narc_0719_bin, NARC_msg_narc_0233_bin, SEQ_D_01, SEQ_D_01, ENCDATA(NARC_d_enc_data_narc_0047_bin, NARC_p_enc_data_narc_0047_bin), NARC_zone_event_release_narc_0237_bin, MAPSEC_VICTORY_ROAD, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D09R0101
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0044_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_01, SEQ_D_01, ENCDATA(NARC_d_enc_data_narc_0048_bin, NARC_p_enc_data_narc_0048_bin), NARC_zone_event_release_narc_0238_bin, MAPSEC_VICTORY_ROAD, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D09R0102
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0045_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_01, SEQ_D_01, ENCDATA(NARC_d_enc_data_narc_0049_bin, NARC_p_enc_data_narc_0049_bin), NARC_zone_event_release_narc_0239_bin, MAPSEC_VICTORY_ROAD, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D09R0103
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0046_bin, NARC_scr_seq_release_narc_0262_bin, NARC_scr_seq_release_narc_0722_bin, NARC_msg_narc_0234_bin, SEQ_D_01, SEQ_D_01, ENCDATA(NARC_d_enc_data_narc_0050_bin, NARC_p_enc_data_narc_0050_bin), NARC_zone_event_release_narc_0240_bin, MAPSEC_VICTORY_ROAD, 14, 0, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D09R0104
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0047_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_01, SEQ_D_01, ENCDATA(NARC_d_enc_data_narc_0051_bin, NARC_p_enc_data_narc_0051_bin), NARC_zone_event_release_narc_0241_bin, MAPSEC_VICTORY_ROAD, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D09R0105
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0048_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_01, SEQ_D_01, ENCDATA(NARC_d_enc_data_narc_0052_bin, NARC_p_enc_data_narc_0052_bin), NARC_zone_event_release_narc_0242_bin, MAPSEC_VICTORY_ROAD, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D09R0106
    { NARC_area_data_narc_0004_bin, NARC_move_model_list_narc_0004_bin, NARC_map_matrix_narc_0049_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0243_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, TRUE, FALSE }, // MAP_D10
    { NARC_area_data_narc_0051_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0049_bin, NARC_scr_seq_release_narc_0265_bin, NARC_scr_seq_release_narc_0725_bin, NARC_msg_narc_0235_bin, SEQ_SILENCE_DUNGEON, SEQ_SILENCE_DUNGEON, 0xFFFF, NARC_zone_event_release_narc_0244_bin, MAPSEC_PAL_PARK, 0, 2, 2, 0, TRUE, FALSE, FALSE, FALSE }, // MAP_D10R0101
    { NARC_area_data_narc_0009_bin, NARC_move_model_list_narc_0003_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_01, SEQ_D_01, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, FALSE, FALSE }, // MAP_D11
    { NARC_area_data_narc_0049_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0050_bin, NARC_scr_seq_release_narc_0266_bin, NARC_scr_seq_release_narc_0726_bin, NARC_msg_narc_0236_bin, SEQ_D_KOUEN, SEQ_D_KOUEN, 0xFFFF, NARC_zone_event_release_narc_0245_bin, MAPSEC_AMITY_SQUARE, 0, 2, 2, 0, FALSE, TRUE, FALSE, FALSE }, // MAP_D11R0101
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0051_bin, NARC_scr_seq_release_narc_0267_bin, NARC_scr_seq_release_narc_0727_bin, NARC_msg_narc_0018_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0053_bin, NARC_p_enc_data_narc_0053_bin), NARC_zone_event_release_narc_0246_bin, MAPSEC_RAVAGED_PATH, 0, 12, 3, 9, TRUE, TRUE, TRUE, FALSE }, // MAP_D12R0101
    { NARC_area_data_narc_0044_bin, 44, NARC_map_matrix_narc_0052_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0247_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, TRUE, FALSE }, // MAP_D13
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0052_bin, NARC_scr_seq_release_narc_0269_bin, NARC_scr_seq_release_narc_0729_bin, NARC_msg_narc_0238_bin, SEQ_TOWN03_D, SEQ_TOWN03_N, 0xFFFF, NARC_zone_event_release_narc_0248_bin, MAPSEC_FLOAROMA_MEADOW, 0, 2, 3, 3, TRUE, TRUE, FALSE, TRUE }, // MAP_D13R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0270_bin, NARC_scr_seq_release_narc_0730_bin, NARC_msg_narc_0239_bin, SEQ_TOWN03_D, SEQ_TOWN03_N, 0xFFFF, NARC_zone_event_release_narc_0249_bin, MAPSEC_FLOAROMA_MEADOW, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D13R0102
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0003_bin, NARC_scr_seq_release_narc_0271_bin, NARC_scr_seq_release_narc_0731_bin, NARC_msg_narc_0240_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0054_bin, NARC_p_enc_data_narc_0054_bin), NARC_zone_event_release_narc_0250_bin, MAPSEC_OREBURGH_GATE, 0, 12, 3, 9, TRUE, TRUE, TRUE, FALSE }, // MAP_D14R0101
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0004_bin, NARC_scr_seq_release_narc_0272_bin, NARC_scr_seq_release_narc_0732_bin, NARC_msg_narc_0241_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0055_bin, NARC_p_enc_data_narc_0055_bin), NARC_zone_event_release_narc_0251_bin, MAPSEC_OREBURGH_GATE, 1, 12, 3, 9, TRUE, TRUE, TRUE, FALSE }, // MAP_D14R0102
    { NARC_area_data_narc_0015_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0273_bin, NARC_scr_seq_release_narc_0733_bin, NARC_msg_narc_0242_bin, SEQ_D_02, SEQ_D_02, 0xFFFF, NARC_zone_event_release_narc_0252_bin, MAPSEC_FULLMOON_ISLAND, 0, 0, 2, 0, FALSE, TRUE, FALSE, TRUE }, // MAP_D15
    { NARC_area_data_narc_0044_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0053_bin, NARC_scr_seq_release_narc_0274_bin, NARC_scr_seq_release_narc_0734_bin, NARC_msg_narc_0243_bin, SEQ_D_02, SEQ_D_02, 0xFFFF, NARC_zone_event_release_narc_0253_bin, MAPSEC_FULLMOON_ISLAND, 0, 2, 3, 3, FALSE, TRUE, FALSE, FALSE }, // MAP_D15R0101
    { NARC_area_data_narc_0017_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0275_bin, NARC_scr_seq_release_narc_0735_bin, NARC_msg_narc_0244_bin, SEQ_TOWN06_D, SEQ_TOWN06_N, ENCDATA(NARC_d_enc_data_narc_0056_bin, NARC_p_enc_data_narc_0056_bin), NARC_zone_event_release_narc_0254_bin, MAPSEC_STARK_MOUNTAIN, 9, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_D16
    { NARC_area_data_narc_0047_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0057_bin, NARC_scr_seq_release_narc_0276_bin, NARC_scr_seq_release_narc_0736_bin, NARC_msg_narc_0245_bin, SEQ_D_06, SEQ_D_06, ENCDATA(NARC_d_enc_data_narc_0057_bin, NARC_p_enc_data_narc_0057_bin), NARC_zone_event_release_narc_0255_bin, MAPSEC_STARK_MOUNTAIN, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D16R0101
    { NARC_area_data_narc_0047_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0058_bin, NARC_scr_seq_release_narc_0277_bin, NARC_scr_seq_release_narc_0737_bin, NARC_msg_narc_0246_bin, SEQ_D_06, SEQ_D_06, ENCDATA(NARC_d_enc_data_narc_0058_bin, NARC_p_enc_data_narc_0058_bin), NARC_zone_event_release_narc_0256_bin, MAPSEC_STARK_MOUNTAIN, 0, 8, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D16R0102
    { NARC_area_data_narc_0047_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0059_bin, NARC_scr_seq_release_narc_0278_bin, NARC_scr_seq_release_narc_0738_bin, NARC_msg_narc_0247_bin, SEQ_D_06, SEQ_D_06, 0xFFFF, NARC_zone_event_release_narc_0257_bin, MAPSEC_STARK_MOUNTAIN, 0, 12, 3, 10, TRUE, TRUE, FALSE, FALSE }, // MAP_D16R0103
    { NARC_area_data_narc_0018_bin, NARC_move_model_list_narc_0012_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, FALSE, FALSE }, // MAP_D17
    { NARC_area_data_narc_0052_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0060_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0059_bin, NARC_p_enc_data_narc_0059_bin), NARC_zone_event_release_narc_0258_bin, MAPSEC_SENDOFF_SPRING, 8, 0, 3, 3, TRUE, TRUE, FALSE, TRUE }, // MAP_D17R0101
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0061_bin, NARC_scr_seq_release_narc_0281_bin, NARC_scr_seq_release_narc_0741_bin, NARC_msg_narc_0248_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0259_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0102
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0062_bin, NARC_scr_seq_release_narc_0282_bin, NARC_scr_seq_release_narc_0742_bin, NARC_msg_narc_0249_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0260_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0103
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0063_bin, NARC_scr_seq_release_narc_0283_bin, NARC_scr_seq_release_narc_0743_bin, NARC_msg_narc_0250_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0261_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0104
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0284_bin, NARC_scr_seq_release_narc_0744_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0063_bin, NARC_p_enc_data_narc_0063_bin), NARC_zone_event_release_narc_0262_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0105
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0285_bin, NARC_scr_seq_release_narc_0745_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0064_bin, NARC_p_enc_data_narc_0064_bin), NARC_zone_event_release_narc_0263_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0106
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0286_bin, NARC_scr_seq_release_narc_0746_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0065_bin, NARC_p_enc_data_narc_0065_bin), NARC_zone_event_release_narc_0264_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0107
    { NARC_area_data_narc_0013_bin, NARC_move_model_list_narc_0010_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0302_bin, NARC_scr_seq_release_narc_0762_bin, NARC_msg_narc_0251_bin, SEQ_TOWN03_D, SEQ_TOWN03_N, 0xFFFF, NARC_zone_event_release_narc_0265_bin, MAPSEC_FLOWER_PARADISE, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_D18
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, FALSE, FALSE, FALSE, FALSE }, // MAP_D18R0101
    { NARC_area_data_narc_0011_bin, NARC_move_model_list_narc_0005_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_01, SEQ_D_01, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, FALSE, FALSE }, // MAP_D19A
    { NARC_area_data_narc_0011_bin, NARC_move_model_list_narc_0005_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_01, SEQ_D_01, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, TRUE, TRUE, FALSE, FALSE }, // MAP_D19B
    { NARC_area_data_narc_0055_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0068_bin, NARC_scr_seq_release_narc_0304_bin, NARC_scr_seq_release_narc_0764_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0106_bin, NARC_p_enc_data_narc_0106_bin), NARC_zone_event_release_narc_0266_bin, MAPSEC_SNOWPOINT_TEMPLE, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D20R0101
    { NARC_area_data_narc_0055_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0069_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0107_bin, NARC_p_enc_data_narc_0107_bin), NARC_zone_event_release_narc_0267_bin, MAPSEC_SNOWPOINT_TEMPLE, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D20R0102
    { NARC_area_data_narc_0055_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0070_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0108_bin, NARC_p_enc_data_narc_0108_bin), NARC_zone_event_release_narc_0268_bin, MAPSEC_SNOWPOINT_TEMPLE, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D20R0103
    { NARC_area_data_narc_0055_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0071_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0109_bin, NARC_p_enc_data_narc_0109_bin), NARC_zone_event_release_narc_0269_bin, MAPSEC_SNOWPOINT_TEMPLE, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D20R0104
    { NARC_area_data_narc_0055_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0072_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0110_bin, NARC_p_enc_data_narc_0110_bin), NARC_zone_event_release_narc_0270_bin, MAPSEC_SNOWPOINT_TEMPLE, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D20R0105
    { NARC_area_data_narc_0055_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0073_bin, NARC_scr_seq_release_narc_0309_bin, NARC_scr_seq_release_narc_0769_bin, NARC_msg_narc_0252_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0111_bin, NARC_p_enc_data_narc_0111_bin), NARC_zone_event_release_narc_0271_bin, MAPSEC_SNOWPOINT_TEMPLE, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D20R0106
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0074_bin, NARC_scr_seq_release_narc_0310_bin, NARC_scr_seq_release_narc_0770_bin, NARC_msg_narc_0253_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0112_bin, NARC_p_enc_data_narc_0112_bin), NARC_zone_event_release_narc_0272_bin, MAPSEC_WAYWARD_CAVE, 16, 12, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D21R0101
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0075_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_05, SEQ_D_05, ENCDATA(NARC_d_enc_data_narc_0113_bin, NARC_p_enc_data_narc_0113_bin), NARC_zone_event_release_narc_0273_bin, MAPSEC_WAYWARD_CAVE, 0, 12, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D21R0102
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0076_bin, NARC_scr_seq_release_narc_0312_bin, NARC_scr_seq_release_narc_0772_bin, NARC_msg_narc_0254_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0114_bin, NARC_p_enc_data_narc_0114_bin), NARC_zone_event_release_narc_0274_bin, MAPSEC_RUIN_MANIAC_CAVE, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D22R0101
    { NARC_area_data_narc_0012_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0079_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, ENCDATA(NARC_d_enc_data_narc_0117_bin, NARC_p_enc_data_narc_0117_bin), NARC_zone_event_release_narc_0275_bin, MAPSEC_TROPHY_GARDEN, 0, 2, 2, 3, TRUE, TRUE, FALSE, TRUE }, // MAP_D23R0101
    { NARC_area_data_narc_0015_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0316_bin, NARC_scr_seq_release_narc_0776_bin, NARC_msg_narc_0257_bin, SEQ_ROAD_B_D, SEQ_ROAD_B_N, ENCDATA(NARC_d_enc_data_narc_0118_bin, NARC_p_enc_data_narc_0118_bin), NARC_zone_event_release_narc_0276_bin, MAPSEC_IRON_ISLAND, 8, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_D24
    { NARC_area_data_narc_0045_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0080_bin, NARC_scr_seq_release_narc_0317_bin, NARC_scr_seq_release_narc_0777_bin, NARC_msg_narc_0018_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0119_bin, NARC_p_enc_data_narc_0119_bin), NARC_zone_event_release_narc_0277_bin, MAPSEC_IRON_ISLAND, 0, 13, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D24R0101
    { NARC_area_data_narc_0045_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0081_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0120_bin, NARC_p_enc_data_narc_0120_bin), NARC_zone_event_release_narc_0278_bin, MAPSEC_IRON_ISLAND, 0, 13, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D24R0102
    { NARC_area_data_narc_0045_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0082_bin, NARC_scr_seq_release_narc_0319_bin, NARC_scr_seq_release_narc_0779_bin, NARC_msg_narc_0018_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0121_bin, NARC_p_enc_data_narc_0121_bin), NARC_zone_event_release_narc_0279_bin, MAPSEC_IRON_ISLAND, 0, 13, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D24R0103
    { NARC_area_data_narc_0045_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0083_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0122_bin, NARC_p_enc_data_narc_0122_bin), NARC_zone_event_release_narc_0280_bin, MAPSEC_IRON_ISLAND, 0, 13, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D24R0104
    { NARC_area_data_narc_0045_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0084_bin, NARC_scr_seq_release_narc_0321_bin, NARC_scr_seq_release_narc_0781_bin, NARC_msg_narc_0258_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0123_bin, NARC_p_enc_data_narc_0123_bin), NARC_zone_event_release_narc_0281_bin, MAPSEC_IRON_ISLAND, 0, 13, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D24R0105
    { NARC_area_data_narc_0045_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0085_bin, NARC_scr_seq_release_narc_0322_bin, NARC_scr_seq_release_narc_0782_bin, NARC_msg_narc_0018_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0124_bin, NARC_p_enc_data_narc_0124_bin), NARC_zone_event_release_narc_0282_bin, MAPSEC_IRON_ISLAND, 0, 13, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D24R0106
    { NARC_area_data_narc_0056_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0086_bin, NARC_scr_seq_release_narc_0324_bin, NARC_scr_seq_release_narc_0784_bin, NARC_msg_narc_0260_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0125_bin, NARC_p_enc_data_narc_0125_bin), NARC_zone_event_release_narc_0283_bin, MAPSEC_OLD_CHATEAU, 0, 4, 3, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R0101
    { NARC_area_data_narc_0056_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0087_bin, NARC_scr_seq_release_narc_0325_bin, NARC_scr_seq_release_narc_0785_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0126_bin, NARC_p_enc_data_narc_0126_bin), NARC_zone_event_release_narc_0284_bin, MAPSEC_OLD_CHATEAU, 0, 4, 3, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R0102
    { NARC_area_data_narc_0056_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0088_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0127_bin, NARC_p_enc_data_narc_0127_bin), NARC_zone_event_release_narc_0285_bin, MAPSEC_OLD_CHATEAU, 0, 4, 3, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R0103
    { NARC_area_data_narc_0056_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0089_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0128_bin, NARC_p_enc_data_narc_0128_bin), NARC_zone_event_release_narc_0286_bin, MAPSEC_OLD_CHATEAU, 0, 4, 3, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R0104
    { NARC_area_data_narc_0056_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0090_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0129_bin, NARC_p_enc_data_narc_0129_bin), NARC_zone_event_release_narc_0287_bin, MAPSEC_OLD_CHATEAU, 0, 4, 3, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R0105
    { NARC_area_data_narc_0056_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0091_bin, NARC_scr_seq_release_narc_0329_bin, NARC_scr_seq_release_narc_0789_bin, NARC_msg_narc_0261_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0130_bin, NARC_p_enc_data_narc_0130_bin), NARC_zone_event_release_narc_0288_bin, MAPSEC_OLD_CHATEAU, 0, 4, 3, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R0106
    { NARC_area_data_narc_0056_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0092_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0131_bin, NARC_p_enc_data_narc_0131_bin), NARC_zone_event_release_narc_0289_bin, MAPSEC_OLD_CHATEAU, 0, 4, 3, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R0107
    { NARC_area_data_narc_0056_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0093_bin, NARC_scr_seq_release_narc_0331_bin, NARC_scr_seq_release_narc_0791_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0132_bin, NARC_p_enc_data_narc_0132_bin), NARC_zone_event_release_narc_0290_bin, MAPSEC_OLD_CHATEAU, 0, 4, 3, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R0108
    { NARC_area_data_narc_0056_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0094_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0133_bin, NARC_p_enc_data_narc_0133_bin), NARC_zone_event_release_narc_0291_bin, MAPSEC_OLD_CHATEAU, 0, 4, 3, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R0109
    { NARC_area_data_narc_0031_bin, 31, NARC_map_matrix_narc_0157_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 3, 9, FALSE, FALSE, FALSE, FALSE }, // MAP_D25R1001
    { NARC_area_data_narc_0048_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0095_bin, NARC_scr_seq_release_narc_0333_bin, NARC_scr_seq_release_narc_0793_bin, NARC_msg_narc_0262_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, 0xFFFF, NARC_zone_event_release_narc_0292_bin, MAPSEC_GALACTIC_HQ, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_D26R0101
    { NARC_area_data_narc_0048_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0096_bin, NARC_scr_seq_release_narc_0334_bin, NARC_scr_seq_release_narc_0794_bin, NARC_msg_narc_0263_bin, SEQ_D_AGITO, SEQ_D_AGITO, 0xFFFF, NARC_zone_event_release_narc_0293_bin, MAPSEC_GALACTIC_HQ, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_D26R0102
    { NARC_area_data_narc_0048_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0097_bin, NARC_scr_seq_release_narc_0335_bin, NARC_scr_seq_release_narc_0795_bin, NARC_msg_narc_0264_bin, SEQ_D_AGITO, SEQ_D_AGITO, 0xFFFF, NARC_zone_event_release_narc_0294_bin, MAPSEC_GALACTIC_HQ, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_D26R0103
    { NARC_area_data_narc_0048_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0098_bin, NARC_scr_seq_release_narc_0336_bin, NARC_scr_seq_release_narc_0796_bin, NARC_msg_narc_0265_bin, SEQ_D_AGITO, SEQ_D_AGITO, 0xFFFF, NARC_zone_event_release_narc_0295_bin, MAPSEC_GALACTIC_HQ, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_D26R0104
    { NARC_area_data_narc_0048_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0100_bin, NARC_scr_seq_release_narc_0337_bin, NARC_scr_seq_release_narc_0797_bin, NARC_msg_narc_0266_bin, SEQ_D_AGITO, SEQ_D_AGITO, 0xFFFF, NARC_zone_event_release_narc_0296_bin, MAPSEC_GALACTIC_HQ, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_D26R0105
    { NARC_area_data_narc_0048_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0099_bin, NARC_scr_seq_release_narc_0338_bin, NARC_scr_seq_release_narc_0798_bin, NARC_msg_narc_0267_bin, SEQ_D_AGITO, SEQ_D_AGITO, 0xFFFF, NARC_zone_event_release_narc_0297_bin, MAPSEC_GALACTIC_HQ, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_D26R0106
    { NARC_area_data_narc_0052_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0101_bin, NARC_scr_seq_release_narc_0342_bin, NARC_scr_seq_release_narc_0802_bin, NARC_msg_narc_0270_bin, SEQ_D_LAKE, SEQ_D_LAKE, ENCDATA(NARC_d_enc_data_narc_0134_bin, NARC_p_enc_data_narc_0134_bin), NARC_zone_event_release_narc_0298_bin, MAPSEC_LAKE_VERITY, 0, 2, 3, 3, TRUE, TRUE, FALSE, TRUE }, // MAP_D27R0101
    { NARC_area_data_narc_0052_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0102_bin, NARC_scr_seq_release_narc_0343_bin, NARC_scr_seq_release_narc_0803_bin, NARC_msg_narc_0271_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, ENCDATA(NARC_d_enc_data_narc_0135_bin, NARC_p_enc_data_narc_0135_bin), NARC_zone_event_release_narc_0299_bin, MAPSEC_LAKE_VERITY, 0, 2, 3, 3, TRUE, TRUE, FALSE, TRUE }, // MAP_D27R0102
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0103_bin, NARC_scr_seq_release_narc_0344_bin, NARC_scr_seq_release_narc_0804_bin, NARC_msg_narc_0272_bin, SEQ_D_RYAYHY, SEQ_D_RYAYHY, 0xFFFF, NARC_zone_event_release_narc_0300_bin, MAPSEC_VERITY_CAVERN, 0, 12, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D27R0103
    { NARC_area_data_narc_0052_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0104_bin, NARC_scr_seq_release_narc_0346_bin, NARC_scr_seq_release_narc_0806_bin, NARC_msg_narc_0273_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, 0xFFFF, NARC_zone_event_release_narc_0301_bin, MAPSEC_LAKE_VALOR, 0, 2, 3, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_D28R0101
    { NARC_area_data_narc_0052_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0105_bin, NARC_scr_seq_release_narc_0347_bin, NARC_scr_seq_release_narc_0807_bin, NARC_msg_narc_0274_bin, SEQ_D_LAKE, SEQ_D_LAKE, ENCDATA(NARC_d_enc_data_narc_0136_bin, NARC_p_enc_data_narc_0136_bin), NARC_zone_event_release_narc_0302_bin, MAPSEC_LAKE_VALOR, 0, 2, 3, 3, TRUE, TRUE, FALSE, TRUE }, // MAP_D28R0102
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0106_bin, NARC_scr_seq_release_narc_0348_bin, NARC_scr_seq_release_narc_0808_bin, NARC_msg_narc_0275_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, 0xFFFF, NARC_zone_event_release_narc_0303_bin, MAPSEC_VALOR_CAVERN, 0, 12, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D28R0103
    { NARC_area_data_narc_0014_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0107_bin, NARC_scr_seq_release_narc_0350_bin, NARC_scr_seq_release_narc_0810_bin, NARC_msg_narc_0276_bin, SEQ_D_LAKE, SEQ_D_LAKE, 0xFFFF, NARC_zone_event_release_narc_0304_bin, MAPSEC_LAKE_ACUITY, 0, 15, 3, 5, FALSE, TRUE, FALSE, TRUE }, // MAP_D29R0101
    { NARC_area_data_narc_0014_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0108_bin, NARC_scr_seq_release_narc_0351_bin, NARC_scr_seq_release_narc_0811_bin, NARC_msg_narc_0277_bin, SEQ_D_GINLOBBY, SEQ_D_GINLOBBY, ENCDATA(NARC_d_enc_data_narc_0137_bin, NARC_p_enc_data_narc_0137_bin), NARC_zone_event_release_narc_0305_bin, MAPSEC_LAKE_ACUITY, 0, 15, 3, 5, FALSE, TRUE, FALSE, TRUE }, // MAP_D29R0102
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0109_bin, NARC_scr_seq_release_narc_0352_bin, NARC_scr_seq_release_narc_0812_bin, NARC_msg_narc_0278_bin, SEQ_D_RYAYHY, SEQ_D_RYAYHY, 0xFFFF, NARC_zone_event_release_narc_0306_bin, MAPSEC_ACUITY_CAVERN, 0, 12, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D29R0103
    { NARC_area_data_narc_0015_bin, NARC_move_model_list_narc_0009_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0353_bin, NARC_scr_seq_release_narc_0813_bin, NARC_msg_narc_0279_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0307_bin, MAPSEC_NEWMOON_ISLAND, 0, 0, 3, 0, FALSE, TRUE, FALSE, FALSE }, // MAP_D30
    { NARC_area_data_narc_0044_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0110_bin, NARC_scr_seq_release_narc_0354_bin, NARC_scr_seq_release_narc_0814_bin, NARC_msg_narc_0280_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0308_bin, MAPSEC_NEWMOON_ISLAND, 0, 2, 3, 3, FALSE, TRUE, FALSE, FALSE }, // MAP_D30R0101
    { NARC_area_data_narc_0054_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0229_bin, NARC_scr_seq_release_narc_0355_bin, NARC_scr_seq_release_narc_0815_bin, NARC_msg_narc_0281_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0309_bin, MAPSEC_BATTLE_PARK, 0, 2, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_D31
    { NARC_area_data_narc_0041_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0231_bin, NARC_scr_seq_release_narc_0356_bin, NARC_scr_seq_release_narc_0816_bin, NARC_msg_narc_0282_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0310_bin, MAPSEC_BATTLE_PARK, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0101
    { NARC_area_data_narc_0033_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0232_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0102
    { NARC_area_data_narc_0033_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0233_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0103
    { NARC_area_data_narc_0033_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0193_bin, NARC_scr_seq_release_narc_0358_bin, NARC_scr_seq_release_narc_0818_bin, NARC_msg_narc_0283_bin, SEQ_BF_TOWWER, SEQ_BF_TOWWER, 0xFFFF, NARC_zone_event_release_narc_0311_bin, MAPSEC_BATTLE_TOWER, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0201
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0207_bin, NARC_scr_seq_release_narc_0359_bin, NARC_scr_seq_release_narc_0819_bin, NARC_msg_narc_0018_bin, SEQ_BF_TOWWER, SEQ_BF_TOWWER, 0xFFFF, NARC_zone_event_release_narc_0312_bin, MAPSEC_BATTLE_TOWER, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0202
    { NARC_area_data_narc_0033_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0194_bin, NARC_scr_seq_release_narc_0360_bin, NARC_scr_seq_release_narc_0820_bin, NARC_msg_narc_0018_bin, SEQ_BF_TOWWER, SEQ_BF_TOWWER, 0xFFFF, NARC_zone_event_release_narc_0313_bin, MAPSEC_BATTLE_TOWER, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0203
    { NARC_area_data_narc_0033_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0195_bin, NARC_scr_seq_release_narc_0361_bin, NARC_scr_seq_release_narc_0821_bin, NARC_msg_narc_0018_bin, SEQ_BF_TOWWER, SEQ_BF_TOWWER, 0xFFFF, NARC_zone_event_release_narc_0314_bin, MAPSEC_BATTLE_TOWER, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0204
    { NARC_area_data_narc_0033_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0197_bin, NARC_scr_seq_release_narc_0362_bin, NARC_scr_seq_release_narc_0822_bin, NARC_msg_narc_0284_bin, SEQ_BF_TOWWER, SEQ_BF_TOWWER, 0xFFFF, NARC_zone_event_release_narc_0315_bin, MAPSEC_BATTLE_TOWER, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0205
    { NARC_area_data_narc_0033_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0198_bin, NARC_scr_seq_release_narc_0363_bin, NARC_scr_seq_release_narc_0823_bin, NARC_msg_narc_0285_bin, SEQ_BF_TOWWER, SEQ_BF_TOWWER, 0xFFFF, NARC_zone_event_release_narc_0316_bin, MAPSEC_BATTLE_TOWER, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0206
    { NARC_area_data_narc_0005_bin, NARC_move_model_list_narc_0014_bin, NARC_map_matrix_narc_0118_bin, NARC_scr_seq_release_narc_0366_bin, NARC_scr_seq_release_narc_0825_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0317_bin, MAPSEC_MYSTERY_ZONE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_DIRECT2
    { NARC_area_data_narc_0005_bin, NARC_move_model_list_narc_0014_bin, NARC_map_matrix_narc_0121_bin, NARC_scr_seq_release_narc_0367_bin, NARC_scr_seq_release_narc_0826_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0318_bin, MAPSEC_MYSTERY_ZONE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_DIRECT4
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0379_bin, NARC_scr_seq_release_narc_0829_bin, NARC_msg_narc_0352_bin, SEQ_ROAD_A_D, SEQ_ROAD_A_N, 0xFFFF, NARC_zone_event_release_narc_0319_bin, MAPSEC_VERITY_LAKEFRONT, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_L01
    { NARC_area_data_narc_0020_bin, 20, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0380_bin, NARC_scr_seq_release_narc_0830_bin, NARC_msg_narc_0353_bin, SEQ_ROAD_A_D, SEQ_ROAD_A_N, 0xFFFF, NARC_zone_event_release_narc_0320_bin, MAPSEC_VERITY_LAKEFRONT, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_L01R0101
    { NARC_area_data_narc_0018_bin, NARC_move_model_list_narc_0012_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0381_bin, NARC_scr_seq_release_narc_0831_bin, NARC_msg_narc_0354_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, ENCDATA(NARC_d_enc_data_narc_0138_bin, NARC_p_enc_data_narc_0138_bin), NARC_zone_event_release_narc_0321_bin, MAPSEC_VALOR_LAKEFRONT, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_L02
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0147_bin, NARC_scr_seq_release_narc_0382_bin, NARC_scr_seq_release_narc_0832_bin, NARC_msg_narc_0355_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0322_bin, MAPSEC_RESTAURANT, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_L02R0101
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0146_bin, NARC_scr_seq_release_narc_0383_bin, NARC_scr_seq_release_narc_0833_bin, NARC_msg_narc_0356_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0323_bin, MAPSEC_GRAND_LAKE, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_L02R0201
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0146_bin, NARC_scr_seq_release_narc_0384_bin, NARC_scr_seq_release_narc_0834_bin, NARC_msg_narc_0357_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0324_bin, MAPSEC_GRAND_LAKE, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_L02R0301
    { NARC_area_data_narc_0014_bin, NARC_move_model_list_narc_0008_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0385_bin, NARC_scr_seq_release_narc_0835_bin, NARC_msg_narc_0358_bin, SEQ_ROAD_SNOW_D, SEQ_ROAD_SNOW_N, ENCDATA(NARC_d_enc_data_narc_0139_bin, NARC_p_enc_data_narc_0139_bin), NARC_zone_event_release_narc_0325_bin, MAPSEC_ACUITY_LAKEFRONT, 27, 0, 2, 5, FALSE, TRUE, FALSE, TRUE }, // MAP_L03
    { NARC_area_data_narc_0018_bin, NARC_move_model_list_narc_0012_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0326_bin, MAPSEC_SPRING_PATH, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_L04
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0392_bin, NARC_scr_seq_release_narc_0837_bin, NARC_msg_narc_0415_bin, SEQ_ROAD_A_D, SEQ_ROAD_A_N, ENCDATA(NARC_d_enc_data_narc_0140_bin, NARC_p_enc_data_narc_0140_bin), NARC_zone_event_release_narc_0327_bin, MAPSEC_ROUTE_201, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R201
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0393_bin, NARC_scr_seq_release_narc_0838_bin, NARC_msg_narc_0416_bin, SEQ_ROAD_A_D, SEQ_ROAD_A_N, ENCDATA(NARC_d_enc_data_narc_0141_bin, NARC_p_enc_data_narc_0141_bin), NARC_zone_event_release_narc_0328_bin, MAPSEC_ROUTE_202, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R202
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0394_bin, NARC_scr_seq_release_narc_0839_bin, NARC_msg_narc_0417_bin, SEQ_ROAD_B_D, SEQ_ROAD_B_N, ENCDATA(NARC_d_enc_data_narc_0142_bin, NARC_p_enc_data_narc_0142_bin), NARC_zone_event_release_narc_0329_bin, MAPSEC_ROUTE_203, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R203
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0395_bin, NARC_scr_seq_release_narc_0840_bin, NARC_msg_narc_0418_bin, SEQ_ROAD_B_D, SEQ_ROAD_B_N, ENCDATA(NARC_d_enc_data_narc_0143_bin, NARC_p_enc_data_narc_0143_bin), NARC_zone_event_release_narc_0330_bin, MAPSEC_ROUTE_204, 0, 0, 2, 0, TRUE, TRUE, TRUE, TRUE }, // MAP_R204A
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0396_bin, NARC_scr_seq_release_narc_0841_bin, NARC_msg_narc_0419_bin, SEQ_ROAD_B_D, SEQ_ROAD_B_N, ENCDATA(NARC_d_enc_data_narc_0144_bin, NARC_p_enc_data_narc_0144_bin), NARC_zone_event_release_narc_0331_bin, MAPSEC_ROUTE_204, 0, 0, 2, 0, TRUE, TRUE, TRUE, TRUE }, // MAP_R204B
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0397_bin, NARC_scr_seq_release_narc_0842_bin, NARC_msg_narc_0420_bin, SEQ_ROAD_C_D, SEQ_ROAD_C_N, ENCDATA(NARC_d_enc_data_narc_0145_bin, NARC_p_enc_data_narc_0145_bin), NARC_zone_event_release_narc_0332_bin, MAPSEC_ROUTE_205, 0, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R205A
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0398_bin, NARC_scr_seq_release_narc_0843_bin, NARC_msg_narc_0421_bin, SEQ_ROAD_C_D, SEQ_ROAD_C_N, 0xFFFF, NARC_zone_event_release_narc_0333_bin, MAPSEC_ROUTE_205, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R205AR0101
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0399_bin, NARC_scr_seq_release_narc_0844_bin, NARC_msg_narc_0422_bin, SEQ_ROAD_C_D, SEQ_ROAD_C_N, ENCDATA(NARC_d_enc_data_narc_0146_bin, NARC_p_enc_data_narc_0146_bin), NARC_zone_event_release_narc_0334_bin, MAPSEC_ROUTE_205, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R205B
    { NARC_area_data_narc_0007_bin, NARC_move_model_list_narc_0001_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0400_bin, NARC_scr_seq_release_narc_0845_bin, NARC_msg_narc_0423_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, ENCDATA(NARC_d_enc_data_narc_0147_bin, NARC_p_enc_data_narc_0147_bin), NARC_zone_event_release_narc_0335_bin, MAPSEC_ROUTE_206, 8, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R206
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0211_bin, NARC_scr_seq_release_narc_0401_bin, NARC_scr_seq_release_narc_0846_bin, NARC_msg_narc_0424_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0336_bin, MAPSEC_ROUTE_206, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R206R0101
    { NARC_area_data_narc_0031_bin, 31, NARC_map_matrix_narc_0157_bin, NARC_scr_seq_release_narc_0402_bin, NARC_scr_seq_release_narc_0847_bin, NARC_msg_narc_0425_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0337_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R206R0201
    { NARC_area_data_narc_0007_bin, NARC_move_model_list_narc_0001_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0403_bin, NARC_scr_seq_release_narc_0848_bin, NARC_msg_narc_0426_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, ENCDATA(NARC_d_enc_data_narc_0148_bin, NARC_p_enc_data_narc_0148_bin), NARC_zone_event_release_narc_0338_bin, MAPSEC_ROUTE_207, 0, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R207
    { NARC_area_data_narc_0009_bin, NARC_move_model_list_narc_0003_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0404_bin, NARC_scr_seq_release_narc_0849_bin, NARC_msg_narc_0427_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, ENCDATA(NARC_d_enc_data_narc_0149_bin, NARC_p_enc_data_narc_0149_bin), NARC_zone_event_release_narc_0339_bin, MAPSEC_ROUTE_208, 8, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R208
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0405_bin, NARC_scr_seq_release_narc_0850_bin, NARC_msg_narc_0428_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0340_bin, MAPSEC_ROUTE_208, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R208R0101
    { NARC_area_data_narc_0010_bin, NARC_move_model_list_narc_0004_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0406_bin, NARC_scr_seq_release_narc_0851_bin, NARC_msg_narc_0429_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, ENCDATA(NARC_d_enc_data_narc_0150_bin, NARC_p_enc_data_narc_0150_bin), NARC_zone_event_release_narc_0341_bin, MAPSEC_ROUTE_209, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R209
    { NARC_area_data_narc_0042_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0212_bin, NARC_scr_seq_release_narc_0407_bin, NARC_scr_seq_release_narc_0852_bin, NARC_msg_narc_0430_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0151_bin, NARC_p_enc_data_narc_0151_bin), NARC_zone_event_release_narc_0342_bin, MAPSEC_ROUTE_209, 0, 4, 4, 8, FALSE, FALSE, TRUE, FALSE }, // MAP_R209R0101
    { NARC_area_data_narc_0042_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0213_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0152_bin, NARC_p_enc_data_narc_0152_bin), NARC_zone_event_release_narc_0343_bin, MAPSEC_ROUTE_209, 0, 4, 4, 8, FALSE, FALSE, TRUE, FALSE }, // MAP_R209R0102
    { NARC_area_data_narc_0042_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0214_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0153_bin, NARC_p_enc_data_narc_0153_bin), NARC_zone_event_release_narc_0344_bin, MAPSEC_ROUTE_209, 0, 4, 4, 8, FALSE, FALSE, TRUE, FALSE }, // MAP_R209R0103
    { NARC_area_data_narc_0042_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0215_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0154_bin, NARC_p_enc_data_narc_0154_bin), NARC_zone_event_release_narc_0345_bin, MAPSEC_ROUTE_209, 0, 4, 4, 8, FALSE, FALSE, TRUE, FALSE }, // MAP_R209R0104
    { NARC_area_data_narc_0042_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0216_bin, NARC_scr_seq_release_narc_0411_bin, NARC_scr_seq_release_narc_0856_bin, NARC_msg_narc_0431_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0155_bin, NARC_p_enc_data_narc_0155_bin), NARC_zone_event_release_narc_0346_bin, MAPSEC_ROUTE_209, 0, 4, 4, 8, FALSE, FALSE, TRUE, FALSE }, // MAP_R209R0105
    { NARC_area_data_narc_0010_bin, NARC_move_model_list_narc_0004_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0412_bin, NARC_scr_seq_release_narc_0857_bin, NARC_msg_narc_0432_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, ENCDATA(NARC_d_enc_data_narc_0156_bin, NARC_p_enc_data_narc_0156_bin), NARC_zone_event_release_narc_0347_bin, MAPSEC_ROUTE_210, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R210A
    { NARC_area_data_narc_0010_bin, NARC_move_model_list_narc_0004_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0414_bin, NARC_scr_seq_release_narc_0859_bin, NARC_msg_narc_0434_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, ENCDATA(NARC_d_enc_data_narc_0157_bin, NARC_p_enc_data_narc_0157_bin), NARC_zone_event_release_narc_0348_bin, MAPSEC_ROUTE_210, 14, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R210B
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0415_bin, NARC_scr_seq_release_narc_0860_bin, NARC_msg_narc_0435_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, 0xFFFF, NARC_zone_event_release_narc_0349_bin, MAPSEC_ROUTE_210, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R210BR0101
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0416_bin, NARC_scr_seq_release_narc_0861_bin, NARC_msg_narc_0436_bin, SEQ_ROAD_C_D, SEQ_ROAD_C_N, ENCDATA(NARC_d_enc_data_narc_0158_bin, NARC_p_enc_data_narc_0158_bin), NARC_zone_event_release_narc_0350_bin, MAPSEC_ROUTE_211, 0, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R211A
    { NARC_area_data_narc_0010_bin, NARC_move_model_list_narc_0004_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0417_bin, NARC_scr_seq_release_narc_0862_bin, NARC_msg_narc_0437_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, ENCDATA(NARC_d_enc_data_narc_0159_bin, NARC_p_enc_data_narc_0159_bin), NARC_zone_event_release_narc_0351_bin, MAPSEC_ROUTE_211, 0, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R211B
    { NARC_area_data_narc_0012_bin, NARC_move_model_list_narc_0006_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0418_bin, NARC_scr_seq_release_narc_0863_bin, NARC_msg_narc_0438_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, ENCDATA(NARC_d_enc_data_narc_0160_bin, NARC_p_enc_data_narc_0160_bin), NARC_zone_event_release_narc_0352_bin, MAPSEC_ROUTE_212, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R212A
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0178_bin, NARC_scr_seq_release_narc_0419_bin, NARC_scr_seq_release_narc_0864_bin, NARC_msg_narc_0439_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, 0xFFFF, NARC_zone_event_release_narc_0353_bin, MAPSEC_POKEMON_MANSION, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R212AR0101
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0179_bin, NARC_scr_seq_release_narc_0420_bin, NARC_scr_seq_release_narc_0865_bin, NARC_msg_narc_0440_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, 0xFFFF, NARC_zone_event_release_narc_0354_bin, MAPSEC_POKEMON_MANSION, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R212AR0102
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0180_bin, NARC_scr_seq_release_narc_0421_bin, NARC_scr_seq_release_narc_0866_bin, NARC_msg_narc_0441_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, 0xFFFF, NARC_zone_event_release_narc_0355_bin, MAPSEC_POKEMON_MANSION, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R212AR0103
    { NARC_area_data_narc_0012_bin, NARC_move_model_list_narc_0006_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0422_bin, NARC_scr_seq_release_narc_0867_bin, NARC_msg_narc_0442_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, ENCDATA(NARC_d_enc_data_narc_0161_bin, NARC_p_enc_data_narc_0161_bin), NARC_zone_event_release_narc_0356_bin, MAPSEC_ROUTE_212, 24, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R212B
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0244_bin, NARC_scr_seq_release_narc_0423_bin, NARC_scr_seq_release_narc_0868_bin, NARC_msg_narc_0443_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, 0xFFFF, NARC_zone_event_release_narc_0357_bin, MAPSEC_ROUTE_212, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R212BR0101
    { NARC_area_data_narc_0018_bin, NARC_move_model_list_narc_0012_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0424_bin, NARC_scr_seq_release_narc_0869_bin, NARC_msg_narc_0444_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, ENCDATA(NARC_d_enc_data_narc_0162_bin, NARC_p_enc_data_narc_0162_bin), NARC_zone_event_release_narc_0358_bin, MAPSEC_ROUTE_213, 25, 0, 2, 1, TRUE, TRUE, FALSE, TRUE }, // MAP_R213
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0158_bin, NARC_scr_seq_release_narc_0425_bin, NARC_scr_seq_release_narc_0870_bin, NARC_msg_narc_0445_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0359_bin, MAPSEC_ROUTE_213, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R213R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0426_bin, NARC_scr_seq_release_narc_0871_bin, NARC_msg_narc_0446_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0360_bin, MAPSEC_FOOTSTEP_HOUSE, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R213R0201
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0145_bin, NARC_scr_seq_release_narc_0427_bin, NARC_scr_seq_release_narc_0872_bin, NARC_msg_narc_0447_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0361_bin, MAPSEC_GRAND_LAKE, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R213R0301
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0146_bin, NARC_scr_seq_release_narc_0428_bin, NARC_scr_seq_release_narc_0873_bin, NARC_msg_narc_0448_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0362_bin, MAPSEC_GRAND_LAKE, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R213R0401
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0146_bin, NARC_scr_seq_release_narc_0429_bin, NARC_scr_seq_release_narc_0874_bin, NARC_msg_narc_0449_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0363_bin, MAPSEC_GRAND_LAKE, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R213R0501
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0146_bin, NARC_scr_seq_release_narc_0430_bin, NARC_scr_seq_release_narc_0875_bin, NARC_msg_narc_0450_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0364_bin, MAPSEC_GRAND_LAKE, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R213R0601
    { NARC_area_data_narc_0018_bin, NARC_move_model_list_narc_0012_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0431_bin, NARC_scr_seq_release_narc_0876_bin, NARC_msg_narc_0451_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, ENCDATA(NARC_d_enc_data_narc_0163_bin, NARC_p_enc_data_narc_0163_bin), NARC_zone_event_release_narc_0365_bin, MAPSEC_ROUTE_214, 0, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R214
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0157_bin, NARC_scr_seq_release_narc_0432_bin, NARC_scr_seq_release_narc_0877_bin, NARC_msg_narc_0452_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, 0xFFFF, NARC_zone_event_release_narc_0366_bin, MAPSEC_ROUTE_214, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R214R0101
    { NARC_area_data_narc_0010_bin, NARC_move_model_list_narc_0004_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0433_bin, NARC_scr_seq_release_narc_0878_bin, NARC_msg_narc_0453_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, ENCDATA(NARC_d_enc_data_narc_0164_bin, NARC_p_enc_data_narc_0164_bin), NARC_zone_event_release_narc_0367_bin, MAPSEC_ROUTE_215, 2, 0, 2, 3, TRUE, TRUE, FALSE, TRUE }, // MAP_R215
    { NARC_area_data_narc_0014_bin, NARC_move_model_list_narc_0008_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0434_bin, NARC_scr_seq_release_narc_0879_bin, NARC_msg_narc_0454_bin, SEQ_ROAD_SNOW_D, SEQ_ROAD_SNOW_N, ENCDATA(NARC_d_enc_data_narc_0165_bin, NARC_p_enc_data_narc_0165_bin), NARC_zone_event_release_narc_0368_bin, MAPSEC_ROUTE_216, 26, 0, 2, 5, FALSE, TRUE, FALSE, TRUE }, // MAP_R216
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0435_bin, NARC_scr_seq_release_narc_0880_bin, NARC_msg_narc_0455_bin, SEQ_ROAD_SNOW_D, SEQ_ROAD_SNOW_N, 0xFFFF, NARC_zone_event_release_narc_0369_bin, MAPSEC_ROUTE_216, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R216R0101
    { NARC_area_data_narc_0014_bin, NARC_move_model_list_narc_0008_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0436_bin, NARC_scr_seq_release_narc_0881_bin, NARC_msg_narc_0456_bin, SEQ_ROAD_SNOW_D, SEQ_ROAD_SNOW_N, ENCDATA(NARC_d_enc_data_narc_0166_bin, NARC_p_enc_data_narc_0166_bin), NARC_zone_event_release_narc_0370_bin, MAPSEC_ROUTE_217, 7, 0, 2, 5, FALSE, TRUE, FALSE, TRUE }, // MAP_R217
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0124_bin, NARC_scr_seq_release_narc_0437_bin, NARC_scr_seq_release_narc_0882_bin, NARC_msg_narc_0457_bin, SEQ_ROAD_SNOW_D, SEQ_ROAD_SNOW_N, 0xFFFF, NARC_zone_event_release_narc_0371_bin, MAPSEC_ROUTE_217, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R217R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0124_bin, NARC_scr_seq_release_narc_0438_bin, NARC_scr_seq_release_narc_0883_bin, NARC_msg_narc_0458_bin, SEQ_ROAD_SNOW_D, SEQ_ROAD_SNOW_N, 0xFFFF, NARC_zone_event_release_narc_0372_bin, MAPSEC_ROUTE_217, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R217R0201
    { NARC_area_data_narc_0015_bin, NARC_move_model_list_narc_0009_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0439_bin, NARC_scr_seq_release_narc_0884_bin, NARC_msg_narc_0459_bin, SEQ_ROAD_B_D, SEQ_ROAD_B_N, ENCDATA(NARC_d_enc_data_narc_0167_bin, NARC_p_enc_data_narc_0167_bin), NARC_zone_event_release_narc_0373_bin, MAPSEC_ROUTE_218, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R218
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0158_bin, NARC_scr_seq_release_narc_0440_bin, NARC_scr_seq_release_narc_0885_bin, NARC_msg_narc_0460_bin, SEQ_ROAD_B_D, SEQ_ROAD_B_N, 0xFFFF, NARC_zone_event_release_narc_0374_bin, MAPSEC_ROUTE_218, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R218R0101
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0158_bin, NARC_scr_seq_release_narc_0441_bin, NARC_scr_seq_release_narc_0886_bin, NARC_msg_narc_0461_bin, SEQ_ROAD_B_D, SEQ_ROAD_B_N, 0xFFFF, NARC_zone_event_release_narc_0375_bin, MAPSEC_ROUTE_218, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R218R0201
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0442_bin, NARC_scr_seq_release_narc_0887_bin, NARC_msg_narc_0462_bin, SEQ_ROAD_A_D, SEQ_ROAD_A_N, ENCDATA(NARC_d_enc_data_narc_0168_bin, NARC_p_enc_data_narc_0168_bin), NARC_zone_event_release_narc_0376_bin, MAPSEC_ROUTE_219, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R219
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0443_bin, NARC_scr_seq_release_narc_0888_bin, NARC_msg_narc_0463_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, ENCDATA(NARC_d_enc_data_narc_0169_bin, NARC_p_enc_data_narc_0169_bin), NARC_zone_event_release_narc_0377_bin, MAPSEC_ROUTE_221, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R221
    { NARC_area_data_narc_0039_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0201_bin, NARC_scr_seq_release_narc_0444_bin, NARC_scr_seq_release_narc_0889_bin, NARC_msg_narc_0464_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0378_bin, MAPSEC_PAL_PARK, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R221R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0244_bin, NARC_scr_seq_release_narc_0445_bin, NARC_scr_seq_release_narc_0890_bin, NARC_msg_narc_0465_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0379_bin, MAPSEC_ROUTE_221, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R221R0201
    { NARC_area_data_narc_0018_bin, NARC_move_model_list_narc_0012_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0446_bin, NARC_scr_seq_release_narc_0891_bin, NARC_msg_narc_0466_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, ENCDATA(NARC_d_enc_data_narc_0170_bin, NARC_p_enc_data_narc_0170_bin), NARC_zone_event_release_narc_0380_bin, MAPSEC_ROUTE_222, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R222
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0447_bin, NARC_scr_seq_release_narc_0892_bin, NARC_msg_narc_0467_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, 0xFFFF, NARC_zone_event_release_narc_0381_bin, MAPSEC_ROUTE_222, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R222R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0448_bin, NARC_scr_seq_release_narc_0893_bin, NARC_msg_narc_0468_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, 0xFFFF, NARC_zone_event_release_narc_0382_bin, MAPSEC_ROUTE_222, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R222R0201
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0158_bin, NARC_scr_seq_release_narc_0449_bin, NARC_scr_seq_release_narc_0894_bin, NARC_msg_narc_0469_bin, SEQ_ROAD_E_D, SEQ_ROAD_E_N, 0xFFFF, NARC_zone_event_release_narc_0383_bin, MAPSEC_ROUTE_222, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R222R0301
    { NARC_area_data_narc_0013_bin, NARC_move_model_list_narc_0010_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0450_bin, NARC_scr_seq_release_narc_0895_bin, NARC_msg_narc_0470_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, ENCDATA(NARC_d_enc_data_narc_0171_bin, NARC_p_enc_data_narc_0171_bin), NARC_zone_event_release_narc_0384_bin, MAPSEC_ROUTE_224, 0, 0, 2, 0, TRUE, TRUE, FALSE, TRUE }, // MAP_R224
    { NARC_area_data_narc_0017_bin, NARC_move_model_list_narc_0011_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0451_bin, NARC_scr_seq_release_narc_0896_bin, NARC_msg_narc_0471_bin, SEQ_TOWN06_D, SEQ_TOWN06_N, ENCDATA(NARC_d_enc_data_narc_0172_bin, NARC_p_enc_data_narc_0172_bin), NARC_zone_event_release_narc_0385_bin, MAPSEC_ROUTE_225, 0, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R225
    { NARC_area_data_narc_0017_bin, NARC_move_model_list_narc_0011_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_R226A
    { NARC_area_data_narc_0017_bin, NARC_move_model_list_narc_0011_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_R226B
    { NARC_area_data_narc_0017_bin, NARC_move_model_list_narc_0011_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0454_bin, NARC_scr_seq_release_narc_0899_bin, NARC_msg_narc_0474_bin, SEQ_TOWN06_D, SEQ_TOWN06_N, ENCDATA(NARC_d_enc_data_narc_0173_bin, NARC_p_enc_data_narc_0173_bin), NARC_zone_event_release_narc_0386_bin, MAPSEC_ROUTE_227, 9, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R227
    { NARC_area_data_narc_0017_bin, NARC_move_model_list_narc_0011_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_R227A
    { NARC_area_data_narc_0017_bin, NARC_move_model_list_narc_0011_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_R227B
    { NARC_area_data_narc_0019_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0456_bin, NARC_scr_seq_release_narc_0901_bin, NARC_msg_narc_0476_bin, SEQ_ROAD_BZA_D, SEQ_ROAD_BZA_N, ENCDATA(NARC_d_enc_data_narc_0174_bin, NARC_p_enc_data_narc_0174_bin), NARC_zone_event_release_narc_0387_bin, MAPSEC_ROUTE_228, 10, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_R228
    { NARC_area_data_narc_0019_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0460_bin, NARC_scr_seq_release_narc_0905_bin, NARC_msg_narc_0480_bin, SEQ_ROAD_BZA_D, SEQ_ROAD_BZA_N, ENCDATA(NARC_d_enc_data_narc_0175_bin, NARC_p_enc_data_narc_0175_bin), NARC_zone_event_release_narc_0388_bin, MAPSEC_ROUTE_229, 0, 0, 2, 3, TRUE, TRUE, FALSE, TRUE }, // MAP_R229
    { NARC_area_data_narc_0019_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_R230
    { NARC_area_data_narc_0019_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_R232
    { NARC_area_data_narc_0005_bin, NARC_move_model_list_narc_0014_bin, NARC_map_matrix_narc_0119_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_RECORD
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0978_bin, NARC_scr_seq_release_narc_0908_bin, NARC_msg_narc_0498_bin, SEQ_TOWN01_D, SEQ_TOWN01_N, ENCDATA(NARC_d_enc_data_narc_0176_bin, NARC_p_enc_data_narc_0176_bin), NARC_zone_event_release_narc_0389_bin, MAPSEC_TWINLEAF_TOWN, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_T01
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0126_bin, NARC_scr_seq_release_narc_0979_bin, NARC_scr_seq_release_narc_0909_bin, NARC_msg_narc_0499_bin, SEQ_TOWN01_D, SEQ_TOWN01_N, 0xFFFF, NARC_zone_event_release_narc_0390_bin, MAPSEC_TWINLEAF_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T01R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0127_bin, NARC_scr_seq_release_narc_0980_bin, NARC_scr_seq_release_narc_0910_bin, NARC_msg_narc_0500_bin, SEQ_TOWN01_D, SEQ_TOWN01_N, 0xFFFF, NARC_zone_event_release_narc_0391_bin, MAPSEC_TWINLEAF_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T01R0102
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0128_bin, NARC_scr_seq_release_narc_0981_bin, NARC_scr_seq_release_narc_0911_bin, NARC_msg_narc_0501_bin, SEQ_TOWN01_D, SEQ_TOWN01_N, 0xFFFF, NARC_zone_event_release_narc_0392_bin, MAPSEC_TWINLEAF_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T01R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0129_bin, NARC_scr_seq_release_narc_0982_bin, NARC_scr_seq_release_narc_0912_bin, NARC_msg_narc_0502_bin, SEQ_TOWN01_D, SEQ_TOWN01_N, 0xFFFF, NARC_zone_event_release_narc_0393_bin, MAPSEC_TWINLEAF_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T01R0202
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0983_bin, NARC_scr_seq_release_narc_0913_bin, NARC_msg_narc_0503_bin, SEQ_TOWN01_D, SEQ_TOWN01_N, 0xFFFF, NARC_zone_event_release_narc_0394_bin, MAPSEC_TWINLEAF_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T01R0301
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0984_bin, NARC_scr_seq_release_narc_0914_bin, NARC_msg_narc_0504_bin, SEQ_TOWN01_D, SEQ_TOWN01_N, 0xFFFF, NARC_zone_event_release_narc_0395_bin, MAPSEC_TWINLEAF_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T01R0401
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0985_bin, NARC_scr_seq_release_narc_0915_bin, NARC_msg_narc_0505_bin, SEQ_TOWN02_D, SEQ_TOWN02_N, 0xFFFF, NARC_zone_event_release_narc_0396_bin, MAPSEC_SANDGEM_TOWN, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_T02
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0986_bin, NARC_scr_seq_release_narc_0916_bin, NARC_msg_narc_0506_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0397_bin, MAPSEC_SANDGEM_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T02FS0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0987_bin, NARC_scr_seq_release_narc_0917_bin, NARC_msg_narc_0507_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0398_bin, MAPSEC_SANDGEM_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T02PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0988_bin, NARC_scr_seq_release_narc_0918_bin, NARC_msg_narc_0508_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0399_bin, MAPSEC_SANDGEM_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T02PC0102
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0160_bin, NARC_scr_seq_release_narc_0990_bin, NARC_scr_seq_release_narc_0920_bin, NARC_msg_narc_0509_bin, SEQ_KENKYUJO, SEQ_KENKYUJO, 0xFFFF, NARC_zone_event_release_narc_0400_bin, MAPSEC_SANDGEM_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T02R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0130_bin, NARC_scr_seq_release_narc_0991_bin, NARC_scr_seq_release_narc_0921_bin, NARC_msg_narc_0510_bin, SEQ_TOWN02_D, SEQ_TOWN02_N, 0xFFFF, NARC_zone_event_release_narc_0401_bin, MAPSEC_SANDGEM_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T02R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0131_bin, NARC_scr_seq_release_narc_0992_bin, NARC_scr_seq_release_narc_0922_bin, NARC_msg_narc_0511_bin, SEQ_TOWN02_D, SEQ_TOWN02_N, 0xFFFF, NARC_zone_event_release_narc_0402_bin, MAPSEC_SANDGEM_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T02R0202
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0993_bin, NARC_scr_seq_release_narc_0923_bin, NARC_msg_narc_0512_bin, SEQ_TOWN02_D, SEQ_TOWN02_N, 0xFFFF, NARC_zone_event_release_narc_0403_bin, MAPSEC_SANDGEM_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T02R0301
    { NARC_area_data_narc_0008_bin, NARC_move_model_list_narc_0002_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0994_bin, NARC_scr_seq_release_narc_0924_bin, NARC_msg_narc_0513_bin, SEQ_TOWN03_D, SEQ_TOWN03_N, 0xFFFF, NARC_zone_event_release_narc_0404_bin, MAPSEC_FLOAROMA_TOWN, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_T03
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_0995_bin, NARC_scr_seq_release_narc_0925_bin, NARC_msg_narc_0514_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0405_bin, MAPSEC_FLOAROMA_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T03FS0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_0996_bin, NARC_scr_seq_release_narc_0926_bin, NARC_msg_narc_0515_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0406_bin, MAPSEC_FLOAROMA_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T03PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0997_bin, NARC_scr_seq_release_narc_0927_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0407_bin, MAPSEC_FLOAROMA_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T03PC0102
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0236_bin, NARC_scr_seq_release_narc_0999_bin, NARC_scr_seq_release_narc_0929_bin, NARC_msg_narc_0516_bin, SEQ_TOWN03_D, SEQ_TOWN03_N, 0xFFFF, NARC_zone_event_release_narc_0408_bin, MAPSEC_FLOWER_SHOP, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T03R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_1000_bin, NARC_scr_seq_release_narc_0930_bin, NARC_msg_narc_0517_bin, SEQ_TOWN03_D, SEQ_TOWN03_N, 0xFFFF, NARC_zone_event_release_narc_0409_bin, MAPSEC_FLOAROMA_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T03R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_1001_bin, NARC_scr_seq_release_narc_0931_bin, NARC_msg_narc_0518_bin, SEQ_TOWN03_D, SEQ_TOWN03_N, 0xFFFF, NARC_zone_event_release_narc_0410_bin, MAPSEC_FLOAROMA_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T03R0301
    { NARC_area_data_narc_0010_bin, NARC_move_model_list_narc_0004_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_1002_bin, NARC_scr_seq_release_narc_0932_bin, NARC_msg_narc_0519_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0411_bin, MAPSEC_SOLACEON_TOWN, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_T04
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_1003_bin, NARC_scr_seq_release_narc_0933_bin, NARC_msg_narc_0520_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0412_bin, MAPSEC_SOLACEON_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T04FS0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_1004_bin, NARC_scr_seq_release_narc_0934_bin, NARC_msg_narc_0521_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0413_bin, MAPSEC_SOLACEON_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T04PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_1005_bin, NARC_scr_seq_release_narc_0935_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0414_bin, MAPSEC_SOLACEON_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T04PC0102
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0137_bin, NARC_scr_seq_release_narc_1007_bin, NARC_scr_seq_release_narc_0937_bin, NARC_msg_narc_0522_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0415_bin, MAPSEC_POKEMON_DAY_CARE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T04R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_1008_bin, NARC_scr_seq_release_narc_0938_bin, NARC_msg_narc_0523_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0416_bin, MAPSEC_SOLACEON_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T04R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0244_bin, NARC_scr_seq_release_narc_1009_bin, NARC_scr_seq_release_narc_0939_bin, NARC_msg_narc_0524_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0417_bin, MAPSEC_SOLACEON_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T04R0301
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_1010_bin, NARC_scr_seq_release_narc_0940_bin, NARC_msg_narc_0525_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0418_bin, MAPSEC_SOLACEON_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T04R0401
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_1011_bin, NARC_scr_seq_release_narc_0941_bin, NARC_msg_narc_0526_bin, SEQ_CITY06_D, SEQ_CITY06_N, 0xFFFF, NARC_zone_event_release_narc_0419_bin, MAPSEC_SOLACEON_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T04R0501
    { NARC_area_data_narc_0010_bin, NARC_move_model_list_narc_0004_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_1012_bin, NARC_scr_seq_release_narc_0942_bin, NARC_msg_narc_0527_bin, SEQ_CITY04_D, SEQ_CITY04_N, ENCDATA(NARC_d_enc_data_narc_0177_bin, NARC_p_enc_data_narc_0177_bin), NARC_zone_event_release_narc_0420_bin, MAPSEC_CELESTIC_TOWN, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_T05
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_1014_bin, NARC_scr_seq_release_narc_0944_bin, NARC_msg_narc_0528_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0421_bin, MAPSEC_CELESTIC_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T05PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_1015_bin, NARC_scr_seq_release_narc_0945_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0422_bin, MAPSEC_CELESTIC_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T05PC0102
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0168_bin, NARC_scr_seq_release_narc_1017_bin, NARC_scr_seq_release_narc_0947_bin, NARC_msg_narc_0529_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0423_bin, MAPSEC_CELESTIC_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T05R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0170_bin, NARC_scr_seq_release_narc_1018_bin, NARC_scr_seq_release_narc_0948_bin, NARC_msg_narc_0530_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0424_bin, MAPSEC_CELESTIC_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T05R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0124_bin, NARC_scr_seq_release_narc_1019_bin, NARC_scr_seq_release_narc_0949_bin, NARC_msg_narc_0531_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0425_bin, MAPSEC_CELESTIC_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T05R0301
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0124_bin, NARC_scr_seq_release_narc_1020_bin, NARC_scr_seq_release_narc_0950_bin, NARC_msg_narc_0532_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0426_bin, MAPSEC_CELESTIC_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T05R0401
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0169_bin, NARC_scr_seq_release_narc_1021_bin, NARC_scr_seq_release_narc_0951_bin, NARC_msg_narc_0533_bin, SEQ_CITY04_D, SEQ_CITY04_N, 0xFFFF, NARC_zone_event_release_narc_0427_bin, MAPSEC_CELESTIC_TOWN, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T05R0501
    { NARC_area_data_narc_0017_bin, NARC_move_model_list_narc_0011_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_1022_bin, NARC_scr_seq_release_narc_0952_bin, NARC_msg_narc_0534_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0428_bin, MAPSEC_SURVIVAL_AREA, 0, 0, 1, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_T06
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_1023_bin, NARC_scr_seq_release_narc_0953_bin, NARC_msg_narc_0535_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0429_bin, MAPSEC_SURVIVAL_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T06FS0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_1024_bin, NARC_scr_seq_release_narc_0954_bin, NARC_msg_narc_0536_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0430_bin, MAPSEC_SURVIVAL_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T06PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_1025_bin, NARC_scr_seq_release_narc_0955_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0431_bin, MAPSEC_SURVIVAL_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T06PC0102
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_1027_bin, NARC_scr_seq_release_narc_0957_bin, NARC_msg_narc_0537_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0432_bin, MAPSEC_SURVIVAL_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T06R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_1028_bin, NARC_scr_seq_release_narc_0958_bin, NARC_msg_narc_0538_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0433_bin, MAPSEC_SURVIVAL_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T06R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_1029_bin, NARC_scr_seq_release_narc_0959_bin, NARC_msg_narc_0539_bin, SEQ_CITY11_D, SEQ_CITY11_N, 0xFFFF, NARC_zone_event_release_narc_0434_bin, MAPSEC_SURVIVAL_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T06R0301
    { NARC_area_data_narc_0019_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_1030_bin, NARC_scr_seq_release_narc_0960_bin, NARC_msg_narc_0540_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, ENCDATA(NARC_d_enc_data_narc_0178_bin, NARC_p_enc_data_narc_0178_bin), NARC_zone_event_release_narc_0435_bin, MAPSEC_RESORT_AREA, 0, 0, 1, 2, TRUE, TRUE, FALSE, TRUE }, // MAP_T07
    { NARC_area_data_narc_0022_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0122_bin, NARC_scr_seq_release_narc_1031_bin, NARC_scr_seq_release_narc_0961_bin, NARC_msg_narc_0541_bin, SEQ_FS, SEQ_FS, 0xFFFF, NARC_zone_event_release_narc_0436_bin, MAPSEC_RESORT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T07FS0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0116_bin, NARC_scr_seq_release_narc_1032_bin, NARC_scr_seq_release_narc_0962_bin, NARC_msg_narc_0542_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0437_bin, MAPSEC_RESORT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T07PC0101
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_1033_bin, NARC_scr_seq_release_narc_0963_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0438_bin, MAPSEC_RESORT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T07PC0102
    { NARC_area_data_narc_0038_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0199_bin, NARC_scr_seq_release_narc_1035_bin, NARC_scr_seq_release_narc_0965_bin, NARC_msg_narc_0543_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0439_bin, MAPSEC_RESORT_AREA, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_T07R0101
    { NARC_area_data_narc_0038_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0200_bin, NARC_scr_seq_release_narc_1036_bin, NARC_scr_seq_release_narc_0966_bin, NARC_msg_narc_0544_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0440_bin, MAPSEC_RESORT_AREA, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_T07R0102
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0207_bin, NARC_scr_seq_release_narc_1037_bin, NARC_scr_seq_release_narc_0967_bin, NARC_msg_narc_0545_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0441_bin, MAPSEC_RESORT_AREA, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_T07R0103
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_1038_bin, NARC_scr_seq_release_narc_0968_bin, NARC_msg_narc_0546_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0442_bin, MAPSEC_RESORT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T07R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_1039_bin, NARC_scr_seq_release_narc_0969_bin, NARC_msg_narc_0547_bin, SEQ_TOWN07_D, SEQ_TOWN07_N, 0xFFFF, NARC_zone_event_release_narc_0443_bin, MAPSEC_RESORT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T07R0301
    { NARC_area_data_narc_0005_bin, NARC_move_model_list_narc_0014_bin, NARC_map_matrix_narc_0120_bin, NARC_scr_seq_release_narc_1044_bin, NARC_scr_seq_release_narc_0971_bin, NARC_msg_narc_0576_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0444_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_UNION
    { NARC_area_data_narc_0006_bin, NARC_move_model_list_narc_0000_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_ROAD_D_D, SEQ_ROAD_D_N, ENCDATA(NARC_d_enc_data_narc_0179_bin, NARC_p_enc_data_narc_0179_bin), NARC_zone_event_release_narc_0445_bin, MAPSEC_ROUTE_220, 0, 0, 2, 1, TRUE, TRUE, FALSE, TRUE }, // MAP_W220
    { NARC_area_data_narc_0013_bin, NARC_move_model_list_narc_0007_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, ENCDATA(NARC_d_enc_data_narc_0180_bin, NARC_p_enc_data_narc_0180_bin), NARC_zone_event_release_narc_0446_bin, MAPSEC_ROUTE_223, 0, 11, 2, 1, TRUE, TRUE, FALSE, TRUE }, // MAP_W223
    { NARC_area_data_narc_0017_bin, NARC_move_model_list_narc_0011_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_1047_bin, NARC_scr_seq_release_narc_0974_bin, NARC_msg_narc_0583_bin, SEQ_TOWN06_D, SEQ_TOWN06_N, ENCDATA(NARC_d_enc_data_narc_0181_bin, NARC_p_enc_data_narc_0181_bin), NARC_zone_event_release_narc_0447_bin, MAPSEC_ROUTE_226, 0, 0, 2, 4, TRUE, TRUE, FALSE, TRUE }, // MAP_W226
    { NARC_area_data_narc_0019_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_W229
    { NARC_area_data_narc_0019_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_1049_bin, NARC_scr_seq_release_narc_0976_bin, NARC_msg_narc_0585_bin, SEQ_ROAD_BZA_D, SEQ_ROAD_BZA_N, ENCDATA(NARC_d_enc_data_narc_0182_bin, NARC_p_enc_data_narc_0182_bin), NARC_zone_event_release_narc_0448_bin, MAPSEC_ROUTE_230, 0, 0, 2, 1, TRUE, TRUE, FALSE, TRUE }, // MAP_W230
    { NARC_area_data_narc_0013_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_TOWN03_D, SEQ_TOWN03_N, 0xFFFF, NARC_zone_event_release_narc_0449_bin, MAPSEC_SEABREAK_PATH, 0, 0, 2, 1, TRUE, TRUE, FALSE, TRUE }, // MAP_W231
    { NARC_area_data_narc_0019_bin, NARC_move_model_list_narc_0013_bin, NARC_map_matrix_narc_0000_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_DUMMY, SEQ_DUMMY, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_MYSTERY_ZONE, 0, 0, 2, 1, TRUE, TRUE, FALSE, FALSE }, // MAP_W233
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0007_bin, NARC_scr_seq_release_narc_0470_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0450_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C01PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0039_bin, NARC_scr_seq_release_narc_0502_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0451_bin, MAPSEC_CANALAVE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0053_bin, NARC_scr_seq_release_narc_0516_bin, NARC_msg_narc_0062_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0452_bin, MAPSEC_OREBURGH_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C03PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0075_bin, NARC_scr_seq_release_narc_0538_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0453_bin, MAPSEC_ETERNA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C04PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0099_bin, NARC_scr_seq_release_narc_0562_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0454_bin, MAPSEC_HEARTHOME_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C05PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0123_bin, NARC_scr_seq_release_narc_0586_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0455_bin, MAPSEC_PASTORIA_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C06PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0135_bin, NARC_scr_seq_release_narc_0598_bin, NARC_msg_narc_0138_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0456_bin, MAPSEC_VEILSTONE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C07PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0157_bin, NARC_scr_seq_release_narc_0620_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0457_bin, MAPSEC_SUNYSHORE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C08PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0173_bin, NARC_scr_seq_release_narc_0636_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0458_bin, MAPSEC_SNOWPOINT_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C09PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0179_bin, NARC_scr_seq_release_narc_0642_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0459_bin, MAPSEC_POKEMON_LEAGUE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C10PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0199_bin, NARC_scr_seq_release_narc_0662_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0460_bin, MAPSEC_FIGHT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C11PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0989_bin, NARC_scr_seq_release_narc_0919_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0461_bin, MAPSEC_SANDGEM_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T02PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0998_bin, NARC_scr_seq_release_narc_0928_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0462_bin, MAPSEC_FLOAROMA_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T03PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_1006_bin, NARC_scr_seq_release_narc_0936_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0463_bin, MAPSEC_SOLACEON_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T04PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_1016_bin, NARC_scr_seq_release_narc_0946_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0464_bin, MAPSEC_CELESTIC_TOWN, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T05PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_1026_bin, NARC_scr_seq_release_narc_0956_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0465_bin, MAPSEC_SURVIVAL_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T06PC0103
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_1034_bin, NARC_scr_seq_release_narc_0964_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0466_bin, MAPSEC_RESORT_AREA, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_T07PC0103
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0124_bin, NARC_scr_seq_release_narc_0047_bin, NARC_scr_seq_release_narc_0510_bin, NARC_msg_narc_0018_bin, SEQ_CITY02_D, SEQ_CITY02_N, 0xFFFF, NARC_zone_event_release_narc_0467_bin, MAPSEC_CANALAVE_CITY, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C02R0601
    { NARC_area_data_narc_0035_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0171_bin, NARC_scr_seq_release_narc_0413_bin, NARC_scr_seq_release_narc_0858_bin, NARC_msg_narc_0433_bin, SEQ_ROAD_F_D, SEQ_ROAD_F_N, 0xFFFF, NARC_zone_event_release_narc_0468_bin, MAPSEC_CAFE, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_R210AR0101
    { NARC_area_data_narc_0033_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0196_bin, NARC_scr_seq_release_narc_0364_bin, NARC_scr_seq_release_narc_0824_bin, NARC_msg_narc_0286_bin, SEQ_BF_TOWWER, SEQ_BF_TOWWER, 0xFFFF, NARC_zone_event_release_narc_0469_bin, MAPSEC_BATTLE_TOWER, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_D31R0207
    { NARC_area_data_narc_0058_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0238_bin, NARC_scr_seq_release_narc_0339_bin, NARC_scr_seq_release_narc_0799_bin, NARC_msg_narc_0268_bin, SEQ_THE_EVENT04, SEQ_THE_EVENT04, 0xFFFF, NARC_zone_event_release_narc_0470_bin, MAPSEC_GALACTIC_HQ, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_D26R0107
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0117_bin, NARC_scr_seq_release_narc_0193_bin, NARC_scr_seq_release_narc_0656_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0471_bin, MAPSEC_POKEMON_LEAGUE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0114
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0235_bin, NARC_scr_seq_release_narc_0194_bin, NARC_scr_seq_release_narc_0657_bin, NARC_msg_narc_0018_bin, SEQ_PC_01, SEQ_PC_02, 0xFFFF, NARC_zone_event_release_narc_0472_bin, MAPSEC_POKEMON_LEAGUE, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_C10R0115
    { NARC_area_data_narc_0058_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0239_bin, NARC_scr_seq_release_narc_0340_bin, NARC_scr_seq_release_narc_0800_bin, NARC_msg_narc_0269_bin, SEQ_THE_EVENT04, SEQ_THE_EVENT04, 0xFFFF, NARC_zone_event_release_narc_0473_bin, MAPSEC_GALACTIC_HQ, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_D26R0108
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0123_bin, NARC_scr_seq_release_narc_0452_bin, NARC_scr_seq_release_narc_0897_bin, NARC_msg_narc_0472_bin, SEQ_TOWN06_D, SEQ_TOWN06_N, 0xFFFF, NARC_zone_event_release_narc_0474_bin, MAPSEC_ROUTE_225, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R225R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0244_bin, NARC_scr_seq_release_narc_1048_bin, NARC_scr_seq_release_narc_0975_bin, NARC_msg_narc_0584_bin, SEQ_TOWN06_D, SEQ_TOWN06_N, 0xFFFF, NARC_zone_event_release_narc_0475_bin, MAPSEC_ROUTE_226, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_W226R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0455_bin, NARC_scr_seq_release_narc_0900_bin, NARC_msg_narc_0475_bin, SEQ_TOWN06_D, SEQ_TOWN06_N, 0xFFFF, NARC_zone_event_release_narc_0476_bin, MAPSEC_ROUTE_227, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R227R0101
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0158_bin, NARC_scr_seq_release_narc_0457_bin, NARC_scr_seq_release_narc_0902_bin, NARC_msg_narc_0477_bin, SEQ_ROAD_BZA_D, SEQ_ROAD_BZA_N, 0xFFFF, NARC_zone_event_release_narc_0477_bin, MAPSEC_ROUTE_228, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R228R0101
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0244_bin, NARC_scr_seq_release_narc_0458_bin, NARC_scr_seq_release_narc_0903_bin, NARC_msg_narc_0478_bin, SEQ_ROAD_BZA_D, SEQ_ROAD_BZA_N, 0xFFFF, NARC_zone_event_release_narc_0478_bin, MAPSEC_ROUTE_228, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R228R0201
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0125_bin, NARC_scr_seq_release_narc_0459_bin, NARC_scr_seq_release_narc_0904_bin, NARC_msg_narc_0479_bin, SEQ_ROAD_BZA_D, SEQ_ROAD_BZA_N, 0xFFFF, NARC_zone_event_release_narc_0479_bin, MAPSEC_ROUTE_228, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_R228R0301
    { NARC_area_data_narc_0053_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0240_bin, NARC_scr_seq_release_narc_0235_bin, NARC_scr_seq_release_narc_0695_bin, NARC_msg_narc_0223_bin, SEQ_D_SAFARI, SEQ_D_SAFARI, ENCDATA(NARC_d_enc_data_narc_0023_bin, NARC_p_enc_data_narc_0023_bin), NARC_zone_event_release_narc_0480_bin, MAPSEC_GREAT_MARSH, 0, 2, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_D06R0201
    { NARC_area_data_narc_0053_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0240_bin, NARC_scr_seq_release_narc_0236_bin, NARC_scr_seq_release_narc_0696_bin, NARC_msg_narc_0224_bin, SEQ_D_SAFARI, SEQ_D_SAFARI, ENCDATA(NARC_d_enc_data_narc_0024_bin, NARC_p_enc_data_narc_0024_bin), NARC_zone_event_release_narc_0481_bin, MAPSEC_GREAT_MARSH, 0, 2, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_D06R0202
    { NARC_area_data_narc_0053_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0240_bin, NARC_scr_seq_release_narc_0237_bin, NARC_scr_seq_release_narc_0697_bin, NARC_msg_narc_0225_bin, SEQ_D_SAFARI, SEQ_D_SAFARI, ENCDATA(NARC_d_enc_data_narc_0025_bin, NARC_p_enc_data_narc_0025_bin), NARC_zone_event_release_narc_0482_bin, MAPSEC_GREAT_MARSH, 0, 2, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_D06R0203
    { NARC_area_data_narc_0053_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0240_bin, NARC_scr_seq_release_narc_0238_bin, NARC_scr_seq_release_narc_0698_bin, NARC_msg_narc_0226_bin, SEQ_D_SAFARI, SEQ_D_SAFARI, ENCDATA(NARC_d_enc_data_narc_0026_bin, NARC_p_enc_data_narc_0026_bin), NARC_zone_event_release_narc_0483_bin, MAPSEC_GREAT_MARSH, 0, 2, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_D06R0204
    { NARC_area_data_narc_0053_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0240_bin, NARC_scr_seq_release_narc_0239_bin, NARC_scr_seq_release_narc_0699_bin, NARC_msg_narc_0227_bin, SEQ_D_SAFARI, SEQ_D_SAFARI, ENCDATA(NARC_d_enc_data_narc_0027_bin, NARC_p_enc_data_narc_0027_bin), NARC_zone_event_release_narc_0484_bin, MAPSEC_GREAT_MARSH, 0, 2, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_D06R0205
    { NARC_area_data_narc_0053_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0240_bin, NARC_scr_seq_release_narc_0240_bin, NARC_scr_seq_release_narc_0700_bin, NARC_msg_narc_0228_bin, SEQ_D_SAFARI, SEQ_D_SAFARI, ENCDATA(NARC_d_enc_data_narc_0028_bin, NARC_p_enc_data_narc_0028_bin), NARC_zone_event_release_narc_0485_bin, MAPSEC_GREAT_MARSH, 0, 2, 2, 3, TRUE, TRUE, FALSE, FALSE }, // MAP_D06R0206
    { NARC_area_data_narc_0050_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0241_bin, NARC_scr_seq_release_narc_0232_bin, NARC_scr_seq_release_narc_0692_bin, NARC_msg_narc_0221_bin, SEQ_AUS, SEQ_AUS, 0xFFFF, NARC_zone_event_release_narc_0486_bin, MAPSEC_HALL_OF_ORIGIN, 13, 14, 2, 9, FALSE, TRUE, FALSE, FALSE }, // MAP_D05R0116
    { NARC_area_data_narc_0050_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0242_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_MOUNT2, SEQ_D_MOUNT2, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_HALL_OF_ORIGIN, 13, 14, 2, 9, FALSE, TRUE, FALSE, FALSE }, // MAP_D05R0117
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0077_bin, NARC_scr_seq_release_narc_0313_bin, NARC_scr_seq_release_narc_0773_bin, NARC_msg_narc_0255_bin, SEQ_D_04, SEQ_D_04, ENCDATA(NARC_d_enc_data_narc_0115_bin, NARC_p_enc_data_narc_0115_bin), NARC_zone_event_release_narc_0487_bin, MAPSEC_RUIN_MANIAC_CAVE, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D22R0102
    { NARC_area_data_narc_0043_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0078_bin, NARC_scr_seq_release_narc_0314_bin, NARC_scr_seq_release_narc_0774_bin, NARC_msg_narc_0256_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0116_bin, NARC_p_enc_data_narc_0116_bin), NARC_zone_event_release_narc_0488_bin, MAPSEC_MANIAC_TUNNEL, 0, 12, 3, 10, TRUE, TRUE, TRUE, FALSE }, // MAP_D22R0103
    { NARC_area_data_narc_0020_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0243_bin, NARC_scr_seq_release_narc_0323_bin, NARC_scr_seq_release_narc_0783_bin, NARC_msg_narc_0259_bin, SEQ_ROAD_B_D, SEQ_ROAD_B_N, 0xFFFF, NARC_zone_event_release_narc_0489_bin, MAPSEC_IRON_ISLAND, 0, 4, 4, 6, FALSE, FALSE, FALSE, FALSE }, // MAP_D24R0201
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0031_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_02, SEQ_D_02, ENCDATA(NARC_d_enc_data_narc_0046_bin, NARC_p_enc_data_narc_0046_bin), NARC_zone_event_release_narc_0490_bin, MAPSEC_SOLACEON_RUINS, 0, 0, 3, 9, TRUE, TRUE, TRUE, FALSE }, // MAP_D07R0119
    { NARC_area_data_narc_0021_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0207_bin, NARC_scr_seq_release_narc_0166_bin, NARC_scr_seq_release_narc_0629_bin, NARC_msg_narc_0018_bin, SEQ_CITY08_D, SEQ_CITY08_N, 0xFFFF, NARC_zone_event_release_narc_0491_bin, MAPSEC_VISTA_LIGHTHOUSE, 0, 4, 4, 8, FALSE, FALSE, FALSE, FALSE }, // MAP_C08R0802
    { NARC_area_data_narc_0031_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0208_bin, NARC_scr_seq_release_narc_0031_bin, NARC_scr_seq_release_narc_0494_bin, NARC_msg_narc_0044_bin, SEQ_CITY01_D, SEQ_CITY01_N, 0xFFFF, NARC_zone_event_release_narc_0492_bin, MAPSEC_JUBILIFE_CITY, 0, 4, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C01R0802
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0287_bin, NARC_scr_seq_release_narc_0747_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0066_bin, NARC_p_enc_data_narc_0066_bin), NARC_zone_event_release_narc_0493_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0108
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0288_bin, NARC_scr_seq_release_narc_0748_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0067_bin, NARC_p_enc_data_narc_0067_bin), NARC_zone_event_release_narc_0494_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0109
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0289_bin, NARC_scr_seq_release_narc_0749_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0068_bin, NARC_p_enc_data_narc_0068_bin), NARC_zone_event_release_narc_0495_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0110
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0290_bin, NARC_scr_seq_release_narc_0750_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0069_bin, NARC_p_enc_data_narc_0069_bin), NARC_zone_event_release_narc_0496_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0111
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0291_bin, NARC_scr_seq_release_narc_0751_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0070_bin, NARC_p_enc_data_narc_0070_bin), NARC_zone_event_release_narc_0497_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0112
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0292_bin, NARC_scr_seq_release_narc_0752_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0071_bin, NARC_p_enc_data_narc_0071_bin), NARC_zone_event_release_narc_0498_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0113
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0293_bin, NARC_scr_seq_release_narc_0753_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0072_bin, NARC_p_enc_data_narc_0072_bin), NARC_zone_event_release_narc_0499_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0114
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0294_bin, NARC_scr_seq_release_narc_0754_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0073_bin, NARC_p_enc_data_narc_0073_bin), NARC_zone_event_release_narc_0500_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0115
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0295_bin, NARC_scr_seq_release_narc_0755_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0074_bin, NARC_p_enc_data_narc_0074_bin), NARC_zone_event_release_narc_0501_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0116
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0296_bin, NARC_scr_seq_release_narc_0756_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0075_bin, NARC_p_enc_data_narc_0075_bin), NARC_zone_event_release_narc_0502_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0117
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0297_bin, NARC_scr_seq_release_narc_0757_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0076_bin, NARC_p_enc_data_narc_0076_bin), NARC_zone_event_release_narc_0503_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0118
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0298_bin, NARC_scr_seq_release_narc_0758_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0077_bin, NARC_p_enc_data_narc_0077_bin), NARC_zone_event_release_narc_0504_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0119
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0299_bin, NARC_scr_seq_release_narc_0759_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0078_bin, NARC_p_enc_data_narc_0078_bin), NARC_zone_event_release_narc_0505_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0120
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0300_bin, NARC_scr_seq_release_narc_0760_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, ENCDATA(NARC_d_enc_data_narc_0079_bin, NARC_p_enc_data_narc_0079_bin), NARC_zone_event_release_narc_0506_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0121
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0301_bin, NARC_scr_seq_release_narc_0761_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0507_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, FALSE, FALSE }, // MAP_D17R0122
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0123
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0124
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0508_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0125
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0126
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0127
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0128
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0129
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0509_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0130
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0131
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0132
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0133
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0134
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0135
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0510_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0136
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0137
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0138
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0139
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0140
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0141
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0064_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0142
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0143
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0065_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0144
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0145
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0146
    { NARC_area_data_narc_0046_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0066_bin, NARC_scr_seq_release_narc_0368_bin, NARC_scr_seq_release_narc_0827_bin, NARC_msg_narc_0018_bin, SEQ_D_03, SEQ_D_03, 0xFFFF, NARC_zone_event_release_narc_0000_bin, MAPSEC_TURNBACK_CAVE, 14, 0, 3, 11, TRUE, TRUE, TRUE, FALSE }, // MAP_D17R0147
    { NARC_area_data_narc_0032_bin, NARC_move_model_list_narc_0015_bin, NARC_map_matrix_narc_0166_bin, NARC_scr_seq_release_narc_0116_bin, NARC_scr_seq_release_narc_0579_bin, NARC_msg_narc_0121_bin, SEQ_BLD_CON, SEQ_BLD_CON, 0xFFFF, NARC_zone_event_release_narc_0511_bin, MAPSEC_CONTEST_HALL, 0, 0, 4, 7, FALSE, FALSE, FALSE, FALSE }, // MAP_C05R1103
};

u32 MapNumberBoundsCheck(u32 mapno) {
    if (mapno >= NELEMS(sMapHeaders)) {
        GF_ASSERT(0);
        mapno = 3;
    }
    return mapno;
}

u8 MapHeader_GetAreaDataBank(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].area_data_bank;
}

u8 MapHeader_GetMoveModelBank(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].move_model_bank;
}

u16 MapHeader_GetMatrixId(u32 mapno) {
    u16 ret;
    mapno = MapNumberBoundsCheck(mapno);
    ret = sMapHeaders[mapno].matrix_id;
    // Spear Pillar
    if (ret == NARC_map_matrix_narc_0022_bin && gGameVersion == VERSION_PEARL) {
        ret = NARC_map_matrix_narc_0023_bin;
    }
    return ret;
}

u16 MapHeader_GetMsgBank(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].msg_bank;
}

u16 MapHeader_GetScriptsBank(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].scripts_bank;
}

u16 MapHeader_GetLevelScriptsBank(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].level_scripts_bank;
}

u16 MapHeader_GetDayMusicId(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].day_music_id;
}

u16 MapHeader_GetNightMusicId(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].night_music_id;
}

BOOL MapHeader_HasWildEncounters(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].wild_encounter_bank != 0xFFFF;
}

u16 MapHeader_GetWildEncounterBank(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].wild_encounter_bank;
}

u16 MapHeader_GetEventsBank(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].events_bank;
}

u16 MapHeader_GetMapSec(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].mapsec;
}

u8 MapHeader_GetWeatherType(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].weather_type;
}

u8 MapHeader_GetCameraType(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].camera_type;
}

u8 MapHeader_GetBattleBg(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].battle_bg;
}

u8 MapHeader_IsEscapeRopeAllowed(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].is_escape_rope_allowed;
}

u8 MapHeader_IsFlyAllowed(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].is_fly_allowed;
}

u8 MapHeader_IsBikeAllowed(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].is_bike_allowed;
}

u8 MapHeader_GetMapType(u32 mapno) {
    mapno = MapNumberBoundsCheck(mapno);
    return sMapHeaders[mapno].map_type;
}

BOOL MapHeader_IsOutdoorNotTown(u32 mapno) {
    if (!MapHeader_IsFlyAllowed(mapno)) {
        return FALSE;
    }
    if (MapHeader_GetMapType(mapno) != 1) {
        return TRUE;
    }
    return FALSE;
}

BOOL MapHeader_MapIsOnMainMatrix(u32 mapno) {
    return MapHeader_GetMatrixId(mapno) == NARC_map_matrix_narc_0000_bin;
}

BOOL MapHeader_IsPokemonCenter(u32 mapno) {
    return MapHeader_GetMapType(mapno) == 5;
}

BOOL MapHeader_IsCave(u32 mapno) {
    return MapHeader_GetMapType(mapno) == 3;
}

BOOL MapHeader_IsBuilding(u32 mapno) {
    return MapHeader_GetMapType(mapno) == 4 || MapHeader_GetMapType(mapno) == 5;
}

BOOL MapHeader_IsOutdoor(u32 mapno) {
    return MapHeader_GetMapType(mapno) == 1 || MapHeader_GetMapType(mapno) == 2;
}

BOOL MapHeader_MapIsPokemonCenter(u32 mapno) {
    return MapHeader_IsPokemonCenter(mapno) != FALSE;
}

BOOL MapHeader_MapIsUnionRoom(u32 mapno) {
    return mapno == MAP_UNION;
}

BOOL MapHeader_MapIsMtCoronetFeebasRoom(u32 mapno) {
    return mapno == MAP_D05R0113;
}

BOOL MapHeader_MapIsTrophyGarden(u32 mapno) {
    return mapno == MAP_D23R0101;
}

BOOL MapHeader_MapIsAmitySquare(u32 mapno) {
    return mapno == MAP_D11R0101;
}

BOOL MapHeader_MapIsSpearPillar(u32 mapno) {
    return mapno == MAP_D05R0114;
}

BOOL MapHeader_MapIsPokemonCenterSecondFloor(u32 mapno) {
    int i;

    for (i = 0; i < NELEMS(sPokemonCenterSecondFloorMaps); i++) {
        if (mapno == sPokemonCenterSecondFloorMaps[i]) {
            return TRUE;
        }
    }

    return FALSE;
}

u16 MapHeader_GetMapEvolutionMethod(u32 mapno) {
    int i;

    for (i = 0; i < NELEMS(sMapEvolutionMethods); i += 2) {
        if (mapno == sMapEvolutionMethods[i + 0]) {
            return sMapEvolutionMethods[i + 1];
        }
    }

    return EVO_NONE;
}
