#include "nitro/types.h"
#include "fx.h"

/*
 * [2 * idx + 0] <- sin(idx * 2pi / 4096)
 * [2 * idx + 1] <- cos(idx * 2pi / 4096)
 */
const fx16 FX_SinCosTable_[4096 * 2] = {
    FX16_CONST(0.0), FX16_CONST(1.0),
    FX16_CONST(0.0015339801862847655), FX16_CONST(0.9999988234517019),
    FX16_CONST(0.003067956762965976), FX16_CONST(0.9999952938095762),
    FX16_CONST(0.0046019261204485705), FX16_CONST(0.9999894110819284),
    FX16_CONST(0.006135884649154475), FX16_CONST(0.9999811752826011),
    FX16_CONST(0.007669828739531097), FX16_CONST(0.9999705864309741),
    FX16_CONST(0.00920375478205982), FX16_CONST(0.9999576445519639),
    FX16_CONST(0.01073765916726449), FX16_CONST(0.9999423496760239),
    FX16_CONST(0.012271538285719925), FX16_CONST(0.9999247018391445),
    FX16_CONST(0.01380538852806039), FX16_CONST(0.9999047010828529),
    FX16_CONST(0.0153392062849881), FX16_CONST(0.9998823474542126),
    FX16_CONST(0.01687298794728171), FX16_CONST(0.9998576410058239),
    FX16_CONST(0.01840672990580482), FX16_CONST(0.9998305817958234),
    FX16_CONST(0.01994042855151444), FX16_CONST(0.9998011698878843),
    FX16_CONST(0.021474080275469508), FX16_CONST(0.9997694053512153),
    FX16_CONST(0.02300768146883937), FX16_CONST(0.9997352882605617),
    FX16_CONST(0.024541228522912288), FX16_CONST(0.9996988186962042),
    FX16_CONST(0.0260747178291039), FX16_CONST(0.9996599967439592),
    FX16_CONST(0.02760814577896574), FX16_CONST(0.9996188224951786),
    FX16_CONST(0.029141508764193722), FX16_CONST(0.9995752960467492),
    FX16_CONST(0.030674803176636626), FX16_CONST(0.9995294175010931),
    FX16_CONST(0.032208025408304586), FX16_CONST(0.999481186966167),
    FX16_CONST(0.03374117185137758), FX16_CONST(0.9994306045554617),
    FX16_CONST(0.03527423889821395), FX16_CONST(0.9993776703880028),
    FX16_CONST(0.03680722294135883), FX16_CONST(0.9993223845883495),
    FX16_CONST(0.038340120373552694), FX16_CONST(0.9992647472865944),
    FX16_CONST(0.03987292758773981), FX16_CONST(0.9992047586183639),
    FX16_CONST(0.04140564097707674), FX16_CONST(0.9991424187248169),
    FX16_CONST(0.04293825693494082), FX16_CONST(0.9990777277526454),
    FX16_CONST(0.04447077185493867), FX16_CONST(0.9990106858540734),
    FX16_CONST(0.04600318213091462), FX16_CONST(0.9989412931868569),
    FX16_CONST(0.0475354841569593), FX16_CONST(0.9988695499142836),
    FX16_CONST(0.049067674327418015), FX16_CONST(0.9987954562051724),
    FX16_CONST(0.05059974903689928), FX16_CONST(0.9987190122338729),
    FX16_CONST(0.052131704680283324), FX16_CONST(0.9986402181802653),
    FX16_CONST(0.05366353765273052), FX16_CONST(0.9985590742297593),
    FX16_CONST(0.055195244349689934), FX16_CONST(0.9984755805732948),
    FX16_CONST(0.05672682116690775), FX16_CONST(0.9983897374073402),
    FX16_CONST(0.05825826450043575), FX16_CONST(0.9983015449338929),
    FX16_CONST(0.05978957074663987), FX16_CONST(0.9982110033604782),
    FX16_CONST(0.06132073630220858), FX16_CONST(0.9981181129001492),
    FX16_CONST(0.0628517575641614), FX16_CONST(0.9980228737714862),
    FX16_CONST(0.06438263092985747), FX16_CONST(0.997925286198596),
    FX16_CONST(0.0659133527970038), FX16_CONST(0.9978253504111116),
    FX16_CONST(0.06744391956366405), FX16_CONST(0.9977230666441916),
    FX16_CONST(0.06897432762826675), FX16_CONST(0.9976184351385196),
    FX16_CONST(0.07050457338961386), FX16_CONST(0.9975114561403035),
    FX16_CONST(0.07203465324688933), FX16_CONST(0.9974021299012753),
    FX16_CONST(0.07356456359966743), FX16_CONST(0.9972904566786902),
    FX16_CONST(0.0750943008479213), FX16_CONST(0.9971764367353262),
    FX16_CONST(0.07662386139203149), FX16_CONST(0.997060070339483),
    FX16_CONST(0.07815324163279423), FX16_CONST(0.9969413577649822),
    FX16_CONST(0.07968243797143013), FX16_CONST(0.9968202992911657),
    FX16_CONST(0.08121144680959244), FX16_CONST(0.9966968952028961),
    FX16_CONST(0.08274026454937569), FX16_CONST(0.9965711457905548),
    FX16_CONST(0.08426888759332407), FX16_CONST(0.9964430513500426),
    FX16_CONST(0.0857973123444399), FX16_CONST(0.996312612182778),
    FX16_CONST(0.08732553520619206), FX16_CONST(0.996179828595697),
    FX16_CONST(0.0888535525825246), FX16_CONST(0.996044700901252),
    FX16_CONST(0.09038136087786498), FX16_CONST(0.9959072294174117),
    FX16_CONST(0.09190895649713272), FX16_CONST(0.9957674144676598),
    FX16_CONST(0.09343633584574779), FX16_CONST(0.9956252563809943),
    FX16_CONST(0.09496349532963899), FX16_CONST(0.9954807554919269),
    FX16_CONST(0.09649043135525259), FX16_CONST(0.9953339121404823),
    FX16_CONST(0.0980171403295606), FX16_CONST(0.9951847266721969),
    FX16_CONST(0.09954361866006932), FX16_CONST(0.9950331994381186),
    FX16_CONST(0.10106986275482782), FX16_CONST(0.9948793307948056),
    FX16_CONST(0.10259586902243628), FX16_CONST(0.9947231211043257),
    FX16_CONST(0.10412163387205459), FX16_CONST(0.9945645707342554),
    FX16_CONST(0.10564715371341062), FX16_CONST(0.9944036800576791),
    FX16_CONST(0.10717242495680884), FX16_CONST(0.9942404494531879),
    FX16_CONST(0.10869744401313872), FX16_CONST(0.9940748793048794),
    FX16_CONST(0.11022220729388306), FX16_CONST(0.9939069700023561),
    FX16_CONST(0.11174671121112659), FX16_CONST(0.9937367219407246),
    FX16_CONST(0.11327095217756435), FX16_CONST(0.9935641355205953),
    FX16_CONST(0.11479492660651008), FX16_CONST(0.9933892111480807),
    FX16_CONST(0.11631863091190475), FX16_CONST(0.9932119492347945),
    FX16_CONST(0.11784206150832498), FX16_CONST(0.9930323501978514),
    FX16_CONST(0.11936521481099135), FX16_CONST(0.9928504144598651),
    FX16_CONST(0.12088808723577708), FX16_CONST(0.992666142448948),
    FX16_CONST(0.1224106751992162), FX16_CONST(0.99247953459871),
    FX16_CONST(0.12393297511851216), FX16_CONST(0.9922905913482574),
    FX16_CONST(0.12545498341154623), FX16_CONST(0.9920993131421918),
    FX16_CONST(0.12697669649688587), FX16_CONST(0.9919057004306093),
    FX16_CONST(0.12849811079379317), FX16_CONST(0.9917097536690995),
    FX16_CONST(0.13001922272223335), FX16_CONST(0.9915114733187439),
    FX16_CONST(0.13154002870288312), FX16_CONST(0.9913108598461154),
    FX16_CONST(0.13306052515713906), FX16_CONST(0.9911079137232769),
    FX16_CONST(0.13458070850712617), FX16_CONST(0.99090263542778),
    FX16_CONST(0.1361005751757062), FX16_CONST(0.9906950254426646),
    FX16_CONST(0.13762012158648604), FX16_CONST(0.9904850842564571),
    FX16_CONST(0.1391393441638262), FX16_CONST(0.9902728123631691),
    FX16_CONST(0.1406582393328492), FX16_CONST(0.9900582102622971),
    FX16_CONST(0.14217680351944803), FX16_CONST(0.9898412784588205),
    FX16_CONST(0.14369503315029447), FX16_CONST(0.9896220174632009),
    FX16_CONST(0.14521292465284746), FX16_CONST(0.9894004277913804),
    FX16_CONST(0.14673047445536175), FX16_CONST(0.989176509964781),
    FX16_CONST(0.14824767898689603), FX16_CONST(0.988950264510303),
    FX16_CONST(0.1497645346773215), FX16_CONST(0.9887216919603238),
    FX16_CONST(0.15128103795733022), FX16_CONST(0.9884907928526966),
    FX16_CONST(0.15279718525844344), FX16_CONST(0.9882575677307495),
    FX16_CONST(0.1543129730130201), FX16_CONST(0.9880220171432835),
    FX16_CONST(0.15582839765426523), FX16_CONST(0.9877841416445722),
    FX16_CONST(0.15734345561623825), FX16_CONST(0.9875439417943592),
    FX16_CONST(0.15885814333386145), FX16_CONST(0.9873014181578584),
    FX16_CONST(0.16037245724292828), FX16_CONST(0.987056571305751),
    FX16_CONST(0.16188639378011183), FX16_CONST(0.9868094018141855),
    FX16_CONST(0.16339994938297323), FX16_CONST(0.9865599102647754),
    FX16_CONST(0.1649131204899699), FX16_CONST(0.9863080972445987),
    FX16_CONST(0.1664259035404641), FX16_CONST(0.9860539633461954),
    FX16_CONST(0.16793829497473117), FX16_CONST(0.9857975091675675),
    FX16_CONST(0.16945029123396796), FX16_CONST(0.9855387353121761),
    FX16_CONST(0.17096188876030122), FX16_CONST(0.9852776423889412),
    FX16_CONST(0.17247308399679595), FX16_CONST(0.9850142310122398),
    FX16_CONST(0.17398387338746382), FX16_CONST(0.9847485018019042),
    FX16_CONST(0.17549425337727143), FX16_CONST(0.9844804553832209),
    FX16_CONST(0.17700422041214875), FX16_CONST(0.984210092386929),
    FX16_CONST(0.1785137709389975), FX16_CONST(0.9839374134492189),
    FX16_CONST(0.18002290140569951), FX16_CONST(0.9836624192117303),
    FX16_CONST(0.18153160826112497), FX16_CONST(0.9833851103215512),
    FX16_CONST(0.18303988795514095), FX16_CONST(0.9831054874312163),
    FX16_CONST(0.18454773693861962), FX16_CONST(0.9828235511987052),
    FX16_CONST(0.18605515166344663), FX16_CONST(0.9825393022874412),
    FX16_CONST(0.1875621285825296), FX16_CONST(0.9822527413662894),
    FX16_CONST(0.1890686641498062), FX16_CONST(0.9819638691095552),
    FX16_CONST(0.19057475482025274), FX16_CONST(0.9816726861969831),
    FX16_CONST(0.19208039704989244), FX16_CONST(0.9813791933137546),
    FX16_CONST(0.1935855872958036), FX16_CONST(0.9810833911504867),
    FX16_CONST(0.19509032201612825), FX16_CONST(0.9807852804032304),
    FX16_CONST(0.19659459767008022), FX16_CONST(0.9804848617734694),
    FX16_CONST(0.19809841071795356), FX16_CONST(0.9801821359681174),
    FX16_CONST(0.19960175762113097), FX16_CONST(0.9798771036995176),
    FX16_CONST(0.2011046348420919), FX16_CONST(0.9795697656854405),
    FX16_CONST(0.20260703884442113), FX16_CONST(0.979260122649082),
    FX16_CONST(0.20410896609281687), FX16_CONST(0.9789481753190622),
    FX16_CONST(0.20561041305309924), FX16_CONST(0.9786339244294232),
    FX16_CONST(0.20711137619221856), FX16_CONST(0.9783173707196277),
    FX16_CONST(0.20861185197826349), FX16_CONST(0.9779985149345571),
    FX16_CONST(0.2101118368804696), FX16_CONST(0.9776773578245099),
    FX16_CONST(0.21161132736922755), FX16_CONST(0.9773539001452),
    FX16_CONST(0.21311031991609136), FX16_CONST(0.9770281426577544),
    FX16_CONST(0.21460881099378676), FX16_CONST(0.9767000861287118),
    FX16_CONST(0.21610679707621952), FX16_CONST(0.9763697313300211),
    FX16_CONST(0.21760427463848364), FX16_CONST(0.976037079039039),
    FX16_CONST(0.2191012401568698), FX16_CONST(0.9757021300385286),
    FX16_CONST(0.2205976901088735), FX16_CONST(0.975364885116657),
    FX16_CONST(0.2220936209732035), FX16_CONST(0.9750253450669941),
    FX16_CONST(0.22358902922979), FX16_CONST(0.9746835106885107),
    FX16_CONST(0.22508391135979283), FX16_CONST(0.9743393827855759),
    FX16_CONST(0.22657826384561), FX16_CONST(0.9739929621679558),
    FX16_CONST(0.22807208317088573), FX16_CONST(0.973644249650812),
    FX16_CONST(0.22956536582051887), FX16_CONST(0.9732932460546982),
    FX16_CONST(0.2310581082806711), FX16_CONST(0.9729399522055602),
    FX16_CONST(0.23255030703877524), FX16_CONST(0.9725843689347322),
    FX16_CONST(0.23404195858354343), FX16_CONST(0.9722264970789363),
    FX16_CONST(0.2355330594049755), FX16_CONST(0.9718663374802794),
    FX16_CONST(0.2370236059943672), FX16_CONST(0.9715038909862518),
    FX16_CONST(0.23851359484431842), FX16_CONST(0.9711391584497251),
    FX16_CONST(0.2400030224487415), FX16_CONST(0.9707721407289504),
    FX16_CONST(0.24149188530286933), FX16_CONST(0.9704028386875555),
    FX16_CONST(0.24298017990326387), FX16_CONST(0.970031253194544),
    FX16_CONST(0.24446790274782415), FX16_CONST(0.9696573851242924),
    FX16_CONST(0.2459550503357946), FX16_CONST(0.9692812353565485),
    FX16_CONST(0.24744161916777327), FX16_CONST(0.9689028047764289),
    FX16_CONST(0.24892760574572015), FX16_CONST(0.9685220942744174),
    FX16_CONST(0.2504130065729652), FX16_CONST(0.9681391047463624),
    FX16_CONST(0.25189781815421697), FX16_CONST(0.9677538370934755),
    FX16_CONST(0.25338203699557016), FX16_CONST(0.9673662922223285),
    FX16_CONST(0.25486565960451457), FX16_CONST(0.9669764710448521),
    FX16_CONST(0.2563486824899429), FX16_CONST(0.9665843744783331),
    FX16_CONST(0.257831102162159), FX16_CONST(0.9661900034454125),
    FX16_CONST(0.25931291513288623), FX16_CONST(0.9657933588740837),
    FX16_CONST(0.2607941179152755), FX16_CONST(0.9653944416976894),
    FX16_CONST(0.2622747070239136), FX16_CONST(0.9649932528549203),
    FX16_CONST(0.26375467897483135), FX16_CONST(0.9645897932898128),
    FX16_CONST(0.2652340302855118), FX16_CONST(0.9641840639517458),
    FX16_CONST(0.26671275747489837), FX16_CONST(0.9637760657954398),
    FX16_CONST(0.2681908570634032), FX16_CONST(0.963365799780954),
    FX16_CONST(0.2696683255729151), FX16_CONST(0.9629532668736839),
    FX16_CONST(0.271145159526808), FX16_CONST(0.9625384680443592),
    FX16_CONST(0.272621355449949), FX16_CONST(0.9621214042690416),
    FX16_CONST(0.2740969098687064), FX16_CONST(0.9617020765291225),
    FX16_CONST(0.27557181931095814), FX16_CONST(0.9612804858113206),
    FX16_CONST(0.2770460803060999), FX16_CONST(0.9608566331076797),
    FX16_CONST(0.27851968938505306), FX16_CONST(0.9604305194155658),
    FX16_CONST(0.2799926430802732), FX16_CONST(0.960002145737666),
    FX16_CONST(0.28146493792575794), FX16_CONST(0.9595715130819845),
    FX16_CONST(0.2829365704570554), FX16_CONST(0.9591386224618419),
    FX16_CONST(0.2844075372112719), FX16_CONST(0.9587034748958716),
    FX16_CONST(0.2858778347270806), FX16_CONST(0.9582660714080177),
    FX16_CONST(0.2873474595447295), FX16_CONST(0.9578264130275329),
    FX16_CONST(0.2888164082060495), FX16_CONST(0.9573845007889759),
    FX16_CONST(0.29028467725446233), FX16_CONST(0.9569403357322088),
    FX16_CONST(0.29175226323498926), FX16_CONST(0.9564939189023951),
    FX16_CONST(0.29321916269425863), FX16_CONST(0.9560452513499964),
    FX16_CONST(0.2946853721805143), FX16_CONST(0.9555943341307711),
    FX16_CONST(0.2961508882436238), FX16_CONST(0.9551411683057708),
    FX16_CONST(0.2976157074350862), FX16_CONST(0.9546857549413383),
    FX16_CONST(0.2990798263080405), FX16_CONST(0.9542280951091057),
    FX16_CONST(0.30054324141727345), FX16_CONST(0.9537681898859903),
    FX16_CONST(0.3020059493192281), FX16_CONST(0.9533060403541939),
    FX16_CONST(0.3034679465720113), FX16_CONST(0.9528416476011987),
    FX16_CONST(0.3049292297354024), FX16_CONST(0.9523750127197659),
    FX16_CONST(0.3063897953708609), FX16_CONST(0.9519061368079323),
    FX16_CONST(0.30784964004153487), FX16_CONST(0.9514350209690083),
    FX16_CONST(0.3093087603122687), FX16_CONST(0.9509616663115751),
    FX16_CONST(0.3107671527496115), FX16_CONST(0.9504860739494817),
    FX16_CONST(0.3122248139218249), FX16_CONST(0.950008245001843),
    FX16_CONST(0.3136817403988915), FX16_CONST(0.9495281805930367),
    FX16_CONST(0.31513792875252244), FX16_CONST(0.9490458818527006),
    FX16_CONST(0.31659337555616585), FX16_CONST(0.9485613499157303),
    FX16_CONST(0.31804807738501495), FX16_CONST(0.9480745859222762),
    FX16_CONST(0.3195020308160157), FX16_CONST(0.9475855910177411),
    FX16_CONST(0.3209552324278752), FX16_CONST(0.9470943663527772),
    FX16_CONST(0.32240767880106985), FX16_CONST(0.9466009130832835),
    FX16_CONST(0.32385936651785285), FX16_CONST(0.9461052323704034),
    FX16_CONST(0.3253102921622629), FX16_CONST(0.9456073253805213),
    FX16_CONST(0.32676045232013173), FX16_CONST(0.9451071932852606),
    FX16_CONST(0.3282098435790925), FX16_CONST(0.9446048372614803),
    FX16_CONST(0.3296584625285875), FX16_CONST(0.9441002584912727),
    FX16_CONST(0.33110630575987643), FX16_CONST(0.9435934581619604),
    FX16_CONST(0.3325533698660442), FX16_CONST(0.9430844374660935),
    FX16_CONST(0.3339996514420094), FX16_CONST(0.9425731976014469),
    FX16_CONST(0.3354451470845316), FX16_CONST(0.9420597397710173),
    FX16_CONST(0.33688985339222005), FX16_CONST(0.9415440651830208),
    FX16_CONST(0.3383337669655411), FX16_CONST(0.9410261750508893),
    FX16_CONST(0.33977688440682685), FX16_CONST(0.9405060705932683),
    FX16_CONST(0.34121920232028236), FX16_CONST(0.939983753034014),
    FX16_CONST(0.3426607173119944), FX16_CONST(0.9394592236021899),
    FX16_CONST(0.3441014259899388), FX16_CONST(0.9389324835320646),
    FX16_CONST(0.3455413249639891), FX16_CONST(0.9384035340631081),
    FX16_CONST(0.3469804108459237), FX16_CONST(0.9378723764399899),
    FX16_CONST(0.34841868024943456), FX16_CONST(0.937339011912575),
    FX16_CONST(0.3498561297901349), FX16_CONST(0.9368034417359216),
    FX16_CONST(0.3512927560855671), FX16_CONST(0.9362656671702783),
    FX16_CONST(0.3527285557552107), FX16_CONST(0.9357256894810804),
    FX16_CONST(0.35416352542049034), FX16_CONST(0.9351835099389476),
    FX16_CONST(0.35559766170478385), FX16_CONST(0.9346391298196808),
    FX16_CONST(0.35703096123343), FX16_CONST(0.9340925504042589),
    FX16_CONST(0.35846342063373654), FX16_CONST(0.9335437729788362),
    FX16_CONST(0.3598950365349881), FX16_CONST(0.932992798834739),
    FX16_CONST(0.3613258055684543), FX16_CONST(0.9324396292684624),
    FX16_CONST(0.3627557243673972), FX16_CONST(0.9318842655816681),
    FX16_CONST(0.3641847895670799), FX16_CONST(0.9313267090811804),
    FX16_CONST(0.36561299780477385), FX16_CONST(0.9307669610789837),
    FX16_CONST(0.3670403457197672), FX16_CONST(0.9302050228922191),
    FX16_CONST(0.3684668299533723), FX16_CONST(0.9296408958431812),
    FX16_CONST(0.3698924471489341), FX16_CONST(0.9290745812593159),
    FX16_CONST(0.37131719395183754), FX16_CONST(0.9285060804732156),
    FX16_CONST(0.37274106700951576), FX16_CONST(0.9279353948226179),
    FX16_CONST(0.37416406297145793), FX16_CONST(0.9273625256504011),
    FX16_CONST(0.3755861784892172), FX16_CONST(0.9267874743045817),
    FX16_CONST(0.37700741021641826), FX16_CONST(0.9262102421383114),
    FX16_CONST(0.37842775480876556), FX16_CONST(0.9256308305098727),
    FX16_CONST(0.37984720892405116), FX16_CONST(0.9250492407826776),
    FX16_CONST(0.3812657692221624), FX16_CONST(0.9244654743252626),
    FX16_CONST(0.3826834323650898), FX16_CONST(0.9238795325112867),
    FX16_CONST(0.38410019501693504), FX16_CONST(0.9232914167195276),
    FX16_CONST(0.38551605384391885), FX16_CONST(0.9227011283338786),
    FX16_CONST(0.3869310055143886), FX16_CONST(0.9221086687433452),
    FX16_CONST(0.38834504669882625), FX16_CONST(0.9215140393420419),
    FX16_CONST(0.3897581740698564), FX16_CONST(0.9209172415291894),
    FX16_CONST(0.39117038430225387), FX16_CONST(0.9203182767091106),
    FX16_CONST(0.39258167407295147), FX16_CONST(0.9197171462912274),
    FX16_CONST(0.3939920400610481), FX16_CONST(0.9191138516900578),
    FX16_CONST(0.39540147894781635), FX16_CONST(0.9185083943252123),
    FX16_CONST(0.3968099874167103), FX16_CONST(0.9179007756213905),
    FX16_CONST(0.39821756215337356), FX16_CONST(0.9172909970083779),
    FX16_CONST(0.3996241998456468), FX16_CONST(0.9166790599210427),
    FX16_CONST(0.4010298971835756), FX16_CONST(0.9160649657993317),
    FX16_CONST(0.40243465085941843), FX16_CONST(0.9154487160882678),
    FX16_CONST(0.4038384575676541), FX16_CONST(0.9148303122379462),
    FX16_CONST(0.40524131400498986), FX16_CONST(0.9142097557035307),
    FX16_CONST(0.40664321687036903), FX16_CONST(0.9135870479452508),
    FX16_CONST(0.4080441628649787), FX16_CONST(0.9129621904283982),
    FX16_CONST(0.4094441486922576), FX16_CONST(0.9123351846233227),
    FX16_CONST(0.4108431710579039), FX16_CONST(0.9117060320054299),
    FX16_CONST(0.4122412266698829), FX16_CONST(0.9110747340551764),
    FX16_CONST(0.4136383122384345), FX16_CONST(0.9104412922580672),
    FX16_CONST(0.41503442447608163), FX16_CONST(0.9098057081046522),
    FX16_CONST(0.41642956009763715), FX16_CONST(0.9091679830905224),
    FX16_CONST(0.41782371582021227), FX16_CONST(0.9085281187163061),
    FX16_CONST(0.4192168883632239), FX16_CONST(0.9078861164876663),
    FX16_CONST(0.4206090744484025), FX16_CONST(0.9072419779152958),
    FX16_CONST(0.4220002707997997), FX16_CONST(0.9065957045149153),
    FX16_CONST(0.42339047414379605), FX16_CONST(0.9059472978072685),
    FX16_CONST(0.4247796812091088), FX16_CONST(0.9052967593181188),
    FX16_CONST(0.4261678887267996), FX16_CONST(0.9046440905782462),
    FX16_CONST(0.4275550934302821), FX16_CONST(0.9039892931234433),
    FX16_CONST(0.4289412920553295), FX16_CONST(0.9033323684945118),
    FX16_CONST(0.4303264813400826), FX16_CONST(0.9026733182372588),
    FX16_CONST(0.43171065802505726), FX16_CONST(0.9020121439024932),
    FX16_CONST(0.43309381885315196), FX16_CONST(0.901348847046022),
    FX16_CONST(0.43447596056965565), FX16_CONST(0.9006834292286469),
    FX16_CONST(0.4358570799222555), FX16_CONST(0.9000158920161602),
    FX16_CONST(0.4372371736610441), FX16_CONST(0.8993462369793416),
    FX16_CONST(0.43861623853852766), FX16_CONST(0.8986744656939538),
    FX16_CONST(0.43999427130963326), FX16_CONST(0.8980005797407399),
    FX16_CONST(0.44137126873171667), FX16_CONST(0.8973245807054183),
    FX16_CONST(0.44274722756457), FX16_CONST(0.8966464701786802),
    FX16_CONST(0.4441221445704292), FX16_CONST(0.8959662497561852),
    FX16_CONST(0.44549601651398174), FX16_CONST(0.8952839210385576),
    FX16_CONST(0.44686884016237416), FX16_CONST(0.8945994856313827),
    FX16_CONST(0.4482406122852199), FX16_CONST(0.8939129451452033),
    FX16_CONST(0.44961132965460654), FX16_CONST(0.8932243011955153),
    FX16_CONST(0.45098098904510386), FX16_CONST(0.8925335554027646),
    FX16_CONST(0.4523495872337709), FX16_CONST(0.8918407093923427),
    FX16_CONST(0.45371712100016387), FX16_CONST(0.8911457647945832),
    FX16_CONST(0.45508358712634384), FX16_CONST(0.8904487232447579),
    FX16_CONST(0.4564489823968839), FX16_CONST(0.8897495863830728),
    FX16_CONST(0.4578133035988772), FX16_CONST(0.8890483558546646),
    FX16_CONST(0.4591765475219441), FX16_CONST(0.8883450333095964),
    FX16_CONST(0.46053871095824), FX16_CONST(0.8876396204028539),
    FX16_CONST(0.46189979070246273), FX16_CONST(0.8869321187943422),
    FX16_CONST(0.46325978355186015), FX16_CONST(0.8862225301488806),
    FX16_CONST(0.4646186863062378), FX16_CONST(0.8855108561362),
    FX16_CONST(0.4659764957679662), FX16_CONST(0.8847970984309378),
    FX16_CONST(0.4673332087419884), FX16_CONST(0.884081258712635),
    FX16_CONST(0.4686888220358279), FX16_CONST(0.8833633386657316),
    FX16_CONST(0.4700433324595956), FX16_CONST(0.8826433399795628),
    FX16_CONST(0.47139673682599764), FX16_CONST(0.881921264348355),
    FX16_CONST(0.4727490319503428), FX16_CONST(0.8811971134712221),
    FX16_CONST(0.47410021465054997), FX16_CONST(0.8804708890521608),
    FX16_CONST(0.47545028174715587), FX16_CONST(0.8797425928000474),
    FX16_CONST(0.4767992300633221), FX16_CONST(0.8790122264286335),
    FX16_CONST(0.478147056424843), FX16_CONST(0.8782797916565416),
    FX16_CONST(0.47949375766015295), FX16_CONST(0.8775452902072614),
    FX16_CONST(0.48083933060033396), FX16_CONST(0.8768087238091457),
    FX16_CONST(0.4821837720791227), FX16_CONST(0.8760700941954066),
    FX16_CONST(0.4835270789329187), FX16_CONST(0.8753294031041109),
    FX16_CONST(0.48486924800079106), FX16_CONST(0.8745866522781761),
    FX16_CONST(0.4862102761244864), FX16_CONST(0.8738418434653669),
    FX16_CONST(0.487550160148436), FX16_CONST(0.8730949784182901),
    FX16_CONST(0.48888889691976317), FX16_CONST(0.8723460588943915),
    FX16_CONST(0.49022648328829116), FX16_CONST(0.871595086655951),
    FX16_CONST(0.4915629161065499), FX16_CONST(0.870842063470079),
    FX16_CONST(0.49289819222978404), FX16_CONST(0.8700869911087115),
    FX16_CONST(0.4942323085159597), FX16_CONST(0.8693298713486068),
    FX16_CONST(0.49556526182577254), FX16_CONST(0.8685707059713409),
    FX16_CONST(0.49689704902265447), FX16_CONST(0.8678094967633033),
    FX16_CONST(0.4982276669727818), FX16_CONST(0.8670462455156926),
    FX16_CONST(0.49955711254508184), FX16_CONST(0.866280954024513),
    FX16_CONST(0.5008853826112407), FX16_CONST(0.8655136240905691),
    FX16_CONST(0.5022124740457108), FX16_CONST(0.8647442575194624),
    FX16_CONST(0.5035383837257176), FX16_CONST(0.8639728561215867),
    FX16_CONST(0.5048631085312676), FX16_CONST(0.8631994217121242),
    FX16_CONST(0.5061866453451552), FX16_CONST(0.8624239561110405),
    FX16_CONST(0.5075089910529709), FX16_CONST(0.8616464611430813),
    FX16_CONST(0.508830142543107), FX16_CONST(0.8608669386377673),
    FX16_CONST(0.5101500967067668), FX16_CONST(0.8600853904293901),
    FX16_CONST(0.5114688504379703), FX16_CONST(0.8593018183570085),
    FX16_CONST(0.512786400633563), FX16_CONST(0.8585162242644427),
    FX16_CONST(0.5141027441932217), FX16_CONST(0.8577286100002721),
    FX16_CONST(0.5154178780194629), FX16_CONST(0.8569389774178288),
    FX16_CONST(0.5167317990176499), FX16_CONST(0.8561473283751945),
    FX16_CONST(0.5180445040959993), FX16_CONST(0.855353664735196),
    FX16_CONST(0.5193559901655896), FX16_CONST(0.8545579883654005),
    FX16_CONST(0.5206662541403672), FX16_CONST(0.8537603011381114),
    FX16_CONST(0.5219752929371544), FX16_CONST(0.8529606049303636),
    FX16_CONST(0.5232831034756564), FX16_CONST(0.8521589016239198),
    FX16_CONST(0.524589682678469), FX16_CONST(0.8513551931052652),
    FX16_CONST(0.5258950274710846), FX16_CONST(0.8505494812656035),
    FX16_CONST(0.5271991347819013), FX16_CONST(0.8497417680008525),
    FX16_CONST(0.5285020015422285), FX16_CONST(0.8489320552116396),
    FX16_CONST(0.5298036246862946), FX16_CONST(0.8481203448032972),
    FX16_CONST(0.531104001151255), FX16_CONST(0.8473066386858583),
    FX16_CONST(0.5324031278771979), FX16_CONST(0.8464909387740521),
    FX16_CONST(0.533701001807153), FX16_CONST(0.8456732469872991),
    FX16_CONST(0.5349976198870972), FX16_CONST(0.8448535652497071),
    FX16_CONST(0.5362929790659632), FX16_CONST(0.8440318954900664),
    FX16_CONST(0.5375870762956454), FX16_CONST(0.8432082396418454),
    FX16_CONST(0.5388799085310084), FX16_CONST(0.8423825996431858),
    FX16_CONST(0.5401714727298929), FX16_CONST(0.8415549774368984),
    FX16_CONST(0.5414617658531234), FX16_CONST(0.8407253749704581),
    FX16_CONST(0.5427507848645159), FX16_CONST(0.8398937941959995),
    FX16_CONST(0.5440385267308838), FX16_CONST(0.8390602370703127),
    FX16_CONST(0.5453249884220465), FX16_CONST(0.8382247055548381),
    FX16_CONST(0.5466101669108349), FX16_CONST(0.8373872016156619),
    FX16_CONST(0.5478940591731002), FX16_CONST(0.836547727223512),
    FX16_CONST(0.5491766621877197), FX16_CONST(0.8357062843537526),
    FX16_CONST(0.5504579729366048), FX16_CONST(0.83486287498638),
    FX16_CONST(0.5517379884047073), FX16_CONST(0.8340175011060181),
    FX16_CONST(0.5530167055800275), FX16_CONST(0.8331701647019132),
    FX16_CONST(0.55429412145362), FX16_CONST(0.8323208677679297),
    FX16_CONST(0.5555702330196022), FX16_CONST(0.8314696123025452),
    FX16_CONST(0.5568450372751601), FX16_CONST(0.8306164003088463),
    FX16_CONST(0.5581185312205561), FX16_CONST(0.829761233794523),
    FX16_CONST(0.5593907118591361), FX16_CONST(0.8289041147718649),
    FX16_CONST(0.560661576197336), FX16_CONST(0.8280450452577558),
    FX16_CONST(0.5619311212446894), FX16_CONST(0.8271840272736691),
    FX16_CONST(0.5631993440138341), FX16_CONST(0.8263210628456635),
    FX16_CONST(0.5644662415205194), FX16_CONST(0.8254561540043776),
    FX16_CONST(0.5657318107836131), FX16_CONST(0.8245893027850253),
    FX16_CONST(0.5669960488251087), FX16_CONST(0.8237205112273914),
    FX16_CONST(0.5682589526701315), FX16_CONST(0.8228497813758264),
    FX16_CONST(0.5695205193469471), FX16_CONST(0.8219771152792416),
    FX16_CONST(0.5707807458869673), FX16_CONST(0.8211025149911046),
    FX16_CONST(0.572039629324757), FX16_CONST(0.8202259825694347),
    FX16_CONST(0.5732971666980422), FX16_CONST(0.819347520076797),
    FX16_CONST(0.5745533550477158), FX16_CONST(0.8184671295802987),
    FX16_CONST(0.5758081914178453), FX16_CONST(0.8175848131515837),
    FX16_CONST(0.5770616728556794), FX16_CONST(0.8167005728668278),
    FX16_CONST(0.5783137964116556), FX16_CONST(0.8158144108067338),
    FX16_CONST(0.5795645591394056), FX16_CONST(0.8149263290565266),
    FX16_CONST(0.5808139580957645), FX16_CONST(0.8140363297059484),
    FX16_CONST(0.5820619903407754), FX16_CONST(0.8131444148492536),
    FX16_CONST(0.5833086529376983), FX16_CONST(0.812250586585204),
    FX16_CONST(0.5845539429530153), FX16_CONST(0.8113548470170637),
    FX16_CONST(0.5857978574564389), FX16_CONST(0.8104571982525948),
    FX16_CONST(0.587040393520918), FX16_CONST(0.8095576424040513),
    FX16_CONST(0.5882815482226452), FX16_CONST(0.808656181588175),
    FX16_CONST(0.5895213186410639), FX16_CONST(0.8077528179261904),
    FX16_CONST(0.5907597018588742), FX16_CONST(0.8068475535437993),
    FX16_CONST(0.591996694962041), FX16_CONST(0.8059403905711763),
    FX16_CONST(0.5932322950397998), FX16_CONST(0.8050313311429637),
    FX16_CONST(0.5944664991846644), FX16_CONST(0.8041203773982657),
    FX16_CONST(0.5956993044924334), FX16_CONST(0.8032075314806449),
    FX16_CONST(0.5969307080621964), FX16_CONST(0.8022927955381157),
    FX16_CONST(0.5981607069963424), FX16_CONST(0.8013761717231402),
    FX16_CONST(0.5993892984005645), FX16_CONST(0.8004576621926228),
    FX16_CONST(0.600616479383869), FX16_CONST(0.799537269107905),
    FX16_CONST(0.60184224705858), FX16_CONST(0.7986149946347609),
    FX16_CONST(0.6030665985403482), FX16_CONST(0.7976908409433912),
    FX16_CONST(0.604289530948156), FX16_CONST(0.7967648102084188),
    FX16_CONST(0.6055110414043255), FX16_CONST(0.7958369046088836),
    FX16_CONST(0.6067311270345245), FX16_CONST(0.794907126328237),
    FX16_CONST(0.6079497849677736), FX16_CONST(0.7939754775543372),
    FX16_CONST(0.6091670123364532), FX16_CONST(0.7930419604794436),
    FX16_CONST(0.6103828062763095), FX16_CONST(0.7921065773002124),
    FX16_CONST(0.6115971639264619), FX16_CONST(0.7911693302176902),
    FX16_CONST(0.6128100824294097), FX16_CONST(0.79023022143731),
    FX16_CONST(0.6140215589310385), FX16_CONST(0.7892892531688857),
    FX16_CONST(0.6152315905806268), FX16_CONST(0.7883464276266062),
    FX16_CONST(0.6164401745308536), FX16_CONST(0.7874017470290314),
    FX16_CONST(0.6176473079378039), FX16_CONST(0.7864552135990858),
    FX16_CONST(0.6188529879609763), FX16_CONST(0.7855068295640539),
    FX16_CONST(0.6200572117632891), FX16_CONST(0.7845565971555752),
    FX16_CONST(0.6212599765110876), FX16_CONST(0.7836045186096382),
    FX16_CONST(0.62246127937415), FX16_CONST(0.7826505961665757),
    FX16_CONST(0.6236611175256945), FX16_CONST(0.7816948320710594),
    FX16_CONST(0.6248594881423863), FX16_CONST(0.7807372285720945),
    FX16_CONST(0.6260563884043435), FX16_CONST(0.7797777879230146),
    FX16_CONST(0.6272518154951441), FX16_CONST(0.778816512381476),
    FX16_CONST(0.6284457666018327), FX16_CONST(0.7778534042094531),
    FX16_CONST(0.629638238914927), FX16_CONST(0.7768884656732324),
    FX16_CONST(0.6308292296284245), FX16_CONST(0.7759216990434077),
    FX16_CONST(0.6320187359398091), FX16_CONST(0.7749531065948739),
    FX16_CONST(0.6332067550500572), FX16_CONST(0.7739826906068229),
    FX16_CONST(0.6343932841636455), FX16_CONST(0.773010453362737),
    FX16_CONST(0.6355783204885561), FX16_CONST(0.7720363971503845),
    FX16_CONST(0.6367618612362842), FX16_CONST(0.7710605242618138),
    FX16_CONST(0.637943903621844), FX16_CONST(0.7700828369933479),
    FX16_CONST(0.6391244448637757), FX16_CONST(0.7691033376455797),
    FX16_CONST(0.6403034821841517), FX16_CONST(0.7681220285233654),
    FX16_CONST(0.641481012808583), FX16_CONST(0.7671389119358204),
    FX16_CONST(0.6426570339662269), FX16_CONST(0.7661539901963129),
    FX16_CONST(0.6438315428897914), FX16_CONST(0.765167265622459),
    FX16_CONST(0.6450045368155439), FX16_CONST(0.7641787405361167),
    FX16_CONST(0.6461760129833163), FX16_CONST(0.7631884172633814),
    FX16_CONST(0.6473459686365121), FX16_CONST(0.762196298134579),
    FX16_CONST(0.6485144010221124), FX16_CONST(0.7612023854842618),
    FX16_CONST(0.6496813073906832), FX16_CONST(0.7602066816512024),
    FX16_CONST(0.6508466849963809), FX16_CONST(0.759209188978388),
    FX16_CONST(0.6520105310969595), FX16_CONST(0.7582099098130153),
    FX16_CONST(0.6531728429537768), FX16_CONST(0.7572088465064846),
    FX16_CONST(0.6543336178318004), FX16_CONST(0.7562060014143945),
    FX16_CONST(0.6554928529996153), FX16_CONST(0.7552013768965365),
    FX16_CONST(0.6566505457294289), FX16_CONST(0.7541949753168892),
    FX16_CONST(0.6578066932970786), FX16_CONST(0.7531867990436125),
    FX16_CONST(0.6589612929820373), FX16_CONST(0.7521768504490427),
    FX16_CONST(0.6601143420674205), FX16_CONST(0.7511651319096864),
    FX16_CONST(0.6612658378399923), FX16_CONST(0.7501516458062151),
    FX16_CONST(0.6624157775901718), FX16_CONST(0.7491363945234594),
    FX16_CONST(0.6635641586120398), FX16_CONST(0.7481193804504036),
    FX16_CONST(0.6647109782033448), FX16_CONST(0.7471006059801801),
    FX16_CONST(0.6658562336655097), FX16_CONST(0.7460800735100638),
    FX16_CONST(0.6669999223036375), FX16_CONST(0.745057785441466),
    FX16_CONST(0.6681420414265185), FX16_CONST(0.7440337441799293),
    FX16_CONST(0.669282588346636), FX16_CONST(0.7430079521351217),
    FX16_CONST(0.6704215603801731), FX16_CONST(0.7419804117208311),
    FX16_CONST(0.6715589548470183), FX16_CONST(0.7409511253549592),
    FX16_CONST(0.6726947690707729), FX16_CONST(0.7399200954595162),
    FX16_CONST(0.673829000378756), FX16_CONST(0.7388873244606151),
    FX16_CONST(0.6749616461020119), FX16_CONST(0.737852814788466),
    FX16_CONST(0.6760927035753159), FX16_CONST(0.7368165688773698),
    FX16_CONST(0.6772221701371803), FX16_CONST(0.7357785891657136),
    FX16_CONST(0.6783500431298615), FX16_CONST(0.7347388780959635),
    FX16_CONST(0.679476319899365), FX16_CONST(0.7336974381146603),
    FX16_CONST(0.680600997795453), FX16_CONST(0.7326542716724128),
    FX16_CONST(0.6817240741716497), FX16_CONST(0.7316093812238926),
    FX16_CONST(0.6828455463852481), FX16_CONST(0.7305627692278276),
    FX16_CONST(0.6839654117973154), FX16_CONST(0.729514438146997),
    FX16_CONST(0.6850836677727004), FX16_CONST(0.7284643904482252),
    FX16_CONST(0.6862003116800386), FX16_CONST(0.7274126286023758),
    FX16_CONST(0.687315340891759), FX16_CONST(0.726359155084346),
    FX16_CONST(0.6884287527840904), FX16_CONST(0.7253039723730608),
    FX16_CONST(0.6895405447370668), FX16_CONST(0.724247082951467),
    FX16_CONST(0.6906507141345346), FX16_CONST(0.7231884893065275),
    FX16_CONST(0.6917592583641577), FX16_CONST(0.7221281939292153),
    FX16_CONST(0.6928661748174246), FX16_CONST(0.7210661993145081),
    FX16_CONST(0.6939714608896539), FX16_CONST(0.7200025079613817),
    FX16_CONST(0.6950751139800009), FX16_CONST(0.7189371223728045),
    FX16_CONST(0.696177131491463), FX16_CONST(0.7178700450557317),
    FX16_CONST(0.6972775108308865), FX16_CONST(0.7168012785210995),
    FX16_CONST(0.6983762494089728), FX16_CONST(0.7157308252838187),
    FX16_CONST(0.6994733446402838), FX16_CONST(0.7146586878627691),
    FX16_CONST(0.7005687939432483), FX16_CONST(0.7135848687807935),
    FX16_CONST(0.7016625947401685), FX16_CONST(0.7125093705646924),
    FX16_CONST(0.7027547444572253), FX16_CONST(0.7114321957452164),
    FX16_CONST(0.7038452405244849), FX16_CONST(0.7103533468570624),
    FX16_CONST(0.7049340803759049), FX16_CONST(0.7092728264388657),
    FX16_CONST(0.7060212614493397), FX16_CONST(0.7081906370331954),
    FX16_CONST(0.7071067811865476), FX16_CONST(0.7071067811865476),
    FX16_CONST(0.7081906370331954), FX16_CONST(0.7060212614493397),
    FX16_CONST(0.7092728264388657), FX16_CONST(0.704934080375905),
    FX16_CONST(0.7103533468570624), FX16_CONST(0.7038452405244849),
    FX16_CONST(0.7114321957452164), FX16_CONST(0.7027547444572253),
    FX16_CONST(0.7125093705646923), FX16_CONST(0.7016625947401685),
    FX16_CONST(0.7135848687807935), FX16_CONST(0.7005687939432484),
    FX16_CONST(0.7146586878627691), FX16_CONST(0.6994733446402838),
    FX16_CONST(0.7157308252838186), FX16_CONST(0.6983762494089729),
    FX16_CONST(0.7168012785210994), FX16_CONST(0.6972775108308866),
    FX16_CONST(0.7178700450557317), FX16_CONST(0.696177131491463),
    FX16_CONST(0.7189371223728044), FX16_CONST(0.6950751139800009),
    FX16_CONST(0.7200025079613817), FX16_CONST(0.693971460889654),
    FX16_CONST(0.7210661993145081), FX16_CONST(0.6928661748174247),
    FX16_CONST(0.7221281939292153), FX16_CONST(0.6917592583641577),
    FX16_CONST(0.7231884893065273), FX16_CONST(0.6906507141345346),
    FX16_CONST(0.7242470829514669), FX16_CONST(0.6895405447370669),
    FX16_CONST(0.7253039723730608), FX16_CONST(0.6884287527840904),
    FX16_CONST(0.726359155084346), FX16_CONST(0.687315340891759),
    FX16_CONST(0.7274126286023758), FX16_CONST(0.6862003116800386),
    FX16_CONST(0.7284643904482252), FX16_CONST(0.6850836677727004),
    FX16_CONST(0.7295144381469969), FX16_CONST(0.6839654117973155),
    FX16_CONST(0.7305627692278276), FX16_CONST(0.6828455463852481),
    FX16_CONST(0.7316093812238926), FX16_CONST(0.6817240741716498),
    FX16_CONST(0.7326542716724128), FX16_CONST(0.680600997795453),
    FX16_CONST(0.7336974381146603), FX16_CONST(0.679476319899365),
    FX16_CONST(0.7347388780959635), FX16_CONST(0.6783500431298615),
    FX16_CONST(0.7357785891657135), FX16_CONST(0.6772221701371804),
    FX16_CONST(0.7368165688773698), FX16_CONST(0.676092703575316),
    FX16_CONST(0.737852814788466), FX16_CONST(0.674961646102012),
    FX16_CONST(0.7388873244606151), FX16_CONST(0.6738290003787561),
    FX16_CONST(0.7399200954595161), FX16_CONST(0.672694769070773),
    FX16_CONST(0.7409511253549591), FX16_CONST(0.6715589548470183),
    FX16_CONST(0.741980411720831), FX16_CONST(0.6704215603801731),
    FX16_CONST(0.7430079521351217), FX16_CONST(0.669282588346636),
    FX16_CONST(0.7440337441799293), FX16_CONST(0.6681420414265186),
    FX16_CONST(0.745057785441466), FX16_CONST(0.6669999223036375),
    FX16_CONST(0.7460800735100637), FX16_CONST(0.6658562336655097),
    FX16_CONST(0.7471006059801801), FX16_CONST(0.6647109782033449),
    FX16_CONST(0.7481193804504035), FX16_CONST(0.6635641586120399),
    FX16_CONST(0.7491363945234593), FX16_CONST(0.6624157775901718),
    FX16_CONST(0.750151645806215), FX16_CONST(0.6612658378399923),
    FX16_CONST(0.7511651319096864), FX16_CONST(0.6601143420674205),
    FX16_CONST(0.7521768504490427), FX16_CONST(0.6589612929820373),
    FX16_CONST(0.7531867990436125), FX16_CONST(0.6578066932970787),
    FX16_CONST(0.7541949753168892), FX16_CONST(0.656650545729429),
    FX16_CONST(0.7552013768965365), FX16_CONST(0.6554928529996155),
    FX16_CONST(0.7562060014143945), FX16_CONST(0.6543336178318006),
    FX16_CONST(0.7572088465064846), FX16_CONST(0.6531728429537769),
    FX16_CONST(0.7582099098130153), FX16_CONST(0.6520105310969595),
    FX16_CONST(0.759209188978388), FX16_CONST(0.650846684996381),
    FX16_CONST(0.7602066816512024), FX16_CONST(0.6496813073906832),
    FX16_CONST(0.7612023854842618), FX16_CONST(0.6485144010221126),
    FX16_CONST(0.7621962981345789), FX16_CONST(0.6473459686365121),
    FX16_CONST(0.7631884172633813), FX16_CONST(0.6461760129833164),
    FX16_CONST(0.7641787405361167), FX16_CONST(0.645004536815544),
    FX16_CONST(0.765167265622459), FX16_CONST(0.6438315428897915),
    FX16_CONST(0.7661539901963128), FX16_CONST(0.6426570339662269),
    FX16_CONST(0.7671389119358204), FX16_CONST(0.6414810128085832),
    FX16_CONST(0.7681220285233653), FX16_CONST(0.6403034821841517),
    FX16_CONST(0.7691033376455796), FX16_CONST(0.6391244448637757),
    FX16_CONST(0.7700828369933479), FX16_CONST(0.6379439036218442),
    FX16_CONST(0.7710605242618138), FX16_CONST(0.6367618612362842),
    FX16_CONST(0.7720363971503844), FX16_CONST(0.6355783204885562),
    FX16_CONST(0.7730104533627369), FX16_CONST(0.6343932841636455),
    FX16_CONST(0.7739826906068228), FX16_CONST(0.6332067550500572),
    FX16_CONST(0.7749531065948738), FX16_CONST(0.6320187359398091),
    FX16_CONST(0.7759216990434076), FX16_CONST(0.6308292296284246),
    FX16_CONST(0.7768884656732324), FX16_CONST(0.6296382389149271),
    FX16_CONST(0.777853404209453), FX16_CONST(0.6284457666018327),
    FX16_CONST(0.7788165123814759), FX16_CONST(0.6272518154951442),
    FX16_CONST(0.7797777879230144), FX16_CONST(0.6260563884043435),
    FX16_CONST(0.7807372285720945), FX16_CONST(0.6248594881423865),
    FX16_CONST(0.7816948320710594), FX16_CONST(0.6236611175256946),
    FX16_CONST(0.7826505961665757), FX16_CONST(0.6224612793741501),
    FX16_CONST(0.7836045186096382), FX16_CONST(0.6212599765110877),
    FX16_CONST(0.7845565971555752), FX16_CONST(0.6200572117632892),
    FX16_CONST(0.7855068295640539), FX16_CONST(0.6188529879609763),
    FX16_CONST(0.7864552135990858), FX16_CONST(0.617647307937804),
    FX16_CONST(0.7874017470290313), FX16_CONST(0.6164401745308536),
    FX16_CONST(0.7883464276266062), FX16_CONST(0.6152315905806268),
    FX16_CONST(0.7892892531688857), FX16_CONST(0.6140215589310385),
    FX16_CONST(0.79023022143731), FX16_CONST(0.6128100824294097),
    FX16_CONST(0.7911693302176901), FX16_CONST(0.611597163926462),
    FX16_CONST(0.7921065773002123), FX16_CONST(0.6103828062763095),
    FX16_CONST(0.7930419604794436), FX16_CONST(0.6091670123364532),
    FX16_CONST(0.7939754775543372), FX16_CONST(0.6079497849677737),
    FX16_CONST(0.794907126328237), FX16_CONST(0.6067311270345245),
    FX16_CONST(0.7958369046088835), FX16_CONST(0.6055110414043255),
    FX16_CONST(0.7967648102084187), FX16_CONST(0.6042895309481561),
    FX16_CONST(0.797690840943391), FX16_CONST(0.6030665985403483),
    FX16_CONST(0.7986149946347608), FX16_CONST(0.60184224705858),
    FX16_CONST(0.799537269107905), FX16_CONST(0.600616479383869),
    FX16_CONST(0.8004576621926227), FX16_CONST(0.5993892984005645),
    FX16_CONST(0.8013761717231401), FX16_CONST(0.5981607069963424),
    FX16_CONST(0.8022927955381157), FX16_CONST(0.5969307080621965),
    FX16_CONST(0.8032075314806448), FX16_CONST(0.5956993044924335),
    FX16_CONST(0.8041203773982657), FX16_CONST(0.5944664991846645),
    FX16_CONST(0.8050313311429637), FX16_CONST(0.5932322950397998),
    FX16_CONST(0.8059403905711763), FX16_CONST(0.591996694962041),
    FX16_CONST(0.8068475535437992), FX16_CONST(0.5907597018588743),
    FX16_CONST(0.8077528179261902), FX16_CONST(0.5895213186410639),
    FX16_CONST(0.808656181588175), FX16_CONST(0.5882815482226453),
    FX16_CONST(0.8095576424040513), FX16_CONST(0.5870403935209181),
    FX16_CONST(0.8104571982525948), FX16_CONST(0.5857978574564389),
    FX16_CONST(0.8113548470170637), FX16_CONST(0.5845539429530153),
    FX16_CONST(0.8122505865852039), FX16_CONST(0.5833086529376983),
    FX16_CONST(0.8131444148492536), FX16_CONST(0.5820619903407755),
    FX16_CONST(0.8140363297059483), FX16_CONST(0.5808139580957645),
    FX16_CONST(0.8149263290565266), FX16_CONST(0.5795645591394057),
    FX16_CONST(0.8158144108067338), FX16_CONST(0.5783137964116556),
    FX16_CONST(0.8167005728668278), FX16_CONST(0.5770616728556796),
    FX16_CONST(0.8175848131515837), FX16_CONST(0.5758081914178453),
    FX16_CONST(0.8184671295802987), FX16_CONST(0.5745533550477158),
    FX16_CONST(0.8193475200767969), FX16_CONST(0.5732971666980423),
    FX16_CONST(0.8202259825694347), FX16_CONST(0.572039629324757),
    FX16_CONST(0.8211025149911046), FX16_CONST(0.5707807458869674),
    FX16_CONST(0.8219771152792416), FX16_CONST(0.5695205193469473),
    FX16_CONST(0.8228497813758263), FX16_CONST(0.5682589526701315),
    FX16_CONST(0.8237205112273913), FX16_CONST(0.5669960488251087),
    FX16_CONST(0.8245893027850253), FX16_CONST(0.5657318107836132),
    FX16_CONST(0.8254561540043774), FX16_CONST(0.5644662415205195),
    FX16_CONST(0.8263210628456635), FX16_CONST(0.5631993440138341),
    FX16_CONST(0.8271840272736691), FX16_CONST(0.5619311212446895),
    FX16_CONST(0.8280450452577558), FX16_CONST(0.560661576197336),
    FX16_CONST(0.8289041147718649), FX16_CONST(0.5593907118591361),
    FX16_CONST(0.829761233794523), FX16_CONST(0.5581185312205561),
    FX16_CONST(0.8306164003088462), FX16_CONST(0.5568450372751601),
    FX16_CONST(0.8314696123025452), FX16_CONST(0.5555702330196023),
    FX16_CONST(0.8323208677679297), FX16_CONST(0.5542941214536201),
    FX16_CONST(0.8331701647019132), FX16_CONST(0.5530167055800276),
    FX16_CONST(0.8340175011060181), FX16_CONST(0.5517379884047074),
    FX16_CONST(0.83486287498638), FX16_CONST(0.5504579729366048),
    FX16_CONST(0.8357062843537526), FX16_CONST(0.5491766621877198),
    FX16_CONST(0.8365477272235119), FX16_CONST(0.5478940591731002),
    FX16_CONST(0.8373872016156619), FX16_CONST(0.5466101669108349),
    FX16_CONST(0.838224705554838), FX16_CONST(0.5453249884220465),
    FX16_CONST(0.8390602370703126), FX16_CONST(0.5440385267308839),
    FX16_CONST(0.8398937941959994), FX16_CONST(0.542750784864516),
    FX16_CONST(0.840725374970458), FX16_CONST(0.5414617658531236),
    FX16_CONST(0.8415549774368983), FX16_CONST(0.540171472729893),
    FX16_CONST(0.8423825996431858), FX16_CONST(0.5388799085310084),
    FX16_CONST(0.8432082396418454), FX16_CONST(0.5375870762956455),
    FX16_CONST(0.8440318954900664), FX16_CONST(0.5362929790659632),
    FX16_CONST(0.844853565249707), FX16_CONST(0.5349976198870973),
    FX16_CONST(0.8456732469872991), FX16_CONST(0.533701001807153),
    FX16_CONST(0.8464909387740521), FX16_CONST(0.532403127877198),
    FX16_CONST(0.8473066386858583), FX16_CONST(0.531104001151255),
    FX16_CONST(0.8481203448032971), FX16_CONST(0.5298036246862948),
    FX16_CONST(0.8489320552116396), FX16_CONST(0.5285020015422285),
    FX16_CONST(0.8497417680008524), FX16_CONST(0.5271991347819014),
    FX16_CONST(0.8505494812656034), FX16_CONST(0.5258950274710847),
    FX16_CONST(0.8513551931052652), FX16_CONST(0.5245896826784688),
    FX16_CONST(0.8521589016239198), FX16_CONST(0.5232831034756564),
    FX16_CONST(0.8529606049303636), FX16_CONST(0.5219752929371544),
    FX16_CONST(0.8537603011381113), FX16_CONST(0.5206662541403673),
    FX16_CONST(0.8545579883654005), FX16_CONST(0.5193559901655895),
    FX16_CONST(0.855353664735196), FX16_CONST(0.5180445040959993),
    FX16_CONST(0.8561473283751945), FX16_CONST(0.51673179901765),
    FX16_CONST(0.8569389774178287), FX16_CONST(0.5154178780194631),
    FX16_CONST(0.8577286100002721), FX16_CONST(0.5141027441932217),
    FX16_CONST(0.8585162242644427), FX16_CONST(0.5127864006335631),
    FX16_CONST(0.8593018183570084), FX16_CONST(0.5114688504379705),
    FX16_CONST(0.8600853904293903), FX16_CONST(0.5101500967067667),
    FX16_CONST(0.8608669386377673), FX16_CONST(0.508830142543107),
    FX16_CONST(0.8616464611430813), FX16_CONST(0.5075089910529709),
    FX16_CONST(0.8624239561110405), FX16_CONST(0.5061866453451553),
    FX16_CONST(0.8631994217121242), FX16_CONST(0.5048631085312675),
    FX16_CONST(0.8639728561215867), FX16_CONST(0.5035383837257176),
    FX16_CONST(0.8647442575194624), FX16_CONST(0.5022124740457109),
    FX16_CONST(0.865513624090569), FX16_CONST(0.5008853826112409),
    FX16_CONST(0.866280954024513), FX16_CONST(0.49955711254508184),
    FX16_CONST(0.8670462455156926), FX16_CONST(0.49822766697278187),
    FX16_CONST(0.8678094967633032), FX16_CONST(0.49689704902265464),
    FX16_CONST(0.8685707059713409), FX16_CONST(0.4955652618257725),
    FX16_CONST(0.8693298713486067), FX16_CONST(0.49423230851595973),
    FX16_CONST(0.8700869911087113), FX16_CONST(0.4928981922297841),
    FX16_CONST(0.8708420634700789), FX16_CONST(0.49156291610655006),
    FX16_CONST(0.8715950866559511), FX16_CONST(0.4902264832882911),
    FX16_CONST(0.8723460588943914), FX16_CONST(0.4888888969197632),
    FX16_CONST(0.8730949784182901), FX16_CONST(0.48755016014843605),
    FX16_CONST(0.8738418434653668), FX16_CONST(0.48621027612448653),
    FX16_CONST(0.8745866522781761), FX16_CONST(0.4848692480007911),
    FX16_CONST(0.8753294031041108), FX16_CONST(0.48352707893291874),
    FX16_CONST(0.8760700941954066), FX16_CONST(0.48218377207912283),
    FX16_CONST(0.8768087238091458), FX16_CONST(0.4808393306003339),
    FX16_CONST(0.8775452902072612), FX16_CONST(0.479493757660153),
    FX16_CONST(0.8782797916565415), FX16_CONST(0.4781470564248431),
    FX16_CONST(0.8790122264286334), FX16_CONST(0.47679923006332225),
    FX16_CONST(0.8797425928000474), FX16_CONST(0.47545028174715587),
    FX16_CONST(0.8804708890521608), FX16_CONST(0.47410021465055),
    FX16_CONST(0.881197113471222), FX16_CONST(0.4727490319503429),
    FX16_CONST(0.8819212643483549), FX16_CONST(0.4713967368259978),
    FX16_CONST(0.8826433399795628), FX16_CONST(0.4700433324595956),
    FX16_CONST(0.8833633386657316), FX16_CONST(0.46868882203582796),
    FX16_CONST(0.884081258712635), FX16_CONST(0.4673332087419885),
    FX16_CONST(0.8847970984309378), FX16_CONST(0.4659764957679661),
    FX16_CONST(0.8855108561362), FX16_CONST(0.4646186863062378),
    FX16_CONST(0.8862225301488806), FX16_CONST(0.46325978355186026),
    FX16_CONST(0.8869321187943421), FX16_CONST(0.46189979070246284),
    FX16_CONST(0.8876396204028539), FX16_CONST(0.46053871095824),
    FX16_CONST(0.8883450333095964), FX16_CONST(0.45917654752194415),
    FX16_CONST(0.8890483558546646), FX16_CONST(0.4578133035988773),
    FX16_CONST(0.8897495863830729), FX16_CONST(0.45644898239688386),
    FX16_CONST(0.8904487232447579), FX16_CONST(0.45508358712634384),
    FX16_CONST(0.8911457647945832), FX16_CONST(0.4537171210001639),
    FX16_CONST(0.8918407093923427), FX16_CONST(0.452349587233771),
    FX16_CONST(0.8925335554027647), FX16_CONST(0.4509809890451038),
    FX16_CONST(0.8932243011955153), FX16_CONST(0.4496113296546066),
    FX16_CONST(0.8939129451452033), FX16_CONST(0.44824061228522),
    FX16_CONST(0.8945994856313826), FX16_CONST(0.4468688401623743),
    FX16_CONST(0.8952839210385576), FX16_CONST(0.44549601651398174),
    FX16_CONST(0.8959662497561851), FX16_CONST(0.44412214457042926),
    FX16_CONST(0.8966464701786802), FX16_CONST(0.44274722756457013),
    FX16_CONST(0.8973245807054183), FX16_CONST(0.4413712687317166),
    FX16_CONST(0.8980005797407399), FX16_CONST(0.43999427130963326),
    FX16_CONST(0.8986744656939538), FX16_CONST(0.4386162385385277),
    FX16_CONST(0.8993462369793415), FX16_CONST(0.4372371736610442),
    FX16_CONST(0.9000158920161603), FX16_CONST(0.4358570799222555),
    FX16_CONST(0.9006834292286469), FX16_CONST(0.4344759605696557),
    FX16_CONST(0.901348847046022), FX16_CONST(0.433093818853152),
    FX16_CONST(0.9020121439024931), FX16_CONST(0.43171065802505737),
    FX16_CONST(0.9026733182372588), FX16_CONST(0.4303264813400826),
    FX16_CONST(0.9033323684945118), FX16_CONST(0.42894129205532955),
    FX16_CONST(0.9039892931234433), FX16_CONST(0.4275550934302822),
    FX16_CONST(0.9046440905782462), FX16_CONST(0.4261678887267996),
    FX16_CONST(0.9052967593181188), FX16_CONST(0.4247796812091088),
    FX16_CONST(0.9059472978072685), FX16_CONST(0.4233904741437961),
    FX16_CONST(0.9065957045149153), FX16_CONST(0.4220002707997998),
    FX16_CONST(0.9072419779152959), FX16_CONST(0.4206090744484025),
    FX16_CONST(0.9078861164876663), FX16_CONST(0.41921688836322396),
    FX16_CONST(0.9085281187163061), FX16_CONST(0.4178237158202124),
    FX16_CONST(0.9091679830905223), FX16_CONST(0.4164295600976373),
    FX16_CONST(0.9098057081046522), FX16_CONST(0.41503442447608163),
    FX16_CONST(0.9104412922580671), FX16_CONST(0.41363831223843456),
    FX16_CONST(0.9110747340551762), FX16_CONST(0.412241226669883),
    FX16_CONST(0.9117060320054299), FX16_CONST(0.4108431710579039),
    FX16_CONST(0.9123351846233227), FX16_CONST(0.40944414869225765),
    FX16_CONST(0.9129621904283981), FX16_CONST(0.40804416286497874),
    FX16_CONST(0.9135870479452508), FX16_CONST(0.40664321687036914),
    FX16_CONST(0.9142097557035307), FX16_CONST(0.40524131400498986),
    FX16_CONST(0.9148303122379461), FX16_CONST(0.40383845756765413),
    FX16_CONST(0.9154487160882678), FX16_CONST(0.40243465085941854),
    FX16_CONST(0.9160649657993316), FX16_CONST(0.4010298971835758),
    FX16_CONST(0.9166790599210427), FX16_CONST(0.3996241998456468),
    FX16_CONST(0.9172909970083779), FX16_CONST(0.3982175621533736),
    FX16_CONST(0.9179007756213904), FX16_CONST(0.3968099874167104),
    FX16_CONST(0.9185083943252123), FX16_CONST(0.3954014789478163),
    FX16_CONST(0.9191138516900578), FX16_CONST(0.3939920400610481),
    FX16_CONST(0.9197171462912274), FX16_CONST(0.3925816740729515),
    FX16_CONST(0.9203182767091105), FX16_CONST(0.391170384302254),
    FX16_CONST(0.9209172415291894), FX16_CONST(0.3897581740698564),
    FX16_CONST(0.9215140393420419), FX16_CONST(0.3883450466988263),
    FX16_CONST(0.9221086687433451), FX16_CONST(0.3869310055143887),
    FX16_CONST(0.9227011283338785), FX16_CONST(0.385516053843919),
    FX16_CONST(0.9232914167195276), FX16_CONST(0.38410019501693504),
    FX16_CONST(0.9238795325112867), FX16_CONST(0.38268343236508984),
    FX16_CONST(0.9244654743252626), FX16_CONST(0.3812657692221625),
    FX16_CONST(0.9250492407826776), FX16_CONST(0.3798472089240511),
    FX16_CONST(0.9256308305098727), FX16_CONST(0.3784277548087656),
    FX16_CONST(0.9262102421383113), FX16_CONST(0.3770074102164183),
    FX16_CONST(0.9267874743045817), FX16_CONST(0.3755861784892173),
    FX16_CONST(0.9273625256504011), FX16_CONST(0.374164062971458),
    FX16_CONST(0.9279353948226179), FX16_CONST(0.3727410670095158),
    FX16_CONST(0.9285060804732156), FX16_CONST(0.3713171939518376),
    FX16_CONST(0.9290745812593157), FX16_CONST(0.36989244714893427),
    FX16_CONST(0.9296408958431812), FX16_CONST(0.3684668299533723),
    FX16_CONST(0.9302050228922191), FX16_CONST(0.36704034571976724),
    FX16_CONST(0.9307669610789837), FX16_CONST(0.36561299780477396),
    FX16_CONST(0.9313267090811804), FX16_CONST(0.36418478956707984),
    FX16_CONST(0.9318842655816681), FX16_CONST(0.3627557243673972),
    FX16_CONST(0.9324396292684624), FX16_CONST(0.36132580556845434),
    FX16_CONST(0.9329927988347388), FX16_CONST(0.3598950365349883),
    FX16_CONST(0.9335437729788362), FX16_CONST(0.35846342063373654),
    FX16_CONST(0.9340925504042589), FX16_CONST(0.35703096123343003),
    FX16_CONST(0.9346391298196808), FX16_CONST(0.35559766170478396),
    FX16_CONST(0.9351835099389475), FX16_CONST(0.3541635254204905),
    FX16_CONST(0.9357256894810804), FX16_CONST(0.3527285557552107),
    FX16_CONST(0.9362656671702783), FX16_CONST(0.35129275608556715),
    FX16_CONST(0.9368034417359216), FX16_CONST(0.34985612979013503),
    FX16_CONST(0.937339011912575), FX16_CONST(0.3484186802494345),
    FX16_CONST(0.9378723764399899), FX16_CONST(0.3469804108459237),
    FX16_CONST(0.9384035340631081), FX16_CONST(0.34554132496398915),
    FX16_CONST(0.9389324835320645), FX16_CONST(0.344101425989939),
    FX16_CONST(0.9394592236021899), FX16_CONST(0.3426607173119944),
    FX16_CONST(0.9399837530340139), FX16_CONST(0.3412192023202824),
    FX16_CONST(0.9405060705932683), FX16_CONST(0.33977688440682696),
    FX16_CONST(0.9410261750508893), FX16_CONST(0.3383337669655413),
    FX16_CONST(0.9415440651830208), FX16_CONST(0.33688985339222005),
    FX16_CONST(0.9420597397710173), FX16_CONST(0.33544514708453166),
    FX16_CONST(0.9425731976014469), FX16_CONST(0.3339996514420095),
    FX16_CONST(0.9430844374660935), FX16_CONST(0.3325533698660442),
    FX16_CONST(0.9435934581619604), FX16_CONST(0.33110630575987643),
    FX16_CONST(0.9441002584912727), FX16_CONST(0.32965846252858755),
    FX16_CONST(0.9446048372614803), FX16_CONST(0.32820984357909266),
    FX16_CONST(0.9451071932852606), FX16_CONST(0.3267604523201318),
    FX16_CONST(0.9456073253805213), FX16_CONST(0.325310292162263),
    FX16_CONST(0.9461052323704033), FX16_CONST(0.32385936651785296),
    FX16_CONST(0.9466009130832835), FX16_CONST(0.32240767880107),
    FX16_CONST(0.9470943663527772), FX16_CONST(0.3209552324278752),
    FX16_CONST(0.9475855910177411), FX16_CONST(0.31950203081601575),
    FX16_CONST(0.9480745859222762), FX16_CONST(0.31804807738501506),
    FX16_CONST(0.9485613499157303), FX16_CONST(0.31659337555616585),
    FX16_CONST(0.9490458818527006), FX16_CONST(0.31513792875252244),
    FX16_CONST(0.9495281805930367), FX16_CONST(0.3136817403988916),
    FX16_CONST(0.950008245001843), FX16_CONST(0.31222481392182505),
    FX16_CONST(0.9504860739494817), FX16_CONST(0.3107671527496115),
    FX16_CONST(0.9509616663115751), FX16_CONST(0.3093087603122688),
    FX16_CONST(0.9514350209690083), FX16_CONST(0.307849640041535),
    FX16_CONST(0.9519061368079322), FX16_CONST(0.3063897953708611),
    FX16_CONST(0.9523750127197659), FX16_CONST(0.30492922973540243),
    FX16_CONST(0.9528416476011987), FX16_CONST(0.30346794657201137),
    FX16_CONST(0.9533060403541938), FX16_CONST(0.3020059493192282),
    FX16_CONST(0.9537681898859903), FX16_CONST(0.3005432414172734),
    FX16_CONST(0.9542280951091057), FX16_CONST(0.2990798263080405),
    FX16_CONST(0.9546857549413383), FX16_CONST(0.2976157074350863),
    FX16_CONST(0.9551411683057707), FX16_CONST(0.29615088824362396),
    FX16_CONST(0.9555943341307711), FX16_CONST(0.2946853721805143),
    FX16_CONST(0.9560452513499964), FX16_CONST(0.2932191626942587),
    FX16_CONST(0.956493918902395), FX16_CONST(0.2917522632349894),
    FX16_CONST(0.9569403357322089), FX16_CONST(0.29028467725446233),
    FX16_CONST(0.9573845007889759), FX16_CONST(0.2888164082060495),
    FX16_CONST(0.9578264130275329), FX16_CONST(0.28734745954472957),
    FX16_CONST(0.9582660714080177), FX16_CONST(0.2858778347270807),
    FX16_CONST(0.9587034748958716), FX16_CONST(0.2844075372112718),
    FX16_CONST(0.9591386224618419), FX16_CONST(0.2829365704570554),
    FX16_CONST(0.9595715130819845), FX16_CONST(0.28146493792575805),
    FX16_CONST(0.9600021457376658), FX16_CONST(0.2799926430802734),
    FX16_CONST(0.9604305194155658), FX16_CONST(0.27851968938505306),
    FX16_CONST(0.9608566331076797), FX16_CONST(0.27704608030609995),
    FX16_CONST(0.9612804858113206), FX16_CONST(0.27557181931095825),
    FX16_CONST(0.9617020765291225), FX16_CONST(0.27409690986870633),
    FX16_CONST(0.9621214042690416), FX16_CONST(0.272621355449949),
    FX16_CONST(0.9625384680443592), FX16_CONST(0.27114515952680807),
    FX16_CONST(0.9629532668736839), FX16_CONST(0.2696683255729152),
    FX16_CONST(0.963365799780954), FX16_CONST(0.2681908570634032),
    FX16_CONST(0.9637760657954398), FX16_CONST(0.2667127574748984),
    FX16_CONST(0.9641840639517457), FX16_CONST(0.2652340302855119),
    FX16_CONST(0.9645897932898126), FX16_CONST(0.2637546789748315),
    FX16_CONST(0.9649932528549203), FX16_CONST(0.2622747070239136),
    FX16_CONST(0.9653944416976894), FX16_CONST(0.26079411791527557),
    FX16_CONST(0.9657933588740836), FX16_CONST(0.25931291513288635),
    FX16_CONST(0.9661900034454126), FX16_CONST(0.25783110216215893),
    FX16_CONST(0.9665843744783331), FX16_CONST(0.2563486824899429),
    FX16_CONST(0.9669764710448521), FX16_CONST(0.2548656596045146),
    FX16_CONST(0.9673662922223285), FX16_CONST(0.25338203699557027),
    FX16_CONST(0.9677538370934755), FX16_CONST(0.2518978181542169),
    FX16_CONST(0.9681391047463624), FX16_CONST(0.2504130065729653),
    FX16_CONST(0.9685220942744173), FX16_CONST(0.24892760574572026),
    FX16_CONST(0.9689028047764289), FX16_CONST(0.24744161916777344),
    FX16_CONST(0.9692812353565485), FX16_CONST(0.2459550503357946),
    FX16_CONST(0.9696573851242924), FX16_CONST(0.2444679027478242),
    FX16_CONST(0.970031253194544), FX16_CONST(0.24298017990326398),
    FX16_CONST(0.9704028386875555), FX16_CONST(0.2414918853028693),
    FX16_CONST(0.9707721407289504), FX16_CONST(0.2400030224487415),
    FX16_CONST(0.9711391584497251), FX16_CONST(0.2385135948443185),
    FX16_CONST(0.9715038909862518), FX16_CONST(0.23702360599436734),
    FX16_CONST(0.9718663374802794), FX16_CONST(0.23553305940497546),
    FX16_CONST(0.9722264970789363), FX16_CONST(0.23404195858354346),
    FX16_CONST(0.9725843689347322), FX16_CONST(0.23255030703877533),
    FX16_CONST(0.9729399522055601), FX16_CONST(0.23105810828067128),
    FX16_CONST(0.9732932460546982), FX16_CONST(0.22956536582051887),
    FX16_CONST(0.9736442496508119), FX16_CONST(0.2280720831708858),
    FX16_CONST(0.9739929621679558), FX16_CONST(0.2265782638456101),
    FX16_CONST(0.9743393827855759), FX16_CONST(0.22508391135979278),
    FX16_CONST(0.9746835106885107), FX16_CONST(0.22358902922979002),
    FX16_CONST(0.9750253450669941), FX16_CONST(0.2220936209732036),
    FX16_CONST(0.9753648851166569), FX16_CONST(0.22059769010887365),
    FX16_CONST(0.9757021300385286), FX16_CONST(0.21910124015686977),
    FX16_CONST(0.976037079039039), FX16_CONST(0.21760427463848367),
    FX16_CONST(0.9763697313300211), FX16_CONST(0.2161067970762196),
    FX16_CONST(0.9767000861287118), FX16_CONST(0.21460881099378692),
    FX16_CONST(0.9770281426577544), FX16_CONST(0.21311031991609136),
    FX16_CONST(0.9773539001452), FX16_CONST(0.2116113273692276),
    FX16_CONST(0.9776773578245099), FX16_CONST(0.21011183688046972),
    FX16_CONST(0.9779985149345571), FX16_CONST(0.20861185197826346),
    FX16_CONST(0.9783173707196277), FX16_CONST(0.20711137619221856),
    FX16_CONST(0.9786339244294231), FX16_CONST(0.20561041305309932),
    FX16_CONST(0.9789481753190622), FX16_CONST(0.204108966092817),
    FX16_CONST(0.979260122649082), FX16_CONST(0.2026070388444211),
    FX16_CONST(0.9795697656854405), FX16_CONST(0.20110463484209196),
    FX16_CONST(0.9798771036995176), FX16_CONST(0.19960175762113105),
    FX16_CONST(0.9801821359681173), FX16_CONST(0.19809841071795373),
    FX16_CONST(0.9804848617734694), FX16_CONST(0.19659459767008022),
    FX16_CONST(0.9807852804032304), FX16_CONST(0.19509032201612833),
    FX16_CONST(0.9810833911504866), FX16_CONST(0.19358558729580375),
    FX16_CONST(0.9813791933137546), FX16_CONST(0.19208039704989238),
    FX16_CONST(0.9816726861969831), FX16_CONST(0.1905747548202528),
    FX16_CONST(0.9819638691095552), FX16_CONST(0.18906866414980628),
    FX16_CONST(0.9822527413662894), FX16_CONST(0.18756212858252974),
    FX16_CONST(0.9825393022874412), FX16_CONST(0.18605515166344663),
    FX16_CONST(0.9828235511987052), FX16_CONST(0.18454773693861964),
    FX16_CONST(0.9831054874312163), FX16_CONST(0.18303988795514106),
    FX16_CONST(0.9833851103215512), FX16_CONST(0.18153160826112513),
    FX16_CONST(0.9836624192117303), FX16_CONST(0.18002290140569951),
    FX16_CONST(0.9839374134492189), FX16_CONST(0.1785137709389976),
    FX16_CONST(0.984210092386929), FX16_CONST(0.17700422041214886),
    FX16_CONST(0.9844804553832209), FX16_CONST(0.1754942533772714),
    FX16_CONST(0.9847485018019042), FX16_CONST(0.17398387338746385),
    FX16_CONST(0.9850142310122398), FX16_CONST(0.17247308399679603),
    FX16_CONST(0.9852776423889412), FX16_CONST(0.17096188876030136),
    FX16_CONST(0.9855387353121761), FX16_CONST(0.16945029123396793),
    FX16_CONST(0.9857975091675674), FX16_CONST(0.16793829497473123),
    FX16_CONST(0.9860539633461954), FX16_CONST(0.16642590354046422),
    FX16_CONST(0.9863080972445987), FX16_CONST(0.1649131204899701),
    FX16_CONST(0.9865599102647754), FX16_CONST(0.16339994938297323),
    FX16_CONST(0.9868094018141854), FX16_CONST(0.16188639378011188),
    FX16_CONST(0.987056571305751), FX16_CONST(0.1603724572429284),
    FX16_CONST(0.9873014181578584), FX16_CONST(0.1588581433338614),
    FX16_CONST(0.9875439417943592), FX16_CONST(0.15734345561623828),
    FX16_CONST(0.9877841416445722), FX16_CONST(0.15582839765426532),
    FX16_CONST(0.9880220171432835), FX16_CONST(0.15431297301302024),
    FX16_CONST(0.9882575677307495), FX16_CONST(0.1527971852584434),
    FX16_CONST(0.9884907928526966), FX16_CONST(0.15128103795733025),
    FX16_CONST(0.9887216919603238), FX16_CONST(0.14976453467732162),
    FX16_CONST(0.988950264510303), FX16_CONST(0.1482476789868962),
    FX16_CONST(0.989176509964781), FX16_CONST(0.14673047445536175),
    FX16_CONST(0.9894004277913804), FX16_CONST(0.14521292465284752),
    FX16_CONST(0.9896220174632008), FX16_CONST(0.14369503315029458),
    FX16_CONST(0.9898412784588205), FX16_CONST(0.142176803519448),
    FX16_CONST(0.9900582102622971), FX16_CONST(0.14065823933284924),
    FX16_CONST(0.9902728123631691), FX16_CONST(0.13913934416382628),
    FX16_CONST(0.990485084256457), FX16_CONST(0.13762012158648618),
    FX16_CONST(0.9906950254426646), FX16_CONST(0.1361005751757062),
    FX16_CONST(0.99090263542778), FX16_CONST(0.13458070850712622),
    FX16_CONST(0.9911079137232768), FX16_CONST(0.13306052515713918),
    FX16_CONST(0.9913108598461154), FX16_CONST(0.13154002870288328),
    FX16_CONST(0.9915114733187439), FX16_CONST(0.13001922272223335),
    FX16_CONST(0.9917097536690995), FX16_CONST(0.12849811079379322),
    FX16_CONST(0.9919057004306093), FX16_CONST(0.12697669649688598),
    FX16_CONST(0.9920993131421918), FX16_CONST(0.1254549834115462),
    FX16_CONST(0.9922905913482574), FX16_CONST(0.1239329751185122),
    FX16_CONST(0.99247953459871), FX16_CONST(0.12241067519921628),
    FX16_CONST(0.992666142448948), FX16_CONST(0.12088808723577722),
    FX16_CONST(0.9928504144598651), FX16_CONST(0.11936521481099135),
    FX16_CONST(0.9930323501978514), FX16_CONST(0.11784206150832502),
    FX16_CONST(0.9932119492347945), FX16_CONST(0.11631863091190488),
    FX16_CONST(0.9933892111480807), FX16_CONST(0.11479492660651025),
    FX16_CONST(0.9935641355205953), FX16_CONST(0.11327095217756436),
    FX16_CONST(0.9937367219407246), FX16_CONST(0.11174671121112666),
    FX16_CONST(0.9939069700023561), FX16_CONST(0.11022220729388318),
    FX16_CONST(0.9940748793048794), FX16_CONST(0.10869744401313867),
    FX16_CONST(0.9942404494531879), FX16_CONST(0.10717242495680887),
    FX16_CONST(0.9944036800576791), FX16_CONST(0.1056471537134107),
    FX16_CONST(0.9945645707342554), FX16_CONST(0.10412163387205473),
    FX16_CONST(0.9947231211043257), FX16_CONST(0.10259586902243628),
    FX16_CONST(0.9948793307948056), FX16_CONST(0.10106986275482788),
    FX16_CONST(0.9950331994381186), FX16_CONST(0.09954361866006944),
    FX16_CONST(0.9951847266721968), FX16_CONST(0.09801714032956077),
    FX16_CONST(0.9953339121404823), FX16_CONST(0.0964904313552526),
    FX16_CONST(0.9954807554919269), FX16_CONST(0.09496349532963906),
    FX16_CONST(0.9956252563809943), FX16_CONST(0.09343633584574791),
    FX16_CONST(0.9957674144676598), FX16_CONST(0.0919089564971327),
    FX16_CONST(0.9959072294174117), FX16_CONST(0.09038136087786501),
    FX16_CONST(0.996044700901252), FX16_CONST(0.08885355258252468),
    FX16_CONST(0.9961798285956969), FX16_CONST(0.08732553520619223),
    FX16_CONST(0.996312612182778), FX16_CONST(0.08579731234443988),
    FX16_CONST(0.9964430513500426), FX16_CONST(0.08426888759332413),
    FX16_CONST(0.9965711457905548), FX16_CONST(0.0827402645493758),
    FX16_CONST(0.9966968952028961), FX16_CONST(0.08121144680959239),
    FX16_CONST(0.9968202992911657), FX16_CONST(0.07968243797143013),
    FX16_CONST(0.9969413577649822), FX16_CONST(0.07815324163279432),
    FX16_CONST(0.997060070339483), FX16_CONST(0.07662386139203162),
    FX16_CONST(0.9971764367353262), FX16_CONST(0.07509430084792129),
    FX16_CONST(0.9972904566786902), FX16_CONST(0.07356456359966745),
    FX16_CONST(0.9974021299012753), FX16_CONST(0.07203465324688942),
    FX16_CONST(0.9975114561403035), FX16_CONST(0.07050457338961401),
    FX16_CONST(0.9976184351385196), FX16_CONST(0.06897432762826673),
    FX16_CONST(0.9977230666441916), FX16_CONST(0.0674439195636641),
    FX16_CONST(0.9978253504111116), FX16_CONST(0.06591335279700393),
    FX16_CONST(0.997925286198596), FX16_CONST(0.06438263092985741),
    FX16_CONST(0.9980228737714862), FX16_CONST(0.06285175756416142),
    FX16_CONST(0.9981181129001492), FX16_CONST(0.06132073630220865),
    FX16_CONST(0.9982110033604782), FX16_CONST(0.05978957074664001),
    FX16_CONST(0.9983015449338929), FX16_CONST(0.05825826450043573),
    FX16_CONST(0.9983897374073402), FX16_CONST(0.05672682116690778),
    FX16_CONST(0.9984755805732948), FX16_CONST(0.05519524434969003),
    FX16_CONST(0.9985590742297593), FX16_CONST(0.05366353765273068),
    FX16_CONST(0.9986402181802653), FX16_CONST(0.05213170468028332),
    FX16_CONST(0.9987190122338729), FX16_CONST(0.05059974903689934),
    FX16_CONST(0.9987954562051724), FX16_CONST(0.049067674327418126),
    FX16_CONST(0.9988695499142836), FX16_CONST(0.04753548415695926),
    FX16_CONST(0.9989412931868569), FX16_CONST(0.046003182130914644),
    FX16_CONST(0.9990106858540734), FX16_CONST(0.044470771854938744),
    FX16_CONST(0.9990777277526454), FX16_CONST(0.04293825693494096),
    FX16_CONST(0.9991424187248169), FX16_CONST(0.04140564097707671),
    FX16_CONST(0.9992047586183639), FX16_CONST(0.039872927587739845),
    FX16_CONST(0.9992647472865944), FX16_CONST(0.03834012037355279),
    FX16_CONST(0.9993223845883495), FX16_CONST(0.03680722294135899),
    FX16_CONST(0.9993776703880028), FX16_CONST(0.03527423889821395),
    FX16_CONST(0.9994306045554617), FX16_CONST(0.03374117185137764),
    FX16_CONST(0.999481186966167), FX16_CONST(0.032208025408304704),
    FX16_CONST(0.9995294175010931), FX16_CONST(0.03067480317663658),
    FX16_CONST(0.9995752960467492), FX16_CONST(0.02914150876419374),
    FX16_CONST(0.9996188224951786), FX16_CONST(0.02760814577896582),
    FX16_CONST(0.9996599967439592), FX16_CONST(0.02607471782910404),
    FX16_CONST(0.9996988186962042), FX16_CONST(0.024541228522912264),
    FX16_CONST(0.9997352882605617), FX16_CONST(0.02300768146883941),
    FX16_CONST(0.9997694053512153), FX16_CONST(0.021474080275469605),
    FX16_CONST(0.9998011698878843), FX16_CONST(0.019940428551514598),
    FX16_CONST(0.9998305817958234), FX16_CONST(0.01840672990580482),
    FX16_CONST(0.9998576410058239), FX16_CONST(0.016872987947281773),
    FX16_CONST(0.9998823474542126), FX16_CONST(0.01533920628498822),
    FX16_CONST(0.9999047010828529), FX16_CONST(0.013805388528060349),
    FX16_CONST(0.9999247018391445), FX16_CONST(0.012271538285719944),
    FX16_CONST(0.9999423496760239), FX16_CONST(0.010737659167264572),
    FX16_CONST(0.9999576445519639), FX16_CONST(0.00920375478205996),
    FX16_CONST(0.9999705864309741), FX16_CONST(0.007669828739531077),
    FX16_CONST(0.9999811752826011), FX16_CONST(0.006135884649154515),
    FX16_CONST(0.9999894110819284), FX16_CONST(0.004601926120448672),
    FX16_CONST(0.9999952938095762), FX16_CONST(0.003067956762966138),
    FX16_CONST(0.9999988234517019), FX16_CONST(0.0015339801862847662),
    FX16_CONST(1.0), FX16_CONST(6.123233995736766e-17),
    FX16_CONST(0.9999988234517019), FX16_CONST(-0.0015339801862846436),
    FX16_CONST(0.9999952938095762), FX16_CONST(-0.0030679567629660156),
    FX16_CONST(0.9999894110819284), FX16_CONST(-0.00460192612044855),
    FX16_CONST(0.9999811752826011), FX16_CONST(-0.006135884649154393),
    FX16_CONST(0.9999705864309741), FX16_CONST(-0.007669828739530955),
    FX16_CONST(0.9999576445519639), FX16_CONST(-0.009203754782059837),
    FX16_CONST(0.9999423496760239), FX16_CONST(-0.010737659167264449),
    FX16_CONST(0.9999247018391445), FX16_CONST(-0.012271538285719823),
    FX16_CONST(0.9999047010828529), FX16_CONST(-0.013805388528060226),
    FX16_CONST(0.9998823474542126), FX16_CONST(-0.015339206284988098),
    FX16_CONST(0.9998576410058239), FX16_CONST(-0.01687298794728165),
    FX16_CONST(0.9998305817958234), FX16_CONST(-0.018406729905804695),
    FX16_CONST(0.9998011698878843), FX16_CONST(-0.019940428551514476),
    FX16_CONST(0.9997694053512153), FX16_CONST(-0.021474080275469484),
    FX16_CONST(0.9997352882605617), FX16_CONST(-0.02300768146883929),
    FX16_CONST(0.9996988186962042), FX16_CONST(-0.024541228522912142),
    FX16_CONST(0.9996599967439592), FX16_CONST(-0.026074717829103915),
    FX16_CONST(0.9996188224951786), FX16_CONST(-0.027608145778965698),
    FX16_CONST(0.9995752960467492), FX16_CONST(-0.029141508764193618),
    FX16_CONST(0.9995294175010931), FX16_CONST(-0.03067480317663646),
    FX16_CONST(0.999481186966167), FX16_CONST(-0.03220802540830458),
    FX16_CONST(0.9994306045554617), FX16_CONST(-0.03374117185137752),
    FX16_CONST(0.9993776703880028), FX16_CONST(-0.03527423889821382),
    FX16_CONST(0.9993223845883495), FX16_CONST(-0.036807222941358866),
    FX16_CONST(0.9992647472865944), FX16_CONST(-0.038340120373552666),
    FX16_CONST(0.9992047586183639), FX16_CONST(-0.03987292758773973),
    FX16_CONST(0.9991424187248169), FX16_CONST(-0.041405640977076594),
    FX16_CONST(0.9990777277526454), FX16_CONST(-0.042938256934940834),
    FX16_CONST(0.9990106858540734), FX16_CONST(-0.04447077185493862),
    FX16_CONST(0.9989412931868569), FX16_CONST(-0.04600318213091452),
    FX16_CONST(0.9988695499142836), FX16_CONST(-0.047535484156959136),
    FX16_CONST(0.9987954562051724), FX16_CONST(-0.04906767432741801),
    FX16_CONST(0.9987190122338729), FX16_CONST(-0.05059974903689921),
    FX16_CONST(0.9986402181802653), FX16_CONST(-0.05213170468028319),
    FX16_CONST(0.9985590742297593), FX16_CONST(-0.053663537652730554),
    FX16_CONST(0.9984755805732948), FX16_CONST(-0.05519524434968991),
    FX16_CONST(0.9983897374073402), FX16_CONST(-0.05672682116690766),
    FX16_CONST(0.9983015449338929), FX16_CONST(-0.05825826450043561),
    FX16_CONST(0.9982110033604782), FX16_CONST(-0.05978957074663988),
    FX16_CONST(0.9981181129001492), FX16_CONST(-0.06132073630220853),
    FX16_CONST(0.9980228737714862), FX16_CONST(-0.06285175756416131),
    FX16_CONST(0.997925286198596), FX16_CONST(-0.06438263092985728),
    FX16_CONST(0.9978253504111116), FX16_CONST(-0.0659133527970038),
    FX16_CONST(0.9977230666441916), FX16_CONST(-0.06744391956366398),
    FX16_CONST(0.9976184351385196), FX16_CONST(-0.06897432762826661),
    FX16_CONST(0.9975114561403035), FX16_CONST(-0.0705045733896139),
    FX16_CONST(0.9974021299012753), FX16_CONST(-0.07203465324688929),
    FX16_CONST(0.9972904566786902), FX16_CONST(-0.07356456359966733),
    FX16_CONST(0.9971764367353262), FX16_CONST(-0.07509430084792117),
    FX16_CONST(0.997060070339483), FX16_CONST(-0.0766238613920315),
    FX16_CONST(0.9969413577649822), FX16_CONST(-0.07815324163279419),
    FX16_CONST(0.9968202992911658), FX16_CONST(-0.07968243797143001),
    FX16_CONST(0.9966968952028961), FX16_CONST(-0.08121144680959226),
    FX16_CONST(0.9965711457905548), FX16_CONST(-0.08274026454937568),
    FX16_CONST(0.9964430513500426), FX16_CONST(-0.084268887593324),
    FX16_CONST(0.996312612182778), FX16_CONST(-0.08579731234443976),
    FX16_CONST(0.9961798285956969), FX16_CONST(-0.0873255352061921),
    FX16_CONST(0.996044700901252), FX16_CONST(-0.08885355258252456),
    FX16_CONST(0.9959072294174117), FX16_CONST(-0.09038136087786489),
    FX16_CONST(0.9957674144676598), FX16_CONST(-0.09190895649713257),
    FX16_CONST(0.9956252563809943), FX16_CONST(-0.09343633584574779),
    FX16_CONST(0.9954807554919269), FX16_CONST(-0.09496349532963895),
    FX16_CONST(0.9953339121404823), FX16_CONST(-0.09649043135525248),
    FX16_CONST(0.9951847266721969), FX16_CONST(-0.09801714032956065),
    FX16_CONST(0.9950331994381186), FX16_CONST(-0.09954361866006932),
    FX16_CONST(0.9948793307948056), FX16_CONST(-0.10106986275482775),
    FX16_CONST(0.9947231211043257), FX16_CONST(-0.10259586902243616),
    FX16_CONST(0.9945645707342554), FX16_CONST(-0.1041216338720546),
    FX16_CONST(0.9944036800576791), FX16_CONST(-0.10564715371341057),
    FX16_CONST(0.9942404494531879), FX16_CONST(-0.10717242495680876),
    FX16_CONST(0.9940748793048795), FX16_CONST(-0.10869744401313856),
    FX16_CONST(0.9939069700023561), FX16_CONST(-0.11022220729388306),
    FX16_CONST(0.9937367219407246), FX16_CONST(-0.11174671121112655),
    FX16_CONST(0.9935641355205953), FX16_CONST(-0.11327095217756424),
    FX16_CONST(0.9933892111480807), FX16_CONST(-0.11479492660651013),
    FX16_CONST(0.9932119492347945), FX16_CONST(-0.11631863091190475),
    FX16_CONST(0.9930323501978514), FX16_CONST(-0.1178420615083249),
    FX16_CONST(0.9928504144598651), FX16_CONST(-0.11936521481099123),
    FX16_CONST(0.992666142448948), FX16_CONST(-0.1208880872357771),
    FX16_CONST(0.99247953459871), FX16_CONST(-0.12241067519921615),
    FX16_CONST(0.9922905913482574), FX16_CONST(-0.12393297511851208),
    FX16_CONST(0.9920993131421918), FX16_CONST(-0.12545498341154607),
    FX16_CONST(0.9919057004306093), FX16_CONST(-0.12697669649688587),
    FX16_CONST(0.9917097536690995), FX16_CONST(-0.1284981107937931),
    FX16_CONST(0.991511473318744), FX16_CONST(-0.13001922272223324),
    FX16_CONST(0.9913108598461154), FX16_CONST(-0.13154002870288314),
    FX16_CONST(0.9911079137232769), FX16_CONST(-0.13306052515713904),
    FX16_CONST(0.99090263542778), FX16_CONST(-0.1345807085071261),
    FX16_CONST(0.9906950254426646), FX16_CONST(-0.13610057517570606),
    FX16_CONST(0.990485084256457), FX16_CONST(-0.13762012158648607),
    FX16_CONST(0.9902728123631691), FX16_CONST(-0.13913934416382617),
    FX16_CONST(0.9900582102622971), FX16_CONST(-0.14065823933284913),
    FX16_CONST(0.9898412784588205), FX16_CONST(-0.1421768035194479),
    FX16_CONST(0.9896220174632009), FX16_CONST(-0.14369503315029444),
    FX16_CONST(0.9894004277913804), FX16_CONST(-0.1452129246528474),
    FX16_CONST(0.989176509964781), FX16_CONST(-0.14673047445536164),
    FX16_CONST(0.988950264510303), FX16_CONST(-0.1482476789868961),
    FX16_CONST(0.9887216919603238), FX16_CONST(-0.1497645346773215),
    FX16_CONST(0.9884907928526967), FX16_CONST(-0.15128103795733014),
    FX16_CONST(0.9882575677307495), FX16_CONST(-0.1527971852584433),
    FX16_CONST(0.9880220171432835), FX16_CONST(-0.15431297301302013),
    FX16_CONST(0.9877841416445722), FX16_CONST(-0.1558283976542652),
    FX16_CONST(0.9875439417943593), FX16_CONST(-0.15734345561623816),
    FX16_CONST(0.9873014181578584), FX16_CONST(-0.15885814333386128),
    FX16_CONST(0.987056571305751), FX16_CONST(-0.16037245724292826),
    FX16_CONST(0.9868094018141855), FX16_CONST(-0.16188639378011177),
    FX16_CONST(0.9865599102647755), FX16_CONST(-0.16339994938297311),
    FX16_CONST(0.9863080972445987), FX16_CONST(-0.16491312048996995),
    FX16_CONST(0.9860539633461954), FX16_CONST(-0.1664259035404641),
    FX16_CONST(0.9857975091675675), FX16_CONST(-0.1679382949747311),
    FX16_CONST(0.9855387353121761), FX16_CONST(-0.16945029123396782),
    FX16_CONST(0.9852776423889412), FX16_CONST(-0.17096188876030124),
    FX16_CONST(0.9850142310122398), FX16_CONST(-0.17247308399679592),
    FX16_CONST(0.9847485018019042), FX16_CONST(-0.1739838733874637),
    FX16_CONST(0.9844804553832209), FX16_CONST(-0.17549425337727126),
    FX16_CONST(0.984210092386929), FX16_CONST(-0.17700422041214875),
    FX16_CONST(0.9839374134492189), FX16_CONST(-0.17851377093899745),
    FX16_CONST(0.9836624192117303), FX16_CONST(-0.1800229014056994),
    FX16_CONST(0.9833851103215512), FX16_CONST(-0.18153160826112502),
    FX16_CONST(0.9831054874312163), FX16_CONST(-0.18303988795514092),
    FX16_CONST(0.9828235511987053), FX16_CONST(-0.18454773693861953),
    FX16_CONST(0.9825393022874412), FX16_CONST(-0.1860551516634465),
    FX16_CONST(0.9822527413662894), FX16_CONST(-0.1875621285825296),
    FX16_CONST(0.9819638691095552), FX16_CONST(-0.18906866414980616),
    FX16_CONST(0.9816726861969831), FX16_CONST(-0.19057475482025266),
    FX16_CONST(0.9813791933137546), FX16_CONST(-0.19208039704989227),
    FX16_CONST(0.9810833911504867), FX16_CONST(-0.1935855872958036),
    FX16_CONST(0.9807852804032304), FX16_CONST(-0.1950903220161282),
    FX16_CONST(0.9804848617734694), FX16_CONST(-0.1965945976700801),
    FX16_CONST(0.9801821359681174), FX16_CONST(-0.19809841071795362),
    FX16_CONST(0.9798771036995176), FX16_CONST(-0.19960175762113094),
    FX16_CONST(0.9795697656854405), FX16_CONST(-0.20110463484209182),
    FX16_CONST(0.9792601226490821), FX16_CONST(-0.20260703884442097),
    FX16_CONST(0.9789481753190622), FX16_CONST(-0.2041089660928169),
    FX16_CONST(0.9786339244294232), FX16_CONST(-0.2056104130530992),
    FX16_CONST(0.9783173707196277), FX16_CONST(-0.20711137619221845),
    FX16_CONST(0.9779985149345571), FX16_CONST(-0.20861185197826332),
    FX16_CONST(0.9776773578245099), FX16_CONST(-0.2101118368804696),
    FX16_CONST(0.9773539001452001), FX16_CONST(-0.2116113273692275),
    FX16_CONST(0.9770281426577544), FX16_CONST(-0.21311031991609125),
    FX16_CONST(0.9767000861287118), FX16_CONST(-0.2146088109937868),
    FX16_CONST(0.9763697313300211), FX16_CONST(-0.2161067970762195),
    FX16_CONST(0.9760370790390391), FX16_CONST(-0.21760427463848356),
    FX16_CONST(0.9757021300385286), FX16_CONST(-0.21910124015686966),
    FX16_CONST(0.975364885116657), FX16_CONST(-0.22059769010887353),
    FX16_CONST(0.9750253450669941), FX16_CONST(-0.22209362097320348),
    FX16_CONST(0.9746835106885107), FX16_CONST(-0.22358902922978988),
    FX16_CONST(0.9743393827855759), FX16_CONST(-0.22508391135979267),
    FX16_CONST(0.9739929621679558), FX16_CONST(-0.22657826384560997),
    FX16_CONST(0.973644249650812), FX16_CONST(-0.22807208317088568),
    FX16_CONST(0.9732932460546982), FX16_CONST(-0.22956536582051876),
    FX16_CONST(0.9729399522055602), FX16_CONST(-0.23105810828067114),
    FX16_CONST(0.9725843689347322), FX16_CONST(-0.23255030703877522),
    FX16_CONST(0.9722264970789364), FX16_CONST(-0.23404195858354332),
    FX16_CONST(0.9718663374802794), FX16_CONST(-0.23553305940497535),
    FX16_CONST(0.9715038909862518), FX16_CONST(-0.23702360599436723),
    FX16_CONST(0.9711391584497251), FX16_CONST(-0.2385135948443184),
    FX16_CONST(0.9707721407289504), FX16_CONST(-0.2400030224487414),
    FX16_CONST(0.9704028386875555), FX16_CONST(-0.24149188530286916),
    FX16_CONST(0.970031253194544), FX16_CONST(-0.24298017990326387),
    FX16_CONST(0.9696573851242924), FX16_CONST(-0.2444679027478241),
    FX16_CONST(0.9692812353565485), FX16_CONST(-0.24595505033579448),
    FX16_CONST(0.9689028047764289), FX16_CONST(-0.24744161916777332),
    FX16_CONST(0.9685220942744174), FX16_CONST(-0.24892760574572012),
    FX16_CONST(0.9681391047463624), FX16_CONST(-0.25041300657296517),
    FX16_CONST(0.9677538370934755), FX16_CONST(-0.2518978181542168),
    FX16_CONST(0.9673662922223285), FX16_CONST(-0.25338203699557016),
    FX16_CONST(0.9669764710448521), FX16_CONST(-0.2548656596045145),
    FX16_CONST(0.9665843744783331), FX16_CONST(-0.25634868248994275),
    FX16_CONST(0.9661900034454126), FX16_CONST(-0.2578311021621588),
    FX16_CONST(0.9657933588740837), FX16_CONST(-0.25931291513288623),
    FX16_CONST(0.9653944416976894), FX16_CONST(-0.26079411791527546),
    FX16_CONST(0.9649932528549204), FX16_CONST(-0.2622747070239135),
    FX16_CONST(0.9645897932898128), FX16_CONST(-0.2637546789748314),
    FX16_CONST(0.9641840639517458), FX16_CONST(-0.2652340302855118),
    FX16_CONST(0.9637760657954398), FX16_CONST(-0.2667127574748983),
    FX16_CONST(0.963365799780954), FX16_CONST(-0.268190857063403),
    FX16_CONST(0.9629532668736839), FX16_CONST(-0.2696683255729151),
    FX16_CONST(0.9625384680443592), FX16_CONST(-0.27114515952680796),
    FX16_CONST(0.9621214042690416), FX16_CONST(-0.27262135544994887),
    FX16_CONST(0.9617020765291225), FX16_CONST(-0.2740969098687062),
    FX16_CONST(0.9612804858113206), FX16_CONST(-0.27557181931095814),
    FX16_CONST(0.9608566331076797), FX16_CONST(-0.27704608030609984),
    FX16_CONST(0.9604305194155659), FX16_CONST(-0.27851968938505295),
    FX16_CONST(0.9600021457376658), FX16_CONST(-0.2799926430802733),
    FX16_CONST(0.9595715130819845), FX16_CONST(-0.28146493792575794),
    FX16_CONST(0.959138622461842), FX16_CONST(-0.2829365704570553),
    FX16_CONST(0.9587034748958716), FX16_CONST(-0.2844075372112717),
    FX16_CONST(0.9582660714080177), FX16_CONST(-0.2858778347270806),
    FX16_CONST(0.9578264130275329), FX16_CONST(-0.28734745954472946),
    FX16_CONST(0.957384500788976), FX16_CONST(-0.28881640820604937),
    FX16_CONST(0.9569403357322089), FX16_CONST(-0.29028467725446216),
    FX16_CONST(0.9564939189023951), FX16_CONST(-0.29175226323498926),
    FX16_CONST(0.9560452513499965), FX16_CONST(-0.2932191626942586),
    FX16_CONST(0.9555943341307711), FX16_CONST(-0.2946853721805142),
    FX16_CONST(0.9551411683057707), FX16_CONST(-0.29615088824362384),
    FX16_CONST(0.9546857549413383), FX16_CONST(-0.2976157074350862),
    FX16_CONST(0.9542280951091057), FX16_CONST(-0.29907982630804036),
    FX16_CONST(0.9537681898859903), FX16_CONST(-0.3005432414172733),
    FX16_CONST(0.9533060403541939), FX16_CONST(-0.3020059493192281),
    FX16_CONST(0.9528416476011987), FX16_CONST(-0.30346794657201126),
    FX16_CONST(0.9523750127197659), FX16_CONST(-0.30492922973540226),
    FX16_CONST(0.9519061368079323), FX16_CONST(-0.306389795370861),
    FX16_CONST(0.9514350209690083), FX16_CONST(-0.30784964004153487),
    FX16_CONST(0.9509616663115751), FX16_CONST(-0.3093087603122686),
    FX16_CONST(0.9504860739494818), FX16_CONST(-0.31076715274961136),
    FX16_CONST(0.950008245001843), FX16_CONST(-0.31222481392182494),
    FX16_CONST(0.9495281805930367), FX16_CONST(-0.3136817403988914),
    FX16_CONST(0.9490458818527006), FX16_CONST(-0.31513792875252233),
    FX16_CONST(0.9485613499157304), FX16_CONST(-0.31659337555616573),
    FX16_CONST(0.9480745859222762), FX16_CONST(-0.31804807738501495),
    FX16_CONST(0.9475855910177412), FX16_CONST(-0.31950203081601564),
    FX16_CONST(0.9470943663527772), FX16_CONST(-0.3209552324278751),
    FX16_CONST(0.9466009130832835), FX16_CONST(-0.32240767880106985),
    FX16_CONST(0.9461052323704034), FX16_CONST(-0.32385936651785285),
    FX16_CONST(0.9456073253805214), FX16_CONST(-0.32531029216226287),
    FX16_CONST(0.9451071932852606), FX16_CONST(-0.3267604523201316),
    FX16_CONST(0.9446048372614803), FX16_CONST(-0.32820984357909255),
    FX16_CONST(0.9441002584912727), FX16_CONST(-0.32965846252858744),
    FX16_CONST(0.9435934581619604), FX16_CONST(-0.3311063057598763),
    FX16_CONST(0.9430844374660935), FX16_CONST(-0.33255336986604406),
    FX16_CONST(0.9425731976014469), FX16_CONST(-0.3339996514420094),
    FX16_CONST(0.9420597397710174), FX16_CONST(-0.33544514708453155),
    FX16_CONST(0.9415440651830208), FX16_CONST(-0.33688985339221994),
    FX16_CONST(0.9410261750508893), FX16_CONST(-0.3383337669655412),
    FX16_CONST(0.9405060705932683), FX16_CONST(-0.33977688440682685),
    FX16_CONST(0.939983753034014), FX16_CONST(-0.3412192023202823),
    FX16_CONST(0.9394592236021899), FX16_CONST(-0.34266071731199427),
    FX16_CONST(0.9389324835320645), FX16_CONST(-0.34410142598993887),
    FX16_CONST(0.9384035340631082), FX16_CONST(-0.34554132496398904),
    FX16_CONST(0.9378723764399899), FX16_CONST(-0.34698041084592357),
    FX16_CONST(0.937339011912575), FX16_CONST(-0.3484186802494344),
    FX16_CONST(0.9368034417359216), FX16_CONST(-0.3498561297901349),
    FX16_CONST(0.9362656671702783), FX16_CONST(-0.35129275608556704),
    FX16_CONST(0.9357256894810804), FX16_CONST(-0.3527285557552106),
    FX16_CONST(0.9351835099389476), FX16_CONST(-0.3541635254204904),
    FX16_CONST(0.9346391298196808), FX16_CONST(-0.35559766170478385),
    FX16_CONST(0.934092550404259), FX16_CONST(-0.3570309612334299),
    FX16_CONST(0.9335437729788363), FX16_CONST(-0.35846342063373643),
    FX16_CONST(0.9329927988347388), FX16_CONST(-0.35989503653498817),
    FX16_CONST(0.9324396292684624), FX16_CONST(-0.36132580556845423),
    FX16_CONST(0.9318842655816681), FX16_CONST(-0.3627557243673971),
    FX16_CONST(0.9313267090811805), FX16_CONST(-0.3641847895670797),
    FX16_CONST(0.9307669610789837), FX16_CONST(-0.36561299780477385),
    FX16_CONST(0.9302050228922191), FX16_CONST(-0.3670403457197671),
    FX16_CONST(0.9296408958431813), FX16_CONST(-0.3684668299533722),
    FX16_CONST(0.9290745812593157), FX16_CONST(-0.36989244714893416),
    FX16_CONST(0.9285060804732156), FX16_CONST(-0.3713171939518375),
    FX16_CONST(0.9279353948226179), FX16_CONST(-0.3727410670095157),
    FX16_CONST(0.9273625256504011), FX16_CONST(-0.3741640629714579),
    FX16_CONST(0.9267874743045817), FX16_CONST(-0.3755861784892172),
    FX16_CONST(0.9262102421383114), FX16_CONST(-0.3770074102164182),
    FX16_CONST(0.9256308305098728), FX16_CONST(-0.37842775480876545),
    FX16_CONST(0.9250492407826777), FX16_CONST(-0.379847208924051),
    FX16_CONST(0.9244654743252626), FX16_CONST(-0.3812657692221624),
    FX16_CONST(0.9238795325112867), FX16_CONST(-0.3826834323650897),
    FX16_CONST(0.9232914167195277), FX16_CONST(-0.38410019501693493),
    FX16_CONST(0.9227011283338785), FX16_CONST(-0.3855160538439189),
    FX16_CONST(0.9221086687433452), FX16_CONST(-0.3869310055143886),
    FX16_CONST(0.921514039342042), FX16_CONST(-0.3883450466988262),
    FX16_CONST(0.9209172415291895), FX16_CONST(-0.3897581740698563),
    FX16_CONST(0.9203182767091106), FX16_CONST(-0.39117038430225387),
    FX16_CONST(0.9197171462912274), FX16_CONST(-0.3925816740729514),
    FX16_CONST(0.9191138516900578), FX16_CONST(-0.393992040061048),
    FX16_CONST(0.9185083943252123), FX16_CONST(-0.3954014789478162),
    FX16_CONST(0.9179007756213905), FX16_CONST(-0.3968099874167103),
    FX16_CONST(0.917290997008378), FX16_CONST(-0.3982175621533735),
    FX16_CONST(0.9166790599210427), FX16_CONST(-0.3996241998456467),
    FX16_CONST(0.9160649657993317), FX16_CONST(-0.4010298971835757),
    FX16_CONST(0.9154487160882678), FX16_CONST(-0.40243465085941843),
    FX16_CONST(0.9148303122379462), FX16_CONST(-0.403838457567654),
    FX16_CONST(0.9142097557035307), FX16_CONST(-0.40524131400498975),
    FX16_CONST(0.9135870479452508), FX16_CONST(-0.40664321687036903),
    FX16_CONST(0.9129621904283982), FX16_CONST(-0.40804416286497863),
    FX16_CONST(0.9123351846233229), FX16_CONST(-0.40944414869225754),
    FX16_CONST(0.9117060320054299), FX16_CONST(-0.4108431710579038),
    FX16_CONST(0.9110747340551764), FX16_CONST(-0.4122412266698829),
    FX16_CONST(0.9104412922580672), FX16_CONST(-0.4136383122384345),
    FX16_CONST(0.9098057081046523), FX16_CONST(-0.4150344244760815),
    FX16_CONST(0.9091679830905225), FX16_CONST(-0.416429560097637),
    FX16_CONST(0.9085281187163061), FX16_CONST(-0.41782371582021227),
    FX16_CONST(0.9078861164876662), FX16_CONST(-0.41921688836322407),
    FX16_CONST(0.9072419779152959), FX16_CONST(-0.4206090744484024),
    FX16_CONST(0.9065957045149153), FX16_CONST(-0.4220002707997997),
    FX16_CONST(0.9059472978072686), FX16_CONST(-0.42339047414379577),
    FX16_CONST(0.9052967593181188), FX16_CONST(-0.4247796812091087),
    FX16_CONST(0.9046440905782461), FX16_CONST(-0.42616788872679967),
    FX16_CONST(0.9039892931234434), FX16_CONST(-0.42755509343028186),
    FX16_CONST(0.9033323684945118), FX16_CONST(-0.42894129205532944),
    FX16_CONST(0.9026733182372587), FX16_CONST(-0.4303264813400827),
    FX16_CONST(0.9020121439024933), FX16_CONST(-0.4317106580250571),
    FX16_CONST(0.901348847046022), FX16_CONST(-0.4330938188531519),
    FX16_CONST(0.9006834292286469), FX16_CONST(-0.4344759605696558),
    FX16_CONST(0.9000158920161603), FX16_CONST(-0.43585707992225536),
    FX16_CONST(0.8993462369793416), FX16_CONST(-0.4372371736610441),
    FX16_CONST(0.8986744656939539), FX16_CONST(-0.4386162385385274),
    FX16_CONST(0.8980005797407399), FX16_CONST(-0.43999427130963314),
    FX16_CONST(0.8973245807054183), FX16_CONST(-0.4413712687317167),
    FX16_CONST(0.8966464701786803), FX16_CONST(-0.4427472275645698),
    FX16_CONST(0.8959662497561852), FX16_CONST(-0.44412214457042914),
    FX16_CONST(0.8952839210385575), FX16_CONST(-0.4454960165139818),
    FX16_CONST(0.8945994856313828), FX16_CONST(-0.446868840162374),
    FX16_CONST(0.8939129451452033), FX16_CONST(-0.4482406122852199),
    FX16_CONST(0.8932243011955152), FX16_CONST(-0.4496113296546067),
    FX16_CONST(0.8925335554027647), FX16_CONST(-0.4509809890451037),
    FX16_CONST(0.8918407093923427), FX16_CONST(-0.4523495872337709),
    FX16_CONST(0.8911457647945834), FX16_CONST(-0.4537171210001636),
    FX16_CONST(0.890448723244758), FX16_CONST(-0.4550835871263437),
    FX16_CONST(0.8897495863830728), FX16_CONST(-0.456448982396884),
    FX16_CONST(0.8890483558546647), FX16_CONST(-0.457813303598877),
    FX16_CONST(0.8883450333095964), FX16_CONST(-0.45917654752194403),
    FX16_CONST(0.8876396204028539), FX16_CONST(-0.46053871095824006),
    FX16_CONST(0.8869321187943423), FX16_CONST(-0.46189979070246256),
    FX16_CONST(0.8862225301488806), FX16_CONST(-0.46325978355186015),
    FX16_CONST(0.8855108561361998), FX16_CONST(-0.4646186863062379),
    FX16_CONST(0.8847970984309379), FX16_CONST(-0.465976495767966),
    FX16_CONST(0.884081258712635), FX16_CONST(-0.4673332087419884),
    FX16_CONST(0.8833633386657317), FX16_CONST(-0.4686888220358277),
    FX16_CONST(0.8826433399795628), FX16_CONST(-0.4700433324595955),
    FX16_CONST(0.881921264348355), FX16_CONST(-0.4713967368259977),
    FX16_CONST(0.8811971134712222), FX16_CONST(-0.47274903195034257),
    FX16_CONST(0.8804708890521609), FX16_CONST(-0.4741002146505499),
    FX16_CONST(0.8797425928000474), FX16_CONST(-0.4754502817471559),
    FX16_CONST(0.8790122264286335), FX16_CONST(-0.4767992300633219),
    FX16_CONST(0.8782797916565416), FX16_CONST(-0.478147056424843),
    FX16_CONST(0.8775452902072612), FX16_CONST(-0.4794937576601531),
    FX16_CONST(0.8768087238091458), FX16_CONST(-0.4808393306003338),
    FX16_CONST(0.8760700941954066), FX16_CONST(-0.4821837720791227),
    FX16_CONST(0.875329403104111), FX16_CONST(-0.48352707893291846),
    FX16_CONST(0.8745866522781762), FX16_CONST(-0.484869248000791),
    FX16_CONST(0.8738418434653668), FX16_CONST(-0.4862102761244864),
    FX16_CONST(0.8730949784182902), FX16_CONST(-0.4875501601484357),
    FX16_CONST(0.8723460588943915), FX16_CONST(-0.4888888969197631),
    FX16_CONST(0.871595086655951), FX16_CONST(-0.4902264832882912),
    FX16_CONST(0.870842063470079), FX16_CONST(-0.49156291610654973),
    FX16_CONST(0.8700869911087115), FX16_CONST(-0.492898192229784),
    FX16_CONST(0.8693298713486067), FX16_CONST(-0.49423230851595984),
    FX16_CONST(0.868570705971341), FX16_CONST(-0.4955652618257724),
    FX16_CONST(0.8678094967633032), FX16_CONST(-0.4968970490226545),
    FX16_CONST(0.8670462455156928), FX16_CONST(-0.4982276669727816),
    FX16_CONST(0.8662809540245131), FX16_CONST(-0.4995571125450818),
    FX16_CONST(0.8655136240905691), FX16_CONST(-0.5008853826112408),
    FX16_CONST(0.8647442575194625), FX16_CONST(-0.5022124740457106),
    FX16_CONST(0.8639728561215868), FX16_CONST(-0.5035383837257175),
    FX16_CONST(0.8631994217121242), FX16_CONST(-0.5048631085312676),
    FX16_CONST(0.8624239561110406), FX16_CONST(-0.5061866453451551),
    FX16_CONST(0.8616464611430814), FX16_CONST(-0.5075089910529708),
    FX16_CONST(0.8608669386377672), FX16_CONST(-0.5088301425431071),
    FX16_CONST(0.8600853904293903), FX16_CONST(-0.5101500967067666),
    FX16_CONST(0.8593018183570085), FX16_CONST(-0.5114688504379704),
    FX16_CONST(0.858516224264443), FX16_CONST(-0.5127864006335627),
    FX16_CONST(0.8577286100002721), FX16_CONST(-0.5141027441932216),
    FX16_CONST(0.8569389774178287), FX16_CONST(-0.515417878019463),
    FX16_CONST(0.8561473283751946), FX16_CONST(-0.5167317990176497),
    FX16_CONST(0.855353664735196), FX16_CONST(-0.5180445040959992),
    FX16_CONST(0.8545579883654005), FX16_CONST(-0.5193559901655896),
    FX16_CONST(0.8537603011381115), FX16_CONST(-0.5206662541403669),
    FX16_CONST(0.8529606049303637), FX16_CONST(-0.5219752929371543),
    FX16_CONST(0.8521589016239197), FX16_CONST(-0.5232831034756565),
    FX16_CONST(0.8513551931052652), FX16_CONST(-0.5245896826784687),
    FX16_CONST(0.8505494812656035), FX16_CONST(-0.5258950274710846),
    FX16_CONST(0.8497417680008527), FX16_CONST(-0.5271991347819011),
    FX16_CONST(0.8489320552116397), FX16_CONST(-0.5285020015422284),
    FX16_CONST(0.8481203448032972), FX16_CONST(-0.5298036246862947),
    FX16_CONST(0.8473066386858585), FX16_CONST(-0.5311040011512548),
    FX16_CONST(0.8464909387740521), FX16_CONST(-0.5324031278771979),
    FX16_CONST(0.8456732469872991), FX16_CONST(-0.533701001807153),
    FX16_CONST(0.8448535652497072), FX16_CONST(-0.534997619887097),
    FX16_CONST(0.8440318954900664), FX16_CONST(-0.5362929790659631),
    FX16_CONST(0.8432082396418453), FX16_CONST(-0.5375870762956456),
    FX16_CONST(0.842382599643186), FX16_CONST(-0.5388799085310083),
    FX16_CONST(0.8415549774368984), FX16_CONST(-0.5401714727298929),
    FX16_CONST(0.8407253749704582), FX16_CONST(-0.5414617658531232),
    FX16_CONST(0.8398937941959995), FX16_CONST(-0.5427507848645158),
    FX16_CONST(0.8390602370703127), FX16_CONST(-0.5440385267308839),
    FX16_CONST(0.8382247055548382), FX16_CONST(-0.5453249884220462),
    FX16_CONST(0.8373872016156619), FX16_CONST(-0.5466101669108347),
    FX16_CONST(0.836547727223512), FX16_CONST(-0.5478940591731002),
    FX16_CONST(0.8357062843537527), FX16_CONST(-0.5491766621877195),
    FX16_CONST(0.8348628749863801), FX16_CONST(-0.5504579729366047),
    FX16_CONST(0.834017501106018), FX16_CONST(-0.5517379884047074),
    FX16_CONST(0.8331701647019133), FX16_CONST(-0.5530167055800274),
    FX16_CONST(0.8323208677679297), FX16_CONST(-0.5542941214536201),
    FX16_CONST(0.8314696123025453), FX16_CONST(-0.555570233019602),
    FX16_CONST(0.8306164003088463), FX16_CONST(-0.55684503727516),
    FX16_CONST(0.829761233794523), FX16_CONST(-0.5581185312205561),
    FX16_CONST(0.8289041147718651), FX16_CONST(-0.5593907118591358),
    FX16_CONST(0.8280450452577558), FX16_CONST(-0.5606615761973359),
    FX16_CONST(0.827184027273669), FX16_CONST(-0.5619311212446895),
    FX16_CONST(0.8263210628456636), FX16_CONST(-0.5631993440138339),
    FX16_CONST(0.8254561540043776), FX16_CONST(-0.5644662415205194),
    FX16_CONST(0.8245893027850252), FX16_CONST(-0.5657318107836132),
    FX16_CONST(0.8237205112273915), FX16_CONST(-0.5669960488251085),
    FX16_CONST(0.8228497813758263), FX16_CONST(-0.5682589526701315),
    FX16_CONST(0.8219771152792414), FX16_CONST(-0.5695205193469473),
    FX16_CONST(0.8211025149911048), FX16_CONST(-0.5707807458869671),
    FX16_CONST(0.8202259825694347), FX16_CONST(-0.572039629324757),
    FX16_CONST(0.8193475200767971), FX16_CONST(-0.573297166698042),
    FX16_CONST(0.8184671295802988), FX16_CONST(-0.5745533550477158),
    FX16_CONST(0.8175848131515837), FX16_CONST(-0.5758081914178453),
    FX16_CONST(0.816700572866828), FX16_CONST(-0.5770616728556793),
    FX16_CONST(0.8158144108067338), FX16_CONST(-0.5783137964116555),
    FX16_CONST(0.8149263290565265), FX16_CONST(-0.5795645591394059),
    FX16_CONST(0.8140363297059485), FX16_CONST(-0.5808139580957644),
    FX16_CONST(0.8131444148492536), FX16_CONST(-0.5820619903407755),
    FX16_CONST(0.8122505865852039), FX16_CONST(-0.5833086529376984),
    FX16_CONST(0.8113548470170638), FX16_CONST(-0.5845539429530152),
    FX16_CONST(0.8104571982525948), FX16_CONST(-0.5857978574564389),
    FX16_CONST(0.8095576424040515), FX16_CONST(-0.5870403935209177),
    FX16_CONST(0.8086561815881751), FX16_CONST(-0.5882815482226452),
    FX16_CONST(0.8077528179261904), FX16_CONST(-0.5895213186410639),
    FX16_CONST(0.8068475535437994), FX16_CONST(-0.590759701858874),
    FX16_CONST(0.8059403905711764), FX16_CONST(-0.5919966949620409),
    FX16_CONST(0.8050313311429635), FX16_CONST(-0.5932322950397999),
    FX16_CONST(0.8041203773982658), FX16_CONST(-0.5944664991846643),
    FX16_CONST(0.8032075314806449), FX16_CONST(-0.5956993044924334),
    FX16_CONST(0.8022927955381156), FX16_CONST(-0.5969307080621966),
    FX16_CONST(0.8013761717231402), FX16_CONST(-0.5981607069963422),
    FX16_CONST(0.8004576621926228), FX16_CONST(-0.5993892984005645),
    FX16_CONST(0.7995372691079052), FX16_CONST(-0.6006164793838688),
    FX16_CONST(0.7986149946347609), FX16_CONST(-0.60184224705858),
    FX16_CONST(0.797690840943391), FX16_CONST(-0.6030665985403483),
    FX16_CONST(0.7967648102084189), FX16_CONST(-0.6042895309481559),
    FX16_CONST(0.7958369046088836), FX16_CONST(-0.6055110414043254),
    FX16_CONST(0.7949071263282369), FX16_CONST(-0.6067311270345246),
    FX16_CONST(0.7939754775543373), FX16_CONST(-0.6079497849677735),
    FX16_CONST(0.7930419604794436), FX16_CONST(-0.6091670123364532),
    FX16_CONST(0.7921065773002123), FX16_CONST(-0.6103828062763096),
    FX16_CONST(0.7911693302176903), FX16_CONST(-0.6115971639264618),
    FX16_CONST(0.79023022143731), FX16_CONST(-0.6128100824294097),
    FX16_CONST(0.7892892531688859), FX16_CONST(-0.6140215589310382),
    FX16_CONST(0.7883464276266063), FX16_CONST(-0.6152315905806267),
    FX16_CONST(0.7874017470290313), FX16_CONST(-0.6164401745308536),
    FX16_CONST(0.7864552135990859), FX16_CONST(-0.6176473079378038),
    FX16_CONST(0.785506829564054), FX16_CONST(-0.6188529879609762),
    FX16_CONST(0.7845565971555751), FX16_CONST(-0.6200572117632892),
    FX16_CONST(0.7836045186096383), FX16_CONST(-0.6212599765110874),
    FX16_CONST(0.7826505961665757), FX16_CONST(-0.62246127937415),
    FX16_CONST(0.7816948320710593), FX16_CONST(-0.6236611175256946),
    FX16_CONST(0.7807372285720946), FX16_CONST(-0.6248594881423862),
    FX16_CONST(0.7797777879230144), FX16_CONST(-0.6260563884043435),
    FX16_CONST(0.7788165123814761), FX16_CONST(-0.6272518154951439),
    FX16_CONST(0.7778534042094531), FX16_CONST(-0.6284457666018326),
    FX16_CONST(0.7768884656732324), FX16_CONST(-0.6296382389149271),
    FX16_CONST(0.7759216990434078), FX16_CONST(-0.6308292296284244),
    FX16_CONST(0.7749531065948739), FX16_CONST(-0.632018735939809),
    FX16_CONST(0.7739826906068228), FX16_CONST(-0.6332067550500573),
    FX16_CONST(0.7730104533627371), FX16_CONST(-0.6343932841636454),
    FX16_CONST(0.7720363971503845), FX16_CONST(-0.6355783204885561),
    FX16_CONST(0.7710605242618137), FX16_CONST(-0.6367618612362843),
    FX16_CONST(0.7700828369933481), FX16_CONST(-0.6379439036218439),
    FX16_CONST(0.7691033376455796), FX16_CONST(-0.6391244448637757),
    FX16_CONST(0.7681220285233655), FX16_CONST(-0.6403034821841515),
    FX16_CONST(0.7671389119358204), FX16_CONST(-0.641481012808583),
    FX16_CONST(0.7661539901963128), FX16_CONST(-0.6426570339662269),
    FX16_CONST(0.7651672656224591), FX16_CONST(-0.6438315428897913),
    FX16_CONST(0.7641787405361168), FX16_CONST(-0.6450045368155439),
    FX16_CONST(0.7631884172633812), FX16_CONST(-0.6461760129833164),
    FX16_CONST(0.762196298134579), FX16_CONST(-0.647345968636512),
    FX16_CONST(0.7612023854842619), FX16_CONST(-0.6485144010221124),
    FX16_CONST(0.7602066816512023), FX16_CONST(-0.6496813073906833),
    FX16_CONST(0.7592091889783881), FX16_CONST(-0.6508466849963808),
    FX16_CONST(0.7582099098130153), FX16_CONST(-0.6520105310969595),
    FX16_CONST(0.7572088465064847), FX16_CONST(-0.6531728429537765),
    FX16_CONST(0.7562060014143945), FX16_CONST(-0.6543336178318004),
    FX16_CONST(0.7552013768965364), FX16_CONST(-0.6554928529996155),
    FX16_CONST(0.7541949753168893), FX16_CONST(-0.6566505457294288),
    FX16_CONST(0.7531867990436125), FX16_CONST(-0.6578066932970785),
    FX16_CONST(0.7521768504490427), FX16_CONST(-0.6589612929820374),
    FX16_CONST(0.7511651319096866), FX16_CONST(-0.6601143420674204),
    FX16_CONST(0.7501516458062151), FX16_CONST(-0.6612658378399922),
    FX16_CONST(0.7491363945234593), FX16_CONST(-0.6624157775901719),
    FX16_CONST(0.7481193804504037), FX16_CONST(-0.6635641586120397),
    FX16_CONST(0.7471006059801801), FX16_CONST(-0.6647109782033449),
    FX16_CONST(0.746080073510064), FX16_CONST(-0.6658562336655095),
    FX16_CONST(0.7450577854414661), FX16_CONST(-0.6669999223036374),
    FX16_CONST(0.7440337441799292), FX16_CONST(-0.6681420414265186),
    FX16_CONST(0.7430079521351218), FX16_CONST(-0.6692825883466359),
    FX16_CONST(0.7419804117208311), FX16_CONST(-0.6704215603801731),
    FX16_CONST(0.740951125354959), FX16_CONST(-0.6715589548470184),
    FX16_CONST(0.7399200954595163), FX16_CONST(-0.6726947690707727),
    FX16_CONST(0.7388873244606152), FX16_CONST(-0.673829000378756),
    FX16_CONST(0.7378528147884659), FX16_CONST(-0.674961646102012),
    FX16_CONST(0.73681656887737), FX16_CONST(-0.6760927035753158),
    FX16_CONST(0.7357785891657136), FX16_CONST(-0.6772221701371804),
    FX16_CONST(0.7347388780959637), FX16_CONST(-0.6783500431298612),
    FX16_CONST(0.7336974381146604), FX16_CONST(-0.679476319899365),
    FX16_CONST(0.7326542716724128), FX16_CONST(-0.680600997795453),
    FX16_CONST(0.7316093812238927), FX16_CONST(-0.6817240741716496),
    FX16_CONST(0.7305627692278276), FX16_CONST(-0.682845546385248),
    FX16_CONST(0.729514438146997), FX16_CONST(-0.6839654117973155),
    FX16_CONST(0.7284643904482253), FX16_CONST(-0.6850836677727002),
    FX16_CONST(0.7274126286023758), FX16_CONST(-0.6862003116800386),
    FX16_CONST(0.7263591550843459), FX16_CONST(-0.6873153408917592),
    FX16_CONST(0.7253039723730609), FX16_CONST(-0.6884287527840903),
    FX16_CONST(0.7242470829514669), FX16_CONST(-0.6895405447370669),
    FX16_CONST(0.7231884893065276), FX16_CONST(-0.6906507141345344),
    FX16_CONST(0.7221281939292155), FX16_CONST(-0.6917592583641576),
    FX16_CONST(0.7210661993145081), FX16_CONST(-0.6928661748174247),
    FX16_CONST(0.7200025079613818), FX16_CONST(-0.6939714608896538),
    FX16_CONST(0.7189371223728045), FX16_CONST(-0.6950751139800008),
    FX16_CONST(0.7178700450557317), FX16_CONST(-0.696177131491463),
    FX16_CONST(0.7168012785210996), FX16_CONST(-0.6972775108308864),
    FX16_CONST(0.7157308252838187), FX16_CONST(-0.6983762494089728),
    FX16_CONST(0.714658687862769), FX16_CONST(-0.6994733446402839),
    FX16_CONST(0.7135848687807936), FX16_CONST(-0.7005687939432482),
    FX16_CONST(0.7125093705646923), FX16_CONST(-0.7016625947401685),
    FX16_CONST(0.7114321957452167), FX16_CONST(-0.7027547444572251),
    FX16_CONST(0.7103533468570624), FX16_CONST(-0.7038452405244848),
    FX16_CONST(0.7092728264388656), FX16_CONST(-0.7049340803759049),
    FX16_CONST(0.7081906370331955), FX16_CONST(-0.7060212614493396),
    FX16_CONST(0.7071067811865476), FX16_CONST(-0.7071067811865475),
    FX16_CONST(0.7060212614493397), FX16_CONST(-0.7081906370331954),
    FX16_CONST(0.7049340803759051), FX16_CONST(-0.7092728264388655),
    FX16_CONST(0.703845240524485), FX16_CONST(-0.7103533468570623),
    FX16_CONST(0.7027547444572252), FX16_CONST(-0.7114321957452165),
    FX16_CONST(0.7016625947401687), FX16_CONST(-0.7125093705646922),
    FX16_CONST(0.7005687939432483), FX16_CONST(-0.7135848687807935),
    FX16_CONST(0.699473344640284), FX16_CONST(-0.7146586878627689),
    FX16_CONST(0.6983762494089729), FX16_CONST(-0.7157308252838186),
    FX16_CONST(0.6972775108308865), FX16_CONST(-0.7168012785210995),
    FX16_CONST(0.6961771314914631), FX16_CONST(-0.7178700450557316),
    FX16_CONST(0.6950751139800009), FX16_CONST(-0.7189371223728044),
    FX16_CONST(0.6939714608896539), FX16_CONST(-0.7200025079613817),
    FX16_CONST(0.6928661748174249), FX16_CONST(-0.7210661993145079),
    FX16_CONST(0.6917592583641579), FX16_CONST(-0.7221281939292152),
    FX16_CONST(0.6906507141345346), FX16_CONST(-0.7231884893065275),
    FX16_CONST(0.689540544737067), FX16_CONST(-0.7242470829514668),
    FX16_CONST(0.6884287527840904), FX16_CONST(-0.7253039723730608),
    FX16_CONST(0.6873153408917593), FX16_CONST(-0.7263591550843458),
    FX16_CONST(0.6862003116800387), FX16_CONST(-0.7274126286023757),
    FX16_CONST(0.6850836677727004), FX16_CONST(-0.7284643904482252),
    FX16_CONST(0.6839654117973156), FX16_CONST(-0.7295144381469968),
    FX16_CONST(0.6828455463852481), FX16_CONST(-0.7305627692278275),
    FX16_CONST(0.6817240741716497), FX16_CONST(-0.7316093812238926),
    FX16_CONST(0.6806009977954532), FX16_CONST(-0.7326542716724127),
    FX16_CONST(0.6794763198993651), FX16_CONST(-0.7336974381146603),
    FX16_CONST(0.6783500431298614), FX16_CONST(-0.7347388780959635),
    FX16_CONST(0.6772221701371806), FX16_CONST(-0.7357785891657134),
    FX16_CONST(0.6760927035753159), FX16_CONST(-0.7368165688773698),
    FX16_CONST(0.6749616461020123), FX16_CONST(-0.7378528147884658),
    FX16_CONST(0.6738290003787561), FX16_CONST(-0.7388873244606151),
    FX16_CONST(0.6726947690707729), FX16_CONST(-0.7399200954595162),
    FX16_CONST(0.6715589548470186), FX16_CONST(-0.7409511253549589),
    FX16_CONST(0.6704215603801732), FX16_CONST(-0.741980411720831),
    FX16_CONST(0.669282588346636), FX16_CONST(-0.7430079521351217),
    FX16_CONST(0.6681420414265187), FX16_CONST(-0.7440337441799291),
    FX16_CONST(0.6669999223036376), FX16_CONST(-0.745057785441466),
    FX16_CONST(0.6658562336655096), FX16_CONST(-0.7460800735100638),
    FX16_CONST(0.664710978203345), FX16_CONST(-0.74710060598018),
    FX16_CONST(0.6635641586120398), FX16_CONST(-0.7481193804504036),
    FX16_CONST(0.662415777590172), FX16_CONST(-0.7491363945234591),
    FX16_CONST(0.6612658378399923), FX16_CONST(-0.750151645806215),
    FX16_CONST(0.6601143420674205), FX16_CONST(-0.7511651319096864),
    FX16_CONST(0.6589612929820375), FX16_CONST(-0.7521768504490425),
    FX16_CONST(0.6578066932970787), FX16_CONST(-0.7531867990436124),
    FX16_CONST(0.656650545729429), FX16_CONST(-0.7541949753168892),
    FX16_CONST(0.6554928529996156), FX16_CONST(-0.7552013768965364),
    FX16_CONST(0.6543336178318006), FX16_CONST(-0.7562060014143945),
    FX16_CONST(0.6531728429537766), FX16_CONST(-0.7572088465064847),
    FX16_CONST(0.6520105310969597), FX16_CONST(-0.7582099098130152),
    FX16_CONST(0.650846684996381), FX16_CONST(-0.759209188978388),
    FX16_CONST(0.6496813073906834), FX16_CONST(-0.7602066816512022),
    FX16_CONST(0.6485144010221126), FX16_CONST(-0.7612023854842617),
    FX16_CONST(0.6473459686365121), FX16_CONST(-0.7621962981345789),
    FX16_CONST(0.6461760129833166), FX16_CONST(-0.7631884172633812),
    FX16_CONST(0.645004536815544), FX16_CONST(-0.7641787405361167),
    FX16_CONST(0.6438315428897914), FX16_CONST(-0.765167265622459),
    FX16_CONST(0.6426570339662271), FX16_CONST(-0.7661539901963128),
    FX16_CONST(0.6414810128085832), FX16_CONST(-0.7671389119358204),
    FX16_CONST(0.6403034821841516), FX16_CONST(-0.7681220285233654),
    FX16_CONST(0.6391244448637758), FX16_CONST(-0.7691033376455795),
    FX16_CONST(0.637943903621844), FX16_CONST(-0.7700828369933479),
    FX16_CONST(0.6367618612362844), FX16_CONST(-0.7710605242618136),
    FX16_CONST(0.6355783204885562), FX16_CONST(-0.7720363971503844),
    FX16_CONST(0.6343932841636455), FX16_CONST(-0.773010453362737),
    FX16_CONST(0.6332067550500574), FX16_CONST(-0.7739826906068227),
    FX16_CONST(0.6320187359398091), FX16_CONST(-0.7749531065948738),
    FX16_CONST(0.6308292296284245), FX16_CONST(-0.7759216990434077),
    FX16_CONST(0.6296382389149272), FX16_CONST(-0.7768884656732323),
    FX16_CONST(0.6284457666018327), FX16_CONST(-0.777853404209453),
    FX16_CONST(0.6272518154951441), FX16_CONST(-0.778816512381476),
    FX16_CONST(0.6260563884043436), FX16_CONST(-0.7797777879230143),
    FX16_CONST(0.6248594881423863), FX16_CONST(-0.7807372285720945),
    FX16_CONST(0.6236611175256949), FX16_CONST(-0.7816948320710593),
    FX16_CONST(0.6224612793741501), FX16_CONST(-0.7826505961665756),
    FX16_CONST(0.6212599765110876), FX16_CONST(-0.7836045186096382),
    FX16_CONST(0.6200572117632894), FX16_CONST(-0.784556597155575),
    FX16_CONST(0.6188529879609764), FX16_CONST(-0.7855068295640539),
    FX16_CONST(0.6176473079378039), FX16_CONST(-0.7864552135990858),
    FX16_CONST(0.6164401745308538), FX16_CONST(-0.7874017470290312),
    FX16_CONST(0.6152315905806269), FX16_CONST(-0.7883464276266062),
    FX16_CONST(0.6140215589310384), FX16_CONST(-0.7892892531688858),
    FX16_CONST(0.6128100824294098), FX16_CONST(-0.7902302214373099),
    FX16_CONST(0.6115971639264619), FX16_CONST(-0.7911693302176902),
    FX16_CONST(0.6103828062763097), FX16_CONST(-0.7921065773002122),
    FX16_CONST(0.6091670123364533), FX16_CONST(-0.7930419604794436),
    FX16_CONST(0.6079497849677736), FX16_CONST(-0.7939754775543372),
    FX16_CONST(0.6067311270345247), FX16_CONST(-0.7949071263282368),
    FX16_CONST(0.6055110414043257), FX16_CONST(-0.7958369046088835),
    FX16_CONST(0.604289530948156), FX16_CONST(-0.7967648102084187),
    FX16_CONST(0.6030665985403484), FX16_CONST(-0.7976908409433909),
    FX16_CONST(0.6018422470585801), FX16_CONST(-0.7986149946347608),
    FX16_CONST(0.6006164793838689), FX16_CONST(-0.7995372691079051),
    FX16_CONST(0.5993892984005647), FX16_CONST(-0.8004576621926226),
    FX16_CONST(0.5981607069963424), FX16_CONST(-0.8013761717231402),
    FX16_CONST(0.5969307080621967), FX16_CONST(-0.8022927955381155),
    FX16_CONST(0.5956993044924335), FX16_CONST(-0.8032075314806448),
    FX16_CONST(0.5944664991846644), FX16_CONST(-0.8041203773982657),
    FX16_CONST(0.5932322950398), FX16_CONST(-0.8050313311429634),
    FX16_CONST(0.591996694962041), FX16_CONST(-0.8059403905711763),
    FX16_CONST(0.5907597018588742), FX16_CONST(-0.8068475535437993),
    FX16_CONST(0.589521318641064), FX16_CONST(-0.8077528179261902),
    FX16_CONST(0.5882815482226453), FX16_CONST(-0.808656181588175),
    FX16_CONST(0.5870403935209179), FX16_CONST(-0.8095576424040514),
    FX16_CONST(0.585797857456439), FX16_CONST(-0.8104571982525947),
    FX16_CONST(0.5845539429530153), FX16_CONST(-0.8113548470170637),
    FX16_CONST(0.5833086529376985), FX16_CONST(-0.8122505865852038),
    FX16_CONST(0.5820619903407757), FX16_CONST(-0.8131444148492535),
    FX16_CONST(0.5808139580957645), FX16_CONST(-0.8140363297059484),
    FX16_CONST(0.579564559139406), FX16_CONST(-0.8149263290565264),
    FX16_CONST(0.5783137964116557), FX16_CONST(-0.8158144108067338),
    FX16_CONST(0.5770616728556794), FX16_CONST(-0.8167005728668278),
    FX16_CONST(0.5758081914178454), FX16_CONST(-0.8175848131515836),
    FX16_CONST(0.5745533550477159), FX16_CONST(-0.8184671295802987),
    FX16_CONST(0.5732971666980421), FX16_CONST(-0.819347520076797),
    FX16_CONST(0.5720396293247573), FX16_CONST(-0.8202259825694346),
    FX16_CONST(0.5707807458869673), FX16_CONST(-0.8211025149911046),
    FX16_CONST(0.5695205193469475), FX16_CONST(-0.8219771152792413),
    FX16_CONST(0.5682589526701317), FX16_CONST(-0.8228497813758262),
    FX16_CONST(0.5669960488251087), FX16_CONST(-0.8237205112273914),
    FX16_CONST(0.5657318107836135), FX16_CONST(-0.8245893027850251),
    FX16_CONST(0.5644662415205195), FX16_CONST(-0.8254561540043774),
    FX16_CONST(0.5631993440138341), FX16_CONST(-0.8263210628456635),
    FX16_CONST(0.5619311212446896), FX16_CONST(-0.827184027273669),
    FX16_CONST(0.5606615761973361), FX16_CONST(-0.8280450452577557),
    FX16_CONST(0.559390711859136), FX16_CONST(-0.828904114771865),
    FX16_CONST(0.5581185312205563), FX16_CONST(-0.8297612337945229),
    FX16_CONST(0.5568450372751601), FX16_CONST(-0.8306164003088462),
    FX16_CONST(0.5555702330196022), FX16_CONST(-0.8314696123025453),
    FX16_CONST(0.5542941214536202), FX16_CONST(-0.8323208677679296),
    FX16_CONST(0.5530167055800275), FX16_CONST(-0.8331701647019132),
    FX16_CONST(0.5517379884047077), FX16_CONST(-0.8340175011060179),
    FX16_CONST(0.5504579729366049), FX16_CONST(-0.83486287498638),
    FX16_CONST(0.5491766621877197), FX16_CONST(-0.8357062843537526),
    FX16_CONST(0.5478940591731004), FX16_CONST(-0.8365477272235119),
    FX16_CONST(0.546610166910835), FX16_CONST(-0.8373872016156618),
    FX16_CONST(0.5453249884220464), FX16_CONST(-0.8382247055548381),
    FX16_CONST(0.544038526730884), FX16_CONST(-0.8390602370703126),
    FX16_CONST(0.5427507848645159), FX16_CONST(-0.8398937941959995),
    FX16_CONST(0.5414617658531233), FX16_CONST(-0.8407253749704581),
    FX16_CONST(0.540171472729893), FX16_CONST(-0.8415549774368983),
    FX16_CONST(0.5388799085310084), FX16_CONST(-0.8423825996431858),
    FX16_CONST(0.5375870762956457), FX16_CONST(-0.8432082396418453),
    FX16_CONST(0.5362929790659633), FX16_CONST(-0.8440318954900664),
    FX16_CONST(0.5349976198870972), FX16_CONST(-0.8448535652497071),
    FX16_CONST(0.5337010018071532), FX16_CONST(-0.845673246987299),
    FX16_CONST(0.532403127877198), FX16_CONST(-0.846490938774052),
    FX16_CONST(0.5311040011512549), FX16_CONST(-0.8473066386858584),
    FX16_CONST(0.5298036246862948), FX16_CONST(-0.8481203448032971),
    FX16_CONST(0.5285020015422285), FX16_CONST(-0.8489320552116396),
    FX16_CONST(0.5271991347819013), FX16_CONST(-0.8497417680008525),
    FX16_CONST(0.5258950274710849), FX16_CONST(-0.8505494812656034),
    FX16_CONST(0.524589682678469), FX16_CONST(-0.8513551931052652),
    FX16_CONST(0.5232831034756567), FX16_CONST(-0.8521589016239196),
    FX16_CONST(0.5219752929371544), FX16_CONST(-0.8529606049303636),
    FX16_CONST(0.5206662541403672), FX16_CONST(-0.8537603011381114),
    FX16_CONST(0.5193559901655898), FX16_CONST(-0.8545579883654004),
    FX16_CONST(0.5180445040959994), FX16_CONST(-0.8553536647351959),
    FX16_CONST(0.5167317990176498), FX16_CONST(-0.8561473283751945),
    FX16_CONST(0.5154178780194631), FX16_CONST(-0.8569389774178287),
    FX16_CONST(0.5141027441932218), FX16_CONST(-0.857728610000272),
    FX16_CONST(0.512786400633563), FX16_CONST(-0.8585162242644429),
    FX16_CONST(0.5114688504379705), FX16_CONST(-0.8593018183570084),
    FX16_CONST(0.5101500967067668), FX16_CONST(-0.8600853904293901),
    FX16_CONST(0.5088301425431073), FX16_CONST(-0.8608669386377672),
    FX16_CONST(0.507508991052971), FX16_CONST(-0.8616464611430813),
    FX16_CONST(0.5061866453451552), FX16_CONST(-0.8624239561110405),
    FX16_CONST(0.5048631085312677), FX16_CONST(-0.863199421712124),
    FX16_CONST(0.5035383837257176), FX16_CONST(-0.8639728561215867),
    FX16_CONST(0.5022124740457107), FX16_CONST(-0.8647442575194624),
    FX16_CONST(0.5008853826112409), FX16_CONST(-0.865513624090569),
    FX16_CONST(0.4995571125450819), FX16_CONST(-0.866280954024513),
    FX16_CONST(0.49822766697278176), FX16_CONST(-0.8670462455156926),
    FX16_CONST(0.4968970490226547), FX16_CONST(-0.8678094967633032),
    FX16_CONST(0.49556526182577254), FX16_CONST(-0.8685707059713409),
    FX16_CONST(0.49423230851596), FX16_CONST(-0.8693298713486066),
    FX16_CONST(0.49289819222978415), FX16_CONST(-0.8700869911087113),
    FX16_CONST(0.4915629161065499), FX16_CONST(-0.8708420634700789),
    FX16_CONST(0.4902264832882914), FX16_CONST(-0.8715950866559509),
    FX16_CONST(0.4888888969197632), FX16_CONST(-0.8723460588943914),
    FX16_CONST(0.4875501601484359), FX16_CONST(-0.8730949784182901),
    FX16_CONST(0.4862102761244866), FX16_CONST(-0.8738418434653668),
    FX16_CONST(0.4848692480007911), FX16_CONST(-0.8745866522781761),
    FX16_CONST(0.48352707893291863), FX16_CONST(-0.8753294031041109),
    FX16_CONST(0.4821837720791229), FX16_CONST(-0.8760700941954065),
    FX16_CONST(0.48083933060033396), FX16_CONST(-0.8768087238091457),
    FX16_CONST(0.4794937576601533), FX16_CONST(-0.8775452902072611),
    FX16_CONST(0.4781470564248432), FX16_CONST(-0.8782797916565415),
    FX16_CONST(0.4767992300633221), FX16_CONST(-0.8790122264286335),
    FX16_CONST(0.4754502817471561), FX16_CONST(-0.8797425928000473),
    FX16_CONST(0.4741002146505501), FX16_CONST(-0.8804708890521608),
    FX16_CONST(0.47274903195034274), FX16_CONST(-0.8811971134712221),
    FX16_CONST(0.4713967368259978), FX16_CONST(-0.8819212643483549),
    FX16_CONST(0.4700433324595957), FX16_CONST(-0.8826433399795628),
    FX16_CONST(0.46868882203582785), FX16_CONST(-0.8833633386657317),
    FX16_CONST(0.4673332087419886), FX16_CONST(-0.8840812587126349),
    FX16_CONST(0.4659764957679662), FX16_CONST(-0.8847970984309378),
    FX16_CONST(0.4646186863062381), FX16_CONST(-0.8855108561361998),
    FX16_CONST(0.4632597835518603), FX16_CONST(-0.8862225301488805),
    FX16_CONST(0.46189979070246273), FX16_CONST(-0.8869321187943422),
    FX16_CONST(0.4605387109582402), FX16_CONST(-0.8876396204028538),
    FX16_CONST(0.4591765475219442), FX16_CONST(-0.8883450333095962),
    FX16_CONST(0.4578133035988772), FX16_CONST(-0.8890483558546646),
    FX16_CONST(0.45644898239688414), FX16_CONST(-0.8897495863830727),
    FX16_CONST(0.4550835871263439), FX16_CONST(-0.8904487232447579),
    FX16_CONST(0.45371712100016376), FX16_CONST(-0.8911457647945833),
    FX16_CONST(0.45234958723377106), FX16_CONST(-0.8918407093923426),
    FX16_CONST(0.45098098904510386), FX16_CONST(-0.8925335554027646),
    FX16_CONST(0.4496113296546069), FX16_CONST(-0.8932243011955152),
    FX16_CONST(0.44824061228522005), FX16_CONST(-0.8939129451452031),
    FX16_CONST(0.44686884016237416), FX16_CONST(-0.8945994856313827),
    FX16_CONST(0.44549601651398196), FX16_CONST(-0.8952839210385574),
    FX16_CONST(0.4441221445704293), FX16_CONST(-0.8959662497561851),
    FX16_CONST(0.44274722756456997), FX16_CONST(-0.8966464701786803),
    FX16_CONST(0.4413712687317169), FX16_CONST(-0.8973245807054182),
    FX16_CONST(0.4399942713096333), FX16_CONST(-0.8980005797407398),
    FX16_CONST(0.43861623853852755), FX16_CONST(-0.8986744656939539),
    FX16_CONST(0.43723717366104425), FX16_CONST(-0.8993462369793415),
    FX16_CONST(0.43585707992225553), FX16_CONST(-0.9000158920161602),
    FX16_CONST(0.434475960569656), FX16_CONST(-0.9006834292286467),
    FX16_CONST(0.43309381885315207), FX16_CONST(-0.9013488470460219),
    FX16_CONST(0.43171065802505726), FX16_CONST(-0.9020121439024932),
    FX16_CONST(0.4303264813400829), FX16_CONST(-0.9026733182372587),
    FX16_CONST(0.4289412920553296), FX16_CONST(-0.9033323684945118),
    FX16_CONST(0.42755509343028203), FX16_CONST(-0.9039892931234433),
    FX16_CONST(0.42616788872679984), FX16_CONST(-0.9046440905782461),
    FX16_CONST(0.42477968120910886), FX16_CONST(-0.9052967593181187),
    FX16_CONST(0.42339047414379594), FX16_CONST(-0.9059472978072685),
    FX16_CONST(0.42200027079979985), FX16_CONST(-0.9065957045149153),
    FX16_CONST(0.42060907444840256), FX16_CONST(-0.9072419779152958),
    FX16_CONST(0.41921688836322424), FX16_CONST(-0.907886116487666),
    FX16_CONST(0.41782371582021244), FX16_CONST(-0.9085281187163061),
    FX16_CONST(0.41642956009763715), FX16_CONST(-0.9091679830905224),
    FX16_CONST(0.41503442447608185), FX16_CONST(-0.9098057081046521),
    FX16_CONST(0.41363831223843467), FX16_CONST(-0.9104412922580671),
    FX16_CONST(0.41224122666988283), FX16_CONST(-0.9110747340551764),
    FX16_CONST(0.41084317105790413), FX16_CONST(-0.9117060320054298),
    FX16_CONST(0.4094441486922577), FX16_CONST(-0.9123351846233227),
    FX16_CONST(0.4080441628649786), FX16_CONST(-0.9129621904283982),
    FX16_CONST(0.4066432168703692), FX16_CONST(-0.9135870479452507),
    FX16_CONST(0.4052413140049899), FX16_CONST(-0.9142097557035307),
    FX16_CONST(0.4038384575676544), FX16_CONST(-0.914830312237946),
    FX16_CONST(0.4024346508594186), FX16_CONST(-0.9154487160882677),
    FX16_CONST(0.4010298971835756), FX16_CONST(-0.9160649657993317),
    FX16_CONST(0.39962419984564707), FX16_CONST(-0.9166790599210426),
    FX16_CONST(0.39821756215337367), FX16_CONST(-0.9172909970083779),
    FX16_CONST(0.39680998741671025), FX16_CONST(-0.9179007756213905),
    FX16_CONST(0.3954014789478165), FX16_CONST(-0.9185083943252121),
    FX16_CONST(0.39399204006104815), FX16_CONST(-0.9191138516900578),
    FX16_CONST(0.3925816740729514), FX16_CONST(-0.9197171462912274),
    FX16_CONST(0.39117038430225404), FX16_CONST(-0.9203182767091105),
    FX16_CONST(0.38975817406985647), FX16_CONST(-0.9209172415291894),
    FX16_CONST(0.3883450466988266), FX16_CONST(-0.9215140393420418),
    FX16_CONST(0.38693100551438875), FX16_CONST(-0.9221086687433451),
    FX16_CONST(0.38551605384391885), FX16_CONST(-0.9227011283338786),
    FX16_CONST(0.3841001950169353), FX16_CONST(-0.9232914167195275),
    FX16_CONST(0.3826834323650899), FX16_CONST(-0.9238795325112867),
    FX16_CONST(0.3812657692221623), FX16_CONST(-0.9244654743252626),
    FX16_CONST(0.3798472089240514), FX16_CONST(-0.9250492407826775),
    FX16_CONST(0.37842775480876567), FX16_CONST(-0.9256308305098727),
    FX16_CONST(0.37700741021641815), FX16_CONST(-0.9262102421383114),
    FX16_CONST(0.3755861784892174), FX16_CONST(-0.9267874743045817),
    FX16_CONST(0.37416406297145804), FX16_CONST(-0.9273625256504011),
    FX16_CONST(0.3727410670095161), FX16_CONST(-0.9279353948226178),
    FX16_CONST(0.3713171939518377), FX16_CONST(-0.9285060804732155),
    FX16_CONST(0.3698924471489341), FX16_CONST(-0.9290745812593159),
    FX16_CONST(0.3684668299533726), FX16_CONST(-0.9296408958431812),
    FX16_CONST(0.3670403457197673), FX16_CONST(-0.9302050228922191),
    FX16_CONST(0.3656129978047738), FX16_CONST(-0.9307669610789837),
    FX16_CONST(0.3641847895670801), FX16_CONST(-0.9313267090811803),
    FX16_CONST(0.3627557243673973), FX16_CONST(-0.931884265581668),
    FX16_CONST(0.3613258055684542), FX16_CONST(-0.9324396292684625),
    FX16_CONST(0.35989503653498833), FX16_CONST(-0.9329927988347388),
    FX16_CONST(0.3584634206337366), FX16_CONST(-0.9335437729788362),
    FX16_CONST(0.3570309612334303), FX16_CONST(-0.9340925504042588),
    FX16_CONST(0.355597661704784), FX16_CONST(-0.9346391298196807),
    FX16_CONST(0.3541635254204904), FX16_CONST(-0.9351835099389476),
    FX16_CONST(0.35272855575521095), FX16_CONST(-0.9357256894810803),
    FX16_CONST(0.3512927560855672), FX16_CONST(-0.9362656671702783),
    FX16_CONST(0.34985612979013486), FX16_CONST(-0.9368034417359217),
    FX16_CONST(0.3484186802494348), FX16_CONST(-0.9373390119125748),
    FX16_CONST(0.34698041084592374), FX16_CONST(-0.9378723764399898),
    FX16_CONST(0.345541324963989), FX16_CONST(-0.9384035340631082),
    FX16_CONST(0.34410142598993904), FX16_CONST(-0.9389324835320645),
    FX16_CONST(0.34266071731199443), FX16_CONST(-0.9394592236021899),
    FX16_CONST(0.3412192023202827), FX16_CONST(-0.9399837530340138),
    FX16_CONST(0.339776884406827), FX16_CONST(-0.9405060705932683),
    FX16_CONST(0.3383337669655412), FX16_CONST(-0.9410261750508893),
    FX16_CONST(0.33688985339222033), FX16_CONST(-0.9415440651830207),
    FX16_CONST(0.3354451470845317), FX16_CONST(-0.9420597397710173),
    FX16_CONST(0.3339996514420094), FX16_CONST(-0.9425731976014469),
    FX16_CONST(0.33255336986604445), FX16_CONST(-0.9430844374660934),
    FX16_CONST(0.3311063057598765), FX16_CONST(-0.9435934581619604),
    FX16_CONST(0.32965846252858744), FX16_CONST(-0.9441002584912727),
    FX16_CONST(0.3282098435790927), FX16_CONST(-0.9446048372614801),
    FX16_CONST(0.32676045232013184), FX16_CONST(-0.9451071932852606),
    FX16_CONST(0.32531029216226326), FX16_CONST(-0.9456073253805212),
    FX16_CONST(0.323859366517853), FX16_CONST(-0.9461052323704033),
    FX16_CONST(0.32240767880106985), FX16_CONST(-0.9466009130832835),
    FX16_CONST(0.3209552324278755), FX16_CONST(-0.9470943663527771),
    FX16_CONST(0.3195020308160158), FX16_CONST(-0.9475855910177411),
    FX16_CONST(0.3180480773850149), FX16_CONST(-0.9480745859222762),
    FX16_CONST(0.31659337555616607), FX16_CONST(-0.9485613499157303),
    FX16_CONST(0.3151379287525225), FX16_CONST(-0.9490458818527006),
    FX16_CONST(0.3136817403988914), FX16_CONST(-0.9495281805930367),
    FX16_CONST(0.3122248139218251), FX16_CONST(-0.950008245001843),
    FX16_CONST(0.31076715274961153), FX16_CONST(-0.9504860739494817),
    FX16_CONST(0.309308760312269), FX16_CONST(-0.950961666311575),
    FX16_CONST(0.30784964004153503), FX16_CONST(-0.9514350209690083),
    FX16_CONST(0.3063897953708609), FX16_CONST(-0.9519061368079323),
    FX16_CONST(0.30492922973540265), FX16_CONST(-0.9523750127197658),
    FX16_CONST(0.3034679465720114), FX16_CONST(-0.9528416476011986),
    FX16_CONST(0.30200594931922803), FX16_CONST(-0.9533060403541939),
    FX16_CONST(0.3005432414172737), FX16_CONST(-0.9537681898859902),
    FX16_CONST(0.29907982630804053), FX16_CONST(-0.9542280951091056),
    FX16_CONST(0.29761570743508614), FX16_CONST(-0.9546857549413383),
    FX16_CONST(0.296150888243624), FX16_CONST(-0.9551411683057707),
    FX16_CONST(0.2946853721805144), FX16_CONST(-0.9555943341307711),
    FX16_CONST(0.29321916269425896), FX16_CONST(-0.9560452513499963),
    FX16_CONST(0.29175226323498943), FX16_CONST(-0.956493918902395),
    FX16_CONST(0.2902846772544624), FX16_CONST(-0.9569403357322088),
    FX16_CONST(0.28881640820604976), FX16_CONST(-0.9573845007889759),
    FX16_CONST(0.2873474595447296), FX16_CONST(-0.9578264130275329),
    FX16_CONST(0.28587783472708056), FX16_CONST(-0.9582660714080177),
    FX16_CONST(0.2844075372112721), FX16_CONST(-0.9587034748958715),
    FX16_CONST(0.28293657045705545), FX16_CONST(-0.9591386224618419),
    FX16_CONST(0.2814649379257579), FX16_CONST(-0.9595715130819845),
    FX16_CONST(0.27999264308027344), FX16_CONST(-0.9600021457376658),
    FX16_CONST(0.27851968938505317), FX16_CONST(-0.9604305194155658),
    FX16_CONST(0.27704608030610023), FX16_CONST(-0.9608566331076795),
    FX16_CONST(0.2755718193109583), FX16_CONST(-0.9612804858113206),
    FX16_CONST(0.2740969098687064), FX16_CONST(-0.9617020765291225),
    FX16_CONST(0.27262135544994925), FX16_CONST(-0.9621214042690415),
    FX16_CONST(0.2711451595268081), FX16_CONST(-0.9625384680443592),
    FX16_CONST(0.2696683255729151), FX16_CONST(-0.9629532668736839),
    FX16_CONST(0.2681908570634034), FX16_CONST(-0.9633657997809539),
    FX16_CONST(0.2667127574748985), FX16_CONST(-0.9637760657954398),
    FX16_CONST(0.26523403028551173), FX16_CONST(-0.9641840639517458),
    FX16_CONST(0.26375467897483157), FX16_CONST(-0.9645897932898126),
    FX16_CONST(0.2622747070239137), FX16_CONST(-0.9649932528549203),
    FX16_CONST(0.26079411791527585), FX16_CONST(-0.9653944416976893),
    FX16_CONST(0.2593129151328864), FX16_CONST(-0.9657933588740836),
    FX16_CONST(0.257831102162159), FX16_CONST(-0.9661900034454125),
    FX16_CONST(0.2563486824899432), FX16_CONST(-0.966584374478333),
    FX16_CONST(0.2548656596045147), FX16_CONST(-0.9669764710448521),
    FX16_CONST(0.2533820369955701), FX16_CONST(-0.9673662922223285),
    FX16_CONST(0.2518978181542172), FX16_CONST(-0.9677538370934754),
    FX16_CONST(0.25041300657296534), FX16_CONST(-0.9681391047463623),
    FX16_CONST(0.2489276057457201), FX16_CONST(-0.9685220942744174),
    FX16_CONST(0.2474416191677735), FX16_CONST(-0.9689028047764289),
    FX16_CONST(0.24595505033579465), FX16_CONST(-0.9692812353565484),
    FX16_CONST(0.24446790274782448), FX16_CONST(-0.9696573851242923),
    FX16_CONST(0.24298017990326407), FX16_CONST(-0.970031253194544),
    FX16_CONST(0.24149188530286936), FX16_CONST(-0.9704028386875555),
    FX16_CONST(0.24000302244874178), FX16_CONST(-0.9707721407289502),
    FX16_CONST(0.23851359484431855), FX16_CONST(-0.9711391584497251),
    FX16_CONST(0.23702360599436717), FX16_CONST(-0.9715038909862518),
    FX16_CONST(0.23553305940497574), FX16_CONST(-0.9718663374802793),
    FX16_CONST(0.2340419585835435), FX16_CONST(-0.9722264970789363),
    FX16_CONST(0.23255030703877516), FX16_CONST(-0.9725843689347322),
    FX16_CONST(0.23105810828067133), FX16_CONST(-0.9729399522055601),
    FX16_CONST(0.22956536582051892), FX16_CONST(-0.9732932460546982),
    FX16_CONST(0.22807208317088606), FX16_CONST(-0.9736442496508119),
    FX16_CONST(0.22657826384561017), FX16_CONST(-0.9739929621679558),
    FX16_CONST(0.22508391135979283), FX16_CONST(-0.9743393827855759),
    FX16_CONST(0.2235890292297903), FX16_CONST(-0.9746835106885107),
    FX16_CONST(0.22209362097320365), FX16_CONST(-0.9750253450669941),
    FX16_CONST(0.2205976901088735), FX16_CONST(-0.975364885116657),
    FX16_CONST(0.21910124015687005), FX16_CONST(-0.9757021300385285),
    FX16_CONST(0.21760427463848372), FX16_CONST(-0.976037079039039),
    FX16_CONST(0.21610679707621944), FX16_CONST(-0.9763697313300211),
    FX16_CONST(0.21460881099378698), FX16_CONST(-0.9767000861287117),
    FX16_CONST(0.21311031991609142), FX16_CONST(-0.9770281426577544),
    FX16_CONST(0.2116113273692279), FX16_CONST(-0.9773539001452),
    FX16_CONST(0.2101118368804698), FX16_CONST(-0.9776773578245099),
    FX16_CONST(0.2086118519782635), FX16_CONST(-0.9779985149345571),
    FX16_CONST(0.20711137619221884), FX16_CONST(-0.9783173707196275),
    FX16_CONST(0.20561041305309938), FX16_CONST(-0.9786339244294231),
    FX16_CONST(0.20410896609281684), FX16_CONST(-0.9789481753190622),
    FX16_CONST(0.20260703884442138), FX16_CONST(-0.979260122649082),
    FX16_CONST(0.201104634842092), FX16_CONST(-0.9795697656854405),
    FX16_CONST(0.19960175762113092), FX16_CONST(-0.9798771036995176),
    FX16_CONST(0.1980984107179538), FX16_CONST(-0.9801821359681173),
    FX16_CONST(0.19659459767008028), FX16_CONST(-0.9804848617734694),
    FX16_CONST(0.1950903220161286), FX16_CONST(-0.9807852804032304),
    FX16_CONST(0.1935855872958038), FX16_CONST(-0.9810833911504866),
    FX16_CONST(0.19208039704989247), FX16_CONST(-0.9813791933137546),
    FX16_CONST(0.19057475482025307), FX16_CONST(-0.9816726861969831),
    FX16_CONST(0.18906866414980636), FX16_CONST(-0.9819638691095552),
    FX16_CONST(0.18756212858252957), FX16_CONST(-0.9822527413662894),
    FX16_CONST(0.1860551516634469), FX16_CONST(-0.9825393022874412),
    FX16_CONST(0.1845477369386197), FX16_CONST(-0.9828235511987052),
    FX16_CONST(0.1830398879551409), FX16_CONST(-0.9831054874312163),
    FX16_CONST(0.18153160826112522), FX16_CONST(-0.9833851103215512),
    FX16_CONST(0.18002290140569957), FX16_CONST(-0.9836624192117303),
    FX16_CONST(0.17851377093899742), FX16_CONST(-0.9839374134492189),
    FX16_CONST(0.17700422041214894), FX16_CONST(-0.984210092386929),
    FX16_CONST(0.17549425337727145), FX16_CONST(-0.9844804553832209),
    FX16_CONST(0.17398387338746413), FX16_CONST(-0.9847485018019042),
    FX16_CONST(0.17247308399679612), FX16_CONST(-0.9850142310122398),
    FX16_CONST(0.17096188876030122), FX16_CONST(-0.9852776423889412),
    FX16_CONST(0.1694502912339682), FX16_CONST(-0.9855387353121761),
    FX16_CONST(0.16793829497473128), FX16_CONST(-0.9857975091675674),
    FX16_CONST(0.16642590354046405), FX16_CONST(-0.9860539633461954),
    FX16_CONST(0.16491312048997014), FX16_CONST(-0.9863080972445986),
    FX16_CONST(0.16339994938297328), FX16_CONST(-0.9865599102647754),
    FX16_CONST(0.16188639378011174), FX16_CONST(-0.9868094018141855),
    FX16_CONST(0.16037245724292845), FX16_CONST(-0.987056571305751),
    FX16_CONST(0.15885814333386147), FX16_CONST(-0.9873014181578584),
    FX16_CONST(0.15734345561623855), FX16_CONST(-0.9875439417943592),
    FX16_CONST(0.15582839765426537), FX16_CONST(-0.9877841416445722),
    FX16_CONST(0.15431297301302008), FX16_CONST(-0.9880220171432835),
    FX16_CONST(0.15279718525844369), FX16_CONST(-0.9882575677307495),
    FX16_CONST(0.1512810379573303), FX16_CONST(-0.9884907928526966),
    FX16_CONST(0.14976453467732145), FX16_CONST(-0.9887216919603238),
    FX16_CONST(0.14824767898689625), FX16_CONST(-0.988950264510303),
    FX16_CONST(0.1467304744553618), FX16_CONST(-0.989176509964781),
    FX16_CONST(0.14521292465284735), FX16_CONST(-0.9894004277913804),
    FX16_CONST(0.14369503315029464), FX16_CONST(-0.9896220174632008),
    FX16_CONST(0.1421768035194481), FX16_CONST(-0.9898412784588205),
    FX16_CONST(0.14065823933284954), FX16_CONST(-0.990058210262297),
    FX16_CONST(0.13913934416382634), FX16_CONST(-0.9902728123631691),
    FX16_CONST(0.13762012158648604), FX16_CONST(-0.9904850842564571),
    FX16_CONST(0.13610057517570648), FX16_CONST(-0.9906950254426646),
    FX16_CONST(0.13458070850712628), FX16_CONST(-0.99090263542778),
    FX16_CONST(0.133060525157139), FX16_CONST(-0.9911079137232769),
    FX16_CONST(0.13154002870288334), FX16_CONST(-0.9913108598461154),
    FX16_CONST(0.13001922272223343), FX16_CONST(-0.9915114733187439),
    FX16_CONST(0.12849811079379309), FX16_CONST(-0.9917097536690995),
    FX16_CONST(0.12697669649688606), FX16_CONST(-0.9919057004306093),
    FX16_CONST(0.12545498341154626), FX16_CONST(-0.9920993131421918),
    FX16_CONST(0.12393297511851248), FX16_CONST(-0.9922905913482573),
    FX16_CONST(0.12241067519921635), FX16_CONST(-0.99247953459871),
    FX16_CONST(0.12088808723577706), FX16_CONST(-0.992666142448948),
    FX16_CONST(0.11936521481099163), FX16_CONST(-0.9928504144598651),
    FX16_CONST(0.11784206150832509), FX16_CONST(-0.9930323501978514),
    FX16_CONST(0.11631863091190471), FX16_CONST(-0.9932119492347945),
    FX16_CONST(0.1147949266065103), FX16_CONST(-0.9933892111480807),
    FX16_CONST(0.11327095217756442), FX16_CONST(-0.9935641355205953),
    FX16_CONST(0.1117467112111265), FX16_CONST(-0.9937367219407246),
    FX16_CONST(0.11022220729388324), FX16_CONST(-0.9939069700023561),
    FX16_CONST(0.10869744401313874), FX16_CONST(-0.9940748793048794),
    FX16_CONST(0.10717242495680916), FX16_CONST(-0.9942404494531879),
    FX16_CONST(0.10564715371341075), FX16_CONST(-0.9944036800576791),
    FX16_CONST(0.10412163387205457), FX16_CONST(-0.9945645707342554),
    FX16_CONST(0.10259586902243656), FX16_CONST(-0.9947231211043257),
    FX16_CONST(0.10106986275482793), FX16_CONST(-0.9948793307948056),
    FX16_CONST(0.09954361866006928), FX16_CONST(-0.9950331994381186),
    FX16_CONST(0.09801714032956083), FX16_CONST(-0.9951847266721968),
    FX16_CONST(0.09649043135525266), FX16_CONST(-0.9953339121404823),
    FX16_CONST(0.09496349532963891), FX16_CONST(-0.9954807554919269),
    FX16_CONST(0.09343633584574797), FX16_CONST(-0.9956252563809943),
    FX16_CONST(0.09190895649713275), FX16_CONST(-0.9957674144676598),
    FX16_CONST(0.09038136087786529), FX16_CONST(-0.9959072294174117),
    FX16_CONST(0.08885355258252475), FX16_CONST(-0.996044700901252),
    FX16_CONST(0.08732553520619206), FX16_CONST(-0.996179828595697),
    FX16_CONST(0.08579731234444016), FX16_CONST(-0.996312612182778),
    FX16_CONST(0.08426888759332418), FX16_CONST(-0.9964430513500426),
    FX16_CONST(0.08274026454937564), FX16_CONST(-0.9965711457905548),
    FX16_CONST(0.08121144680959266), FX16_CONST(-0.9966968952028961),
    FX16_CONST(0.0796824379714302), FX16_CONST(-0.9968202992911657),
    FX16_CONST(0.07815324163279415), FX16_CONST(-0.9969413577649822),
    FX16_CONST(0.07662386139203169), FX16_CONST(-0.997060070339483),
    FX16_CONST(0.07509430084792135), FX16_CONST(-0.9971764367353261),
    FX16_CONST(0.07356456359966773), FX16_CONST(-0.9972904566786902),
    FX16_CONST(0.07203465324688947), FX16_CONST(-0.9974021299012753),
    FX16_CONST(0.07050457338961386), FX16_CONST(-0.9975114561403035),
    FX16_CONST(0.06897432762826702), FX16_CONST(-0.9976184351385196),
    FX16_CONST(0.06744391956366418), FX16_CONST(-0.9977230666441916),
    FX16_CONST(0.06591335279700376), FX16_CONST(-0.9978253504111116),
    FX16_CONST(0.0643826309298577), FX16_CONST(-0.997925286198596),
    FX16_CONST(0.06285175756416149), FX16_CONST(-0.9980228737714862),
    FX16_CONST(0.06132073630220849), FX16_CONST(-0.9981181129001492),
    FX16_CONST(0.05978957074664007), FX16_CONST(-0.9982110033604782),
    FX16_CONST(0.058258264500435794), FX16_CONST(-0.9983015449338929),
    FX16_CONST(0.05672682116690807), FX16_CONST(-0.9983897374073402),
    FX16_CONST(0.055195244349690094), FX16_CONST(-0.9984755805732948),
    FX16_CONST(0.05366353765273052), FX16_CONST(-0.9985590742297593),
    FX16_CONST(0.052131704680283594), FX16_CONST(-0.9986402181802652),
    FX16_CONST(0.05059974903689939), FX16_CONST(-0.9987190122338729),
    FX16_CONST(0.049067674327417966), FX16_CONST(-0.9987954562051724),
    FX16_CONST(0.04753548415695954), FX16_CONST(-0.9988695499142836),
    FX16_CONST(0.046003182130914706), FX16_CONST(-0.9989412931868569),
    FX16_CONST(0.044470771854938584), FX16_CONST(-0.9990106858540734),
    FX16_CONST(0.04293825693494102), FX16_CONST(-0.9990777277526454),
    FX16_CONST(0.041405640977076774), FX16_CONST(-0.9991424187248169),
    FX16_CONST(0.03987292758774013), FX16_CONST(-0.9992047586183639),
    FX16_CONST(0.038340120373552854), FX16_CONST(-0.9992647472865944),
    FX16_CONST(0.03680722294135883), FX16_CONST(-0.9993223845883495),
    FX16_CONST(0.03527423889821423), FX16_CONST(-0.9993776703880028),
    FX16_CONST(0.033741171851377705), FX16_CONST(-0.9994306045554617),
    FX16_CONST(0.032208025408304544), FX16_CONST(-0.999481186966167),
    FX16_CONST(0.030674803176636865), FX16_CONST(-0.9995294175010931),
    FX16_CONST(0.029141508764193802), FX16_CONST(-0.9995752960467492),
    FX16_CONST(0.02760814577896566), FX16_CONST(-0.9996188224951786),
    FX16_CONST(0.0260747178291041), FX16_CONST(-0.9996599967439592),
    FX16_CONST(0.024541228522912326), FX16_CONST(-0.9996988186962042),
    FX16_CONST(0.023007681468839695), FX16_CONST(-0.9997352882605617),
    FX16_CONST(0.021474080275469667), FX16_CONST(-0.9997694053512153),
    FX16_CONST(0.019940428551514438), FX16_CONST(-0.9998011698878843),
    FX16_CONST(0.0184067299058051), FX16_CONST(-0.9998305817958234),
    FX16_CONST(0.016872987947281835), FX16_CONST(-0.9998576410058239),
    FX16_CONST(0.01533920628498806), FX16_CONST(-0.9998823474542126),
    FX16_CONST(0.013805388528060632), FX16_CONST(-0.9999047010828528),
    FX16_CONST(0.012271538285720007), FX16_CONST(-0.9999247018391445),
    FX16_CONST(0.01073765916726441), FX16_CONST(-0.9999423496760239),
    FX16_CONST(0.00920375478206002), FX16_CONST(-0.9999576445519639),
    FX16_CONST(0.007669828739531138), FX16_CONST(-0.9999705864309741),
    FX16_CONST(0.006135884649154799), FX16_CONST(-0.9999811752826011),
    FX16_CONST(0.004601926120448733), FX16_CONST(-0.9999894110819284),
    FX16_CONST(0.003067956762965977), FX16_CONST(-0.9999952938095762),
    FX16_CONST(0.0015339801862850493), FX16_CONST(-0.9999988234517019),
    FX16_CONST(1.2246467991473532e-16), FX16_CONST(-1.0),
    FX16_CONST(-0.0015339801862848043), FX16_CONST(-0.9999988234517019),
    FX16_CONST(-0.0030679567629657324), FX16_CONST(-0.9999952938095762),
    FX16_CONST(-0.004601926120448488), FX16_CONST(-0.9999894110819284),
    FX16_CONST(-0.006135884649154554), FX16_CONST(-0.9999811752826011),
    FX16_CONST(-0.007669828739530893), FX16_CONST(-0.9999705864309741),
    FX16_CONST(-0.009203754782059776), FX16_CONST(-0.9999576445519639),
    FX16_CONST(-0.010737659167264166), FX16_CONST(-0.9999423496760239),
    FX16_CONST(-0.012271538285719762), FX16_CONST(-0.9999247018391445),
    FX16_CONST(-0.013805388528060387), FX16_CONST(-0.9999047010828529),
    FX16_CONST(-0.015339206284987816), FX16_CONST(-0.9998823474542126),
    FX16_CONST(-0.01687298794728159), FX16_CONST(-0.9998576410058239),
    FX16_CONST(-0.01840672990580486), FX16_CONST(-0.9998305817958234),
    FX16_CONST(-0.01994042855151419), FX16_CONST(-0.9998011698878843),
    FX16_CONST(-0.02147408027546942), FX16_CONST(-0.9997694053512153),
    FX16_CONST(-0.02300768146883945), FX16_CONST(-0.9997352882605617),
    FX16_CONST(-0.02454122852291208), FX16_CONST(-0.9996988186962042),
    FX16_CONST(-0.026074717829103856), FX16_CONST(-0.9996599967439592),
    FX16_CONST(-0.027608145778965414), FX16_CONST(-0.9996188224951786),
    FX16_CONST(-0.029141508764193556), FX16_CONST(-0.9995752960467492),
    FX16_CONST(-0.03067480317663662), FX16_CONST(-0.9995294175010931),
    FX16_CONST(-0.032208025408304294), FX16_CONST(-0.999481186966167),
    FX16_CONST(-0.033741171851377455), FX16_CONST(-0.9994306045554617),
    FX16_CONST(-0.03527423889821398), FX16_CONST(-0.9993776703880028),
    FX16_CONST(-0.03680722294135858), FX16_CONST(-0.9993223845883495),
    FX16_CONST(-0.03834012037355261), FX16_CONST(-0.9992647472865944),
    FX16_CONST(-0.03987292758773989), FX16_CONST(-0.9992047586183639),
    FX16_CONST(-0.04140564097707653), FX16_CONST(-0.9991424187248169),
    FX16_CONST(-0.04293825693494078), FX16_CONST(-0.9990777277526454),
    FX16_CONST(-0.044470771854938335), FX16_CONST(-0.9990106858540734),
    FX16_CONST(-0.046003182130914456), FX16_CONST(-0.9989412931868569),
    FX16_CONST(-0.047535484156959296), FX16_CONST(-0.9988695499142836),
    FX16_CONST(-0.049067674327417724), FX16_CONST(-0.9987954562051724),
    FX16_CONST(-0.05059974903689915), FX16_CONST(-0.9987190122338729),
    FX16_CONST(-0.05213170468028335), FX16_CONST(-0.9986402181802653),
    FX16_CONST(-0.05366353765273028), FX16_CONST(-0.9985590742297593),
    FX16_CONST(-0.05519524434968985), FX16_CONST(-0.9984755805732948),
    FX16_CONST(-0.05672682116690782), FX16_CONST(-0.9983897374073402),
    FX16_CONST(-0.05825826450043555), FX16_CONST(-0.9983015449338929),
    FX16_CONST(-0.05978957074663983), FX16_CONST(-0.9982110033604782),
    FX16_CONST(-0.061320736302208245), FX16_CONST(-0.9981181129001492),
    FX16_CONST(-0.06285175756416124), FX16_CONST(-0.9980228737714862),
    FX16_CONST(-0.06438263092985745), FX16_CONST(-0.997925286198596),
    FX16_CONST(-0.06591335279700353), FX16_CONST(-0.9978253504111116),
    FX16_CONST(-0.06744391956366393), FX16_CONST(-0.9977230666441916),
    FX16_CONST(-0.06897432762826677), FX16_CONST(-0.9976184351385196),
    FX16_CONST(-0.0705045733896136), FX16_CONST(-0.9975114561403035),
    FX16_CONST(-0.07203465324688924), FX16_CONST(-0.9974021299012753),
    FX16_CONST(-0.0735645635996675), FX16_CONST(-0.9972904566786902),
    FX16_CONST(-0.0750943008479211), FX16_CONST(-0.9971764367353262),
    FX16_CONST(-0.07662386139203144), FX16_CONST(-0.997060070339483),
    FX16_CONST(-0.0781532416327939), FX16_CONST(-0.9969413577649822),
    FX16_CONST(-0.07968243797142995), FX16_CONST(-0.9968202992911658),
    FX16_CONST(-0.08121144680959243), FX16_CONST(-0.9966968952028961),
    FX16_CONST(-0.0827402645493754), FX16_CONST(-0.9965711457905548),
    FX16_CONST(-0.08426888759332393), FX16_CONST(-0.9964430513500426),
    FX16_CONST(-0.08579731234443992), FX16_CONST(-0.996312612182778),
    FX16_CONST(-0.08732553520619181), FX16_CONST(-0.996179828595697),
    FX16_CONST(-0.0888535525825245), FX16_CONST(-0.996044700901252),
    FX16_CONST(-0.09038136087786505), FX16_CONST(-0.9959072294174117),
    FX16_CONST(-0.09190895649713252), FX16_CONST(-0.9957674144676598),
    FX16_CONST(-0.09343633584574773), FX16_CONST(-0.9956252563809943),
    FX16_CONST(-0.09496349532963866), FX16_CONST(-0.9954807554919269),
    FX16_CONST(-0.09649043135525241), FX16_CONST(-0.9953339121404823),
    FX16_CONST(-0.09801714032956059), FX16_CONST(-0.9951847266721969),
    FX16_CONST(-0.09954361866006904), FX16_CONST(-0.9950331994381186),
    FX16_CONST(-0.10106986275482768), FX16_CONST(-0.9948793307948056),
    FX16_CONST(-0.10259586902243631), FX16_CONST(-0.9947231211043257),
    FX16_CONST(-0.10412163387205432), FX16_CONST(-0.9945645707342555),
    FX16_CONST(-0.10564715371341052), FX16_CONST(-0.9944036800576791),
    FX16_CONST(-0.10717242495680891), FX16_CONST(-0.9942404494531879),
    FX16_CONST(-0.1086974440131385), FX16_CONST(-0.9940748793048795),
    FX16_CONST(-0.110222207293883), FX16_CONST(-0.9939069700023561),
    FX16_CONST(-0.11174671121112625), FX16_CONST(-0.9937367219407247),
    FX16_CONST(-0.11327095217756417), FX16_CONST(-0.9935641355205953),
    FX16_CONST(-0.11479492660651007), FX16_CONST(-0.9933892111480807),
    FX16_CONST(-0.11631863091190447), FX16_CONST(-0.9932119492347946),
    FX16_CONST(-0.11784206150832484), FX16_CONST(-0.9930323501978514),
    FX16_CONST(-0.11936521481099138), FX16_CONST(-0.9928504144598651),
    FX16_CONST(-0.12088808723577682), FX16_CONST(-0.992666142448948),
    FX16_CONST(-0.1224106751992161), FX16_CONST(-0.99247953459871),
    FX16_CONST(-0.12393297511851223), FX16_CONST(-0.9922905913482574),
    FX16_CONST(-0.125454983411546), FX16_CONST(-0.9920993131421918),
    FX16_CONST(-0.1269766964968858), FX16_CONST(-0.9919057004306093),
    FX16_CONST(-0.12849811079379284), FX16_CONST(-0.9917097536690995),
    FX16_CONST(-0.13001922272223318), FX16_CONST(-0.991511473318744),
    FX16_CONST(-0.1315400287028831), FX16_CONST(-0.9913108598461154),
    FX16_CONST(-0.13306052515713876), FX16_CONST(-0.9911079137232769),
    FX16_CONST(-0.13458070850712606), FX16_CONST(-0.99090263542778),
    FX16_CONST(-0.13610057517570623), FX16_CONST(-0.9906950254426646),
    FX16_CONST(-0.1376201215864858), FX16_CONST(-0.9904850842564571),
    FX16_CONST(-0.13913934416382612), FX16_CONST(-0.9902728123631691),
    FX16_CONST(-0.1406582393328493), FX16_CONST(-0.9900582102622971),
    FX16_CONST(-0.14217680351944784), FX16_CONST(-0.9898412784588205),
    FX16_CONST(-0.1436950331502944), FX16_CONST(-0.9896220174632009),
    FX16_CONST(-0.14521292465284713), FX16_CONST(-0.9894004277913804),
    FX16_CONST(-0.14673047445536158), FX16_CONST(-0.989176509964781),
    FX16_CONST(-0.14824767898689603), FX16_CONST(-0.988950264510303),
    FX16_CONST(-0.1497645346773212), FX16_CONST(-0.9887216919603238),
    FX16_CONST(-0.15128103795733008), FX16_CONST(-0.9884907928526967),
    FX16_CONST(-0.15279718525844344), FX16_CONST(-0.9882575677307495),
    FX16_CONST(-0.15431297301301983), FX16_CONST(-0.9880220171432836),
    FX16_CONST(-0.15582839765426512), FX16_CONST(-0.9877841416445722),
    FX16_CONST(-0.1573434556162383), FX16_CONST(-0.9875439417943592),
    FX16_CONST(-0.15885814333386122), FX16_CONST(-0.9873014181578584),
    FX16_CONST(-0.1603724572429282), FX16_CONST(-0.987056571305751),
    FX16_CONST(-0.1618863937801115), FX16_CONST(-0.9868094018141855),
    FX16_CONST(-0.16339994938297306), FX16_CONST(-0.9865599102647755),
    FX16_CONST(-0.1649131204899699), FX16_CONST(-0.9863080972445987),
    FX16_CONST(-0.16642590354046383), FX16_CONST(-0.9860539633461954),
    FX16_CONST(-0.16793829497473103), FX16_CONST(-0.9857975091675675),
    FX16_CONST(-0.169450291233968), FX16_CONST(-0.9855387353121761),
    FX16_CONST(-0.17096188876030097), FX16_CONST(-0.9852776423889413),
    FX16_CONST(-0.17247308399679587), FX16_CONST(-0.9850142310122398),
    FX16_CONST(-0.17398387338746388), FX16_CONST(-0.9847485018019042),
    FX16_CONST(-0.1754942533772712), FX16_CONST(-0.9844804553832209),
    FX16_CONST(-0.1770042204121487), FX16_CONST(-0.9842100923869291),
    FX16_CONST(-0.17851377093899717), FX16_CONST(-0.9839374134492189),
    FX16_CONST(-0.18002290140569935), FX16_CONST(-0.9836624192117303),
    FX16_CONST(-0.18153160826112497), FX16_CONST(-0.9833851103215512),
    FX16_CONST(-0.18303988795514065), FX16_CONST(-0.9831054874312164),
    FX16_CONST(-0.18454773693861948), FX16_CONST(-0.9828235511987053),
    FX16_CONST(-0.18605515166344666), FX16_CONST(-0.9825393022874412),
    FX16_CONST(-0.18756212858252932), FX16_CONST(-0.9822527413662895),
    FX16_CONST(-0.1890686641498061), FX16_CONST(-0.9819638691095552),
    FX16_CONST(-0.19057475482025282), FX16_CONST(-0.9816726861969831),
    FX16_CONST(-0.19208039704989222), FX16_CONST(-0.9813791933137547),
    FX16_CONST(-0.19358558729580355), FX16_CONST(-0.9810833911504867),
    FX16_CONST(-0.19509032201612836), FX16_CONST(-0.9807852804032304),
    FX16_CONST(-0.19659459767008003), FX16_CONST(-0.9804848617734694),
    FX16_CONST(-0.19809841071795356), FX16_CONST(-0.9801821359681174),
    FX16_CONST(-0.19960175762113067), FX16_CONST(-0.9798771036995177),
    FX16_CONST(-0.20110463484209176), FX16_CONST(-0.9795697656854405),
    FX16_CONST(-0.20260703884442113), FX16_CONST(-0.979260122649082),
    FX16_CONST(-0.20410896609281662), FX16_CONST(-0.9789481753190622),
    FX16_CONST(-0.20561041305309916), FX16_CONST(-0.9786339244294232),
    FX16_CONST(-0.2071113761922186), FX16_CONST(-0.9783173707196277),
    FX16_CONST(-0.20861185197826326), FX16_CONST(-0.9779985149345571),
    FX16_CONST(-0.21011183688046955), FX16_CONST(-0.97767735782451),
    FX16_CONST(-0.21161132736922766), FX16_CONST(-0.9773539001452),
    FX16_CONST(-0.2131103199160912), FX16_CONST(-0.9770281426577544),
    FX16_CONST(-0.21460881099378673), FX16_CONST(-0.9767000861287118),
    FX16_CONST(-0.21610679707621921), FX16_CONST(-0.9763697313300213),
    FX16_CONST(-0.21760427463848347), FX16_CONST(-0.9760370790390391),
    FX16_CONST(-0.2191012401568698), FX16_CONST(-0.9757021300385286),
    FX16_CONST(-0.22059769010887326), FX16_CONST(-0.975364885116657),
    FX16_CONST(-0.22209362097320343), FX16_CONST(-0.9750253450669941),
    FX16_CONST(-0.22358902922979004), FX16_CONST(-0.9746835106885107),
    FX16_CONST(-0.2250839113597926), FX16_CONST(-0.9743393827855759),
    FX16_CONST(-0.22657826384560992), FX16_CONST(-0.973992962167956),
    FX16_CONST(-0.22807208317088581), FX16_CONST(-0.9736442496508119),
    FX16_CONST(-0.2295653658205187), FX16_CONST(-0.9732932460546982),
    FX16_CONST(-0.23105810828067108), FX16_CONST(-0.9729399522055602),
    FX16_CONST(-0.23255030703877494), FX16_CONST(-0.9725843689347323),
    FX16_CONST(-0.23404195858354326), FX16_CONST(-0.9722264970789364),
    FX16_CONST(-0.23553305940497551), FX16_CONST(-0.9718663374802794),
    FX16_CONST(-0.23702360599436695), FX16_CONST(-0.9715038909862519),
    FX16_CONST(-0.2385135948443183), FX16_CONST(-0.9711391584497252),
    FX16_CONST(-0.24000302244874153), FX16_CONST(-0.9707721407289502),
    FX16_CONST(-0.2414918853028691), FX16_CONST(-0.9704028386875555),
    FX16_CONST(-0.24298017990326382), FX16_CONST(-0.970031253194544),
    FX16_CONST(-0.24446790274782426), FX16_CONST(-0.9696573851242924),
    FX16_CONST(-0.24595505033579443), FX16_CONST(-0.9692812353565485),
    FX16_CONST(-0.24744161916777327), FX16_CONST(-0.9689028047764289),
    FX16_CONST(-0.24892760574571987), FX16_CONST(-0.9685220942744174),
    FX16_CONST(-0.2504130065729651), FX16_CONST(-0.9681391047463624),
    FX16_CONST(-0.25189781815421697), FX16_CONST(-0.9677538370934755),
    FX16_CONST(-0.2533820369955699), FX16_CONST(-0.9673662922223286),
    FX16_CONST(-0.25486565960451446), FX16_CONST(-0.9669764710448522),
    FX16_CONST(-0.2563486824899429), FX16_CONST(-0.9665843744783331),
    FX16_CONST(-0.25783110216215877), FX16_CONST(-0.9661900034454126),
    FX16_CONST(-0.2593129151328862), FX16_CONST(-0.9657933588740837),
    FX16_CONST(-0.2607941179152756), FX16_CONST(-0.9653944416976894),
    FX16_CONST(-0.2622747070239134), FX16_CONST(-0.9649932528549204),
    FX16_CONST(-0.26375467897483135), FX16_CONST(-0.9645897932898128),
    FX16_CONST(-0.2652340302855115), FX16_CONST(-0.9641840639517458),
    FX16_CONST(-0.26671275747489825), FX16_CONST(-0.96377606579544),
    FX16_CONST(-0.2681908570634032), FX16_CONST(-0.963365799780954),
    FX16_CONST(-0.2696683255729148), FX16_CONST(-0.962953266873684),
    FX16_CONST(-0.2711451595268079), FX16_CONST(-0.9625384680443592),
    FX16_CONST(-0.27262135544994903), FX16_CONST(-0.9621214042690416),
    FX16_CONST(-0.27409690986870616), FX16_CONST(-0.9617020765291227),
    FX16_CONST(-0.2755718193109581), FX16_CONST(-0.9612804858113206),
    FX16_CONST(-0.2770460803061), FX16_CONST(-0.9608566331076795),
    FX16_CONST(-0.2785196893850529), FX16_CONST(-0.9604305194155659),
    FX16_CONST(-0.2799926430802732), FX16_CONST(-0.960002145737666),
    FX16_CONST(-0.28146493792575766), FX16_CONST(-0.9595715130819846),
    FX16_CONST(-0.28293657045705517), FX16_CONST(-0.959138622461842),
    FX16_CONST(-0.2844075372112718), FX16_CONST(-0.9587034748958716),
    FX16_CONST(-0.28587783472708034), FX16_CONST(-0.9582660714080178),
    FX16_CONST(-0.2873474595447294), FX16_CONST(-0.9578264130275329),
    FX16_CONST(-0.28881640820604954), FX16_CONST(-0.9573845007889759),
    FX16_CONST(-0.2902846772544621), FX16_CONST(-0.9569403357322089),
    FX16_CONST(-0.2917522632349892), FX16_CONST(-0.9564939189023951),
    FX16_CONST(-0.29321916269425874), FX16_CONST(-0.9560452513499964),
    FX16_CONST(-0.29468537218051416), FX16_CONST(-0.9555943341307711),
    FX16_CONST(-0.2961508882436238), FX16_CONST(-0.9551411683057708),
    FX16_CONST(-0.2976157074350859), FX16_CONST(-0.9546857549413384),
    FX16_CONST(-0.2990798263080403), FX16_CONST(-0.9542280951091057),
    FX16_CONST(-0.30054324141727345), FX16_CONST(-0.9537681898859903),
    FX16_CONST(-0.3020059493192278), FX16_CONST(-0.953306040354194),
    FX16_CONST(-0.3034679465720112), FX16_CONST(-0.9528416476011987),
    FX16_CONST(-0.30492922973540243), FX16_CONST(-0.9523750127197659),
    FX16_CONST(-0.3063897953708607), FX16_CONST(-0.9519061368079323),
    FX16_CONST(-0.3078496400415348), FX16_CONST(-0.9514350209690083),
    FX16_CONST(-0.3093087603122688), FX16_CONST(-0.9509616663115751),
    FX16_CONST(-0.3107671527496113), FX16_CONST(-0.9504860739494818),
    FX16_CONST(-0.3122248139218249), FX16_CONST(-0.950008245001843),
    FX16_CONST(-0.3136817403988912), FX16_CONST(-0.9495281805930368),
    FX16_CONST(-0.3151379287525222), FX16_CONST(-0.9490458818527007),
    FX16_CONST(-0.31659337555616585), FX16_CONST(-0.9485613499157303),
    FX16_CONST(-0.31804807738501467), FX16_CONST(-0.9480745859222763),
    FX16_CONST(-0.3195020308160156), FX16_CONST(-0.9475855910177412),
    FX16_CONST(-0.32095523242787527), FX16_CONST(-0.9470943663527772),
    FX16_CONST(-0.32240767880106963), FX16_CONST(-0.9466009130832836),
    FX16_CONST(-0.3238593665178528), FX16_CONST(-0.9461052323704034),
    FX16_CONST(-0.325310292162263), FX16_CONST(-0.9456073253805213),
    FX16_CONST(-0.32676045232013157), FX16_CONST(-0.9451071932852606),
    FX16_CONST(-0.3282098435790925), FX16_CONST(-0.9446048372614803),
    FX16_CONST(-0.3296584625285872), FX16_CONST(-0.9441002584912728),
    FX16_CONST(-0.33110630575987626), FX16_CONST(-0.9435934581619604),
    FX16_CONST(-0.3325533698660442), FX16_CONST(-0.9430844374660935),
    FX16_CONST(-0.3339996514420091), FX16_CONST(-0.942573197601447),
    FX16_CONST(-0.3354451470845315), FX16_CONST(-0.9420597397710174),
    FX16_CONST(-0.3368898533922201), FX16_CONST(-0.9415440651830208),
    FX16_CONST(-0.3383337669655409), FX16_CONST(-0.9410261750508894),
    FX16_CONST(-0.3397768844068268), FX16_CONST(-0.9405060705932684),
    FX16_CONST(-0.34121920232028247), FX16_CONST(-0.9399837530340139),
    FX16_CONST(-0.3426607173119942), FX16_CONST(-0.93945922360219),
    FX16_CONST(-0.3441014259899388), FX16_CONST(-0.9389324835320646),
    FX16_CONST(-0.34554132496398876), FX16_CONST(-0.9384035340631083),
    FX16_CONST(-0.3469804108459235), FX16_CONST(-0.9378723764399899),
    FX16_CONST(-0.34841868024943456), FX16_CONST(-0.937339011912575),
    FX16_CONST(-0.34985612979013464), FX16_CONST(-0.9368034417359217),
    FX16_CONST(-0.351292756085567), FX16_CONST(-0.9362656671702783),
    FX16_CONST(-0.3527285557552107), FX16_CONST(-0.9357256894810804),
    FX16_CONST(-0.3541635254204901), FX16_CONST(-0.9351835099389477),
    FX16_CONST(-0.3555976617047838), FX16_CONST(-0.9346391298196808),
    FX16_CONST(-0.3570309612334301), FX16_CONST(-0.9340925504042589),
    FX16_CONST(-0.3584634206337364), FX16_CONST(-0.9335437729788363),
    FX16_CONST(-0.3598950365349881), FX16_CONST(-0.932992798834739),
    FX16_CONST(-0.36132580556845395), FX16_CONST(-0.9324396292684625),
    FX16_CONST(-0.36275572436739706), FX16_CONST(-0.9318842655816681),
    FX16_CONST(-0.3641847895670799), FX16_CONST(-0.9313267090811804),
    FX16_CONST(-0.3656129978047736), FX16_CONST(-0.9307669610789838),
    FX16_CONST(-0.36704034571976707), FX16_CONST(-0.9302050228922191),
    FX16_CONST(-0.3684668299533724), FX16_CONST(-0.9296408958431812),
    FX16_CONST(-0.3698924471489339), FX16_CONST(-0.9290745812593159),
    FX16_CONST(-0.37131719395183743), FX16_CONST(-0.9285060804732156),
    FX16_CONST(-0.37274106700951587), FX16_CONST(-0.9279353948226178),
    FX16_CONST(-0.3741640629714578), FX16_CONST(-0.9273625256504011),
    FX16_CONST(-0.37558617848921716), FX16_CONST(-0.9267874743045819),
    FX16_CONST(-0.3770074102164179), FX16_CONST(-0.9262102421383115),
    FX16_CONST(-0.3784277548087654), FX16_CONST(-0.9256308305098728),
    FX16_CONST(-0.37984720892405116), FX16_CONST(-0.9250492407826776),
    FX16_CONST(-0.3812657692221621), FX16_CONST(-0.9244654743252627),
    FX16_CONST(-0.38268343236508967), FX16_CONST(-0.9238795325112868),
    FX16_CONST(-0.3841001950169351), FX16_CONST(-0.9232914167195276),
    FX16_CONST(-0.3855160538439186), FX16_CONST(-0.9227011283338786),
    FX16_CONST(-0.3869310055143885), FX16_CONST(-0.9221086687433452),
    FX16_CONST(-0.38834504669882636), FX16_CONST(-0.9215140393420419),
    FX16_CONST(-0.38975817406985624), FX16_CONST(-0.9209172415291895),
    FX16_CONST(-0.3911703843022538), FX16_CONST(-0.9203182767091106),
    FX16_CONST(-0.3925816740729512), FX16_CONST(-0.9197171462912275),
    FX16_CONST(-0.39399204006104793), FX16_CONST(-0.9191138516900578),
    FX16_CONST(-0.3954014789478163), FX16_CONST(-0.9185083943252123),
    FX16_CONST(-0.39680998741671003), FX16_CONST(-0.9179007756213906),
    FX16_CONST(-0.39821756215337345), FX16_CONST(-0.917290997008378),
    FX16_CONST(-0.39962419984564684), FX16_CONST(-0.9166790599210427),
    FX16_CONST(-0.4010298971835754), FX16_CONST(-0.9160649657993318),
    FX16_CONST(-0.4024346508594184), FX16_CONST(-0.9154487160882678),
    FX16_CONST(-0.4038384575676542), FX16_CONST(-0.9148303122379461),
    FX16_CONST(-0.4052413140049897), FX16_CONST(-0.9142097557035307),
    FX16_CONST(-0.406643216870369), FX16_CONST(-0.9135870479452508),
    FX16_CONST(-0.40804416286497835), FX16_CONST(-0.9129621904283983),
    FX16_CONST(-0.4094441486922574), FX16_CONST(-0.9123351846233229),
    FX16_CONST(-0.4108431710579039), FX16_CONST(-0.9117060320054299),
    FX16_CONST(-0.4122412266698826), FX16_CONST(-0.9110747340551765),
    FX16_CONST(-0.4136383122384344), FX16_CONST(-0.9104412922580672),
    FX16_CONST(-0.41503442447608163), FX16_CONST(-0.9098057081046522),
    FX16_CONST(-0.41642956009763693), FX16_CONST(-0.9091679830905225),
    FX16_CONST(-0.4178237158202122), FX16_CONST(-0.9085281187163061),
    FX16_CONST(-0.419216888363224), FX16_CONST(-0.9078861164876662),
    FX16_CONST(-0.42060907444840234), FX16_CONST(-0.9072419779152959),
    FX16_CONST(-0.4220002707997996), FX16_CONST(-0.9065957045149154),
    FX16_CONST(-0.4233904741437957), FX16_CONST(-0.9059472978072686),
    FX16_CONST(-0.42477968120910864), FX16_CONST(-0.9052967593181188),
    FX16_CONST(-0.4261678887267996), FX16_CONST(-0.9046440905782462),
    FX16_CONST(-0.4275550934302818), FX16_CONST(-0.9039892931234434),
    FX16_CONST(-0.4289412920553294), FX16_CONST(-0.9033323684945119),
    FX16_CONST(-0.43032648134008267), FX16_CONST(-0.9026733182372588),
    FX16_CONST(-0.43171065802505704), FX16_CONST(-0.9020121439024933),
    FX16_CONST(-0.43309381885315185), FX16_CONST(-0.901348847046022),
    FX16_CONST(-0.43447596056965576), FX16_CONST(-0.9006834292286469),
    FX16_CONST(-0.4358570799222553), FX16_CONST(-0.9000158920161603),
    FX16_CONST(-0.43723717366104403), FX16_CONST(-0.8993462369793416),
    FX16_CONST(-0.4386162385385273), FX16_CONST(-0.898674465693954),
    FX16_CONST(-0.4399942713096331), FX16_CONST(-0.8980005797407399),
    FX16_CONST(-0.44137126873171667), FX16_CONST(-0.8973245807054183),
    FX16_CONST(-0.44274722756456975), FX16_CONST(-0.8966464701786804),
    FX16_CONST(-0.4441221445704291), FX16_CONST(-0.8959662497561852),
    FX16_CONST(-0.44549601651398174), FX16_CONST(-0.8952839210385575),
    FX16_CONST(-0.44686884016237394), FX16_CONST(-0.8945994856313828),
    FX16_CONST(-0.44824061228521983), FX16_CONST(-0.8939129451452033),
    FX16_CONST(-0.44961132965460665), FX16_CONST(-0.8932243011955153),
    FX16_CONST(-0.45098098904510364), FX16_CONST(-0.8925335554027647),
    FX16_CONST(-0.45234958723377083), FX16_CONST(-0.8918407093923427),
    FX16_CONST(-0.45371712100016354), FX16_CONST(-0.8911457647945834),
    FX16_CONST(-0.45508358712634367), FX16_CONST(-0.890448723244758),
    FX16_CONST(-0.4564489823968839), FX16_CONST(-0.8897495863830728),
    FX16_CONST(-0.45781330359887695), FX16_CONST(-0.8890483558546647),
    FX16_CONST(-0.459176547521944), FX16_CONST(-0.8883450333095964),
    FX16_CONST(-0.46053871095824006), FX16_CONST(-0.8876396204028539),
    FX16_CONST(-0.4618997907024625), FX16_CONST(-0.8869321187943423),
    FX16_CONST(-0.4632597835518601), FX16_CONST(-0.8862225301488806),
    FX16_CONST(-0.46461868630623787), FX16_CONST(-0.8855108561362),
    FX16_CONST(-0.46597649576796596), FX16_CONST(-0.8847970984309379),
    FX16_CONST(-0.46733320874198836), FX16_CONST(-0.884081258712635),
    FX16_CONST(-0.4686888220358276), FX16_CONST(-0.8833633386657318),
    FX16_CONST(-0.47004333245959545), FX16_CONST(-0.8826433399795629),
    FX16_CONST(-0.47139673682599764), FX16_CONST(-0.881921264348355),
    FX16_CONST(-0.4727490319503425), FX16_CONST(-0.8811971134712222),
    FX16_CONST(-0.47410021465054986), FX16_CONST(-0.8804708890521609),
    FX16_CONST(-0.47545028174715587), FX16_CONST(-0.8797425928000474),
    FX16_CONST(-0.47679923006332187), FX16_CONST(-0.8790122264286336),
    FX16_CONST(-0.47814705642484295), FX16_CONST(-0.8782797916565416),
    FX16_CONST(-0.47949375766015306), FX16_CONST(-0.8775452902072612),
    FX16_CONST(-0.48083933060033374), FX16_CONST(-0.8768087238091458),
    FX16_CONST(-0.48218377207912266), FX16_CONST(-0.8760700941954066),
    FX16_CONST(-0.4835270789329184), FX16_CONST(-0.875329403104111),
    FX16_CONST(-0.48486924800079095), FX16_CONST(-0.8745866522781762),
    FX16_CONST(-0.48621027612448636), FX16_CONST(-0.8738418434653669),
    FX16_CONST(-0.48755016014843566), FX16_CONST(-0.8730949784182902),
    FX16_CONST(-0.48888889691976306), FX16_CONST(-0.8723460588943915),
    FX16_CONST(-0.49022648328829116), FX16_CONST(-0.8715950866559511),
    FX16_CONST(-0.4915629161065497), FX16_CONST(-0.8708420634700791),
    FX16_CONST(-0.4928981922297839), FX16_CONST(-0.8700869911087115),
    FX16_CONST(-0.4942323085159598), FX16_CONST(-0.8693298713486067),
    FX16_CONST(-0.4955652618257723), FX16_CONST(-0.868570705971341),
    FX16_CONST(-0.49689704902265447), FX16_CONST(-0.8678094967633033),
    FX16_CONST(-0.49822766697278154), FX16_CONST(-0.8670462455156929),
    FX16_CONST(-0.4995571125450817), FX16_CONST(-0.8662809540245131),
    FX16_CONST(-0.5008853826112407), FX16_CONST(-0.8655136240905691),
    FX16_CONST(-0.5022124740457106), FX16_CONST(-0.8647442575194625),
    FX16_CONST(-0.5035383837257175), FX16_CONST(-0.8639728561215868),
    FX16_CONST(-0.5048631085312676), FX16_CONST(-0.8631994217121242),
    FX16_CONST(-0.506186645345155), FX16_CONST(-0.8624239561110407),
    FX16_CONST(-0.5075089910529708), FX16_CONST(-0.8616464611430814),
    FX16_CONST(-0.5088301425431071), FX16_CONST(-0.8608669386377673),
    FX16_CONST(-0.5101500967067666), FX16_CONST(-0.8600853904293903),
    FX16_CONST(-0.5114688504379703), FX16_CONST(-0.8593018183570085),
    FX16_CONST(-0.5127864006335627), FX16_CONST(-0.858516224264443),
    FX16_CONST(-0.5141027441932216), FX16_CONST(-0.8577286100002721),
    FX16_CONST(-0.5154178780194629), FX16_CONST(-0.8569389774178288),
    FX16_CONST(-0.5167317990176497), FX16_CONST(-0.8561473283751947),
    FX16_CONST(-0.5180445040959992), FX16_CONST(-0.8553536647351961),
    FX16_CONST(-0.5193559901655895), FX16_CONST(-0.8545579883654005),
    FX16_CONST(-0.5206662541403669), FX16_CONST(-0.8537603011381115),
    FX16_CONST(-0.5219752929371543), FX16_CONST(-0.8529606049303637),
    FX16_CONST(-0.5232831034756564), FX16_CONST(-0.8521589016239198),
    FX16_CONST(-0.5245896826784687), FX16_CONST(-0.8513551931052653),
    FX16_CONST(-0.5258950274710846), FX16_CONST(-0.8505494812656035),
    FX16_CONST(-0.5271991347819011), FX16_CONST(-0.8497417680008527),
    FX16_CONST(-0.5285020015422283), FX16_CONST(-0.8489320552116397),
    FX16_CONST(-0.5298036246862946), FX16_CONST(-0.8481203448032972),
    FX16_CONST(-0.5311040011512547), FX16_CONST(-0.8473066386858585),
    FX16_CONST(-0.5324031278771978), FX16_CONST(-0.8464909387740521),
    FX16_CONST(-0.533701001807153), FX16_CONST(-0.8456732469872991),
    FX16_CONST(-0.5349976198870969), FX16_CONST(-0.8448535652497072),
    FX16_CONST(-0.5362929790659631), FX16_CONST(-0.8440318954900665),
    FX16_CONST(-0.5375870762956455), FX16_CONST(-0.8432082396418454),
    FX16_CONST(-0.5388799085310082), FX16_CONST(-0.842382599643186),
    FX16_CONST(-0.5401714727298929), FX16_CONST(-0.8415549774368984),
    FX16_CONST(-0.5414617658531232), FX16_CONST(-0.8407253749704582),
    FX16_CONST(-0.5427507848645158), FX16_CONST(-0.8398937941959996),
    FX16_CONST(-0.5440385267308838), FX16_CONST(-0.8390602370703127),
    FX16_CONST(-0.5453249884220461), FX16_CONST(-0.8382247055548382),
    FX16_CONST(-0.5466101669108347), FX16_CONST(-0.837387201615662),
    FX16_CONST(-0.5478940591731002), FX16_CONST(-0.836547727223512),
    FX16_CONST(-0.5491766621877194), FX16_CONST(-0.8357062843537527),
    FX16_CONST(-0.5504579729366047), FX16_CONST(-0.8348628749863801),
    FX16_CONST(-0.5517379884047074), FX16_CONST(-0.8340175011060181),
    FX16_CONST(-0.5530167055800274), FX16_CONST(-0.8331701647019133),
    FX16_CONST(-0.55429412145362), FX16_CONST(-0.8323208677679297),
    FX16_CONST(-0.555570233019602), FX16_CONST(-0.8314696123025455),
    FX16_CONST(-0.5568450372751599), FX16_CONST(-0.8306164003088464),
    FX16_CONST(-0.5581185312205561), FX16_CONST(-0.829761233794523),
    FX16_CONST(-0.5593907118591358), FX16_CONST(-0.8289041147718651),
    FX16_CONST(-0.5606615761973359), FX16_CONST(-0.8280450452577559),
    FX16_CONST(-0.5619311212446894), FX16_CONST(-0.8271840272736691),
    FX16_CONST(-0.5631993440138339), FX16_CONST(-0.8263210628456636),
    FX16_CONST(-0.5644662415205194), FX16_CONST(-0.8254561540043776),
    FX16_CONST(-0.5657318107836132), FX16_CONST(-0.8245893027850253),
    FX16_CONST(-0.5669960488251085), FX16_CONST(-0.8237205112273915),
    FX16_CONST(-0.5682589526701315), FX16_CONST(-0.8228497813758264),
    FX16_CONST(-0.5695205193469473), FX16_CONST(-0.8219771152792416),
    FX16_CONST(-0.5707807458869671), FX16_CONST(-0.8211025149911048),
    FX16_CONST(-0.572039629324757), FX16_CONST(-0.8202259825694347),
    FX16_CONST(-0.573297166698042), FX16_CONST(-0.8193475200767971),
    FX16_CONST(-0.5745533550477157), FX16_CONST(-0.8184671295802988),
    FX16_CONST(-0.5758081914178453), FX16_CONST(-0.8175848131515837),
    FX16_CONST(-0.5770616728556793), FX16_CONST(-0.816700572866828),
    FX16_CONST(-0.5783137964116555), FX16_CONST(-0.8158144108067339),
    FX16_CONST(-0.5795645591394057), FX16_CONST(-0.8149263290565266),
    FX16_CONST(-0.5808139580957643), FX16_CONST(-0.8140363297059485),
    FX16_CONST(-0.5820619903407754), FX16_CONST(-0.8131444148492536),
    FX16_CONST(-0.5833086529376983), FX16_CONST(-0.8122505865852039),
    FX16_CONST(-0.5845539429530151), FX16_CONST(-0.8113548470170638),
    FX16_CONST(-0.5857978574564389), FX16_CONST(-0.8104571982525949),
    FX16_CONST(-0.5870403935209177), FX16_CONST(-0.8095576424040515),
    FX16_CONST(-0.5882815482226451), FX16_CONST(-0.8086561815881751),
    FX16_CONST(-0.5895213186410639), FX16_CONST(-0.8077528179261904),
    FX16_CONST(-0.5907597018588739), FX16_CONST(-0.8068475535437994),
    FX16_CONST(-0.5919966949620409), FX16_CONST(-0.8059403905711764),
    FX16_CONST(-0.5932322950397998), FX16_CONST(-0.8050313311429635),
    FX16_CONST(-0.5944664991846642), FX16_CONST(-0.8041203773982659),
    FX16_CONST(-0.5956993044924332), FX16_CONST(-0.8032075314806449),
    FX16_CONST(-0.5969307080621965), FX16_CONST(-0.8022927955381157),
    FX16_CONST(-0.5981607069963422), FX16_CONST(-0.8013761717231404),
    FX16_CONST(-0.5993892984005645), FX16_CONST(-0.8004576621926228),
    FX16_CONST(-0.6006164793838686), FX16_CONST(-0.7995372691079052),
    FX16_CONST(-0.6018422470585799), FX16_CONST(-0.7986149946347609),
    FX16_CONST(-0.6030665985403482), FX16_CONST(-0.7976908409433912),
    FX16_CONST(-0.6042895309481559), FX16_CONST(-0.7967648102084189),
    FX16_CONST(-0.6055110414043254), FX16_CONST(-0.7958369046088836),
    FX16_CONST(-0.6067311270345245), FX16_CONST(-0.794907126328237),
    FX16_CONST(-0.6079497849677735), FX16_CONST(-0.7939754775543373),
    FX16_CONST(-0.6091670123364531), FX16_CONST(-0.7930419604794438),
    FX16_CONST(-0.6103828062763095), FX16_CONST(-0.7921065773002123),
    FX16_CONST(-0.6115971639264618), FX16_CONST(-0.7911693302176903),
    FX16_CONST(-0.6128100824294097), FX16_CONST(-0.79023022143731),
    FX16_CONST(-0.6140215589310382), FX16_CONST(-0.7892892531688859),
    FX16_CONST(-0.6152315905806267), FX16_CONST(-0.7883464276266063),
    FX16_CONST(-0.6164401745308536), FX16_CONST(-0.7874017470290314),
    FX16_CONST(-0.6176473079378038), FX16_CONST(-0.7864552135990859),
    FX16_CONST(-0.6188529879609762), FX16_CONST(-0.785506829564054),
    FX16_CONST(-0.6200572117632892), FX16_CONST(-0.7845565971555752),
    FX16_CONST(-0.6212599765110874), FX16_CONST(-0.7836045186096384),
    FX16_CONST(-0.6224612793741499), FX16_CONST(-0.7826505961665758),
    FX16_CONST(-0.6236611175256946), FX16_CONST(-0.7816948320710594),
    FX16_CONST(-0.6248594881423862), FX16_CONST(-0.7807372285720946),
    FX16_CONST(-0.6260563884043435), FX16_CONST(-0.7797777879230146),
    FX16_CONST(-0.6272518154951439), FX16_CONST(-0.7788165123814762),
    FX16_CONST(-0.6284457666018326), FX16_CONST(-0.7778534042094533),
    FX16_CONST(-0.629638238914927), FX16_CONST(-0.7768884656732324),
    FX16_CONST(-0.6308292296284242), FX16_CONST(-0.7759216990434078),
    FX16_CONST(-0.632018735939809), FX16_CONST(-0.7749531065948739),
    FX16_CONST(-0.6332067550500573), FX16_CONST(-0.7739826906068228),
    FX16_CONST(-0.6343932841636453), FX16_CONST(-0.7730104533627371),
    FX16_CONST(-0.6355783204885561), FX16_CONST(-0.7720363971503845),
    FX16_CONST(-0.6367618612362843), FX16_CONST(-0.7710605242618137),
    FX16_CONST(-0.6379439036218439), FX16_CONST(-0.7700828369933481),
    FX16_CONST(-0.6391244448637757), FX16_CONST(-0.7691033376455797),
    FX16_CONST(-0.6403034821841515), FX16_CONST(-0.7681220285233656),
    FX16_CONST(-0.641481012808583), FX16_CONST(-0.7671389119358205),
    FX16_CONST(-0.6426570339662269), FX16_CONST(-0.7661539901963129),
    FX16_CONST(-0.6438315428897913), FX16_CONST(-0.7651672656224591),
    FX16_CONST(-0.6450045368155438), FX16_CONST(-0.7641787405361168),
    FX16_CONST(-0.6461760129833164), FX16_CONST(-0.7631884172633813),
    FX16_CONST(-0.6473459686365118), FX16_CONST(-0.7621962981345791),
    FX16_CONST(-0.6485144010221123), FX16_CONST(-0.7612023854842619),
    FX16_CONST(-0.6496813073906832), FX16_CONST(-0.7602066816512024),
    FX16_CONST(-0.6508466849963808), FX16_CONST(-0.7592091889783882),
    FX16_CONST(-0.6520105310969595), FX16_CONST(-0.7582099098130154),
    FX16_CONST(-0.6531728429537765), FX16_CONST(-0.7572088465064848),
    FX16_CONST(-0.6543336178318003), FX16_CONST(-0.7562060014143946),
    FX16_CONST(-0.6554928529996153), FX16_CONST(-0.7552013768965365),
    FX16_CONST(-0.6566505457294288), FX16_CONST(-0.7541949753168894),
    FX16_CONST(-0.6578066932970785), FX16_CONST(-0.7531867990436125),
    FX16_CONST(-0.6589612929820373), FX16_CONST(-0.7521768504490427),
    FX16_CONST(-0.6601143420674203), FX16_CONST(-0.7511651319096866),
    FX16_CONST(-0.6612658378399922), FX16_CONST(-0.7501516458062151),
    FX16_CONST(-0.6624157775901718), FX16_CONST(-0.7491363945234593),
    FX16_CONST(-0.6635641586120397), FX16_CONST(-0.7481193804504037),
    FX16_CONST(-0.6647109782033448), FX16_CONST(-0.7471006059801802),
    FX16_CONST(-0.6658562336655094), FX16_CONST(-0.746080073510064),
    FX16_CONST(-0.6669999223036374), FX16_CONST(-0.7450577854414661),
    FX16_CONST(-0.6681420414265185), FX16_CONST(-0.7440337441799293),
    FX16_CONST(-0.6692825883466358), FX16_CONST(-0.7430079521351219),
    FX16_CONST(-0.670421560380173), FX16_CONST(-0.7419804117208311),
    FX16_CONST(-0.6715589548470184), FX16_CONST(-0.7409511253549591),
    FX16_CONST(-0.6726947690707727), FX16_CONST(-0.7399200954595163),
    FX16_CONST(-0.6738290003787559), FX16_CONST(-0.7388873244606152),
    FX16_CONST(-0.674961646102012), FX16_CONST(-0.737852814788466),
    FX16_CONST(-0.6760927035753158), FX16_CONST(-0.73681656887737),
    FX16_CONST(-0.6772221701371803), FX16_CONST(-0.7357785891657136),
    FX16_CONST(-0.6783500431298612), FX16_CONST(-0.7347388780959637),
    FX16_CONST(-0.6794763198993649), FX16_CONST(-0.7336974381146604),
    FX16_CONST(-0.680600997795453), FX16_CONST(-0.7326542716724128),
    FX16_CONST(-0.6817240741716496), FX16_CONST(-0.7316093812238927),
    FX16_CONST(-0.682845546385248), FX16_CONST(-0.7305627692278277),
    FX16_CONST(-0.6839654117973154), FX16_CONST(-0.729514438146997),
    FX16_CONST(-0.6850836677727001), FX16_CONST(-0.7284643904482254),
    FX16_CONST(-0.6862003116800385), FX16_CONST(-0.7274126286023759),
    FX16_CONST(-0.6873153408917592), FX16_CONST(-0.7263591550843459),
    FX16_CONST(-0.6884287527840903), FX16_CONST(-0.7253039723730609),
    FX16_CONST(-0.6895405447370668), FX16_CONST(-0.724247082951467),
    FX16_CONST(-0.6906507141345344), FX16_CONST(-0.7231884893065277),
    FX16_CONST(-0.6917592583641576), FX16_CONST(-0.7221281939292155),
    FX16_CONST(-0.6928661748174246), FX16_CONST(-0.7210661993145081),
    FX16_CONST(-0.6939714608896538), FX16_CONST(-0.7200025079613819),
    FX16_CONST(-0.6950751139800008), FX16_CONST(-0.7189371223728045),
    FX16_CONST(-0.696177131491463), FX16_CONST(-0.7178700450557317),
    FX16_CONST(-0.6972775108308864), FX16_CONST(-0.7168012785210996),
    FX16_CONST(-0.6983762494089728), FX16_CONST(-0.7157308252838187),
    FX16_CONST(-0.6994733446402839), FX16_CONST(-0.714658687862769),
    FX16_CONST(-0.7005687939432482), FX16_CONST(-0.7135848687807937),
    FX16_CONST(-0.7016625947401685), FX16_CONST(-0.7125093705646924),
    FX16_CONST(-0.7027547444572251), FX16_CONST(-0.7114321957452167),
    FX16_CONST(-0.7038452405244848), FX16_CONST(-0.7103533468570625),
    FX16_CONST(-0.7049340803759049), FX16_CONST(-0.7092728264388657),
    FX16_CONST(-0.7060212614493395), FX16_CONST(-0.7081906370331955),
    FX16_CONST(-0.7071067811865475), FX16_CONST(-0.7071067811865477),
    FX16_CONST(-0.7081906370331953), FX16_CONST(-0.7060212614493397),
    FX16_CONST(-0.7092728264388655), FX16_CONST(-0.7049340803759051),
    FX16_CONST(-0.7103533468570623), FX16_CONST(-0.703845240524485),
    FX16_CONST(-0.7114321957452164), FX16_CONST(-0.7027547444572253),
    FX16_CONST(-0.7125093705646922), FX16_CONST(-0.7016625947401687),
    FX16_CONST(-0.7135848687807935), FX16_CONST(-0.7005687939432484),
    FX16_CONST(-0.7146586878627688), FX16_CONST(-0.6994733446402841),
    FX16_CONST(-0.7157308252838185), FX16_CONST(-0.698376249408973),
    FX16_CONST(-0.7168012785210994), FX16_CONST(-0.6972775108308866),
    FX16_CONST(-0.7178700450557315), FX16_CONST(-0.6961771314914632),
    FX16_CONST(-0.7189371223728044), FX16_CONST(-0.695075113980001),
    FX16_CONST(-0.7200025079613817), FX16_CONST(-0.693971460889654),
    FX16_CONST(-0.7210661993145079), FX16_CONST(-0.6928661748174249),
    FX16_CONST(-0.7221281939292152), FX16_CONST(-0.6917592583641579),
    FX16_CONST(-0.7231884893065275), FX16_CONST(-0.6906507141345346),
    FX16_CONST(-0.7242470829514668), FX16_CONST(-0.689540544737067),
    FX16_CONST(-0.7253039723730607), FX16_CONST(-0.6884287527840905),
    FX16_CONST(-0.7263591550843458), FX16_CONST(-0.6873153408917594),
    FX16_CONST(-0.7274126286023757), FX16_CONST(-0.6862003116800387),
    FX16_CONST(-0.7284643904482252), FX16_CONST(-0.6850836677727004),
    FX16_CONST(-0.7295144381469968), FX16_CONST(-0.6839654117973156),
    FX16_CONST(-0.7305627692278275), FX16_CONST(-0.6828455463852482),
    FX16_CONST(-0.7316093812238925), FX16_CONST(-0.6817240741716498),
    FX16_CONST(-0.7326542716724127), FX16_CONST(-0.6806009977954532),
    FX16_CONST(-0.7336974381146601), FX16_CONST(-0.6794763198993651),
    FX16_CONST(-0.7347388780959635), FX16_CONST(-0.6783500431298615),
    FX16_CONST(-0.7357785891657134), FX16_CONST(-0.6772221701371806),
    FX16_CONST(-0.7368165688773698), FX16_CONST(-0.676092703575316),
    FX16_CONST(-0.7378528147884658), FX16_CONST(-0.6749616461020123),
    FX16_CONST(-0.738887324460615), FX16_CONST(-0.6738290003787561),
    FX16_CONST(-0.7399200954595161), FX16_CONST(-0.672694769070773),
    FX16_CONST(-0.7409511253549589), FX16_CONST(-0.6715589548470187),
    FX16_CONST(-0.741980411720831), FX16_CONST(-0.6704215603801732),
    FX16_CONST(-0.7430079521351217), FX16_CONST(-0.669282588346636),
    FX16_CONST(-0.7440337441799291), FX16_CONST(-0.6681420414265187),
    FX16_CONST(-0.7450577854414658), FX16_CONST(-0.6669999223036376),
    FX16_CONST(-0.7460800735100638), FX16_CONST(-0.6658562336655096),
    FX16_CONST(-0.7471006059801799), FX16_CONST(-0.664710978203345),
    FX16_CONST(-0.7481193804504035), FX16_CONST(-0.6635641586120399),
    FX16_CONST(-0.749136394523459), FX16_CONST(-0.662415777590172),
    FX16_CONST(-0.750151645806215), FX16_CONST(-0.6612658378399924),
    FX16_CONST(-0.7511651319096864), FX16_CONST(-0.6601143420674205),
    FX16_CONST(-0.7521768504490425), FX16_CONST(-0.6589612929820375),
    FX16_CONST(-0.7531867990436124), FX16_CONST(-0.6578066932970787),
    FX16_CONST(-0.7541949753168892), FX16_CONST(-0.656650545729429),
    FX16_CONST(-0.7552013768965363), FX16_CONST(-0.6554928529996156),
    FX16_CONST(-0.7562060014143944), FX16_CONST(-0.6543336178318007),
    FX16_CONST(-0.7572088465064842), FX16_CONST(-0.6531728429537771),
    FX16_CONST(-0.7582099098130151), FX16_CONST(-0.6520105310969597),
    FX16_CONST(-0.759209188978388), FX16_CONST(-0.650846684996381),
    FX16_CONST(-0.7602066816512024), FX16_CONST(-0.6496813073906831),
    FX16_CONST(-0.761202385484262), FX16_CONST(-0.6485144010221122),
    FX16_CONST(-0.7621962981345786), FX16_CONST(-0.6473459686365125),
    FX16_CONST(-0.763188417263381), FX16_CONST(-0.6461760129833166),
    FX16_CONST(-0.7641787405361166), FX16_CONST(-0.6450045368155441),
    FX16_CONST(-0.765167265622459), FX16_CONST(-0.6438315428897915),
    FX16_CONST(-0.766153990196313), FX16_CONST(-0.6426570339662268),
    FX16_CONST(-0.7671389119358201), FX16_CONST(-0.6414810128085836),
    FX16_CONST(-0.7681220285233652), FX16_CONST(-0.640303482184152),
    FX16_CONST(-0.7691033376455795), FX16_CONST(-0.639124444863776),
    FX16_CONST(-0.7700828369933479), FX16_CONST(-0.6379439036218442),
    FX16_CONST(-0.7710605242618138), FX16_CONST(-0.6367618612362842),
    FX16_CONST(-0.7720363971503846), FX16_CONST(-0.635578320488556),
    FX16_CONST(-0.7730104533627367), FX16_CONST(-0.6343932841636459),
    FX16_CONST(-0.7739826906068226), FX16_CONST(-0.6332067550500575),
    FX16_CONST(-0.7749531065948738), FX16_CONST(-0.6320187359398092),
    FX16_CONST(-0.7759216990434076), FX16_CONST(-0.6308292296284246),
    FX16_CONST(-0.7768884656732326), FX16_CONST(-0.6296382389149269),
    FX16_CONST(-0.7778534042094527), FX16_CONST(-0.6284457666018332),
    FX16_CONST(-0.7788165123814756), FX16_CONST(-0.6272518154951444),
    FX16_CONST(-0.7797777879230143), FX16_CONST(-0.6260563884043437),
    FX16_CONST(-0.7807372285720944), FX16_CONST(-0.6248594881423865),
    FX16_CONST(-0.7816948320710595), FX16_CONST(-0.6236611175256945),
    FX16_CONST(-0.7826505961665758), FX16_CONST(-0.6224612793741497),
    FX16_CONST(-0.7836045186096379), FX16_CONST(-0.621259976511088),
    FX16_CONST(-0.784556597155575), FX16_CONST(-0.6200572117632894),
    FX16_CONST(-0.7855068295640538), FX16_CONST(-0.6188529879609764),
    FX16_CONST(-0.7864552135990858), FX16_CONST(-0.617647307937804),
    FX16_CONST(-0.7874017470290315), FX16_CONST(-0.6164401745308535),
    FX16_CONST(-0.7883464276266059), FX16_CONST(-0.6152315905806273),
    FX16_CONST(-0.7892892531688854), FX16_CONST(-0.6140215589310387),
    FX16_CONST(-0.7902302214373099), FX16_CONST(-0.6128100824294099),
    FX16_CONST(-0.7911693302176901), FX16_CONST(-0.611597163926462),
    FX16_CONST(-0.7921065773002124), FX16_CONST(-0.6103828062763094),
    FX16_CONST(-0.7930419604794439), FX16_CONST(-0.609167012336453),
    FX16_CONST(-0.7939754775543368), FX16_CONST(-0.6079497849677741),
    FX16_CONST(-0.7949071263282368), FX16_CONST(-0.6067311270345248),
    FX16_CONST(-0.7958369046088835), FX16_CONST(-0.6055110414043257),
    FX16_CONST(-0.7967648102084187), FX16_CONST(-0.6042895309481561),
    FX16_CONST(-0.7976908409433912), FX16_CONST(-0.603066598540348),
    FX16_CONST(-0.7986149946347605), FX16_CONST(-0.6018422470585805),
    FX16_CONST(-0.7995372691079048), FX16_CONST(-0.6006164793838693),
    FX16_CONST(-0.8004576621926226), FX16_CONST(-0.5993892984005648),
    FX16_CONST(-0.8013761717231401), FX16_CONST(-0.5981607069963424),
    FX16_CONST(-0.8022927955381157), FX16_CONST(-0.5969307080621964),
    FX16_CONST(-0.803207531480645), FX16_CONST(-0.5956993044924331),
    FX16_CONST(-0.8041203773982655), FX16_CONST(-0.5944664991846649),
    FX16_CONST(-0.8050313311429634), FX16_CONST(-0.5932322950398001),
    FX16_CONST(-0.8059403905711762), FX16_CONST(-0.5919966949620411),
    FX16_CONST(-0.8068475535437992), FX16_CONST(-0.5907597018588743),
    FX16_CONST(-0.8077528179261905), FX16_CONST(-0.5895213186410638),
    FX16_CONST(-0.8086561815881746), FX16_CONST(-0.5882815482226458),
    FX16_CONST(-0.809557642404051), FX16_CONST(-0.5870403935209183),
    FX16_CONST(-0.8104571982525947), FX16_CONST(-0.5857978574564391),
    FX16_CONST(-0.8113548470170637), FX16_CONST(-0.5845539429530153),
    FX16_CONST(-0.812250586585204), FX16_CONST(-0.5833086529376983),
    FX16_CONST(-0.8131444148492537), FX16_CONST(-0.5820619903407753),
    FX16_CONST(-0.8140363297059481), FX16_CONST(-0.580813958095765),
    FX16_CONST(-0.8149263290565264), FX16_CONST(-0.579564559139406),
    FX16_CONST(-0.8158144108067337), FX16_CONST(-0.5783137964116557),
    FX16_CONST(-0.8167005728668278), FX16_CONST(-0.5770616728556796),
    FX16_CONST(-0.8175848131515838), FX16_CONST(-0.5758081914178452),
    FX16_CONST(-0.8184671295802983), FX16_CONST(-0.5745533550477163),
    FX16_CONST(-0.8193475200767967), FX16_CONST(-0.5732971666980425),
    FX16_CONST(-0.8202259825694345), FX16_CONST(-0.5720396293247573),
    FX16_CONST(-0.8211025149911046), FX16_CONST(-0.5707807458869674),
    FX16_CONST(-0.8219771152792416), FX16_CONST(-0.5695205193469471),
    FX16_CONST(-0.8228497813758264), FX16_CONST(-0.5682589526701314),
    FX16_CONST(-0.8237205112273911), FX16_CONST(-0.566996048825109),
    FX16_CONST(-0.8245893027850251), FX16_CONST(-0.5657318107836135),
    FX16_CONST(-0.8254561540043774), FX16_CONST(-0.5644662415205196),
    FX16_CONST(-0.8263210628456634), FX16_CONST(-0.5631993440138341),
    FX16_CONST(-0.8271840272736692), FX16_CONST(-0.5619311212446892),
    FX16_CONST(-0.8280450452577555), FX16_CONST(-0.5606615761973365),
    FX16_CONST(-0.8289041147718647), FX16_CONST(-0.5593907118591365),
    FX16_CONST(-0.8297612337945229), FX16_CONST(-0.5581185312205563),
    FX16_CONST(-0.8306164003088462), FX16_CONST(-0.5568450372751601),
    FX16_CONST(-0.8314696123025452), FX16_CONST(-0.5555702330196022),
    FX16_CONST(-0.8323208677679298), FX16_CONST(-0.5542941214536199),
    FX16_CONST(-0.8331701647019129), FX16_CONST(-0.5530167055800279),
    FX16_CONST(-0.8340175011060179), FX16_CONST(-0.5517379884047077),
    FX16_CONST(-0.8348628749863799), FX16_CONST(-0.5504579729366049),
    FX16_CONST(-0.8357062843537526), FX16_CONST(-0.5491766621877198),
    FX16_CONST(-0.8365477272235121), FX16_CONST(-0.5478940591731001),
    FX16_CONST(-0.8373872016156616), FX16_CONST(-0.5466101669108354),
    FX16_CONST(-0.8382247055548379), FX16_CONST(-0.5453249884220468),
    FX16_CONST(-0.8390602370703125), FX16_CONST(-0.5440385267308842),
    FX16_CONST(-0.8398937941959994), FX16_CONST(-0.542750784864516),
    FX16_CONST(-0.8407253749704581), FX16_CONST(-0.5414617658531234),
    FX16_CONST(-0.8415549774368986), FX16_CONST(-0.5401714727298927),
    FX16_CONST(-0.8423825996431856), FX16_CONST(-0.5388799085310089),
    FX16_CONST(-0.8432082396418452), FX16_CONST(-0.5375870762956457),
    FX16_CONST(-0.8440318954900663), FX16_CONST(-0.5362929790659633),
    FX16_CONST(-0.8448535652497071), FX16_CONST(-0.5349976198870973),
    FX16_CONST(-0.8456732469872992), FX16_CONST(-0.5337010018071529),
    FX16_CONST(-0.8464909387740518), FX16_CONST(-0.5324031278771985),
    FX16_CONST(-0.8473066386858581), FX16_CONST(-0.5311040011512553),
    FX16_CONST(-0.8481203448032971), FX16_CONST(-0.5298036246862949),
    FX16_CONST(-0.8489320552116396), FX16_CONST(-0.5285020015422286),
    FX16_CONST(-0.8497417680008525), FX16_CONST(-0.5271991347819013),
    FX16_CONST(-0.8505494812656036), FX16_CONST(-0.5258950274710845),
    FX16_CONST(-0.8513551931052649), FX16_CONST(-0.5245896826784693),
    FX16_CONST(-0.8521589016239196), FX16_CONST(-0.5232831034756568),
    FX16_CONST(-0.8529606049303635), FX16_CONST(-0.5219752929371545),
    FX16_CONST(-0.8537603011381114), FX16_CONST(-0.5206662541403672),
    FX16_CONST(-0.8545579883654005), FX16_CONST(-0.5193559901655894),
    FX16_CONST(-0.8553536647351957), FX16_CONST(-0.5180445040959999),
    FX16_CONST(-0.8561473283751942), FX16_CONST(-0.5167317990176502),
    FX16_CONST(-0.8569389774178287), FX16_CONST(-0.5154178780194633),
    FX16_CONST(-0.857728610000272), FX16_CONST(-0.5141027441932218),
    FX16_CONST(-0.8585162242644429), FX16_CONST(-0.512786400633563),
    FX16_CONST(-0.8593018183570085), FX16_CONST(-0.5114688504379702),
    FX16_CONST(-0.8600853904293899), FX16_CONST(-0.5101500967067673),
    FX16_CONST(-0.8608669386377671), FX16_CONST(-0.5088301425431073),
    FX16_CONST(-0.8616464611430812), FX16_CONST(-0.507508991052971),
    FX16_CONST(-0.8624239561110405), FX16_CONST(-0.5061866453451553),
    FX16_CONST(-0.8631994217121243), FX16_CONST(-0.5048631085312674),
    FX16_CONST(-0.8639728561215865), FX16_CONST(-0.503538383725718),
    FX16_CONST(-0.8647442575194622), FX16_CONST(-0.5022124740457111),
    FX16_CONST(-0.865513624090569), FX16_CONST(-0.500885382611241),
    FX16_CONST(-0.8662809540245129), FX16_CONST(-0.49955711254508195),
    FX16_CONST(-0.8670462455156926), FX16_CONST(-0.4982276669727818),
    FX16_CONST(-0.8678094967633033), FX16_CONST(-0.49689704902265436),
    FX16_CONST(-0.8685707059713407), FX16_CONST(-0.495565261825773),
    FX16_CONST(-0.8693298713486066), FX16_CONST(-0.49423230851596),
    FX16_CONST(-0.8700869911087113), FX16_CONST(-0.4928981922297842),
    FX16_CONST(-0.8708420634700789), FX16_CONST(-0.49156291610654995),
    FX16_CONST(-0.8715950866559511), FX16_CONST(-0.49022648328829105),
    FX16_CONST(-0.8723460588943912), FX16_CONST(-0.48888889691976367),
    FX16_CONST(-0.8730949784182899), FX16_CONST(-0.48755016014843633),
    FX16_CONST(-0.8738418434653666), FX16_CONST(-0.48621027612448664),
    FX16_CONST(-0.8745866522781761), FX16_CONST(-0.4848692480007912),
    FX16_CONST(-0.8753294031041109), FX16_CONST(-0.4835270789329187),
    FX16_CONST(-0.8760700941954067), FX16_CONST(-0.48218377207912255),
    FX16_CONST(-0.8768087238091454), FX16_CONST(-0.4808393306003344),
    FX16_CONST(-0.8775452902072611), FX16_CONST(-0.47949375766015334),
    FX16_CONST(-0.8782797916565415), FX16_CONST(-0.47814705642484323),
    FX16_CONST(-0.8790122264286334), FX16_CONST(-0.47679923006332214),
    FX16_CONST(-0.8797425928000475), FX16_CONST(-0.47545028174715576),
    FX16_CONST(-0.8804708890521605), FX16_CONST(-0.4741002146505505),
    FX16_CONST(-0.8811971134712219), FX16_CONST(-0.4727490319503432),
    FX16_CONST(-0.8819212643483549), FX16_CONST(-0.47139673682599786),
    FX16_CONST(-0.8826433399795628), FX16_CONST(-0.47004333245959573),
    FX16_CONST(-0.8833633386657316), FX16_CONST(-0.4686888220358279),
    FX16_CONST(-0.8840812587126351), FX16_CONST(-0.46733320874198825),
    FX16_CONST(-0.8847970984309376), FX16_CONST(-0.4659764957679666),
    FX16_CONST(-0.8855108561361997), FX16_CONST(-0.46461868630623815),
    FX16_CONST(-0.8862225301488805), FX16_CONST(-0.46325978355186037),
    FX16_CONST(-0.8869321187943422), FX16_CONST(-0.4618997907024628),
    FX16_CONST(-0.887639620402854), FX16_CONST(-0.4605387109582399),
    FX16_CONST(-0.888345033309596), FX16_CONST(-0.45917654752194464),
    FX16_CONST(-0.8890483558546644), FX16_CONST(-0.4578133035988776),
    FX16_CONST(-0.8897495863830727), FX16_CONST(-0.4564489823968842),
    FX16_CONST(-0.8904487232447579), FX16_CONST(-0.45508358712634395),
    FX16_CONST(-0.8911457647945833), FX16_CONST(-0.4537171210001638),
    FX16_CONST(-0.8918407093923428), FX16_CONST(-0.45234958723377067),
    FX16_CONST(-0.8925335554027644), FX16_CONST(-0.4509809890451043),
    FX16_CONST(-0.8932243011955152), FX16_CONST(-0.44961132965460693),
    FX16_CONST(-0.8939129451452031), FX16_CONST(-0.4482406122852201),
    FX16_CONST(-0.8945994856313827), FX16_CONST(-0.4468688401623742),
    FX16_CONST(-0.8952839210385576), FX16_CONST(-0.44549601651398163),
    FX16_CONST(-0.8959662497561849), FX16_CONST(-0.44412214457042976),
    FX16_CONST(-0.89664647017868), FX16_CONST(-0.4427472275645704),
    FX16_CONST(-0.8973245807054182), FX16_CONST(-0.44137126873171695),
    FX16_CONST(-0.8980005797407398), FX16_CONST(-0.43999427130963337),
    FX16_CONST(-0.8986744656939538), FX16_CONST(-0.4386162385385276),
    FX16_CONST(-0.8993462369793417), FX16_CONST(-0.4372371736610439),
    FX16_CONST(-0.90001589201616), FX16_CONST(-0.435857079922256),
    FX16_CONST(-0.9006834292286467), FX16_CONST(-0.43447596056965604),
    FX16_CONST(-0.9013488470460219), FX16_CONST(-0.4330938188531521),
    FX16_CONST(-0.9020121439024932), FX16_CONST(-0.4317106580250573),
    FX16_CONST(-0.9026733182372588), FX16_CONST(-0.4303264813400825),
    FX16_CONST(-0.9033323684945116), FX16_CONST(-0.42894129205533005),
    FX16_CONST(-0.9039892931234431), FX16_CONST(-0.4275550934302825),
    FX16_CONST(-0.9046440905782461), FX16_CONST(-0.4261678887267999),
    FX16_CONST(-0.9052967593181187), FX16_CONST(-0.4247796812091089),
    FX16_CONST(-0.9059472978072685), FX16_CONST(-0.423390474143796),
    FX16_CONST(-0.9065957045149154), FX16_CONST(-0.4220002707997995),
    FX16_CONST(-0.9072419779152956), FX16_CONST(-0.420609074448403),
    FX16_CONST(-0.907886116487666), FX16_CONST(-0.4192168883632243),
    FX16_CONST(-0.908528118716306), FX16_CONST(-0.4178237158202125),
    FX16_CONST(-0.9091679830905224), FX16_CONST(-0.4164295600976372),
    FX16_CONST(-0.9098057081046523), FX16_CONST(-0.4150344244760815),
    FX16_CONST(-0.9104412922580669), FX16_CONST(-0.4136383122384351),
    FX16_CONST(-0.9110747340551761), FX16_CONST(-0.4122412266698833),
    FX16_CONST(-0.9117060320054298), FX16_CONST(-0.4108431710579042),
    FX16_CONST(-0.9123351846233227), FX16_CONST(-0.40944414869225776),
    FX16_CONST(-0.9129621904283982), FX16_CONST(-0.40804416286497863),
    FX16_CONST(-0.9135870479452509), FX16_CONST(-0.40664321687036886),
    FX16_CONST(-0.9142097557035305), FX16_CONST(-0.40524131400499036),
    FX16_CONST(-0.914830312237946), FX16_CONST(-0.40383845756765446),
    FX16_CONST(-0.9154487160882677), FX16_CONST(-0.40243465085941865),
    FX16_CONST(-0.9160649657993317), FX16_CONST(-0.4010298971835757),
    FX16_CONST(-0.9166790599210427), FX16_CONST(-0.39962419984564673),
    FX16_CONST(-0.9172909970083777), FX16_CONST(-0.39821756215337417),
    FX16_CONST(-0.9179007756213903), FX16_CONST(-0.39680998741671075),
    FX16_CONST(-0.9185083943252121), FX16_CONST(-0.3954014789478166),
    FX16_CONST(-0.9191138516900577), FX16_CONST(-0.3939920400610482),
    FX16_CONST(-0.9197171462912274), FX16_CONST(-0.39258167407295147),
    FX16_CONST(-0.9203182767091106), FX16_CONST(-0.3911703843022537),
    FX16_CONST(-0.9209172415291893), FX16_CONST(-0.38975817406985697),
    FX16_CONST(-0.9215140393420418), FX16_CONST(-0.38834504669882663),
    FX16_CONST(-0.9221086687433451), FX16_CONST(-0.3869310055143888),
    FX16_CONST(-0.9227011283338785), FX16_CONST(-0.3855160538439189),
    FX16_CONST(-0.9232914167195276), FX16_CONST(-0.38410019501693493),
    FX16_CONST(-0.9238795325112865), FX16_CONST(-0.38268343236509034),
    FX16_CONST(-0.9244654743252625), FX16_CONST(-0.38126576922216276),
    FX16_CONST(-0.9250492407826775), FX16_CONST(-0.37984720892405144),
    FX16_CONST(-0.9256308305098727), FX16_CONST(-0.3784277548087657),
    FX16_CONST(-0.9262102421383114), FX16_CONST(-0.3770074102164182),
    FX16_CONST(-0.9267874743045819), FX16_CONST(-0.37558617848921705),
    FX16_CONST(-0.9273625256504009), FX16_CONST(-0.3741640629714585),
    FX16_CONST(-0.9279353948226177), FX16_CONST(-0.37274106700951615),
    FX16_CONST(-0.9285060804732155), FX16_CONST(-0.37131719395183777),
    FX16_CONST(-0.9290745812593157), FX16_CONST(-0.36989244714893416),
    FX16_CONST(-0.9296408958431813), FX16_CONST(-0.3684668299533722),
    FX16_CONST(-0.9302050228922192), FX16_CONST(-0.36704034571976696),
    FX16_CONST(-0.9307669610789836), FX16_CONST(-0.3656129978047743),
    FX16_CONST(-0.9313267090811803), FX16_CONST(-0.36418478956708017),
    FX16_CONST(-0.931884265581668), FX16_CONST(-0.36275572436739734),
    FX16_CONST(-0.9324396292684624), FX16_CONST(-0.36132580556845423),
    FX16_CONST(-0.932992798834739), FX16_CONST(-0.35989503653498794),
    FX16_CONST(-0.933543772978836), FX16_CONST(-0.35846342063373704),
    FX16_CONST(-0.9340925504042588), FX16_CONST(-0.35703096123343037),
    FX16_CONST(-0.9346391298196807), FX16_CONST(-0.3555976617047841),
    FX16_CONST(-0.9351835099389476), FX16_CONST(-0.35416352542049045),
    FX16_CONST(-0.9357256894810804), FX16_CONST(-0.3527285557552106),
    FX16_CONST(-0.9362656671702784), FX16_CONST(-0.35129275608556687),
    FX16_CONST(-0.9368034417359214), FX16_CONST(-0.34985612979013536),
    FX16_CONST(-0.9373390119125748), FX16_CONST(-0.34841868024943484),
    FX16_CONST(-0.9378723764399898), FX16_CONST(-0.3469804108459238),
    FX16_CONST(-0.9384035340631082), FX16_CONST(-0.34554132496398904),
    FX16_CONST(-0.9389324835320646), FX16_CONST(-0.34410142598993865),
    FX16_CONST(-0.9394592236021897), FX16_CONST(-0.3426607173119949),
    FX16_CONST(-0.9399837530340138), FX16_CONST(-0.34121920232028274),
    FX16_CONST(-0.9405060705932683), FX16_CONST(-0.3397768844068271),
    FX16_CONST(-0.9410261750508893), FX16_CONST(-0.33833376696554124),
    FX16_CONST(-0.9415440651830208), FX16_CONST(-0.33688985339221994),
    FX16_CONST(-0.9420597397710174), FX16_CONST(-0.3354451470845314),
    FX16_CONST(-0.9425731976014468), FX16_CONST(-0.3339996514420098),
    FX16_CONST(-0.9430844374660934), FX16_CONST(-0.3325533698660445),
    FX16_CONST(-0.9435934581619603), FX16_CONST(-0.33110630575987654),
    FX16_CONST(-0.9441002584912727), FX16_CONST(-0.3296584625285875),
    FX16_CONST(-0.9446048372614804), FX16_CONST(-0.32820984357909233),
    FX16_CONST(-0.9451071932852604), FX16_CONST(-0.3267604523201323),
    FX16_CONST(-0.9456073253805212), FX16_CONST(-0.3253102921622633),
    FX16_CONST(-0.9461052323704033), FX16_CONST(-0.3238593665178531),
    FX16_CONST(-0.9466009130832835), FX16_CONST(-0.3224076788010699),
    FX16_CONST(-0.9470943663527772), FX16_CONST(-0.32095523242787516),
    FX16_CONST(-0.9475855910177412), FX16_CONST(-0.3195020308160154),
    FX16_CONST(-0.9480745859222761), FX16_CONST(-0.3180480773850154),
    FX16_CONST(-0.9485613499157302), FX16_CONST(-0.3165933755561662),
    FX16_CONST(-0.9490458818527006), FX16_CONST(-0.31513792875252256),
    FX16_CONST(-0.9495281805930367), FX16_CONST(-0.31368174039889146),
    FX16_CONST(-0.9500082450018431), FX16_CONST(-0.3122248139218248),
    FX16_CONST(-0.9504860739494816), FX16_CONST(-0.31076715274961203),
    FX16_CONST(-0.950961666311575), FX16_CONST(-0.30930876031226906),
    FX16_CONST(-0.9514350209690083), FX16_CONST(-0.3078496400415351),
    FX16_CONST(-0.9519061368079323), FX16_CONST(-0.306389795370861),
    FX16_CONST(-0.9523750127197659), FX16_CONST(-0.3049292297354023),
    FX16_CONST(-0.9528416476011987), FX16_CONST(-0.30346794657201104),
    FX16_CONST(-0.9533060403541936), FX16_CONST(-0.30200594931922853),
    FX16_CONST(-0.9537681898859902), FX16_CONST(-0.30054324141727373),
    FX16_CONST(-0.9542280951091056), FX16_CONST(-0.2990798263080406),
    FX16_CONST(-0.9546857549413383), FX16_CONST(-0.2976157074350862),
    FX16_CONST(-0.9551411683057708), FX16_CONST(-0.2961508882436237),
    FX16_CONST(-0.9555943341307709), FX16_CONST(-0.2946853721805149),
    FX16_CONST(-0.9560452513499963), FX16_CONST(-0.293219162694259),
    FX16_CONST(-0.956493918902395), FX16_CONST(-0.2917522632349895),
    FX16_CONST(-0.9569403357322088), FX16_CONST(-0.29028467725446244),
    FX16_CONST(-0.957384500788976), FX16_CONST(-0.28881640820604937),
    FX16_CONST(-0.957826413027533), FX16_CONST(-0.2873474595447293),
    FX16_CONST(-0.9582660714080176), FX16_CONST(-0.28587783472708106),
    FX16_CONST(-0.9587034748958715), FX16_CONST(-0.28440753721127215),
    FX16_CONST(-0.9591386224618419), FX16_CONST(-0.2829365704570555),
    FX16_CONST(-0.9595715130819845), FX16_CONST(-0.28146493792575794),
    FX16_CONST(-0.960002145737666), FX16_CONST(-0.27999264308027305),
    FX16_CONST(-0.9604305194155657), FX16_CONST(-0.2785196893850536),
    FX16_CONST(-0.9608566331076795), FX16_CONST(-0.2770460803061003),
    FX16_CONST(-0.9612804858113205), FX16_CONST(-0.27557181931095837),
    FX16_CONST(-0.9617020765291225), FX16_CONST(-0.27409690986870644),
    FX16_CONST(-0.9621214042690416), FX16_CONST(-0.27262135544994887),
    FX16_CONST(-0.9625384680443593), FX16_CONST(-0.2711451595268078),
    FX16_CONST(-0.9629532668736838), FX16_CONST(-0.26966832557291553),
    FX16_CONST(-0.9633657997809539), FX16_CONST(-0.2681908570634035),
    FX16_CONST(-0.9637760657954398), FX16_CONST(-0.26671275747489853),
    FX16_CONST(-0.9641840639517458), FX16_CONST(-0.2652340302855118),
    FX16_CONST(-0.9645897932898128), FX16_CONST(-0.26375467897483124),
    FX16_CONST(-0.9649932528549202), FX16_CONST(-0.26227470702391414),
    FX16_CONST(-0.9653944416976893), FX16_CONST(-0.2607941179152759),
    FX16_CONST(-0.9657933588740836), FX16_CONST(-0.25931291513288646),
    FX16_CONST(-0.9661900034454125), FX16_CONST(-0.25783110216215904),
    FX16_CONST(-0.9665843744783331), FX16_CONST(-0.2563486824899428),
    FX16_CONST(-0.9669764710448522), FX16_CONST(-0.25486565960451435),
    FX16_CONST(-0.9673662922223284), FX16_CONST(-0.2533820369955706),
    FX16_CONST(-0.9677538370934754), FX16_CONST(-0.25189781815421725),
    FX16_CONST(-0.9681391047463623), FX16_CONST(-0.2504130065729654),
    FX16_CONST(-0.9685220942744173), FX16_CONST(-0.24892760574572015),
    FX16_CONST(-0.9689028047764289), FX16_CONST(-0.24744161916777313),
    FX16_CONST(-0.9692812353565483), FX16_CONST(-0.24595505033579515),
    FX16_CONST(-0.9696573851242923), FX16_CONST(-0.24446790274782454),
    FX16_CONST(-0.970031253194544), FX16_CONST(-0.24298017990326412),
    FX16_CONST(-0.9704028386875555), FX16_CONST(-0.2414918853028694),
    FX16_CONST(-0.9707721407289504), FX16_CONST(-0.2400030224487414),
    FX16_CONST(-0.9711391584497252), FX16_CONST(-0.2385135948443182),
    FX16_CONST(-0.9715038909862517), FX16_CONST(-0.23702360599436767),
    FX16_CONST(-0.9718663374802793), FX16_CONST(-0.2355330594049758),
    FX16_CONST(-0.9722264970789363), FX16_CONST(-0.23404195858354357),
    FX16_CONST(-0.9725843689347322), FX16_CONST(-0.23255030703877522),
    FX16_CONST(-0.9729399522055602), FX16_CONST(-0.23105810828067094),
    FX16_CONST(-0.9732932460546981), FX16_CONST(-0.22956536582051942),
    FX16_CONST(-0.9736442496508119), FX16_CONST(-0.22807208317088612),
    FX16_CONST(-0.9739929621679558), FX16_CONST(-0.22657826384561022),
    FX16_CONST(-0.9743393827855759), FX16_CONST(-0.22508391135979292),
    FX16_CONST(-0.9746835106885107), FX16_CONST(-0.2235890292297899),
    FX16_CONST(-0.9750253450669942), FX16_CONST(-0.2220936209732033),
    FX16_CONST(-0.9753648851166569), FX16_CONST(-0.22059769010887398),
    FX16_CONST(-0.9757021300385285), FX16_CONST(-0.2191012401568701),
    FX16_CONST(-0.976037079039039), FX16_CONST(-0.21760427463848378),
    FX16_CONST(-0.9763697313300211), FX16_CONST(-0.2161067970762195),
    FX16_CONST(-0.9767000861287118), FX16_CONST(-0.2146088109937866),
    FX16_CONST(-0.9770281426577543), FX16_CONST(-0.21311031991609192),
    FX16_CONST(-0.9773539001452), FX16_CONST(-0.21161132736922797),
    FX16_CONST(-0.9776773578245099), FX16_CONST(-0.21011183688046986),
    FX16_CONST(-0.977998514934557), FX16_CONST(-0.20861185197826357),
    FX16_CONST(-0.9783173707196277), FX16_CONST(-0.20711137619221848),
    FX16_CONST(-0.9786339244294232), FX16_CONST(-0.20561041305309902),
    FX16_CONST(-0.9789481753190621), FX16_CONST(-0.20410896609281734),
    FX16_CONST(-0.979260122649082), FX16_CONST(-0.20260703884442144),
    FX16_CONST(-0.9795697656854405), FX16_CONST(-0.20110463484209207),
    FX16_CONST(-0.9798771036995176), FX16_CONST(-0.19960175762113097),
    FX16_CONST(-0.9801821359681174), FX16_CONST(-0.19809841071795342),
    FX16_CONST(-0.9804848617734693), FX16_CONST(-0.19659459767008078),
    FX16_CONST(-0.9807852804032303), FX16_CONST(-0.19509032201612866),
    FX16_CONST(-0.9810833911504866), FX16_CONST(-0.19358558729580386),
    FX16_CONST(-0.9813791933137546), FX16_CONST(-0.19208039704989252),
    FX16_CONST(-0.9816726861969831), FX16_CONST(-0.19057475482025268),
    FX16_CONST(-0.9819638691095554), FX16_CONST(-0.18906866414980597),
    FX16_CONST(-0.9822527413662894), FX16_CONST(-0.18756212858253007),
    FX16_CONST(-0.9825393022874412), FX16_CONST(-0.18605515166344697),
    FX16_CONST(-0.9828235511987052), FX16_CONST(-0.18454773693861978),
    FX16_CONST(-0.9831054874312163), FX16_CONST(-0.18303988795514095),
    FX16_CONST(-0.9833851103215513), FX16_CONST(-0.18153160826112483),
    FX16_CONST(-0.9836624192117301), FX16_CONST(-0.18002290140570007),
    FX16_CONST(-0.9839374134492188), FX16_CONST(-0.17851377093899792),
    FX16_CONST(-0.984210092386929), FX16_CONST(-0.177004220412149),
    FX16_CONST(-0.9844804553832209), FX16_CONST(-0.1754942533772715),
    FX16_CONST(-0.9847485018019042), FX16_CONST(-0.17398387338746374),
    FX16_CONST(-0.9850142310122398), FX16_CONST(-0.17247308399679573),
    FX16_CONST(-0.9852776423889411), FX16_CONST(-0.1709618887603017),
    FX16_CONST(-0.9855387353121761), FX16_CONST(-0.1694502912339683),
    FX16_CONST(-0.9857975091675674), FX16_CONST(-0.16793829497473134),
    FX16_CONST(-0.9860539633461954), FX16_CONST(-0.1664259035404641),
    FX16_CONST(-0.9863080972445987), FX16_CONST(-0.16491312048996976),
    FX16_CONST(-0.9865599102647754), FX16_CONST(-0.16339994938297378),
    FX16_CONST(-0.9868094018141854), FX16_CONST(-0.16188639378011224),
    FX16_CONST(-0.987056571305751), FX16_CONST(-0.1603724572429285),
    FX16_CONST(-0.9873014181578583), FX16_CONST(-0.15885814333386153),
    FX16_CONST(-0.9875439417943593), FX16_CONST(-0.1573434556162382),
    FX16_CONST(-0.9877841416445722), FX16_CONST(-0.15582839765426498),
    FX16_CONST(-0.9880220171432835), FX16_CONST(-0.15431297301302058),
    FX16_CONST(-0.9882575677307495), FX16_CONST(-0.15279718525844374),
    FX16_CONST(-0.9884907928526966), FX16_CONST(-0.15128103795733036),
    FX16_CONST(-0.9887216919603238), FX16_CONST(-0.1497645346773215),
    FX16_CONST(-0.988950264510303), FX16_CONST(-0.1482476789868959),
    FX16_CONST(-0.9891765099647809), FX16_CONST(-0.1467304744553623),
    FX16_CONST(-0.9894004277913803), FX16_CONST(-0.14521292465284785),
    FX16_CONST(-0.9896220174632008), FX16_CONST(-0.1436950331502947),
    FX16_CONST(-0.9898412784588205), FX16_CONST(-0.14217680351944814),
    FX16_CONST(-0.9900582102622971), FX16_CONST(-0.14065823933284916),
    FX16_CONST(-0.9902728123631691), FX16_CONST(-0.13913934416382598),
    FX16_CONST(-0.990485084256457), FX16_CONST(-0.13762012158648654),
    FX16_CONST(-0.9906950254426646), FX16_CONST(-0.13610057517570653),
    FX16_CONST(-0.99090263542778), FX16_CONST(-0.13458070850712636),
    FX16_CONST(-0.9911079137232769), FX16_CONST(-0.13306052515713906),
    FX16_CONST(-0.9913108598461154), FX16_CONST(-0.13154002870288295),
    FX16_CONST(-0.9915114733187439), FX16_CONST(-0.13001922272223393),
    FX16_CONST(-0.9917097536690995), FX16_CONST(-0.12849811079379359),
    FX16_CONST(-0.9919057004306093), FX16_CONST(-0.12697669649688612),
    FX16_CONST(-0.9920993131421918), FX16_CONST(-0.12545498341154632),
    FX16_CONST(-0.9922905913482574), FX16_CONST(-0.12393297511851209),
    FX16_CONST(-0.9924795345987101), FX16_CONST(-0.12241067519921596),
    FX16_CONST(-0.9926661424489479), FX16_CONST(-0.12088808723577757),
    FX16_CONST(-0.9928504144598651), FX16_CONST(-0.11936521481099169),
    FX16_CONST(-0.9930323501978514), FX16_CONST(-0.11784206150832514),
    FX16_CONST(-0.9932119492347945), FX16_CONST(-0.11631863091190477),
    FX16_CONST(-0.9933892111480807), FX16_CONST(-0.11479492660650993),
    FX16_CONST(-0.9935641355205953), FX16_CONST(-0.11327095217756492),
    FX16_CONST(-0.9937367219407246), FX16_CONST(-0.111746711211127),
    FX16_CONST(-0.9939069700023561), FX16_CONST(-0.11022220729388331),
    FX16_CONST(-0.9940748793048794), FX16_CONST(-0.1086974440131388),
    FX16_CONST(-0.9942404494531879), FX16_CONST(-0.10717242495680877),
    FX16_CONST(-0.9944036800576791), FX16_CONST(-0.10564715371341038),
    FX16_CONST(-0.9945645707342554), FX16_CONST(-0.10412163387205507),
    FX16_CONST(-0.9947231211043257), FX16_CONST(-0.10259586902243661),
    FX16_CONST(-0.9948793307948056), FX16_CONST(-0.10106986275482799),
    FX16_CONST(-0.9950331994381186), FX16_CONST(-0.09954361866006935),
    FX16_CONST(-0.9951847266721969), FX16_CONST(-0.09801714032956045),
    FX16_CONST(-0.9953339121404822), FX16_CONST(-0.09649043135525316),
    FX16_CONST(-0.9954807554919269), FX16_CONST(-0.09496349532963941),
    FX16_CONST(-0.9956252563809943), FX16_CONST(-0.09343633584574804),
    FX16_CONST(-0.9957674144676598), FX16_CONST(-0.09190895649713282),
    FX16_CONST(-0.9959072294174117), FX16_CONST(-0.09038136087786491),
    FX16_CONST(-0.996044700901252), FX16_CONST(-0.08885355258252436),
    FX16_CONST(-0.9961798285956969), FX16_CONST(-0.08732553520619256),
    FX16_CONST(-0.996312612182778), FX16_CONST(-0.08579731234444023),
    FX16_CONST(-0.9964430513500426), FX16_CONST(-0.08426888759332424),
    FX16_CONST(-0.9965711457905548), FX16_CONST(-0.0827402645493757),
    FX16_CONST(-0.9966968952028961), FX16_CONST(-0.08121144680959229),
    FX16_CONST(-0.9968202992911657), FX16_CONST(-0.0796824379714307),
    FX16_CONST(-0.996941357764982), FX16_CONST(-0.07815324163279465),
    FX16_CONST(-0.997060070339483), FX16_CONST(-0.07662386139203174),
    FX16_CONST(-0.9971764367353261), FX16_CONST(-0.0750943008479214),
    FX16_CONST(-0.9972904566786902), FX16_CONST(-0.07356456359966736),
    FX16_CONST(-0.9974021299012753), FX16_CONST(-0.0720346532468891),
    FX16_CONST(-0.9975114561403035), FX16_CONST(-0.07050457338961436),
    FX16_CONST(-0.9976184351385196), FX16_CONST(-0.06897432762826708),
    FX16_CONST(-0.9977230666441916), FX16_CONST(-0.06744391956366423),
    FX16_CONST(-0.9978253504111116), FX16_CONST(-0.06591335279700383),
    FX16_CONST(-0.997925286198596), FX16_CONST(-0.06438263092985731),
    FX16_CONST(-0.9980228737714861), FX16_CONST(-0.06285175756416199),
    FX16_CONST(-0.9981181129001492), FX16_CONST(-0.061320736302208995),
    FX16_CONST(-0.9982110033604782), FX16_CONST(-0.05978957074664013),
    FX16_CONST(-0.9983015449338928), FX16_CONST(-0.058258264500435857),
    FX16_CONST(-0.9983897374073402), FX16_CONST(-0.056726821166907686),
    FX16_CONST(-0.9984755805732948), FX16_CONST(-0.05519524434968971),
    FX16_CONST(-0.9985590742297593), FX16_CONST(-0.053663537652731026),
    FX16_CONST(-0.9986402181802652), FX16_CONST(-0.05213170468028366),
    FX16_CONST(-0.9987190122338729), FX16_CONST(-0.050599749036899455),
    FX16_CONST(-0.9987954562051724), FX16_CONST(-0.04906767432741803),
    FX16_CONST(-0.9988695499142836), FX16_CONST(-0.04753548415695916),
    FX16_CONST(-0.9989412931868569), FX16_CONST(-0.046003182130915206),
    FX16_CONST(-0.9990106858540733), FX16_CONST(-0.044470771854939084),
    FX16_CONST(-0.9990777277526454), FX16_CONST(-0.042938256934941084),
    FX16_CONST(-0.9991424187248169), FX16_CONST(-0.04140564097707684),
    FX16_CONST(-0.9992047586183639), FX16_CONST(-0.03987292758773975),
    FX16_CONST(-0.9992647472865944), FX16_CONST(-0.03834012037355247),
    FX16_CONST(-0.9993223845883494), FX16_CONST(-0.03680722294135933),
    FX16_CONST(-0.9993776703880028), FX16_CONST(-0.035274238898214294),
    FX16_CONST(-0.9994306045554617), FX16_CONST(-0.03374117185137776),
    FX16_CONST(-0.999481186966167), FX16_CONST(-0.0322080254083046),
    FX16_CONST(-0.9995294175010931), FX16_CONST(-0.030674803176636484),
    FX16_CONST(-0.9995752960467492), FX16_CONST(-0.02914150876419431),
    FX16_CONST(-0.9996188224951786), FX16_CONST(-0.027608145778966163),
    FX16_CONST(-0.9996599967439592), FX16_CONST(-0.02607471782910416),
    FX16_CONST(-0.9996988186962042), FX16_CONST(-0.02454122852291239),
    FX16_CONST(-0.9997352882605617), FX16_CONST(-0.02300768146883931),
    FX16_CONST(-0.9997694053512153), FX16_CONST(-0.021474080275469286),
    FX16_CONST(-0.9998011698878843), FX16_CONST(-0.019940428551514944),
    FX16_CONST(-0.9998305817958234), FX16_CONST(-0.018406729905805164),
    FX16_CONST(-0.9998576410058239), FX16_CONST(-0.016872987947281894),
    FX16_CONST(-0.9998823474542126), FX16_CONST(-0.015339206284988121),
    FX16_CONST(-0.9999047010828529), FX16_CONST(-0.01380538852806025),
    FX16_CONST(-0.9999247018391445), FX16_CONST(-0.012271538285720512),
    FX16_CONST(-0.9999423496760239), FX16_CONST(-0.010737659167264916),
    FX16_CONST(-0.9999576445519639), FX16_CONST(-0.009203754782060083),
    FX16_CONST(-0.9999705864309741), FX16_CONST(-0.007669828739531199),
    FX16_CONST(-0.9999811752826011), FX16_CONST(-0.006135884649154416),
    FX16_CONST(-0.9999894110819284), FX16_CONST(-0.00460192612044835),
    FX16_CONST(-0.9999952938095762), FX16_CONST(-0.0030679567629664827),
    FX16_CONST(-0.9999988234517019), FX16_CONST(-0.0015339801862851105),
    FX16_CONST(-1.0), FX16_CONST(-1.8369701987210297e-16),
    FX16_CONST(-0.9999988234517019), FX16_CONST(0.0015339801862847432),
    FX16_CONST(-0.9999952938095762), FX16_CONST(0.003067956762966115),
    FX16_CONST(-0.9999894110819284), FX16_CONST(0.004601926120447982),
    FX16_CONST(-0.9999811752826011), FX16_CONST(0.0061358846491540485),
    FX16_CONST(-0.9999705864309741), FX16_CONST(0.007669828739530832),
    FX16_CONST(-0.9999576445519639), FX16_CONST(0.009203754782059715),
    FX16_CONST(-0.9999423496760239), FX16_CONST(0.010737659167264548),
    FX16_CONST(-0.9999247018391445), FX16_CONST(0.012271538285720144),
    FX16_CONST(-0.9999047010828529), FX16_CONST(0.013805388528059882),
    FX16_CONST(-0.9998823474542126), FX16_CONST(0.015339206284987753),
    FX16_CONST(-0.9998576410058239), FX16_CONST(0.016872987947281527),
    FX16_CONST(-0.9998305817958234), FX16_CONST(0.018406729905804796),
    FX16_CONST(-0.9998011698878843), FX16_CONST(0.019940428551514577),
    FX16_CONST(-0.9997694053512153), FX16_CONST(0.021474080275468918),
    FX16_CONST(-0.9997352882605617), FX16_CONST(0.023007681468838945),
    FX16_CONST(-0.9996988186962042), FX16_CONST(0.02454122852291202),
    FX16_CONST(-0.9996599967439592), FX16_CONST(0.026074717829103793),
    FX16_CONST(-0.9996188224951786), FX16_CONST(0.027608145778965795),
    FX16_CONST(-0.9995752960467492), FX16_CONST(0.02914150876419394),
    FX16_CONST(-0.9995294175010931), FX16_CONST(0.030674803176636116),
    FX16_CONST(-0.999481186966167), FX16_CONST(0.03220802540830423),
    FX16_CONST(-0.9994306045554617), FX16_CONST(0.0337411718513774),
    FX16_CONST(-0.9993776703880028), FX16_CONST(0.035274238898213926),
    FX16_CONST(-0.9993223845883495), FX16_CONST(0.036807222941358964),
    FX16_CONST(-0.9992647472865945), FX16_CONST(0.038340120373552104),
    FX16_CONST(-0.9992047586183639), FX16_CONST(0.03987292758773938),
    FX16_CONST(-0.9991424187248169), FX16_CONST(0.04140564097707647),
    FX16_CONST(-0.9990777277526454), FX16_CONST(0.042938256934940716),
    FX16_CONST(-0.9990106858540734), FX16_CONST(0.044470771854938716),
    FX16_CONST(-0.9989412931868569), FX16_CONST(0.046003182130914845),
    FX16_CONST(-0.9988695499142836), FX16_CONST(0.04753548415695879),
    FX16_CONST(-0.9987954562051724), FX16_CONST(0.04906767432741766),
    FX16_CONST(-0.9987190122338729), FX16_CONST(0.05059974903689909),
    FX16_CONST(-0.9986402181802653), FX16_CONST(0.05213170468028329),
    FX16_CONST(-0.9985590742297593), FX16_CONST(0.05366353765273066),
    FX16_CONST(-0.9984755805732948), FX16_CONST(0.055195244349689344),
    FX16_CONST(-0.9983897374073402), FX16_CONST(0.05672682116690732),
    FX16_CONST(-0.9983015449338929), FX16_CONST(0.05825826450043549),
    FX16_CONST(-0.9982110033604782), FX16_CONST(0.059789570746639764),
    FX16_CONST(-0.9981181129001492), FX16_CONST(0.06132073630220863),
    FX16_CONST(-0.9980228737714862), FX16_CONST(0.06285175756416163),
    FX16_CONST(-0.997925286198596), FX16_CONST(0.06438263092985695),
    FX16_CONST(-0.9978253504111116), FX16_CONST(0.06591335279700346),
    FX16_CONST(-0.9977230666441916), FX16_CONST(0.06744391956366387),
    FX16_CONST(-0.9976184351385196), FX16_CONST(0.06897432762826672),
    FX16_CONST(-0.9975114561403035), FX16_CONST(0.070504573389614),
    FX16_CONST(-0.9974021299012753), FX16_CONST(0.07203465324688872),
    FX16_CONST(-0.9972904566786902), FX16_CONST(0.07356456359966698),
    FX16_CONST(-0.9971764367353262), FX16_CONST(0.07509430084792104),
    FX16_CONST(-0.997060070339483), FX16_CONST(0.07662386139203138),
    FX16_CONST(-0.9969413577649822), FX16_CONST(0.07815324163279429),
    FX16_CONST(-0.9968202992911657), FX16_CONST(0.07968243797143033),
    FX16_CONST(-0.9966968952028961), FX16_CONST(0.08121144680959191),
    FX16_CONST(-0.9965711457905548), FX16_CONST(0.08274026454937533),
    FX16_CONST(-0.9964430513500426), FX16_CONST(0.08426888759332388),
    FX16_CONST(-0.996312612182778), FX16_CONST(0.08579731234443985),
    FX16_CONST(-0.9961798285956969), FX16_CONST(0.0873255352061922),
    FX16_CONST(-0.9960447009012521), FX16_CONST(0.088853552582524),
    FX16_CONST(-0.9959072294174117), FX16_CONST(0.09038136087786454),
    FX16_CONST(-0.9957674144676598), FX16_CONST(0.09190895649713245),
    FX16_CONST(-0.9956252563809943), FX16_CONST(0.09343633584574766),
    FX16_CONST(-0.9954807554919269), FX16_CONST(0.09496349532963905),
    FX16_CONST(-0.9953339121404823), FX16_CONST(0.0964904313552528),
    FX16_CONST(-0.9951847266721969), FX16_CONST(0.09801714032956009),
    FX16_CONST(-0.9950331994381186), FX16_CONST(0.09954361866006897),
    FX16_CONST(-0.9948793307948056), FX16_CONST(0.10106986275482763),
    FX16_CONST(-0.9947231211043257), FX16_CONST(0.10259586902243625),
    FX16_CONST(-0.9945645707342554), FX16_CONST(0.1041216338720547),
    FX16_CONST(-0.9944036800576791), FX16_CONST(0.10564715371341002),
    FX16_CONST(-0.994240449453188), FX16_CONST(0.10717242495680841),
    FX16_CONST(-0.9940748793048795), FX16_CONST(0.10869744401313844),
    FX16_CONST(-0.9939069700023561), FX16_CONST(0.11022220729388293),
    FX16_CONST(-0.9937367219407246), FX16_CONST(0.11174671121112664),
    FX16_CONST(-0.9935641355205953), FX16_CONST(0.11327095217756455),
    FX16_CONST(-0.9933892111480808), FX16_CONST(0.11479492660650957),
    FX16_CONST(-0.9932119492347946), FX16_CONST(0.1163186309119044),
    FX16_CONST(-0.9930323501978514), FX16_CONST(0.11784206150832478),
    FX16_CONST(-0.9928504144598651), FX16_CONST(0.11936521481099133),
    FX16_CONST(-0.992666142448948), FX16_CONST(0.1208880872357772),
    FX16_CONST(-0.9924795345987101), FX16_CONST(0.1224106751992156),
    FX16_CONST(-0.9922905913482574), FX16_CONST(0.12393297511851173),
    FX16_CONST(-0.9920993131421918), FX16_CONST(0.12545498341154596),
    FX16_CONST(-0.9919057004306093), FX16_CONST(0.12697669649688575),
    FX16_CONST(-0.9917097536690995), FX16_CONST(0.12849811079379322),
    FX16_CONST(-0.9915114733187439), FX16_CONST(0.13001922272223354),
    FX16_CONST(-0.9913108598461154), FX16_CONST(0.1315400287028826),
    FX16_CONST(-0.9911079137232769), FX16_CONST(0.1330605251571387),
    FX16_CONST(-0.99090263542778), FX16_CONST(0.13458070850712597),
    FX16_CONST(-0.9906950254426646), FX16_CONST(0.13610057517570617),
    FX16_CONST(-0.990485084256457), FX16_CONST(0.13762012158648618),
    FX16_CONST(-0.9902728123631692), FX16_CONST(0.13913934416382562),
    FX16_CONST(-0.9900582102622971), FX16_CONST(0.1406582393328488),
    FX16_CONST(-0.9898412784588205), FX16_CONST(0.14217680351944778),
    FX16_CONST(-0.9896220174632009), FX16_CONST(0.14369503315029433),
    FX16_CONST(-0.9894004277913804), FX16_CONST(0.1452129246528475),
    FX16_CONST(-0.9891765099647809), FX16_CONST(0.14673047445536194),
    FX16_CONST(-0.9889502645103031), FX16_CONST(0.14824767898689553),
    FX16_CONST(-0.9887216919603238), FX16_CONST(0.14976453467732115),
    FX16_CONST(-0.9884907928526967), FX16_CONST(0.15128103795733),
    FX16_CONST(-0.9882575677307495), FX16_CONST(0.15279718525844338),
    FX16_CONST(-0.9880220171432835), FX16_CONST(0.15431297301302022),
    FX16_CONST(-0.9877841416445723), FX16_CONST(0.15582839765426462),
    FX16_CONST(-0.9875439417943593), FX16_CONST(0.1573434556162378),
    FX16_CONST(-0.9873014181578584), FX16_CONST(0.15885814333386117),
    FX16_CONST(-0.9870565713057511), FX16_CONST(0.16037245724292815),
    FX16_CONST(-0.9868094018141854), FX16_CONST(0.16188639378011188),
    FX16_CONST(-0.9865599102647754), FX16_CONST(0.16339994938297342),
    FX16_CONST(-0.9863080972445988), FX16_CONST(0.1649131204899694),
    FX16_CONST(-0.9860539633461955), FX16_CONST(0.16642590354046374),
    FX16_CONST(-0.9857975091675675), FX16_CONST(0.16793829497473098),
    FX16_CONST(-0.9855387353121761), FX16_CONST(0.16945029123396793),
    FX16_CONST(-0.9852776423889412), FX16_CONST(0.17096188876030133),
    FX16_CONST(-0.98501423101224), FX16_CONST(0.17247308399679537),
    FX16_CONST(-0.9847485018019043), FX16_CONST(0.17398387338746338),
    FX16_CONST(-0.9844804553832209), FX16_CONST(0.17549425337727115),
    FX16_CONST(-0.9842100923869291), FX16_CONST(0.17700422041214864),
    FX16_CONST(-0.9839374134492189), FX16_CONST(0.17851377093899756),
    FX16_CONST(-0.9836624192117303), FX16_CONST(0.1800229014056997),
    FX16_CONST(-0.9833851103215513), FX16_CONST(0.18153160826112447),
    FX16_CONST(-0.9831054874312164), FX16_CONST(0.1830398879551406),
    FX16_CONST(-0.9828235511987053), FX16_CONST(0.1845477369386194),
    FX16_CONST(-0.9825393022874412), FX16_CONST(0.1860551516634466),
    FX16_CONST(-0.9822527413662894), FX16_CONST(0.1875621285825297),
    FX16_CONST(-0.9819638691095554), FX16_CONST(0.1890686641498056),
    FX16_CONST(-0.9816726861969832), FX16_CONST(0.19057475482025232),
    FX16_CONST(-0.9813791933137547), FX16_CONST(0.19208039704989216),
    FX16_CONST(-0.9810833911504867), FX16_CONST(0.1935855872958035),
    FX16_CONST(-0.9807852804032304), FX16_CONST(0.1950903220161283),
    FX16_CONST(-0.9804848617734693), FX16_CONST(0.19659459767008042),
    FX16_CONST(-0.9801821359681175), FX16_CONST(0.19809841071795306),
    FX16_CONST(-0.9798771036995177), FX16_CONST(0.1996017576211306),
    FX16_CONST(-0.9795697656854406), FX16_CONST(0.2011046348420917),
    FX16_CONST(-0.979260122649082), FX16_CONST(0.20260703884442108),
    FX16_CONST(-0.9789481753190622), FX16_CONST(0.20410896609281698),
    FX16_CONST(-0.9786339244294233), FX16_CONST(0.20561041305309866),
    FX16_CONST(-0.9783173707196278), FX16_CONST(0.20711137619221812),
    FX16_CONST(-0.9779985149345571), FX16_CONST(0.2086118519782632),
    FX16_CONST(-0.97767735782451), FX16_CONST(0.2101118368804695),
    FX16_CONST(-0.9773539001452), FX16_CONST(0.2116113273692276),
    FX16_CONST(-0.9770281426577543), FX16_CONST(0.21311031991609156),
    FX16_CONST(-0.976700086128712), FX16_CONST(0.21460881099378626),
    FX16_CONST(-0.9763697313300213), FX16_CONST(0.21610679707621913),
    FX16_CONST(-0.9760370790390391), FX16_CONST(0.21760427463848342),
    FX16_CONST(-0.9757021300385286), FX16_CONST(0.21910124015686974),
    FX16_CONST(-0.975364885116657), FX16_CONST(0.22059769010887362),
    FX16_CONST(-0.9750253450669942), FX16_CONST(0.22209362097320293),
    FX16_CONST(-0.9746835106885108), FX16_CONST(0.22358902922978954),
    FX16_CONST(-0.974339382785576), FX16_CONST(0.22508391135979255),
    FX16_CONST(-0.973992962167956), FX16_CONST(0.22657826384560986),
    FX16_CONST(-0.9736442496508119), FX16_CONST(0.22807208317088576),
    FX16_CONST(-0.9732932460546981), FX16_CONST(0.22956536582051906),
    FX16_CONST(-0.9729399522055603), FX16_CONST(0.23105810828067058),
    FX16_CONST(-0.9725843689347323), FX16_CONST(0.23255030703877488),
    FX16_CONST(-0.9722264970789364), FX16_CONST(0.2340419585835432),
    FX16_CONST(-0.9718663374802794), FX16_CONST(0.23553305940497546),
    FX16_CONST(-0.9715038909862518), FX16_CONST(0.2370236059943673),
    FX16_CONST(-0.9711391584497253), FX16_CONST(0.23851359484431783),
    FX16_CONST(-0.9707721407289505), FX16_CONST(0.24000302244874103),
    FX16_CONST(-0.9704028386875555), FX16_CONST(0.24149188530286905),
    FX16_CONST(-0.970031253194544), FX16_CONST(0.24298017990326376),
    FX16_CONST(-0.9696573851242924), FX16_CONST(0.24446790274782418),
    FX16_CONST(-0.9692812353565484), FX16_CONST(0.2459550503357948),
    FX16_CONST(-0.968902804776429), FX16_CONST(0.24744161916777277),
    FX16_CONST(-0.9685220942744174), FX16_CONST(0.2489276057457198),
    FX16_CONST(-0.9681391047463624), FX16_CONST(0.25041300657296506),
    FX16_CONST(-0.9677538370934755), FX16_CONST(0.2518978181542169),
    FX16_CONST(-0.9673662922223285), FX16_CONST(0.25338203699557027),
    FX16_CONST(-0.9669764710448523), FX16_CONST(0.25486565960451396),
    FX16_CONST(-0.9665843744783332), FX16_CONST(0.25634868248994247),
    FX16_CONST(-0.9661900034454126), FX16_CONST(0.2578311021621587),
    FX16_CONST(-0.9657933588740837), FX16_CONST(0.2593129151328861),
    FX16_CONST(-0.9653944416976894), FX16_CONST(0.2607941179152755),
    FX16_CONST(-0.9649932528549203), FX16_CONST(0.2622747070239138),
    FX16_CONST(-0.9645897932898129), FX16_CONST(0.26375467897483085),
    FX16_CONST(-0.9641840639517459), FX16_CONST(0.26523403028551146),
    FX16_CONST(-0.96377606579544), FX16_CONST(0.2667127574748982),
    FX16_CONST(-0.963365799780954), FX16_CONST(0.2681908570634031),
    FX16_CONST(-0.9629532668736839), FX16_CONST(0.2696683255729152),
    FX16_CONST(-0.9625384680443594), FX16_CONST(0.2711451595268074),
    FX16_CONST(-0.9621214042690417), FX16_CONST(0.27262135544994853),
    FX16_CONST(-0.9617020765291227), FX16_CONST(0.2740969098687061),
    FX16_CONST(-0.9612804858113206), FX16_CONST(0.27557181931095803),
    FX16_CONST(-0.9608566331076797), FX16_CONST(0.27704608030609995),
    FX16_CONST(-0.9604305194155658), FX16_CONST(0.2785196893850533),
    FX16_CONST(-0.9600021457376661), FX16_CONST(0.2799926430802727),
    FX16_CONST(-0.9595715130819846), FX16_CONST(0.2814649379257576),
    FX16_CONST(-0.959138622461842), FX16_CONST(0.2829365704570551),
    FX16_CONST(-0.9587034748958716), FX16_CONST(0.28440753721127177),
    FX16_CONST(-0.9582660714080177), FX16_CONST(0.28587783472708067),
    FX16_CONST(-0.957826413027533), FX16_CONST(0.2873474595447289),
    FX16_CONST(-0.9573845007889761), FX16_CONST(0.28881640820604904),
    FX16_CONST(-0.9569403357322089), FX16_CONST(0.29028467725446205),
    FX16_CONST(-0.9564939189023951), FX16_CONST(0.29175226323498915),
    FX16_CONST(-0.9560452513499964), FX16_CONST(0.2932191626942587),
    FX16_CONST(-0.955594334130771), FX16_CONST(0.2946853721805145),
    FX16_CONST(-0.9551411683057709), FX16_CONST(0.2961508882436233),
    FX16_CONST(-0.9546857549413384), FX16_CONST(0.29761570743508586),
    FX16_CONST(-0.9542280951091057), FX16_CONST(0.29907982630804025),
    FX16_CONST(-0.9537681898859903), FX16_CONST(0.3005432414172734),
    FX16_CONST(-0.9533060403541939), FX16_CONST(0.30200594931922814),
    FX16_CONST(-0.9528416476011988), FX16_CONST(0.3034679465720107),
    FX16_CONST(-0.952375012719766), FX16_CONST(0.304929229735402),
    FX16_CONST(-0.9519061368079325), FX16_CONST(0.30638979537086064),
    FX16_CONST(-0.9514350209690084), FX16_CONST(0.30784964004153476),
    FX16_CONST(-0.9509616663115751), FX16_CONST(0.3093087603122687),
    FX16_CONST(-0.9504860739494817), FX16_CONST(0.31076715274961164),
    FX16_CONST(-0.9500082450018432), FX16_CONST(0.3122248139218244),
    FX16_CONST(-0.9495281805930368), FX16_CONST(0.31368174039889113),
    FX16_CONST(-0.9490458818527007), FX16_CONST(0.31513792875252217),
    FX16_CONST(-0.9485613499157303), FX16_CONST(0.3165933755561658),
    FX16_CONST(-0.9480745859222762), FX16_CONST(0.318048077385015),
    FX16_CONST(-0.9475855910177413), FX16_CONST(0.3195020308160151),
    FX16_CONST(-0.9470943663527773), FX16_CONST(0.32095523242787477),
    FX16_CONST(-0.9466009130832836), FX16_CONST(0.3224076788010696),
    FX16_CONST(-0.9461052323704034), FX16_CONST(0.32385936651785274),
    FX16_CONST(-0.9456073253805213), FX16_CONST(0.3253102921622629),
    FX16_CONST(-0.9451071932852605), FX16_CONST(0.32676045232013196),
    FX16_CONST(-0.9446048372614805), FX16_CONST(0.328209843579092),
    FX16_CONST(-0.9441002584912728), FX16_CONST(0.32965846252858716),
    FX16_CONST(-0.9435934581619604), FX16_CONST(0.3311063057598762),
    FX16_CONST(-0.9430844374660935), FX16_CONST(0.33255336986604417),
    FX16_CONST(-0.9425731976014469), FX16_CONST(0.3339996514420095),
    FX16_CONST(-0.9420597397710175), FX16_CONST(0.33544514708453105),
    FX16_CONST(-0.9415440651830209), FX16_CONST(0.3368898533922196),
    FX16_CONST(-0.9410261750508894), FX16_CONST(0.33833376696554085),
    FX16_CONST(-0.9405060705932684), FX16_CONST(0.33977688440682674),
    FX16_CONST(-0.9399837530340139), FX16_CONST(0.3412192023202824),
    FX16_CONST(-0.9394592236021898), FX16_CONST(0.34266071731199454),
    FX16_CONST(-0.9389324835320647), FX16_CONST(0.3441014259899383),
    FX16_CONST(-0.9384035340631083), FX16_CONST(0.3455413249639887),
    FX16_CONST(-0.9378723764399899), FX16_CONST(0.34698041084592346),
    FX16_CONST(-0.937339011912575), FX16_CONST(0.3484186802494345),
    FX16_CONST(-0.9368034417359216), FX16_CONST(0.34985612979013503),
    FX16_CONST(-0.9362656671702785), FX16_CONST(0.35129275608556654),
    FX16_CONST(-0.9357256894810805), FX16_CONST(0.3527285557552103),
    FX16_CONST(-0.9351835099389477), FX16_CONST(0.35416352542049007),
    FX16_CONST(-0.9346391298196808), FX16_CONST(0.35559766170478374),
    FX16_CONST(-0.9340925504042589), FX16_CONST(0.35703096123343003),
    FX16_CONST(-0.9335437729788362), FX16_CONST(0.3584634206337367),
    FX16_CONST(-0.9329927988347391), FX16_CONST(0.3598950365349876),
    FX16_CONST(-0.9324396292684626), FX16_CONST(0.3613258055684539),
    FX16_CONST(-0.9318842655816681), FX16_CONST(0.362755724367397),
    FX16_CONST(-0.9313267090811805), FX16_CONST(0.36418478956707984),
    FX16_CONST(-0.9307669610789837), FX16_CONST(0.36561299780477396),
    FX16_CONST(-0.9302050228922193), FX16_CONST(0.36704034571976657),
    FX16_CONST(-0.9296408958431814), FX16_CONST(0.3684668299533719),
    FX16_CONST(-0.9290745812593159), FX16_CONST(0.3698924471489338),
    FX16_CONST(-0.9285060804732156), FX16_CONST(0.3713171939518374),
    FX16_CONST(-0.9279353948226179), FX16_CONST(0.3727410670095158),
    FX16_CONST(-0.927362525650401), FX16_CONST(0.37416406297145816),
    FX16_CONST(-0.926787474304582), FX16_CONST(0.3755861784892167),
    FX16_CONST(-0.9262102421383115), FX16_CONST(0.37700741021641787),
    FX16_CONST(-0.9256308305098728), FX16_CONST(0.37842775480876534),
    FX16_CONST(-0.9250492407826776), FX16_CONST(0.3798472089240511),
    FX16_CONST(-0.9244654743252626), FX16_CONST(0.38126576922216243),
    FX16_CONST(-0.9238795325112866), FX16_CONST(0.38268343236509),
    FX16_CONST(-0.9232914167195279), FX16_CONST(0.3841001950169346),
    FX16_CONST(-0.9227011283338787), FX16_CONST(0.38551605384391857),
    FX16_CONST(-0.9221086687433452), FX16_CONST(0.38693100551438847),
    FX16_CONST(-0.9215140393420419), FX16_CONST(0.3883450466988263),
    FX16_CONST(-0.9209172415291894), FX16_CONST(0.38975817406985663),
    FX16_CONST(-0.9203182767091108), FX16_CONST(0.39117038430225337),
    FX16_CONST(-0.9197171462912275), FX16_CONST(0.39258167407295114),
    FX16_CONST(-0.9191138516900579), FX16_CONST(0.3939920400610479),
    FX16_CONST(-0.9185083943252123), FX16_CONST(0.39540147894781624),
    FX16_CONST(-0.9179007756213904), FX16_CONST(0.3968099874167104),
    FX16_CONST(-0.9172909970083778), FX16_CONST(0.39821756215337384),
    FX16_CONST(-0.9166790599210428), FX16_CONST(0.3996241998456464),
    FX16_CONST(-0.9160649657993318), FX16_CONST(0.40102989718357535),
    FX16_CONST(-0.9154487160882678), FX16_CONST(0.4024346508594183),
    FX16_CONST(-0.9148303122379462), FX16_CONST(0.40383845756765413),
    FX16_CONST(-0.9142097557035306), FX16_CONST(0.40524131400499),
    FX16_CONST(-0.913587047945251), FX16_CONST(0.4066432168703685),
    FX16_CONST(-0.9129621904283983), FX16_CONST(0.4080441628649783),
    FX16_CONST(-0.9123351846233229), FX16_CONST(0.40944414869225737),
    FX16_CONST(-0.9117060320054299), FX16_CONST(0.41084317105790386),
    FX16_CONST(-0.9110747340551762), FX16_CONST(0.41224122666988294),
    FX16_CONST(-0.9104412922580671), FX16_CONST(0.4136383122384348),
    FX16_CONST(-0.9098057081046524), FX16_CONST(0.4150344244760812),
    FX16_CONST(-0.9091679830905225), FX16_CONST(0.4164295600976369),
    FX16_CONST(-0.9085281187163062), FX16_CONST(0.41782371582021216),
    FX16_CONST(-0.9078861164876663), FX16_CONST(0.41921688836322396),
    FX16_CONST(-0.9072419779152958), FX16_CONST(0.4206090744484027),
    FX16_CONST(-0.9065957045149156), FX16_CONST(0.4220002707997992),
    FX16_CONST(-0.9059472978072687), FX16_CONST(0.42339047414379566),
    FX16_CONST(-0.9052967593181189), FX16_CONST(0.4247796812091086),
    FX16_CONST(-0.9046440905782462), FX16_CONST(0.42616788872679956),
    FX16_CONST(-0.9039892931234433), FX16_CONST(0.42755509343028214),
    FX16_CONST(-0.9033323684945117), FX16_CONST(0.4289412920553297),
    FX16_CONST(-0.902673318237259), FX16_CONST(0.43032648134008217),
    FX16_CONST(-0.9020121439024933), FX16_CONST(0.431710658025057),
    FX16_CONST(-0.9013488470460221), FX16_CONST(0.4330938188531518),
    FX16_CONST(-0.9006834292286469), FX16_CONST(0.4344759605696557),
    FX16_CONST(-0.9000158920161602), FX16_CONST(0.43585707992225564),
    FX16_CONST(-0.8993462369793418), FX16_CONST(0.4372371736610436),
    FX16_CONST(-0.898674465693954), FX16_CONST(0.43861623853852727),
    FX16_CONST(-0.89800057974074), FX16_CONST(0.43999427130963303),
    FX16_CONST(-0.8973245807054183), FX16_CONST(0.4413712687317166),
    FX16_CONST(-0.8966464701786802), FX16_CONST(0.4427472275645701),
    FX16_CONST(-0.895966249756185), FX16_CONST(0.4441221445704294),
    FX16_CONST(-0.8952839210385577), FX16_CONST(0.4454960165139813),
    FX16_CONST(-0.8945994856313828), FX16_CONST(0.4468688401623739),
    FX16_CONST(-0.8939129451452034), FX16_CONST(0.4482406122852198),
    FX16_CONST(-0.8932243011955153), FX16_CONST(0.4496113296546066),
    FX16_CONST(-0.8925335554027646), FX16_CONST(0.45098098904510403),
    FX16_CONST(-0.891840709392343), FX16_CONST(0.4523495872337704),
    FX16_CONST(-0.8911457647945834), FX16_CONST(0.4537171210001635),
    FX16_CONST(-0.890448723244758), FX16_CONST(0.4550835871263436),
    FX16_CONST(-0.8897495863830729), FX16_CONST(0.45644898239688386),
    FX16_CONST(-0.8890483558546646), FX16_CONST(0.4578133035988773),
    FX16_CONST(-0.8883450333095962), FX16_CONST(0.45917654752194437),
    FX16_CONST(-0.8876396204028542), FX16_CONST(0.46053871095823956),
    FX16_CONST(-0.8869321187943423), FX16_CONST(0.46189979070246245),
    FX16_CONST(-0.8862225301488807), FX16_CONST(0.46325978355186004),
    FX16_CONST(-0.8855108561362), FX16_CONST(0.4646186863062378),
    FX16_CONST(-0.8847970984309377), FX16_CONST(0.4659764957679663),
    FX16_CONST(-0.8840812587126353), FX16_CONST(0.4673332087419879),
    FX16_CONST(-0.8833633386657318), FX16_CONST(0.46868882203582757),
    FX16_CONST(-0.8826433399795629), FX16_CONST(0.4700433324595954),
    FX16_CONST(-0.881921264348355), FX16_CONST(0.4713967368259976),
    FX16_CONST(-0.881197113471222), FX16_CONST(0.47274903195034285),
    FX16_CONST(-0.8804708890521606), FX16_CONST(0.4741002146505502),
    FX16_CONST(-0.8797425928000476), FX16_CONST(0.4754502817471554),
    FX16_CONST(-0.8790122264286336), FX16_CONST(0.4767992300633218),
    FX16_CONST(-0.8782797916565416), FX16_CONST(0.4781470564248429),
    FX16_CONST(-0.8775452902072612), FX16_CONST(0.479493757660153),
    FX16_CONST(-0.8768087238091457), FX16_CONST(0.48083933060033407),
    FX16_CONST(-0.8760700941954069), FX16_CONST(0.4821837720791222),
    FX16_CONST(-0.875329403104111), FX16_CONST(0.48352707893291835),
    FX16_CONST(-0.8745866522781762), FX16_CONST(0.4848692480007909),
    FX16_CONST(-0.8738418434653669), FX16_CONST(0.4862102761244863),
    FX16_CONST(-0.8730949784182901), FX16_CONST(0.487550160148436),
    FX16_CONST(-0.8723460588943914), FX16_CONST(0.4888888969197634),
    FX16_CONST(-0.8715950866559513), FX16_CONST(0.4902264832882907),
    FX16_CONST(-0.8708420634700791), FX16_CONST(0.4915629161065497),
    FX16_CONST(-0.8700869911087115), FX16_CONST(0.49289819222978387),
    FX16_CONST(-0.8693298713486067), FX16_CONST(0.49423230851595973),
    FX16_CONST(-0.8685707059713408), FX16_CONST(0.49556526182577265),
    FX16_CONST(-0.8678094967633035), FX16_CONST(0.496897049022654),
    FX16_CONST(-0.8670462455156929), FX16_CONST(0.4982276669727815),
    FX16_CONST(-0.8662809540245131), FX16_CONST(0.49955711254508167),
    FX16_CONST(-0.8655136240905691), FX16_CONST(0.5008853826112407),
    FX16_CONST(-0.8647442575194624), FX16_CONST(0.5022124740457108),
    FX16_CONST(-0.8639728561215866), FX16_CONST(0.5035383837257178),
    FX16_CONST(-0.8631994217121244), FX16_CONST(0.5048631085312671),
    FX16_CONST(-0.8624239561110407), FX16_CONST(0.506186645345155),
    FX16_CONST(-0.8616464611430814), FX16_CONST(0.5075089910529706),
    FX16_CONST(-0.8608669386377673), FX16_CONST(0.508830142543107),
    FX16_CONST(-0.8600853904293901), FX16_CONST(0.5101500967067669),
    FX16_CONST(-0.8593018183570087), FX16_CONST(0.5114688504379699),
    FX16_CONST(-0.858516224264443), FX16_CONST(0.5127864006335626),
    FX16_CONST(-0.8577286100002722), FX16_CONST(0.5141027441932216),
    FX16_CONST(-0.8569389774178288), FX16_CONST(0.5154178780194629),
    FX16_CONST(-0.8561473283751945), FX16_CONST(0.5167317990176499),
    FX16_CONST(-0.8553536647351959), FX16_CONST(0.5180445040959996),
    FX16_CONST(-0.8545579883654008), FX16_CONST(0.5193559901655892),
    FX16_CONST(-0.8537603011381115), FX16_CONST(0.5206662541403668),
    FX16_CONST(-0.8529606049303637), FX16_CONST(0.5219752929371542),
    FX16_CONST(-0.8521589016239198), FX16_CONST(0.5232831034756564),
    FX16_CONST(-0.8513551931052651), FX16_CONST(0.5245896826784691),
    FX16_CONST(-0.8505494812656038), FX16_CONST(0.5258950274710842),
    FX16_CONST(-0.8497417680008528), FX16_CONST(0.527199134781901),
    FX16_CONST(-0.8489320552116397), FX16_CONST(0.5285020015422283),
    FX16_CONST(-0.8481203448032973), FX16_CONST(0.5298036246862946),
    FX16_CONST(-0.8473066386858583), FX16_CONST(0.531104001151255),
    FX16_CONST(-0.8464909387740519), FX16_CONST(0.5324031278771981),
    FX16_CONST(-0.8456732469872993), FX16_CONST(0.5337010018071525),
    FX16_CONST(-0.8448535652497072), FX16_CONST(0.5349976198870969),
    FX16_CONST(-0.8440318954900665), FX16_CONST(0.536292979065963),
    FX16_CONST(-0.8432082396418454), FX16_CONST(0.5375870762956455),
    FX16_CONST(-0.8423825996431858), FX16_CONST(0.5388799085310085),
    FX16_CONST(-0.8415549774368988), FX16_CONST(0.5401714727298924),
    FX16_CONST(-0.8407253749704583), FX16_CONST(0.5414617658531231),
    FX16_CONST(-0.8398937941959996), FX16_CONST(0.5427507848645157),
    FX16_CONST(-0.8390602370703127), FX16_CONST(0.5440385267308838),
    FX16_CONST(-0.838224705554838), FX16_CONST(0.5453249884220465),
    FX16_CONST(-0.8373872016156618), FX16_CONST(0.5466101669108351),
    FX16_CONST(-0.8365477272235122), FX16_CONST(0.5478940591730997),
    FX16_CONST(-0.8357062843537528), FX16_CONST(0.5491766621877194),
    FX16_CONST(-0.8348628749863801), FX16_CONST(0.5504579729366046),
    FX16_CONST(-0.8340175011060181), FX16_CONST(0.5517379884047073),
    FX16_CONST(-0.8331701647019131), FX16_CONST(0.5530167055800277),
    FX16_CONST(-0.83232086776793), FX16_CONST(0.5542941214536197),
    FX16_CONST(-0.8314696123025455), FX16_CONST(0.5555702330196018),
    FX16_CONST(-0.8306164003088464), FX16_CONST(0.5568450372751599),
    FX16_CONST(-0.8297612337945232), FX16_CONST(0.558118531220556),
    FX16_CONST(-0.8289041147718649), FX16_CONST(0.5593907118591361),
    FX16_CONST(-0.8280450452577557), FX16_CONST(0.5606615761973361),
    FX16_CONST(-0.8271840272736694), FX16_CONST(0.561931121244689),
    FX16_CONST(-0.8263210628456636), FX16_CONST(0.5631993440138339),
    FX16_CONST(-0.8254561540043777), FX16_CONST(0.5644662415205193),
    FX16_CONST(-0.8245893027850253), FX16_CONST(0.5657318107836131),
    FX16_CONST(-0.8237205112273913), FX16_CONST(0.5669960488251088),
    FX16_CONST(-0.8228497813758266), FX16_CONST(0.568258952670131),
    FX16_CONST(-0.8219771152792418), FX16_CONST(0.5695205193469468),
    FX16_CONST(-0.8211025149911049), FX16_CONST(0.570780745886967),
    FX16_CONST(-0.8202259825694347), FX16_CONST(0.5720396293247569),
    FX16_CONST(-0.8193475200767969), FX16_CONST(0.5732971666980422),
    FX16_CONST(-0.8184671295802985), FX16_CONST(0.574553355047716),
    FX16_CONST(-0.8175848131515839), FX16_CONST(0.5758081914178449),
    FX16_CONST(-0.816700572866828), FX16_CONST(0.5770616728556792),
    FX16_CONST(-0.8158144108067339), FX16_CONST(0.5783137964116554),
    FX16_CONST(-0.8149263290565266), FX16_CONST(0.5795645591394057),
    FX16_CONST(-0.8140363297059483), FX16_CONST(0.5808139580957646),
    FX16_CONST(-0.8131444148492539), FX16_CONST(0.5820619903407751),
    FX16_CONST(-0.8122505865852042), FX16_CONST(0.583308652937698),
    FX16_CONST(-0.811354847017064), FX16_CONST(0.5845539429530151),
    FX16_CONST(-0.8104571982525949), FX16_CONST(0.5857978574564388),
    FX16_CONST(-0.8095576424040513), FX16_CONST(0.5870403935209181),
    FX16_CONST(-0.8086561815881749), FX16_CONST(0.5882815482226454),
    FX16_CONST(-0.8077528179261906), FX16_CONST(0.5895213186410635),
    FX16_CONST(-0.8068475535437994), FX16_CONST(0.5907597018588739),
    FX16_CONST(-0.8059403905711764), FX16_CONST(0.5919966949620408),
    FX16_CONST(-0.8050313311429637), FX16_CONST(0.5932322950397998),
    FX16_CONST(-0.8041203773982657), FX16_CONST(0.5944664991846645),
    FX16_CONST(-0.8032075314806453), FX16_CONST(0.5956993044924328),
    FX16_CONST(-0.8022927955381159), FX16_CONST(0.5969307080621962),
    FX16_CONST(-0.8013761717231404), FX16_CONST(0.598160706996342),
    FX16_CONST(-0.8004576621926228), FX16_CONST(0.5993892984005644),
    FX16_CONST(-0.799537269107905), FX16_CONST(0.600616479383869),
    FX16_CONST(-0.7986149946347607), FX16_CONST(0.6018422470585802),
    FX16_CONST(-0.7976908409433914), FX16_CONST(0.6030665985403478),
    FX16_CONST(-0.7967648102084189), FX16_CONST(0.6042895309481557),
    FX16_CONST(-0.7958369046088837), FX16_CONST(0.6055110414043253),
    FX16_CONST(-0.794907126328237), FX16_CONST(0.6067311270345245),
    FX16_CONST(-0.7939754775543371), FX16_CONST(0.6079497849677737),
    FX16_CONST(-0.7930419604794441), FX16_CONST(0.6091670123364527),
    FX16_CONST(-0.7921065773002126), FX16_CONST(0.6103828062763091),
    FX16_CONST(-0.7911693302176903), FX16_CONST(0.6115971639264617),
    FX16_CONST(-0.7902302214373101), FX16_CONST(0.6128100824294096),
    FX16_CONST(-0.7892892531688857), FX16_CONST(0.6140215589310385),
    FX16_CONST(-0.7883464276266061), FX16_CONST(0.615231590580627),
    FX16_CONST(-0.7874017470290317), FX16_CONST(0.6164401745308532),
    FX16_CONST(-0.786455213599086), FX16_CONST(0.6176473079378036),
    FX16_CONST(-0.785506829564054), FX16_CONST(0.6188529879609762),
    FX16_CONST(-0.7845565971555752), FX16_CONST(0.6200572117632892),
    FX16_CONST(-0.7836045186096382), FX16_CONST(0.6212599765110877),
    FX16_CONST(-0.7826505961665761), FX16_CONST(0.6224612793741495),
    FX16_CONST(-0.7816948320710597), FX16_CONST(0.6236611175256942),
    FX16_CONST(-0.7807372285720947), FX16_CONST(0.6248594881423861),
    FX16_CONST(-0.7797777879230146), FX16_CONST(0.6260563884043434),
    FX16_CONST(-0.7788165123814759), FX16_CONST(0.6272518154951442),
    FX16_CONST(-0.7778534042094529), FX16_CONST(0.6284457666018328),
    FX16_CONST(-0.7768884656732328), FX16_CONST(0.6296382389149267),
    FX16_CONST(-0.7759216990434078), FX16_CONST(0.6308292296284242),
    FX16_CONST(-0.774953106594874), FX16_CONST(0.6320187359398088),
    FX16_CONST(-0.7739826906068228), FX16_CONST(0.6332067550500572),
    FX16_CONST(-0.7730104533627369), FX16_CONST(0.6343932841636456),
    FX16_CONST(-0.7720363971503849), FX16_CONST(0.6355783204885557),
    FX16_CONST(-0.771060524261814), FX16_CONST(0.6367618612362839),
    FX16_CONST(-0.7700828369933481), FX16_CONST(0.6379439036218438),
    FX16_CONST(-0.7691033376455797), FX16_CONST(0.6391244448637756),
    FX16_CONST(-0.7681220285233654), FX16_CONST(0.6403034821841517),
    FX16_CONST(-0.7671389119358203), FX16_CONST(0.6414810128085833),
    FX16_CONST(-0.7661539901963133), FX16_CONST(0.6426570339662265),
    FX16_CONST(-0.7651672656224592), FX16_CONST(0.6438315428897912),
    FX16_CONST(-0.7641787405361168), FX16_CONST(0.6450045368155438),
    FX16_CONST(-0.7631884172633813), FX16_CONST(0.6461760129833163),
    FX16_CONST(-0.7621962981345789), FX16_CONST(0.6473459686365122),
    FX16_CONST(-0.7612023854842622), FX16_CONST(0.648514401022112),
    FX16_CONST(-0.7602066816512026), FX16_CONST(0.6496813073906829),
    FX16_CONST(-0.7592091889783882), FX16_CONST(0.6508466849963808),
    FX16_CONST(-0.7582099098130154), FX16_CONST(0.6520105310969595),
    FX16_CONST(-0.7572088465064846), FX16_CONST(0.6531728429537768),
    FX16_CONST(-0.7562060014143943), FX16_CONST(0.6543336178318007),
    FX16_CONST(-0.7552013768965369), FX16_CONST(0.655492852999615),
    FX16_CONST(-0.7541949753168894), FX16_CONST(0.6566505457294287),
    FX16_CONST(-0.7531867990436126), FX16_CONST(0.6578066932970785),
    FX16_CONST(-0.7521768504490427), FX16_CONST(0.6589612929820373),
    FX16_CONST(-0.7511651319096864), FX16_CONST(0.6601143420674206),
    FX16_CONST(-0.7501516458062154), FX16_CONST(0.6612658378399917),
    FX16_CONST(-0.7491363945234596), FX16_CONST(0.6624157775901715),
    FX16_CONST(-0.7481193804504037), FX16_CONST(0.6635641586120395),
    FX16_CONST(-0.7471006059801802), FX16_CONST(0.6647109782033448),
    FX16_CONST(-0.7460800735100638), FX16_CONST(0.6658562336655097),
    FX16_CONST(-0.7450577854414658), FX16_CONST(0.6669999223036377),
    FX16_CONST(-0.7440337441799296), FX16_CONST(0.6681420414265181),
    FX16_CONST(-0.7430079521351219), FX16_CONST(0.6692825883466358),
    FX16_CONST(-0.7419804117208312), FX16_CONST(0.670421560380173),
    FX16_CONST(-0.7409511253549591), FX16_CONST(0.6715589548470183),
    FX16_CONST(-0.7399200954595161), FX16_CONST(0.672694769070773),
    FX16_CONST(-0.7388873244606156), FX16_CONST(0.6738290003787556),
    FX16_CONST(-0.7378528147884663), FX16_CONST(0.6749616461020117),
    FX16_CONST(-0.7368165688773701), FX16_CONST(0.6760927035753157),
    FX16_CONST(-0.7357785891657136), FX16_CONST(0.6772221701371803),
    FX16_CONST(-0.7347388780959634), FX16_CONST(0.6783500431298615),
    FX16_CONST(-0.7336974381146601), FX16_CONST(0.6794763198993652),
    FX16_CONST(-0.7326542716724131), FX16_CONST(0.6806009977954527),
    FX16_CONST(-0.7316093812238929), FX16_CONST(0.6817240741716495),
    FX16_CONST(-0.7305627692278277), FX16_CONST(0.6828455463852479),
    FX16_CONST(-0.729514438146997), FX16_CONST(0.6839654117973154),
    FX16_CONST(-0.7284643904482251), FX16_CONST(0.6850836677727005),
    FX16_CONST(-0.7274126286023762), FX16_CONST(0.6862003116800381),
    FX16_CONST(-0.7263591550843463), FX16_CONST(0.6873153408917587),
    FX16_CONST(-0.725303972373061), FX16_CONST(0.6884287527840902),
    FX16_CONST(-0.724247082951467), FX16_CONST(0.6895405447370668),
    FX16_CONST(-0.7231884893065273), FX16_CONST(0.6906507141345346),
    FX16_CONST(-0.7221281939292151), FX16_CONST(0.6917592583641579),
    FX16_CONST(-0.7210661993145084), FX16_CONST(0.6928661748174243),
    FX16_CONST(-0.7200025079613819), FX16_CONST(0.6939714608896537),
    FX16_CONST(-0.7189371223728046), FX16_CONST(0.6950751139800007),
    FX16_CONST(-0.7178700450557318), FX16_CONST(0.6961771314914629),
    FX16_CONST(-0.7168012785210994), FX16_CONST(0.6972775108308866),
    FX16_CONST(-0.715730825283819), FX16_CONST(0.6983762494089724),
    FX16_CONST(-0.7146586878627694), FX16_CONST(0.6994733446402834),
    FX16_CONST(-0.7135848687807937), FX16_CONST(0.7005687939432481),
    FX16_CONST(-0.7125093705646924), FX16_CONST(0.7016625947401685),
    FX16_CONST(-0.7114321957452164), FX16_CONST(0.7027547444572253),
    FX16_CONST(-0.7103533468570622), FX16_CONST(0.703845240524485),
    FX16_CONST(-0.709272826438866), FX16_CONST(0.7049340803759045),
    FX16_CONST(-0.7081906370331956), FX16_CONST(0.7060212614493395),
    FX16_CONST(-0.7071067811865477), FX16_CONST(0.7071067811865474),
    FX16_CONST(-0.7060212614493399), FX16_CONST(0.7081906370331953),
    FX16_CONST(-0.7049340803759048), FX16_CONST(0.7092728264388657),
    FX16_CONST(-0.7038452405244854), FX16_CONST(0.7103533468570619),
    FX16_CONST(-0.7027547444572256), FX16_CONST(0.7114321957452161),
    FX16_CONST(-0.7016625947401687), FX16_CONST(0.7125093705646921),
    FX16_CONST(-0.7005687939432484), FX16_CONST(0.7135848687807935),
    FX16_CONST(-0.6994733446402838), FX16_CONST(0.7146586878627691),
    FX16_CONST(-0.6983762494089727), FX16_CONST(0.7157308252838188),
    FX16_CONST(-0.697277510830887), FX16_CONST(0.7168012785210991),
    FX16_CONST(-0.6961771314914632), FX16_CONST(0.7178700450557315),
    FX16_CONST(-0.695075113980001), FX16_CONST(0.7189371223728043),
    FX16_CONST(-0.693971460889654), FX16_CONST(0.7200025079613817),
    FX16_CONST(-0.6928661748174246), FX16_CONST(0.7210661993145082),
    FX16_CONST(-0.6917592583641582), FX16_CONST(0.7221281939292149),
    FX16_CONST(-0.6906507141345349), FX16_CONST(0.7231884893065271),
    FX16_CONST(-0.6895405447370672), FX16_CONST(0.7242470829514667),
    FX16_CONST(-0.6884287527840905), FX16_CONST(0.7253039723730607),
    FX16_CONST(-0.687315340891759), FX16_CONST(0.726359155084346),
    FX16_CONST(-0.6862003116800385), FX16_CONST(0.7274126286023759),
    FX16_CONST(-0.6850836677727008), FX16_CONST(0.7284643904482249),
    FX16_CONST(-0.6839654117973157), FX16_CONST(0.7295144381469967),
    FX16_CONST(-0.6828455463852482), FX16_CONST(0.7305627692278274),
    FX16_CONST(-0.6817240741716498), FX16_CONST(0.7316093812238925),
    FX16_CONST(-0.680600997795453), FX16_CONST(0.7326542716724129),
    FX16_CONST(-0.6794763198993655), FX16_CONST(0.7336974381146598),
    FX16_CONST(-0.6783500431298618), FX16_CONST(0.7347388780959632),
    FX16_CONST(-0.6772221701371807), FX16_CONST(0.7357785891657133),
    FX16_CONST(-0.676092703575316), FX16_CONST(0.7368165688773698),
    FX16_CONST(-0.674961646102012), FX16_CONST(0.737852814788466),
    FX16_CONST(-0.6738290003787559), FX16_CONST(0.7388873244606152),
    FX16_CONST(-0.6726947690707733), FX16_CONST(0.7399200954595158),
    FX16_CONST(-0.6715589548470187), FX16_CONST(0.7409511253549589),
    FX16_CONST(-0.6704215603801733), FX16_CONST(0.7419804117208308),
    FX16_CONST(-0.6692825883466361), FX16_CONST(0.7430079521351216),
    FX16_CONST(-0.6681420414265185), FX16_CONST(0.7440337441799294),
    FX16_CONST(-0.666999922303638), FX16_CONST(0.7450577854414656),
    FX16_CONST(-0.6658562336655101), FX16_CONST(0.7460800735100634),
    FX16_CONST(-0.6647109782033451), FX16_CONST(0.7471006059801799),
    FX16_CONST(-0.6635641586120399), FX16_CONST(0.7481193804504035),
    FX16_CONST(-0.6624157775901718), FX16_CONST(0.7491363945234594),
    FX16_CONST(-0.661265837839992), FX16_CONST(0.7501516458062152),
    FX16_CONST(-0.6601143420674209), FX16_CONST(0.751165131909686),
    FX16_CONST(-0.6589612929820376), FX16_CONST(0.7521768504490425),
    FX16_CONST(-0.6578066932970789), FX16_CONST(0.7531867990436123),
    FX16_CONST(-0.656650545729429), FX16_CONST(0.7541949753168892),
    FX16_CONST(-0.6554928529996153), FX16_CONST(0.7552013768965365),
    FX16_CONST(-0.654333617831801), FX16_CONST(0.7562060014143941),
    FX16_CONST(-0.6531728429537771), FX16_CONST(0.7572088465064842),
    FX16_CONST(-0.6520105310969597), FX16_CONST(0.7582099098130151),
    FX16_CONST(-0.650846684996381), FX16_CONST(0.759209188978388),
    FX16_CONST(-0.6496813073906832), FX16_CONST(0.7602066816512024),
    FX16_CONST(-0.6485144010221123), FX16_CONST(0.7612023854842619),
    FX16_CONST(-0.6473459686365125), FX16_CONST(0.7621962981345786),
    FX16_CONST(-0.6461760129833166), FX16_CONST(0.763188417263381),
    FX16_CONST(-0.6450045368155441), FX16_CONST(0.7641787405361166),
    FX16_CONST(-0.6438315428897915), FX16_CONST(0.7651672656224588),
    FX16_CONST(-0.6426570339662268), FX16_CONST(0.7661539901963129),
    FX16_CONST(-0.6414810128085836), FX16_CONST(0.76713891193582),
    FX16_CONST(-0.640303482184152), FX16_CONST(0.7681220285233651),
    FX16_CONST(-0.639124444863776), FX16_CONST(0.7691033376455795),
    FX16_CONST(-0.6379439036218442), FX16_CONST(0.7700828369933479),
    FX16_CONST(-0.6367618612362842), FX16_CONST(0.7710605242618138),
    FX16_CONST(-0.635578320488556), FX16_CONST(0.7720363971503846),
    FX16_CONST(-0.6343932841636459), FX16_CONST(0.7730104533627365),
    FX16_CONST(-0.6332067550500575), FX16_CONST(0.7739826906068226),
    FX16_CONST(-0.6320187359398092), FX16_CONST(0.7749531065948737),
    FX16_CONST(-0.6308292296284246), FX16_CONST(0.7759216990434076),
    FX16_CONST(-0.629638238914927), FX16_CONST(0.7768884656732326),
    FX16_CONST(-0.6284457666018332), FX16_CONST(0.7778534042094527),
    FX16_CONST(-0.6272518154951445), FX16_CONST(0.7788165123814756),
    FX16_CONST(-0.6260563884043437), FX16_CONST(0.7797777879230143),
    FX16_CONST(-0.6248594881423865), FX16_CONST(0.7807372285720944),
    FX16_CONST(-0.6236611175256945), FX16_CONST(0.7816948320710594),
    FX16_CONST(-0.6224612793741499), FX16_CONST(0.7826505961665758),
    FX16_CONST(-0.621259976511088), FX16_CONST(0.7836045186096379),
    FX16_CONST(-0.6200572117632894), FX16_CONST(0.784556597155575),
    FX16_CONST(-0.6188529879609765), FX16_CONST(0.7855068295640538),
    FX16_CONST(-0.617647307937804), FX16_CONST(0.7864552135990857),
    FX16_CONST(-0.6164401745308535), FX16_CONST(0.7874017470290314),
    FX16_CONST(-0.6152315905806274), FX16_CONST(0.7883464276266059),
    FX16_CONST(-0.6140215589310388), FX16_CONST(0.7892892531688854),
    FX16_CONST(-0.6128100824294099), FX16_CONST(0.7902302214373098),
    FX16_CONST(-0.611597163926462), FX16_CONST(0.7911693302176901),
    FX16_CONST(-0.6103828062763095), FX16_CONST(0.7921065773002124),
    FX16_CONST(-0.6091670123364531), FX16_CONST(0.7930419604794438),
    FX16_CONST(-0.6079497849677741), FX16_CONST(0.7939754775543368),
    FX16_CONST(-0.6067311270345248), FX16_CONST(0.7949071263282368),
    FX16_CONST(-0.6055110414043257), FX16_CONST(0.7958369046088833),
    FX16_CONST(-0.6042895309481561), FX16_CONST(0.7967648102084187),
    FX16_CONST(-0.6030665985403482), FX16_CONST(0.7976908409433912),
    FX16_CONST(-0.6018422470585806), FX16_CONST(0.7986149946347605),
    FX16_CONST(-0.6006164793838693), FX16_CONST(0.7995372691079048),
    FX16_CONST(-0.5993892984005648), FX16_CONST(0.8004576621926226),
    FX16_CONST(-0.5981607069963424), FX16_CONST(0.8013761717231401),
    FX16_CONST(-0.5969307080621965), FX16_CONST(0.8022927955381157),
    FX16_CONST(-0.5956993044924332), FX16_CONST(0.803207531480645),
    FX16_CONST(-0.5944664991846649), FX16_CONST(0.8041203773982655),
    FX16_CONST(-0.5932322950398001), FX16_CONST(0.8050313311429633),
    FX16_CONST(-0.5919966949620411), FX16_CONST(0.8059403905711762),
    FX16_CONST(-0.5907597018588743), FX16_CONST(0.8068475535437992),
    FX16_CONST(-0.5895213186410638), FX16_CONST(0.8077528179261904),
    FX16_CONST(-0.5882815482226458), FX16_CONST(0.8086561815881746),
    FX16_CONST(-0.5870403935209184), FX16_CONST(0.8095576424040509),
    FX16_CONST(-0.5857978574564391), FX16_CONST(0.8104571982525945),
    FX16_CONST(-0.5845539429530154), FX16_CONST(0.8113548470170636),
    FX16_CONST(-0.5833086529376983), FX16_CONST(0.8122505865852039),
    FX16_CONST(-0.5820619903407754), FX16_CONST(0.8131444148492536),
    FX16_CONST(-0.580813958095765), FX16_CONST(0.8140363297059481),
    FX16_CONST(-0.5795645591394061), FX16_CONST(0.8149263290565264),
    FX16_CONST(-0.5783137964116558), FX16_CONST(0.8158144108067337),
    FX16_CONST(-0.5770616728556796), FX16_CONST(0.8167005728668277),
    FX16_CONST(-0.5758081914178452), FX16_CONST(0.8175848131515837),
    FX16_CONST(-0.5745533550477163), FX16_CONST(0.8184671295802983),
    FX16_CONST(-0.5732971666980426), FX16_CONST(0.8193475200767967),
    FX16_CONST(-0.5720396293247574), FX16_CONST(0.8202259825694345),
    FX16_CONST(-0.5707807458869674), FX16_CONST(0.8211025149911046),
    FX16_CONST(-0.5695205193469471), FX16_CONST(0.8219771152792416),
    FX16_CONST(-0.5682589526701314), FX16_CONST(0.8228497813758264),
    FX16_CONST(-0.5669960488251091), FX16_CONST(0.8237205112273911),
    FX16_CONST(-0.5657318107836136), FX16_CONST(0.8245893027850251),
    FX16_CONST(-0.5644662415205196), FX16_CONST(0.8254561540043773),
    FX16_CONST(-0.5631993440138342), FX16_CONST(0.8263210628456634),
    FX16_CONST(-0.5619311212446894), FX16_CONST(0.8271840272736691),
    FX16_CONST(-0.5606615761973366), FX16_CONST(0.8280450452577554),
    FX16_CONST(-0.5593907118591365), FX16_CONST(0.8289041147718647),
    FX16_CONST(-0.5581185312205563), FX16_CONST(0.8297612337945228),
    FX16_CONST(-0.5568450372751602), FX16_CONST(0.8306164003088462),
    FX16_CONST(-0.5555702330196022), FX16_CONST(0.8314696123025452),
    FX16_CONST(-0.55429412145362), FX16_CONST(0.8323208677679297),
    FX16_CONST(-0.553016705580028), FX16_CONST(0.8331701647019129),
    FX16_CONST(-0.5517379884047078), FX16_CONST(0.8340175011060179),
    FX16_CONST(-0.550457972936605), FX16_CONST(0.8348628749863799),
    FX16_CONST(-0.5491766621877198), FX16_CONST(0.8357062843537525),
    FX16_CONST(-0.5478940591731001), FX16_CONST(0.836547727223512),
    FX16_CONST(-0.5466101669108354), FX16_CONST(0.8373872016156616),
    FX16_CONST(-0.5453249884220468), FX16_CONST(0.8382247055548377),
    FX16_CONST(-0.5440385267308842), FX16_CONST(0.8390602370703125),
    FX16_CONST(-0.542750784864516), FX16_CONST(0.8398937941959994),
    FX16_CONST(-0.5414617658531234), FX16_CONST(0.8407253749704581),
    FX16_CONST(-0.5401714727298927), FX16_CONST(0.8415549774368986),
    FX16_CONST(-0.5388799085310089), FX16_CONST(0.8423825996431855),
    FX16_CONST(-0.5375870762956458), FX16_CONST(0.8432082396418452),
    FX16_CONST(-0.5362929790659634), FX16_CONST(0.8440318954900663),
    FX16_CONST(-0.5349976198870973), FX16_CONST(0.844853565249707),
    FX16_CONST(-0.5337010018071529), FX16_CONST(0.8456732469872991),
    FX16_CONST(-0.5324031278771986), FX16_CONST(0.8464909387740517),
    FX16_CONST(-0.5311040011512553), FX16_CONST(0.8473066386858581),
    FX16_CONST(-0.5298036246862949), FX16_CONST(0.8481203448032971),
    FX16_CONST(-0.5285020015422286), FX16_CONST(0.8489320552116395),
    FX16_CONST(-0.5271991347819014), FX16_CONST(0.8497417680008524),
    FX16_CONST(-0.5258950274710845), FX16_CONST(0.8505494812656035),
    FX16_CONST(-0.5245896826784694), FX16_CONST(0.8513551931052649),
    FX16_CONST(-0.5232831034756568), FX16_CONST(0.8521589016239196),
    FX16_CONST(-0.5219752929371545), FX16_CONST(0.8529606049303635),
    FX16_CONST(-0.5206662541403673), FX16_CONST(0.8537603011381113),
    FX16_CONST(-0.5193559901655895), FX16_CONST(0.8545579883654005),
    FX16_CONST(-0.5180445040959999), FX16_CONST(0.8553536647351957),
    FX16_CONST(-0.5167317990176503), FX16_CONST(0.8561473283751942),
    FX16_CONST(-0.5154178780194633), FX16_CONST(0.8569389774178285),
    FX16_CONST(-0.5141027441932219), FX16_CONST(0.857728610000272),
    FX16_CONST(-0.512786400633563), FX16_CONST(0.8585162242644427),
    FX16_CONST(-0.5114688504379703), FX16_CONST(0.8593018183570085),
    FX16_CONST(-0.5101500967067673), FX16_CONST(0.8600853904293899),
    FX16_CONST(-0.5088301425431074), FX16_CONST(0.8608669386377671),
    FX16_CONST(-0.5075089910529711), FX16_CONST(0.8616464611430812),
    FX16_CONST(-0.5061866453451553), FX16_CONST(0.8624239561110405),
    FX16_CONST(-0.5048631085312675), FX16_CONST(0.8631994217121242),
    FX16_CONST(-0.5035383837257181), FX16_CONST(0.8639728561215864),
    FX16_CONST(-0.5022124740457112), FX16_CONST(0.8647442575194622),
    FX16_CONST(-0.500885382611241), FX16_CONST(0.8655136240905689),
    FX16_CONST(-0.499557112545082), FX16_CONST(0.8662809540245129),
    FX16_CONST(-0.49822766697278187), FX16_CONST(0.8670462455156926),
    FX16_CONST(-0.4968970490226544), FX16_CONST(0.8678094967633033),
    FX16_CONST(-0.49556526182577304), FX16_CONST(0.8685707059713406),
    FX16_CONST(-0.49423230851596006), FX16_CONST(0.8693298713486066),
    FX16_CONST(-0.49289819222978426), FX16_CONST(0.8700869911087113),
    FX16_CONST(-0.49156291610655), FX16_CONST(0.8708420634700789),
    FX16_CONST(-0.4902264832882911), FX16_CONST(0.8715950866559511),
    FX16_CONST(-0.4888888969197637), FX16_CONST(0.8723460588943912),
    FX16_CONST(-0.4875501601484364), FX16_CONST(0.8730949784182899),
    FX16_CONST(-0.4862102761244867), FX16_CONST(0.8738418434653666),
    FX16_CONST(-0.48486924800079123), FX16_CONST(0.874586652278176),
    FX16_CONST(-0.48352707893291874), FX16_CONST(0.8753294031041108),
    FX16_CONST(-0.4821837720791226), FX16_CONST(0.8760700941954067),
    FX16_CONST(-0.48083933060033446), FX16_CONST(0.8768087238091454),
    FX16_CONST(-0.4794937576601534), FX16_CONST(0.8775452902072611),
    FX16_CONST(-0.4781470564248433), FX16_CONST(0.8782797916565414),
    FX16_CONST(-0.4767992300633222), FX16_CONST(0.8790122264286334),
    FX16_CONST(-0.4754502817471558), FX16_CONST(0.8797425928000475),
    FX16_CONST(-0.4741002146505506), FX16_CONST(0.8804708890521604),
    FX16_CONST(-0.47274903195034323), FX16_CONST(0.8811971134712218),
    FX16_CONST(-0.4713967368259979), FX16_CONST(0.8819212643483548),
    FX16_CONST(-0.4700433324595958), FX16_CONST(0.8826433399795627),
    FX16_CONST(-0.46868882203582796), FX16_CONST(0.8833633386657316),
    FX16_CONST(-0.4673332087419883), FX16_CONST(0.8840812587126351),
    FX16_CONST(-0.4659764957679667), FX16_CONST(0.8847970984309375),
    FX16_CONST(-0.4646186863062382), FX16_CONST(0.8855108561361997),
    FX16_CONST(-0.4632597835518604), FX16_CONST(0.8862225301488805),
    FX16_CONST(-0.46189979070246284), FX16_CONST(0.8869321187943421),
    FX16_CONST(-0.46053871095823995), FX16_CONST(0.8876396204028539),
    FX16_CONST(-0.4591765475219447), FX16_CONST(0.888345033309596),
    FX16_CONST(-0.4578133035988777), FX16_CONST(0.8890483558546644),
    FX16_CONST(-0.45644898239688425), FX16_CONST(0.8897495863830727),
    FX16_CONST(-0.455083587126344), FX16_CONST(0.8904487232447578),
    FX16_CONST(-0.45371712100016387), FX16_CONST(0.8911457647945832),
    FX16_CONST(-0.4523495872337707), FX16_CONST(0.8918407093923428),
    FX16_CONST(-0.45098098904510436), FX16_CONST(0.8925335554027644),
    FX16_CONST(-0.449611329654607), FX16_CONST(0.8932243011955151),
    FX16_CONST(-0.44824061228522016), FX16_CONST(0.8939129451452031),
    FX16_CONST(-0.44686884016237427), FX16_CONST(0.8945994856313826),
    FX16_CONST(-0.4454960165139817), FX16_CONST(0.8952839210385576),
    FX16_CONST(-0.4441221445704298), FX16_CONST(0.8959662497561849),
    FX16_CONST(-0.44274722756457047), FX16_CONST(0.8966464701786799),
    FX16_CONST(-0.441371268731717), FX16_CONST(0.8973245807054181),
    FX16_CONST(-0.4399942713096334), FX16_CONST(0.8980005797407398),
    FX16_CONST(-0.43861623853852766), FX16_CONST(0.8986744656939538),
    FX16_CONST(-0.437237173661044), FX16_CONST(0.8993462369793416),
    FX16_CONST(-0.43585707992225603), FX16_CONST(0.90001589201616),
    FX16_CONST(-0.4344759605696561), FX16_CONST(0.9006834292286467),
    FX16_CONST(-0.4330938188531522), FX16_CONST(0.9013488470460219),
    FX16_CONST(-0.43171065802505737), FX16_CONST(0.9020121439024932),
    FX16_CONST(-0.43032648134008256), FX16_CONST(0.9026733182372588),
    FX16_CONST(-0.4289412920553301), FX16_CONST(0.9033323684945116),
    FX16_CONST(-0.42755509343028253), FX16_CONST(0.9039892931234431),
    FX16_CONST(-0.42616788872679995), FX16_CONST(0.904644090578246),
    FX16_CONST(-0.42477968120910903), FX16_CONST(0.9052967593181187),
    FX16_CONST(-0.42339047414379605), FX16_CONST(0.9059472978072685),
    FX16_CONST(-0.42200027079979957), FX16_CONST(0.9065957045149154),
    FX16_CONST(-0.42060907444840306), FX16_CONST(0.9072419779152956),
    FX16_CONST(-0.41921688836322435), FX16_CONST(0.907886116487666),
    FX16_CONST(-0.41782371582021255), FX16_CONST(0.908528118716306),
    FX16_CONST(-0.41642956009763726), FX16_CONST(0.9091679830905224),
    FX16_CONST(-0.4150344244760816), FX16_CONST(0.9098057081046522),
    FX16_CONST(-0.41363831223843517), FX16_CONST(0.9104412922580669),
    FX16_CONST(-0.41224122666988333), FX16_CONST(0.9110747340551761),
    FX16_CONST(-0.41084317105790424), FX16_CONST(0.9117060320054297),
    FX16_CONST(-0.40944414869225776), FX16_CONST(0.9123351846233226),
    FX16_CONST(-0.4080441628649787), FX16_CONST(0.9129621904283981),
    FX16_CONST(-0.40664321687036886), FX16_CONST(0.9135870479452509),
    FX16_CONST(-0.4052413140049904), FX16_CONST(0.9142097557035305),
    FX16_CONST(-0.4038384575676545), FX16_CONST(0.914830312237946),
    FX16_CONST(-0.4024346508594187), FX16_CONST(0.9154487160882677),
    FX16_CONST(-0.40102989718357573), FX16_CONST(0.9160649657993316),
    FX16_CONST(-0.3996241998456468), FX16_CONST(0.9166790599210427),
    FX16_CONST(-0.3982175621533742), FX16_CONST(0.9172909970083777),
    FX16_CONST(-0.3968099874167108), FX16_CONST(0.9179007756213903),
    FX16_CONST(-0.39540147894781663), FX16_CONST(0.918508394325212),
    FX16_CONST(-0.39399204006104827), FX16_CONST(0.9191138516900577),
    FX16_CONST(-0.3925816740729515), FX16_CONST(0.9197171462912274),
    FX16_CONST(-0.39117038430225376), FX16_CONST(0.9203182767091106),
    FX16_CONST(-0.389758174069857), FX16_CONST(0.9209172415291892),
    FX16_CONST(-0.3883450466988267), FX16_CONST(0.9215140393420418),
    FX16_CONST(-0.38693100551438886), FX16_CONST(0.9221086687433451),
    FX16_CONST(-0.38551605384391896), FX16_CONST(0.9227011283338785),
    FX16_CONST(-0.384100195016935), FX16_CONST(0.9232914167195276),
    FX16_CONST(-0.3826834323650904), FX16_CONST(0.9238795325112865),
    FX16_CONST(-0.3812657692221628), FX16_CONST(0.9244654743252624),
    FX16_CONST(-0.3798472089240515), FX16_CONST(0.9250492407826775),
    FX16_CONST(-0.3784277548087658), FX16_CONST(0.9256308305098727),
    FX16_CONST(-0.37700741021641826), FX16_CONST(0.9262102421383114),
    FX16_CONST(-0.3755861784892171), FX16_CONST(0.9267874743045819),
    FX16_CONST(-0.37416406297145854), FX16_CONST(0.9273625256504009),
    FX16_CONST(-0.3727410670095162), FX16_CONST(0.9279353948226177),
    FX16_CONST(-0.3713171939518378), FX16_CONST(0.9285060804732155),
    FX16_CONST(-0.3698924471489342), FX16_CONST(0.9290745812593157),
    FX16_CONST(-0.36846682995337227), FX16_CONST(0.9296408958431813),
    FX16_CONST(-0.367040345719767), FX16_CONST(0.9302050228922192),
    FX16_CONST(-0.36561299780477435), FX16_CONST(0.9307669610789835),
    FX16_CONST(-0.3641847895670802), FX16_CONST(0.9313267090811803),
    FX16_CONST(-0.3627557243673974), FX16_CONST(0.931884265581668),
    FX16_CONST(-0.3613258055684543), FX16_CONST(0.9324396292684624),
    FX16_CONST(-0.359895036534988), FX16_CONST(0.932992798834739),
    FX16_CONST(-0.3584634206337371), FX16_CONST(0.933543772978836),
    FX16_CONST(-0.3570309612334304), FX16_CONST(0.9340925504042588),
    FX16_CONST(-0.35559766170478413), FX16_CONST(0.9346391298196807),
    FX16_CONST(-0.3541635254204905), FX16_CONST(0.9351835099389475),
    FX16_CONST(-0.35272855575521067), FX16_CONST(0.9357256894810804),
    FX16_CONST(-0.3512927560855669), FX16_CONST(0.9362656671702784),
    FX16_CONST(-0.3498561297901354), FX16_CONST(0.9368034417359214),
    FX16_CONST(-0.3484186802494349), FX16_CONST(0.9373390119125748),
    FX16_CONST(-0.34698041084592385), FX16_CONST(0.9378723764399898),
    FX16_CONST(-0.3455413249639891), FX16_CONST(0.9384035340631081),
    FX16_CONST(-0.34410142598993876), FX16_CONST(0.9389324835320646),
    FX16_CONST(-0.34266071731199493), FX16_CONST(0.9394592236021897),
    FX16_CONST(-0.3412192023202828), FX16_CONST(0.9399837530340138),
    FX16_CONST(-0.33977688440682713), FX16_CONST(0.9405060705932682),
    FX16_CONST(-0.3383337669655413), FX16_CONST(0.9410261750508893),
    FX16_CONST(-0.33688985339222), FX16_CONST(0.9415440651830208),
    FX16_CONST(-0.33544514708453144), FX16_CONST(0.9420597397710174),
    FX16_CONST(-0.3339996514420099), FX16_CONST(0.9425731976014468),
    FX16_CONST(-0.33255336986604456), FX16_CONST(0.9430844374660934),
    FX16_CONST(-0.3311063057598766), FX16_CONST(0.9435934581619603),
    FX16_CONST(-0.32965846252858755), FX16_CONST(0.9441002584912727),
    FX16_CONST(-0.3282098435790924), FX16_CONST(0.9446048372614803),
    FX16_CONST(-0.32676045232013234), FX16_CONST(0.9451071932852604),
    FX16_CONST(-0.32531029216226337), FX16_CONST(0.9456073253805212),
    FX16_CONST(-0.32385936651785313), FX16_CONST(0.9461052323704033),
    FX16_CONST(-0.32240767880106996), FX16_CONST(0.9466009130832835),
    FX16_CONST(-0.3209552324278752), FX16_CONST(0.9470943663527772),
    FX16_CONST(-0.31950203081601547), FX16_CONST(0.9475855910177412),
    FX16_CONST(-0.31804807738501545), FX16_CONST(0.9480745859222761),
    FX16_CONST(-0.31659337555616623), FX16_CONST(0.9485613499157302),
    FX16_CONST(-0.3151379287525226), FX16_CONST(0.9490458818527006),
    FX16_CONST(-0.3136817403988915), FX16_CONST(0.9495281805930367),
    FX16_CONST(-0.31222481392182483), FX16_CONST(0.9500082450018431),
    FX16_CONST(-0.3107671527496121), FX16_CONST(0.9504860739494815),
    FX16_CONST(-0.30930876031226917), FX16_CONST(0.950961666311575),
    FX16_CONST(-0.30784964004153514), FX16_CONST(0.9514350209690082),
    FX16_CONST(-0.3063897953708611), FX16_CONST(0.9519061368079322),
    FX16_CONST(-0.3049292297354024), FX16_CONST(0.9523750127197659),
    FX16_CONST(-0.3034679465720111), FX16_CONST(0.9528416476011987),
    FX16_CONST(-0.3020059493192286), FX16_CONST(0.9533060403541936),
    FX16_CONST(-0.3005432414172738), FX16_CONST(0.9537681898859902),
    FX16_CONST(-0.29907982630804064), FX16_CONST(0.9542280951091056),
    FX16_CONST(-0.29761570743508625), FX16_CONST(0.9546857549413383),
    FX16_CONST(-0.29615088824362373), FX16_CONST(0.9551411683057708),
    FX16_CONST(-0.29468537218051494), FX16_CONST(0.9555943341307709),
    FX16_CONST(-0.2932191626942591), FX16_CONST(0.9560452513499963),
    FX16_CONST(-0.29175226323498954), FX16_CONST(0.956493918902395),
    FX16_CONST(-0.2902846772544625), FX16_CONST(0.9569403357322088),
    FX16_CONST(-0.2888164082060494), FX16_CONST(0.957384500788976),
    FX16_CONST(-0.28734745954472934), FX16_CONST(0.9578264130275329),
    FX16_CONST(-0.2858778347270811), FX16_CONST(0.9582660714080176),
    FX16_CONST(-0.2844075372112722), FX16_CONST(0.9587034748958715),
    FX16_CONST(-0.28293657045705556), FX16_CONST(0.9591386224618419),
    FX16_CONST(-0.28146493792575805), FX16_CONST(0.9595715130819845),
    FX16_CONST(-0.2799926430802731), FX16_CONST(0.960002145737666),
    FX16_CONST(-0.27851968938505367), FX16_CONST(0.9604305194155657),
    FX16_CONST(-0.27704608030610034), FX16_CONST(0.9608566331076795),
    FX16_CONST(-0.2755718193109584), FX16_CONST(0.9612804858113205),
    FX16_CONST(-0.2740969098687065), FX16_CONST(0.9617020765291225),
    FX16_CONST(-0.2726213554499489), FX16_CONST(0.9621214042690416),
    FX16_CONST(-0.27114515952680784), FX16_CONST(0.9625384680443592),
    FX16_CONST(-0.2696683255729156), FX16_CONST(0.9629532668736838),
    FX16_CONST(-0.26819085706340356), FX16_CONST(0.9633657997809539),
    FX16_CONST(-0.2667127574748986), FX16_CONST(0.9637760657954398),
    FX16_CONST(-0.26523403028551185), FX16_CONST(0.9641840639517458),
    FX16_CONST(-0.2637546789748313), FX16_CONST(0.9645897932898128),
    FX16_CONST(-0.2622747070239142), FX16_CONST(0.9649932528549202),
    FX16_CONST(-0.26079411791527596), FX16_CONST(0.9653944416976893),
    FX16_CONST(-0.2593129151328865), FX16_CONST(0.9657933588740836),
    FX16_CONST(-0.25783110216215915), FX16_CONST(0.9661900034454125),
    FX16_CONST(-0.25634868248994286), FX16_CONST(0.9665843744783331),
    FX16_CONST(-0.2548656596045144), FX16_CONST(0.9669764710448522),
    FX16_CONST(-0.25338203699557066), FX16_CONST(0.9673662922223284),
    FX16_CONST(-0.2518978181542173), FX16_CONST(0.9677538370934754),
    FX16_CONST(-0.25041300657296545), FX16_CONST(0.9681391047463623),
    FX16_CONST(-0.2489276057457202), FX16_CONST(0.9685220942744173),
    FX16_CONST(-0.24744161916777319), FX16_CONST(0.9689028047764289),
    FX16_CONST(-0.2459550503357952), FX16_CONST(0.9692812353565483),
    FX16_CONST(-0.2444679027478246), FX16_CONST(0.9696573851242923),
    FX16_CONST(-0.24298017990326418), FX16_CONST(0.970031253194544),
    FX16_CONST(-0.24149188530286947), FX16_CONST(0.9704028386875554),
    FX16_CONST(-0.24000302244874144), FX16_CONST(0.9707721407289504),
    FX16_CONST(-0.23851359484431825), FX16_CONST(0.9711391584497252),
    FX16_CONST(-0.23702360599436773), FX16_CONST(0.9715038909862517),
    FX16_CONST(-0.23553305940497588), FX16_CONST(0.9718663374802793),
    FX16_CONST(-0.23404195858354362), FX16_CONST(0.9722264970789363),
    FX16_CONST(-0.2325503070387753), FX16_CONST(0.9725843689347322),
    FX16_CONST(-0.231058108280671), FX16_CONST(0.9729399522055602),
    FX16_CONST(-0.22956536582051948), FX16_CONST(0.9732932460546981),
    FX16_CONST(-0.22807208317088618), FX16_CONST(0.9736442496508119),
    FX16_CONST(-0.22657826384561028), FX16_CONST(0.9739929621679558),
    FX16_CONST(-0.22508391135979297), FX16_CONST(0.9743393827855759),
    FX16_CONST(-0.22358902922978996), FX16_CONST(0.9746835106885107),
    FX16_CONST(-0.22209362097320334), FX16_CONST(0.9750253450669942),
    FX16_CONST(-0.22059769010887406), FX16_CONST(0.9753648851166569),
    FX16_CONST(-0.21910124015687016), FX16_CONST(0.9757021300385285),
    FX16_CONST(-0.21760427463848384), FX16_CONST(0.976037079039039),
    FX16_CONST(-0.21610679707621955), FX16_CONST(0.9763697313300211),
    FX16_CONST(-0.21460881099378668), FX16_CONST(0.9767000861287118),
    FX16_CONST(-0.21311031991609197), FX16_CONST(0.9770281426577542),
    FX16_CONST(-0.21161132736922802), FX16_CONST(0.9773539001452),
    FX16_CONST(-0.21011183688046992), FX16_CONST(0.9776773578245099),
    FX16_CONST(-0.20861185197826362), FX16_CONST(0.977998514934557),
    FX16_CONST(-0.20711137619221853), FX16_CONST(0.9783173707196277),
    FX16_CONST(-0.20561041305309907), FX16_CONST(0.9786339244294232),
    FX16_CONST(-0.2041089660928174), FX16_CONST(0.9789481753190621),
    FX16_CONST(-0.2026070388444215), FX16_CONST(0.979260122649082),
    FX16_CONST(-0.20110463484209212), FX16_CONST(0.9795697656854405),
    FX16_CONST(-0.19960175762113103), FX16_CONST(0.9798771036995176),
    FX16_CONST(-0.19809841071795348), FX16_CONST(0.9801821359681174),
    FX16_CONST(-0.19659459767008083), FX16_CONST(0.9804848617734693),
    FX16_CONST(-0.19509032201612872), FX16_CONST(0.9807852804032303),
    FX16_CONST(-0.1935855872958039), FX16_CONST(0.9810833911504866),
    FX16_CONST(-0.19208039704989258), FX16_CONST(0.9813791933137546),
    FX16_CONST(-0.19057475482025274), FX16_CONST(0.9816726861969831),
    FX16_CONST(-0.18906866414980603), FX16_CONST(0.9819638691095554),
    FX16_CONST(-0.18756212858253013), FX16_CONST(0.9822527413662893),
    FX16_CONST(-0.18605515166344702), FX16_CONST(0.9825393022874411),
    FX16_CONST(-0.18454773693861984), FX16_CONST(0.9828235511987052),
    FX16_CONST(-0.183039887955141), FX16_CONST(0.9831054874312163),
    FX16_CONST(-0.18153160826112488), FX16_CONST(0.9833851103215512),
    FX16_CONST(-0.18002290140570013), FX16_CONST(0.9836624192117301),
    FX16_CONST(-0.17851377093899798), FX16_CONST(0.9839374134492188),
    FX16_CONST(-0.17700422041214905), FX16_CONST(0.984210092386929),
    FX16_CONST(-0.17549425337727156), FX16_CONST(0.9844804553832209),
    FX16_CONST(-0.1739838733874638), FX16_CONST(0.9847485018019042),
    FX16_CONST(-0.17247308399679578), FX16_CONST(0.9850142310122398),
    FX16_CONST(-0.17096188876030177), FX16_CONST(0.9852776423889411),
    FX16_CONST(-0.16945029123396835), FX16_CONST(0.985538735312176),
    FX16_CONST(-0.1679382949747314), FX16_CONST(0.9857975091675674),
    FX16_CONST(-0.1664259035404642), FX16_CONST(0.9860539633461954),
    FX16_CONST(-0.1649131204899698), FX16_CONST(0.9863080972445987),
    FX16_CONST(-0.16339994938297386), FX16_CONST(0.9865599102647753),
    FX16_CONST(-0.1618863937801123), FX16_CONST(0.9868094018141854),
    FX16_CONST(-0.16037245724292856), FX16_CONST(0.987056571305751),
    FX16_CONST(-0.15885814333386158), FX16_CONST(0.9873014181578583),
    FX16_CONST(-0.15734345561623825), FX16_CONST(0.9875439417943592),
    FX16_CONST(-0.15582839765426507), FX16_CONST(0.9877841416445722),
    FX16_CONST(-0.15431297301302063), FX16_CONST(0.9880220171432835),
    FX16_CONST(-0.1527971852584438), FX16_CONST(0.9882575677307495),
    FX16_CONST(-0.15128103795733044), FX16_CONST(0.9884907928526966),
    FX16_CONST(-0.1497645346773216), FX16_CONST(0.9887216919603238),
    FX16_CONST(-0.14824767898689595), FX16_CONST(0.988950264510303),
    FX16_CONST(-0.1467304744553624), FX16_CONST(0.9891765099647809),
    FX16_CONST(-0.14521292465284794), FX16_CONST(0.9894004277913803),
    FX16_CONST(-0.14369503315029475), FX16_CONST(0.9896220174632008),
    FX16_CONST(-0.1421768035194482), FX16_CONST(0.9898412784588205),
    FX16_CONST(-0.1406582393328492), FX16_CONST(0.9900582102622971),
    FX16_CONST(-0.13913934416382603), FX16_CONST(0.9902728123631691),
    FX16_CONST(-0.1376201215864866), FX16_CONST(0.990485084256457),
    FX16_CONST(-0.1361005751757066), FX16_CONST(0.9906950254426646),
    FX16_CONST(-0.13458070850712642), FX16_CONST(0.99090263542778),
    FX16_CONST(-0.13306052515713912), FX16_CONST(0.9911079137232768),
    FX16_CONST(-0.131540028702883), FX16_CONST(0.9913108598461154),
    FX16_CONST(-0.13001922272223398), FX16_CONST(0.9915114733187439),
    FX16_CONST(-0.12849811079379364), FX16_CONST(0.9917097536690994),
    FX16_CONST(-0.12697669649688617), FX16_CONST(0.9919057004306093),
    FX16_CONST(-0.12545498341154637), FX16_CONST(0.9920993131421917),
    FX16_CONST(-0.12393297511851216), FX16_CONST(0.9922905913482574),
    FX16_CONST(-0.12241067519921603), FX16_CONST(0.99247953459871),
    FX16_CONST(-0.12088808723577762), FX16_CONST(0.9926661424489479),
    FX16_CONST(-0.11936521481099176), FX16_CONST(0.992850414459865),
    FX16_CONST(-0.1178420615083252), FX16_CONST(0.9930323501978514),
    FX16_CONST(-0.11631863091190484), FX16_CONST(0.9932119492347945),
    FX16_CONST(-0.11479492660650999), FX16_CONST(0.9933892111480807),
    FX16_CONST(-0.11327095217756497), FX16_CONST(0.9935641355205953),
    FX16_CONST(-0.11174671121112706), FX16_CONST(0.9937367219407246),
    FX16_CONST(-0.11022220729388336), FX16_CONST(0.9939069700023561),
    FX16_CONST(-0.10869744401313887), FX16_CONST(0.9940748793048794),
    FX16_CONST(-0.10717242495680884), FX16_CONST(0.9942404494531879),
    FX16_CONST(-0.10564715371341044), FX16_CONST(0.9944036800576791),
    FX16_CONST(-0.10412163387205513), FX16_CONST(0.9945645707342554),
    FX16_CONST(-0.10259586902243668), FX16_CONST(0.9947231211043257),
    FX16_CONST(-0.10106986275482806), FX16_CONST(0.9948793307948056),
    FX16_CONST(-0.0995436186600694), FX16_CONST(0.9950331994381186),
    FX16_CONST(-0.0980171403295605), FX16_CONST(0.9951847266721969),
    FX16_CONST(-0.09649043135525323), FX16_CONST(0.9953339121404822),
    FX16_CONST(-0.09496349532963948), FX16_CONST(0.9954807554919269),
    FX16_CONST(-0.09343633584574809), FX16_CONST(0.9956252563809943),
    FX16_CONST(-0.09190895649713288), FX16_CONST(0.9957674144676598),
    FX16_CONST(-0.09038136087786497), FX16_CONST(0.9959072294174117),
    FX16_CONST(-0.08885355258252442), FX16_CONST(0.996044700901252),
    FX16_CONST(-0.08732553520619263), FX16_CONST(0.9961798285956969),
    FX16_CONST(-0.08579731234444028), FX16_CONST(0.996312612182778),
    FX16_CONST(-0.08426888759332431), FX16_CONST(0.9964430513500426),
    FX16_CONST(-0.08274026454937576), FX16_CONST(0.9965711457905548),
    FX16_CONST(-0.08121144680959234), FX16_CONST(0.9966968952028961),
    FX16_CONST(-0.07968243797143075), FX16_CONST(0.9968202992911657),
    FX16_CONST(-0.07815324163279472), FX16_CONST(0.996941357764982),
    FX16_CONST(-0.07662386139203181), FX16_CONST(0.997060070339483),
    FX16_CONST(-0.07509430084792147), FX16_CONST(0.9971764367353261),
    FX16_CONST(-0.07356456359966741), FX16_CONST(0.9972904566786902),
    FX16_CONST(-0.07203465324688915), FX16_CONST(0.9974021299012753),
    FX16_CONST(-0.07050457338961442), FX16_CONST(0.9975114561403035),
    FX16_CONST(-0.06897432762826713), FX16_CONST(0.9976184351385196),
    FX16_CONST(-0.06744391956366429), FX16_CONST(0.9977230666441916),
    FX16_CONST(-0.06591335279700389), FX16_CONST(0.9978253504111116),
    FX16_CONST(-0.06438263092985737), FX16_CONST(0.997925286198596),
    FX16_CONST(-0.06285175756416206), FX16_CONST(0.9980228737714861),
    FX16_CONST(-0.06132073630220906), FX16_CONST(0.9981181129001492),
    FX16_CONST(-0.05978957074664019), FX16_CONST(0.9982110033604782),
    FX16_CONST(-0.05825826450043591), FX16_CONST(0.9983015449338928),
    FX16_CONST(-0.05672682116690774), FX16_CONST(0.9983897374073402),
    FX16_CONST(-0.055195244349689775), FX16_CONST(0.9984755805732948),
    FX16_CONST(-0.05366353765273108), FX16_CONST(0.9985590742297593),
    FX16_CONST(-0.05213170468028372), FX16_CONST(0.9986402181802652),
    FX16_CONST(-0.05059974903689952), FX16_CONST(0.9987190122338729),
    FX16_CONST(-0.04906767432741809), FX16_CONST(0.9987954562051724),
    FX16_CONST(-0.04753548415695922), FX16_CONST(0.9988695499142836),
    FX16_CONST(-0.04600318213091527), FX16_CONST(0.9989412931868569),
    FX16_CONST(-0.044470771854939146), FX16_CONST(0.9990106858540733),
    FX16_CONST(-0.04293825693494114), FX16_CONST(0.9990777277526454),
    FX16_CONST(-0.0414056409770769), FX16_CONST(0.9991424187248169),
    FX16_CONST(-0.03987292758773981), FX16_CONST(0.9992047586183639),
    FX16_CONST(-0.038340120373552534), FX16_CONST(0.9992647472865944),
    FX16_CONST(-0.036807222941359394), FX16_CONST(0.9993223845883494),
    FX16_CONST(-0.03527423889821435), FX16_CONST(0.9993776703880028),
    FX16_CONST(-0.03374117185137782), FX16_CONST(0.9994306045554617),
    FX16_CONST(-0.03220802540830466), FX16_CONST(0.999481186966167),
    FX16_CONST(-0.030674803176636543), FX16_CONST(0.9995294175010931),
    FX16_CONST(-0.029141508764194368), FX16_CONST(0.9995752960467492),
    FX16_CONST(-0.027608145778966225), FX16_CONST(0.9996188224951786),
    FX16_CONST(-0.02607471782910422), FX16_CONST(0.9996599967439592),
    FX16_CONST(-0.024541228522912448), FX16_CONST(0.9996988186962042),
    FX16_CONST(-0.023007681468839372), FX16_CONST(0.9997352882605617),
    FX16_CONST(-0.021474080275469345), FX16_CONST(0.9997694053512153),
    FX16_CONST(-0.019940428551515003), FX16_CONST(0.9998011698878843),
    FX16_CONST(-0.018406729905805226), FX16_CONST(0.9998305817958234),
    FX16_CONST(-0.016872987947281957), FX16_CONST(0.9998576410058239),
    FX16_CONST(-0.015339206284988182), FX16_CONST(0.9998823474542126),
    FX16_CONST(-0.01380538852806031), FX16_CONST(0.9999047010828529),
    FX16_CONST(-0.012271538285720572), FX16_CONST(0.9999247018391445),
    FX16_CONST(-0.010737659167264976), FX16_CONST(0.9999423496760239),
    FX16_CONST(-0.009203754782060144), FX16_CONST(0.9999576445519639),
    FX16_CONST(-0.007669828739531261), FX16_CONST(0.9999705864309741),
    FX16_CONST(-0.006135884649154477), FX16_CONST(0.9999811752826011),
    FX16_CONST(-0.004601926120448411), FX16_CONST(0.9999894110819284),
    FX16_CONST(-0.003067956762966544), FX16_CONST(0.9999952938095762),
    FX16_CONST(-0.0015339801862851719), FX16_CONST(0.9999988234517019)
};
