	.include "asm/macros.inc"
	.include "global.inc"

	.section .data

	.global itab
itab: ; 0x021062AC
	.byte 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
	.byte 0x01, 0x06, 0x0B, 0x00, 0x05, 0x0A, 0x0F, 0x04, 0x09, 0x0E, 0x03, 0x08, 0x0D, 0x02, 0x07, 0x0C
	.byte 0x05, 0x08, 0x0B, 0x0E, 0x01, 0x04, 0x07, 0x0A, 0x0D, 0x00, 0x03, 0x06, 0x09, 0x0C, 0x0F, 0x02
	.byte 0x00, 0x07, 0x0E, 0x05, 0x0C, 0x03, 0x0A, 0x01, 0x08, 0x0F, 0x06, 0x0D, 0x04, 0x0B, 0x02, 0x09

	.global padding
padding: ; 0x021062EC
	.byte 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	.byte 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	.byte 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	.byte 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

	.global ktab
ktab: ; 0x0210632C
	.byte 0x78, 0xA4, 0x6A, 0xD7, 0x56, 0xB7, 0xC7, 0xE8, 0xDB, 0x70, 0x20, 0x24, 0xEE, 0xCE, 0xBD, 0xC1
	.byte 0xAF, 0x0F, 0x7C, 0xF5, 0x2A, 0xC6, 0x87, 0x47, 0x13, 0x46, 0x30, 0xA8, 0x01, 0x95, 0x46, 0xFD
	.byte 0xD8, 0x98, 0x80, 0x69, 0xAF, 0xF7, 0x44, 0x8B, 0xB1, 0x5B, 0xFF, 0xFF, 0xBE, 0xD7, 0x5C, 0x89
	.byte 0x22, 0x11, 0x90, 0x6B, 0x93, 0x71, 0x98, 0xFD, 0x8E, 0x43, 0x79, 0xA6, 0x21, 0x08, 0xB4, 0x49
	.byte 0x62, 0x25, 0x1E, 0xF6, 0x40, 0xB3, 0x40, 0xC0, 0x51, 0x5A, 0x5E, 0x26, 0xAA, 0xC7, 0xB6, 0xE9
	.byte 0x5D, 0x10, 0x2F, 0xD6, 0x53, 0x14, 0x44, 0x02, 0x81, 0xE6, 0xA1, 0xD8, 0xC8, 0xFB, 0xD3, 0xE7
	.byte 0xE6, 0xCD, 0xE1, 0x21, 0xD6, 0x07, 0x37, 0xC3, 0x87, 0x0D, 0xD5, 0xF4, 0xED, 0x14, 0x5A, 0x45
	.byte 0x05, 0xE9, 0xE3, 0xA9, 0xF8, 0xA3, 0xEF, 0xFC, 0xD9, 0x02, 0x6F, 0x67, 0x8A, 0x4C, 0x2A, 0x8D
	.byte 0x42, 0x39, 0xFA, 0xFF, 0x81, 0xF6, 0x71, 0x87, 0x22, 0x61, 0x9D, 0x6D, 0x0C, 0x38, 0xE5, 0xFD
	.byte 0x44, 0xEA, 0xBE, 0xA4, 0xA9, 0xCF, 0xDE, 0x4B, 0x60, 0x4B, 0xBB, 0xF6, 0x70, 0xBC, 0xBF, 0xBE
	.byte 0xC6, 0x7E, 0x9B, 0x28, 0xFA, 0x27, 0xA1, 0xEA, 0x85, 0x30, 0xEF, 0xD4, 0x05, 0x1D, 0x88, 0x04
	.byte 0x39, 0xD0, 0xD4, 0xD9, 0xE5, 0x99, 0xDB, 0xE6, 0xF8, 0x7C, 0xA2, 0x1F, 0x65, 0x56, 0xAC, 0xC4
	.byte 0x44, 0x22, 0x29, 0xF4, 0x97, 0xFF, 0x2A, 0x43, 0xA7, 0x23, 0x94, 0xAB, 0x39, 0xA0, 0x93, 0xFC
	.byte 0xC3, 0x59, 0x5B, 0x65, 0x92, 0xCC, 0x0C, 0x8F, 0x7D, 0xF4, 0xEF, 0xFF, 0xD1, 0x5D, 0x84, 0x85
	.byte 0x4F, 0x7E, 0xA8, 0x6F, 0xE0, 0xE6, 0x2C, 0xFE, 0x14, 0x43, 0x01, 0xA3, 0xA1, 0x11, 0x08, 0x4E
	.byte 0x82, 0x7E, 0x53, 0xF7, 0x35, 0xF2, 0x3A, 0xBD, 0xBB, 0xD2, 0xD7, 0x2A, 0x91, 0xD3, 0x86, 0xEB

	.section .text

	arm_func_start CPSi_md5_result
CPSi_md5_result: ; 0x020A3A58
	stmdb sp!, {r4-r5,lr}
	sub sp, sp, #0x4
	mov r5, r0
	mov r4, r1
	mov r0, r4
	add r1, r5, #0x10
	mov r2, #0x8
	bl char_from_long
	ldr r0, [r5, #0x10]
	ldr r1, _020A3AC8 ; =padding
	mov r0, r0, lsr #0x3
	and r0, r0, #0x3f
	cmp r0, #0x38
	rsblt r2, r0, #0x38
	rsbge r2, r0, #0x78
	mov r0, r5
	bl CPSi_md5_calc
	mov r0, r5
	mov r1, r4
	mov r2, #0x8
	bl CPSi_md5_calc
	mov r0, r4
	mov r1, r5
	mov r2, #0x10
	bl char_from_long
	add sp, sp, #0x4
	ldmia sp!, {r4-r5,lr}
	bx lr
	.balign 4
_020A3AC8: .word padding

	arm_func_start CPSi_md5_calc
CPSi_md5_calc:
	stmdb sp!, {r4-r8,lr}
	mov r8, r0
	ldr r3, [r8, #0x10]
	mov r6, r2
	add r0, r3, r6, lsl #0x3
	str r0, [r8, #0x10]
	ldr r0, [r8, #0x10]
	mov r2, r3, lsr #0x3
	cmp r0, r6, lsl #0x3
	ldrcc r0, [r8, #0x14]
	and r4, r2, #0x3f
	addcc r0, r0, #0x1
	strcc r0, [r8, #0x14]
	ldr r0, [r8, #0x14]
	rsb r5, r4, #0x40
	add r0, r0, r6, lsr #0x1d
	mov r7, r1
	str r0, [r8, #0x14]
	cmp r6, r5
	blo _020A3B6C
	add r1, r8, #0x18
	mov r0, r7
	mov r2, r5
	add r1, r1, r4
	bl MI_CpuCopy8
	mov r0, r8
	add r1, r8, #0x18
	mov r4, #0x0
	bl CPSi_md5_block
	add r0, r5, #0x3f
	cmp r0, r6
	bhs _020A3B70
_020A3B4C:
	mov r0, r8
	add r1, r7, r5
	bl CPSi_md5_block
	add r5, r5, #0x40
	add r0, r5, #0x3f
	cmp r0, r6
	blo _020A3B4C
	b _020A3B70
_020A3B6C:
	mov r5, #0x0
_020A3B70:
	add r1, r8, #0x18
	add r0, r7, r5
	add r1, r1, r4
	sub r2, r6, r5
	bl MI_CpuCopy8
	ldmia sp!, {r4-r8,lr}
	bx lr

	arm_func_start CPSi_md5_init
CPSi_md5_init: ; 0x020A3B8C
	stmdb sp!, {r4,lr}
	mov r1, #0x0
	mov r2, #0x58
	mov r4, r0
	bl MI_CpuFill8
	ldr r1, _020A3BC8 ; =0x67452301
	ldr r0, _020A3BCC ; =0xEFCDAB89
	str r1, [r4, #0x0]
	ldr r1, _020A3BD0 ; =0x98BADCFE
	str r0, [r4, #0x4]
	ldr r0, _020A3BD4 ; =0x10325476
	str r1, [r4, #0x8]
	str r0, [r4, #0xc]
	ldmia sp!, {r4,lr}
	bx lr
	.balign 4
_020A3BC8: .word 0x67452301
_020A3BCC: .word 0xEFCDAB89
_020A3BD0: .word 0x98BADCFE
_020A3BD4: .word 0x10325476

	arm_func_start CPSi_md5_block
CPSi_md5_block: ; 0x020A3BD8
	stmdb sp!, {r4-r11,lr}
	sub sp, sp, #0x44
	str r0, [sp, #0x0]
	ldr r3, [sp, #0x0]
	add r0, sp, #0x4
	mov r2, #0x40
	ldr r7, [r3, #0x0]
	ldr r6, [r3, #0x4]
	ldr r5, [r3, #0x8]
	ldr r4, [r3, #0xc]
	bl long_from_char
	ldr r2, _020A4024 ; =itab
	mov r3, #0x0
	ldr r1, _020A4028 ; =ktab
	mov r11, r3
	add r0, sp, #0x4
	mov r10, r2
_020A3C1C:
	ldrb r9, [r2, #0x0]
	add r8, r3, #0x1
	eor r12, r5, r4
	and r12, r6, r12
	eor r12, r4, r12
	ldr r9, [r0, r9, lsl #0x2]
	ldr lr, [r1, r3, lsl #0x2]
	add r9, r12, r9
	add r9, lr, r9
	add r9, r7, r9
	mov r7, r9, lsl #0x7
	orr r7, r7, r9, lsr #0x19
	ldrb r9, [r10, r8]
	add r7, r6, r7
	ldr r8, [r1, r8, lsl #0x2]
	ldr r9, [r0, r9, lsl #0x2]
	eor r12, r6, r5
	and r12, r7, r12
	eor r12, r5, r12
	add r9, r12, r9
	add r9, r8, r9
	add r8, r3, #0x2
	add r9, r4, r9
	mov r4, r9, lsl #0xc
	orr r4, r4, r9, lsr #0x14
	add r4, r7, r4
	ldr r9, [r1, r8, lsl #0x2]
	ldrb r12, [r10, r8]
	eor r8, r7, r6
	and r8, r4, r8
	eor r8, r6, r8
	ldr lr, [r0, r12, lsl #0x2]
	add r12, r3, #0x3
	add r8, r8, lr
	add r8, r9, r8
	add r8, r5, r8
	mov r5, r8, lsl #0x11
	orr r5, r5, r8, lsr #0xf
	add r5, r4, r5
	ldr r9, [r1, r12, lsl #0x2]
	ldrb r12, [r10, r12]
	eor r8, r4, r7
	and r8, r5, r8
	eor r8, r7, r8
	ldr r12, [r0, r12, lsl #0x2]
	add r2, r2, #0x4
	add r8, r8, r12
	add r8, r9, r8
	add r8, r6, r8
	mov r6, r8, lsl #0x16
	orr r6, r6, r8, lsr #0xa
	add r6, r5, r6
	add r3, r3, #0x4
	add r11, r11, #0x1
	cmp r11, #0x4
	blt _020A3C1C
	add r8, r10, r3
	mov r2, #0x0
	ldr r1, _020A4028 ; =ktab
	add r0, sp, #0x4
	ldr lr, _020A4024 ; =itab
_020A3D10:
	ldrb r10, [r8, #0x0]
	add r9, r3, #0x1
	eor r11, r6, r5
	and r11, r4, r11
	eor r11, r5, r11
	ldr r10, [r0, r10, lsl #0x2]
	ldr r12, [r1, r3, lsl #0x2]
	add r10, r11, r10
	add r10, r12, r10
	add r10, r7, r10
	mov r7, r10, lsl #0x5
	orr r7, r7, r10, lsr #0x1b
	ldrb r10, [lr, r9]
	add r7, r6, r7
	ldr r9, [r1, r9, lsl #0x2]
	ldr r10, [r0, r10, lsl #0x2]
	eor r11, r7, r6
	and r11, r5, r11
	eor r11, r6, r11
	add r10, r11, r10
	add r10, r9, r10
	add r9, r3, #0x2
	add r10, r4, r10
	mov r4, r10, lsl #0x9
	orr r4, r4, r10, lsr #0x17
	add r4, r7, r4
	ldr r12, [r1, r9, lsl #0x2]
	ldrb r9, [lr, r9]
	eor r10, r4, r7
	and r10, r6, r10
	eor r11, r7, r10
	ldr r10, [r0, r9, lsl #0x2]
	add r9, r3, #0x3
	add r10, r11, r10
	add r10, r12, r10
	add r10, r5, r10
	mov r5, r10, lsl #0xe
	orr r5, r5, r10, lsr #0x12
	add r5, r4, r5
	ldr r10, [r1, r9, lsl #0x2]
	ldrb r11, [lr, r9]
	eor r9, r5, r4
	and r9, r7, r9
	eor r9, r4, r9
	ldr r11, [r0, r11, lsl #0x2]
	add r8, r8, #0x4
	add r9, r9, r11
	add r9, r10, r9
	add r9, r6, r9
	mov r6, r9, lsl #0x14
	orr r6, r6, r9, lsr #0xc
	add r6, r5, r6
	add r3, r3, #0x4
	add r2, r2, #0x1
	cmp r2, #0x4
	blt _020A3D10
	add r8, lr, r3
	mov lr, #0x0
	ldr r2, _020A4028 ; =ktab
	add r0, sp, #0x4
_020A3E00:
	ldrb r1, [r8, #0x0]
	eor r12, r6, r5
	add lr, lr, #0x1
	ldr r11, [r0, r1, lsl #0x2]
	eor r12, r4, r12
	ldr r1, [r2, r3, lsl #0x2]
	add r11, r12, r11
	add r1, r1, r11
	add r7, r7, r1
	mov r1, r7, lsl #0x4
	orr r1, r1, r7, lsr #0x1c
	add r7, r6, r1
	add r10, r3, #0x1
	ldr r1, _020A4024 ; =itab
	ldr r12, [r2, r10, lsl #0x2]
	ldrb r1, [r1, r10]
	eor r10, r7, r6
	eor r11, r5, r10
	ldr r10, [r0, r1, lsl #0x2]
	add r9, r3, #0x2
	add r10, r11, r10
	add r10, r12, r10
	add r4, r4, r10
	ldr sl, _020A4024 ; =itab
	ldr r1, [r2, r9, lsl #0x2]
	ldrb r9, [r10, r9]
	mov r10, r4, lsl #0xb
	orr r4, r10, r4, lsr #0x15
	add r4, r7, r4
	eor r10, r4, r7
	ldr r9, [r0, r9, lsl #0x2]
	eor r10, r6, r10
	add r9, r10, r9
	add r1, r1, r9
	add r5, r5, r1
	add r10, r3, #0x3
	ldr sb, _020A4024 ; =itab
	mov r1, r5, lsl #0x10
	ldrb r9, [r9, r10]
	orr r1, r1, r5, lsr #0x10
	add r5, r4, r1
	ldr r1, [r2, r10, lsl #0x2]
	eor r10, r5, r4
	ldr r9, [r0, r9, lsl #0x2]
	eor r10, r7, r10
	add r9, r10, r9
	add r1, r1, r9
	add r6, r6, r1
	mov r1, r6, lsl #0x17
	orr r1, r1, r6, lsr #0x9
	add r8, r8, #0x4
	add r6, r5, r1
	add r3, r3, #0x4
	cmp lr, #0x4
	blt _020A3E00
	ldr r0, _020A4024 ; =itab
	ldr r1, _020A4028 ; =ktab
	add r8, r0, r3
	ldr lr, _020A4024 ; =itab
	mov r2, #0x0
	add r0, sp, #0x4
_020A3EF4:
	ldrb r10, [r8, #0x0]
	add r9, r3, #0x1
	mvn r11, r4
	orr r11, r6, r11
	eor r11, r5, r11
	ldr r10, [r0, r10, lsl #0x2]
	ldr r12, [r1, r3, lsl #0x2]
	add r10, r11, r10
	add r10, r12, r10
	add r10, r7, r10
	mov r7, r10, lsl #0x6
	orr r7, r7, r10, lsr #0x1a
	ldrb r10, [lr, r9]
	add r7, r6, r7
	ldr r9, [r1, r9, lsl #0x2]
	ldr r10, [r0, r10, lsl #0x2]
	mvn r11, r5
	orr r11, r7, r11
	eor r11, r6, r11
	add r10, r11, r10
	add r10, r9, r10
	add r9, r3, #0x2
	add r10, r4, r10
	mov r4, r10, lsl #0xa
	orr r4, r4, r10, lsr #0x16
	add r4, r7, r4
	ldr r12, [r1, r9, lsl #0x2]
	ldrb r9, [lr, r9]
	mvn r10, r6
	orr r10, r4, r10
	eor r11, r7, r10
	ldr r10, [r0, r9, lsl #0x2]
	add r9, r3, #0x3
	add r10, r11, r10
	add r10, r12, r10
	add r10, r5, r10
	mov r5, r10, lsl #0xf
	orr r5, r5, r10, lsr #0x11
	add r5, r4, r5
	ldr r10, [r1, r9, lsl #0x2]
	ldrb r11, [lr, r9]
	mvn r9, r7
	orr r9, r5, r9
	eor r9, r4, r9
	ldr r11, [r0, r11, lsl #0x2]
	add r8, r8, #0x4
	add r9, r9, r11
	add r9, r10, r9
	add r9, r6, r9
	mov r6, r9, lsl #0x15
	orr r6, r6, r9, lsr #0xb
	add r6, r5, r6
	add r3, r3, #0x4
	add r2, r2, #0x1
	cmp r2, #0x4
	blt _020A3EF4
	ldr r0, [sp, #0x0]
	ldr r0, [r0, #0x0]
	add r1, r0, r7
	ldr r0, [sp, #0x0]
	str r1, [r0, #0x0]
	ldr r0, [r0, #0x4]
	add r1, r0, r6
	ldr r0, [sp, #0x0]
	str r1, [r0, #0x4]
	ldr r0, [r0, #0x8]
	add r1, r0, r5
	ldr r0, [sp, #0x0]
	str r1, [r0, #0x8]
	ldr r0, [r0, #0xc]
	add r1, r0, r4
	ldr r0, [sp, #0x0]
	str r1, [r0, #0xc]
	add sp, sp, #0x44
	ldmia sp!, {r4-r11,lr}
	bx lr
	.balign 4
_020A4024: .word itab
_020A4028: .word ktab

	arm_func_start long_from_char
long_from_char: ; 0x020A402C
	ldr ip, _020A4040 ; =MI_CpuCopy8
	mov r3, r0
	mov r0, r1
	mov r1, r3
	bx r12
	.balign 4
_020A4040: .word MI_CpuCopy8

	arm_func_start char_from_long
char_from_long: ; 0x020A4044
	ldr ip, _020A4058 ; =MI_CpuCopy8
	mov r3, r0
	mov r0, r1
	mov r1, r3
	bx r12
	.balign 4
_020A4058: .word MI_CpuCopy8
