---
name: Libraries & Add-ons
permalink: '/about/addons-libraries'
---

# 库和插件


此页收集了一些 Preact 的库与插件.
> :information_desk_person: _构建一个你自己的库？
> [把它加到这里！](https://github.com/preactjs/preact-www/blob/master/content/zh/about/libraries-addons.md)_


### 插件（Add-Ons）

- :raised_hands: [**preact-compat**](https://github.com/preactjs/preact-compat): 让你可以在 Preact 下使用任何 react 的库 *([full example](https://github.com/developit/preact-compat-example))*
- :repeat: [**preact-cycle**](https://github.com/developit/preact-cycle): 基于 Preact 的小型 Vdom 渲染
- :page_facing_up: [**preact-render-to-string**](https://github.com/preactjs/preact-render-to-string): 统一渲染


### 组件（Components）

- :earth_americas: [**preact-router**](https://github.com/preactjs/preact-router): 路由组件
- :bookmark_tabs: [**preact-markup**](https://github.com/developit/preact-markup): 渲染组件或自定义元素（如 jsx）为 html
- :satellite: [**preact-portal**](https://github.com/developit/preact-portal): 渲染 Preact 组件到一个容器内（如 dom 元素）:milky_way:
- :pencil: [**preact-richtextarea**](https://github.com/developit/preact-richtextarea): 简单版的 html 编辑器组件
- :bookmark: [**preact-token-input**](https://github.com/developit/preact-token-input): 用于输入标签的文字框
- :card_index: [**preact-virtual-list**](https://github.com/developit/preact-virtual-list): 可轻松渲染百万行数据到 list 中 ([demo](https://jsfiddle.net/developit/qqan9pdo/))
- :triangular_ruler: [**preact-layout**](https://download.github.io/preact-layout/): 一款小而简单的布局库


### 集成（Integrations）

- :thought_balloon: [**preact-socrates**](https://github.com/matthewmueller/preact-socrates): 针对 [Socrates](https://github.com/matthewmueller/socrates) 的 Preact 插件(http://github.com/matthewmueller/socrates)
- :rowboat: [**preact-flyd**](https://github.com/xialvjun/preact-flyd): 在 Preact + jsx 上使用 [flyd](https://github.com/paldepind/flyd) FRP streams


### GUI 工具（GUI Toolkits）

- :white_square_button: [**preact-mdl**](https://github.com/developit/preact-mdl): 使用 [MDL](https://getmdl.io) 制作 Preact 组件
- :rocket: [**preact-photon**](https://github.com/developit/preact-photon): 基于 [photon](http://photonkit.com) 构建桌面 app


### 测试（Testing）

- :microscope: [**preact-jsx-chai**](https://github.com/developit/preact-jsx-chai): jsx 断言测试 _（仅在 Node 下使用，不支持 DOM）_


### 基础库（Utilities）

- :tophat: [**preact-classless-component**](https://github.com/ld0rman/preact-classless-component): 不使用 class 关键字创建 preact 组件 
- :hammer: [**preact-hyperscript**](https://github.com/queckezz/preact-hyperscript): 使用 Hyperscript 的语法创建元素 
- :white_check_mark: [**shallow-compare**](https://github.com/tkh44/shallow-compare): 简单的 `shouldComponentUpdate` 帮助库，快速深度对比
