---
name: Demos & Examples
permalink: '/about/demos-examples'
---

# 示例

此页列出了一些你可以用来学习 Preact 的示例

> :information_desk_person: _构建一个你自己的模块?
> [Add it!](https://github.com/preactjs/preact-www/blob/master/content/zh/about/demos-examples.md)_


## 完整的 app

[**Preact Website** _(preactjs.com)_](https://preactjs.com)  
该网站基于 Preact。
[Github Project](https://github.com/preactjs/preact-www)

**[ESBench](http://esbench.com)** :alarm_clock:  
基于 Preact & Material Design Lite

[**GuriVR**](https://gurivr.com) :eyeglasses:
基于自然语言的网络VR故事创造器。
[Github Project](https://github.com/opennewslabs/guri-vr)

[**BigWebQuiz**](https://bigwebquiz.com) :game_die:  
2016年Chrome Dev峰会上观众参与的渐进式网络应用程序!
[Github Project](https://github.com/jakearchibald/big-web-quiz)

**[Nectarine.rocks](http://nectarine.rocks)** :peach:  
一款开源的 peach.cool app。
[Github Project](https://github.com/developit/nectarine)

**[Web Maker](https://webmaker.app/)** :zap:
急速并支持离线的前端游乐场。
[Github Project](https://github.com/chinchang/web-maker)

**[BitMidi](https://bitmidi.com/)** :musical_keyboard:
免费MIDI文件回放机
[Github Project](https://github.com/feross/bitmidi.com)

**[BBC Roasting Calculator](https://www.bbc.com/food/techniques/articles/roast-calculator)** :turkey:
计算不同种类的肉烹饪时间。

**[Dropfox](https://github.com/developit/dropfox)** :wolf:  
Dropbox 的桌面 app，基于 Preact、Electron 和 Photon。

**[Embed Hacker News](https://github.com/TXTPEN/hn)** :kissing_closed_eyes:
在你的博客文章下面嵌入Hacker News评论树。

**[Connectivity Index](https://cindex.co)** :iphone:  
一个允许您按国家搜索[Akamai互联网连接状况报告](https://content.akamai.com/PG7010-Q2-2016-SOTI-Connectivity-Report.html)数据的网站。

**[Drag & Drop file upload (webpack 2)](https://contentful-labs.github.io/file-upload-example/)** :rocket:
用于将资源上传到Contentful（基于API的CMS）的桌面应用程序
[Github Project](https://github.com/contentful-labs/file-upload-example)

**[Exchange Widget](https://sgtpep.github.io/exchange-widget/dist/)** :currency_exchange:
货币兑换小工具,灵感来自于一个流行的移动应用程序，使用Preact、Meiosis、HTML标签模板和本地ES模块实现。
[Github Project](https://github.com/sgtpep/exchange-widget)

**[Blaze](https://blaze.now.sh)** :zap:  
先进的P2P文件共享的渐进式网络应用程序。
[Github Project](https://github.com/blenderskool/blaze)

**[1tuner](https://1tuner.com)** :radio:  
收听广播和博客
[Github Project](https://github.com/robinbakker/1tuner)

**[ColoGuessr](https://cologuessr.com)** :rainbow:
测试你对自己的颜色有多了解
[Github Project](https://github.com/jackpordi/cologuessr)

## 完整的示例

**[Documentation Viewer](https://documentation-viewer.firebaseapp.com)**  
在线查看 documentation.js 生成的内容。
[Github Project](https://github.com/developit/documentation-viewer)

**[TodoMVC](http://developit.github.io/preact-todomvc/)**  
非官方最快的 TodoMVC 实现。
[Github Project](https://github.com/developit/preact-todomvc)

**[TodoMVC+PouchDB](http://katopz.github.io/preact-todomvc-pouchdb/)** :floppy_disk:  
基于 [PouchDB](https://pouchdb.com/) 离线版 TodoMVC。
[Github Project](https://github.com/katopz/preact-todomvc-pouchdb)

**[Hacker News Minimal](https://developit.github.io/hn_minimal/)** :newspaper:  
小型 hacker news 客户端。
[Github Project](https://github.com/developit/hn_minimal)

**[Preact Boilerplate](https://preact-boilerplate.surge.sh)** :zap:   
两条命令开始一个项目，Preact + Webpack + LESS + CSS Modules.。
[Github Project](https://github.com/developit/preact-boilerplate)

**[Preact Offline Starter](https://preact-starter.now.sh)** :100:  
用于渐进式Web应用支持离线的简化Webpack2启动器，
[Github Project](https://github.com/lukeed/preact-starter)

**[Preact Redux Example](https://preact-redux-example.surge.sh)** :repeat:  
基于 Preact + Redux 的项目，实现一个简单的 To-Do list。
[Github Project](https://github.com/developit/preact-redux-example)

**[Preact Without Babel](https://github.com/developit/preact-without-babel)** :horse:  
怎么在没有 Babel、ES2015 或 JSX 的情况下使用 Preact。

**[preact-minimal](https://github.com/aganglada/preact-minimal)** :rocket:  
一个只包含必要组件的 Preact 脚手架,让你可以马上开始你的项目

**[preact-typescript-webpack4-less](https://github.com/lexey111/preact-typescript-webpack4-boilerplate)**
包含Preact、Typescript和Webpack 4的脚手架

**[Preact Homepage Generator](https://thomaswood.me/)** :globe_with_meridians:  
仅仅需要修改 JSON 文件就可以马上生成一个个人网页
[Github Project](https://github.com/tomasswood/preact-homepage-generator)

**[Parcel + Preact + Unistore Starter](https://github.com/hwclass/parcel-preact-unistore-starter)**
用于快速开发原型设计或者中小项目的启动包


## Codepens 上的例子

- [Flickr Browser](http://codepen.io/developit/full/VvMZwK/) _(@ CodePen)_
- [Animating Text](http://codepen.io/developit/full/LpNOdm/) _(@ CodePen)_
- [60FPS Rainbow Spiral](http://codepen.io/developit/full/xGoagz/) _(@ CodePen)_
- [Simple Clock](http://jsfiddle.net/developit/u9m5x0L7/embedded/result,js/) _(@ JSFiddle)_
- [3D + ThreeJS](http://codepen.io/developit/pen/PPMNjd?editors=0010) _(@ CodePen)_

## 模版

:zap: [**JSFiddle Template**](https://jsfiddle.net/developit/rs6zrh5f/embedded/result/)

:zap: [**CodePen Template**](http://codepen.io/developit/pen/pgaROe?editors=0010)
