---
name: Libraries & Add-ons
permalink: '/about/addons-libraries'
---

# Kütüphaneler & Eklentiler

Preact ile oluşturulmuş mükemmel modül koleksiyonu.
> :information_desk_person: _Kendin için bir tane oluşturdun mu?
> [Sende Ekle!](https://github.com/preactjs/preact-www/blob/master/content/tr/about/libraries-addons.md)_

### Eklentiler
- :raised_hands: [**preact-compat**](https://github.com/preactjs/preact-compat): Herhangi React kütüphanesini Preact ile kullan *([tam örnek](https://github.com/developit/preact-compat-example))*
- :repeat: [**preact-cycle**](https://github.com/developit/preact-cycle): Preact için Functional-reactive paradigma
- :page_facing_up: [**preact-render-to-string**](https://github.com/preactjs/preact-render-to-string): Universal rendering.

### Bileşenler
- :earth_americas: [**preact-router**](https://github.com/preactjs/preact-router): Bileşenlerin için URL yönlendirmesi
- :bookmark_tabs: [**preact-markup**](https://github.com/developit/preact-markup): JSX & Bileşen olarak HTML & Özel Elementler Oluştur
- :satellite: [**preact-portal**](https://github.com/developit/preact-portal): Preact bileşenlerini (bir) SPACE içine yerleştirin :milky_way:
- :pencil: [**preact-richtextarea**](https://github.com/developit/preact-richtextarea): Basit HTML editör bileşeni
- :bookmark: [**preact-token-input**](https://github.com/developit/preact-token-input): Etiket gibi şeyler için token girişi yapılan metin alanı
- :card_index: [**preact-virtual-list**](https://github.com/developit/preact-virtual-list): Milyonlarca satır ile kolayca listeler oluştur ([demo](https://jsfiddle.net/developit/qqan9pdo/))
- :triangular_ruler: [**preact-layout**](https://download.github.io/preact-layout/): Kolay ve basit layout kütüphaneleri
- :construction_worker: [**preact-helmet**](https://github.com/download/preact-helmet): Preact için belge yöneticisi
- :arrow_up_down: [**preact-custom-scrollbars**](https://github.com/lucafalasco/preact-custom-scrollbars): Native tarayıcı scrolling için tam özelleştirilebilir scrollbarlar

### Entegrasyonlar
- :thought_balloon: [**preact-socrates**](https://github.com/matthewmueller/preact-socrates): [Socrates](http://github.com/matthewmueller/socrates) için Preact eklentileri
- :rowboat: [**preact-flyd**](https://github.com/xialvjun/preact-flyd): [flyd](https://github.com/paldepind/flyd) FRP stream'leri Preact + JSX'de kullanın
- :speech_balloon: [**preact-i18nline**](https://github.com/download/preact-i18nline):[i18n-js](https://github.com/everydayhero/i18n-js) çevresindeki ekosistemi [i18nline](https://github.com/download/i18nline) yoluyla Preact ile bütünleştirir.


### GUI Araçları
- :white_square_button: [**preact-mdl**](https://github.com/developit/preact-mdl): Preact bileşenleri olarak [MDL](https://getmdl.io) kullanın.
- :rocket: [**preact-photon**](https://github.com/developit/preact-photon):[photon](http://photonkit.com) ile güzel masaüstü UI'lari oluşturun.
- :penguin: [**preact-weui**](https://github.com/afeiship/preact-weui):Preact için [Weui](https://github.com/afeiship/preact-weui)
- 💅 [**preact-fluid**](https://github.com/ajainvivek/preact-fluid):Preact için minimal [Fluid](https://github.com/ajainvivek/preact-fluid) UI araçları.

### Test Araçları
- :microscope: [**preact-jsx-chai**](https://github.com/developit/preact-jsx-chai): JSX assertion testing _(no DOM, right in Node)_
- :white_check_mark: [**unexpected-preact**](https://github.com/bruderstein/unexpected-preact): JSX assertions, events, snapshots in Jest _(DOM, works under Node jsdom or out-of-the-box in Jest)_ - [docs](https://bruderstein.github.io/unexpected-preact/)


### Yardımcı Uygulamalar

- :tophat: [**preact-classless-component**](https://github.com/ld0rman/preact-classless-component): Sınıf keyword olmadan preact bileşenleri yaratın.
- :hammer: [**preact-hyperscript**](https://github.com/queckezz/preact-hyperscript): Element oluşturmak için Hyperscript-like sözdizimi.
- :white_check_mark: [**shallow-compare**](https://github.com/tkh44/shallow-compare): Basitleştirilmiş `shouldComponentUpdate` yardımcısı.
