---
name: Demos & Examples
permalink: '/about/demos-examples'
---

# Demolar & Örnekler

Bu sayfada Preact öğrenmek için kullanabileceğiniz demolar ve örnekler listelenmiştir.

> :information_desk_person: _Sizin de mi bir örneğiniz var ?
> [Ekleyin!](https://github.com/preactjs/preact-www/blob/master/content/tr/about/demos-examples.md)_


## Tamamlanmış Uygulamalar

[**Preact İnternet Sitesi** _(preactjs.com)_](https://preactjs.com)  
Tabii ki de bu site Preact ile geliştirildi.  
[Github Projesi](https://github.com/preactjs/preact-www)

**[ESBench](http://esbench.com)** :alarm_clock:  
Preact & Material Design Lite kullanarak geliştirildi.

[**GuriVR**](https://gurivr.com) :eyeglasses:
Doğal dil tabanlı Web VR hikaye yaratıcısı. 
_([Github Projesi](https://github.com/opennewslabs/guri-vr))_

[**BigWebQuiz**](https://bigwebquiz.com) :game_die:  
Chrome Dev Summit 2016'dan katılımcılara Progressive Web App sunumu!  
([Github Projesi](https://github.com/jakearchibald/big-web-quiz))

**[Nectarine.rocks](http://nectarine.rocks)** :peach:  
Açık kaynak peach.cool uygulaması.
[Github Projesi](https://github.com/developit/nectarine)

**[Dropfox](https://github.com/developit/dropfox)** :wolf:  
Dropbox için Preact, Electron ve Photon ile oluşturulmuş masaüstü uygulaması.

**[Bağlantı raporu](https://cindex.co)** :iphone:  
Arama yapmanıza izin veren bir site [Akamia şirketinin ülke verilerine göre internet bağlantı raporu](https://content.akamai.com/PG7010-Q2-2016-SOTI-Connectivity-Report.html)

**[Sürükle & Bırak dosya yükleme (webpack 2)](https://contentful-labs.github.io/file-upload-example/)** :rocket:
İçerikleri yüklemeyi sürükle bırak ile yapan bir masaüstü uygulaması. (CMS bazlı API)
[Github Projesi](https://github.com/contentful-labs/file-upload-example)

**[Embed Hacker News](https://github.com/TXTPEN/hn)** :kissing_closed_eyes:
Embed Hacker News ile blog yazınızın altına yorumlar bırakın

**[ColoGuessr](https://cologuessr.com)** :rainbow:
Renklerinizi ne kadar iyi tanıdığınızı test edin
[Github Project](https://github.com/jackpordi/cologuessr)

## Demolar & Örnekler

**[Dökümantasyon görüntüleyici](https://documentation-viewer.firebaseapp.com)**  
Documentation.js çıktısını çevrimiçi görüntülemenize yarar.
[Github Projesi](https://github.com/developit/documentation-viewer)

**[TodoMVC](http://developit.github.io/preact-todomvc/)**  
Gayri resmi en hızlı TodoMVC uygulaması.  
[Github Projesi](https://github.com/developit/preact-todomvc)

**[TodoMVC+PouchDB](http://katopz.github.io/preact-todomvc-pouchdb/)** :floppy_disk:  
Çevrimdışı senkronizasyon destekli TodoMVC [PouchDB](https://pouchdb.com/).  
[Github Projesi](https://github.com/katopz/preact-todomvc-pouchdb)

**[Hacker News Minimal](https://developit.github.io/hn_minimal/)** :newspaper:  
Oldukça miminal olarak hazırlanmış hacker news web sitesi.  
[Github Projesi](https://github.com/developit/hn_minimal)

**[Preact Boilerplate](https://preact-boilerplate.surge.sh)** :zap:  
Preact + Webpack + LESS + CSS paketlerinin dahil olduğu başlangıç paketi. 
[Github Projesi](https://github.com/developit/preact-boilerplate)

**[Preact Çevrimdışı Başlangıç Kiti](https://preact-starter.now.sh)** :100:  
Webpack2 kullanan Progressive Web Apps ve çevrımdışı destekli başlangıç paketi.  
[Github Projesi](https://github.com/lukeed/preact-starter)

**[Preact Redux Örneği](https://preact-redux-example.surge.sh)** :repeat:  
Preact + Redux örnek proje, basit bir to-do list'e uygulanması. 
[Github Projesi](https://github.com/developit/preact-redux-example)

**[Babel'siz Preact](https://github.com/developit/preact-without-babel)** :horse:  
Preact'ı Babel, ES2015 veya JSX olmadan kullanan bir proje.

**[preact-minimal](https://github.com/aganglada/preact-minimal)** :rocket:  
Minimal Preact yapısı ile projenizi hemen başlatmak için gerekli tüm araçlar.

**[Preact Kişisel Site Oluşturucu](https://thomaswood.me/)** :globe_with_meridians:  
Yalnızca json verileri değiştirerek, oldukça hızlı bir şekilde kişisel web sitenizi oluşturun.
[Github Projesi](https://github.com/tomasswood/preact-homepage-generator)

**[Parcel + Preact + Unistore Başlangıç](https://github.com/hwclass/parcel-preact-unistore-starter)**
Yıldırım hızında bir başlangıç kiti. Küçük/Orta ölçekli proje yapıları için ideal.

## Codepens

- [Flickr Tarayıcı](http://codepen.io/developit/full/VvMZwK/) _(@ CodePen)_
- [Animasyonlu Metin](http://codepen.io/developit/full/LpNOdm/) _(@ CodePen)_
- [60FPS Gökkuşağı Spriali](http://codepen.io/developit/full/xGoagz/) _(@ CodePen)_
- [Basit Saat](http://jsfiddle.net/developit/u9m5x0L7/embedded/result,js/) _(@ JSFiddle)_
- [3D + ThreeJS](http://codepen.io/developit/pen/PPMNjd?editors=0010) _(@ CodePen)_

## Templates

:zap: [**JSFiddle Template**](https://jsfiddle.net/developit/rs6zrh5f/embedded/result/)

:zap: [**CodePen Template**](http://codepen.io/developit/pen/pgaROe?editors=0010)
