---
name: Формы
permalink: '/guide/forms'
---

# Формы


Формы в Preact работают так же, как и в React, за исключением отсутствия поддержки «статических» (с начальным значением) атрибутов.

**[Документация React о формах](https://reactjs.org/docs/forms.html)**

---

<div><toc></toc></div>

---

## Управляемые и неуправляемые компоненты

Документация React по [Управляемым компонентам](https://reactjs.org/docs/forms.html#controlled-components) и [Неуправляемым компонентам](https://reactjs.org/docs/uncontrolled-components.html) очень полезна для понимания того, как взять HTML-формы, которые имеют двунаправленный поток данных, и использовать их в контексте компонентного виртуального DOM-рендерера, который обычно имеет однонаправленный поток данных.

В целом, вы должны стараться всегда использовать _управляемые_ компоненты. Однако при создании автономных компонентов или обёртывании сторонних библиотек пользовательского интерфейса может оказаться полезным просто использовать ваш компонент в качестве точки монтирования для функциональности, не связанной с Preact. В таких случаях _неуправляемые_ компоненты отлично подходят для решения этой задачи.


## Флажки и переключатели

Флажки и переключатели (`<input type="checkbox|radio">`) поначалу могут вызывать путаницу при создании контролируемых форм. Это происходит потому, что в неконтролируемой среде мы обычно позволяем браузеру «переключать» или «проверять» флажок или переключатель за нас, слушая событие изменения и реагируя на новое значение. Однако эта техника не очень хорошо переходит в картину мира, где пользовательский интерфейс всегда обновляется автоматически в ответ на изменения состояния и атрибутов.

> **Объяснение:** Допустим, мы прослушиваем событие `change` на флажке, которое срабатывает, когда флажок устанавливается или снимается пользователем. В обработчике события изменения мы установим значение в `state` на новое значение, полученное от флажка. Это вызовет повторный рендеринг нашего компонента, который заново присвоит значение флажка значению из состояния. В этом нет необходимости, потому что мы просто запросили у DOM значение, а затем сказали ему отрисовать его снова с тем значением, которое мы хотим.

Итак, вместо того, чтобы слушать событие `change`, мы должны слушать событие `click`, которое срабатывает каждый раз, когда пользователь нажимает на флажок _или связанную с ним `<label>`_. Флажки просто переключаются между булевыми `true` и `false`, поэтому, щёлкнув по флажку или метке, мы просто инвертируем любое значение, которое у нас есть в состоянии, вызывая повторный рендеринг, меняя отображаемое значение флажка на то, которое нам нужно.

### Пример флажка

```js
class MyForm extends Component {
    toggle = e => {
        let checked = !this.state.checked;
        this.setState({ checked });
    };
    render({ }, { checked }) {
        return (
            <label>
                <input
                    type="checkbox"
                    checked={checked}
                    onClick={this.toggle} />
            </label>
        );
    }
}
```
