---
name: Внешние мутации DOM
permalink: '/guide/external-dom-mutations'
---

# Внешние мутации DOM


## Обзор

Иногда возникает необходимость работать со сторонними библиотеками, которые ожидают, что смогут свободно изменять DOM, сохранять состояние внутри него или вообще не имеют границ компонентов.  Существует множество отличных наборов инструментов пользовательского интерфейса или многократно используемых элементов, которые работают именно таким образом. В Preact (и аналогично в React) работа с такими библиотеками требует, чтобы вы сообщили алгоритму рендеринга/дифференцирования Virtual DOM, что он не должен пытаться _отменять_ любые внешние мутации DOM, выполняемые в рамках данного компонента (или элемента DOM, который он представляет).


## Техника

Это может быть просто определение метода `shouldComponentUpdate()` для вашего компонента и его возврат `false`:

```js
class Block extends Component {
  shouldComponentUpdate() {
    return false;
  }
}
```

... или сокращённо:

```js
class Block extends Component {
  shouldComponentUpdate = () => false;
}
```

Благодаря этому хуку жизненного цикла и указанию Preact не перерисовывать компонент при изменениях в дереве VDOM, ваш компонент теперь имеет ссылку на свой корневой элемент DOM, который можно рассматривать как статический до тех пор, пока компонент не будет размонтирован. Как и в любом компоненте, эта ссылка называется просто `this.base` и соответствует корневому JSX-элементу, который был возвращен из `render()`.

---

## Пример пошагового руководства

Вот пример «отключения» повторного рендеринга для компонента. Обратите внимание, что метод `render()` по-прежнему вызывается как часть создания и монтирования компонента, чтобы сгенерировать его исходную структуру DOM.

```js
class Example extends Component {
  shouldComponentUpdate() {
    // не пересчитывать через diff:
    return false;
  }

  componentWillReceiveProps(nextProps) {
    // здесь можно что-то сделать с входящими параметрами, если нужно
  }

  componentDidMount() {
    // компонент смонтирован, можно свободно модифицировать DOM:
    let thing = document.createElement('maybe-a-custom-element');
    this.base.appendChild(thing);
  }

  componentWillUnmount() {
    // компонент будет удален из DOM, выполняем все необходимые действия по очистке
  }

  render() {
    return <div class="example" />;
  }
}
```


## Демонстрация

[![demo](https://i.gyazo.com/a63622edbeefb2e86d6c0d9c8d66e582.gif)](http://www.webpackbin.com/V1hyNQbpe)

[**Посмотреть эту демонстрацию на Webpackbin**](https://www.webpackbin.com/bins/-KflCmJ5bvKsRF8WDkzb)


## Реальные примеры

В качестве альтернативы можно посмотреть на этот прием в [preact-token-input](https://github.com/developit/preact-token-input/blob/master/src/index.js) — он использует компонент как точку опоры в DOM, но затем отключает обновления и позволяет [tags-input](https://github.com/developit/tags-input) взять на себя управление. Более сложным примером может служить [preact-richtextarea](https://github.com/developit/preact-richtextarea), в котором эта техника используется для того, чтобы избежать повторного отображения редактируемого `<iframe>`.
