---
name: Опционные хуки
description: 'В Preact есть несколько опционных хуков, которые позволяют прикреплять обратные вызовы к различным этапам процесса сравнения.'
---

# Опционные хуки

Обратные вызовы для плагинов, которые могут изменять рендеринг Preact.

Preact поддерживает ряд различных обратных вызовов, которые могут быть использованы для наблюдения или изменения каждого этапа процесса рендеринга, обычно называемых «опционными «хуками» (не путать с [обычными хуками](/guide/v10/hooks)). Они часто используются для расширения функциональных возможностей самого Preact или для создания специализированных средств тестирования. Все наши аддоны, такие как `preact/hooks`, `preact/compat` и наше расширение devtools, основаны на этих обратных вызовах.

Этот API предназначен в первую очередь для авторов инструментов и библиотек, желающих расширить возможности Preact.

---

<div><toc></toc></div>

---

## Версионирование и поддержка

Опционные хуки поставляются в Preact и поэтому имеют семантическое версионирование. Однако у них нет одинаковой политики прекращения поддержки, а это означает, что основные версии могут изменить API без расширенного периода объявлений, предшествующего выпуску. Это также верно для структуры внутренних API, предоставляемых через хуки параметров, таких как объекты `VNode`.

## Настройка опционных хуков

Вы можете установить опционные хуки в Preact, изменив экспортированный объект `options`.

При определении хука всегда обязательно вызывайте ранее определённый хук с таким именем, если он существовал. Без этого цепочка вызовов будет нарушена, а код, зависящий от ранее установленного хука, сломается, в результате чего такие дополнения, как `preact/hooks` или DevTools, перестанут работать. Обязательно передайте те же аргументы исходному хуку — если только у вас нет особой причины их менять.

```js
import { options } from 'preact';

// Сохраняем предыдущий хук
const oldHook = options.vnode;

// Задаём наш собственный опционный хук
options.vnode = (vnode) => {
  console.log("Hey I'm a vnode", vnode);

  // Вызываем ранее определённый хук, если он был
  if (oldHook) {
    oldHook(vnode);
  }
};
```

Ни один из доступных в настоящее время хуков, за исключением `options.event`, не имеет возвращаемых значений, поэтому обработка возвращаемых значений из исходного хука не требуется.

## Доступные опционные хуки

#### `options.vnode`

**Сигнатура:** `(vnode: VNode) => void`

Наиболее распространённый опционный хук, `vnode`, вызывается всякий раз, когда создается объект VNode. VNodes — это представление Preact элементов Virtual DOM, обычно называемых «элементами JSX».

#### `options.unmount`

**Сигнатура:** `(vnode: VNode) => void`

Вызывается непосредственно перед размонтированием vnode, когда его DOM-представление всё ещё подключено.

#### `options.diffed`

**Сигнатура:** `(vnode: VNode) => void`

Вызывается сразу после визуализации vnode, как только его DOM-представление создано или преобразовано в правильное состояние.

#### `options.event`

**Сигнатура:** `(event: Event) => any`

Вызывается непосредственно перед тем, как событие DOM обрабатывается связанным с ним прослушивателем Virtual DOM. Когда установлен `options.event`, событие, которое является аргументом прослушивателя событий, заменяется возвращаемым значением `options.event`.

#### `options.requestAnimationFrame`

**Сигнатура:** `(callback: () => void) => void`

Управляет планированием эффектов и основанной на эффектах функциональностью в `preact/hooks`.

#### `options.debounceRendering`

**Сигнатура:** `(callback: () => void) => void`

Функция «отсрочки» по времени, которая используется для пакетной обработки обновлений в глобальной очереди рендеринга компонентов.

По умолчанию в Preact используется `setTimeout` с нулевой длительностью.

#### `options.useDebugValue`

**Сигнатура:** `(value: string | number) => void`

Вызывается при вызове хука `useDebugValue` в `preact/hooks`.
