---
title: Preact X, история стабильности
date: 2024-05-24
authors:
  - Jovi De Croock
---

# Preact X — история стабильности

Многие из вас ждали [версию v11 Preact](https://github.com/preactjs/preact/issues/2621), анонсированную в одном из открытых выпусков.
ещё в июле 2020 года, и, честно говоря, я был одним из тех, кто с нетерпением ждал выхода v11.
Когда мы начали думать о Preact 11, мы считали, что нет способа внедрить изменения, которые мы задумали в Preact X, не нарушив при этом некоторые из тех вещей, которые мы задумали:

- Используя структуру резервного VNode для уменьшения GC, мы будем использовать только результат `h()` для обновления нашего резервного узла.
- Согласование производительности, позволяющее оптимизировать пути для монтирования/размонтирования/и т. д.
- Некоторые изменения, такие как удаление суффикса `px`, `forwardRef` и отказ от поддержки IE11.
- Хранение ref в пропсах.
- Устранение ошибок, связанных с различием событий и потомков.

Это были наши первоначальные цели для версии 11, но, пройдя по этому пути, мы поняли, что многие из этих изменений на самом деле не являются критическими изменениями и могут быть выпущены непосредственно в версии 10 без нарушения её работы. Только третий пункт, удаление суффикса `px` и передача `ref` непосредственно в пропсах, а также отказ от IE11, попадают в категорию разрушающих изменений. Мы решили выпустить остальные функции в стабильной версии v10, что позволит любому пользователю Preact сразу же воспользоваться ими без необходимости вносить изменения в свой код.

Сегодня у Preact гораздо большая база пользователей по сравнению с тем, когда мы планировали выпускать v11. Он широко используется во многих малых и крупных компаниях для критически важного программного обеспечения. Мы действительно хотим быть уверены, что любые кардинальные изменения, которые мы можем внести, абсолютно оправдают затраты на перевод на них всей экосистемы.

В процессе [экспериментов](https://github.com/preactjs/preact/tree/v11) мы перешли к новому типу диффинга, названному [диффинг на основе перекоса](https://github.com/preactjs/preact/pull/3388), и увидели реальный прирост производительности, а также исправили кучу давних ошибок. Со временем, когда мы стали уделять больше времени экспериментам с Preact 11, мы начали замечать, что улучшения, которые мы внедряли, не обязательно должны быть исключительно в Preact 11.

## Релизы

С момента выхода вышеупомянутого выпуска Preact 11 было выпущено 18 (!!!) минорных версий Preact X.
Многие из них были непосредственно вдохновлены работой над Preact 11. Давайте рассмотрим некоторые из них и оценим их влияние.

### 10.5.0

Введение [возобновлённой гидратации](https://github.com/preactjs/preact/pull/2754) — эта функциональность в основном позволяет приостанавливать работу во время повторной гидратации вашего дерева компонентов. Это означает, что, например, в следующем дереве компонентов мы повторно гидрируем и сделаем интерактивным `Header`, в то время как `LazyArticleHeader` приостановится, а тем временем отрендеренный сервером DOM останется на экране. Когда ленивая загрузка завершится, мы продолжим повторную гидратацию, с нашими `Header` и `LazyArticleHeader` можно будет работать, пока наши `LazyContents` разрешаются. Это довольно мощная функция, позволяющая сделать наиболее важные материалы интерактивными, не перегружая при этом размер скачиваемого пакета.

```jsx
const App = () => {
  return (
    <>
      <Header>
      <main>
        <Suspense>
          <LazyArticleHeader />
          <Suspense>
            <article>
              <LazyContents />
            </article>
          </Suspense>
        </Suspense>
      </main>
    </>
  )
}
```

### 10.8.0

В 10.8.0 мы ввели [регулировку состояния](https://github.com/preactjs/preact/pull/3553), которая гарантирует, что если компонент обновляет состояние хука во время рендеринга, мы подхватим это, отменим предыдущие эффекты и продолжим рендеринг. Нам, конечно, придется следить за тем, чтобы это не зацикливалось, но эта функция уменьшает количество рендеров, которые стоят в очереди из-за обращений к состоянию рендера. Эта функция также повышает нашу совместимость с экосистемой React, поскольку многие библиотеки полагаются на то, что эффекты не будут вызываться несколько раз из-за обновлений состояния рендера.

### 10.11.0

После долгих поисков мы нашли способ внедрить [useId](https://github.com/preactjs/preact/pull/3583) в Preact, что потребовало тонны исследований того, как мы можем добавить уникальные значения для данной древовидной структуры. Один из наших сопровождающих написал о [нашем тогдашнем исследовании](https://www.jovidecroock.com/blog/preact-use-id), и с тех пор мы дорабатывали его, стараясь сделать его как можно более свободным от коллизий...

### 10.15.0

Мы обнаружили, что при повторном рендеринге, в результате которого рендерится множество новых компонентов, наша `rerenderQueue` может быть не в порядке, что приводит к тому, что наши (контекстные) обновления распространяются на компоненты, которые после этого снова рендерятся с устаревшими значениями, вы можете посмотреть [сообщение о фиксации](https://github.com/preactjs/preact/commit/672782adbf9ccefa7a4d7c175f0adf8580f73c92) для действительно подробного объяснения! Это позволяет как ускорить процесс обновления, так и увеличить количество библиотек React.

### 10.16.0

В ходе работы над v11 мы глубоко изучили вопрос различия потомков, поскольку знали, что есть несколько случаев, когда наш текущий алгоритм не справляется с задачей:

- [удаление элемента перед другим приведёт к повторной вставке](https://github.com/preactjs/preact/issues/3973)
- [повторная вставка при удалении нескольких потомков](https://github.com/preactjs/preact/issues/2622)
- [ненужное размонтирование узлов с ключами](https://github.com/preactjs/preact/issues/2783)

Не все из них приводили к плохому состоянию, некоторые просто снижали производительность... Когда мы узнали, что можем перенести диффинг на основе перекоса в Preact X, мы были в восторге: мы не только исправили множество случаев, но и смогли увидеть, как этот алгоритм ведет себя в реальных условиях! Оглядываясь назад, можно сказать, что все прошло отлично, но иногда я хотел бы, чтобы у нас были хорошие тестовые стенды, на которых мы могли бы их запустить, а не чтобы наше сообщество сообщало о проблемах. Я хочу воспользоваться этой возможностью и поблагодарить вас всех за то, что вы всегда помогаете нам в решении вопросов с репродукциями, вы все — лучшие!

### 10.19.0

В 10.19.0 Марвин применил свои исследования из [fresh](https://fresh.deno.dev/), чтобы добавить [предварительно скомпилированные функции JSX](https://github.com/preactjs/preact/pull/4177), это в основном позволяет вам предварительно компилировать ваши компоненты во время транспиляции, когда выполняется render-to-string, мы просто должны конкатенировать строки, а не выделять память для всего дерева VNode. Трансформация для этого на данный момент является эксклюзивной для Deno, но общая концепция присутствует в Preact!

### 10.20.2

Мы столкнулись с рядом проблем, когда событие могло перетекать в только что вставленный VNode, что приводило к нежелательному поведению. Это было исправлено [добавлением часов событий](https://github.com/preactjs/preact/pull/4322). В следующем сценарии вы нажимаете на кнопку, которая устанавливает состояние, браузер чередует всплески событий с микро-тактами, что также используется Preact для планирования обновлений. Эта комбинация означает, что Preact обновит UI, а это значит, что `<div>` получит обработчик `onClick`, к которому мы подберёмся и снова вызовем `click`, чтобы немедленно отключить это состояние.

```jsx
const App = () => {
  const [toggled, setToggled] = useState(false);

  return toggled ? (
    <div onClick={() => setToggled(false)}>
      <span>clear</span>
    </div> 
  ) : (
    <div>
      <button
        onClick={() => setToggled(true)}
      >toggle on</button>
    </div>
  )
}
```

## Стабильность

Выше перечислены некоторые релизы, которые наше сообщество получило без изменений, но есть и многое другое... Добавление новой основной версии всегда оставляет часть сообщества позади, а мы не хотим этого делать. Если мы посмотрим на линейку релизов Preact 8, то увидим, что за последнюю неделю было загружено 100.000 копий, а последний релиз 8.x был выпущен 5 лет назад, просто чтобы показать, что часть сообщества осталась позади.

Стабильность — это здорово, мы, команда Preact, любим стабильность. Мы выпустили несколько крупных функций в других проектах экосистемы:

- [Сигналы](https://github.com/preactjs/signals)
- [Асинхронный рендеринг](https://github.com/preactjs/preact-render-to-string/pull/333)
- [Потоковая визуализация](https://github.com/preactjs/preact-render-to-string/pull/354)
- [Prefresh](https://github.com/preactjs/prefresh)
- [Пресет Vite с предварительным рендерингом](https://github.com/preactjs/preset-vite#prerendering-configuration)
- [Новый асинхронный маршрутизатор](https://github.com/preactjs/preact-iso)
- [Create Preact](https://github.com/preactjs/create-preact)

Мы ценим нашу экосистему и расширения, создаваемые с помощью нашего [`options API`](https://marvinh.dev/blog/preact-options/), и это одна из главных причин, по которой мы не хотим вносить эти разрушительные изменения, а вместо этого позволяем вам всем воспользоваться результатами наших исследований без болезненного пути миграции.

Это не значит, что Preact 11 не состоится, но, возможно, это будет не то, о чем мы изначально думали. Вместо этого мы можем просто отказаться от поддержки IE11 и получить прирост производительности, обеспечив при этом стабильность Preact X. Существует множество других идей, и мы очень заинтересованы в более широком опыте Preact в контексте мета-фреймворков, которые обеспечивают такие вещи, как маршрутизация из коробки. Мы исследуем этот угол в нашем пресете vite, а также [Fresh](https://fresh.deno.dev/), чтобы получить представление о том, как должен выглядеть первый мета-фреймворк Preact.
