---
name: Библиотеки и дополнения
permalink: '/about/addons-libraries'
description: 'Коллекция библиотек и дополнений, которые хорошо работают с Preact.'
---

# Библиотеки и дополнения

Набор модулей, предназначенных для совместной работы с Preact.

> :information_desk_person: _У вас есть свой модуль?
> [Добавьте его!](https://github.com/preactjs/preact-www/blob/master/content/en/about/libraries-addons.md)_

## Дополнения

- :repeat: [**preact-cycle**](https://github.com/developit/preact-cycle): Функционально-реактивная парадигма для Preact
- :page_facing_up: [**preact-render-to-string**](https://github.com/preactjs/preact-render-to-string): Универсальный рендеринг.
- :timer_clock: [**relaks**](https://github.com/trambarhq/relaks): Создавайте компоненты с методами рендеринга, которые возвращаются асинхронно.
- :nut_and_bolt: [**express-preact-views**](https://github.com/edwjusti/express-preact-views): Express View Engine.
- :floppy_disk: [**Prefresh**](https://github.com/JoviDeCroock/prefresh): Fast-Refresh для Preact.

## Компоненты

- :earth_americas: [**preact-router**](https://github.com/preactjs/preact-router): Маршрутизация URL-адресов для ваших компонентов
- :bookmark_tabs: [**preact-markup**](https://github.com/developit/preact-markup): Рендеринг HTML и пользовательских элементов в виде JSX и компонентов
- :satellite: [**preact-portal**](https://github.com/developit/preact-portal): Рендеринг компонентов Preact в SPACE :milky_way:
- :pencil: [**preact-richtextarea**](https://github.com/developit/preact-richtextarea): Простой компонент HTML-редактора
- :bookmark: [**preact-token-input**](https://github.com/developit/preact-token-input): Текстовое поле, в котором происходит токенизация вводимых данных, для таких вещей, как теги
- :card_index: [**preact-virtual-list**](https://github.com/developit/preact-virtual-list): Удобное отображение списков с миллионами строк ([demo](https://jsfiddle.net/developit/qqan9pdo/))
- :triangular_ruler: [**preact-layout**](https://download.github.io/preact-layout/): Небольшая и простая библиотека макетов
- :construction_worker: [**preact-helmet**](https://github.com/download/preact-helmet): Главный менеджер документов для Preact
- :arrow_up_down: [**preact-custom-scrollbars**](https://github.com/lucafalasco/preact-custom-scrollbars): Полностью настраиваемые полосы прокрутки для удобной прокрутки в браузере.
- 🧱 [**@modular-forms/preact**](https://modularforms.dev/): Модульная и типобезопасная библиотека форм.

## Интеграции

- :thought_balloon: [**preact-socrates**](https://github.com/matthewmueller/preact-socrates): Плагин Preact для [Socrates](http://github.com/matthewmueller/socrates)
- :rowboat: [**preact-flyd**](https://github.com/xialvjun/preact-flyd): Use [flyd](https://github.com/paldepind/flyd) Потоки FRP в Preact + JSX
- :speech_balloon: [**preact-i18nline**](https://github.com/download/preact-i18nline): Интегрирует экосистему вокруг [i18n-js](https://github.com/everydayhero/i18n-js) с Preact через [i18nline](https://github.com/download/i18nline).
- :diamond_shape_with_a_dot_inside: [**Capacitor**](https://capacitorjs.com/solution/preact): Превратите свое приложение Preact в нативное приложение для iOS/Android и PWA.
- 🏝: [**preact-island**](https://github.com/mwood23/preact-island): Запустите виджет Preact на любом веб-сайте с реактивными реквизитами.

## Инструментальные средства графического интерфейса

- 🎴 [**@mui/material**](https://github.com/mui/material-ui/tree/master/examples/material-ui-preact): библиотека React UI, которую вы всегда хотели. Следуйте своей собственной системе дизайна или начните с Material Design.
- :thumbsup: [**preact-material-components**](https://github.com/prateekbh/preact-material-components): Материальные компоненты для Интернета (заменяют MDL)
- :white_square_button: [**preact-mdl**](https://github.com/developit/preact-mdl): Используйте [MDL](https://getmdl.io) в качестве компонентов Preact
- :rocket: [**preact-photon**](https://github.com/developit/preact-photon): Создание красивых пользовательских интерфейсов на рабочем столе с помощью [photon](http://photonkit.com)
- :penguin: [**preact-weui**](https://github.com/afeiship/preact-weui): [Weui](https://github.com/afeiship/preact-weui) для Preact
- 💅 [**preact-fluid**](https://github.com/ajainvivek/preact-fluid): [Fluid](https://github.com/ajainvivek/preact-fluid) — минимальный набор пользовательских интерфейсов для Preact
- :book: [**storybook-preact**](https://github.com/storybooks/storybook/tree/next/app/preact): Storybook for Preact — это среда разработки пользовательского интерфейса для компонентов Preact.

### Тестирование

- :microscope: [**preact-jsx-chai**](https://github.com/developit/preact-jsx-chai): Тестирование утверждений JSX _(без DOM, прямо в Node)_.
- :white_check_mark: [**unexpected-preact**](https://github.com/bruderstein/unexpected-preact): JSX утверждения, события, снимки в Jest *(DOM, работает под Node jsdom или «из коробки» в Jest)* — [docs](https://bruderstein.github.io/unexpected-preact/)

## Утилиты

- :tophat: [**preact-classless-component**](https://github.com/ld0rman/preact-classless-component): создание компонентов preact без ключевого слова `class`
- :hammer: [**preact-hyperscript**](https://github.com/queckezz/preact-hyperscript): Гиперскриптоподобный синтаксис для создания элементов
- :white_check_mark: [**shallow-compare**](https://github.com/tkh44/shallow-compare): Упрощенный хэлпер `shouldComponentUpdate`.
- :signal_strength: [**@deepsignal/preact**](https://github.com/EthanStandel/deepsignal/tree/main/packages/preact): Расширение `@preact/signals` для полного управления состояниями
