---
name: Демонстрации и примеры
permalink: '/about/demos-examples'
description: 'Коллекция демо-версий и примеров приложений Preact'
---

# Демонстрации и примеры

На этой странице перечислено множество демонстраций и примеров, которые можно использовать для изучения Preact.

> :information_desk_person: _У вас есть свой пример?
> [Добавьте его!](https://github.com/preactjs/preact-www/blob/master/content/en/about/demos-examples.md)_

## Полнофункциональные приложения

[**Сайт Preact** _(preactjs.com)_](https://preactjs.com)
Конечно же, этот сайт построен с помощью Preact.
[Проект Github](https://github.com/preactjs/preact-www)

**[ESBench](http://esbench.com)** :alarm_clock:
Построен на основе Preact и Material Design Lite.

[**GuriVR**](https://gurivr.com) :eyeglasses:
Создатель Web VR историй на основе естественного языка.
[Проект Github](https://github.com/opennewslabs/guri-vr)

[**BigWebQuiz**](https://bigwebquiz.com) :game_die:
Прогрессивное веб-приложение с участием аудитории с Chrome Dev Summit 2016!
[Проект Github](https://github.com/jakearchibald/big-web-quiz)

**[Nectarine.rocks](http://nectarine.rocks)** :peach:
Приложение peach.cool с открытым исходным кодом.
[Проект Github](https://github.com/developit/nectarine)

**[Web Maker](https://webmaker.app/)** :zap:
Удивительно быстрый и автономный фронтенд.
[Проект Github](https://github.com/chinchang/web-maker)

**[BitMidi](https://bitmidi.com/)** :musical_keyboard:
Машина обратного отсчета для бесплатных MIDI-файлов
[Проект Github](https://github.com/feross/bitmidi.com)

**[BBC Roasting Calculator](https://www.bbc.com/food/techniques/articles/roast-calculator)** :turkey:
Рассчитывает время приготовления различных кусков мяса.

**[Dropfox](https://github.com/developit/dropfox)** :wolf:
Настольное приложение для Dropbox, созданное на основе Preact, Electron и Photon.

**[Embed Hacker News](https://github.com/TXTPEN/hn)** :kissing_closed_eyes:
Вставьте дерево комментариев Hacker News под статью в своем блоге.

**[Connectivity Index](https://cindex.co)** :iphone:
Сайт, позволяющий осуществлять поиск данных [Akamai о состоянии подключения к Интернету](https://content.akamai.com/PG7010-Q2-2016-SOTI-Connectivity-Report.html) по странам.

**[Drag & Drop file upload (webpack 2)](https://contentful-labs.github.io/file-upload-example/)** :rocket:
Настольное приложение для загрузки ресурсов в Contentful (CMS на основе API)
[Проект Github](https://github.com/contentful-labs/file-upload-example)

**[Exchange Widget](https://sgtpep.github.io/exchange-widget/dist/)** :currency_exchange:
Виджет обмена валюты, вдохновленный популярным мобильным приложением, реализованным с использованием Preact, Meiosis, шаблонов с тегами HTML и собственных модулей ES.
[Проект Github](https://github.com/sgtpep/exchange-widget)

**[Blaze](https://blaze.now.sh)** :zap:
Современный одноранговый обмен файлами Progressive Web App.
[Проект Github](https://github.com/blenderskool/blaze)

**[1tuner](https://1tuner.com)** :radio:
Слушайте радио и подкасты.
[Проект Github](https://github.com/robinbakker/1tuner)

**[ColoGuessr](https://cologuessr.com)** :rainbow:
Проверьте, насколько хорошо вы знаете свои цвета
[Проект Github](https://github.com/jackpordi/cologuessr)

## Полнофункциональные демонстрации и примеры

**[Documentation Viewer](https://documentation-viewer.firebaseapp.com)**
Просмотрите выходные данные document.js онлайн.
[Проект Github](https://github.com/developit/documentation-viewer)

**[TodoMVC](http://developit.github.io/preact-todomvc/)**
Неофициальная самая быстрая реализация TodoMVC.
[Проект Github](https://github.com/developit/preact-todomvc)

**[TodoMVC+PouchDB](http://katopz.github.io/preact-todomvc-pouchdb/)** :floppy_disk:
Автономная синхронизация TodoMVC с [PouchDB](https://pouchdb.com/).
[Проект Github](https://github.com/katopz/preact-todomvc-pouchdb)

**[Hacker News Minimal](https://developit.github.io/hn_minimal/)** :newspaper:
Маленький хакерский новостной клиент.
[Проект Github](https://github.com/developit/hn_minimal)

**[Preact Boilerplate](https://preact-boilerplate.surge.sh)** :zap:
2-командный стартовый проект. Preact + Webpack + LESS + модули CSS.
[Проект Github](https://github.com/developit/preact-boilerplate)

**[Preact Offline Starter](https://preact-starter.now.sh)** :100:
Упрощенный стартовый пакет Webpack2 для Progressive Web Apps с автономной поддержкой.
[Проект Github](https://github.com/lukeed/preact-starter)

**[Пример Preact Redux](https://preact-redux-example.surge.sh)** :repeat:
Пример проекта Preact + Redux, реализующий простой список дел.
[Проект Github](https://github.com/developit/preact-redux-example)

**[Preact без Babel](https://github.com/developit/preact-without-babel)** :horse:
Как использовать Preact полностью без Babel, ES2015 или JSX.

**[preact-minimal](https://github.com/aganglada/preact-minimal)** :rocket:
Минимальная структура Preact со всеми необходимыми инструментами для немедленного запуска вашего проекта.

**[preact-typescript-webpack4-less](https://github.com/lexey111/preact-typescript-webpack4-boilerplate)**
Ещё один минимальный набор с Preact, Typescript и Webpack 4.

**[Preact Homepage Generator](https://thomaswood.me/)** :globe_with_meridians:
Быстро создайте новую личную веб-страницу, всего лишь изменив данные JSON.
[Проект Github](https://github.com/tomasswood/preact-homepage-generator)

**[Parcel + Preact + Unistore Starter](https://github.com/hwclass/parcel-preact-unistore-starter)**
Стартовый пакет для молниеносного прототипирования и создания структуры проекта малого/среднего размера.

## Codepens

- [Flickr Browser](http://codepen.io/developit/full/VvMZwK/) _(@ CodePen)_
- [Animating Text](http://codepen.io/developit/full/LpNOdm/) _(@ CodePen)_
- [60FPS Rainbow Spiral](http://codepen.io/developit/full/xGoagz/) _(@ CodePen)_
- [Simple Clock](http://jsfiddle.net/developit/u9m5x0L7/embedded/result,js/) _(@ JSFiddle)_
- [3D + ThreeJS](http://codepen.io/developit/pen/PPMNjd?editors=0010) _(@ CodePen)_

## Шаблоны

:zap: [**Шаблон JSFiddle**](https://jsfiddle.net/developit/rs6zrh5f/embedded/result/)

:zap: [**Шаблон CodePen**](http://codepen.io/developit/pen/pgaROe?editors=0010)
