---
name: Bibliotecas & Add-ons
permalink: '/about/addons-libraries'
---

# Bibliotecas & Add-ons

Uma coleção de módulos construídos para trabalhar maravilhosamente com Preact.

> :information_desk_person: _Criou algo com preact?
> [Adicione aqui!](https://github.com/preactjs/preact-www/blob/master/content/pt-br/about/libraries-addons.md)_


### Add-Ons

- :raised_hands: [**preact-compat**](https://github.com/preactjs/preact-compat): use qualqer biblioteca React com Preact *([exemplo completo](https://github.com/developit/preact-compat-example))*
- :repeat: [**preact-cycle**](https://github.com/developit/preact-cycle): Paradigma funcional-reativo para Preact.
- :page_facing_up: [**preact-render-to-string**](https://github.com/preactjs/preact-render-to-string): Renderização universal.


### Componentes

- :earth_americas: [**preact-router**](https://github.com/preactjs/preact-router): Rotas de URL para seus componentes
- :bookmark_tabs: [**preact-markup**](https://github.com/developit/preact-markup): Renderize HTML & Elementos Customizados como JSX & Componentes
- :satellite: [**preact-portal**](https://github.com/developit/preact-portal): Renderize componentes Preact no (um) ESPAÇO :milky_way:
- :pencil: [**preact-richtextarea**](https://github.com/developit/preact-richtextarea): Componente de edição HTML simples
- :bookmark: [**preact-token-input**](https://github.com/developit/preact-token-input): Campo de texto que <i>tokeniza</i> a entrada, pra coisas como <i>tags</i>
- :card_index: [**preact-virtual-list**](https://github.com/developit/preact-virtual-list): Renderize facilmente listas com milhões de linhas ([demo](https://jsfiddle.net/developit/qqan9pdo/))
- :triangular_ruler: [**preact-layout**](https://download.github.io/preact-layout/): Biblioteca de layout simples e pequena.
- :construction_worker: [**preact-helmet**](https://github.com/download/preact-helmet): Um gerenciador de documento para Preact


### Integrações

- :thought_balloon: [**preact-socrates**](https://github.com/matthewmueller/preact-socrates): Plugin Preact para [Socrates](http://github.com/matthewmueller/socrates)
- :rowboat: [**preact-flyd**](https://github.com/xialvjun/preact-flyd): Use [flyd](https://github.com/paldepind/flyd) <i> FRP streams</i> em Preact + JSX
- :speech_balloon: [**preact-i18nline**](https://github.com/download/preact-i18nline): Integra o ecosistema do [i18n-js](https://github.com/everydayhero/i18n-js) com Preact via [i18nline](https://github.com/download/i18nline).


### Ferramentas para Interfaces Gráficas (GUI)

- :white_square_button: [**preact-mdl**](https://github.com/developit/preact-mdl): Use o [MDL](https://getmdl.io) como componentes Preact.
- :rocket: [**preact-photon**](https://github.com/developit/preact-photon): crie lindas UIs para aplicações desktop com [photon](http://photonkit.com)


### Testes

- :microscope: [**preact-jsx-chai**](https://github.com/developit/preact-jsx-chai): Testes de <i>Assertion</i> pra JSX  _(sem DOM, direto no Node)_


### Utilitários

- :tophat: [**preact-classless-component**](https://github.com/ld0rman/preact-classless-component): crie componentes Preact sem a _keyword_ `Class`
- :hammer: [**preact-hyperscript**](https://github.com/queckezz/preact-hyperscript): Sintaxe similar a Hyperscript para criação de elementos.
- :white_check_mark: [**shallow-compare**](https://github.com/tkh44/shallow-compare): _Helper_ simplificado para `shouldComponentUpdate`.
